/*
 *	HeNCE Tool
 *
 *	xgraph.c - X Window graph routines.
 *  XXX also junk that I needed...
 *
 *	Sep 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log: xgraph.c,v $
 * Revision 1.2  1992/09/14  19:07:16  moore
 * allow graph text font to be set with htool.graphFont resource.
 *
 * Revision 1.1  1992/04/08  05:50:56  moore
 * initial RCS version
 *
 *
 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include "xincl.h"
#include "xcomn.h"
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "graph.h"
#include "graphP.h"
#include "symtab.h"
#include "comn.h"
#include "xbm/compose_help"
#include "xbm/bl_ic"
#include "xbm/el_ic"
#include "xbm/bs_ic"
#include "xbm/es_ic"
#include "xbm/bp_ic"
#include "xbm/ep_ic"
#include "xbm/fo_ic"
#include "xbm/fi_ic"
#include "xbm/no_ic"
#include "xbm/no_ready_ic"
#include "xbm/no_run1_ic"
#include "xbm/no_run2_ic"
#include "xbm/no_done_ic"
#include "xbm/no_dead_ic"
#include "xbm/no_warn_ic"
#include "xbm/no_error_ic"
#include "xgraph.h"

#ifndef min
#define min(a,b) ((a)<(b)?(a):(b))
#endif
#ifndef max
#define max(a,b) ((a)>(b)?(a):(b))
#endif

Boolean click = True;

/* these define the arrowhead size and proximity to node */

#define	NODERADIUS 11	/* size of graph node circle */
#define	ARROWX	NODERADIUS/2
#define	ARROWY	(NODERADIUS/4)
#define	ARROWPROX (NODERADIUS*5/4)

#define MAXPICKNODEDIST (NODERADIUS*NODERADIUS*25)
#define MAXPICKARCDIST (NODERADIUS*NODERADIUS*25)

/* GCs that correspond to the node states (on a color screen, oc) */
/* XXX be sure these work out with the node states in graph.h */

#define	GCNOTREADY	ST_NOT_BEGUN
#define	GCREADY		ST_READY
#define	GCRUNNING	ST_RUNNING
#define	GCDONE		ST_DONE
#define	GCDEAD		ST_DEAD

#define	GCERROR		ST_ERROR
#define	GCWARNING	ST_WARNING

#define	GCINVERSE	7
#define	GCXOR		8
#define	GCCLEAR		9
#define	GCNORMAL	10

static Pixmap compose_help_pm = 0;
static Pixmap bp_pm = 0;
static Pixmap ep_pm = 0;
static Pixmap bl_pm = 0;
static Pixmap el_pm = 0;
static Pixmap bs_pm = 0;
static Pixmap es_pm = 0;
static Pixmap fo_pm = 0;
static Pixmap fi_pm = 0;
static Pixmap no_pm = 0;
static Pixmap no_ready_pm = 0;
static Pixmap no_run1_pm = 0;
static Pixmap no_run2_pm = 0;
static Pixmap no_done_pm = 0;
static Pixmap no_dead_pm = 0;
static Pixmap no_warn_pm = 0;
static Pixmap no_error_pm = 0;
static GC gcs[11];
static char crud[1024];

static struct icstuff {
	int wd, ht;
	Pixmap pmap;
} nodeics[] = {
	{ no_ic_width, no_ic_height, 0 },
	{ bs_ic_width, bs_ic_height, 0 },
	{ es_ic_width, es_ic_height, 0 },
	{ bl_ic_width, bl_ic_height, 0 },
	{ el_ic_width, el_ic_height, 0 },
	{ fo_ic_width, fo_ic_height, 0 },
	{ fi_ic_width, fi_ic_height, 0 },
	{ bp_ic_width, bp_ic_height, 0 },
	{ ep_ic_width, ep_ic_height, 0 }
};

/*	xgr_Init()
*
*	Must be called once at startup time
*	Creates pixmaps and GCs used for drawing graphs.
*/

void
xgr_Init()
{
	XGCValues xgcvalues;

	static struct foo {
		Font graphFont;
	} defaults ;

#define offset(field) XtOffsetOf (struct foo, field)

	static XtResource resourceSpecs [] = {
		{ "graphFont", XtCFont, XtRFont, sizeof(Font),
			  offset (graphFont), XtRString, XtDefaultFont },
	};

#undef offset

	if (bp_pm)
		return;

	XtGetApplicationResources (topLevel, &defaults, resourceSpecs,
							   XtNumber (resourceSpecs), NULL, 0);

	compose_help_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		compose_help_bits, compose_help_width, compose_help_height, 1, 0, 1);

	nodeics[0].pmap = no_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_ic_bits, no_ic_width, no_ic_height, 1, 0, 1);
	nodeics[1].pmap = bs_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		bs_ic_bits, bs_ic_width, bs_ic_height, 1, 0, 1);
	nodeics[2].pmap = es_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		es_ic_bits, es_ic_width, es_ic_height, 1, 0, 1);
	nodeics[3].pmap = bl_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		bl_ic_bits, bl_ic_width, bl_ic_height, 1, 0, 1);
	nodeics[4].pmap = el_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		el_ic_bits, el_ic_width, el_ic_height, 1, 0, 1);
	nodeics[5].pmap = fo_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		fo_ic_bits, fo_ic_width, fo_ic_height, 1, 0, 1);
	nodeics[6].pmap = fi_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		fi_ic_bits, fi_ic_width, fi_ic_height, 1, 0, 1);
	nodeics[7].pmap = bp_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		bp_ic_bits, bp_ic_width, bp_ic_height, 1, 0, 1);
	nodeics[8].pmap = ep_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		ep_ic_bits, ep_ic_width, ep_ic_height, 1, 0, 1);
	no_ready_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_ready_ic_bits, no_ready_ic_width, no_ready_ic_height, 1, 0, 1);
	no_run1_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_run1_ic_bits, no_run1_ic_width, no_run1_ic_height, 1, 0, 1);
	no_run2_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_run2_ic_bits, no_run2_ic_width, no_run2_ic_height, 1, 0, 1);
	no_done_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_done_ic_bits, no_done_ic_width, no_done_ic_height, 1, 0, 1);
	no_dead_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_dead_ic_bits, no_dead_ic_width, no_dead_ic_height, 1, 0, 1);
	no_warn_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_warn_ic_bits, no_warn_ic_width, no_warn_ic_height, 1, 0, 1);
	no_error_pm = XCreatePixmapFromBitmapData(xDisp, xRootW,
		no_error_ic_bits, no_error_ic_width, no_error_ic_height, 1, 0, 1);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLFGND];
	gcs[GCNORMAL] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.foreground = (Pixel)mycolor[COLBGND];
	xgcvalues.background = (Pixel)mycolor[COLFGND];
	gcs[GCINVERSE] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXxor;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.foreground = (Pixel)mycolor[COLBGND] ^ (Pixel)mycolor[COLFGND];
	xgcvalues.background = 0;
	gcs[GCXOR] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.foreground = (Pixel)mycolor[COLBGND];
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	gcs[GCCLEAR] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

/*
	if (inColor) {
*/
	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLNOTREADY];
	gcs[GCNOTREADY] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLERROR];
	gcs[GCERROR] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLWARNING];
	gcs[GCWARNING] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLSTARTED];
	gcs[GCREADY] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLEXECUTING];
	gcs[GCRUNNING] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLCOMPLETED];
	gcs[GCDONE] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

	xgcvalues.function = GXcopy;
	xgcvalues.font = defaults.graphFont;
	xgcvalues.background = (Pixel)mycolor[COLBGND];
	xgcvalues.foreground = (Pixel)mycolor[COLEXIT];
	gcs[GCDEAD] =
		XCreateGC(xDisp, xRootW,
				  GCFunction|GCFont|GCForeground|GCBackground, &xgcvalues);

/*
	}
*/
}

/*	xgr_DrawGrf()
 *
 *	Redraw all nodes and arcs in a graph
 */

void
xgr_DrawGrf(win, g, tracemode)
Window win;
Graph g;
int tracemode;
{
	Tree ntree = g->nlist;
	Tree atree;
	TreeNode tn, atn;
	Node n1, n2;

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		xgr_DrawNode(win, (Node)rb_Value(tn), tracemode ? -1 : 1);
	}
	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n1 = (Node)rb_Value(tn);
		atree = n1->children;
		for (atn = rb_First(atree); atn != atree; atn = rb_Next(atn)) {
			n2 = (Node)rb_Value(atn);
			xgr_DrawArc(win, n1, n2, 1);
		}
	}
#if 0
/* XXX for debugging pair-finding */
for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
	n1 = (Node)rb_Value(tn);
	if (n2 = n1->pair) {
		if (n1->xy.set && n2->xy.set)
			XDrawLine(xDisp, win, gcs[GCNORMAL],
				n1->xy.x + 10, n1->xy.y, n2->xy.x, n2->xy.y);
	}
}
#endif

}

/*	xgr_DrawNode()
 *
 *	Draw a node icon in a window.  abs(how) is
 *		0 to erase
 *		1 to draw
 *		2 to draw via xor
 *
 * If how is negative, it means to print trace info.
 */

void
xgr_DrawNode(win, node, how)
	Window win;
	Node node;
	int how;
{
	int x = node->xy.x;
	int y = node->xy.y;
	int t = node->node_type;
	GC tgc;
	GC bgc;
	Pixmap npm;
	int tracing = 0;

	if (how < 0) {
		how = -how;
		tracing = 1;
	}

	if (how != 2) {
		if (how) {
			tgc = gcs[GCNORMAL];
			if (inColor)
				bgc = gcs[node->state];
			else
				bgc = gcs[GCNORMAL];	/* XXX todo b&w */

		} else {
			tgc = gcs[GCCLEAR];
			bgc = gcs[GCCLEAR];
		}

		if (t != NODE_NORMAL)
			npm = nodeics[t].pmap;
		else {
			switch (node->state) {
			case ST_READY:
				npm = no_ready_pm;
				break;
			case ST_RUNNING:
			    if (click)
					npm = no_run1_pm;
				else
					npm = no_run2_pm;
				click = !click;
				break;
			case ST_DONE:
				npm = no_done_pm;
				break;
			case ST_DEAD:
				npm = no_dead_pm;
				break;
			case ST_WARNING:
				npm = no_warn_pm;
				break;
			case ST_ERROR:
				npm = no_error_pm;
				break;
			default:
				bgc = gcs[GCNOTREADY];
				npm = no_pm;
				break;
			}
		}
		xdraw_Bitmap (win, npm, bgc, nodeics[t].wd, nodeics[t].ht, x, y);

		if (node->nk.id >= 0) {
			if (tracing) {
				if (node->nk.inst)
					(void)sprintf(crud, "%s%s%s%d/%d",
								  node->sub_name ? "(" : "",
								  node->sub_name ? node->sub_name : "",
								  node->sub_name ? ") " : "",
								  node->nk.id, node->nk.inst);
				else
					(void)sprintf(crud, "%s%s%s%d",
								  node->sub_name ? "(" : "",
								  node->sub_name ? node->sub_name : "",
								  node->sub_name ? ") " : "",
								  node->nk.id);

				xdraw_Text (win, tgc,
							x - NODERADIUS - 4 - xdraw_StringWidth (tgc, crud),
							y + xdraw_TextHeight (tgc) / 2, crud);
				if (node->node_type == NODE_NORMAL) {
					sprintf (crud, "%dr,%di  ", node->numRunning,
							 node->numIdle);
					xdraw_Text (win, tgc, x + NODERADIUS + 4,
								y + xdraw_TextHeight (tgc) / 2, crud);
				}
			}
			else {
				if (node->nk.inst)
					(void)sprintf(crud, "%d/%d", node->nk.id, node->nk.inst);
				else
					(void)sprintf(crud, "%d", node->nk.id);

				xdraw_Text (win, tgc,
							x - NODERADIUS - 4 - xdraw_StringWidth (tgc, crud),
							y +  xdraw_TextHeight (tgc) / 2, crud);
				if (node->node_type == NODE_NORMAL) {
					if (node->sub_name) {
						xdraw_Text (win, tgc, x + NODERADIUS + 4,
									y + xdraw_TextHeight (tgc) / 2,
									node->sub_name);
					}
				}
			}
		}
	} else {	/* rubber drawing */
		xdraw_Bitmap (win, nodeics[t].pmap, gcs[GCXOR],
			nodeics[t].wd, nodeics[t].ht, x, y);
	}
}

/*	xgr_DrawArc()
*
*	Draw arc between nodes in window.  How is
*		0 to erase
*		1 to draw
*		2 to draw via xor
*/

void
xgr_DrawArc(win, n1, n2, how)
	Window win;
	Node n1, n2;
	int how;
{
	int ax, ay;
	double v, vx, vy;
	int x1, y1, x2, y2;
	GC gc;

	if (how == 2)
		gc = gcs[GCXOR];
	else
		gc = gcs[how ? GCNORMAL : GCCLEAR];
		
	ax = n2->xy.x - n1->xy.x;
	ay = n2->xy.y - n1->xy.y;
	if (!ax && !ay)		/* sanity check */
		return;
	v = sqrt((double)(ax * ax + ay * ay));
	vx = ax / v;
	vy = ay / v;
	x1 = n1->xy.x + ARROWPROX * vx;
	y1 = n1->xy.y + ARROWPROX * vy;
	x2 = n2->xy.x - ARROWPROX * vx;
	y2 = n2->xy.y - ARROWPROX * vy;
	XDrawLine(xDisp, win, gc, x1, y1, x2, y2);

	x1 = x2 - ARROWX * vx + ARROWY * vy;
	y1 = y2 - ARROWY * vx - ARROWX * vy;
	XDrawLine(xDisp, win, gc, x1, y1, x2, y2);

	x1 = x2 - ARROWX * vx - ARROWY * vy;
	y1 = y2 + ARROWY * vx - ARROWX * vy;
	XDrawLine(xDisp, win, gc, x1, y1, x2, y2);
}

/*	xgr_NearestNode()
*
*	Return pointer to node nearest a point.
*/

Node
xgr_NearestNode(grf, x, y)
	Graph grf;
	int x, y;
{
	Tree ntree = grf->nlist;
	TreeNode tn;
	Node n, nn = 0;
	int nd = -1, dx, dy, dd;

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n = (Node)rb_Value(tn);
		dx = n->xy.x - x;
		dy = n->xy.y - y;
		dd = dx * dx + dy * dy;
		if (dd < MAXPICKNODEDIST && (nd < 0 || dd < nd)) {
			nd = dd;
			nn = n;
		}
	}
	return nn;
}

/*	xgr_NearestArc()
*
*	Return the nodes at the ends of the nearest arc to a point,
*	endpoint which is closest first.
*/

void
xgr_NearestArc(grf, x, y, n1p, n2p)
	Graph grf;
	int x, y;
	Node *n1p, *n2p;
{
	Tree ntree = grf->nlist;
	Tree atree;
	TreeNode tn, atn;
	Node n1, n2;				/* gp */
	int ax, ay;					/* delta */
	int d1, d2;					/* dist to endpoints */
	double v, vx, vy;			/* gp */
	int x1, y1, x2, y2;			/* arc bbx */
	int md = -1;				/* min dist found any arc */
	int mda;					/* min dist this arc */
	Node nna1 = 0, nna2 = 0;	/* nodes of nearest arc */

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n1 = (Node)rb_Value(tn);
		atree = n1->children;
		for (atn = rb_First(atree); atn != atree; atn = rb_Next(atn)) {
			n2 = (Node)rb_Value(atn);

	/* compute endpoints of arc */

			ax = n2->xy.x - n1->xy.x;
			ay = n2->xy.y - n1->xy.y;
			if (!ax && !ay)		/* sanity check */
				continue;
			v = sqrt((double)(ax * ax + ay * ay));
			vx = ax / v;
			vy = ay / v;
			x1 = n1->xy.x + ARROWPROX * vx;
			y1 = n1->xy.y + ARROWPROX * vy;
			x2 = n2->xy.x - ARROWPROX * vx;
			y2 = n2->xy.y - ARROWPROX * vy;

	/* get dist to epts */
			ax = x - x1;
			ay = y - y1;
			d1 = ax * ax + ay * ay;
			ax = x - x2;
			ay = y - y2;
			d2 = ax * ax + ay * ay;

	/* get nearest pt on line */

			ax = x2 - x1;
			ay = y2 - y1;
			v = (double)(ax * (x - x1) + ay * (y - y1)) / (ax * ax + ay * ay);
			ax = x1 + ax * v;
			ay = y1 + ay * v;

			if (ax < min(x1, x2) || ax > max(x1, x2)
			|| ay < min(y1, y2) || ay > max(y1, y2)) {	/* not in seg */
				mda = min(d1, d2);
			} else {	/* in ray segment */
				ax -= x;
				ay -= y;
				mda = ax * ax + ay * ay;
			}

	/* compare distance to old closest arc */

			if (mda < MAXPICKARCDIST && (md == -1 || mda < md)) {
				md = mda;
				if (d1 < d2) {
					nna1 = n1;
					nna2 = n2;
				} else {
					nna1 = n2;
					nna2 = n1;
				}
			}
		}
	}
	*n1p = nna1;
	*n2p = nna2;
/*
	fprintf(stderr, "(%d-%d)\n", nna1->nk.id, nna2->nk.id);
*/
}

/*	xgr_PlaceNodes()
*
*	Start at level 0. All nodes are initially at level 0. All
*	nodes set the level of their parents to current level + 1.
*	Since no leaf node has children, its level is not incremented.
*	All other nodes have their levels set to 1 because they
*	have children.
*
*	Now go to level 1. All nodes at that level set the
*	level of their parents. Thus, nodes that have only leaf nodes
*	as children do not have their levels set to 2, and of course,
*	all others do.  Continue as such until only the root
*	node is left.
*/

void
xgr_PlaceNodes(g, wd, ht)
	Graph g;
	int wd, ht;
{
	Tree ntree = g->nlist;
	Tree atree;
	TreeNode tn, atn;
	Node n1, n2;
	int j, k, n;
	int lev = 0;
	int done = 0;

	/* start all nodes at level zero */

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n1 = (Node)rb_Value(tn);
		n1->xy.y = 0;
	}

	/* increment by levels until root node is on a level by itself */

	for (lev = 0; !done; lev++) {
		done = 1;
		for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
			n1 = (Node)rb_Value(tn);
			if (n1->xy.y != lev)
				continue;
			atree = n1->children;
			for (atn = rb_First(atree); atn != atree; atn = rb_Next(atn)) {
				n2 = (Node)rb_Value(atn);
				n2->xy.y = lev + 1;
				done = 0;
			}
		}
	}

	/* set x coords */

	for (j = 0; j < lev; j++) {
		n = 0;
		for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
			n1 = (Node)rb_Value(tn);
			if (n1->xy.y == j)
				n++;
		}
		if (!n)
			continue;
		k = 1;
		for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
			n1 = (Node)rb_Value(tn);
			if (n1->xy.y == j) {
				n1->xy.x = (wd * k) / (n + 1);
/*
				n1->xy.x = (wd * k) / (n + 1) + (j & 1 ? -10 : 10);
*/
				k++;
			}
		}
	}

	/* set y coords */

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n1 = (Node)rb_Value(tn);
		n1->xy.y = (ht * (lev - n1->xy.y)) / (lev + 1);
		n1->xy.set = 1;
	}

}

/*	xgr_GetSubNames()
*
*	Return a symbol table containing a list of the function names
*	used in the graph, exactly once each.
*/

Tree
xgr_GetSubNames(g)
	Graph g;
{
	Tree ntree = g->nlist;
	Tree st = st_New();
	TreeNode tn;
	Node n;

	for (tn = rb_First(ntree); tn != ntree; tn = rb_Next(tn)) {
		n = (Node)rb_Value(tn);
		if (n->node_type == NODE_NORMAL && n->sub_name && *n->sub_name)
			st_Insert(st, n->sub_name);
	}
	return st;
}

/*
 *	xgr_drawLegend()
 */

void
xgr_DrawLegend (w)
Window w;
{
	static Node n = 0;
	int tx = NODERADIUS * 6;

	if (!n)
		n = gr_NewNode(-1);

	n->xy.x = NODERADIUS*4;
	n->xy.y = NODERADIUS*2;
	n->node_type = NODE_NORMAL;
	n->state = ST_NOT_BEGUN;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Not Ready");

	n->xy.y += NODERADIUS*3;
	n->state = ST_READY;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Node Started");

	n->xy.y += NODERADIUS*3;
	n->state = ST_RUNNING;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Function Executing");

	n->xy.y += NODERADIUS*3;
	n->state = ST_DONE;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Function Completed");

#if 0
    XDrawLine(xDisp, w, gcs[GCNORMAL],
		0, n->xy.y + (int)(NODERADIUS * 1.5), 400, 
		n->xy.y + (int)(NODERADIUS * 1.5));
#endif

	n->xy.y += NODERADIUS*3;
	n->state = ST_DEAD;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Node Exited");

#if 1
	XDrawLine(xDisp, w, gcs[GCNORMAL],
			  0, n->xy.y + (int)(NODERADIUS * 1.5), 400, 
			  n->xy.y + (int)(NODERADIUS * 1.5));
#endif

	n->xy.y += NODERADIUS*3;
	n->state = ST_WARNING;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Warning in Graph Program");

	n->xy.y += NODERADIUS*3;
	n->state = ST_ERROR;
	xgr_DrawNode(w, n, 1);
	xdraw_Text (w, gcs[GCNORMAL], tx, n->xy.y, "Error in Graph Program");
}

/*
 *  xgr_drawComposeHelp()
 */

void
xgr_drawComposeHelp (w)
Window w;
{
    XCopyPlane(xDisp, compose_help_pm, w, gcs[GCNORMAL],
        0,0, compose_help_width, compose_help_height, 0,0, 1);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
