/*
 *	HeNCE Tool
 *
 *	xdrawing.c - Useful stuff for drawing with X.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log: xdraw.c,v $
 * Revision 1.1  1992/04/08  05:50:53  moore
 * initial RCS version
 *
 *
 */

#include <stdio.h>
#include "xincl.h"
#include "xcomn.h"
#include "comn.h"
#include "hostmap.h"
#include "xdraw.h"

void
xdraw_Text (wn, gc, x, y, s)
	Window wn;
	GC gc;
	int x, y;
	char *s;
{
#if 0
	XDrawString(xDisp, wn, gc, x, y, s, strlen(s));
#else
	XDrawImageString(xDisp, wn, gc, x, y, s, strlen(s));
#endif
}

void
xdraw_Bitmap (w, pm, gc, wd, ht, x, y)
	Window w;
	Pixmap pm;
	GC gc;
	int wd, ht;
	int x, y;
{
	XCopyPlane(xDisp, pm, w, gc,
		0, 0, wd, ht, x - wd / 2, y - ht / 2, 1);
}

int
xdraw_StringWidth (gc, s)
	GC gc;
	char *s;
{
	static XFontStruct *font_info = 0;
	int wd;

	if (!font_info)
		font_info = XQueryFont(xDisp, XGContextFromGC(gc));
	wd = XTextWidth(font_info, s, strlen(s));
	return wd;
}

int
xdraw_TextHeight (gc)
	GC gc;
{
	XFontStruct *font_info;
	static int ht = -1;

	if (ht == -1) {
		font_info = XQueryFont(xDisp, XGContextFromGC(gc));
		ht = font_info->ascent + font_info->descent;
		XFreeFontInfo(NULL, font_info, 0);
	}
	return ht;
}

void
xdraw_Line (win, gc, x1, y1, x2, y2)
Window win;
int x1, y1;
int x2, y2;
GC gc;
{
	XDrawLine (xDisp, win, gc, x1, y1, x2, y2);
}

/*	xdraw_Icon ()
 *
 *	Blat a pixmap onto the the screen
 */

void
xdraw_Icon (win, gc, icon, xpos, ypos)
Window win;
struct icon *icon;
int xpos, ypos;
GC gc;
{
	XCopyPlane(xDisp, icon->bits, win, gc, 0, 0,
			   icon->width, icon->height, xpos, ypos, 1);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
