/*

 to do:

 * add types to expression nodes
 * add code to build just a node stub instead of a whole program
 * nodelists should build lists of int's, not Node's
 * change tab stops to 4 for C code only
 * free tree on parse error

 */

%{
#include <stdio.h>
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "graph.h"
#include "misc.h"		/* change this file name! */
#include "parse.h"
#include "msg.h"

#ifdef __
#undef __
#endif
#ifdef __STDC__
#define __(X) X
#else
#define __(X) ()
#endif

typedef struct node_list *NodeList;

NodeList nodelist_AddNode __((NodeList nl, int id));
NodeList nodelist_New ();
void nodelist_FreeNode __((NodeList nl));

/* types of parameters - read/only or read/write */

#define PARAM_RO	'<'
#define PARAM_RW	'B'

/*
 * All global variables start with "yy" so we can filter the y.tab.c
 * file through sed to produce unique variable names.  In that way we
 * can incorporate more than one yacc parser in a program.
 *
 * XXX not sure why it matters if they are declared "static"...
 */

static void *yy_compiled_program; /* used to pass the compiled program or
									 node back to the caller */

static Node yy_current_node;	/* productions under node_program use
								   this variable to locate the current
								   node structure */

static enum { program, node } yy_parse_target;

static char *currentString;

int parseErrorCount;
%}

%start prog_or_stub

%union {
	long integer;
	Expr expr;
	Node node;
	char *id;
	Param param;
	double floatnum;
	char *string;
	struct param_array *array_params;
	NodeList nodelist;
	Graph graph;
}

/*
 * type <void> prog_or_stub real_node_decl loop_expr
 */
%type <array_params> dim_list
%type <expr> arg const dim expr
%type <floatnum> fconst
%type <graph> decl_list prog
%type <id> id
%type <integer> end_node from_element iconst in_or_io opt_new
%type <integer> opt_type other_node to_element type
%type <node> node_decl
%type <nodelist> from_list to_list
%type <param> input_decl loop_incr loop_set output_decl var
%type <string> sconst
/* %type <void> arg_list input_decl_list loop_expr node_id_loc node_program */
/* %type <void> output_decl_list prog_or_stub real_node_decl sub_args */
/* %type <void> sub_call sub_n_output */

%token TK_int TK_float TK_id TK_string TK_TYPENAME 
%token TK_NODE TK_ARC TK_IO
%token TK_LSHIFT TK_RSHIFT
%token TK_ENDCOND TK_COND TK_ENDLOOP TK_LOOP TK_ENDPIPE TK_PIPE
%token TK_FANOUT TK_FANIN TK_NEW
%token TK_PROGRAM TK_TO
%token TK_UNDEFINED

%right '?' ':'
%left TK_OR
%left TK_AND
%left '|'
%left '^'
%left '&'
%left TK_NE TK_EQ
%left TK_LE TK_GE '<' '>'
%left TK_LSHIFT TK_RSHIFT
%left '+' '-'
%left '*' '/' '%'
%right UNARY

%%

/* void */
prog_or_stub:	prog {
					if (yy_parse_target == program)
						yy_compiled_program = (void *) $1;
					else
						yy_compiled_program = (void *) NULL;
			    }
			|	node_decl {
					if (yy_parse_target == node)
						yy_compiled_program = (void *) $1;
					else
						yy_compiled_program = (void *) NULL;
				}
			;


/* graph */
prog		:	TK_PROGRAM decl_list {
					$$ = $2;
				}
			;

/* graph */
decl_list	:	node_decl {
					$$ = gr_New ();
					if ($1 != (Node) NULL)
						gr_AddNode ($$, $1);
				}
			|	decl_list node_decl {
					$$ = $1;
					if ($2 != (Node) NULL)
						gr_AddNode ($$, $2);
				}
			|	decl_list TK_ARC from_list to_list {
					NodeList p, q, tmp;
					$$ = $1;
					for (p = $3; p != (NodeList) NULL; ) {
						for (q = $4; q != (NodeList) NULL; ) {
							gr_BuildArc ($$, p->node_id, q->node_id);
							tmp = q->next;
							nodelist_FreeNode (q);
							q = tmp;
						}
						tmp = p->next;
						nodelist_FreeNode (p);
						p = tmp;
					}
				}
			;

/* nodelist */
from_list	:	from_element {
					$$ = nodelist_AddNode (nodelist_New (), $1);
				}
			|	from_list ',' from_element {
					$$ = nodelist_AddNode ($1, $3);
				}
			;

/* integer */
from_element:	iconst {
					$$ = $1;
				}
			;

/* nodelist */
to_list		:	to_element {
					$$ = nodelist_AddNode (nodelist_New (), $1);
				}
			|	to_list ',' to_element {
					$$ = nodelist_AddNode ($1, $3);
				}
			;

/* integer */
to_element	:	iconst	 {
					$$ = $1; 
				}
			;

/* node */
node_decl	:	real_node_decl {
					$$ = yy_current_node;
					yy_current_node = (Node) NULL;
				}
			|	undefined_node_decl {
					$$ = yy_current_node;
					yy_current_node = (Node) NULL;
				}
			;

/* void */
undefined_node_decl: TK_NODE node_id_loc TK_UNDEFINED ';' {
					yy_current_node->node_type = NODE_NORMAL;
				}
			|	TK_COND node_id_loc TK_UNDEFINED ';' {
					yy_current_node->node_type = NODE_COND;
				}
			|	other_node node_id_loc TK_UNDEFINED ';' {
					yy_current_node->node_type = $1;
				}
			|	TK_LOOP node_id_loc TK_UNDEFINED ';' {
					yy_current_node->node_type = NODE_LOOP;
				}
			;

/* void */
real_node_decl: TK_NODE node_id_loc node_program {
					yy_current_node->node_type = NODE_NORMAL;
				}
			|	end_node node_id_loc ';' {
					yy_current_node->node_type = $1;
				}
			|	TK_COND node_id_loc '(' expr ')' ';' {
					yy_current_node->node_type = NODE_COND;
					gr_ResizeNodeArgs (yy_current_node, 1);
					yy_current_node->args[0] = $4;
				}
			|	other_node node_id_loc var '=' expr TK_TO expr ';' {
					if ($3->type == TYPE_INHERITED)
						$3->type = TYPE_INT;
					yy_current_node->node_type = $1;
					gr_ResizeNodeArgs (yy_current_node, 2);
					yy_current_node->args[0] = $5;		/* expr 1 */
					yy_current_node->args[1] = $7;		/* expr 2 */
					yy_current_node->ret_param = $3;	/* var */
					yy_current_node->ret_param->io.new = 1;
					yy_current_node->ret_param->io.out = 1;
					/* XXX set_param_specs ('>', 0, 1); */
				}
			|	TK_LOOP node_id_loc loop_expr ';' {
					yy_current_node->node_type = NODE_LOOP;
					/*
                     * it appears that the current HeNCE executioner
                     * always treats loop parameters as integers
                     */
					yy_current_node->ret_param->type = TYPE_INT;
				}
			;


/* integer */
end_node	:	TK_ENDCOND	{ $$ = NODE_ENDCOND; }
			|	TK_ENDLOOP	{ $$ = NODE_ENDLOOP; }
			|	TK_ENDPIPE	{ $$ = NODE_ENDPIPE; }
			|	TK_FANIN	{ $$ = NODE_FANIN; }
			;

/* integer */
other_node	:	TK_FANOUT	{ $$ = NODE_FANOUT; }
			|	TK_PIPE		{ $$ = NODE_PIPE; }
			;


/* void */
loop_expr	:	/* empty prefix */ {
					gr_ResizeNodeArgs (yy_current_node, 3);
				} '(' loop_set ';' expr ';' loop_incr ')' {
					/*
					 * action rules for loop_set and loop_incr
					 * return a Param that should be the control
					 * variable for the loop.  Check to make
					 * sure they are in agreement.
					 *
					 * XXX the executoner requires that all references
					 * to a datum point to the same Param structure.
					 * This parser does not ensure this.
					 */

					yy_current_node->ret_param = (Param) NULL;
					if ($3 == $7 || (
							($3->type == $7->type) &&
							($3->type != TYPE_ARRAY) &&
							($3->name != NULL) && ($7->name != NULL) &&
							(strcmp ($3->name, $7->name) == 0)))
						yy_current_node->ret_param = $3;
					else
						parse_Error ("loop control params don't match");

					/*
					 * now build the resulting expression
					 */
					yy_current_node->args[1] = $5;
				}
			;

/* param */
loop_set	:	var '=' expr {
					$$ = $1;
					yy_current_node->args[0] = $3;

					if ($$->type == TYPE_ARRAY) {
					    parse_Error ("loop control param must be a scalar");
						$$ = NULL;
						/* XXX free children */
					}
				}
			|	/* empty */ {
					$$ = (Param) NULL;
					yy_current_node->args[0] = (Expr) NULL;
				}
			;

/* param */
loop_incr	:	var '=' expr {
					$$ = $1;
					yy_current_node->args[2] = $3;

					if ($$->type == TYPE_ARRAY) {
					    parse_Error ("loop control param must be a scalar");
						$$ = NULL;
						/* XXX free children */
					}
				}
			|	/* empty */ {
				$$ = (Param) NULL;
				yy_current_node->args[2] = (Expr) NULL;
				}
			;

/* void */
node_id_loc	:	iconst {
					yy_current_node = gr_NewNode ($1);
				}
			|	'[' iconst iconst ']' iconst {
				yy_current_node = gr_NewNode ($5);
				gr_SetNodeLoc (yy_current_node, $2, $3);
				}
			;

/* void */
node_program:	input_decl_list {
				}
			|	input_decl_list sub_n_output {
				}
			|	sub_n_output {
				}
			;

/* void */
input_decl_list: input_decl {
					gr_AddNodeParam (yy_current_node, $1);
				}
			|	input_decl_list input_decl {
					gr_AddNodeParam (yy_current_node, $2);
				}
			;

/* void */
sub_n_output:	sub_call ';' {
				}
			|	sub_call ';' output_decl_list {
				}
			;

/* void */
sub_call	:	id sub_args {
					yy_current_node->sub_name = $1;
				}
			|	var '=' id sub_args {
					yy_current_node->sub_name = $3;
					yy_current_node->ret_param = $1;
				}
			;

/* void */
sub_args	:	'(' ')'
			|	'(' arg_list ')'
			;

/* void */
arg_list	:	arg
			|	arg_list ',' arg
			;

/* expr */
arg 		:	expr {
					gr_AddNodeArg (yy_current_node, $1);
				}
			;


/* void */
output_decl_list: output_decl {
					gr_AddNodeParam (yy_current_node, $1);
				}
			|	output_decl_list output_decl {
					gr_AddNodeParam (yy_current_node, $2);
				}
			;

/* param */
input_decl	:	opt_new in_or_io opt_type var ';' {
					$$ = $4;
					$$->io.new = $1;
					$$->io.in = 1;
					if ($2 == PARAM_RW)
						$$->io.out = 1;
					if ($$->type == TYPE_ARRAY)
						$$->a->type = $3;
					else
						$$->type = $3;
					if ($1 && ($3 == TYPE_INHERITED))
						parse_Error ("NEW parameter must have a specified type");
					
				}
			|	opt_new in_or_io opt_type var '=' expr ';' {
					$$ = $4;
					$$->io.new = $1;
					$$->io.in = 1;
					if ($2 == PARAM_RW)
						$$->io.out = 1;
					if ($$->type == TYPE_ARRAY)
						$$->a->type = $3;
					else
						$$->type = $3;
					$$->val = $6;
					if ($1 && ($3 == TYPE_INHERITED))
						parse_Error ("NEW parameter must have a specified type");
				}
			;

/* integer */
opt_new		:	TK_NEW		{ $$ = 1; }
			|	/* empty */ { $$ = 0; }
			;

/* integer */
opt_type	:	type		{ $$ = $1; }
			|	/* empty */ { $$ = TYPE_INHERITED; }
			;

/* integer */
in_or_io	:	'<'		{ $$ = PARAM_RO; }
			|	TK_IO	{ $$ = PARAM_RW; }
			;

/* param */
output_decl	:	opt_new '>' type var ';' {
					$$ = $4;
					$$->io.out = 1;
					$$->io.new = $1;	/* 1 iff NEW keyword used */
					if ($$->type == TYPE_ARRAY)
						$$->a->type = $3;
					else
						$$->type = $3;
				}
			;

/* integer */
type		:	TK_TYPENAME {
					if (strcmp (yytext, "int") == 0)
						$$ = TYPE_INT;
					else if (strcmp (yytext, "float") == 0)
						$$ = TYPE_FLOAT;
					else if (strcmp (yytext, "double") == 0)
						$$ = TYPE_DOUBLE;
					else if (strcmp (yytext, "char") == 0)
						$$ = TYPE_CHAR;
					else if (strcmp (yytext, "INT") == 0)
						$$ = TYPE_INT;
					else if (strcmp (yytext, "FLOAT") == 0)
						$$ = TYPE_FLOAT;
					else if (strcmp (yytext, "DOUBLE") == 0)
						$$ = TYPE_DOUBLE;
					else if (strcmp (yytext, "CHAR") == 0)
						$$ = TYPE_CHAR;
				}
			;


/* expr */
expr		:	expr '?' expr ':' expr	{
					$$ = expr_TernaryOp (OP_COND_EXPR, $1, $3, $5);
				}
			|	expr TK_OR expr		{
					$$ = expr_BinaryOp (OP_LOGICAL_OR, $1, $3);
				}
			|	expr TK_AND expr	{
					$$ = expr_BinaryOp (OP_LOGICAL_AND, $1, $3);
				}
			|	expr '|' expr		{
					$$ = expr_BinaryOp (OP_BIT_OR, $1, $3);
				}
			|	expr '^' expr		{
					$$ = expr_BinaryOp (OP_BIT_XOR, $1, $3);
				}
			|	expr '&' expr		{
					$$ = expr_BinaryOp (OP_BIT_AND, $1, $3);
				}
			|	expr TK_NE expr		{
					$$ = expr_BinaryOp (OP_COMP_NE, $1, $3);
				}
			|	expr TK_EQ expr		{
					$$ = expr_BinaryOp (OP_COMP_EQ, $1, $3);
				}
			|	expr TK_LE expr		{
					$$ = expr_BinaryOp (OP_COMP_LE, $1, $3);
				}
			|	expr TK_GE expr		{
					$$ = expr_BinaryOp (OP_COMP_GE, $1, $3);
				}
			|	expr '>' expr		{
					$$ = expr_BinaryOp (OP_COMP_GT, $1, $3);
				}
			|	expr '<' expr		{
					$$ = expr_BinaryOp (OP_COMP_LT, $1, $3);
				}
			|	expr TK_LSHIFT expr {
					$$ = expr_BinaryOp (OP_LSHIFT, $1, $3);
				}
			|	expr TK_RSHIFT expr {
					$$ = expr_BinaryOp (OP_RSHIFT, $1, $3);
				}
			|	expr '*' expr		{
					$$ = expr_BinaryOp (OP_MULT, $1, $3);
				}
			|	expr '/' expr		{
					$$ = expr_BinaryOp (OP_DIV, $1, $3);
				}
			|	expr '%' expr		{
					$$ = expr_BinaryOp (OP_MOD, $1, $3);
				}
			|	expr '-' expr		{
					$$ = expr_BinaryOp (OP_SUBTRACT, $1, $3);
				}
			|	expr '+' expr		{
					$$ = expr_BinaryOp (OP_ADD, $1, $3);
				}
			|	'-' expr %prec UNARY	{
					$$ = expr_UnaryOp (OP_NEG, $2);
				}
			|	'*' expr %prec UNARY	{
					$$ = expr_UnaryOp (OP_INDIR, $2);
				}
			|	'!' expr %prec UNARY	{
					$$ = expr_UnaryOp (OP_LOGICAL_CMPL, $2);
				}
			|	'~' expr %prec UNARY	{
					$$ = expr_UnaryOp (OP_BIT_CMPL, $2);
				}
			|	'&' expr %prec UNARY	{
					$$ = expr_UnaryOp (OP_ADDRESS, $2);
				}
			|	'(' expr ')' {
					 $$ = $2; 
				}
			|	const { 
					$$ = $1; 
				}
			|	var {
					/* 
					 * XXX should this be "rvalue"?
					 * i.e. should we be sure to mark this as
					 * a readable param?
					 */
					$$ = expr_Param ($1);
				}
			;


/* expr */
const		:	iconst {
					$$ = expr_Const (TYPE_INT, &($1));
				}
			|	fconst {
					/* XXX distinguish between FLOAT and DOUBLE consts? */
					$$ = expr_Const (TYPE_DOUBLE, &($1));
				}
			|	sconst {
					$$ = expr_Const (TYPE_STRING, $1);
				}
			;

/* integer */
iconst		:	TK_int { 
					$$ = atoi (yytext);
				}
			;

/* floatnum */
fconst		:	TK_float { 
					double atof ();

					$$ = atof (yytext);
				}
			;

/* string */
sconst		:	TK_string {
					/*
					 * the storage has already been malloced from
					 * within the lexer.
					 */
					$$ = currentString;
					fprintf (stderr, "string='%s'\n", $$);
				}
			;

/* param */
var			:	id {
					$$ = param_New ((char *) NULL);
					$$->name = $1; /* name, in malloc'ed space */
					$$->type = TYPE_INHERITED;
				}
			|	id dim_list {
					$$ = param_New ((char *) NULL);
					$$->type = TYPE_ARRAY;
					$$->name = $1; /* name, in malloc'ed space */
					$$->a = $2;	 /* array dimensions */
				}
			;

/* id */
id			:	TK_id {
					$$ = strsave (yytext);
				}
			;

/* array_params */
dim_list	:	dim {
					$$ = param_NewArrayParams ();
					$$->ndims = 0;
					param_AddArrayDim ($$, $1);
					/* $$->dims[$$->ndims++] = $1; */
				}
			|	dim_list dim {
					$$ = $1;
					param_AddArrayDim ($$, $2);
					/* $$->dims[$$->ndims++] = $2; */
				}
			;

/* expr */
dim 		:	'[' ']' {
					/*
					 * XXX write a special function for exp.c
					 * and get rid of this call to expr_New()
					 */
					$$ = expr_New (TYPE_UNSPECIFIED, OP_EMPTY_DIM);
				}
			|	'[' expr ']' {
					$$ = expr_UnaryOp (OP_DIM, $2);
				}
			|	'[' expr ':' expr ']' {
					$$ = expr_BinaryOp (OP_ARR_SECTION, $2, $4);
				}
			;

%%
static int yyerror ();
static int yywrap ();

/*
 * These globals are pointers to functions to get a character
 * of input and to write one to the error output
 */
static int (*yy_getc) __((void *));
static char *yy_input_filename;
static void *yy_getc_arg;

#include "parse.lex.out"
/*
 * flex defines a fake yywrap function, which we undef so we can
 * define our own.
 */
#ifdef yywrap
#undef yywrap
#endif

/*
 * Simple linked list used to keep track of node lists in ARC statements
 */

struct node_list {
	struct node_list *next;
	int node_id;
};

NodeList
nodelist_AddNode (nl, id)
NodeList nl;
int id;
{
	NodeList x;
	for (x = nl; x; x = x->next) {
		if (x->node_id == id) {
			msg_Format ("Node %d appears more than once in list\n",
					    x->node_id);
			return nl;
		}
	}
	x = talloc (1, struct node_list);
	x->next = nl;
	x->node_id = id;
	return x;
}

NodeList
nodelist_New ()
{
	return (NodeList) NULL;
}

void
nodelist_FreeNode (nl)
NodeList nl;
{
	nl->next = (NodeList) NULL;
	free (nl);
}


/*
 * The calling sequence to the parse_XXX routines is a little wierd.
 * Since the parser will be called from different environments it
 * needs callback functions to get its input (e.g. from a string
 * or a file) and to print error messages (e.g. to stderr or an
 * X window).  So the caller passes functions that do i/o to parse_XXX,
 * along with an argument to pass back to that function when the parser
 * calls it.  The idea is that you can call parse_Program() like:
 *
 * parse_Program (fgetc, (void*) fp, "filename");
 *
 * from a vanilla C/stdio environment.	In a non-vanilla environment
 * you can substitute other functions for fgetc/fputc, and pass them
 * appropriate arguments when called
 *
 * parse_Program() is just like parse_Node except that the former
 * returns a Graph and the latter returns a Node.  In the former
 * case the input text should start with "PROGRAM"; in the latter
 * it should start with a node declaration.
 */

static void parse_ResetLexer ();

Graph
parse_Program (inp, input_arg, input_filename)
int (*inp)();
void *input_arg;
char *input_filename;
{
	yy_getc = inp;
	yy_getc_arg = input_arg;
	yy_input_filename = input_filename;
	yy_parse_target = program;
	parse_ResetLexer ();
	parseErrorCount = 0;

	if (yyparse () == 0 && parseErrorCount == 0)
		return (Graph) yy_compiled_program;

	/* XXX need to free graph */
	return (Graph) NULL;
}

Node
parse_Node (inp, input_arg, input_filename)
int (*inp)();
void *input_arg;
char *input_filename;
{
	yy_getc = inp;
	yy_getc_arg = input_arg;
	yy_input_filename = input_filename;
	yy_parse_target = node;
	parse_ResetLexer ();
	parseErrorCount = 0;

	if (yyparse () == 0 && parseErrorCount == 0)
		return (Node) yy_compiled_program;

	/* XXX need to free node */
	return (Node) NULL;
}

static int
yyerror ()
{
	extern int yylineno;

	char *foo = (yychar == TK_id) ? "identifier" : "symbol";

	if (yy_input_filename != (char *) NULL)
		msg_Format ("%s, line %d: unexpected %s \"%s\"\n",
					yy_input_filename, yylineno, foo, yytext);
	else
		msg_Format ("line %d: unexpected %s \"%s\"\n", yylineno, foo, yytext);
	++parseErrorCount;
}

static void
parse_Error (s)
char *s;
{
	if (yy_input_filename != (char *) NULL)
		msg_Format ("%s, line %d: %s\n",
					yy_input_filename, yylineno, s);
	else
		msg_Format ("line %d: %s\n", yylineno, s);
	++parseErrorCount;
}

static int
yywrap ()
{
	return 1;
}

/*
 * this is a horrible hack to reset the lexical analyzer's state
 * back to its initial state.  This probably won't work with anything
 * except Lex Classic.  If this code ever has to run with anything
 * else we should probably rewrite the lexical analyzer in bare C.
 */

static void
parse_ResetLexer ()
{
	yylineno = 1;
#ifndef FLEX_SCANNER
	yysptr = yysbuf;
    yytchar = 0;
	yyprevious = YYNEWLINE;
#else
	/* XXX how to reset flex scanner? */
#endif
    BEGIN 0;
}

/*
 * Local Variables:
 * mode:fundamental
 * tab-width:4
 * comment-column:40
 * End:
 */
