#
#	dag.l
#
#	Scanner for graph descriptions.
#
#	3 Dec 1990  Manchek  manchek@CS.UTK.EDU.
#

D		[0-9]
L		[a-zA-Z_]
ID		{L}({L}|{D})*
INT		({D}+)
F		({D}+[.]{D}*)|({D}*[.]{D}+)
QUO             ["]
TYPE		"int"|"float"|"double"|"char"|"INT"|"FLOAT"|"DOUBLE"|"CHAR"

%%
%{
/*
 * override lex defaults for input, output, and unput
 */
#undef input
#undef output
#undef unput
#ifdef FLEX_SCANNER
/* XXX need definitions for input, output, and unput */
#else
/*
 * redefine input() and unput() to use normal buffering, but to call yy_getc()
 * instead of getchar().  Redefine output() to do nothing useful.
 */
#define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):(*yy_getc)(yy_getc_arg))=='\n'?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
#define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
#define output(c) do {} while (0)
#endif

%}
"/*"			{
                          char c;
                          loop:
			  for (c = input(); c != '*'; c = input()) {
    			    if (c == EOF || c == '\0') {
     			      fprintf(stderr, "EOF in comment\n");
                              yyerror();
            		    }
			  }
			  c = input();
                          if (c != '/') {
                            unput(c);
                            goto loop;
                          }
                        }
{QUO}			{
                          int i, sz;
			  char *str, bksl, c;
 
       			  i = 0;
                          sz = 21;
                          bksl = 0;
                          str = (char *) malloc (20 * sizeof(char));
                          for (c = input(); c != '"' || bksl ; c = input()) {
			      if (i == sz - 1) {
				  sz += 20;
				  str = (char *) realloc (str, sz);
			      }
			      if (c == EOF) {
				  fprintf(stderr, 
					  "ERROR: EOF in string constant\n");
				  yyerror();
			      }
			      else if (c == '\n') {
				  fprintf(stderr,
					  "ERROR: \\n in string constant\n");
				  yyerror();
			      }
			      else if (c == '\0') {
				  fprintf(stderr, 
					  "ERROR: Null in string constant\n");
				  yyerror();
			      }
			      else if (bksl) {
				  switch (c) {
				  case 'n': str[i] = '\n'; break;
				  case 't': str[i] = '\t'; break;
			          case 'b': str[i] = '\b'; break;
				  default: str[i] = c; break;
				  }
				  bksl = 0;
				  i++;
			      }
			      else if (c == '\\') {
				  bksl = 1;
			      }
			      else {
				  str[i] = c;
				  i++;
			      }
			  }
			  str[i] = '\0';
			  currentString = str;
			  return TK_string;
			}
"PROGRAM"		{ return TK_PROGRAM; }
"NODE"			{ return TK_NODE; }
"ARC"			{ return TK_ARC; }
"NEW" 			{ return TK_NEW; }
"ENDSWITCH"		{ return TK_ENDCOND; }
"BEGINSWITCH"		{ return TK_COND; }
"ENDCOND"		{ return TK_ENDCOND; }
"BEGINCOND"		{ return TK_COND; }
"ENDLOOP"		{ return TK_ENDLOOP; }
"BEGINLOOP"		{ return TK_LOOP; }
"ENDPIPE"		{ return TK_ENDPIPE; }
"BEGINPIPE"		{ return TK_PIPE; }
"FANOUT"		{ return TK_FANOUT; }
"FANIN"			{ return TK_FANIN; }
"TO"			{ return TK_TO; }
"UNDEFINED"		{ return TK_UNDEFINED; }
{TYPE}			{ return TK_TYPENAME; }
{ID}			{ return TK_id; }
{F}			{ return TK_float; }
{INT}			{ return TK_int; }
"<>"			{ return TK_IO; }
"<<"			{ return TK_LSHIFT; }
">>"			{ return TK_RSHIFT; }
"!="			{ return TK_NE; }
"=="			{ return TK_EQ; }
"<="			{ return TK_LE; }
">="			{ return TK_GE; }
"&&"			{ return TK_AND; }
"||"			{ return TK_OR; }
"\n"			{
#ifdef FLEX_SCANNER
	extern int yylineno;
	++yylineno;
#endif
}
[ \t]+			;
.			{ return (int)(*yytext); }

%%
#ifdef FLEX_SCANNER
int yylineno = 1;
#endif
/*
 * Local Variables:
 * mode:fundamental
 * comment-column:40
 * End:
 */
