#define FV_FileTypeBits		0xFF
#define FV_RegularFile		0x01	/* ordinary file */
#define FV_Directory		0x02	/* directory */
#define FV_BlockSpecial 	0x04	/* block device */
#define FV_CharSpecial		0x08	/* char device */
#define FV_FIFO			0x10	/* named pipe / fifo (SYSV) */
#define FV_Socket		0x20	/* UNIX domain socket (BSD) */
#define FV_Symlink		0x40	/* symbolic link */
#define FV_Other		0x80	/* anything else */

#define FV_MustExist		0x8000	/* don't select a nonexistent file */
#define FV_MustBeReadable	0x4000	/* don't select unless readable */
#define FV_MustBeWritable	0x2000	/* don't select unless writable */
#define FV_DirMustExist		0x1000	/* directory must exist */
#define FV_NoticeSymlinks	0x0800	/* treat a symlink as a symlink,
					   not the kind of file it points to */

static Widget fvPop = (Widget) NULL;
static Widget fvForm = (Widget) NULL;
static Widget fvLabel = (Widget) NULL;
static Widget fvDirLabel = (Widget) NULL;
static Widget fvDirText = (Widget) NULL;
static Widget fvFilterLabel =  (Widget) NULL;
static Widget fvFilterText = (Widget) NULL;
static Widget fvFileList = (Widget) NULL;
static Widget fvFileText = (Widget) NULL;
static Widget fvMsgLabel = (Widget) NULL;
static Widget fvSelectButton = (Widget) NULL;
static Widget fvCancelButton = (Widget) NULL;
char **fv_FileNames = NULL;
static XtCallbackRec callback[2] = {
    { 0, 0 },
    { 0, 0 },
};

static void
fv_CallBack (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
}

static
fv_RedoFilelist ()
{
}

static
fv_SelectFile ()
{
}

static void
fv_SelectButton ()
{
}

static void
fv_CancelButton ()
{
}

static XtActionsRec actions[] = {
    { "fv-redo-filelist", fv_RedoFilelist },
    { "fv-select-file", fv_SelectFile },
};

int
filever (prompt, namebuf, buflen, dir, filter, flags)
char *prompt;
char *namebuf;
int buflen;
char *dir;
char *filter;
int flags;
{
    int x, y;
    int n;
    Arg args[20];
    
#define XtVaCMW XtVaCreateManagedWidget

    if (fvPop == (Widget) NULL) {	
	char *atxt, *ttxt;
	XtAccelerators atbl;
	XtTranslations ttbl;

	XtAppAddActions (context, actions, 1);

	fvPop = XtVaCreatePopupShell ("filePop", overrideShellWidgetClass,
				      topLevel, NULL);
	fvForm = XtVaCMW ("", formWidgetClass, fvPop, NULL);

	/*
	 * label for top of dialog box, that says what we are prompting
	 * for.
	 */
	fvLabel = XtVaCMW ("prompt", labelWidgetClass, fvForm,
			   XtNtop, XawChainTop,
			   XtNbottom, XawChainTop,
			   XtNleft, XawChainLeft,
			   XtNright, XawChainRight,
			   XtNresizable, True,
			   NULL);
	/*
	 * label in front of Directory box.  By default, this says
	 * "directory:".
	 *
	 * XXX should be in global resource fallbacks, so site or
	 * user can override it.
	 */
	fvDirLabel = XtVaCMW ("fvDirLabel", labelWidgetClass, fvForm,
			      XtNtop, XawChainTop,
			      XtNbottom, XawChainTop,
			      XtNleft, XawChainLeft,
			      XtNright, XawChainLeft,
			      XtNfromVert, fvLabel,
			      XtNresizable, True,
			      XtNlabel, "directory:", /* XXX defaults */
			      NULL);

	/*
	 * text widget for user to edit directory.  Default is supplied
	 * by caller; user can edit.  When user presses Return,
	 * we re-scan the directory.
	 */
	ttxt = "<Key>Return: fv-redo-filelist()";
	ttbl = XtParseTranslations (ttxt);
	fvDirText = XtVaCMW ("fvDirText", asciiTextWidgetClass, fvForm,
			     XtNtop, XawChainTop,
			     XtNbottom, XawChainTop,
			     XtNright, XawChainRight,
			     XtNfromVert, fvLabel,
			     XtNfromHoriz, fvDirLabel,
			     XtNtranslations, ttbl,
			     NULL);

	/*
	 * label in front of filter.  By default, sez "filter:".
	 *
	 * XXX should be in global resource fallbacks, so site or
	 * user can override it.
	 */
	fvFilterLabel = XtVaCMW ("fvFilterLabel", labelWidgetClass, fvForm,
				 XtNtop, XawChainTop,
				 XtNbottom, XawChainTop,
				 XtNleft, XawChainLeft,
				 XtNright, XawChainLeft,
				 XtNfromVert, fvDirLabel,
				 XtNresizable, True,
				 XtNlabel, "filter:", /* XXX defaults */
				 NULL);

	/*
	 * text widget for user to specify filter.  Default is supplied
	 * by caller; user can edit.  When user presses Return, we
	 * re-scan the directory.
	 */
	ttxt = "<Key>Return: fv-redo-filelist()";
	ttbl = XtParseTranslations (ttxt);
	fvFilterText = XtVaCMW ("fvFilterText", asciiTextWidgetClass, fvForm,
				XtNtop, XawChainTop,
				XtNbottom, XawChainTop,
				XtNright, XawChainRight,
				XtNfromVert, fvLabel,
				XtNfromHoriz, fvFilterLabel,
				XtNtranslations, ttbl,
				NULL);
	/*
	 * viewport widget to hold file list so that it can have
	 * a scrollbar
	 */
	fvFileListViewport = XtVaCMW ("fvFileListViewport",
				      viewportWidgetClass, fvForm,
				      XtNtop, XawChainTop,
				      XtNbottom, XawChainBottom,
				      XtNleft, XawChainLeft,
				      XtNright, XawChainRight,
				      XtNfromVert, fvFilterLabel,
				      XtNallowHoriz, False,
				      XtNforceBars, True,
				      NULL);

	/*
	 * list widget to allow user to point-and-click at filename.
	 */
	callback[0].callback = fv_SelectFromList;
	callback[0].closure = 0;
	fvFileList = XtVaCMW ("fvFileList", listWidgetClass,
			      fvFileListViewport,
			      XtNdefaultColumns, 1,
			      XtNforceColumns, True,
			      XtNverticalList, True,
			      XtNcallback, callback,
			      NULL);

	/*
	 * text widget to allow user to type-in file name.  When user
	 * presses Return, attempts to select file.
	 */
	ttxt = "<Key>Return: fv-select-file()";
	ttbl = XtParseTranslations (ttxt);
	fvFileText = XtVaCMW ("fvFileText", asciiTextWidgetClass, fvForm,
			      XtNtop, XawChainBottom,
			      XtNbottom, XawChainBottom,
			      XtNleft, XawChainLeft,
			      XtNright, XawChainRight,
			      XtNfromVert, fvFileListViewport,
			      XtNtranslations, ttbl,
			      NULL);
	/*
	 * label used to display error messages, etc.
	 */

	fvMsgLabel = XtVaCMW ("fvMsgLabel", labelWidgetClass, fvForm,
			      XtNtop, XawChainBottom,
			      XtNbottom, XawChainBottom,
			      XtNleft, XawChainLeft,
			      XtNright, XawChainRight,
			      XtNfromVert, fvFileText,
			      XtNresizable, True,
			      XtNlabel, "",
			      NULL);
#if 0
	atxt = "#override\n<Key>Return:set()notify()reset()\n";
    	atbl = XtParseAcceleratorTable (atxt);
#endif
	/*
	 * select button.  When user clicks on button, we attempt to
	 * select the file name from the fvFileText buffer.
	 *
	 * XXX need button legend in global resource fallbacks so
	 * site or user can override it.
	 */
	callback[0].callback = fv_SelectButton;
	callback[0].closure = 0;
	fvSelectButton = XtVaCMW ("fvSelect", commandWidgetClass, fvForm,
				  XtNtop, XawChainBottom,
				  XtNbottom, XawChainBottom,
				  XtNleft, XawChainLeft,
				  XtNfromVert, fvMsgLabel,
				  XtNresizable, True,
				  XtNcallback, callback,
				  XtNlabel, "select", /* XXX defaults */
#if 0
				  XtNaccelerators, atbl,
#endif
				  NULL);
	/*
	 * cancel button.  When user clicks on button, we should get rid
	 * of the popup window and return without selecting anything.
	 *
	 * XXX need button legend in global resource fallbacks so
	 * site or user can override it.
	 */
	callback[0].callback = fv_CancelButton;
	callback[0].closure = 0;
	fvCancelButton = XtVaCMW ("fvCancel", commandWidgetClass, fvForm,
				  XtNtop, XawChainBottom,
				  XtNbottom, XawChainBottom,
				  XtNright, XawChainRight,
				  XtNfromVert, fvMsgLabel,
				  XtNresizable, True,
				  XtNcallback, callback,
				  XtNlabel, "cancel", /* XXX defaults */
				  NULL);
	XtRealizeWidget (fvPop);
#if 0
	XtInstallAccelerators (fvFileText, fvSelectButton);
	/* XtInstallAccelerators (fvFileList, fvSelectButton); */
#endif
    }
    XawFormDoLayout (fvForm, False);
    XtVaSetValues (fvLabel, XtNlabel, prompt, NULL);
    XtVaSetValues (fvFileText,
		   XtNstring, namebuf,
		   XtNlength, buflen - 1,
		   NULL);
    XtVaSetValues (fvMsgLabel, XtNlabel, "", NULL);

    fv_FileNames = getFileList (dir, filter);
    XtVaSetValues (fvFileList, XtNlist, fv_FileNames, NULL);
    if (fv_FileNames && *namebuf) {
	for (i = 0; fv_FileNames[i], ++i)
	    if (strcmp (namebuf, fv_FileNames[i]) == 0) {
		XawListHighlight (fv_FileList, i);
		break;
	    }
    }
    XawFormDoLayout (fvForm, True);
    get_mousxy (&x, &y);
    if (x)
	XtMoveWidget (fvPop, x, y);
    XtPopup (fvPop, XtGrabExclusive);
}
