/*
 *	HeNCE Tool
 *
 *	config.c - Configuration editor widget stuff.
 *		This is where everything goes that happens in the config panel.
 *
 *	Jun 1991  Robert Manchek  manchek@CS.UTK.EDU.
 *
 *	Revision Log
 *
$Log: config.c,v $
 * Revision 1.1  1992/04/08  05:48:34  moore
 * initial RCS version
 *
 *
 */

#include <sys/types.h>
#include <stdio.h>
#include "xincl.h"
#include "FileSelect.h"
#include "Hgw/Matrix.h"
#include "rb.h"
#include "param.h"
#include "exp.h"
#include "graph.h"
#include "costmat.h"
#include "xcomn.h"
#include "comn.h"


/*******************
*  from elsewhere  *
*                  *
*******************/

extern char directory[1024];		/* from widmain.c */
extern char costfile[1024];			/* from widmain.c */
extern Graph scratchgraph;			/* from widmain.c */
extern struct costm *costmatrix;	/* from widmain.c */
extern Widget configButton;			/* from widmain.c */


/*************
*  exported  *
*            *
*************/

void start_config();
int stop_config();


/***********
*  global  *
*          *
***********/

static void load_cb();
static void store_cb();
static void move_cb();
static void newentry_cb();
static Widget cre_costmat();
static Widget cre_cmdpanel();
static void newmatrices();

static char filename[256];		/* for load, store */
static Widget configMat = 0;
static Widget configCmd = 0;
static Widget subMatrix, hostMatrix, costMatrix;
static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];
static char crud[1024];
static int row_offset = 0;
static int col_offset = 0;


/********************
*  widget creation  *
*                   *
********************/

/*	start_config()
*
*	Start method for config mode.  Create any widgets and manage em.
*/

void
start_config()
{
	Widget w;
	extern Widget costButton;	/* in widmain.c */

	if (costfile[0]) {
		int n;

		if (directory[0]
		&& !strncmp(costfile, directory, (n = strlen(directory)))
		&& costfile[n] == '/') {
			strncpy(filename, costfile + n + 1, sizeof(filename)-1);
		} else
			strncpy(filename, costfile, sizeof(filename)-1);

	} else {
		filename[0] = 0;
	}
	if (!costmatrix)
		costmatrix = cm_New ();

#if 1
	if (cm_AddNamesFromGraph (scratchgraph, costmatrix)) {
		msg_Format ("new functions from graph added to cost matrix.\n");
	}
#endif

	w = cre_cmdpanel(mainCmd);
	XtManageChild(configCmd);
	cre_costmat(w);
	XtManageChild(configMat);
	newmatrices();
	set_togg(configButton, 1);
#if 1
	XtVaSetValues (costButton,
				   XtNsensitive, False,
				   NULL);
#endif
}

/*
 * last chance for the luser to exit without saving the cost matrix
 * return 1 if he wants to save ; 0 if it's okay to quit
 */

int
config_SaveLuser ()
{
	static char msg[] =
		"cost matrix is not saved.  quit anyway?";

	if (costmatrix && costmatrix->isModified) {
		switch (verify (msg)) {
		case 0:					/* yes => okay to quit */
			msg_Format ("\
Use the \"store\" button in config mode to save the cost matrix\n");
			return 0;
		case 1:					/* no => don't quit */
		case 2:					/* cancel => don't quit */
		default:
			return 1;
		}
	}
	else
		return 0;				/* no cost matrix => okay to quit */
}


/*	stop_config()
*
*	Stop method for config mode.
*	Returns 0 if successfully stopped, else 1.
*/

int
stop_config()
{
	extern Widget costButton;	/* in widmain.c */

	if (costmatrix && costmatrix->isModified) {
		switch (verify ("cost matrix has been modified.  save?")) {
		case 0:					/* yes */
			store_cb ();
			break;
		case 1:					/* no */
			break;
		case 2:					/* cancel */
			return 1;
		}
	}
	XtUnmanageChild(configCmd);
	XtUnmanageChild(configMat);
	set_togg(configButton, 0);
#if 1
	XtVaSetValues (costButton,
				   XtNsensitive, True,
				   NULL);
#endif
	return 0;
}

static void
CellChanged (w, cli, cd)
Widget w;
XtPointer cli;
XtPointer cd;
{
	if (costmatrix) {
#if 0
		if (costmatrix->isModified == 0)
			printf ("modified cost matrix\n");
#endif
		costmatrix->isModified = 1;
	}
}

static Widget
cre_costmat(below)
Widget below;
{
	/*	Widget w; */
	int n;

	if (configMat)
		return configMat;

	n = 0;
	XtSetArg(args[n], XtNfromVert, below); n++;
	configMat = XtCreateWidget("configMat", formWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNhorizDistance, 110); n++;
	XtSetArg(args[n], XtNwidth, 680); n++;
	XtSetArg(args[n], HgwNrows, 1); n++;
	XtSetArg(args[n], HgwNcols, 10); n++;
	subMatrix = XtCreateManagedWidget("subMatrix", matrixWidgetClass,
		configMat, args, n);
	XtAddCallback (subMatrix, XtNcallback, CellChanged, (XtPointer) NULL);

	n = 0;
	XtSetArg(args[n], XtNfromVert, subMatrix); n++;
	XtSetArg(args[n], HgwNrows, 10); n++;
	XtSetArg(args[n], HgwNcols, 1); n++;
	hostMatrix = XtCreateManagedWidget("hostMatrix", matrixWidgetClass,
		configMat, args, n);
	XtAddCallback (hostMatrix, XtNcallback, CellChanged, (XtPointer) NULL);

	n = 0;
	XtSetArg(args[n], XtNwidth, 680); n++;
	XtSetArg(args[n], XtNfromHoriz, hostMatrix); n++;
	XtSetArg(args[n], XtNfromVert, subMatrix); n++;
	XtSetArg(args[n], HgwNrows, 10); n++;
	XtSetArg(args[n], HgwNcols, 10); n++;
	XtSetArg(args[n], HgwNnumeric, True); n++;
	costMatrix = XtCreateManagedWidget("costMatrix", matrixWidgetClass,
		configMat, args, n);
	XtAddCallback (costMatrix, XtNcallback, CellChanged, (XtPointer) NULL);

	XtRealizeWidget(configMat);
	XtManageChild(configMat);
	return configMat;
}

static Widget
cre_cmdpanel(below)
Widget below;
{
	Widget w;
	/* 	Widget  w2, w3; */
	int n;

	if (configCmd)
		return configCmd;

	n = 0;
	XtSetArg(args[n], XtNfromVert, below); n++;
	XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNhorizDistance, 0); n++;
	configCmd = XtCreateWidget("configCmd", formWidgetClass,
			mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNleft, XtChainLeft); n++;
	XtSetArg(args[n], XtNright, XtChainLeft); n++;
	XtSetArg(args[n], XtNtop, XtChainTop); n++;
	XtSetArg(args[n], XtNbottom, XtChainTop); n++;

	w = cre_cmd_but("load", configCmd, args, n,
		(Widget)0, (Widget)0, "load", (char*)0, 0, 0, load_cb, 0);
	w = cre_cmd_but("store", configCmd, args, n,
		(Widget)0, w, "store", (char*)0, 0, 0, store_cb, 0);
	w = cre_cmd_but("newEntry", configCmd, args, n,
		(Widget)0, w, "new entry", (char*)0, 0, 0, newentry_cb, 0);
	w = cre_cmd_but("left", configCmd, args, n,
		(Widget)0, w, "left", (char*)0, 0, 0, move_cb, 0);
	w = cre_cmd_but("down", configCmd, args, n,
		(Widget)0, w, "down", (char*)0, 0, 0, move_cb, 1);
	w = cre_cmd_but("up", configCmd, args, n,
		(Widget)0, w, "up", (char*)0, 0, 0, move_cb, 2);
	w = cre_cmd_but("right", configCmd, args, n,
		(Widget)0, w, "right", (char*)0, 0, 0, move_cb, 3);

	XtRealizeWidget(configCmd);
	return configCmd;
}


/**************
*  callbacks  *
*             *
**************/

/*	load_cb()
*
*	Load button hit
*/

static void
load_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int can;
	struct costm *newcm, *oldcm;

#if 1
	can = fileVerify ("load cm from file:", filename, sizeof(filename),
					  "*.mat", FS_RegularFile|FS_MustBeReadable);
#else
	can = filever("load cm from file:", filename, sizeof(filename));
#endif

	if (!can) {
		if (!filename[0]) {
			message("no filename.");
			return;
		}
		switch (cm_ReadFile (filename, &newcm)) {
		case 1:
			sprintf(crud, "\"%s\": can't read", filename);
			message(crud);
			break;

		case 2:
			sprintf(crud, "\"%s\": bad cost matrix", filename);
			message(crud);
			break;

		default:
			oldcm = costmatrix;
			costmatrix = newcm;
			newmatrices();
			cm_Free (oldcm);
			sprintf(crud, "\"%s\": new cost matrix", filename);
			message(crud);
			set_costfile(filename);
			break;
		}
	}
}

/*	store_cb()
*
*	Store button hit
*/

static void
store_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int can;

#if 1
	can = fileVerify ("store cm in file:", filename, sizeof(filename),
					  "*.mat", FS_RegularFile|FS_MustBeWritable);
#else
	can = filever("store cm in file:", filename, sizeof(filename));
#endif
	if (!can) {
		if (!filename[0]) {
			message("no filename.");
			return;
		}
		switch (cm_WriteFile (filename, costmatrix)) {
		case 0:
			sprintf(crud, "\"%s\": cost matrix written.", filename);
			message(crud);
			set_costfile(filename);
			break;

		case 1:
			sprintf(crud, "\"%s\": can't write cost matrix.", filename);
			message(crud);
			set_costfile(filename);
			break;

		case 2:
			message("no cost matrix.");
			break;
		}
	}
}

static void
move_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int how = (int)cli;
	int n;

	switch (how) {
	case 1:	/* down */
		row_offset++;
		break;

	case 2:	/* up */
		if (--row_offset < 0)
			row_offset = 0;
		break;

	case 3:	/* right */
		col_offset++;
		break;

	default:	/* left */
		if (--col_offset < 0)
			col_offset = 0;
		break;
	}
	n = 0;
	XtSetArg(args[n], HgwNcolOffset, col_offset); n++;
	XtSetValues(subMatrix, args, n);
	n = 0;
	XtSetArg(args[n], HgwNrowOffset, row_offset); n++;
	XtSetValues(hostMatrix, args, n);
	n = 0;
	XtSetArg(args[n], HgwNrowOffset, row_offset); n++;
	XtSetArg(args[n], HgwNcolOffset, col_offset); n++;
	XtSetValues(costMatrix, args, n);
}

static void
newentry_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	cm_AddEntry (costmatrix, (char*)0, (char*)0, 0);
	newmatrices();
}


/***************
*  misc stuff  *
*              *
***************/

static void
newmatrices()
{
	int n;

	if (!configMat)
		return;

	row_offset = 0;
	col_offset = 0;

	if (!costmatrix) {
fputs("newmatrices(): no cost matrix\n", stderr);
		n = 0;
		XtSetArg(args[n], HgwNeditable, False); n++;
		XtSetValues(subMatrix, args, n);
		XtSetValues(hostMatrix, args, n);
		XtSetValues(costMatrix, args, n);
		return;
	}

	n = 0;
	XtSetArg(args[n], HgwNeditable, True); n++;
	XtSetArg(args[n], HgwNcols, costmatrix->nsub); n++;
	XtSetArg(args[n], HgwNbase, costmatrix->subs); n++;
	XtSetArg(args[n], HgwNcolOffset, col_offset); n++;
	XtSetValues(subMatrix, args, n);

	n = 0;
	XtSetArg(args[n], HgwNeditable, True); n++;
	XtSetArg(args[n], HgwNrows, costmatrix->nhost); n++;
	XtSetArg(args[n], HgwNbase, costmatrix->hosts); n++;
	XtSetArg(args[n], HgwNrowOffset, row_offset); n++;
	XtSetValues(hostMatrix, args, n);

	n = 0;
	XtSetArg(args[n], HgwNeditable, True); n++;
	XtSetArg(args[n], HgwNrows, costmatrix->nhost); n++;
	XtSetArg(args[n], HgwNcols, costmatrix->nsub); n++;
	XtSetArg(args[n], HgwNbase, costmatrix->mat); n++;
	XtSetArg(args[n], HgwNrowOffset, row_offset); n++;
	XtSetArg(args[n], HgwNcolOffset, col_offset); n++;
	XtSetValues(costMatrix, args, n);
}

/*
 * Local variables:
 * tab-width:4
 * End:
 */
