/*
*	mwt.c
*
*	test application for Matrix Widget.
*
*/

#include <sys/types.h>
#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include "Matrix.h"
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/Viewport.h>

#define	tmalloc(n,t) (t*)malloc((n)*sizeof(t))

void color_cb(), quit_cb();
void row_cb(), col_cb();
void edit_cb();

Display *xDisp;				/* x display */
Widget mainForm;			/* main widget layout level */
Widget topLevel;			/* main widget */
Window xRootW;				/* x screen root window */
XtAppContext context;
int xScrn;					/* x screen */
int xDispWd, xDispHt;		/* display size */
u_long bp, wp;				/* display black, white pixel */
GC gcs[2];
Widget subMat, hostMat, costMat;
Widget mainForm;
Widget colorCmd;
Widget quitCmd;

/* Application default values */

static char *fallbacks[] = {
	"*allowShellResize:true",
	"*costMatrix.columns:5",
	"*costMatrix.rows:8",
	"*hostMatrix.columns:1",
	"*hostMatrix.rows:8",
	"*subMatrix.columns:5",
	"*subMatrix.rows:1",
	0
};

/* For custom resources */

typedef struct {
	Bool mono;			/* force monochrome display */
	Bool rvideo;		/* for monochrome */
} app_res_t, *app_resp_t;

static app_res_t app_res;

static XtResource res_list[] = {
	{"monochrome", "Monochrome", XtRBool, sizeof(Bool),
		XtOffset(app_resp_t, mono), XtRString, "off"},
	{"reverseVideo", "ReverseVideo", XtRBool, sizeof(Bool),
		XtOffset(app_resp_t, rvideo), XtRString, "off"},
};

static XrmOptionDescRec knownargs[] = {
	{ "-mono", ".monochrome", XrmoptionNoArg, "on" },
	{ "+mono", ".monochrome", XrmoptionNoArg, "off" },
};

static XtCallbackRec callback[2] = { { 0, 0 }, { 0, 0 } };
static Arg args[16];

/*	setup()
*
*	Get resources and setup main widget.
*/

setup(argc, argv)
	int *argc;
	char **argv;
{
	int n;
	XGCValues xgcvalues;

	n = 0;
	topLevel = XtAppInitialize(&context, "mwt",
		knownargs, XtNumber(knownargs),
		argc, argv,
		fallbacks,
		args, n);

	if (*argc > 1) {
		int i;

		for (i = 1; i < *argc; i++)
			fprintf(stderr, "mwt: unknown option <%s>\n", argv[i]);
		exit(1);
	}
	xDisp = XtDisplay(topLevel);
	xScrn = DefaultScreen(xDisp);
	xRootW = RootWindow(xDisp, xScrn);
	xDispWd = DisplayWidth(xDisp, xScrn);
	xDispHt = DisplayHeight(xDisp, xScrn);

	XtGetApplicationResources(topLevel, (caddr_t)&app_res,
		res_list, XtNumber(res_list), 0, 0);

	cre_mainwid();

	bp = BlackPixel(xDisp, xScrn);
	wp = WhitePixel(xDisp, xScrn);

}

main(argc, argv)
	int argc;
	char **argv;
{
	setup(&argc, argv);
	XtAppMainLoop(context);
}


cre_mainwid()
{
	int n;
	Widget w;
	Widget subLabel;

	n = 0;
	mainForm = XtCreateManagedWidget("mainForm", formWidgetClass,
		topLevel, args, n);

	n = 0;
	XtSetArg(args[n], XtNlabel, "color"); n++;
	callback[0].callback = color_cb;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = colorCmd = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	XtSetArg(args[n], XtNlabel, "colOffset <"); n++;
	callback[0].callback = col_cb;
	callback[0].closure = 0;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	XtSetArg(args[n], XtNlabel, "colOffset >"); n++;
	callback[0].callback = col_cb;
	callback[0].closure = (XtPointer)1;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	XtSetArg(args[n], XtNlabel, "rowOffset <"); n++;
	callback[0].callback = row_cb;
	callback[0].closure = 0;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	XtSetArg(args[n], XtNlabel, "rowOffset >"); n++;
	callback[0].callback = row_cb;
	callback[0].closure = (XtPointer)1;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	XtSetArg(args[n], XtNlabel, "editable"); n++;
	callback[0].callback = edit_cb;
	XtSetArg(args[n], XtNcallback, callback); n++;
	w = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNlabel, "quit"); n++;
	XtSetArg(args[n], XtNfromHoriz, w); n++;
	callback[0].callback = quit_cb;
	XtSetArg(args[n], XtNcallback, callback); n++;
	quitCmd = XtCreateManagedWidget("", commandWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNlabel, "subroutines:"); n++;
	XtSetArg(args[n], XtNhorizDistance, 120); n++;
	XtSetArg(args[n], XtNfromVert, colorCmd); n++;
	w = subLabel = XtCreateManagedWidget("", labelWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromVert, subLabel); n++;
	XtSetArg(args[n], XtNhorizDistance, 120); n++;
	subMat = XtCreateManagedWidget("subMatrix", matrixWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNlabel, "hosts:"); n++;
	XtSetArg(args[n], XtNfromVert, colorCmd); n++;
	w = XtCreateManagedWidget("", labelWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromVert, subMat); n++;
	XtSetArg(args[n], HgwNbase, (XtPointer)malloc(1000)); n++;
	hostMat = XtCreateManagedWidget("hostMatrix", matrixWidgetClass,
		mainForm, args, n);

	n = 0;
	XtSetArg(args[n], XtNfromHoriz, hostMat); n++;
	XtSetArg(args[n], XtNfromVert, subMat); n++;
	costMat = XtCreateManagedWidget("costMatrix", matrixWidgetClass,
		mainForm, args, n);


	XtRealizeWidget(topLevel);
}

static void
quit_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	exit(0);
}

static void
color_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int n;
	static int state = 0;

	switch (state++) {
	case 0:
		n = 0;
		XtSetArg(args[n], XtNbackground, 0xff0000); n++;
		XtSetValues(costMat, args, n);
		break;
	case 1:
		n = 0;
		XtSetArg(args[n], XtNforeground, 0xffff00); n++;
		XtSetValues(costMat, args, n);
		break;
	default:
		n = 0;
		XtSetArg(args[n], XtNbackground, 0xffffff); n++;
		XtSetArg(args[n], XtNforeground, 0x000000); n++;
		XtSetValues(costMat, args, n);
		state = 0;
		break;
	}
}

static void
row_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int n;
	int how = (int)cli;
	static int rowoffset = 0;

	n = 0;
	if (how) {
		XtSetArg(args[n], HgwNrowOffset, ++rowoffset); n++;
	} else {
		XtSetArg(args[n], HgwNrowOffset, --rowoffset); n++;
	}
	XtSetValues(costMat, args, n);
	XtSetValues(hostMat, args, n);
}

static void
col_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int n;
	int how = (int)cli;
	static int coloffset = 0;

	n = 0;
	if (how) {
		XtSetArg(args[n], HgwNcolOffset, ++coloffset); n++;
	} else {
		XtSetArg(args[n], HgwNcolOffset, --coloffset); n++;
	}
	XtSetValues(costMat, args, n);
	XtSetValues(subMat, args, n);
}

static void
edit_cb(w, cli, cd)
	Widget w;
	XtPointer cli;
	XtPointer cd;
{
	int n;
	static int edable = 1;

	n = 0;
	XtSetArg(args[n], HgwNeditable, (edable = !edable)); n++;
	XtSetValues(costMat, args, n);
}

