/* The following macro depends on the variables a and nca */

#define A(i,j) (*(a + (i)*nca + (j)))

/* The following macro depends on the variables b and ncb */

#define B(i,j) (*(b + (i)*ncb + (j)))

/* The following macro depends on the variables c and ncc */

#define C(i,j) (*(c + (i)*ncc + (j)))

/*
 * update2(int m, int n, int k, double *a, int nca, double *b, int ncb,
 *     double *c, int ncc)
 *
 * Performs the matrix operation
 *
 * c -= a*b
 *
 * where a is a m by k matrix, b is a k by n matrix and c is an m by n matrix.
 */
void
update2(m, n, k, a, nca, b, ncb, c, ncc)
double *a, *b, *c;
{
    int i, j, l;

    for(j = 0; j < n; j++) {
	for(l = 0; l < k; l++) {
	    for(i = 0; i < m; i++) {
		C(i,j) -= B(l,j)*A(i,l);
	    }
	}
    }
}
