/* The following macro depends on the variables a and nca */
#define A(i,j) (*(a + (i)*nca + (j)))
/* #define NOTDEF */

void
initb(n, a, b)
int     n;
double  *a, *b;
{
    int  i, j, nca = n;

    for (i = 0; i < n; i++) {
        b[i] = 0.0;
        for (j = 0; j < n; j++)
            b[i] += A(i,j)*j;
    }
}

void
initarray(n, a, a1, b)
int    n;
double *a, *a1, b[];
{
#ifdef NOTDEF
    static double _a[] = {
/*
        3,  17,  10,  1,
        2,   4 , -2,  2,
        6,  18, -12,  3,
        4,   3,   2,  4,
*/

	3,  18,  10,  1,  3,  17,  10,  1,  3,  17,  10,  1,  3,  17,  10,  1,
	2,   4 , -4,  2,  2,   4 , -2,  2,  2,   4 , -2,  2,  2,   4 , -2,  2,
	6,  18, -12,  5,  6,  18, -12,  3,  6,  18, -12,  3,  6,  18, -12,  3,
	4,   3,   2,  4,  3,   3,   2,  4,  4,   3,   2,  4,  4,   3,   2,  4,
	3,  17,  10,  3,  3,   7,  10,  1,  3,  17,  10,  1,  3,  17,  10,  1,
	2,   4 , -2,  2,  2,   4 ,  2,  2,  2,   4 , -2,  2,  2,   4 , -2,  2,
	6,  18, -12,  3,  6,  18, -12, 13,  6,  18, -12,  3,  6,  18, -12,  3,
	4,   3,   2,  4,  4,   3,   2,  4, -4,   3,   2,  4,  4,   3,   2,  4,
	3,  17,  10,  1,  3,  17,  10,  1,  3,  -7,  10,  1,  3,  17,  10,  1,
	2,   4 , -2,  2,  2,   4 , -2,  2,  2,   4 , 27,  2,  2,   4 , -2,  2,
	6,  18, -12,  3,  6,  18, -12,  3,  6,  18, -12, 13,  6,  18, -12,  3,
	4,   3,   2,  4,  4,   3,   2,  4,  4,   3,   2,  4,-14,   3,   2,  4,
	3,  17,  10,  1,  3,  17,  10,  1,  3,  17,  10,  1,  3,  -3,  10,  1,
	2,   4 ,  2,  2,  2,   4 , -2,  2,  2,   4 , -2,  2,  2,   4 , 20,  2,
	6,  18, -12,  3,  6,  18, -12,  3,  6,  18, -12,  3,  6,  18, -12, 30,
	4,   3,  12,  4,  4,   3,   2,  4,  4,   3,   2,  4,  4,   3,   2,  4,
    };
/*
    static double _a[] = {
        2, 4, 2,
        4, 7, 7,
        -2, -7, 5
    };
    static double _b[] = {4, 13, 7};
    static double _a[] = {
         2,  2, -2,
        -4, -2,  2,
        -2,  3,  9,
    };
    static double _b[] = {8, -14, 9};

*/

#else
    double *_a;
#endif
    int i, j;
    int nca = n;

#ifndef NOTDEF
    _a = (double *)malloc(n * n * sizeof(double));
#endif
    for(i = 0; i < n; i++) {
	for(j = 0; j < n; j++) {
#ifdef NOTDEF
	    A(i, j) = _a[i*n + j];
#else
	    A(i, j) =
	      ((random() % 0x7fffffff) / (double)(unsigned)0x7fffffff)*100;
#endif
	}
    }
    bcopy(a, a1, n*n*sizeof(double));
    initb(n, a, b);
}
