#include <stdio.h>
#define N   8	/* matrix dimension */

void
initmatrix(a, b, n, nproc)
float  *a, *b;
int    n;	/* matrix dimension */
int    nproc;   /* dimension of processor matrix (nproc x nproc) */
{
     static float
/*
aa[N][N] = {    { 1,-1, 0, 0},
                {-1, 2,-1, 0},
                { 0,-1, 2,-1},
                { 0, 0,-1, 2}  },
bb[N][N] = {    {4, 3, 2, 1},
                {3, 3, 2, 1},
                {2, 2, 2, 1},
                {1, 1, 1, 1}   };
*/
aa[N][N] = {    { 1, 0, 1, 2, 1, 0, 0, 1 },
                { 0, 0, 0, 1, 1, 2, 0, 1 },
                { 2, 1, 1,-1, 0, 0, 1, 1 },
                {-1, 0, 1, 2,-1, 1, 0, 1 },
                { 0, 1, 1, 0, 2,-1,-1, 0 },
                { 1, 1, 1, 1, 0, 0,-1, 0 },
                { 1, 0, 0, 2,-1, 1, 0,-1 },
                {-1, 1, 1, 0, 2, 1, 1, 0 }    },
bb[N][N] = {    { 0, 1, 1,-1, 2, 0, 0, 0 },
                { 1, 0,-1, 2, 0, 1, 1,-1 },
                {-1,-1, 0, 0, 1, 2, 1, 0 },
                { 0, 0, 1,-1, 1, 0, 1, 1 },
                { 1, 1, 1, 1, 0, 2,-1, 0 },
                {-1, 0, 0, 1, 2, 1, 0, 0 },
                { 0, 0, 1,-1, 1, 2, 1, 0 },
                { 0, 1, 1, 2,-1, 0,-1,-1 }    };
/*
  Output (8x8):

   0     2     5     0     4     4     1     1
  -1     2     3     4     4     4    -1     0
   0     2     2     2     4     5     1    -3
  -3    -2     1     1     2     1     3     1
   3     1     0     4    -2     4    -1    -1
   0     0     0     1     3     1     2     0
  -2    -1     1    -5     7    -1     4     3
   1     0     1     5     2    10     1    -1
*/

    if (n != N) {
	fprintf(stderr, "usage: n must match matrix dimension.");
	exit(-1);
    } else if ( n % nproc) {
        fprintf(stderr, "usage: n must divide nproc evenly.");
        exit(-1);
    }
    bcopy((char *)aa, (char *)a, N*N*sizeof(float));
    bcopy((char *)bb, (char *)b, N*N*sizeof(float));
}
