#!/bin/sh
XAMPLES=/usr/lpp/X11/Xamples
TMPSRC=tmp.src
TMPBIN=tmp.bin
IMAKE="imake -DUseInstalled -I$XAMPLES/config"
if [ ! -d $XAMPLES/config ] ; then
	echo $XAMPLES/config not found ; exit 1
fi
if [ ! -d $XAMPLES/lib/Xaw ] ; then
	echo $XAMPLES/lib/Xaw not found;  exit 1
fi
rm -rf $TMPSRC $TMPBIN
mkdir $TMPSRC $TMPBIN
BINDIR="`cd $TMPBIN ; pwd`"
echo copying imake sources to $TMPSRC >&2
( cd /usr/lpp/X11/Xamples/config ; tar cf - . ) | ( cd $TMPSRC ; tar xf - )
echo compiling imake >&2
( cd $TMPSRC ; make -f Makefile.ini ; mv imake $BINDIR )
echo removing imake sources >&2
rm -rf $TMPSRC/*
echo copying Xaw sources to $TMPSRC >&2
( cd /usr/lpp/X11/Xamples/lib/Xaw; tar cf - . ) | ( cd $TMPSRC ; tar xf - )
echo making Xaw Makefile >&2
PATH="$BINDIR:$PATH" ; export PATH
( cd $TMPSRC ; $IMAKE )
echo making Xaw >&2
( cd $TMPSRC ; make ; mv libXaw.a $BINDIR )
echo removing Xaw sources >&2
rm -rf $TMPSRC/*
echo making HeNCE Makefiles >&2
find . -type d -print | sed -e '/tmp.*/d' | while read dir ; do
	if [ -f $dir/Imakefile ] ; then
  		echo making Makefile in $dir   
  		(cd $dir ; $IMAKE -DExtraAixLinkerArg=-L$BINDIR )
  	fi  
done
