      PROGRAM FLOW
      INCLUDE 'params.h'
      INCLUDE 'jobcom.h'
      INCLUDE 'lunits.h'
      INCLUDE 'trecom.h'
      INCLUDE 'ignore.h'
C
      INTEGER*4 STATUS,CLI$GET_VALUE,CLI$PRESENT
      INTEGER*4 LIB$FIND_FILE,LIB$FIND_FILE_END
      INCLUDE '($SSDEF)'
      INCLUDE '($RMSDEF)'
      INCLUDE '($LBRDEF)'
      EXTERNAL CLI$_PRESENT,CLI$_DEFAULTED,CLI$_ABSENT,CLI$_NEGATED
      CHARACTER*(MXLIN) CIN,CFLOP,CTEMPL
      CHARACTER*1024 CLONG
      LOGICAL LOG
C
      LOG = .FALSE.
      NIGNO = 0
C
C LOG
C
      STATUS = CLI$PRESENT('LOG')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT).OR.
     &   STATUS.EQ.%LOC(CLI$_DEFAULTED)) THEN
        LOG = .TRUE.
      ENDIF
C
C INPUT TREE FROM FLOPPY
C
      ITREE = 0
      STATUS = CLI$PRESENT('P1')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        STATUS = CLI$GET_VALUE('P1',CIN)
        IF(.NOT.STATUS) STATUS = LIB$STOP(%VAL(STATUS))
        STATUS = LIB$FIND_FILE(CIN,CFLOP,I,'flow.floptre')
        IF(.NOT.STATUS) STATUS = LIB$STOP(%VAL(STATUS))
        STATUS = LIB$FIND_FILE_END(I)
        ITREE = 1
        IF(LOG)WRITE(6,'(A,A)')' Flow --> Input FLOPPY data:',
     &  CFLOP(:LENOCC(CFLOP))
        LINTRE = 50
        OPEN(LINTRE,FILE=CFLOP,ACCESS='SEQUENTIAL',READONLY,
     &  FORM='UNFORMATTED',STATUS='OLD',ERR=999)
      ENDIF
C
C QUERY TREE
C
      LQERY = .FALSE.
      STATUS = CLI$PRESENT('QUERY')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        LQERY = .TRUE.
        IF(LOG)WRITE(6,'(A)') ' Flow --> Queries on the tree'
      ENDIF
C
C ARGUMENT CHECKS
C
      LARGC = .FALSE.
      STATUS = CLI$PRESENT('ARGUMENTS')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        LARGC = .TRUE.
        IF(LOG)WRITE(6,'(A)') ' Flow --> Check argument consistency'
        STATUS = CLI$GET_VALUE('ARGUMENTS',CIN)
        CARGF = 'ARGMNTS.DAT'
        IF(STATUS.NE.%LOC(CLI$_ABSENT)) CARGF = CIN
        IF(LOG)WRITE(6,'(A,A)')
     &' Flow --> write Argument checks to:',CARGF(:LENOCC(CARGF))
        LOUTAR = 61
        OPEN(LOUTAR,FILE=CARGF,STATUS='NEW',ERR=999)
      ENDIF
C
C COMMON BLOCK TABLE
C
      LCOMM = .FALSE.
      STATUS = CLI$PRESENT('COMMON_TABLE')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        LCOMM = .TRUE.
        IF(LOG)WRITE(6,'(A)') ' Flow --> Produce COMMON table'
        STATUS = CLI$GET_VALUE('COMMON_TABLE',CIN)
        CCOMM = 'PROCOM.DAT'
        IF(STATUS.NE.%LOC(CLI$_ABSENT)) CCOMM = CIN
        IF(LOG)WRITE(6,'(A,A)')
     &' Flow --> write COMMON table to:',CCOMM(:LENOCC(CCOMM))
        LOUTCO = 60
        OPEN(LOUTCO,FILE=CCOMM,STATUS='NEW',ERR=999)
      ENDIF
C
C TREE
C
      LTREE = .FALSE.
      STATUS = CLI$PRESENT('STRUCTURE_CHART')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        LTREE = .TRUE.
        IF(LOG)WRITE(6,'(A)') ' Flow --> Produce Text Structure Chart'
        STATUS = CLI$GET_VALUE('STRUCTURE_CHART',CIN)
        CHART = 'PROTRE.DAT'
        IF(STATUS.NE.%LOC(CLI$_ABSENT)) CHART = CIN
        IF(LOG)WRITE(6,'(A,A)')
     &' Flow --> write Structure Chart to: ',CHART(:LENOCC(CHART))
        LOUTRE = 61
        OPEN(LOUTRE,FILE=CHART,STATUS='NEW',ERR=999)
      ENDIF
C
C IGNORE NAMES
C
      STATUS = CLI$PRESENT('IGNORE')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
   60   STATUS = CLI$GET_VALUE('IGNORE',CLONG)
        IF(STATUS.NE.%LOC(CLI$_ABSENT)) THEN
           NIGNO = NIGNO + 1
           LLONG = LENOCC(CLONG)
           CIGNO(NIGNO) = CLONG(:LLONG) 
           LIGNO(NIGNO) = LLONG
           GOTO 60
        ENDIF
        IF(LOG) WRITE(6,'(A)') ' Flow --> Ignore modules:'
        IF(LOG) WRITE(6,'(10X,6A)') (CIGNO(IG),IG=1,NIGNO)
      ENDIF
C
C Graphics Structure Chart
C
      LCHRT = .FALSE.
      STATUS = CLI$PRESENT('GRAPHICS')
      IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        STATUS = CLI$GET_VALUE('GRAPHICS',CIN)
        LOUTCH = 96
        CGRAPH = 'FLOW.PS'
        IF(STATUS) CGRAPH = CIN
        IF(LOG)WRITE(6,'(A,A)') ' Flow --> Chart name:',
     &                 CGRAPH(:LENOCC(CGRAPH))
        LCHRT = .TRUE.
        OPEN(LOUTCH,FILE=CGRAPH(:LENOCC(CGRAPH)),STATUS='NEW',
     &       CARRIAGECONTROL='LIST',ERR=999)
      ENDIF
C
C EXTERNALS
C
      LEXT =.TRUE.
C
      STATUS = CLI$PRESENT('EXTERNALS')
      IF(STATUS.EQ.%LOC(CLI$_NEGATED)) THEN
        IF(LOG)WRITE(6,'(A)')
     &  ' Flow --> Suppress external routines from the chart'
        LEXT = .FALSE.
      ELSE
        IF(LOG)WRITE(6,'(A)')
     &  ' Flow --> Include external routines in the chart'
      ENDIF
C
C NODE
C
      STATUS = CLI$PRESENT('NODE')
      IF(STATUS.EQ.%LOC(CLI$_DEFAULTED)) THEN
        CTREE = '$$$$'
        IF(LOG)WRITE(6,'(A)') ' Flow --> Take first node found'
      ELSE IF(STATUS.EQ.%LOC(CLI$_PRESENT)) THEN
        STATUS = CLI$GET_VALUE('NODE',CIN)
        IF(STATUS.NE.%LOC(CLI$_ABSENT)) THEN
          CTREE = CIN(:LENOCC(CIN))
          IF(LOG)WRITE(6,'(A,A)')' Flow --> Start chart from:',
     &    CTREE(:LENOCC(CTREE))
        ELSE
          CTREE = '$$$$'
          IF(LOG)WRITE(6,'(A)') ' Flow --> Take first node found'
        ENDIF
      ENDIF
    5 CONTINUE
C
      IF(LOG)WRITE(6,'(A)')
     &' Flow --> Finished parsing command string'
C
      CALL PRODES
C
      IF(LCHRT) CLOSE(LOUTCH)
      IF(LCOMM) CLOSE(LOUTCO)
      IF(LTREE) CLOSE(LOUTRE)
      CLOSE(LINTRE)
C
      GOTO 1000
  999 CONTINUE
      WRITE(6,500)
  500 FORMAT(//,1X,'***********************************************',
     &        /,1X,'*                 F  L  O  W                  *',
     &        /,1X,'*                   ABORTED                   *',
     &        /,1X,'*          in job preparation stage.          *',
     &        /,1X,'***********************************************')
 1000 CONTINUE
      END
