/*
 * Include file for Mathomatic.
 */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <setjmp.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <errno.h>
#if	MSC
#include <float.h>
#endif

#define	true	1
#define	false	0

#ifndef	max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif
#ifndef	min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

#undef	PI
#define	PI	3.141592653589793
#define	E	2.718281828459045

#define	ARR_CNT(a)	(sizeof(a)/sizeof(a[0]))

#if	!UNIX
#define	MATHERR		1	/* define if matherr() function exists */
#endif

#define	PROMPT		"-> "	/* user interface prompt string */

#define	SCREEN_COLUMNS	80	/* configurable screen length */

#define	EPSILON		true	/* true if we want to take into account floating point inaccuracies */

/*
 * The following defines the maximum number of equation spaces
 * that will be allocated.
 */
#define	N_EQUATIONS	10

/*
 * The following defines the maximum number of tokens in an expression.
 * A token is a mathematical operator or operand.
 * You may increase this to any value if you have 32 bit integers.
 * Don't make it too high or you will run out of memory.
 */
#if	TUTOR
#define N_TOKENS	500
#else
#if	UNIX
#define	N_TOKENS	15000
#else
#define	N_TOKENS	1500
#endif
#endif

#define	MAX_VARS	200	/* Maximum number of unique variables handled */

#define	VAR_MASK	0x3fffL	/* mask for bits containing the variable name */
#define	VAR_SHIFT	14	/* number of bits set in VAR_MASK */
#define	SUBSCRIPT_MASK	63	/* mask for variable subscript after shifting VAR_SHIFT */
#define	MAX_SUBSCRIPT	(SUBSCRIPT_MASK - 1)	/* maximum variable subscript */
#define	PERCENT_CHANGE	0x100000L	/* mask for bit containing percent_change flag */
#define PRIME_INCREMENT	0x10000000L	/* value to add to increment the number of primes */

typedef	char	sign_array_type[MAX_SUBSCRIPT+2];

typedef	double	k_type;		/* definition for internal storage of mathematical constants */

/*
 * The following structure is allocated for each Mathomatic command.
 */
typedef	struct {
	char	*name;		/* command name to be typed by user */
	int	(*func)();	/* function that handles this command */
	char	*usage;		/* command syntax */
	char	*info;		/* short description of command */
} com_type;

typedef union {
#define	CONSTANT	0	/* value for token_type.kind indicating this token is a constant */
	k_type	constant;	/* internal storage for mathematical constants */
#define	VARIABLE	1	/* value for token_type.kind indicating this token is a variable */
/* predefined variables follow (order is important) */
#define	V_E		1	/* the constant "e" */
#define	V_PI		2	/* the constant "pi" */
#define	IMAGINARY	3	/* the imaginary constant "i#" */
#define	SIGN		4
#define	LIMIT0		5
#define	MATCH_ANY	6
#define	SPECIAL		7
	long	variable;	/* internal storage for mathematical variables */
#define	OPERATOR	2	/* value for token_type.kind indicating this token is an operator */
/* valid operators follow */
#define	PLUS		1
#define	MINUS		2
#define	TIMES		3
#define	DIVIDE		4
#define	POWER		5
#define	FACTORIAL	6
#define	NEGATE		7
	int	operatr;	/* internal storage for the above operators */
} storage_type;

/*
 * The following structure defines the storage for each token in an expression.
 */
typedef	struct {
	short		kind;
	int		level;
	storage_type	token;
} token_type;

#include "proto.h"
