C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* INCLUDE FILE 'wrkspc.i'                                             *
C***********************************************************************
C* Common Block /WRKSPC/ contains a large array (WS) used by various   *
C* routines in this spectral shallow water model. WS provides a pool of*
C* memory for "faking" dynamic storage, allowing problem size, number  *
C* of processors, and parallel algorithm to be determined at runtime   *
C* without sacrificing the efficiency gained by packing work areas into*
C* contiguous storage.                                                 *
C***********************************************************************
C*                                                                     *
      REAL    WS(COMPSZ)
      COMMON  / WRKSPC /
     &        WS
C*                                                                     *
C***********************************************************************
C* WRKSPC also contains integer indices into WS that denote the        *
C* beginning of the arrays used for initial conditions, prognostic     *
C* variables, constants used in the spectral transform, and generic    *
C* work space (used throughout the code). All array definition indices *
C* use the same naming convention: the pointer to the beginning of an  *
C* array XXX is called IXXX.                                           *  
C*                                                                     *
C* The first set of indices denote the beginning of arrays of initial  *
C* conditions provided as test cases in subroutine INIT. These initial *
C* conditions are then used by ANLYTC to get analytic solutions.       *
C*                                                                     *
C*    UIC12  - initial U wind velocity                                 *
C*    VIC12  - initial U wind velocity                                 *
C*    PIC12  - initial height                                          *
C*    DIC12  - initial divergence                                      *
C*    EIC12  - initial vorticity                                       *
C*    MOUNT  - surface height (mountains) for CASE 5                   *
C*    TOPOSC - spectral coefficients for surface height of mountains   *
C*    PHICON - balanced geopotential (PHI), U, and V (for use in ANLYTC*
C*    UCON     for geopotential that balances steady zonal flow        *
C*    VCON     (CASE 4))                                               *
C***********************************************************************
C*                                                                     *
      INTEGER IUIC12, IVIC12, IPIC12, IDIC12, IEIC12, 
     &        IMOUNT, ITOPOSC, IPHICON, IUCON, IVCON
      COMMON  / WRKSPC / 
     &        IUIC12, IVIC12, IPIC12, IDIC12, IEIC12, 
     &        IMOUNT, ITOPOSC, IPHICON, IUCON, IVCON
C*                                                                     *
C***********************************************************************
C* The second set of indices denote the beginning of the arrays for the*
C* prognostic variables in both grid point space (2 levels in time), in*
C* wavenumber space (one level in time), and single vertical layer     *
C* values for both grid point and wavenumber space at a single level in*
C* time (used for error analysis).                                     * 
C*                                                                     *
C*    The indices for grid point space define                          *
C*    DIV    - divergence                                              *
C*    ZETA   - vorticity                                               *
C*    PHI    - geopotential                                            *
C*    for one time level, followed by the diagnostic variables         *
C*    UCOS   - horizontal velocities                                   *
C*    VCOS                                                             *
C*    followed by                                                      *
C*    DIV    - divergence                                              *
C*    ZETA   - vorticity                                               *
C*    PHI    - geopotential                                            *
C*    for the other time level.                                        *
C*                                                                     *
C*    The indices for wavenumber space define                          *
C*    DIVSC  - spectral coefficients for divergence                    *
C*    ZETASC - spectral coefficients for vorticity                     *
C*    PHISC  - spectral coefficients for geopotential                  *
C*                                                                     *
C*    The indices for single vertical layer fields define              *
C*    D      - gridpoint solution fields whose values are extracted    * 
C*    Z        from DIV, ZETA, PHI, UCOS, and VCOS in PSTSWM, and used *
C*    H        when determining errors                                 *
C*    U                                                                *
C*    V                                                                *
C*    DSC    - spectral solution fields whose values are extracted     * 
C*    ZSC      from DIVSC, ZETASC, and PHISC in PSTSWM, and used       *
C*    PSC      when determining errors                                 *
C***********************************************************************
C*                                                                     *
      INTEGER IDIV, IZETA, IPHI, IUCOS, IVCOS,
     &        IDIVSC, IZETASC, IPHISC, 
     &        ID, IZ, IH, IU, IV, IDSC, IZSC, IPSC
      COMMON  / WRKSPC / 
     &        IDIV, IZETA, IPHI, IUCOS, IVCOS,
     &        IDIVSC, IZETASC, IPHISC,
     &        ID, IZ, IH, IU, IV, IDSC, IZSC, IPSC
C*                                                                     *
C***********************************************************************
C* The third set of indices denote the beginning of arrays containing  *
C* information used in transforming between grid point and spectral    *
C* spaces                                                              *
C*                                                                     *
C*    THTA   - Gaussian co-latitude angle (radians)                    *
C*    WTS    - Gaussian weights                                        *
C*    ALP    - Associated Legendre Polynomials                         *
C*    DALP   - derivatives of the Associated Legendre Polynomials      *
C*    TRIGS  - trigonometric function values used by the Fourier       *
C*             transform                                               *
C*    ANNP1  - A/(N*(N+1))                                             *
C*    A2NNP1 - (N*(N+1))/A**2                                          *
C*    WTACSJ - 1.0/(A*COS(LAT)**2)                                     * 
C*    (where A is the radius of the earth and N is the 2-dimensional   *
C*    wavenumber)                                                      *
C***********************************************************************
C*                                                                     *
      INTEGER IALP, IDALP, ITRIGS, ITHTA, IWTS, IANNP1, 
     &        IA2NNP1, IWTACSJ
      COMMON  / WRKSPC / 
     &        IALP, IDALP, ITRIGS, ITHTA, IWTS, IANNP1, 
     &        IA2NNP1, IWTACSJ
C*                                                                     *
C***********************************************************************
C* The fourth set of indices denote the beginning of generic work      *
C* arrays, used for message buffers, as work space for the Fourier     *
C* transforms, for local work space whose size is problem problem      *
C* dependent, etc.                                                     *
C***********************************************************************
C*                                                                     *
      INTEGER IWS1, IWS2, IWS3
      COMMON  / WRKSPC / 
     &        IWS1, IWS2, IWS3
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
