C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      SUBROUTINE TREESUM(OSWITCH, LTH, LTJUMP, NVEC, NDATA, DATA, SUM)
C
C This subroutine calculates a local vector sum using a binary tree
C ordering. NVEC vectors are summed simultaneously.
C
C called by: DZSC2, FLTRNS, FTDPEV, FTDPIV, FTRNPE, PGRIDSUM, SGRIDSUM
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C switch indicating whether to sum "in-place" (0) or put results in
C sum vector (1)
      INTEGER OSWITCH
C vector length
      INTEGER LTH
C declared vector length
      INTEGER LTJUMP
C number of vectors being summed
      INTEGER NVEC
C number of data vectors contributing to each set of NVEC vectors
      INTEGER NDATA
C
C     Input/Work Space/Output
C
C Data to be summed: if (OSWITCH .EQ. 0) then results are returned in
C DATA(*,*,1). Entire array is overwritten during the calculation in any 
C case. 
      REAL DATA(LTJUMP,NVEC,NDATA)
C
C     Output
C
C If (OSWITCH .EQ. 1) then SUM contains the vector sum.
      REAL SUM(LTJUMP,NVEC)
C
C---- Local Variables --------------------------------------------------
C
C loop indices (first, second, third, and fourth) and bound on fourth
C loop index
      INTEGER I, J, N, L, NDHALF
C                                                                              
C---- Executable Statements --------------------------------------------
C
      IF (OSWITCH .EQ. 0) THEN
C
C       Calculate binary tree sums in-place.
        L = 1
        DO WHILE (L .LT. NDATA)
          DO N = 1,NDATA-L,2*L
            DO J = 1,NVEC
              DO I = 1,LTH
                DATA(I,J,N) = DATA(I,J,N) + DATA(I,J,N+L)
              ENDDO
            ENDDO
          ENDDO
          L = 2*L
        ENDDO
C
      ELSE
C
C       Calculate all but last step of binary tree sums in-place.
        L = 1
        IF (2*(NDATA/2) .EQ. NDATA) THEN
          NDHALF = NDATA/2
        ELSE 
          NDHALF = NDATA/2 + 1
        ENDIF
C
        DO WHILE (L .LT. NDHALF)
          DO N = 1,NDATA-L,2*L
            DO J = 1,NVEC
              DO I = 1,LTH
                DATA(I,J,N) = DATA(I,J,N) + DATA(I,J,N+L)
              ENDDO
            ENDDO
          ENDDO
          L = 2*L
        ENDDO
C
C       Finish tree sum and put in output vector.
        IF (NDATA .EQ. 1) THEN
          DO J = 1,NVEC
            DO I = 1,LTH
              SUM(I,J) = DATA(I,J,1)
            ENDDO
          ENDDO
        ELSE
          DO J = 1,NVEC
            DO I = 1,LTH
              SUM(I,J) = DATA(I,J,1) + DATA(I,J,1+L)
            ENDDO
          ENDDO
        ENDIF
C
      ENDIF
C
      RETURN
      END

