C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* INCLUDE FILE 'tracing.i'                                            *
C***********************************************************************
C* Common Block /TRACING/ contains the PICL tracing parameters.        *
C*                                                                     *
C*    TIMING    - enable timing logic?                                 *
C*    TRACING   - enable tracing logic?                                *
C*    TRACEFILE - open a trace file?                                   *
C*    TRSIZE    - size of buffer used to hold trace information        *
C*    TRSTART   - number of timestep when detailed tracing should start*
C*    TRSTOP    - number of timestep when detailed tracing should stop *
C*    TL1       - collect detailed PICL event trace?                   *
C*    TL2       - collect detailed user event trace?                   *
C*    TL3       - collect detailed tracing event trace?                *
C*    VERBOSE   - save trace data in verbose or compact form           *
C*    TMPNAME   - name of temporary file used for saving flushed data  *
C*    PERMNAME  - name of file where trace data is to be (permanently) *
C*                saved                                                *
C***********************************************************************
      LOGICAL TIMING, TRACING, TRACEFILE
      COMMON  / TRACING / 
     &        TIMING, TRACING, TRACEFILE
C*                                                                     *
      INTEGER TRSIZE, TRSTART, TRSTOP, TL1, TL2, TL3, VERBOSE
      COMMON  / TRACING / 
     &        TRSIZE, TRSTART, TRSTOP, TL1, TL2, TL3, VERBOSE
C*                                                                     *
      CHARACTER*32 TMPNAME, PERMNAME
      COMMON  / TRACING / 
     &        TMPNAME, PERMNAME
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
