C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'timing.i'                                             *
C***********************************************************************
C* Common Block /TIMING/ contains the variables used to record the     *
C* performance of PSTSWM.                                              *
C*                                                                     *
C*    TMIN   - minimum elapsed time to calculate a timestep            *
C*    TMAX   - maximum elapsed time to calculate a timestep            *
C*    TIN    - time current timestep calculation started               *
C*    TOVER  - measure of some of the time spent in subroutine call    *
C*             overhead incurred when choosing between parallel        *
C*             algorithm options                                       *
C*    TTOTAL - elapsed time between start and finish of model          *
C*             simulation                                              *
C***********************************************************************
      DOUBLE PRECISION TMIN, TMAX, TIN, TOVER, TTOTAL
      COMMON  / TIMING / 
     &        TMIN, TMAX, TIN, TOVER, TTOTAL
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
