C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      SUBROUTINE ROTATE(RLON, RLAT, ALPHA, ROTLON, ROTLAT)
C                                                                              
C This subroutine computes the rotated coordinates (ROTLON,ROTLAT) for a
C rotation by angle ALPHA.
C                                                                              
C called by: ANLYTC, INIT
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C original longitude
      REAL RLON
C original latitude
      REAL RLAT
C rotation angle
      REAL ALPHA
C
C     Output
C
C rotated longitude
      REAL ROTLON
C rotated latitude
      REAL ROTLAT
C
C---- local parameters -------------------------------------------------
C
      REAL PI
      PARAMETER (PI=3.141592653589793)
C 
C---- Local Variables --------------------------------------------------
C
C temporary used in calculating rotated coordinates
      REAL TEST
C   
C---- executable statements --------------------------------------------
C
      IF (ALPHA .EQ. 0.0) THEN
C
C        no rotation
         ROTLON = RLON
         ROTLAT = RLAT
C
      ELSE
C
C        rotation by angle ALPHA:
C        1) rotated latitude
         TEST = SIN(RLAT)*COS(ALPHA) - COS(RLAT)*COS(RLON)*SIN(ALPHA)
         IF (TEST .GT. 1.0) THEN
           ROTLAT = PI/2.0
         ELSEIF (TEST .LT. -1.0) THEN
           ROTLAT = -PI/2.0
         ELSE
           ROTLAT = ASIN(TEST)
         ENDIF
C
C        2) rotated longitude
         TEST = COS(ROTLAT)
         IF (TEST .EQ. 0.0) THEN
           ROTLON = 0.0
         ELSE
           TEST = SIN(RLON)*COS(RLAT)/TEST
           IF (TEST .GT. 1.0) THEN
             ROTLON = PI/2.0
           ELSEIF (TEST .LT. -1.0) THEN
             ROTLON = -PI/2.0
           ELSE
             ROTLON = ASIN(TEST)
           ENDIF
         ENDIF
C
C        Adjust for correct branch of inverse sine.
         TEST = COS(ALPHA)*COS(RLON)*COS(RLAT) + SIN(ALPHA)*SIN(RLAT)
         IF (TEST .LT. 0.0) THEN
            ROTLON = PI - ROTLON
         ENDIF
C
      ENDIF
C
      RETURN
      END
