C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'physical.i'                                           *
C***********************************************************************
C* Common Block /PHYSICAL/ contains the variables defining the data    *
C* decomposition of the physical space: NLON x NLAT x NVER.            *
C*                                                                     *
C*    NPLON_P  - number of processors used to partition longitude      *
C*               dimension                                             *
C*    NPLAT_P  - number of processors used to partition latitude       *
C*               dimension                                             *
C*    NPVER_P  - number of processors used to partition vertical       *
C*               dimension                                             *
C*    MAPLON_P - an array mapping "virtual processors" to physical     *
C*               processor for the set over which the longitude        *
C*               dimension is partitioned                              *
C*    MAPLAT_P - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the latitude        *
C*               dimension is partitioned                              *
C*    MAPVER_P - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the vertical        *
C*               dimension is partitioned                              *
C*    LONDEX_P - index of processor in MAPLON_P array                  *
C*    LATDEX_P - index of processor in MAPLAT_P array                  *
C*    VERDEX_P - index of processor in MAPVER_P array                  *
C*    MXLLON_P - declared number of local longitudes, used to make sure*
C*               that enough space is allocated to allow physical,     *
C*               Fourier, and spectral partitions of both gridpoint    *
C*               fields and Fourier coefficients will fit into the same*
C*               memory.                                               *
C*    NLLON_P  - number of local longitudes                            *
C*    NLLONH_P - NLLON_P/2                                             *
C*    LONTRUE_P- array mapping local longitude indices to global       * 
C*               longitude indices                                     *
C*    NLLAT_P  - number of local latitudes                             *
C*    LATTRUE_P- array mapping local latitude indices to global        * 
C*               latitude indices                                      *
C*    NLVER_P  - number of local vertical levels                       *
C***********************************************************************
      INTEGER NPLON_P, NPLAT_P, NPVER_P, MAPLON_P(0:NPROCSX-1),
     &        MAPLAT_P(0:NPROCSX-1), MAPVER_P(0:NPROCSX-1), LONDEX_P,
     &        LATDEX_P, VERDEX_P, MXLLON_P, NLLON_P, NLLONH_P, 
     &        LONTRUE_P(NLONX), NLLAT_P, LATTRUE_P(NLATX), 
     &        NLVER_P
      COMMON  / PHYSICAL / 
     &        NPLON_P, NPLAT_P, NPVER_P, MAPLON_P,
     &        MAPLAT_P, MAPVER_P, LONDEX_P,
     &        LATDEX_P, VERDEX_P, MXLLON_P, NLLON_P, NLLONH_P, 
     &        LONTRUE_P, NLLAT_P, LATTRUE_P, NLVER_P
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
