C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      SUBROUTINE NONLEX(DTA, WTACSJ, MOUNT, DIV, ZETA, PHI, UCOS, VCOS, 
     &                  FWS, RHS)
C                                                                              
C This procedure evaluates non-linear product and forcing terms and old
C timelevel of vorticity, divergence, geopotential for one explicit
C timestep. 
C
C If ((FORCED .EQ. .TRUE.) .AND. (MOMENT .EQ. .TRUE.)),  then U/V
C  momentum forcing terms are calculated.
C If ((FORCED .EQ. .TRUE.) .AND. (MOMENT .EQ. .FALSE.)), then
C  vorticity/divergence forcing terms are calculated.
C 
C called by: EXPLIC
C calls: FORCE
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
      INCLUDE 'problem.i'
C constants and timesteps
      INCLUDE 'consts.i'
C domain decomposition information
      INCLUDE 'physical.i'
C time dependent fields
      INCLUDE 'tdvars.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C timestep
      REAL DTA
C 1.0/(A*COS(LAT)**2)
      REAL WTACSJ(NLAT)
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C divergence field
      REAL DIV(MXLLON_P,NLVER_P,NLLAT_P,6)
C vorticity field
      REAL ZETA(MXLLON_P,NLVER_P,NLLAT_P,6)
C geopotential field
      REAL PHI(MXLLON_P,NLVER_P,NLLAT_P,6)
C eastward wind field (scaled by COS(THETA))
      REAL UCOS(MXLLON_P,NLVER_P,NLLAT_P)
C northward wind field (scaled by COS(THETA))
      REAL VCOS(MXLLON_P,NLVER_P,NLLAT_P)
C
C     Work Space
C
C forcing terms
      REAL FWS(NLLON_P,NLVER_P,3)
C
C     Output
C
C nonlinear terms 
      REAL RHS(MXLLON_P,NLVER_P,NLLAT_P,8)
C
C---- Local Variables --------------------------------------------------
C
C longitude, latitude, and vertical layer indices
      INTEGER I, J, JV
C coefficients used in computing nonlinear product terms
      REAL FAC1, FAC2
C
C---- Executable Statements --------------------------------------------
C 
C     Evaluate non-linear advection terms and old timelevel of
C     vorticity, divergence, and geopotential.
      FAC1 = DTA*PHIBAR                      
      DO J=1,NLLAT_P
        FAC2 = .5*A*WTACSJ(LATTRUE_P(J))
        DO JV=1,NLVER_P
          DO I=1,NLLON_P
            RHS(I,JV,J,1) = UCOS(I,JV,J)*ZETA(I,JV,J,LN)
            RHS(I,JV,J,2) = VCOS(I,JV,J)*ZETA(I,JV,J,LN)
            RHS(I,JV,J,3) = UCOS(I,JV,J)*PHI(I,JV,J,LN)
            RHS(I,JV,J,4) = VCOS(I,JV,J)*PHI(I,JV,J,LN)
            RHS(I,JV,J,5) = (UCOS(I,JV,J)*UCOS(I,JV,J)
     &                    + VCOS(I,JV,J)*VCOS(I,JV,J))*FAC2
     &                    + PHI(I,JV,J,LN)
            RHS(I,JV,J,6) = ZETA(I,JV,J,LNM1)
            RHS(I,JV,J,7) = DIV(I,JV,J,LNM1)
            RHS(I,JV,J,8) = PHI(I,JV,J,LNM1) - FAC1*DIV(I,JV,J,LN)
          ENDDO
        ENDDO
      ENDDO
C
      IF (FORCED) THEN
C       Compute forcing terms (for test case 4).
C
        IF (MOMENT) THEN
C         Compute the momentum forcing terms.
          DO J=1,NLLAT_P
            CALL FORCE(J, FWS(1,1,1), FWS(1,1,2), FWS(1,1,3))
            DO JV=1,NLVER_P
              DO I=1,NLLON_P
                RHS(I,JV,J,1) = RHS(I,JV,J,1) - FWS(I,JV,1)
                RHS(I,JV,J,2) = RHS(I,JV,J,2) + FWS(I,JV,2)
                RHS(I,JV,J,8) = RHS(I,JV,J,8) + DTA*FWS(I,JV,3)
              ENDDO
            ENDDO
          ENDDO
        ELSE
C         Compute the vorticity/divergence forcing terms.
          DO J=1,NLLAT_P
            CALL FORCE(J, FWS(1,1,1), FWS(1,1,2), FWS(1,1,3))
            DO JV=1,NLVER_P
              DO I=1,NLLON_P
                RHS(I,JV,J,6) = RHS(I,JV,J,6) + DTA*FWS(I,JV,2)
                RHS(I,JV,J,7) = RHS(I,JV,J,7) + DTA*FWS(I,JV,1)
                RHS(I,JV,J,8) = RHS(I,JV,J,8) + DTA*FWS(I,JV,3)
              ENDDO
            ENDDO
          ENDDO
        ENDIF
C
      ENDIF
C
      IF (FTOPO) THEN
C       Compute modifications for topography.
        DO J=1,NLLAT_P
          DO JV=1,NLVER_P
            DO I=1,NLLON_P
              RHS(I,JV,J,5) = RHS(I,JV,J,5) + GRAV*MOUNT(I,J)
            ENDDO
          ENDDO
        ENDDO
      ENDIF
C
      RETURN
      END
