C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      INTEGER FUNCTION MSGBASE()
C                                                                              
C This routine returns a message type offset that is used to define
C "safe" message types for interprocessor communication, within the
C context of pstswm. Each call returns a different value, which is a
C multiple of NPROCSX. 
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Local Variables --------------------------------------------------
C
C message type base (circular) counter
      INTEGER BASE
      SAVE BASE
      DATA BASE /0/
C
C---- Executable Statements --------------------------------------------
C
      BASE    = MOD(BASE+1, 20)
      MSGBASE = NPROCSX*BASE + NPROCSX
C
      RETURN
      END














