C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C globalgrid.f                                                         C
C                                                                      C
C The following routines return the latitude or longitude of the globalC
C grid (in radians) when passed the local latitude or longitude index, C
C respectively.                                                        C
C                                                                      C
C GLAT_P returns the latitude of the Gaussian grid for the physical    C
C        space partitioning.                                           C
C GLAT_S returns the latitude of the Gaussian grid for the spectral    C
C        space partitioning.                                           C
C GLON_P returns the longitude of the regular grid for the physical    C
C        space partitioning.                                           C
C                                                                      C
C The following routine returns the weight for numerical integration   C
C over the global grid when passed the local latitiude and longitude   C
C indices.                                                             C
C                                                                      C
C WEIGHT_P returns the gridpoint weight for the longitude/latitude gridC
C          for the physical space partitioning.                        C
C                                                                      C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      REAL FUNCTION GLAT_P(J)
C
C This function returns the latitude of the Gaussian grid in radians 
C when passed the local latitude index in the physical space 
C partitioning.
C
C called by: ANLYTC, DZSC, FORCE, INIT, INPUT, NRGTCS, TDVMOD
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C domain decomposition information
      INCLUDE 'physical.i'
C workspace array
      INCLUDE 'wrkspc.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C local latitude index
      INTEGER J
C
C---- Executable Statements --------------------------------------------
C
      GLAT_P = WS(ITHTA+LATTRUE_P(J)-1)
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      REAL FUNCTION GLAT_S(J)
C
C This function returns the latitude of the Gaussian grid in radians 
C when passed the local latitude index in the spectral space 
C partitioning.
C
C called by: CALP
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C domain decomposition information
      INCLUDE 'spectral.i'
C workspace array
      INCLUDE 'wrkspc.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C local latitude index
      INTEGER J
C
C---- Executable Statements --------------------------------------------
C
      GLAT_S = WS(ITHTA+LATTRUE_S(J)-1)
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      REAL FUNCTION GLON_P(I)
C
C This function returns the longitude of the regular grid in radians 
C when passed the local longitude index in the physical space 
C partitioning.
C
C called by: ANLYTC, FORCE, INIT, INPUT, NRGTCS
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
      INCLUDE 'problem.i'
C domain decomposition information
      INCLUDE 'physical.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C grid index (longitude)
      INTEGER I
C
C---- Local Parameters -------------------------------------------------
C
      REAL PI
      PARAMETER (PI=3.141592653589793)
C
C---- Executable Statements --------------------------------------------
C
      GLON_P = (2.0*PI)/REAL(NLON)*REAL(LONTRUE_P(I)-1)
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      REAL FUNCTION WEIGHT_P(I, J)
C
C This function returns a weight for numerical integration on the
C defined grid. It is normalized such that the sum over all latitude and 
C longitude points is 1.0.
C
C called by: ERRANL, NRGTCS, SPEED
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
      INCLUDE 'problem.i'
C domain decomposition definition variables
      INCLUDE 'physical.i'
C work space arrays
      INCLUDE 'wrkspc.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C local longitude and latitude indices
      INTEGER I, J
C
C---- Executable Statements --------------------------------------------
C
      WEIGHT_P = WS(IWTS+LATTRUE_P(J)-1)/(2.0*REAL(NLON))
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

