C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'fourier.i'                                            *
C***********************************************************************
C* Common Block /FOURIER/ contains the variables defining the data     *
C* decomposition of the physical space (NLON x NLAT x nver) and        *
C* Fourier space (MM x NLAT x NVER) when transforming between the      *
C* two spaces.                                                         *
C*                                                                     *
C*    NPFC_F   - number of processors used to partition longitude      *
C*               and Fourier wavenumber dimensions                     *
C*    NPLAT_F  - number of processors used to partition latitude       *
C*               dimension                                             *
C*    NPVER_F  - number of processors used to partition vertical       *
C*               dimension                                             *
C*    MAPFC_F  - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the longitude       *
C*               and Fourier wavenumber dimensions are partitioned     *
C*    MAPLAT_F - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the latitude        *
C*               dimension is partitioned                              *
C*    MAPVER_F - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the vertical        *
C*               dimension is partitioned                              *
C*    FCDEX_F  - index of processor in MAPFC_F array                   *
C*    LATDEX_F - index of processor in MAPLAT_F array                  *
C*    VERDEX_F - index of processor in MAPVER_F array                  *
C*    MXLLON_F - declared number of local longitudes, used to make sure*
C*               that enough space is allocated to allow physical,     *
C*               Fourier, and spectral partitions of both gridpoint    *
C*               fields and Fourier coefficients will fit into the same*
C*               memory.                                               *
C*    NLLON_F  - number of local longitudes                            *
C*    LONTRUE_F- array mapping local longitude indices to global       *
C*               longitude indices                                     *
C*    MXLFC_F  - declared number of local Fourier coefficients, used to*
C*               make sure that enough space is allocated to allow     *
C*               physical, Fourier, and spectral partitions of both    *
C*               gridpoint fields and Fourier coefficients will fit    *
C*               into the same memory.                                 *
C*    NLFC_F   - number of local wavenumbers before truncation         *
C*    NLMM_F   - number of local wavenumbers after truncation          *
C*    MTINV_F  - array mapping Fourier wavenumbers to local indices    *
C*    MTRUE_F  - array mapping local indices to Fourier wavenumbers    *
C*    JMLTRUE_F- array mapping local indices for truncated wavenumber  *
C*               sequence to local indices for untruncated sequence    *
C*    NLLAT_F  - number of local latitudes                             *
C*    LATTRUE_F- array mapping local latitude indices to global        * 
C*               latitude indices                                      *
C*    NLVER_F  - number of local vertical levels                       *
C***********************************************************************
      INTEGER NPFC_F, NPLAT_F, NPVER_F, MAPFC_F(0:NPROCSX-1),
     &        MAPLAT_F(0:NPROCSX-1), MAPVER_F(0:NPROCSX-1), FCDEX_F,
     &        LATDEX_F, VERDEX_F, MXLLON_F, NLLON_F, LONTRUE_F(NLONX), 
     &        MXLFC_F, NLFC_F, NLMM_F, MTINV_F(0:NLONX+1), 
     &        MTRUE_F(NLONX+2), JMLTRUE_F(NLONX+2), NLLAT_F, 
     &        LATTRUE_F(NLATX), NLVER_F
      COMMON  / FOURIER / 
     &        NPFC_F, NPLAT_F, NPVER_F, MAPFC_F,
     &        MAPLAT_F, MAPVER_F, FCDEX_F,
     &        LATDEX_F, VERDEX_F, MXLLON_F, NLLON_F, LONTRUE_F, 
     &        MXLFC_F, NLFC_F, NLMM_F, MTINV_F, MTRUE_F, 
     &        JMLTRUE_F, NLLAT_F, LATTRUE_F, 
     &        NLVER_F
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
