C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'finit.i'                                              *
C***********************************************************************
C* Common Block /FINIT/ contains information required to make use of   *
C* initial conditions provided as test cases in subroutine INIT. This  *
C* information is then used by ANLYTC to get analytic solutions.       *  
C*                                                                     *
C*    ALFA    - amplitude of translating low, used in CASE 4           *
C*    SIGMA   - areal extent of translating low, used in CASE 4        *
C*    NPWR                                                             *
C*    RLAT0   - initial location and amplitude for "features" in CASES *
C*    RLON0     1, 2, and 4                                            *
C*    PHI0      (- PHI amplitude at (RLAT0, RLON0))                    *
C*    SU0       (- velocity at (RLAT0, RLON0))                         *
C*    R       - Rossby-Haurwitz wave parameters, used in CASE 6        *
C*    K                                                                *
C*    OMG                                                              *
C***********************************************************************
      REAL    ALFA, SIGMA, RLAT0, RLON0, PHI0, SU0, K, OMG
      COMMON  / FINIT / 
     &        ALFA, SIGMA, RLAT0, RLON0, PHI0, SU0, K, OMG
C*                                                                     *
      INTEGER NPWR, R
      COMMON  / FINIT / 
     &        NPWR, R
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       





