C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      REAL FUNCTION EPSLON (X)
C
C This function estimates the single precision machine arithmetic
C roundoff in quantities of size x. If should function properly on all
C systems satisfying the following two assumptions:
C  1. The base used in representing floating point numbers is not a 
C     power of three.
C  2. The quantity A in statement 10 is represented to the accuracy used 
C     in floating point variables that are stored in memory.
C The statement number 10 and the GO TO 10 are intended to force
C optimizing compilers to generate code satisfying assumption 2.
C Under these assumptions, it should be true that
C  A   is not exactly equal to four-thirds,
C  B   has a zero for its last bit or digit,
C  C   is not exactly equal to one, and
C  EPS measures the separation of 1.0 from the next larger floating 
C      point number.
C
C called by: INIT, INPUT
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C value with respect to which roundoff is being calculated
C (X + EPSLON > X)
      REAL X
C
C---- Local Variables --------------------------------------------------
C
C temporaries used in calculating EPSLON
      REAL A, B, C, EPS
C
C---- Executable Statements --------------------------------------------
C
      A = 4.0E0/3.0E0
   10 B = A - 1.0E0
      C = B + B + B
      EPS = ABS(C-1.0E0)
      IF (EPS .EQ. 0.0E0) GO TO 10
      EPSLON = EPS*ABS(X)
C
      RETURN
      END
