C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      SUBROUTINE DPUPIM(DTA, A2NNP1, DIVSC, PHISC)
C                                                                              
C This routine updates the divergence and mass continuity spectral
C coefficients for semi-implicit timestepping. (See H. Ritchie's paper.)
C                                                                              
C called by: SIMPLIC
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
      INCLUDE 'params.i'
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
      INCLUDE 'problem.i'
C domain decomposition information
      INCLUDE 'spectral.i'
C time dependent fields
      INCLUDE 'tdvars.i'
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C timestep
      REAL DTA
C (N*(N+1))/A**2
      REAL A2NNP1(0:KK)
C
C     Input/Output
C
C divergence spectral coefficients
      COMPLEX DIVSC(MXLSPEC_S,NLVER_S)
C geopotential spectral coefficients
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C------ Local Variables ------------------------------------------------
C
C precalculated coefficients
      REAL FAC1, FAC2, FAC3
C polynomial degree and polynomial degree transition indices
      INTEGER N, JN, JNTRNS
C vertical layer, wavenumber, and spectral coefficient indices
      INTEGER JV, JM, L
C true wavenumber
      INTEGER M
C
C---- Executable Statements --------------------------------------------
C
C     Precompute common factors.
      FAC2 = 0.5*DTA
      FAC3 = (0.5*DTA)*PHIBAR
      FAC1 = ((0.25*DTA)*PHIBAR)*DTA
C
      JNTRNS = 1 - JMB_S(1)
      DO JV=1,NLVER_S
        L = 1
C
        DO JM=JMB_S(1),JME_S(1)
          M = MTRUE_S(JM)
          L = L - JNB_S(JNTRNS+JM)
C
          DO JN=JNB_S(JNTRNS+JM),JNE_S(JNTRNS+JM)
C           N = M + JN - 1
            PHISC(L+JN,JV) = (PHISC(L+JN,JV) - FAC3*DIVSC(L+JN,JV))	
     &                     / (1.0 + FAC1*A2NNP1(M+JN-1))
            DIVSC(L+JN,JV) = DIVSC(L+JN,JV) 
     &                     + FAC2*A2NNP1(M+JN-1)*PHISC(L+JN,JV)
          ENDDO
C
C         Update local spectral coefficient offset index.
          L = L + JNE_S(JNTRNS+JM) + 1
C
        ENDDO
C
      ENDDO
C
      RETURN
      END
