/*
C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
      SUBROUTINE DENORMAL
C
C On i860 based machines, this routine causes denormalized numbers to be
C set to zero, in order to avoid the significant performance hit caused
C by calculating with them.
C
C called by: INPUT
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Executable Statements --------------------------------------------
C
*/
denormal_()
{
/* 
  Set the FZ bit of the i860 floating point status register to set
  denormals to zero. Written by J. Michalakes of Argonne National
  Laboratory. 
*/ 
  asm("   ld.c fsr, r16") ;
  asm("   or 1, r16, r17") ;
  asm("   st.c r17, fsr") ;
  asm("   mov r17, r16" ) ;
}
