C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'consts.i'                                             *
C***********************************************************************
C* Common Block /CONSTS/ contains constant information required by     *
C* the routines that integrate the spectral shallow water equations.   *
C* For initialization of these variables see routine INPUT.            *
C*                                                                     *
C*    A      = radius of earth                                         *
C*    OMEGA  = angular velocity                                        *
C*    GRAV   = gravitational acceleration                              *
C*    DT     = timestep                                                *
C*    AFC    = Asselin time filter coefficient                         *
C*    SITS   = .TRUE. for semi-implicit timestepping,                  *
C*                    else explicit timestepping                       *
C*    NSTEP  = timestep counter                                        *
C*    TAU    = model time in hours                                     *
C*    TAUE   = length of model run in hours                            *
C*    HDC    = horizontal diffusion coefficient                        *
C*    FORCED = .TRUE. for external forcing (case 4)                    *
C*    MOMENT = .TRUE. for external momentum forcing,                   *
C*                    else vorticity-divergence forcing                *
C*    ALPHA  = rotation angle in radians                               *
C*    CORSC1 = spectral coriolis coefficients                          *
C*    CORSC2                                                           *
C*    EGYFRQ = frequency of analysis for conservation properties       *
C*    ERRFRQ = frequency of analysis for l2-error, min, and max        *
C*    SPCFRQ = frequency of spectral analysis                          *
C*    ICOND  = number of test case                                     *
C*    FTOPO  = .TRUE. if surface topography (MOUNT .NE. 0)             *
C*    CHEXP  = experiment #                                            *
C*    STRUNC = spectral truncation type                                *
C***********************************************************************
      REAL    A, OMEGA, GRAV, DT, AFC, TAU, TAUE,
     &        HDC, ALPHA, CORSC1, CORSC2, EGYFRQ, ERRFRQ, SPCFRQ
      COMMON  / CONSTS / 
     &        A, OMEGA, GRAV, DT, AFC, TAU, TAUE, 
     &        HDC, ALPHA, CORSC1, CORSC2, EGYFRQ, ERRFRQ, SPCFRQ
C*                                                                     *
      INTEGER NSTEP, ICOND
      COMMON  / CONSTS / 
     &        NSTEP, ICOND
C*                                                                     *
      LOGICAL SITS, FORCED, MOMENT, FTOPO
      COMMON  / CONSTS / 
     &        SITS, FORCED, MOMENT, FTOPO
C*                                                                     *
      CHARACTER*4 CHEXP
      CHARACTER*6 STRUNC
      COMMON / FILES / 
     &        CHEXP, STRUNC
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
