C#######################################################################
C PSTSWM Version 1.0 (8/1/93)                                          #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'algorithm.i'                                          *
C***********************************************************************
C* Common Block /ALGORITHM/ contains the parallel algorithm            *
C* specification parameters                                            *
C*                                                                     *
C*    FTOPT   - parallel algorithm to use in transforming between      *
C*              latitude/longitude grid (physical domain) and latitude/*
C*              wavenumber grid (Fourier domain). Options are          *
C*              distributed (0) and transpose (1).                     *
C*    LTOPT   - parallel algorithm to use in transforming between      *
C*              latitude/wavenumber grid (Fourier domain) and the      *
C*              spectral domain. Options are distributed (0) and       *
C*              transpose (1).                                         *
C*    COMMFFT - communication option to be used with the parallel      *
C*              algorithm specified by FTOPT in the transform TO the   *
C*              Fourier domain.                                        *
C*              If (FTOPT .EQ. 0) then                                 *
C*               (0): one block distributed FFT using simple swap      *
C*               (1): one block distributed FFT using "synchronous"    *
C*                    swap (send/recv | recv/send)                     *
C*               (2): two block distributed FFT using simple swap,     *
C*                    where during each stage of the FFT one block is  *
C*                    being communicated while the other block is being*
C*                    used in computation.                             *
C*               (3): two block distributed FFT using "synchronous"    *
C*                    swap                                             *
C*              If (FTOPT .EQ. 1) then                                 *
C*               (0): O(P) transpose algorithm using simple sendrecv   *
C*                    and ring ordering                                *
C*               (1): O(P) transpose algorithm using "synchronous"     *
C*                    sendrecv (send/recv | recv/send) and ring        *
C*                    ordering                                         *
C*               (2): O(P) transpose algorithm using simple sendrecv   *
C*                    with receive-ahead and ring ordering, where all  *
C*                    receive requests are posted ahead of time.       *
C*               (3): O(P) transpose algorithm using "synchronous"     *
C*                    sendrecv with receive-ahead and ring ordering    *
C*              (10): O(P) transpose algorithm using simple swap and   *
C*                    and exclusive-OR ordering                        *
C*              (11): O(P) transpose algorithm using "synchronous"     *
C*                    swap and exclusive-OR ordering                   *
C*              (12): O(P) transpose algorithm using simple swap with  *
C*                    receive-ahead and exclusive-OR ordering          *
C*              (13): O(P) transpose algorithm using "synchronous"     *
C*                    swap with receive-ahead and exclusive-OR ordering*
C*              (20): O(log P) transpose algorithm using simple swaps. *
C*                    P must be a power of two.                        *
C*              (21): O(log P) transpose algorithm using "synchronous" *
C*                    swaps. P must be a power of two.                 *
C*    COMMIFT - communication option to be used with the parallel      *
C*              algorithm specified by FTOPT in the transform FROM the *
C*              Fourier domain. Interpretation is same as for COMMFFT. *
C*    COMMFLT - communication option to be used with the parallel      *
C*              algorithm specified by LTOPT in the transform TO the   *
C*              spectral domain.                                       *
C*              If (LTOPT .EQ. 0) then                                 *
C*               (0): pipelined ring vector sum using simple sendrecv, *
C*                    where communication of running sum is            *
C*                    interspersed with computation of local           *
C*                    contribution to vector sum.                      *
C*               (1): pipelined ring vector sum using "synchronous"    *
C*                    sendrecv (send/recv | recv/send)                 *
C*               (2): pipelined ring vector sum where the receive is   *
C*                    delayed until just before the data is needed     *
C*              (10): (unpipelined) ring vector sum and broadcast using*
C*                    simple sendrecv                                  *
C*              (11): ring vector sum and broadcast using "synchronous"*
C*                    sendrecv                                         *
C*              (12): ring vector sum and broadcast using simple       *
C*                    sendrecv with receive-ahead, where all receive   *
C*                    requests are posted ahead of time.               *
C*              (13): ring vector sum and broadcast using "synchronous"*
C*                    sendrecv with receive-ahead                      *
C*              (20): recursive halving vector sum and broadcast       *
C*                    using simple swap                                *
C*              (21): recursive halving vector sum and broadcast using *
C*                    "synchronous" swap                               *
C*              (30): exchange vector sum and broadcast using simple   *
C*                    swap                                             *
C*              (31): exchange vector sum and broadcast using          *
C*                    "synchronous" swap                               *
C*              If (LTOPT .EQ. 1) then same options as for COMMFFT when*
C*              (FTOPT .EQ. 1)                                         *
C*    COMMILT - communication option to be used with the parallel      *
C*              algorithm specified by LTOPT in the transform FROM the *
C*              spectral domain.                                       *
C*              If (LTOPT .EQ. 0) then                                 *
C*               (0): pipelined ring vector broadcast using simple     *
C*                    sendrecv, where communication of data is         *
C*                    interspersed with computation using data.        *
C*               (1): pipelined ring vector broadcast using            *
C*                    "synchronous" sendrecv (send/recv | recv/send)   *
C*               (2): pipelined ring vector broadcast in which the data*
C*                    is sent on as soon as it is received.            *
C*              (>9): do nothing. When not using a pipeline algorithm, *
C*                    the broadcast is part of the forward transform.  *
C*              If (LTOPT .EQ. 1) then same options as for COMMFLT.    *
C*    BUFSFFT - number of communication buffers to be used in receive- *
C*              ahead variants of COMMFFT algorithm when transforming  *
C*              TO the Fourier domain. BUFSFFT has an effect only in   *
C*              the O(log P) transpose algorithm. The other algorithms *
C*              do not need additional buffers to enable receive-ahead.*
C*              Receive-ahead for the O(log P) algorithm is invoked by *
C*              specifying BUFSFFT > 2 and nonblocking receives. (See  *
C*              description of PROTFFT.)                               *
C*    BUFSIFT - number of communication buffers to be used in receive- *
C*              ahead variants of COMMIFT algorithm when transforming  *
C*              FROM the Fourier domain. BUFSIFT has an effect only in *
C*              the O(log P) transpose algorithm. The other algorithms *
C*              do not need additional buffers to enable receive-ahead.*
C*              Receive-ahead for the O(log P) algorithm is invoked by *
C*              specifying BUFSIFT > 2 and nonblocking receives. (See  *
C*              description of PROTIFT.)                               *
C*    BUFSFLT - number of communication buffers to be used in receive- *
C*              ahead variants of COMMFLT algorithm when transforming  *
C*              TO the spectral domain. BUFSFLT has no effect in the   *
C*              O(P) transpose and (unpipelined) ring vector sum       *
C*              algorithms, which do not need additional buffers to    *
C*              enable receive-ahead. For the other algorithms,        *
C*              receive-ahead is invoked by specifying BUFSFLT > 1 (for*
C*              vector sums) or > 2 (for O(log P) transpose) and       *
C*              nonblocking receives. (See description of PROTFLT.)    *
C*    BUFSILT - number of communication buffers to be used in receive- *
C*              ahead variants of COMMILT algorithm when transforming  *
C*              FROM the spectral domain. BUFSILT has an effect only in*
C*              the O(log P) transpose algorithm and the pipelined ring*
C*              vector broadcast algorithm. The other algorithms either*
C*              do not need additional buffers to enable receive-ahead,*
C*              or perform no interprocessor communication during this *
C*              phase. Receive-ahead for the O(log P) and pipelined    *
C*              algorithms is invoked by specifying BUFSIFT > 2 and    *
C*              nonblocking receives. (See description of PROTILT.)    *
C*    BUFSWS2 - amount of work space in WS2, in units of number of     *
C*              "standard" size WS2 buffers. BUFSWS2 is a function of  *
C*              BUFSFFT, etc., and so is included among the algorithm  *
C*              specification parameters. See the routines ALGINP and  *
C*              INPUT for more information on the relationship.        *
C*    BUFSWS3 - amount of work space in WS3, in units of number of     *
C*              "standard" size WS3 buffers. BUFSWS3 is a function of  *
C*              BUFSFFT, etc., and so is included among the algorithm  *
C*              specification parameters. See the routines ALGINP and  *
C*              INPUT for more information on the relationship.        *
C*    PROTFFT - communication protocol to be used with the parallel    *
C*              algorithm specified by FTOPT in the transform TO the   *
C*              Fourier domain. Current options are blocking send      *
C*              (0,2,4), nonblocking send (1,3,5), forcetypes (4,5),   *
C*              and synchronous (6). Not all protocols are legal with  *
C*              all communication options.                             *
C*    PROTIFT - communication protocol to be used with the parallel    *
C*              algorithm specified by FTOPT in the transform FROM the *
C*              Fourier domain. Current options are blocking send      *
C*              (0,2,4), nonblocking send (1,3,5), forcetypes (4,5),   *
C*              and synchronous (6). Not all protocols are legal with  *
C*              all communication options.                             *
C*    PROTFLT - communication protocol to be used with the parallel    *
C*              algorithm specified by LTOPT in the transform TO the   *
C*              spectral domain. Current options are blocking send     *
C*              (0,2,4), nonblocking send (1,3,5), forcetypes (4,5),   *
C*              and synchronous (6). Not all protocols are legal with  *
C*              all communication options.                             *
C*    PROTILT- communication protocol to be used with the parallel     *
C*              algorithm specified by LTOPT in the transform FROM the *
C*              spectral domain. Current options are blocking send     *
C*              (0,2,4), nonblocking send (1,3,5), forcetypes (4,5),   *
C*              and synchronous (6). Not all protocols are legal with  *
C*              all communication options.                             *
C*    FORCETYPE - message type offset used in Intel iPSC machines to   *
C*              specify a "no-protocol" message. When used in a send,  *
C*              the message is only accepted at the destination if the *
C*              corresponding receive has already been posted. If the  *
C*              user (manually) takes care that this will occur,       *
C*              forcetype messages often incur less overhead.          *
C*    SUMOPT -  option specifying order of summation in local vector   *
C*              sum calculations. Options are in-place linear          *
C*              ordering (0) and binary tree ordering (1). Options are *
C*              provided to "increase" reproducibility of results.     *
C*    EXCHSIZE - message size (in reals) below which an exchange sum   *
C*              algorithm is to be used instead of a recursive halving *
C*              sum algorithm (COMMFLT .EQ. 20 or 21). For example. an *
C*              exchange sum will be more efficient when the message   *
C*              startup cost is larger than the incremental            *
C*              transmission cost to send a message of a given size.   *
C*    MESHOPT -  option specifying the mapping between the logical     *
C*              2-D processor mesh and the physical processor          *
C*              numbering. Nine options are currently supported:       *
C*               (0): read mapping from disk file                      *
C*               (1 to 4): row major orderings                         *
C*               (-1 to -4): column major orderings                    *
C*              where ABS(MESHOPT) signifies                           *
C*               (1): row linear/column linear                         *
C*               (2): row linear/column Gray code                      *
C*               (3): row Gray code/column linear                      *
C*               (4): mapping row (column) to a logical subgrid in     *
C*                    the linear/linear mapping                        *
C***********************************************************************
      INTEGER FTOPT, LTOPT, COMMFFT, COMMIFT, COMMFLT, COMMILT, 
     &        BUFSFFT, BUFSIFT, BUFSFLT, BUFSILT, BUFSWS2, BUFSWS3,
     &        PROTFFT, PROTIFT, PROTFLT, PROTILT, FORCETYPE, 
     &        SUMOPT, EXCHSIZE, MESHOPT
      COMMON  / ALGORITHM / 
     &        FTOPT, LTOPT, COMMFFT, COMMIFT, COMMFLT, COMMILT,
     &        BUFSFFT, BUFSIFT, BUFSFLT, BUFSILT, BUFSWS2, BUFSWS3,
     &        PROTFFT, PROTIFT, PROTFLT, PROTILT,
     &        FORCETYPE, SUMOPT, EXCHSIZE, MESHOPT
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
