.TH CHECKSUM 1L "06 May 1994" "Version 1.06"
.\"======================================================================
.\"  @Troff-man-file{
.\"     author              = "Robert M. Solovay",
.\"     version             = "1.06",
.\"     date                = "06 May 1994",
.\"     time                = "12:11:43 MDT",
.\"     filename            = "checksum.man",
.\"     address             = "Department of Mathematics
.\"                            University of California
.\"                            Berkeley, CA, USA
.\"                            Tel: (415) 642-2252",
.\"     checksum            = "30329 246 1136 7894",
.\"     email               = "solovay@math.berkeley.edu (Internet)",
.\"     codetable           = "ISO/ASCII",
.\"     keywords            = "checksum",
.\"     supported           = "yes",
.\"     docstring           = "The checksum utility provides for the
.\"                            installing, or verification, of a file
.\"                            checksum.
.\"
.\"                            The checksum field above contains the
.\"                            output of the checksum program itself.
.\"                            It consists of a CRC-16 checksum,
.\"                            followed by the count of lines, words,
.\"                            and characters, similar to that
.\"                            produced by the standard UNIX wc (word
.\"                            count) utility.  Indeed, wc can be used
.\"                            to verify the last three parts of the
.\"                            checksum in the absence of checksum
.\"                            itself.",
.\"  }
.\"======================================================================
.if t .ds Te T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Te TeX
.SH "NAME"
checksum \- install, or validate, file checksum
.\"======================================================================
.SH "SYNOPSIS"
.B checksum
<infile >outfile
.br
.B checksum
infile >outfile
.br
.B checksum
infile outfile
.br
.B "checksum \-c"
< infile
.br
.B "checksum \-c"
infile
.br
.B "checksum \-v"
< infile
.br
.B "checksum \-v"
infile
.PP
.B checksum
computes a 16-bit cyclic redundancy checksum (CRC)
for a file, as well as counts of the words, lines
and characters.
.PP
With no filenames on the command line,
.I stdin
and
.I stdout
are assumed.  With one filename, input is from
that file, with output to
.IR stdout .
With two filenames, input is from the first, and
output to the second.
.PP
If the checksum has previously been installed in
the input file, and the input file has not been
corrupted since then, the output file will be
identical to the input file.
.PP
With the
.B \-c
option, only an input file is expected, and it may
come from the command line, or from
.IR stdin .
.B checksum
will then compute a new checksum, and then output
on
.I stdout
only the new checksum line.  This may be convenient
for programmable editors to update a file checksum.
.PP
With the
.B \-v
option, only an input file is expected, and it may
come from the command line, or from
.IR stdin .
.B checksum
will then verify whether the checksum embedded in
the file is correct or not.  A zero status code is
returned for a correct checksum, and a non-zero
one otherwise; in UNIX, the status code may be
conveniently tested in shell scripts.  In either
case, an informative message is printed on
.IR stdout .
.\"======================================================================
.SH "DESCRIPTION"
.B checksum
will search for the first line of its input which
contains the word
.I checksum
in lowercase and no other alphabetic characters.
We refer to this line as the ``critical line'' of
the file.  If the critical line contains no
quotation marks, then the output file created is a
copy of the input file, except that the critical
line is replaced by a line where the word
.I checksum
is replaced by
.\" SunOS 4.1.1 nroff/troff formats this incorrectly,
.\" losing the entire string, so we rewrite it.
.\" .I "checksum = ""xxxxx\ lc\ wc\ cc""."
\fIchecksum = "xxxxx\ lc\ wc\ cc"\fP.
Here,
.I lc
is the number of lines in the output file, written
in decimal.  Similarly,
.I wc
is the word count of the output file, and
.I cc
is the character count when the end of line
character is taken to be the single character
ASCII newline (octal 012).
.PP
For many text files, it is possible to
hide the ``critical line'' in a comment
near the beginning of the file.
.PP
It is difficult to arrange that a file contains
its own checksum.  Instead, the field
.I xxxxx
contains the checksum, written in decimal in a
five-digit field (with possible leading 0's) of
the file obtained from the output file by
replacing the field containing the checksum by the
string
.IR ZZZZZ .
.PP
If the critical line already contains after the
word ``checksum'' precisely two quotation marks,
and the first is the last character of the
four-character string ``\ =\ "''
(i.e. <blank><equals><blank><quotation mark>)
then the material between the two quotation marks
will be deleted and replaced by a checksum and
three counts as described above.
.PP
While the counts of words, characters, and lines
could be obtained by the UNIX
.BR wc(1)
utility, that information is still not sufficient
to detect character substitutions, or
transpositions of characters, lines, and words.
The CRC-16 checksum remedies that, since the
resulting checksum depends on the order and value
of every single byte in the file.
.PP
.B checksum
is intended to support the reliable exchange of
text files between different computers, even ones
with different operating systems.  Thus, the
newline character sequence that terminates each
line is treated as if it were an ASCII newline
(linefeed) character, even though it may be a
carriage return, a carriage return and a line
feed, or simply an end-of-record condition in the
file, depending on the operating system and file
type.  The file checksum is therefore independent
of the particular representation of end-of-line.
.PP
Although UNIX systems have a file checksum
utility,
.BR sum(1),
the result it produces differs between UNIX
variants, and in any event, it is neither publicly
available for porting to other systems, nor
independent of the end-of-line representation.
.B checksum
is freely available.
.\"======================================================================
.SH "SEE ALSO"
.BR sum(1),
.BR wc(1).
.\"======================================================================
.SH "AUTHOR"
.nf
Robert M. Solovay
Department of Mathematics
University of California
Berkeley, CA, USA
Tel: +1 415 642 2252
Email: solovay@math.berkeley.edu
.fi
.PP
Amiga support and many typographical formatting improvements:
.nf
Andreas Scherer
Abt Wolf Strasse 17
96215 Lichtenfels
Germany
Tel: (0 95 71) 2013
.fi
.PP
General maintenance for the \*(Te\& Users Group:
.nf
Nelson H. F. Beebe
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
USA
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: beebe@math.utah.edu (Internet)
.fi
.SH "AVAILABILITY"
The master source distribution for
.B checksum
is maintained on the Internet archive host
.I ftp.math.utah.edu
(University of Utah, Salt Lake City, UT, USA)
in the anonymous ftp directory path
.IR /pub/tex/checksum .
Copies should be mirrored from there to the Comprehensive \*(Te\&
Archive Network hosts, which include at least these machines:
.I tex.ac.uk
(Aston University, Birmingham, UK),
.I ftp.uni-stuttgart.de
(University of Stuttgart, Stuttgart, Germany),
and
.I pip.shsu.edu
(Sam Houston State University, Huntsville, Texas, USA).  On each of
these machines, you should be able to locate this software in the
archives with the ftp command
.IR "quote site index checksum" .
.\"==============================[The End]==============================
