%%% ====================================================================
%%%  @@C-Web-file{
%%%     author          = "Andreas Scherer",
%%%     version         = "0.3",
%%%     date            = "06 May 1994",
%%%     time            = "12:57:23 MDT",
%%%     filename        = "checksum.ch",
%%%     address         = "Abt-Wolf-Stra{\ss}e 17
%%%                        96215 Lichtenfels
%%%                        Germany
%%%                        Tel: [++49] (0) 9571 / 2013",
%%%     checksum        = "20061 1169 4974 39315",
%%%     codetable       = "ISO/ASCII",
%%%     keywords        = "checksum"
%%%     supported       = "yes",
%%%     docstring       = "The checksum field above contains a CRC-16
%%%                        checksum as the first value, followed by the
%%%                        equivalent of the standard UNIX wc (word
%%%                        count) utility output of lines, words, and
%%%                        characters.  This is produced by checksum
%%%                        itself.",
%%%  }
%%% ====================================================================

%%% Revision history (reverse time order):
%%%
%%% 0.3 [06-May-1994] Nelson H. F. Beebe, University of Utah
%%%     Add support for C++ compilation.
%%%     Make constant strings const,
%%%     Add support for -c option to output only the checksum line.
%%%     These changes are flagged by [NHFB] on, or immediately before,
%%%     @x lines.  All other improvements are due to Andreas Scherer,
%%%     marked [AS] on or before @x lines when both authors
%%%     contributed to a change.
%%%
%%% 0.2 [15-Mar-1994]
%%%     Global beautification of the printed documentation.
%%%
%%% 0.1 [15-Mar-1994]
%%%     Beautifications in section 56 (CRC table)
%%%
%%% 0.0 [14-Mar-1994]
%%%     Modifications for use on AMIGA.
%%%     Put C material in comments into `|' signs.
%%%
%%% ====================================================================

------------------------------------------------------------------------
@x l.27
%%% Revision history (reverse time order):
@y
%%% Revision history (reverse time order):
%%%
%%% 1.06 [06-May-1994] [NHFB]
%%%     Add support for C++ compilation.  Add new -c option.  Output
%%%     filenames in messages.  Use const strings were possible.
%%%
%%% 1.05 [14-Mar-1993] [AS]
%%%     Add support for Commodore AMIGA.
@z
------------------------------------------------------------------------
@x l.66
that the above copyright notice appear in all copies and that both that
@y
that the above copyright notice appears in all copies and that both that
@z
------------------------------------------------------------------------
@x l.89 [NHFB] -- document new -c option
	If called with the command line:

{\tt \%checksum -v file}
@y
	If called with the command line:

{\tt \%checksum -c file}

{\parindent=0pt where {\sl file} is a file with an ``installed''
checksum, the program will output only a single line with a new
correct checksum, in the same format as the original checksum line.
This feature may be useful when the program is invoked from
programmable editors, to allow checksums to be automatically computed
and installed.}

	If called with the command line:

{\tt \%checksum -v file}
@z

------------------------------------------------------------------------
@x l.127
	The program is designed to be usable as a UNIX filter; that
@y
	The program is designed to be usable as a \UNIX/ filter; that
@z
------------------------------------------------------------------------
@x l.129
The user can indicate the choce of |stdin| or |stdout| either by
@y
The user can indicate the choice of |stdin| or |stdout| either by
@z
------------------------------------------------------------------------
@x l.151
other standard header files.  Until all C implementations reach
the level of the 1989 ANSI C standard, we have to be careful about
which files we try to include.  The GNU C compiler defines the
@y
other standard header files.  Until all \CEE/ implementations reach
the level of the 1989 {\mc ANSI C} standard, we have to be careful about
which files we try to include.  The {\mc GNU C} compiler defines the
@z
------------------------------------------------------------------------
@x l.155 [NHFB] -- add C++ support
@f CheckSum int
@<Global |#in...@>=
#include <stdio.h>
#include <ctype.h>
#if defined(__STDC__) && !defined(__GNUC__)
@y
However, in 1994, Standard-conforming implementations are generally
available, so assume that {\mc GNU C} implementations now have the {\mc
Standard C} header files.  \CEE/++ compilers are common, so add support
for them; they are supposed to define the symbol |__cplusplus|, but a
few older \CEE/++ define the symbol |c_plusplus|, so we check for that
as well.  It is important here to use the |defined()| function, rather
than testing the value of |__cplusplus| directly: although the Ellis
\& Stroustrup \CEE/++ language draft implies that this symbol should
have a non-zero value, at least one compiler, {\mc Sun C++ 3.0}
defines it to an empty string.  While Sun will fix this bug in the
next version of the compiler, its impact will be widely felt.
@f CheckSum int
@<Global |#in...@>=
#include <stdio.h>
#include <ctype.h>

#ifndef SEEK_SET
#define	SEEK_SET	0
#endif

#if defined(__STDC__) || defined(__GNUC__) || defined(__TURBOC__) || \
    defined(MSDOS) || defined(__cplusplus) || defined(c_plusplus)
#define STDC 1
#else
#define STDC 0
#endif

#if defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus)
@z
------------------------------------------------------------------------
@x l.181 [NHFB] -- add C++ support
#if defined(__STDC__)||defined(__GNUC__)||defined(__TURBOC__)||defined(MSDOS)
#define ARGS(plist) plist
#else
#define ARGS(plist) ()
#endif
@y
#if STDC
#define ARGS(plist) plist
#else
#define ARGS(plist) ()
#define const
#endif
@z
------------------------------------------------------------------------
@x l.188
CheckSum add_a_byte_to_checksum ARGS((unsigned int new_byte,CheckSum
oldCheckSum));@/
int critical ARGS((char *s));
int main ARGS((int argc,char * *argv));@/
CheckSum merge_three_checksums ARGS((CheckSum s,CheckSum t,CheckSum u));
CheckSum MultiplyTwoPolys ARGS((CheckSum u,CheckSum v));@/
unsigned long int word_count ARGS((char *s));
@y
CheckSum add_a_byte_to_checksum ARGS((unsigned int new_byte,CheckSum
oldCheckSum));@/
int critical ARGS((const char *s));@/
int main ARGS((int argc,char * *argv));@/
CheckSum merge_three_checksums ARGS((CheckSum s,CheckSum t,CheckSum u));@/
CheckSum MultiplyTwoPolys ARGS((CheckSum u,CheckSum v));@/
unsigned long int word_count ARGS((const char *s));
@z
------------------------------------------------------------------------
@x l.196 [AS] -- formatting, and  [NHFB] -- remember input file name
@ Now we come to the general layout of the |main| function.  The
|status| variable communicates to the operating system if the run was
successful or not, and |prog_name| is used in case there's an error message to
be printed.

@d OK 0
@d usage_error 1
@d cannot_open_read_file 2
@d cannot_open_write_file 4
@d error_reading_input_file 8
@d cannot_open_temporary_file 16
@<Global variables@>=
int status=OK; /* exit status of command */
char *prog_name;
@y
@ Now we come to the general layout of the |main| function.
@<Global variables@>=
const char *prog_name;
const char *input_filename;
@z
------------------------------------------------------------------------
@x l.212 [NHFB] -- add C++ support
int
main (argc,argv)
int argc;
char **argv;
@y
#if STDC
int
main (int argc, char **argv)
#else
int
main (argc,argv)
int argc;
char **argv;
#endif
@z
------------------------------------------------------------------------
@x l.218
	@<Variables local to |main|@>@/
@y
	@<Variables local to |main|@>@;
@z
------------------------------------------------------------------------
@x l.225
	@<Parse the command@>@/
	@<Open the input and output files@>@/
	@<Process the input file@>@/
	@<Do endgame procedures@>@/
	if (mode == COMPUTING){@<Do second pass on input file@>}@/
	@<Close all files@>@/
	if (status != 0)
	    exit(EXIT_FAILURE);
	else
	    exit(verify_successful ? EXIT_SUCCESS : EXIT_FAILURE);
	return(0);
@y
	@<Parse the command@>@;
	@<Open the input and output files@>@;
	@<Process the input file@>@;
	@<Do endgame procedures@>@;
	if (mode == COMPUTING)@<Do second pass on input file@>@;
	@<Close all files@>@;
	return(verify_successful ? EXIT_SUCCESS : EXIT_FAILURE);
@z
------------------------------------------------------------------------
@x l.242 [AS] -- formatting, and [NHFB] -- add support for -c option
@d COMPUTING 1
@<Variables local to |main|@>=
int mode = COMPUTING;
@ The mode will be |VERIFY| iff the variable |argc| is $\geq 2$ and
the second ``argument'' is |"-v"|. In any case we should have |argc|
$\leq 3$. We update |argc| and |argv| to reflect the arguments already
``consumed''.
@<Parse the command@>=
if(argc > 3){@<Complain about improper command format@>}
else if ( (argc >= 2) && !(strcmp(argv[1], "-v")))
{mode = VERIFY; argc -= 2; argv += 2;}
else{argc--;argv++;}
@y
@d COMPUTING 1
@d CHECKSUM_ONLY 2
@<Variables local to |main|@>=
int mode = COMPUTING;
@ The mode will be |CHECKSUM_ONLY| iff the variable |argc| is $\geq 2$
and the second ``argument'' is |"-c"|.  The mode will be |VERIFY| iff
the variable |argc| is $\geq 2$ and the second ``argument'' is |"-v"|.
In any case we should have |argc| $\leq 3$. We update |argc| and
|argv| to reflect the arguments already ``consumed''.
@<Parse the command@>=
if (argc > 3)
  @<Complain about improper command format@>@;
else if ( (argc >= 2) && !(strcmp(argv[1], "-c"))) {
  mode = CHECKSUM_ONLY; argc -= 2; argv += 2;
}
else if ( (argc >= 2) && !(strcmp(argv[1], "-v"))) {
  mode = VERIFY; argc -= 2; argv += 2;
}
else {
  argc--; argv++;
}
@z
------------------------------------------------------------------------
@x l.280
@

Next we describe the main loop when we are in |COMPUTING| mode. As we
@y
@ Next we describe the main loop when we are in |COMPUTING| mode. As we
@z
----------------------------------------------------------------------
@x l.341
done reading the input file, and the module \.{<Do endgame procedures>}
@y
done reading the input file, and the module |@<Do endgame procedures@>|
@z
------------------------------------------------------------------------
@x l.354
while(  fgets(current_line,257,input_file) != NULL)@/
{
current_line_is_critical = 0; /*Reset this flag.*/
if (found_critical_line == 0)@<Check if current line is critical line
and set flags appropriately@>@/
if(current_line_is_critical){@<Process critical line@>}@/
@<Write line to output file if appropriate@>@/
@<Update counts@>@/
@<Update checksums@>@/
}@/
if (!feof(input_file))@<Signal error while reading input file and abort@>@/
@y
while(  fgets(current_line,257,input_file) != NULL)
{
current_line_is_critical = 0; /*Reset this flag.*/
if (found_critical_line == 0)@<Check if current line is critical line
and set flags appropriately@>@;
if(current_line_is_critical)@<Process critical line@>@;
@<Write line to output file if appropriate@>@;
@<Update counts@>@;
@<Update checksums@>@;
}
if (!feof(input_file))@<Signal error while reading input file and abort@>@;
@z
----------------------------------------------------------------------
@x l.390 [AS] -- formatting, and [NHFB] -- C++ support
@
@<All functions@>=

int critical(s)
	char *s;
@y
@ @<All functions@>=

#if STDC
int critical(const char *s)
#else
int critical(s)
	const char *s;
#endif
@z
----------------------------------------------------------------------
@x l.396
	@<Variables for ``critical''@>@/
        @<Code for ``critical''@>@/
@y
	@<Variables for ``critical''@>@;
        @<Code for ``critical''@>@;
@z
------------------------------------------------------------------------
@x l.399
@

The variable |i| is a state variable which takes a value in the range
@y
@ The variable |i| is a state variable which takes a value in the range
@z
------------------------------------------------------------------------
@x l.419 [NHFB] -- add const modifier to chksm
	char *chksm = "checksum";
@y
	const char *chksm = "checksum";
@z
------------------------------------------------------------------------
@x l.426
line. If it is not, we bail out and return 0. If it is we set the
@y
line. If it is not, we bail out and return~0. If it is we set the
@z
------------------------------------------------------------------------
@x l.490 [NHFB] -- remove compiler warnings about = instead of ==
if( answer_from_critical=critical(current_line))
@y
if( (answer_from_critical=critical(current_line), answer_from_critical) )
@z
------------------------------------------------------------------------
@x l.501
if((mode == COMPUTING) && !input_from_pipe)
{@<Store current location in input file@>}@/
else if (mode == VERIFY)
{@<Adjust current line@>}@/
@y
if((mode == COMPUTING) && !input_from_pipe)
@<Store current location in input file@>@;
else if (mode == VERIFY)
@<Adjust current line@>@;
@z
------------------------------------------------------------------------
@x l.507
@
@<Variables local to ...@>=
int i;
@
@<Adjust current line@>=
for(i = 1; i<6;i++) current_line[loc_first_quote_mark  + i] = 'Z';


@
@<Store current location...@>=
loc_critical_line  = ftell(input_file);
@y
@ @<Variables local to ...@>=
int i;

@ @<Adjust current line@>=
for(i = 1; i<6;i++) current_line[loc_first_quote_mark  + i] = 'Z';

@ @<Store current location...@>=
loc_critical_line  = ftell(input_file);
@z
------------------------------------------------------------------------
@x l.540 [AS] -- formatting, and [NHFB] -- C++ support
}
@

@<All functions@>=

unsigned long int word_count(s)
	char *s;@/
@y
}
@ @<All functions@>=

#if STDC
unsigned long int word_count(const char *s)@/
#else
unsigned long int word_count(s)
	const char *s;@/
#endif
@z
------------------------------------------------------------------------
@x l.560
	return( (unsigned long int)word_cnt);
	}

@

Our checksum can be computed ``a byte at a time''. Thus if the
@y
	return( (unsigned long int)word_cnt);
	}

@ Our checksum can be computed ``a byte at a time''. Thus if the
@z
------------------------------------------------------------------------
@x l.583
 if ( mode == VERIFY ||!found_critical_line) {@<Update one
checksum@>}@/
 else
if(!current_line_is_critical) {@<Update two checksums@>}
@y
 if ( mode == VERIFY ||!found_critical_line)
   @<Update one checksum@>@;
 else if(!current_line_is_critical)
   @<Update two checksums@>@;
@z
------------------------------------------------------------------------
@x l.588
@
@<Update one checksum@>=
@y
@ @<Update one checksum@>=
@z
------------------------------------------------------------------------
@x l.593
 @
@<Update two...@>=
@y
@ @<Update two...@>=
@z
------------------------------------------------------------------------
@x l.608
@<Do second pass on...@>=
if (!input_from_pipe)
fseek(input_file,loc_critical_line,SEEK_SET);
else
{
rewind(temp_file);
fclose(input_file);
input_file = temp_file;
}
while(fgets(current_line,257,input_file) != NULL)
fputs(current_line,output_file);
if (!feof(input_file))
@<Signal error while reading input file and abort@>@/
@y
@<Do second pass on...@>={
if (!input_from_pipe)
fseek(input_file,loc_critical_line,SEEK_SET);
else
{
rewind(temp_file);
fclose(input_file);
input_file = temp_file;
}
while(fgets(current_line,257,input_file) != NULL)
fputs(current_line,output_file);
if (!feof(input_file))
@<Signal error while reading input file and abort@>@;
}
@z
------------------------------------------------------------------------
@x l.625 [AS] -- formatting, and [NHFB] -- add support for -c option
if(mode == COMPUTING){@<Do |COMPUTING| endgame procedures@>}@/
else {@<Do |VERIFY| endgame procedures@>}
@
@<Do |COM...@>=
@<Split |critical_line| into two strings@>@/
@<Install the dummy checksum into the critical line.@>@/
@<Compute the final line count and install it.@>@/
@<Compute the final word count and install it@>@/
@<Compute the final character count and install it@>@/
@<Compute the correct checksum and install it@>@/
@<Write the critical line to the output file@>@/
@y
if(mode == COMPUTING)@<Do |COMPUTING| endgame procedures@>@;
else if(mode == CHECKSUM_ONLY)@<Do |COMPUTING| endgame procedures@>@;
else @<Do |VERIFY| endgame procedures@>@;
@ @<Do |COM...@>={
@<Split |critical_line| into two strings@>@;
@<Install the dummy checksum into the critical line.@>@;
@<Compute the final line count and install it.@>@;
@<Compute the final word count and install it@>@;
@<Compute the final character count and install it@>@;
@<Compute the correct checksum and install it@>@;
@<Write the critical line to the output file@>@;
}
@z
------------------------------------------------------------------------
@x l.636
@

A major part of the work of the |COMPUTING| endgame procedures is in
@y
@ A major part of the work of the |COMPUTING| endgame procedures is in
@z
------------------------------------------------------------------------
@x l.664 [AS], plus [NHFB] -- add const modifier to quote_pattern
@<Split...@>=
temp_buf = current_line;
switch (answer_from_critical) {
@ The first case to consider is when |answer_from_critical| $=0$. This
case ``can't happen'' so we print an appropriate error message and
exit the program.
@<Split...@>=
	case 0:{@<Issue complaint about the bad format of the input file@>}@/
break;
@ For the second case, the line does not contain the pattern |" = \""|
after the word |"checksum"|, We will put the portion of the critical
line after the word |"checksum"| in the buffer |temp_buf|, and place
the string |" = \""| after the end of the word |"checksum"| followed
by a null character.
@<Variables local to |main|@>=
char *quote_pattern = " = \"";
@
@<Split...@>=
	case 1:strcpy(temp_buf,critical_line + (loc_chksum + 8));
	critical_line[loc_chksum + 8] = 0;
	strcat(critical_line,quote_pattern);
	loc_first_quote_mark = loc_chksum + 11;
	break;
@ The next case is when we can find the pattern |" = \""| in the
critical line but not a following ``quote''. In that case, we split at
the quote mark of the pattern |" = \""|.
@<Split...@>=
	case 2:strcpy(temp_buf,critical_line + (loc_first_quote_mark
+1));
	critical_line[loc_first_quote_mark + 1] = 0;
	break;
@ In the final case, we can find both the pattern |" = \""| and a
following ``quote-mark''. We store the portion of the critical line
after the second ``quote-mark'' in |temp_buf| and put a null character
in the buffer |critical_line| after the first ``quote-mark''. This has
the effect of erasing the text that is between the two ``quote-marks''
in the input file. It will be replaced by the new checksum and counts
in the later portions of the program.
@<Split...@>=
	case 3:strcpy(temp_buf,critical_line + (loc_second_quote_mark
+1));
	critical_line[loc_first_quote_mark +1] = 0;
	break;} /* end of switch*/
@y
@<Split...@>=
temp_buf = current_line;
switch (answer_from_critical) {
case 0: @<Issue complaint about the bad format of the input file@>@;
  @+ break;
case 1: @<Missing checksum pattern@>@;
  @+ break;
case 2: @<Missing quote after the pattern@>@;
  @+ break;
case 3: @<Normal case for pattern match@>@;
  @+ break;
  }

@ This is a dummy section.  Its contents is |@<Issue...@>|.

@ For the second case, the line does not contain the pattern |" = \""|
after the word |"checksum"|, We will put the portion of the critical
line after the word |"checksum"| in the buffer |temp_buf|, and place
the string |" = \""| after the end of the word |"checksum"| followed
by a null character.
@<Variables local to |main|@>=
const char *quote_pattern = " = \"";

@ @<Missing checksum pattern@>=
	strcpy(temp_buf,critical_line + (loc_chksum + 8));
	critical_line[loc_chksum + 8] = 0;
	strcat(critical_line,quote_pattern);
	loc_first_quote_mark = loc_chksum + 11;

@ The next case is when we can find the pattern |" = \""| in the
critical line but not a following ``quote''. In that case, we split at
the quote mark of the pattern |" = \""|.
@<Missing quote...@>=
	strcpy(temp_buf,critical_line + (loc_first_quote_mark+1));
	critical_line[loc_first_quote_mark + 1] = 0;

@ In the final case, we can find both the pattern |" = \""| and a
following ``quote-mark''. We store the portion of the critical line
after the second ``quote-mark'' in |temp_buf| and put a null character
in the buffer |critical_line| after the first ``quote-mark''. This has
the effect of erasing the text that is between the two ``quote-marks''
in the input file. It will be replaced by the new checksum and counts
in the later portions of the program.
@<Normal case...@>=
	strcpy(temp_buf,critical_line + (loc_second_quote_mark+1));
	critical_line[loc_first_quote_mark +1] = 0;
@z
------------------------------------------------------------------------
@x l.714 [AS], plus [NHFB] -- add const modifier to Zstring, one_space, and quote
char *Zstring = "ZZZZZ ";
char *one_space = " ";
char *quote = "\"";
@
@<Install the dummy...@>=
@y
const char *Zstring = "ZZZZZ ";
const char *one_space = " ";
const char *quote = "\"";
@ @<Install the dummy...@>=
@z
------------------------------------------------------------------------
@x l.732 [NHFB] -- correct spelling error
We need to keep track of our position in the line, wo we define a
@y
We need to keep track of our position in the line, so we define a
@z
------------------------------------------------------------------------
@x l.736 [AS], plus [NHFB] -- add const modifier to dummy_field_pattern
char *dummy_field_pattern = "B C\"";
@

@<Compute the final word count...@>=
@y
const char *dummy_field_pattern = "B C\"";

@ @<Compute the final word count...@>=
@z
------------------------------------------------------------------------
@x l.761
unsigned long int cc_guess;
@
@<Compute the final character count...@>=
cc += strlen(temp_buf) + strlen(critical_line);
do
{cc_guess = cc + char_field_length + 1;
sprintf(temp_buf2,"%lu",cc_guess);
old_char_field_length = char_field_length;
char_field_length = strlen(temp_buf2);}
while(old_char_field_length != char_field_length);
strcat(critical_line,temp_buf2);
strcat(critical_line,quote);
strcat(critical_line,temp_buf);
@y
unsigned long int cc_guess;

@ @<Compute the final character count...@>=
cc += strlen(temp_buf) + strlen(critical_line);@/
do
{cc_guess = cc + char_field_length + 1;
sprintf(temp_buf2,"%lu",cc_guess);
old_char_field_length = char_field_length;
char_field_length = strlen(temp_buf2);}
while(old_char_field_length != char_field_length);@/
strcat(critical_line,temp_buf2);
strcat(critical_line,quote);
strcat(critical_line,temp_buf);
@z
------------------------------------------------------------------------
@x l.783
strncpy(critical_line + (loc_first_quote_mark + 1),temp_buf2,5);
@
@<Write the critical line...@>=
fputs(critical_line,output_file);

@

The verify ``endgame procedures'' consist in comparing the various
@y
strncpy(critical_line + (loc_first_quote_mark + 1),temp_buf2,5);

@ @<Write the critical line...@>=
fputs(critical_line,output_file);

@ The verify ``endgame procedures'' consist in comparing the various
@z
------------------------------------------------------------------------
@x l.805 [AS], plus [NHFB] -- add const modifier to format
#if vms
char *format = "%d %ld %ld %ld"; /* VMS C sscanf() doesn't support u item. */
				/* none of these numbers overflow into the */
				/* sign bit on the VAX, so use %d instead */
#else
char *format = "%u %lu %lu %lu";
#endif
@y
#if vms
const char *format = "%d %ld %ld %ld";
   /* {\mc VMS C} |sscanf()| doesn't support |"u"| item. */
   /* none of these numbers overflow into the */
   /* sign bit on the {\mc VAX}, so use |"%d"| instead */
#else
const char *format = "%u %lu %lu %lu";
#endif
@z
------------------------------------------------------------------------
@x l.811 [NHFB] -- add const modifier
char *position_in_line;
@y
const char *position_in_line;
@z
------------------------------------------------------------------------
@x l.815 [AS] -- formatting, and [NHFB] -- print input file name in messages
@<Do |VERIFY| endgame procedures@>=
if(!found_critical_line)
{printf("The input file did not have the correct format.\n");
exit(EXIT_FAILURE);}
position_in_line = critical_line + loc_first_quote_mark + 1;
if ( 4 != sscanf(position_in_line,format, &stored_chksum, &stored_lc,
	&stored_wc, &stored_cc))
{printf("The input file did not have the correct format.\n");
exit(EXIT_FAILURE);}
verify_successful = (chksum == stored_chksum && wc == stored_wc &&
	lc == stored_lc && cc == stored_cc);
if(verify_successful)
printf("The checksum verification of the input file was successful.\n");
else
printf("The checksum verification of the input file did not succeed.\n");
@y
@<Do |VERIFY| endgame procedures@>={
if(!found_critical_line)
{printf("The input file did not have the correct format.\n");
exit(EXIT_FAILURE);}
position_in_line = critical_line + loc_first_quote_mark + 1;
if ( 4 != sscanf(position_in_line,format, &stored_chksum, &stored_lc,
	&stored_wc, &stored_cc))
{printf("The input file did not have the correct format.\n");
exit(EXIT_FAILURE);}
verify_successful = (chksum == stored_chksum && wc == stored_wc &&
	lc == stored_lc && cc == stored_cc);
if(verify_successful)
printf("The checksum verification of the input file %s was successful.\n",
        input_filename);
else
printf("The checksum verification of the input file %s did not succeed.\n",
        input_filename);
}
@z
------------------------------------------------------------------------
@x l.853
various functions needed to compute CRC checksums.

@

For an excellent discussion of the ideas involved in the CRC checksum,
@y
various functions needed to compute CRC checksums.

@ For an excellent discussion of the ideas involved in the CRC checksum,
@z
------------------------------------------------------------------------
@x l.876
less than $16$.
@y
less than~$16$.
@z
------------------------------------------------------------------------
@x l.922
$r_1 X^8 + r_2$ where $r_1$ and $r_2$ are polynomials of degree at
most $7$ in $\Zt[X]$, then $r_1$ and $r_2$ correspond respectively to
the high-order byte and low-order byte of the unsigned integer
corresponding to $r$.
@y
$r_1 X^8 + r_2$ where~$r_1$ and~$r_2$ are polynomials of degree at
most $7$ in $\Zt[X]$, then $r_1$ and $r_2$ correspond respectively to
the high-order byte and low-order byte of the unsigned integer
corresponding to~$r$.
@z
------------------------------------------------------------------------
@x l.941
computed in the program described in the CWeb file {\tt polynom.w}
@y
computed in the program described in the \.{CWEB} file {\tt polynom.w}
@z
------------------------------------------------------------------------
@x l.946
static CheckSum crc_table[] =
{
0x0000, 0x8005, 0x800f, 0x000a, 0x801b, 0x001e, 0x0014, 0x8011,
0x8033, 0x0036, 0x003c, 0x8039, 0x0028, 0x802d, 0x8027, 0x0022,
0x8063, 0x0066, 0x006c, 0x8069, 0x0078, 0x807d, 0x8077, 0x0072,
0x0050, 0x8055, 0x805f, 0x005a, 0x804b, 0x004e, 0x0044, 0x8041,
0x80c3, 0x00c6, 0x00cc, 0x80c9, 0x00d8, 0x80dd, 0x80d7, 0x00d2,
0x00f0, 0x80f5, 0x80ff, 0x00fa, 0x80eb, 0x00ee, 0x00e4, 0x80e1,
0x00a0, 0x80a5, 0x80af, 0x00aa, 0x80bb, 0x00be, 0x00b4, 0x80b1,
0x8093, 0x0096, 0x009c, 0x8099, 0x0088, 0x808d, 0x8087, 0x0082,
0x8183, 0x0186, 0x018c, 0x8189, 0x0198, 0x819d, 0x8197, 0x0192,
0x01b0, 0x81b5, 0x81bf, 0x01ba, 0x81ab, 0x01ae, 0x01a4, 0x81a1,
0x01e0, 0x81e5, 0x81ef, 0x01ea, 0x81fb, 0x01fe, 0x01f4, 0x81f1,
0x81d3, 0x01d6, 0x01dc, 0x81d9, 0x01c8, 0x81cd, 0x81c7, 0x01c2,
0x0140, 0x8145, 0x814f, 0x014a, 0x815b, 0x015e, 0x0154, 0x8151,
0x8173, 0x0176, 0x017c, 0x8179, 0x0168, 0x816d, 0x8167, 0x0162,
0x8123, 0x0126, 0x012c, 0x8129, 0x0138, 0x813d, 0x8137, 0x0132,
0x0110, 0x8115, 0x811f, 0x011a, 0x810b, 0x010e, 0x0104, 0x8101,
0x8303, 0x0306, 0x030c, 0x8309, 0x0318, 0x831d, 0x8317, 0x0312,
0x0330, 0x8335, 0x833f, 0x033a, 0x832b, 0x032e, 0x0324, 0x8321,
0x0360, 0x8365, 0x836f, 0x036a, 0x837b, 0x037e, 0x0374, 0x8371,
0x8353, 0x0356, 0x035c, 0x8359, 0x0348, 0x834d, 0x8347, 0x0342,
0x03c0, 0x83c5, 0x83cf, 0x03ca, 0x83db, 0x03de, 0x03d4, 0x83d1,
0x83f3, 0x03f6, 0x03fc, 0x83f9, 0x03e8, 0x83ed, 0x83e7, 0x03e2,
0x83a3, 0x03a6, 0x03ac, 0x83a9, 0x03b8, 0x83bd, 0x83b7, 0x03b2,
0x0390, 0x8395, 0x839f, 0x039a, 0x838b, 0x038e, 0x0384, 0x8381,
0x0280, 0x8285, 0x828f, 0x028a, 0x829b, 0x029e, 0x0294, 0x8291,
0x82b3, 0x02b6, 0x02bc, 0x82b9, 0x02a8, 0x82ad, 0x82a7, 0x02a2,
0x82e3, 0x02e6, 0x02ec, 0x82e9, 0x02f8, 0x82fd, 0x82f7, 0x02f2,
0x02d0, 0x82d5, 0x82df, 0x02da, 0x82cb, 0x02ce, 0x02c4, 0x82c1,
0x8243, 0x0246, 0x024c, 0x8249, 0x0258, 0x825d, 0x8257, 0x0252,
0x0270, 0x8275, 0x827f, 0x027a, 0x826b, 0x026e, 0x0264, 0x8261,
0x0220, 0x8225, 0x822f, 0x022a, 0x823b, 0x023e, 0x0234, 0x8231,
0x8213, 0x0216, 0x021c, 0x8219, 0x0208, 0x820d, 0x8207, 0x0202,
};



@

The following is the function definition for |add_a_byte_to_checksum|.
@y
static CheckSum crc_table[] =
{@t}\3{-5@>
0x0000, 0x8005, 0x800f, 0x000a, 0x801b, 0x001e, 0x0014, 0x8011,@|
0x8033, 0x0036, 0x003c, 0x8039, 0x0028, 0x802d, 0x8027, 0x0022,@|
0x8063, 0x0066, 0x006c, 0x8069, 0x0078, 0x807d, 0x8077, 0x0072,@|
0x0050, 0x8055, 0x805f, 0x005a, 0x804b, 0x004e, 0x0044, 0x8041,@|
0x80c3, 0x00c6, 0x00cc, 0x80c9, 0x00d8, 0x80dd, 0x80d7, 0x00d2,@|
0x00f0, 0x80f5, 0x80ff, 0x00fa, 0x80eb, 0x00ee, 0x00e4, 0x80e1,@|
0x00a0, 0x80a5, 0x80af, 0x00aa, 0x80bb, 0x00be, 0x00b4, 0x80b1,@|
0x8093, 0x0096, 0x009c, 0x8099, 0x0088, 0x808d, 0x8087, 0x0082,@|
0x8183, 0x0186, 0x018c, 0x8189, 0x0198, 0x819d, 0x8197, 0x0192,@|
0x01b0, 0x81b5, 0x81bf, 0x01ba, 0x81ab, 0x01ae, 0x01a4, 0x81a1,@|
0x01e0, 0x81e5, 0x81ef, 0x01ea, 0x81fb, 0x01fe, 0x01f4, 0x81f1,@|
0x81d3, 0x01d6, 0x01dc, 0x81d9, 0x01c8, 0x81cd, 0x81c7, 0x01c2,@|
0x0140, 0x8145, 0x814f, 0x014a, 0x815b, 0x015e, 0x0154, 0x8151,@|
0x8173, 0x0176, 0x017c, 0x8179, 0x0168, 0x816d, 0x8167, 0x0162,@|
0x8123, 0x0126, 0x012c, 0x8129, 0x0138, 0x813d, 0x8137, 0x0132,@|
0x0110, 0x8115, 0x811f, 0x011a, 0x810b, 0x010e, 0x0104, 0x8101,@|
0x8303, 0x0306, 0x030c, 0x8309, 0x0318, 0x831d, 0x8317, 0x0312,@|
0x0330, 0x8335, 0x833f, 0x033a, 0x832b, 0x032e, 0x0324, 0x8321,@|
0x0360, 0x8365, 0x836f, 0x036a, 0x837b, 0x037e, 0x0374, 0x8371,@|
0x8353, 0x0356, 0x035c, 0x8359, 0x0348, 0x834d, 0x8347, 0x0342,@|
0x03c0, 0x83c5, 0x83cf, 0x03ca, 0x83db, 0x03de, 0x03d4, 0x83d1,@|
0x83f3, 0x03f6, 0x03fc, 0x83f9, 0x03e8, 0x83ed, 0x83e7, 0x03e2,@|
0x83a3, 0x03a6, 0x03ac, 0x83a9, 0x03b8, 0x83bd, 0x83b7, 0x03b2,@|
0x0390, 0x8395, 0x839f, 0x039a, 0x838b, 0x038e, 0x0384, 0x8381,@|
0x0280, 0x8285, 0x828f, 0x028a, 0x829b, 0x029e, 0x0294, 0x8291,@|
0x82b3, 0x02b6, 0x02bc, 0x82b9, 0x02a8, 0x82ad, 0x82a7, 0x02a2,@|
0x82e3, 0x02e6, 0x02ec, 0x82e9, 0x02f8, 0x82fd, 0x82f7, 0x02f2,@|
0x02d0, 0x82d5, 0x82df, 0x02da, 0x82cb, 0x02ce, 0x02c4, 0x82c1,@|
0x8243, 0x0246, 0x024c, 0x8249, 0x0258, 0x825d, 0x8257, 0x0252,@|
0x0270, 0x8275, 0x827f, 0x027a, 0x826b, 0x026e, 0x0264, 0x8261,@|
0x0220, 0x8225, 0x822f, 0x022a, 0x823b, 0x023e, 0x0234, 0x8231,@|
0x8213, 0x0216, 0x021c, 0x8219, 0x0208, 0x820d, 0x8207, 0x0202,@/
};

@ The following is the function definition for |add_a_byte_to_checksum|.
@z
------------------------------------------------------------------------
@x l.988 [NHFB] -- C++ support
CheckSum add_a_byte_to_checksum(new_byte,oldCheckSum)
	unsigned int new_byte;
	CheckSum oldCheckSum;
@y
#if STDC
CheckSum add_a_byte_to_checksum(unsigned int new_byte, CheckSum oldCheckSum)
#else
CheckSum add_a_byte_to_checksum(new_byte,oldCheckSum)
	unsigned int new_byte;
	CheckSum oldCheckSum;
#endif
@z
------------------------------------------------------------------------
@x l.1043 [AS] -- formatting, and [NHFB] -- C++ support
CheckSum MultiplyTwoPolys(u,v)
	CheckSum u,v;@/
	{
	CheckSum r = 0;
	int u_array[SIZE];
	int v_array[SIZE];
	int  w_array[SIZE+SIZE];
	int i,j;
	CheckSum s[4];
	for(i=0;i<SIZE;i++)
	{u_array[i] = u%2; u = u/2;
	v_array[i] = v%2; v = v/2;}
	for (i=0;i < (SIZE+SIZE);i++)
	w_array[i]=0;
	for (i = 0; i < SIZE;i++)
	for(j=0;j< SIZE; j++)
	w_array[i+j] +=  (u_array[i]*v_array[j]);
	for(i = 0; i < SIZE + SIZE; i++)
	w_array[i] = w_array[i]%2;
@
Our next task is to store the array |w_array| as an array of four
``bytes'', |s[4]|.
@<All functions@>=
for (i = 0; i < 4; i++)
{s[i] = 0;
for(j=0;j<8;j++)
s[i] = (s[i]*2) + w_array[(8*i)+(7-j)];}

@
Finally we have to reduce this polynomial to one of degree at most 15
that is its canonical image in $R$. The table |crc_table| has all the
needed information to do this expeditiously.
@<All functions@>=
for(i=3;i>1;i--)
{s[i-1] = s[i-1] ^ ((crc_table[s[i]] >> 8) & 0xff);
s[i-2] = s[i-2] ^ ((crc_table[s[i]]) & 0xff);}
	r = (s[1]<<8)^s[0];
	return(r);
}
@y
#if STDC
CheckSum MultiplyTwoPolys(CheckSum u, CheckSum v)@/
#else
CheckSum MultiplyTwoPolys(u,v)
	CheckSum u,v;@/
#endif
	{
	CheckSum r = 0;
	int u_array[SIZE];
	int v_array[SIZE];
	int  w_array[SIZE+SIZE];
	int i,j;
	CheckSum s[4];
	for(i=0;i<SIZE;i++)
	{u_array[i] = u%2; u = u/2;
	v_array[i] = v%2; v = v/2;}
	for (i=0;i < (SIZE+SIZE);i++)
	w_array[i]=0;
	for (i = 0; i < SIZE;i++)
	for(j=0;j< SIZE; j++)
	w_array[i+j] +=  (u_array[i]*v_array[j]);
	for(i = 0; i < SIZE + SIZE; i++)
	w_array[i] = w_array[i]%2;
	@<Store the array |w_array|@>@;
	@<Reduce the polynomial@>@;
}
@
Our next task is to store the array |w_array| as an array of four
``bytes'', |s[4]|.
@<Store the array...@>=
for (i = 0; i < 4; i++)
{s[i] = 0;
for(j=0;j<8;j++)
s[i] = (s[i]*2) + w_array[(8*i)+(7-j)];}

@
Finally we have to reduce this polynomial to one of degree at most 15
that is its canonical image in $R$. The table |crc_table| has all the
needed information to do this expeditiously.
@<Reduce...@>=
for(i=3;i>1;i--)
{s[i-1] = s[i-1] ^ ((crc_table[s[i]] >> 8) & 0xff);
s[i-2] = s[i-2] ^ ((crc_table[s[i]]) & 0xff);}
	r = (s[1]<<8)^s[0];
	return(r);
@z
------------------------------------------------------------------------
@x l.1084
@

The motivation for the following function is contained in the
@y
@ The motivation for the following function is contained in the
@z
------------------------------------------------------------------------
@x l.1090 [NHFB] -- C++ support
CheckSum merge_three_checksums(s,t,u)
	CheckSum s,t,u;
@y
#if STDC
CheckSum merge_three_checksums(CheckSum s, CheckSum t, CheckSum u)
#else
CheckSum merge_three_checksums(s,t,u)
	CheckSum s,t,u;
#endif
@z
------------------------------------------------------------------------
@x l.1113 [NHFB] -- correct spelling error
used, then the input is taken from |stdin|. Simarly, if the argument
@y
used, then the input is taken from |stdin|. Similarly, if the argument
@z
------------------------------------------------------------------------
@x l.1118
if  (argc == 0) {@<Input file is stdin@>}@/
else@#
@t\quad@>@+ if (!(strcmp(argv[0],"-"))){argc--;argv++;{@<Input file is
stdin@>}}@/
@t\quad@>@+else
{
if((input_file = fopen(argv[0],"r"))== NULL){@<Handle error while
opening input file@>}@/
@t\quad\quad\quad\quad@>@+else{@+argc--;argv++;@+}@+}
@y
if (argc == 0) @<Input file is stdin@>@;
else if (!(strcmp(argv[0],"-"))) {
  argc--; argv++; @<Input file is stdin@>@;
  input_filename = argv[0];
}
else {
  input_filename = argv[0];
  if ((input_file = fopen(input_filename,"r"))== NULL)
    @<Handle error while opening input file@>@;
  else {
    argc--; argv++;
  }
}
@z
------------------------------------------------------------------------
@x l.1130
if ((argc == 0) || !(strcmp(argv[0],"-"))) output_file = stdout;@/
else {if((output_file = fopen(argv[0],"w"))== NULL)@<Handle error while
		      opening output file@>}@/
@y
if ((argc == 0) || !(strcmp(argv[0],"-")))
  output_file = stdout;
else if ((output_file = fopen(argv[0],"w"))== NULL)
  @<Handle error while opening output file@>@;
@z
------------------------------------------------------------------------
@x l.1137
@<Input file is stdin@>=

input_from_pipe = 1;@/
if(mode == COMPUTING)
{if ((temp_file = tmpfile()) == NULL) {@<Error message about opening
temporary file@>}}@;@/
input_file = stdin;
@
@<Close all files@>=
@y
@<Input file is stdin@>={
input_from_pipe = 1;
if(mode == COMPUTING) {
  if ((temp_file = tmpfile()) == NULL)
    @<Error message about opening temporary file@>@;
  }
input_file = stdin;
}
@ @<Close all files@>=
@z
------------------------------------------------------------------------
[AS] -- formatting
[NHFB] -- add support for -c option and print input file name in messages
@x l.1154
@
@<Complain about...@>=
{status += usage_error;
fprintf(stderr,"%s: Command line has incorrect format.\n", prog_name);
fprintf(stderr,"%%  checksum  inputfile outputfile\n");
fprintf(stderr, "     is the format for installing a checksum in a \
file.\n");
fprintf(stderr, "%% checksum -v inputfile\n");
fprintf(stderr," is the format for verifying an installed \
checksum.\n");
exit(EXIT_FAILURE);}
@
@<Handle error while opening input...@>=
{status += cannot_open_read_file;
fprintf(stderr,"%s: cannot open input file %s\n", prog_name, *argv);
exit(EXIT_FAILURE);
}
@
@<Error message...@>=
{status += cannot_open_temporary_file;
fprintf(stderr,"%s: cannot open temporary file.\n",prog_name);
exit(EXIT_FAILURE);}
@
@<Handle error while opening output...@>=
{status += cannot_open_write_file;
fprintf(stderr,"%s: cannot open output file %s\n", prog_name, *argv);
exit(EXIT_FAILURE);
}
@
@<Signal error while reading input file and abort@>=
{status += error_reading_input_file;
fprintf(stderr, "%s: Error encountered while reading input file.\n",
prog_name); exit(EXIT_FAILURE);}
@
@<Issue ...@>=
{status += usage_error;
fprintf(stderr, "The input file did not have the correct format.\n");
fprintf(stderr, "It should contain a line which has the word \
\"checksum\"\n");
fprintf(stderr,"and no other alphabetic characters.\n");
exit(EXIT_FAILURE);}
@y
@ @<Complain about...@>=
{
fprintf(stderr,"%s: Command line has incorrect format.\n", prog_name);
fprintf(stderr,"%%  checksum  inputfile outputfile\n");
fprintf(stderr, "     is the format for installing a checksum in a \
file.\n");
fprintf(stderr, "%% checksum -c inputfile\n");
fprintf(stderr," is the format for output of just the checksum line.\n");
fprintf(stderr, "%% checksum -v inputfile\n");
fprintf(stderr," is the format for verifying an installed \
checksum.\n");
exit(EXIT_FAILURE);}

@ @<Handle error while opening input...@>=
{
fprintf(stderr,"%s: cannot open input file %s\n", prog_name, input_filename);
exit(EXIT_FAILURE);
}

@ @<Error message...@>=
{
fprintf(stderr,"%s: cannot open temporary file.\n",prog_name);
exit(EXIT_FAILURE);}

@ @<Handle error while opening output...@>=
{
fprintf(stderr,"%s: cannot open output file %s\n", prog_name, *argv);
exit(EXIT_FAILURE);
}

@ @<Signal error while reading input file and abort@>=
{
fprintf(stderr, "%s: Error encountered while reading input file %s.\n",
prog_name,input_filename); exit(EXIT_FAILURE);}

@ The first case to consider is when |answer_from_critical| $=0$. This
case ``can't happen'' so we print an appropriate error message and
exit the program.

@<Issue ...@>=
{
fprintf(stderr, "The input file %s did not have the correct format.\n",
        input_filename);
fprintf(stderr, "It should contain a line which has the word \
\"checksum\"\n");
fprintf(stderr,"and no other alphabetic characters.\n");
exit(EXIT_FAILURE);}
@* Index.
@z
