#if (defined(__cplusplus) || defined(__STDC__) || defined(c_plusplus))
#define NEW_STYLE 1
#else
#define NEW_STYLE 0
#endif

#include <stdio.h>

#if NEW_STYLE
#define VOID	void
#define ARGS(parenthesized_list) parenthesized_list
#include <stdlib.h>
#else /* K&R style */
#define VOID
#define ARGS(parenthesized_list) ()
#endif /* NEW_STYLE */

#if !defined(EXIT_SUCCESS)
#define EXIT_SUCCESS	0
#define EXIT_FAILURE	1
#endif

#define	ERROR_PREFIX	"??"	/* this prefixes all error messages */

extern long		line_number;
extern const char	*the_filename;

static void		dolex ARGS((void));
int			main ARGS((int argc_, char *argv_[]));

#if __sgi
/* SGI C++ erroneously assumes that yylex() is a C function instead of
a C++ function, sigh... */
#ifdef __cplusplus
extern "C" {
int			yylex ARGS((void));
}
#else
int			yylex ARGS((void));
#endif
#else /* NOT __sgi */
int			yylex ARGS((void));
#endif /* __sgi */


#if NEW_STYLE
int
main(int argc, char *argv[])
#else /* K&R style */
int
main(argc, argv)
int argc;
char *argv[];
#endif /* NEW_STYLE */
{
    int k;
    FILE *fp;

    if (argc > 1)		/* files to lex named on command line */
    {
	for (k = 1; k < argc; ++k)
	{
	    fp = freopen(argv[k],"r",stdin);
	    if (fp == (FILE*)NULL)
	    {
		(void)fprintf(stderr,
		    "\n%s Ignoring open failure on file [%s]\n",
		    ERROR_PREFIX, argv[k]);
		(void)perror("perror() says");
	    }
	    else
	    {
		the_filename = (const char*)argv[k];
		dolex();
		(void)fclose(fp);
	    }
	}
    }
    else				/* lex stdin */
    {
	the_filename = "stdin";
	dolex();
    }
    exit (EXIT_SUCCESS);
    return (0);
}

static void
dolex(VOID)
{
    line_number = 1L;
    printf("# line %ld \"%s\"\n", line_number, the_filename);

    while (yylex() > 0)
	;
}
