/* /u/sy/beebe/tex/biblex/bibyydcl.h, Sat Jan 16 16:24:55 1993 */
/* Edit by Nelson H. F. Beebe <beebe@plot79.math.utah.edu> */

/***********************************************************************
This file contains function prototypes of lex library functions.

We need them because most current lex implementations do not generate
prototypes in the output C code, making it impossible to compile the
code with C++ compilers.

There are also variations in the types of some of these functions
which we must handle by preprocessor conditionals below.
***********************************************************************/

int			yyback ARGS((int *p_, int m_));
void			yyerror ARGS((const char *s_));
int			yyinput ARGS((void));

#if __sgi && defined(__cplusplus)
/* SGI C++ erroneously assumes that yylex() is a C function instead of
a C++ function, sigh... */
extern "C" {
int			yylex ARGS((void));
};
#else /* NOT __sgi && defined(__cplusplus) */
int			yylex ARGS((void));
#endif /* __sgi && defined(__cplusplus) */

int			yylook ARGS((void));

#if _IBMR2 || NeXT || __sgi || __solaris
void			yyoutput ARGS((int c_));
void			yyunput ARGS((int c_));
#else /* NOT (_IBMR2 || NeXT || __sgi || __solaris) */
int			yyoutput ARGS((int c_));
int			yyunput ARGS((int c_));
#endif /* _IBMR2 || NeXT || __sgi || __solaris */

int			yywrap ARGS((void));
