.\" ====================================================================
.\"  @Troff-man-file{
.\"     author          = "Nelson H. F. Beebe",
.\"     version         = "1.00.0",
.\"     date            = "16 January 1993",
.\"     time            = "17:23:26 MST",
.\"     filename        = "bibdup.man",
.\"     address         = "Center for Scientific Computing
.\"                        Department of Mathematics
.\"                        University of Utah
.\"                        Salt Lake City, UT 84112
.\"                        USA",
.\"     telephone       = "+1 801 581 5254",
.\"     FAX             = "+1 801 581 4148",
.\"     checksum        = "27124 122 455 3911",
.\"     email           = "beebe@math.utah.edu (Internet)",
.\"     codetable       = "ISO/ASCII",
.\"     keywords        = "bibliography, BibTeX, lexical analysis",
.\"     supported       = "yes",
.\"     docstring       = "This file is the UNIX nroff/troff manual
.\"                        page documentation for bibdup, a tool for
.\"                        checking for duplicate abbreviations and
.\"                        keys in BibTeX bibliography data base
.\"                        files.
.\"
.\"                        The checksum field above contains a CRC-16
.\"                        checksum as the first value, followed by the
.\"                        equivalent of the standard UNIX wc (word
.\"                        count) utility output of lines, words, and
.\"                        characters.  This is produced by Robert
.\"                        Solovay's checksum utility.",
.\"  }
.\"=====================================================================
.\"
.if t .ds Bi B\s-2IB\s+2T\\h'-0.1667m'\\v'0.20v'E\\v'-0.20v'\\h'-0.125m'X
.if n .ds Bi BibTeX
.\"
.\"=====================================================================
.TH BIBDUP 1 "16 January 1993" "Version 1.00.0"
.\"=====================================================================
.SH NAME
bibdup \- check for duplicate abbreviations and entries in BibTeX \
bibliography data base files
.\"=====================================================================
.SH SYNOPSIS
.B bibdup
.I "<infile"
.I ">outfile"
.nf
or
.fi
.B bibdup
.I "bibfile1 bibfile2 bibfile3 .\|.\|."
.I ">outfile"
.\"=====================================================================
.SH DESCRIPTION
.B bibdup
uses
.BR biblex (1)
to lexically analyze \*(Bi files and
.BR nawk (1)
to check for duplicate @String{.\|.\|.}
abbreviations, and duplicate citation keys.
Letter case is ignored in string comparisons, by
the simple expedient of using
.BR tr (1)
to convert the lexical token stream output by
.BR biblex (1)
to lower case.
.PP
Duplicates are displayed on the standard output in
the form
.RS
.nf
Duplicate string abbreviation ["pub-aw"]:
        # line 1 "ll.bib"
        # line 141 "master.bib"
Duplicate key ["lamport:ldp85"]:
        # line 4 "ll.bib"
        # line 4172 "master.bib"
\&.\|.\|.
.fi
.RE
ANSI/ISO Standard C preprocessor lines identify
the line number and file name where the duplicates
are detected.
.\"=====================================================================
.SH "SEE ALSO"
.BR bibclean (1),
.BR bibextract (1),
.BR bibindex (1),
.BR biblex (1),
.BR biblook (1),
.BR bibparse (1),
.BR bibsort (1),
.BR bibtex (1),
.BR bibunlex (1),
.BR citefind (1),
.BR citetags (1),
.BR latex (1),
.BR nawk (1),
.BR scribe (1),
.BR tex (1),
.BR tr (1).
.\"=====================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
Department of Mathematics
University of Utah
Salt Lake City, UT 84112
USA
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: <beebe@math.utah.edu>
.fi
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
