/*
 *             Automatically Tuned Linear Algebra Software v3.5.6
 *                    (C) Copyright 2003 R. Clint Whaley
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the ATLAS group or the names of its contributers may
 *      not be used to endorse or promote products derived from this
 *      software without specific written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ATLAS GROUP OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef ATLAS_PKBLAS_H
#define ATLAS_PKBLAS_H

#define CBLAS_ENUM_ONLY
#include "cblas.h"
#undef CBLAS_ENUM_ONLY

enum PACK_UPLO {PackUpper=121, PackLower=122, PackGen=123};

#define PACK_ORDER CBLAS_ORDER
   #define PackRowMajor CblasRowMajor
   #define PackColMajor CblasColMajor
#define PACK_TRANS CBLAS_TRANSPOSE
   #define PackNoTrans CblasNoTrans
   #define PackTrans CblasTrans
   #define PackConjTrans CblasConjTrans
   #define PackConj AtlasConj
#define PACK_DIAG CBLAS_DIAG
   #define PackNonUnit CblasNonUnit
   #define PackUnit CblasUnit
#define PACK_SIDE CBLAS_SIDE
   #define PackLeft  CblasLeft
   #define PackRight CblasRight

void ATL_dgpmm(const enum PACK_UPLO UA, const enum PACK_TRANS TA,
               const enum PACK_UPLO UB, const enum PACK_TRANS TB,
               const enum PACK_UPLO UC,
               const int M, const int N, const int K, const double alpha,
               const double *A, const int IA, const int JA, const int lda,
               const double *B, const int IB, const int JB, const int ldb,
               const double beta, double *C, const int IC, const int JC,
               const int ldc);

#endif
