    /*        Fast GEMM routine for Alpha                  */
    /*           Linux, Digital UNIX and NT/Alpha          */
    /*        by Kazushige Goto <goto@statabo.rim.or.jp>   */

#ifndef BMCOMMON_H
#define BMCOMMON_H

static struct timeval gettime(void){
   struct timeval tp;
   gettimeofday( &tp, (struct timezone *)0);
   return tp;
}

static unsigned int   start_clock, stop_clock;
static struct timeval start_time, stop_time;

static void start(void){
  start_time  = gettime();
}

static void stop(void){
  stop_time  = gettime();
}

static double secs(){
  double difftime_real;

  difftime_real = (double)(stop_time.tv_sec - start_time.tv_sec)
    + (double)((stop_time.tv_usec - start_time.tv_usec)) * 1.e-6;

  return difftime_real;
}

static double mflops(int size){
  
  return 2.0 * (double)size * (double)size * (double) size / secs() * 1.e-6;
}

static int diffs(double a, double b){
  double fabs(double);
  double d = fabs(a - b);

#ifdef DGEMM
  return ( d / fabs(a) >= 1.0e-5);
#else
  return ( d / fabs(a) >= 1.0e-3);
#endif
}

long GEMMC_ (char *transA, char *transB, int *m, int *n, int *k,
	     FLOAT *alpha, FLOAT *a, int *lda, FLOAT *b, int *ldb,
	     FLOAT *beta,  FLOAT *c, int *ldc);

long GEMM_  (char *transA, char *transB, int *m, int *n, int *k,
	     FLOAT *alpha, FLOAT *a, int *lda, FLOAT *b, int *ldb,
	     FLOAT *beta,  FLOAT *c, int *ldc);

void ZGEMMC_(char *, char *, int *, int *, int *, FLOAT *, 
	     FLOAT *, int *, FLOAT *, int *, FLOAT *, FLOAT *, int *);

void ZGEMM_ (char *, char *, int *, int *, int *, FLOAT *, 
	     FLOAT *, int *, FLOAT *, int *, FLOAT *, FLOAT *, int *);

typedef struct {FLOAT r, i;} complex_t;

static char *trans[]={"N", "T", "R", "C"};

#endif
