#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure evaluates a multivariate polynomial interpolant
**     to data.
**
**     Thomas Grandine
**     May, 1994
**
***********************************************************************/

long int mvpval (double *x,
                 long int incx,
                 MVPOLY *poly,
                 double *fval)
{
  long int ier = 0;
  long int ix;
  long int iy;
  long int iz;
  long int none = 0;
  long int one = 1;
  double zero = 0.0;
  double term;
  double parm;

/* Evaluate by brute force */

  dcopy_ (&poly->ndep, &zero, &none, fval, &one);
  for (ix = 0; ix < poly->nterm; ix++) {
    term = 1.0;
    for (iy = 0; iy < poly->nind; iy++) {
      parm = (x[iy * incx] - poly->bounds[2 * iy]) /
             (poly->bounds[2 * iy + 1] - poly->bounds[2 * iy]);
      for (iz = 0; iz < poly->expon[ix * poly->nind + iy]; iz++) {
        term *= parm;
      }
    }
    daxpy_ (&poly->ndep, &term, &poly->coefs[ix], &poly->nterm,
            fval, &one);
  }

/* Return the function values */

  return ier;
}
