#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

typedef struct PASSLFUN {
  long int incp;
  long int incd;
  double *xyz;
} PASSLFUN;

static double linfun (MVPOLY *monomial,
                      long int ixfun,
                      void *aux);

/***********************************************************************
**
**     This procedure constructs a multivariate polynomial interpolant
**     to data points.
**
**     The parameters for this function have the following meaning:
**        nind   - the number of independent variables
**        ndep   - the number of dependent variables
**        npts   - the number of functionals to interpolate
**        xyz    - the values of the data points
**        incp   - the increment parameter for xyz per point
**        incd   - the increment parameter for xyz per dependent var
**        bounds - the bounds on the independent variables, i.e.
**                     bound(2*i) <= x(i) <= bound(2*i+1)
**        poly   - on output, contains the interpolant
**
**     Thomas Grandine
**     May, 1994
**
**     Modified to call mvpifn:
**
**     Thomas Grandine
**     May, 1997
**
***********************************************************************/

long int mvpint (long int nind,
                 long int ndep,
                 long int npts,
                 double *xyz,
                 long int incp,
                 long int incd,
                 double *bounds,
                 MVPOLY **poly)
{
  long int ier;
  PASSLFUN passto;

/* Make the call to mvpifn */

  passto.incp = incp;
  passto.incd = incd;
  passto.xyz = xyz;
  ier = mvpifn (nind, ndep, npts, linfun, &passto, &xyz[nind * incd],
                incp, incd, bounds, poly);

/* Return */

  return ier;
}

/* The following routine is used to evaluate the point functionals */

static double linfun (MVPOLY *monomial,
                      long int ixfun,
                      void *aux)
{
  double value = 1.0;
  long int ix;
  long int iy;
  PASSLFUN *passto = (PASSLFUN *) aux;
 
  mvpval (&(passto->xyz[passto->incp * ixfun]), passto->incd,
          monomial, &value);
  return value;
}
