#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure evaluates a partial derivative for a multivariate
**     polynomial interpolant to data.
**
**     Thomas Grandine
**     June, 1996
**
***********************************************************************/

long int mvpder (double *x,
                 long int incx,
                 long int *ider,
                 MVPOLY *poly,
                 double *fval)
{
  long int ier = 0;
  long int ix;
  long int iy;
  long int iz;
  long int power;
  long int none = 0;
  long int one = 1;
  double zero = 0.0;
  double term;
  double parm;
  double scale;

/* Evaluate by brute force */

  dcopy_ (&poly->ndep, &zero, &none, fval, &one);
  for (ix = 0; ix < poly->nterm; ix++) {
    term = 1.0;
    for (iy = 0; iy < poly->nind; iy++) {
      power = poly->expon[ix * poly->nind + iy];
      if (ider[iy] > power) {
        term = 0.0;
        break;
      }
      scale = 1.0 / (poly->bounds[2 * iy + 1] - poly->bounds[2 * iy]);
      parm = scale * (x[iy * incx] - poly->bounds[2 * iy]);
      for (iz = 0; iz < power; iz++) {
        if (iz < ider[iy]) {
          term *= scale * (power - iz);
	} else {
          term *= parm;
	}
      }
    }
    daxpy_ (&poly->ndep, &term, &poly->coefs[ix], &poly->nterm,
            fval, &one);
  }

/* Return the function values */

  return ier;
}
