#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure copies a multivariate polynomial.
**
**     Thomas Grandine
**     July, 1996
**
***********************************************************************/

long int mvcopy (MVPOLY *x,
                 MVPOLY **y)
{
  long int ix;
  long int ncopy;
  long int bytes;
  long int ier;
  long int one = 1;
  MVPOLY *new = NULL;

/* Allocate the new multivariate polynomial */

  B_ALLOC (new, MVPOLY, 1, bytes, ier, END);
  *y = new;

/* Copy information into the new structure */

  new->nind = x->nind;
  new->ndep = x->ndep;
  new->nterm = x->nterm;
  B_ALLOC (new->expon, long int, x->nind * x->nterm, bytes, ier, END);
  B_ALLOC (new->bounds, double, 2 * x->nind, bytes, ier, END);
  B_ALLOC (new->coefs, double, x->ndep * x->nterm, bytes, ier, END);
  for (ix = 0; ix < x->nind * x->nterm; ix++) {
    new->expon[ix] = x->expon[ix];
  }
  ncopy = 2 * x->nind;
  dcopy_ (&ncopy, x->bounds, &one, new->bounds, &one);
  ncopy = x->ndep * x->nterm;
  dcopy_ (&ncopy, x->coefs, &one, new->coefs, &one);

/* Return the result */

END:
  return ier;
}
