#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "spline.h"

/***********************************************************************
**
**     This procedure computes an affine combination of two multivariate
**     polynomial functions.
**
**     Thomas Grandine
**     July, 1996
**
***********************************************************************/

long int mvaxpy (double a,
                 MVPOLY *x,
                 MVPOLY *y)
{
  long int ix;
  long int iy;
  long int iz;
  long int bytes;
  long int ier;
  long int minus = -1;

/* Loop through each of the terms in x */

  for (ix = 0; ix < x->nterm; ix++) {
    for (iy = 0; iy < y->nterm; iy++) {
      for (iz = 0; iz < x->nind; iz++) {
        if (x->expon[ix * x->nind + iz] !=
            y->expon[iy * y->nind + iz]) {
          break;
	}
      }
      if (iz == x->nind) {
        daxpy_ (&x->ndep, &a, &x->coefs[ix], &x->nterm,
                &y->coefs[iy], &y->nterm);
        break;
      }
    }
    if (iy == y->nterm) {
      y->nterm += 1;
      B_REALLOC (y->expon, long int, y->nterm * y->nind, bytes, ier,
                 END);
      B_REALLOC (y->coefs, double, y->nterm * y->ndep, bytes, ier, END);
      for (iz = 0; iz < y->nind; iz++) {
        y->expon[iy * y->nind + iz] = x->expon[ix * x->nind + iz];
      }
      for (iz = y->ndep - 1; iz >= 0; iz--) {
        dcopy_ (&iy, &y->coefs[iz * iy], &minus,
                &y->coefs[iz * y->nterm], &minus);
        y->coefs[iy + y->nterm * iz] = a * x->coefs[ix + x->nterm * iz];
      }
    }
  }

/* Return the result */

END:
  return ier;
}
