  MODULE F95_PFAPACK

    !Interfaces of the Pfaffian routines

    INTERFACE SKPFA
       SUBROUTINE SSKPFA_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: singleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         REAL(singleprec), INTENT(OUT) :: PFAFF
         REAL(singleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE SSKPFA_F95

       SUBROUTINE DSKPFA_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: doubleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         REAL(doubleprec), INTENT(OUT) :: PFAFF
         REAL(doubleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE DSKPFA_F95

       SUBROUTINE CSKPFA_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: singleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         COMPLEX(singleprec), INTENT(OUT) :: PFAFF
         COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE CSKPFA_F95

       SUBROUTINE ZSKPFA_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: doubleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         COMPLEX(doubleprec), INTENT(OUT) :: PFAFF
         COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE ZSKPFA_F95
    END INTERFACE

    INTERFACE SKPF10
       SUBROUTINE SSKPF10_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: singleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         REAL(singleprec), INTENT(OUT) :: PFAFF(2)
         REAL(singleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE SSKPF10_F95

       SUBROUTINE DSKPF10_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: doubleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         REAL(doubleprec), INTENT(OUT) :: PFAFF(2)
         REAL(doubleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE DSKPF10_F95

       SUBROUTINE CSKPF10_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: singleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         COMPLEX(singleprec), INTENT(OUT) :: PFAFF(2)
         COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE CSKPF10_F95

       SUBROUTINE ZSKPF10_F95( A, PFAFF, UPLO, MTHD, INFO)
         USE PFAPACK_PREC, ONLY: doubleprec
         CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MTHD
         INTEGER, INTENT(OUT), OPTIONAL :: INFO
         COMPLEX(doubleprec), INTENT(OUT) :: PFAFF(2)
         COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
       END SUBROUTINE ZSKPF10_F95
    END INTERFACE

    INTERFACE SKBPFA
      SUBROUTINE SSKBPFA_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(singleprec), INTENT(OUT) :: PFAFF
        REAL(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE SSKBPFA_F95

      SUBROUTINE DSKBPFA_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(doubleprec), INTENT(OUT) :: PFAFF
        REAL(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE DSKBPFA_F95

      SUBROUTINE CSKBPFA_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(singleprec), INTENT(OUT) :: PFAFF
        COMPLEX(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE CSKBPFA_F95

      SUBROUTINE ZSKBPFA_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(doubleprec), INTENT(OUT) :: PFAFF
        COMPLEX(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE ZSKBPFA_F95
   END INTERFACE

   INTERFACE SKBPF10
      SUBROUTINE SSKBPF10_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(singleprec), INTENT(OUT) :: PFAFF(2)
        REAL(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE SSKBPF10_F95

      SUBROUTINE DSKBPF10_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(doubleprec), INTENT(OUT) :: PFAFF(2)
        REAL(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE DSKBPF10_F95

      SUBROUTINE CSKBPF10_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(singleprec), INTENT(OUT) :: PFAFF(2)
        COMPLEX(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE CSKBPF10_F95

      SUBROUTINE ZSKBPF10_F95( AB, PFAFF, UPLO, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(doubleprec), INTENT(OUT) :: PFAFF(2)
        COMPLEX(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE ZSKBPF10_F95
   END INTERFACE

   !Interfaces for Parlett-Reid tridiagonalization routines

   INTERFACE SKTRF
      SUBROUTINE SSKTRF_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        REAL(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE SSKTRF_F95

      SUBROUTINE DSKTRF_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        REAL(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE DSKTRF_F95

      SUBROUTINE CSKTRF_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE CSKTRF_F95

      SUBROUTINE ZSKTRF_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE ZSKTRF_F95
   END INTERFACE

   INTERFACE SKTF2
      SUBROUTINE SSKTF2_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        REAL(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE SSKTF2_F95

      SUBROUTINE DSKTF2_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        REAL(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE DSKTF2_F95

      SUBROUTINE CSKTF2_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE CSKTF2_F95

      SUBROUTINE ZSKTF2_F95( A, IPIV, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        INTEGER, INTENT(OUT) :: IPIV(:)
        COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE ZSKTF2_F95
   END INTERFACE

   !Interfaces for Householder tridiagonalization routines

   INTERFACE SKTRD
      SUBROUTINE SSKTRD_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(singleprec), INTENT(OUT) :: TAU(:)
        REAL(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE SSKTRD_F95

      SUBROUTINE DSKTRD_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(doubleprec), INTENT(OUT) :: TAU(:)
        REAL(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE DSKTRD_F95

      SUBROUTINE CSKTRD_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(singleprec), INTENT(OUT) :: TAU(:)
        COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE CSKTRD_F95

      SUBROUTINE ZSKTRD_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(doubleprec), INTENT(OUT) :: TAU(:)
        COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE ZSKTRD_F95
   END INTERFACE

   INTERFACE SKTD2
      SUBROUTINE SSKTD2_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(singleprec), INTENT(OUT) :: TAU(:)
        REAL(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE SSKTD2_F95

      SUBROUTINE DSKTD2_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(doubleprec), INTENT(OUT) :: TAU(:)
        REAL(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE DSKTD2_F95

      SUBROUTINE CSKTD2_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(singleprec), INTENT(OUT) :: TAU(:)
        COMPLEX(singleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE CSKTD2_F95

      SUBROUTINE ZSKTD2_F95( A, TAU, UPLO, MODE, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(doubleprec), INTENT(OUT) :: TAU(:)
        COMPLEX(doubleprec), INTENT(INOUT) :: A(:,:)
      END SUBROUTINE ZSKTD2_F95
   END INTERFACE

   INTERFACE SKBTRD
      SUBROUTINE SSKBTRD_F95( AB, UPLO, MODE, DETQ, Q, VECT, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE, VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(singleprec), INTENT(OUT), OPTIONAL :: DETQ
        REAL(singleprec), INTENT(OUT), OPTIONAL :: Q(:,:)
        REAL(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE SSKBTRD_F95

      SUBROUTINE DSKBTRD_F95( AB, UPLO, MODE, DETQ, Q, VECT, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE, VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        REAL(doubleprec), INTENT(OUT), OPTIONAL :: DETQ
        REAL(doubleprec), INTENT(OUT), OPTIONAL :: Q(:,:)
        REAL(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE DSKBTRD_F95

      SUBROUTINE CSKBTRD_F95( AB, UPLO, MODE, DETQ, Q, VECT, INFO )
        USE PFAPACK_PREC, ONLY: singleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE, VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(singleprec), INTENT(OUT), OPTIONAL :: DETQ
        COMPLEX(singleprec), INTENT(OUT), OPTIONAL :: Q(:,:)
        COMPLEX(singleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE CSKBTRD_F95

      SUBROUTINE ZSKBTRD_F95( AB, UPLO, MODE, DETQ, Q, VECT, INFO )
        USE PFAPACK_PREC, ONLY: doubleprec
        CHARACTER(LEN=1), INTENT(IN), OPTIONAL :: UPLO, MODE, VECT
        INTEGER, INTENT(OUT), OPTIONAL :: INFO
        COMPLEX(doubleprec), INTENT(OUT), OPTIONAL :: DETQ
        COMPLEX(doubleprec), INTENT(OUT), OPTIONAL :: Q(:,:)
        COMPLEX(doubleprec), INTENT(INOUT) :: AB(:,:)
      END SUBROUTINE ZSKBTRD_F95
   END INTERFACE

 END MODULE F95_PFAPACK
