  MODULE AiryFunction
  ! Computation of the real Airy functions
  ! Ai(x), Bi(x), Ai'(x), Bi'(x) using Chebyshev expansions
  IMPLICIT NONE
  INTEGER, PARAMETER  :: r8 = KIND(0.0d0)
  PRIVATE
  PUBLIC  :: aibi, aibip, airsca, xpowy
  CONTAINS
    FUNCTION chepolsum(n,t,a)
    !{a[0]/2+a[1]T1(x)+...a[n]Tn(x)}
    !{This code is a Fortran 90 version of Alan Macleod's code}
    USE Someconstants
    IMPLICIT NONE
    REAL(r8) :: d1,d2,half,test,tt,two,u0,u1,u2,zero,t,a(0:60)
    REAL(r8) :: chepolsum
    INTEGER :: n,i
    zero= 0.0_r8; half= 0.5_r8; test= 0.6_r8; two= 2.0_r8; u1= zero;
    !If ABS ( T ) < 0.6 use the standard Clenshaw method
    IF (abs(t)<test) THEN
      u0=zero;
      tt=t+t;
      DO i=n,0,-1  
        u2=u1;
        u1=u0;
        u0=tt*u1+a(i)-u2
      ENDDO
      chepolsum=(u0-u2)/two
    ELSE
      ! If ABS ( T ) > = 0.6 use the Reinsch modification
      d1=zero;
      IF (t>zero) THEN
        tt=(t-half)-half;
        tt=tt+tt;
        DO i=n,0,-1 
          d2=d1;
          u2=u1;
          d1=tt*u2+a(i)+d2;
          u1=d1+u2
        ENDDO
        chepolsum= (d1 + d2)/two
      ELSE
        tt=(t+half)+half;
        tt=tt+tt;
        DO i=n,0,-1
          d2=d1;
          u2=u1;
          d1=tt*u2+a(i)-d2;
          u1=d1-u2
        ENDDO
        chepolsum=(d1 - d2)/two
      ENDIF
    ENDIF
    END FUNCTION chepolsum
                          
    FUNCTION xpowy(x,y)
    IMPLICIT NONE
    REAL(r8) :: x,y,xpowy
    xpowy=x**y
    END FUNCTION xpowy

    SUBROUTINE aibi(x, ai, bi)
    USE Someconstants
    IMPLICIT NONE
    REAL(r8), INTENT(IN) :: x
    REAL(r8), INTENT(OUT) :: ai
    REAL(r8), INTENT(OUT) :: bi
    REAL(r8) :: y, s, c, f1, f2, t, z, la
    REAL(r8) :: ar(0:60), br(0:60)
    IF (x < -5) THEN 
      ar(0)=+1.1280094441222097012e+0_r8;
      ar(1)=-1.836709914558369e-4_r8;
      ar(2)=+1.1677286575962e-6_r8;
      ar(3)=-2.19524008170e-8_r8;
      ar(4)=+7.698908177e-10_r8;
      ar(5)=-4.09915521e-11_r8;
      ar(6)=+2.9533495e-12_r8;
      ar(7)=-2.679714e-13_r8;
      ar(8)=+2.91808e-14_r8;
      ar(9)=-3.6863e-15_r8;
      ar(10)=+5.269e-16_r8;
      ar(11)=-8.36e-17_r8;
      ar(12)=+1.45e-17_r8;
      ar(13)=-2.7e-18_r8;
      ar(14)=+5.0e-19_r8;
      ar(15)=-1.0e-19_r8;
      br(0)=+7.7988242533135881502e-2_r8;
      br(1)=-1.83421439318478417e-4_r8;
      br(2)=+2.226279540000655e-6_r8;
      br(3)=-6.0307865841937e-8_r8;
      br(4)=+2.708298845975e-9_r8;
      br(5)=-1.73155804053e-10_r8;
      br(6)=+1.4396760940e-11_r8;
      br(7)=-1.467799419e-12_r8;
      br(8)=+1.76234030e-13_r8;
      br(9)=-2.4205568e-14_r8;
      br(10)=+3.721795e-15_r8;
      br(11)=-6.30106e-16_r8;
      br(12)=+1.15949e-16_r8;
      br(13)=-2.2951e-17_r8;
      br(14)=+4.846e-18_r8;
      br(15)=-1.084e-18_r8;
      br(16)=+2.55e-19_r8;
      br(17)=-6.3e-20_r8;
      br(18)=+1.6e-20_r8;
      br(19)=-4.0e-21_r8;
      br(20)=+1.0e-21_r8;
      z=2.0_r8/3.0_r8*xpowy(-x,1.5_r8); la= 5.0_r8; 
      t=la/x
      t=-2.0_r8*t*t*t-1.0_r8;
      s=sin(z+piquart); c=cos(z+piquart);
      f1=chepolsum(15,t,ar);
      f2=chepolsum(20,t,br);
      y=xpowy(-x,-0.25_r8);
      ai=y*(s*f1-c*f2/z);
      bi=y*(c*f1+s*f2/z)
    ELSEIF (x <0 ) THEN 
      ar(0)=+1.5217399882834532859e-1_r8;
      ar(1)=+9.463304395658582345e-2_r8;
      ar(2)=+8.835933286664339033e-2_r8;
      ar(3)=-1.8809032021891572589e-1_r8;
      ar(4)=+7.873696950590187481e-2_r8;
      ar(5)=-1.616162609419079569e-2_r8;
      ar(6)=+2.03792657403144947e-3_r8;
      ar(7)=-1.7619321508091265e-4_r8;
      ar(8)=+1.116557634724685e-5_r8;
      ar(9)=-5.4278037289400e-7_r8;
      ar(10)=+2.092500233007e-8_r8;
      ar(11)=-6.5627359901e-10_r8;
      ar(12)=+1.708749758e-11_r8;
      ar(13)=-3.7550458e-13_r8;
      ar(14)=+7.06091e-15_r8;
      ar(15)=-1.1494e-16_r8;
      ar(16)=+1.64e-18_r8;
      ar(17)=-2.1e-20_r8;
      br(0)=+7.5365743540308812655e-2_r8;
      br(1)=-4.3238169422348489365e-2_r8;
      br(2)=+9.5247283336721394897e-2_r8;
      br(3)=-6.1705567716412224149e-2_r8;
      br(4)=+1.7697290707409225048e-2_r8;
      br(5)=-2.909533805902076483e-3_r8;
      br(6)=+3.13306256975299299e-4_r8;
      br(7)=-2.3946459531381245e-5_r8;
      br(8)=+1.370954782252896e-6_r8;
      br(9)=-6.1112783503340e-8_r8;
      br(10)=+2.184145572027e-9_r8;
      br(11)=-6.4038637539e-11_r8;
      br(12)=+1.569118251e-12_r8;
      br(13)=-3.2625307e-14_r8;
      br(14)=+5.83052e-16_r8;
      br(15)=-9.054e-18_r8;
      br(16)=+1.23e-19_r8;
      br(17)=-1.5e-21_r8;
      la= 5.0_r8;
      t=x/la
      t= -2.0_r8*t*t*t-1.0_r8;
      f1=chepolsum(17,t,ar);
      f2=chepolsum(17,t,br);
      ai=f1-x*f2;
      bi=sqrt3*(f1+x*f2);
    ELSEIF (x==0.0_r8) THEN                                                     
      ai=0.35502805388781723926_r8;
      bi=0.61492662744600073515_r8;
    ELSEIF (x<4.5) THEN                           
      ar(0)=+9.7934675132923263719e-1_r8;
      ar(1)=-5.817935703328346930e-2_r8;
      ar(2)=-1.8573106989330210396e-1_r8;
      ar(3)=+2.466671790187645891e-2_r8;
      ar(4)=+1.523182915947318079e-2_r8;
      ar(5)=-3.18268812403824637e-3_r8;
      ar(6)=-6.4421595859367550e-4_r8;
      ar(7)=+2.1680741331029091e-4_r8;
      ar(8)=+1.036058369682457e-5_r8;
      ar(9)=-9.16356774348920e-6_r8;
      ar(10)=+3.6678407013177e-7_r8;
      ar(11)=+2.5198203640692e-7_r8;
      ar(12)=-2.903896001941e-8_r8;
      ar(13)=-4.22648003774e-9_r8;
      ar(14)=+9.7569578821e-10_r8;
      ar(15)=+2.168534257e-11_r8;
      ar(16)=-2.083233561e-11_r8;
      ar(17)=+1.00889184e-12_r8;
      ar(18)=+2.9268193e-13_r8;
      ar(19)=-3.543870e-14_r8;
      ar(20)=-2.19178e-15_r8;
      ar(21)=+6.4842e-16_r8;
      ar(22)=-1.036e-17_r8;
      ar(23)=-7.75e-18_r8;
      ar(24)=+5.9e-19_r8;
      ar(25)=+6.0e-20_r8;
      br(0)=+7.2340133270078824597e-1_r8;
      br(1)=-6.186433877265966711e-2_r8;
      br(2)=+1.6859154747460945662e-1_r8;
      br(3)=-1.516452843795166719e-2_r8;
      br(4)=+1.268194063516318154e-2_r8;
      br(5)=+2.37665412524311142e-3_r8;
      br(6)=-1.35486356206889915e-3_r8;
      br(7)=+9.4811517986800841e-4_r8;
      br(8)=-3.0184629675683576e-4_r8;
      br(9)=+8.26176092954571e-5_r8;
      br(10)=-1.29237026410167e-5_r8;
      br(11)=+3.86277876708896e-7_r8;
      br(12)=+6.7349791262055e-7_r8;
      br(13)=-2.6650662327003e-7_r8;
      br(14)=+6.313398211272e-8_r8;
      br(15)=-9.28482785276e-9_r8;
      br(16)=+4.2243068981e-10_r8;
      br(17)=+2.2149462027e-10_r8;
      br(18)=-7.885556616e-11_r8;
      br(19)=+1.489486494e-11_r8;
      br(20)=-1.61561338e-12_r8;
      br(21)=-1.99887e-15_r8;
      br(22)=+4.310890e-14_r8;
      br(23)=-1.026039e-14_r8;
      br(24)=+1.36524e-15_r8;
      br(25)=-7.870e-17_r8;
      br(26)=-1.152e-17_r8;
      br(27)=+3.99e-18_r8;
      br(28)=-6.0e-19_r8;
      br(29)=+5.0e-20_r8; 
      la= 4.5_r8; t=2*x/la-1.0_r8;
      f1=chepolsum(25,t,ar);
      f2=chepolsum(29,t, br);
      ai=f1*exp(-1.5_r8*x);
      bi=f2*exp(1.375_r8*x)
    ELSEIF (x<9) THEN 
      ar(0)=+5.0491255733788020503e+1_r8;
      ar(1)=-6.257510019590865924e+0_r8;
      ar(2)=-5.510390933031668771e+0_r8;
      ar(3)=+9.23785747211947637e-1_r8;
      ar(4)=+2.69701933599952531e-1_r8;
      ar(5)=-6.0503610861932189e-2_r8;
      ar(6)=-7.272383379486571e-3_r8;
      ar(7)=+2.432739101814126e-3_r8;
      ar(8)=+8.9407383924725e-5_r8;
      ar(9)=-6.7626485765665e-5_r8;
      ar(10)=+1.143189712477e-6_r8;
      ar(11)=+1.369896864000e-6_r8;
      ar(12)=-8.37850105221e-8_r8;
      ar(13)=-2.0445153671e-8_r8;
      ar(14)=+2.247360374e-9_r8;
      ar(15)=+2.14042502e-10_r8;
      ar(16)=-4.0617972e-11_r8;
      ar(17)=-1.169040e-12_r8;
      ar(18)=+5.51909e-13_r8;
      ar(19)=-8.169e-15_r8;
      ar(20)=-5.801e-15_r8;
      ar(21)=+3.09e-16_r8;
      ar(22)=+4.6e-17_r8;
      ar(23)=-5.0e-18_r8;
      br(0)=+5.1865644423401596677e-3_r8;
      br(1)=+3.190078113025389266e-4_r8;
      br(2)=+6.589260266019625254e-4_r8;
      br(3)=+1.77323651950275976e-5_r8;
      br(4)=+4.24724564662038450e-5_r8;
      br(5)=-3.095767914834698e-7_r8;
      br(6)=+1.8968968954113726e-6_r8;
      br(7)=-8.26612616574416e-8_r8;
      br(8)=+6.82206567197979e-8_r8;
      br(9)=-5.5232442059920e-9_r8;
      br(10)=+2.1841788459370e-9_r8;
      br(11)=-2.532110361946e-10_r8;
      br(12)=+6.69024065663e-11_r8;
      br(13)=-9.6266259764e-12_r8;
      br(14)=+2.0421501469e-12_r8;
      br(15)=-3.287463020e-13_r8;
      br(16)=+6.17455626e-14_r8;
      br(17)=-1.01838450e-14_r8;
      br(18)=+1.7333508e-15_r8;
      br(19)=-2.689068e-16_r8;
      br(20)=+3.97206e-17_r8;
      br(21)=-5.1324e-18_r8;
      br(22)=+5.434e-19_r8;
      br(23)=-3.01e-20_r8;
      br(24)=-5.0e-21_r8;
      br(25)=+2.3e-21_r8;
      br(26)=-5.0e-22_r8;
      br(27)=+1.0e-22_r8;
      la=4.5_r8; t=2*(x-la)/(9.0_r8-la)-1.0_r8;
      f1=chepolsum(23,t,ar);
      f2=chepolsum(27,t,br);
      ai=f1*exp(-2.5_r8*x);
      bi=f2*exp(2.5_r8*x);
    ELSE
      ar(0)=+5.6312443149444830912e-1_r8;
      ar(1)=-5.2879891960803332e-4_r8;
      ar(2)=+3.72709673104629e-6_r8;
      ar(3)=-4.905124032702e-8_r8;
      ar(4)=+9.3521089895e-10_r8;
      ar(5)=-2.313916112e-11_r8;
      ar(6)=+6.9870927e-13_r8;
      ar(7)=-2.476246e-14_r8;
      ar(8)=+1.00261e-15_r8;
      ar(9)=-4.547e-17_r8;
      ar(10)=+2.28e-18_r8;
      ar(11)=-1.2e-19_r8;
      br(0)=+1.1306068068318665650e+0_r8;
      br(1)=+1.1225343035826004e-3_r8;
      br(2)=+8.8491541977453e-6_r8;
      br(3)=+1.379157291154e-7_r8;
      br(4)=+3.3014426995e-9_r8;
      br(5)=+1.089423404e-10_r8;
      br(6)=+4.6726552e-12_r8;
      br(7)=+2.514325e-13_r8;
      br(8)=+1.66086e-14_r8;
      br(9)=+1.3312e-15_r8;
      br(10)=+1.292e-16_r8;
      br(11)=+1.53e-17_r8;
      br(12)=+2.2e-18_r8;
      br(13)=+4.0e-19_r8;
      la= 9.0_r8; y=xpowy(x,-0.25_r8); z= 2.0_r8/3.0_r8*xpowy(x,1.5_r8);
      t=2*xpowy(la/x,1.5_r8)-1;
      f1=chepolsum(11,t,ar);
      f2=chepolsum(13, t, br);
      la=exp(z);
      ai=y/la*f1;
      bi=y*la*f2
    ENDIF
    END SUBROUTINE aibi
                              
    SUBROUTINE aibip(x,aip,bip)
    USE Someconstants
    IMPLICIT NONE
    REAL(r8), INTENT(IN) :: x
    REAL(r8), INTENT(OUT):: aip
    REAL(r8), INTENT(OUT):: bip
    REAL(r8) :: y, s, c, f3, f4, t, z, la
    REAL(r8) :: cr(0:60), dr(0:60)
    IF (x < -5) THEN
      cr(0)=+1.1288167982669480212e+0_r8;
      cr(1)=+2.175180808271174e-4_r8;
      cr(2)=-1.2733503718850e-6_r8;
      cr(3)=+2.33020578931e-8_r8;
      cr(4)=-8.064911115e-10_r8;
      cr(5)=+4.26054712e-11_r8;
      cr(6)=-3.0537799e-12_r8;
      cr(7)=+2.760646e-13_r8;
      cr(8)=-2.99790e-14_r8;
      cr(9)=+3.7789e-15_r8;
      cr(10)=-5.392e-16_r8;
      cr(11)=+8.55e-17_r8;
      cr(12)=-1.48e-17_r8;
      cr(13)=+2.8e-18_r8;
      cr(14)=-6.0e-19_r8;
      cr(15)=+1.0e-19_r8;
      dr(0)=-1.0928773748447830587e-1_r8;
      dr(1)=+2.0544241243325013e-4_r8;
      dr(2)=-2.38739034179860e-6_r8;
      dr(3)=+6.350265424372e-8_r8;
      dr(4)=-2.82350803428e-9_r8;
      dr(5)=+1.7939539824e-10_r8;
      dr(6)=-1.485151455e-11_r8;
      dr(7)=+1.50940584e-12_r8;
      dr(8)=-1.8079342e-13_r8;
      dr(9)=+2.478440e-14_r8;
      dr(10)=-3.80487e-15_r8;
      dr(11)=+6.4333e-16_r8;
      dr(12)=-1.1825e-16_r8;
      dr(13)=+2.339e-17_r8;
      dr(14)=-4.93e-18_r8;
      dr(15)=+1.10e-18_r8;
      dr(16)=-2.60e-19_r8;
      dr(17)=+6.0e-20_r8;
      dr(18)=-2.0e-20_r8;
      z= 2.0_r8/3.0_r8*xpowy(-x,1.5_r8); 
      la=5.0_r8;
      t=la/x
      t= -2.0_r8*t*t*t-1.0_r8;
      s=sin(z+piquart); c=cos(z+piquart);
      f3=chepolsum(15,t,cr);
      f4=chepolsum(18,t,dr);
      y=xpowy(-x,0.25_r8);
      aip=-y*(c*f3+s*f4/z);
      bip=y*(s*f3-c*f4/z)
    ELSEIF (x < 0) THEN
      cr(0)=+5.2961692024697341466e-2_r8;
      cr(1)=-4.8382429177635177789e-2_r8;
      cr(2)=+6.2046464244529580518e-2_r8;
      cr(3)=-3.1417437267239646847e-2_r8;
      cr(4)=+7.876452021481851462e-3_r8;
      cr(5)=-1.182440976973326921e-3_r8;
      cr(6)=+1.18871496270269531e-4_r8;
      cr(7)=-8.595270331212026e-6_r8;
      cr(8)=+4.69655735896232e-7_r8;
      cr(9)=-2.0107696526448e-8_r8;
      cr(10)=+6.93493715818e-10_r8;
      cr(11)=-1.9694289584e-11_r8;
      cr(12)=+4.68795260e-13_r8;
      cr(13)=-9.492371e-15_r8;
      cr(14)=+1.65543e-16_r8;
      cr(15)=-2.513e-18_r8;
      cr(16)=+3.4e-20_r8;
      dr(0)=+1.9598877757490956561e-1_r8;
      dr(1)=+2.0709937287929773169e-1_r8;
      dr(2)=-9.618436611491528534e-2_r8;
      dr(3)=-2.6927080774066725642e-1_r8;
      dr(4)=+1.5311467164195350955e-1_r8;
      dr(5)=-3.621663427173734531e-2_r8;
      dr(6)=+5.00970025411579034e-3_r8;
      dr(7)=-4.6418943778727143e-4_r8;
      dr(8)=+3.110071191129936e-5_r8;
      dr(9)=-1.58422527393619e-6_r8;
      dr(10)=+6.359244256854e-8_r8;
      dr(11)=-2.06683376305e-9_r8;
      dr(12)=+5.556077451e-11_r8;
      dr(13)=-1.25683910e-12_r8;
      dr(14)=+2.426805e-14_r8;
      dr(15)=-4.0481e-16_r8;
      dr(16)=+5.89e-18_r8;
      dr(17)=-7.6e-20_r8;
      la= 5.0_r8;
      t=x/la
      t= -2.0_r8*t*t*t-1.0_r8; z= x*x;
      f3=chepolsum(16,t,cr);
      f4=chepolsum(17,t,dr);
      aip=z*f3-f4;
      bip=sqrt3*(z*f3+f4);
    ELSEIF (x==0.0_r8) THEN
      aip=-0.25881940379280679841_r8;
      bip=0.44828835735382635791_r8
    ELSEIF (x < 4.5) THEN
      cr(0)=-1.0838288082415277302e+0_r8;
      cr(1)=-2.75303325521307795e-2_r8;
      cr(2)=+2.630996799464136716e-1_r8;
      cr(3)=-2.20070838039707907e-2_r8;
      cr(4)=-2.65686371901896143e-2_r8;
      cr(5)=+4.6607302595359725e-3_r8;
      cr(6)=+1.3331627500919505e-3_r8;
      cr(7)=-3.993412832236136e-4_r8;
      cr(8)=-2.57477942743769e-5_r8;
      cr(9)=+1.92965112669086e-5_r8;
      cr(10)=-8.179057497221e-7_r8;
      cr(11)=-5.675046562446e-7_r8;
      cr(12)=+7.38399111711e-8_r8;
      cr(13)=+9.1592819462e-9_r8;
      cr(14)=-2.5909300717e-9_r8;
      cr(15)=-5.596039e-13_r8;
      cr(16)=+5.48262416e-11_r8;
      cr(17)=-4.2085028e-12_r8;
      cr(18)=-6.882068e-13_r8;
      cr(19)=+1.230089e-13_r8;
      cr(20)=+2.2115e-15_r8;
      cr(21)=-2.0268e-15_r8;
      cr(22)=+1.092e-16_r8;
      cr(23)=+2.01e-17_r8;
      cr(24)=-2.8e-18_r8;
      dr(0)=+6.5492503637358356971e-1_r8;
      dr(1)=+7.398273602101549954e-2_r8;
      dr(2)=+1.3916014396498561737e-1_r8;
      dr(3)=-1.318037729688479868e-2_r8;
      dr(4)=+2.721562752659802946e-2_r8;
      dr(5)=-8.95735391942756359e-3_r8;
      dr(6)=+4.64318555084023870e-3_r8;
      dr(7)=-1.31982848083974091e-3_r8;
      dr(8)=+3.2861337599865999e-4_r8;
      dr(9)=-2.823577298366577e-5_r8;
      dr(10)=-1.263661132378531e-5_r8;
      dr(11)=+8.58819079977971e-6_r8;
      dr(12)=-2.83605845640361e-6_r8;
      dr(13)=+6.4357170147486e-7_r8;
      dr(14)=-9.054345148828e-8_r8;
      dr(15)=+1.02361813059e-9_r8;
      dr(16)=+3.75568593189e-9_r8;
      dr(17)=-1.26430133998e-9_r8;
      dr(18)=+2.5000891998e-10_r8;
      dr(19)=-2.967290357e-11_r8;
      dr(20)=+2.6790190e-13_r8;
      dr(21)=+8.3103543e-13_r8;
      dr(22)=-2.2570250e-13_r8;
      dr(23)=+3.487651e-14_r8;
      dr(24)=-2.83929e-15_r8;
      dr(25)=-1.5678e-16_r8;
      dr(26)=+9.941e-17_r8;
      dr(27)=-1.867e-17_r8;
      dr(28)=+2.01e-18_r8;
      dr(29)=-6.0e-20_r8;
      dr(30)=-2.0e-20_r8;
      la= 4.5_r8; t= 2*x/la-1.0_r8;
      f3=chepolsum(24, t, cr);
      f4=chepolsum(30, t, dr);
      aip=f3*exp(-1.375_r8*x);
      bip=f4*exp(1.5_r8*x)
    ELSEIF (x < 9) THEN
      cr(0)=-1.2958123754838538881e+2_r8;
      cr(1)=+6.76832374624909949e+0_r8;
      cr(2)=+1.598511024718904852e+1_r8;
      cr(3)=-1.38866512314607882e+0_r8;
      cr(4)=-9.2855057862186510e-1_r8;
      cr(5)=+1.1311806368323397e-1_r8;
      cr(6)=+3.279015099087572e-2_r8;
      cr(7)=-5.43676653553677e-3_r8;
      cr(8)=-7.5136921782930e-4_r8;
      cr(9)=+1.7836159217021e-4_r8;
      cr(10)=+1.030315382664e-5_r8;
      cr(11)=-4.29105073708e-6_r8;
      cr(12)=-2.395648053e-8_r8;
      cr(13)=+7.851108600e-8_r8;
      cr(14)=-2.78229868e-9_r8;
      cr(15)=-1.10405576e-9_r8;
      cr(16)=+8.374716e-11_r8;
      cr(17)=+1.165092e-11_r8;
      cr(18)=-1.51205e-12_r8;
      cr(19)=-8.180e-14_r8;
      cr(20)=+2.018e-14_r8;
      cr(21)=+1.2e-16_r8;
      cr(22)=-2.1e-16_r8;
      dr(0)=+5.5860183624034104454e-3_r8;
      dr(1)=+2.87080283197283049e-5_r8;
      dr(2)=+6.566960781790676321e-4_r8;
      dr(3)=-1.29004618056797811e-5_r8;
      dr(4)=+3.94734989962719105e-5_r8;
      dr(5)=-1.7468162471848648e-6_r8;
      dr(6)=+1.6312939322265420e-6_r8;
      dr(7)=-1.095384680289487e-7_r8;
      dr(8)=+5.23022431650618e-8_r8;
      dr(9)=-4.4609927148093e-9_r8;
      dr(10)=+1.3623610617155e-9;
      dr(11)=-1.277857258067e-10_r8;
      dr(12)=+2.77519636083e-11_r8;
      dr(13)=-2.2855189985e-12_r8;
      dr(14)=+3.227684345e-13_r8;
      dr(15)=+2.5537222e-15_r8;
      dr(16)=-4.8715113e-15_r8;
      dr(17)=+1.8406926e-15_r8;
      dr(18)=-3.499972e-16_r8;
      dr(19)=+5.20075e-17_r8;
      dr(20)=-3.2250e-18_r8;
      dr(21)=-9.750e-19_r8;
      dr(22)=+5.043e-19_r8;
      dr(23)=-1.464e-19_r8;
      dr(24)=+3.39e-20_r8;
      dr(25)=-6.7e-21_r8;
      dr(26)=+1.2e-21_r8;
      dr(27)=-2.0e-22_r8;
      la= 4.5_r8; t= 2*(x-la)/(9.0_r8-la)-1.0_r8;
      f3= chepolsum(22, t, cr);
      f4= chepolsum(27, t, dr);
      aip= f3*exp(-2.5_r8*x);
      bip= f4*exp(2.625_r8*x);
    ELSE
      cr(0)=+5.6568578662442917280e-1_r8;
      cr(1)=+7.4362138971729004e-4_r8;
      cr(2)=-4.42404425936355e-6_r8;
      cr(3)=+5.505791762929e-8_r8;
      cr(4)=-1.02083536642e-9_r8;
      cr(5)=+2.483795569e-11_r8;
      cr(6)=-7.4166337e-13_r8;
      cr(7)=+2.607525e-14_r8;
      cr(8)=-1.04943e-15_r8;
      cr(9)=+4.738e-17_r8;
      cr(10)=-2.36e-18_r8;
      cr(11)=+1.3e-19_r8;
      dr(0)=+1.1252717606343474943e+0_r8;
      dr(1)=-1.5639596736331532e-3_r8;
      dr(2)=-1.04063425452027e-5_r8;
      dr(3)=-1.533581036012e-7_r8;
      dr(4)=-3.5697709625e-9_r8;
      dr(5)=-1.158278459e-10_r8;
      dr(6)=-4.9121069e-12_r8;
      dr(7)=-2.621683e-13_r8;
      dr(8)=-1.72103e-14_r8;
      dr(9)=-1.3725e-15_r8;
      dr(10)=-1.326e-16_r8;
      dr(11)=-1.56e-17_r8;
      dr(12)=-2.2e-18_r8;
      dr(13)=-4.0e-19_r8;
      la= 9.0_r8; y=xpowy(x,0.25_r8); 
      z=2.0_r8/3.0_r8*xpowy(x,1.5_r8);
      t=2*xpowy(la/x,1.5_r8)-1.0_r8;
      f3=chepolsum(11,t,cr);
      f4=chepolsum(13,t,dr);
      la=exp(z);
      aip=-y/la*f3;
      bip= y*la*f4
    ENDIF
    END SUBROUTINE aibip

    SUBROUTINE airsca(x,daie,dbie,daide,dbide)
    USE Someconstants
    implicit none
    REAL(r8), INTENT(IN) :: x
    REAL(r8), INTENT(OUT) :: daie, dbie, daide, dbide
! Calculates the exponentially scaled Airy function.
! The function and argument are both double precision.
! Ai(x)*exp(zeta) where zeta = 2/3 * x**(3/2) 
    REAL(r8) :: aifcs(0:60), aigcs(0:60), aip1cs(0:60), aip2cs(0:60),&
                factor, sqrtx, sqsqrtx, xbig, x3sml, x32sml, x2sml, z, eta, x2
    REAL(r8) :: bifcs(0:60), bigcs(0:60), bif2cs(0:60), big2cs(0:60),&
                bip1cs(0:60), bip2cs(0:60), atr, btr
    REAL(r8) :: daifcs(0:60), daigcs(0:60), daip1cs(0:60), daip2cs(0:60)
    REAL(r8) :: dbifcs(0:60), dbigcs(0:60), dbif2cs(0:60), dbig2cs(0:60),&
                dbip1cs(0:60), dbip2cs(0:60)
    INTEGER ::  naif, naig, naip1, naip2 
    INTEGER ::  nbif, nbig, nbif2, nbig2, nbip1, nbip2
    DATA aifcs(0) / -.37971358496669997496197089469414e-1_r8/
    DATA aifcs(1) / +.59191888537263638574319728013777e-1_r8/
    DATA aifcs(2) / +.98629280577279975365603891044060e-3_r8/
    DATA aifcs(3) / +.68488438190765667554854830182412e-5_r8/
    DATA aifcs(4) / +.25942025962194713019489279081403e-7_r8/
    DATA aifcs(5) / +.61766127740813750329445749697236e-10_r8/
    DATA aifcs(6) / +.10092454172466117901429556224601e-12_r8/
    DATA aifcs(7) / +.12014792511179938141288033225333e-15_r8/
    DATA aifcs(8) / +.10882945588716991878525295466666e-18_r8/
    DATA aigcs(0) / +.18152365581161273011556209957864e-1_r8/
    DATA aigcs(1) / +.21572563166010755534030638819968e-1_r8/
    DATA aigcs(2) / +.25678356987483249659052428090133e-3_r8/
    DATA aigcs(3) / +.14265214119792403898829496921721e-5_r8/
    DATA aigcs(4) / +.45721149200180426070434097558191e-8_r8/
    DATA aigcs(5) / +.95251708435647098607392278840592e-11_r8/
    DATA aigcs(6) / +.13925634605771399051150420686190e-13_r8/
    DATA aigcs(7) / +.15070999142762379592306991138666e-16_r8/
    DATA aigcs(8) / +.12559148312567778822703205333333e-19_r8/
    DATA aip1cs(0) / -.2146951858910538455460863467778e-1_r8/
    DATA aip1cs(1) / -.7535382535043301166219720865565e-2_r8/
    DATA aip1cs(2) / +.5971527949026380852035388881994e-3_r8/
    DATA aip1cs(3) / -.7283251254207610648502368291548e-4_r8/
    DATA aip1cs(4) / +.1110297130739299666517381821140e-4_r8/
    DATA aip1cs(5) / -.1950386152284405710346930314033e-5_r8/
    DATA aip1cs(6) / +.3786973885159515193885319670057e-6_r8/
    DATA aip1cs(7) / -.7929675297350978279039072879154e-7_r8/
    DATA aip1cs(8) / +.1762247638674256075568420122202e-7_r8/
    DATA aip1cs(9) / -.4110767539667195045029896593893e-8_r8/
    DATA aip1cs(10) / +.9984770057857892247183414107544e-9_r8/
    DATA aip1cs(11) / -.2510093251387122211349867730034e-9_r8/
    DATA aip1cs(12) / +.6500501929860695409272038601725e-10_r8/
    DATA aip1cs(13) / -.1727818405393616515478877107366e-10_r8/
    DATA aip1cs(14) / +.4699378842824512578362292872307e-11_r8/
    DATA aip1cs(15) / -.1304675656297743914491241246272e-11_r8/
    DATA aip1cs(16) / +.3689698478462678810473948382282e-12_r8/
    DATA aip1cs(17) / -.1061087206646806173650359679035e-12_r8/
    DATA aip1cs(18) / +.3098414384878187438660210070110e-13_r8/
    DATA aip1cs(19) / -.9174908079824139307833423547851e-14_r8/
    DATA aip1cs(20) / +.2752049140347210895693579062271e-14_r8/
    DATA aip1cs(21) / -.8353750115922046558091393301880e-15_r8/
    DATA aip1cs(22) / +.2563931129357934947568636168612e-15_r8/
    DATA aip1cs(23) / -.7950633762598854983273747289822e-16_r8/
    DATA aip1cs(24) / +.2489283634603069977437281175644e-16_r8/
    DATA aip1cs(25) / -.7864326933928735569664626221296e-17_r8/
    DATA aip1cs(26) / +.2505687311439975672324470645019e-17_r8/
    DATA aip2cs(0) / -.174314496929375513390355844011e-2_r8/
    DATA aip2cs(1) / -.167893854325541671632190613480e-2_r8/
    DATA aip2cs(2) / +.359653403352166035885983858114e-4_r8/
    DATA aip2cs(3) / -.138081860273922835457399383100e-5_r8/
    DATA aip2cs(4) / +.741122807731505298848699095233e-7_r8/
    DATA aip2cs(5) / -.500238203900133013130422866325e-8_r8/
    DATA aip2cs(6) / +.400693917417184240675446866355e-9_r8/
    DATA aip2cs(7) / -.367331242795905044199318496207e-10_r8/
    DATA aip2cs(8) / +.376034439592373852439592002918e-11_r8/
    DATA aip2cs(9) / -.422321332718747538026564938968e-12_r8/
    DATA aip2cs(10) / +.513509454033657070919618754120e-13_r8/
    DATA aip2cs(11) / -.669095850390477595651681356676e-14_r8/
    DATA aip2cs(12) / +.926667545641290648239550724382e-15_r8/
    DATA aip2cs(13) / -.135514382416070576333397356591e-15_r8/
    DATA aip2cs(14) / +.208115496312830995299006549335e-16_r8/
    DATA aip2cs(15) / -.334116499159176856871277570256e-17_r8/
    DATA bifcs(0) / -.16730216471986649483537423928176e-1_r8/
    DATA bifcs(1) / +.10252335834249445611426362777757e+0_r8/
    DATA bifcs(2) / +.17083092507381516539429650242013e-2_r8/
    DATA bifcs(3) / +.11862545467744681179216459210040e-4_r8/
    DATA bifcs(4) / +.44932907017792133694531887927242e-7_r8/
    DATA bifcs(5) / +.10698207143387889067567767663628e-9_r8/
    DATA bifcs(6) / +.17480643399771824706010517628573e-12_r8/
    DATA bifcs(7) / +.20810231071761711025881891834399e-15_r8/
    DATA bigcs(0) / +.22466223248574522283468220139024e-1_r8/
    DATA bigcs(1) / +.37364775453019545441727561666752e-1_r8/
    DATA bigcs(2) / +.44476218957212285696215294326639e-3_r8/
    DATA bigcs(3) / +.24708075636329384245494591948882e-5_r8/
    DATA bigcs(4) / +.79191353395149635134862426285596e-8_r8/
    DATA bigcs(5) / +.16498079851827779880887872402706e-10_r8/
    DATA bigcs(6) / +.24119906664835455909247501122841e-13_r8/
    DATA bigcs(7) / +.26103736236091436985184781269333e-16_r8/
    DATA bif2cs(0) / +.0998457269381604104468284257993e+0_r8/
    DATA bif2cs(1) / +.47862497786300553772211467318231e+0_r8/
    DATA bif2cs(2) / +.25155211960433011771324415436675e-1_r8/
    DATA bif2cs(3) / +.58206938852326456396515697872216e-3_r8/
    DATA bif2cs(4) / +.74997659644377865943861457378217e-5_r8/
    DATA bif2cs(5) / +.61346028703493836681403010356474e-7_r8/
    DATA bif2cs(6) / +.34627538851480632900434268733359e-9_r8/
    DATA bif2cs(7) / +.14288910080270254287770846748931e-11_r8/
    DATA bif2cs(8) / +.44962704298334641895056472179200e-14_r8/
    DATA bif2cs(9) / +.11142323065833011708428300106666e-16_r8/
    DATA big2cs(0) / +.033305662145514340465176188111647e+0_r8/
    DATA big2cs(1) / +.161309215123197067613287532084943e+0_r8/
    DATA big2cs(2) / +.631900730961342869121615634921173e-2_r8/
    DATA big2cs(3) / +.118790456816251736389780192304567e-3_r8/
    DATA big2cs(4) / +.130453458862002656147116485012843e-5_r8/
    DATA big2cs(5) / +.937412599553521729546809615508936e-8_r8/
    DATA big2cs(6) / +.474580188674725153788510169834595e-10_r8/
    DATA big2cs(7) / +.178310726509481399800065667560946e-12_r8/
    DATA big2cs(8) / +.516759192784958180374276356640000e-15_r8/   
    DATA bip1cs(0) / -.83220474779434474687471864707973e-1_r8/
    DATA bip1cs(1) / +.11461189273711742889920226128031e-1_r8/
    DATA bip1cs(2) / +.42896440718911509494134472566635e-3_r8/
    DATA bip1cs(3) / -.14906639379950514017847677732954e-3_r8/
    DATA bip1cs(4) / -.13076597267876290663136340998881e-4_r8/
    DATA bip1cs(5) / +.63275983961030344754535716032494e-5_r8/
    DATA bip1cs(6) / -.42226696982681924884778515889433e-6_r8/
    DATA bip1cs(7) / -.19147186298654689632835494181277e-6_r8/
    DATA bip1cs(8) / +.64531062845583173611038157880934e-7_r8/
    DATA bip1cs(9) / -.78448546771397719289748310448628e-8_r8/
    DATA bip1cs(10) / -.96077216623785085879198533565432e-9_r8/
    DATA bip1cs(11) / +.70004713316443966339006074402068e-9_r8/
    DATA bip1cs(12) / -.17731789132814932022083128056698e-9_r8/
    DATA bip1cs(13) / +.22720894783465236347282126389311e-10_r8/
    DATA bip1cs(14) / +.16540456313972049847032860681891e-11_r8/
    DATA bip1cs(15) / -.18517125559292316390755369896693e-11_r8/
    DATA bip1cs(16) / +.59576312477117290165680715534277e-12_r8/
    DATA bip1cs(17) / -.12194348147346564781055769498986e-12_r8/
    DATA bip1cs(18) / +.13347869253513048815386347813597e-13_r8/
    DATA bip1cs(19) / +.17278311524339746664384792889731e-14_r8/
    DATA bip1cs(20) / -.14590732013016720735268871713166e-14_r8/
    DATA bip1cs(21) / +.49010319927115819978994989520104e-15_r8/
    DATA bip1cs(22) / -.11556545519261548129262972762521e-15_r8/
    DATA bip1cs(23) / +.19098807367072411430671732441524e-16_r8/
    DATA bip2cs(0) / -.11359673758598867913797310895527e+0_r8/
    DATA bip2cs(1) / +.41381473947881595760052081171444e-2_r8/
    DATA bip2cs(2) / +.13534706221193329857696921727508e-3_r8/
    DATA bip2cs(3) / +.10427316653015353405887183456780e-4_r8/
    DATA bip2cs(4) / +.13474954767849907889589911958925e-5_r8/
    DATA bip2cs(5) / +.16965374054383983356062511163756e-6_r8/
    DATA bip2cs(6) / -.10096500865641624301366228396373e-7_r8/
    DATA bip2cs(7) / -.16729119493778475127836973095943e-7_r8/
    DATA bip2cs(8) / -.45815364485068383217152795613391e-8_r8/
    DATA bip2cs(9) / +.37366813665655477274064749384284e-9_r8/
    DATA bip2cs(10) / +.57669303201452448119584643502111e-9_r8/
    DATA bip2cs(11) / +.62181265087850324095393408792371e-10_r8/
    DATA bip2cs(12) / -.63294120282743068241589177281354e-10_r8/
    DATA bip2cs(13) / -.14915047908598767633999091989487e-10_r8/
    DATA bip2cs(14) / +.78896213942486771938172394294891e-11_r8/
    DATA bip2cs(15) / +.24960513721857797984888064000127e-11_r8/
    DATA bip2cs(16) / -.12130075287291659477746664734814e-11_r8/
    DATA bip2cs(17) / -.37404939108727277887343460402716e-12_r8/
    DATA bip2cs(18) / +.22377278140321476798783446931091e-12_r8/
    DATA bip2cs(19) / +.47490296312192466341986077472514e-13_r8/
    DATA bip2cs(20) / -.45261607991821224810605655831294e-13_r8/
    DATA bip2cs(21) / -.30172271841986072645112245876020e-14_r8/
    DATA bip2cs(22) / +.91058603558754058327592683478908e-14_r8/
    DATA bip2cs(23) / -.98149238033807062926643864207709e-15_r8/
    DATA bip2cs(24) / -.16429400647889465253601245251589e-14_r8/
    DATA bip2cs(25) / +.55334834214274215451182114635164e-15_r8/
    DATA bip2cs(26) / +.21750479864482655984374381998156e-15_r8/
    DATA bip2cs(27) / -.17379236200220656971287029558087e-15_r8/
    DATA bip2cs(28) / -.10470023471443714959283909313604e-17_r8/
    DATA bip2cs(29) / +.39219145986056386925441403311462e-16_r8/
    DATA bip2cs(30) / -.11621293686345196925824005665910e-16_r8/
    DATA bip2cs(31) / -.54027474491754245533735411307773e-17_r8/
    DATA daifcs(0) /  0.105274612265314088088970057325134114e0_r8/
    DATA daifcs(1) /  0.011836136281529978442889292583980840e0_r8/
    DATA daifcs(2) /  0.000123281041732256643051689242469164e0_r8/
    DATA daifcs(3) /  0.000000622612256381399016825658693579e0_r8/
    DATA daifcs(4) /  0.000000001852988878441452950548140821e0_r8/
    DATA daifcs(5) /  0.000000000003633288725904357915995625e0_r8/
    DATA daifcs(6) /  0.000000000000005046217040440664768330e0_r8/
    DATA daifcs(7) /  0.000000000000000005223816555471480985e0_r8/
    DATA daifcs(8) /  0.000000000000000000004185745090748989e0_r8/
    DATA daigcs(0) /  0.0212338781509186668523122276848937e0_r8/
    DATA daigcs(1) /  0.0863159303352144067524942809461604e0_r8/
    DATA daigcs(2) /  0.0017975947203832313578033963225230e0_r8/
    DATA daigcs(3) /  0.0000142654998755506932526620687495e0_r8/
    DATA daigcs(4) /  0.0000000594379952836832010488787064e0_r8/
    DATA daigcs(5) /  0.0000000001524033664794478945214786e0_r8/
    DATA daigcs(6) /  0.0000000000002645876603490435305100e0_r8/
    DATA daigcs(7) /  0.0000000000000003315624296815020591e0_r8/
    DATA daigcs(8) /  0.0000000000000000003139789757594792e0_r8/
    DATA daip2cs(0) /  0.0065457691989713756794276979067064e0_r8/
    DATA daip2cs(1) /  0.0023833724120774591992772552886923e0_r8/
    DATA daip2cs(2) / -0.0000430700770220585862775012110584e0_r8/
    DATA daip2cs(3) /  0.0000015629125858629202330785369063e0_r8/
    DATA daip2cs(4) / -0.0000000815417186162706965112501015e0_r8/
    DATA daip2cs(5) /  0.0000000054103738056935918208008783e0_r8/
    DATA daip2cs(6) / -0.0000000004284130882614696528766222e0_r8/
    DATA daip2cs(7) /  0.0000000000389497962832286424862198e0_r8/
    DATA daip2cs(8) / -0.0000000000039623161264979257658071e0_r8/
    DATA daip2cs(9) /  0.0000000000004428184214405989602353e0_r8/
    DATA daip2cs(10) / -0.0000000000000536296527150689675318e0_r8/
    DATA daip2cs(11) /  0.0000000000000069649872139936028200e0_r8/
    DATA daip2cs(12) / -0.0000000000000009619636286095319210e0_r8/
    DATA daip2cs(13) /  0.0000000000000001403454967784808032e0_r8/
    DATA daip2cs(14) / -0.0000000000000000215097136525875715e0_r8/
    DATA daip2cs(15) /  0.0000000000000000034471230632678283e0_r8/
    DATA daip1cs(0) /  0.0358865097808301537956710489261688e0_r8/
    DATA daip1cs(1) /  0.0114668575627764898572700883121766e0_r8/
    DATA daip1cs(2) / -0.0007592073583861400301335647601603e0_r8/
    DATA daip1cs(3) /  0.0000869517610893841271948619434021e0_r8/
    DATA daip1cs(4) / -0.0000128237294298591691789607600486e0_r8/
    DATA daip1cs(5) /  0.0000022062695681038336934376250420e0_r8/
    DATA daip1cs(6) / -0.0000004222295185920749486945988432e0_r8/
    DATA daip1cs(7) /  0.0000000874686415726348479356130376e0_r8/
    DATA daip1cs(8) / -0.0000000192773588418365388625693417e0_r8/
    DATA daip1cs(9) /  0.0000000044668460054492719699777137e0_r8/
    DATA daip1cs(10) / -0.0000000010790108051948168015747466e0_r8/
    DATA daip1cs(11) /  0.0000000002700029446696248083071434e0_r8/
    DATA daip1cs(12) / -0.0000000000696480108007915257318929e0_r8/
    DATA daip1cs(13) /  0.0000000000184489907003246687076806e0_r8/
    DATA daip1cs(14) / -0.0000000000050027817358071698301149e0_r8/
    DATA daip1cs(15) /  0.0000000000013852243366012168297298e0_r8/
    DATA daip1cs(16) / -0.0000000000003908218466657048253473e0_r8/
    DATA daip1cs(17) /  0.0000000000001121536072524563451273e0_r8/
    DATA daip1cs(18) / -0.0000000000000326861522579502522443e0_r8/
    DATA daip1cs(19) /  0.0000000000000096619179010090805752e0_r8/
    DATA daip1cs(20) / -0.0000000000000028934767442698434271e0_r8/
    DATA daip1cs(21) /  0.0000000000000008770086661150897069e0_r8/
    DATA daip1cs(22) / -0.0000000000000002688046261195853754e0_r8/
    DATA daip1cs(23) /  0.0000000000000000832498823872342992e0_r8/
    DATA daip1cs(24) / -0.0000000000000000260343254786947057e0_r8/
    DATA daip1cs(25) /  0.0000000000000000082159528142686287e0_r8/
    DATA daip1cs(26) / -0.0000000000000000026150406704984940e0_r8/
    DATA dbifcs(0) /  0.115353679082857024267474446284908879e0_r8/
    DATA dbifcs(1) /  0.020500789404919287530357789445940252e0_r8/
    DATA dbifcs(2) /  0.000213529027890287581892679619451158e0_r8/
    DATA dbifcs(3) /  0.000001078396061467683042209155523569e0_r8/
    DATA dbifcs(4) /  0.000000003209470883320666783353670420e0_r8/
    DATA dbifcs(5) /  0.000000000006293040671833540390213316e0_r8/
    DATA dbifcs(6) /  0.000000000000008740304300063083340121e0_r8/
    DATA dbifcs(7) /  0.000000000000000009047915683496049529e0_r8/
    DATA dbigcs(0) / -0.0971964404164435373897790974606802e0_r8/
    DATA dbigcs(1) /  0.1495035768431670665710843445326264e0_r8/
    DATA dbigcs(2) /  0.0031135253871213260419419176839631e0_r8/
    DATA dbigcs(3) /  0.0000247085705798212967777021920569e0_r8/
    DATA dbigcs(4) /  0.0000001029496277313786081987324295e0_r8/
    DATA dbigcs(5) /  0.0000000002639703739869432892676778e0_r8/
    DATA dbigcs(6) /  0.0000000000004582792707803206608181e0_r8/
    DATA dbigcs(7) /  0.0000000000000005742829740893447321e0_r8/
    DATA dbif2cs(0) /  0.32349398760352203352119193596266015e0_r8/
    DATA dbif2cs(1) /  0.08629787153556355913888835323811100e0_r8/
    DATA dbif2cs(2) /  0.00299402555265539742613821050727155e0_r8/
    DATA dbif2cs(3) /  0.00005143052836466163720464316950821e0_r8/
    DATA dbif2cs(4) /  0.00000052584025003681146026033098613e0_r8/
    DATA dbif2cs(5) /  0.00000000356175137395770028102730600e0_r8/
    DATA dbif2cs(6) /  0.00000000001714686400714584830518308e0_r8/
    DATA dbif2cs(7) /  0.00000000000006166351969232555406693e0_r8/
    DATA dbif2cs(8) /  0.00000000000000017191082154315985806e0_r8/
    DATA dbif2cs(9) /  0.00000000000000000038236889518803943e0_r8/ 
    DATA dbig2cs(0) /  1.606299946362129457759284537862622883e0_r8/
    DATA dbig2cs(1) /  0.744908881987608865201476685194753972e0_r8/
    DATA dbig2cs(2) /  0.047013873861027737964095177635353019e0_r8/
    DATA dbig2cs(3) /  0.001228442206254823907016188785848091e0_r8/
    DATA dbig2cs(4) /  0.000017322241225662362670987355613727e0_r8/
    DATA dbig2cs(5) /  0.000000152190165236801893711508366563e0_r8/
    DATA dbig2cs(6) /  0.000000000911356024911957704145528786e0_r8/
    DATA dbig2cs(7) /  0.000000000003954791842356644201722554e0_r8/
    DATA dbig2cs(8) /  0.000000000000013001737033862320007309e0_r8/
    DATA dbip2cs(0) / -0.13269705443526630494937031210217135e0_r8/
    DATA dbip2cs(1) / -0.00568443626045977481306046339037428e0_r8/
    DATA dbip2cs(2) / -0.00015643601119611609623698471216660e0_r8/
    DATA dbip2cs(3) / -0.00001136737203679562267336053207940e0_r8/
    DATA dbip2cs(4) / -0.00000143464350991283669643136951338e0_r8/
    DATA dbip2cs(5) / -0.00000018098531185164131868746481700e0_r8/
    DATA dbip2cs(6) /  0.00000000926177343610865546229511422e0_r8/
    DATA dbip2cs(7) /  0.00000001710005490720592181887296162e0_r8/
    DATA dbip2cs(8) /  0.00000000476698163503781708252686849e0_r8/
    DATA dbip2cs(9) / -0.00000000035195022023163141945397159e0_r8/
    DATA dbip2cs(10) / -0.00000000058890614315886871574147635e0_r8/
    DATA dbip2cs(11) / -0.00000000006678499607795537597612089e0_r8/
    DATA dbip2cs(12) /  0.00000000006395565101720391190697713e0_r8/
    DATA dbip2cs(13) /  0.00000000001554529427064394106403245e0_r8/
    DATA dbip2cs(14) / -0.00000000000792396999744612971684001e0_r8/
    DATA dbip2cs(15) / -0.00000000000258326242689717798947525e0_r8/
    DATA dbip2cs(16) /  0.00000000000121655047787849117978773e0_r8/
    DATA dbip2cs(17) /  0.00000000000038707207172899985942258e0_r8/
    DATA dbip2cs(18) / -0.00000000000022487045479618229130656e0_r8/
    DATA dbip2cs(19) / -0.00000000000004953476515684046293493e0_r8/
    DATA dbip2cs(20) /  0.00000000000004563781601526912756017e0_r8/
    DATA dbip2cs(21) /  0.00000000000000332998314345014118494e0_r8/
    DATA dbip2cs(22) / -0.00000000000000921750185832874202719e0_r8/
    DATA dbip2cs(23) /  0.00000000000000094156670658958205765e0_r8/
    DATA dbip2cs(24) /  0.00000000000000167153952640716157721e0_r8/
    DATA dbip2cs(25) / -0.00000000000000055134268782182410852e0_r8/
    DATA dbip2cs(26) / -0.00000000000000022368651572006617795e0_r8/
    DATA dbip2cs(27) /  0.00000000000000017486948976520089209e0_r8/
    DATA dbip2cs(28) /  0.00000000000000000206518666352329750e0_r8/
    DATA dbip2cs(29) / -0.00000000000000003973060018130712479e0_r8/
    DATA dbip2cs(30) /  0.00000000000000001154836935724892335e0_r8/
    DATA dbip2cs(31) /  0.00000000000000000553906053678276421e0_r8/
    DATA dbip1cs(0) / -0.17291873510795537186124679823741003e0_r8/
    DATA dbip1cs(1) / -0.01493584929846943639486231021818675e0_r8/
    DATA dbip1cs(2) / -0.00054711049516785663990658697874460e0_r8/
    DATA dbip1cs(3) /  0.00015379662929584083449573727856666e0_r8/
    DATA dbip1cs(4) /  0.00001543534761921794131028948022869e0_r8/
    DATA dbip1cs(5) / -0.00000654341138519060129226087106765e0_r8/
    DATA dbip1cs(6) /  0.00000037280824078787032232152275240e0_r8/
    DATA dbip1cs(7) /  0.00000020720783881887480080810710514e0_r8/
    DATA dbip1cs(8) / -0.00000006581733364696191689495883922e0_r8/
    DATA dbip1cs(9) /  0.00000000749267463539288212986048985e0_r8/
    DATA dbip1cs(10) /  0.00000000111013368840707147698890101e0_r8/
    DATA dbip1cs(11) / -0.00000000072651405529159512323880794e0_r8/
    DATA dbip1cs(12) /  0.00000000017827235598470153962165668e0_r8/
    DATA dbip1cs(13) / -0.00000000002173463524809506269656807e0_r8/
    DATA dbip1cs(14) / -0.00000000000203020349653882594017049e0_r8/
    DATA dbip1cs(15) /  0.00000000000193118272294077519319859e0_r8/
    DATA dbip1cs(16) / -0.00000000000060449525048290296023117e0_r8/
    DATA dbip1cs(17) /  0.00000000000012094496248933664277802e0_r8/
    DATA dbip1cs(18) / -0.00000000000001251088360074479784619e0_r8/
    DATA dbip1cs(19) / -0.00000000000000199173832424881344036e0_r8/
    DATA dbip1cs(20) /  0.00000000000000151540816342864303038e0_r8/
    DATA dbip1cs(21) / -0.00000000000000049768927059816240250e0_r8/
    DATA dbip1cs(22) /  0.00000000000000011545959731810501403e0_r8/
    DATA dbip1cs(23) / -0.00000000000000001863286862907983871e0_r8/  
    atr=8.75069057084843450880771988210148_r8 
    btr=-2.09383632135605431360096498526268_r8 
    eta = 0.1*mactol
    naif=8; naig=8; naip1=26; naip2=15
    nbif=7; nbig=7; nbif2=9; nbig2=8; nbip1=23; nbip2=31
    x3sml = eta**0.33330_r8
    x32sml = 1.3104e0_r8*x3sml*x3sml
    x2sml=sqrt(eta)
    xbig = giant**0.6666_r8
    IF (x<=1) THEN
      z = 0.0_r8
      IF (abs(x)>x3sml) z = x*x*x
      daie = 0.375_r8 + (chepolsum (naif, z, aifcs) - x*(0.25_r8 +&
            chepolsum (naig, z, aigcs)) )
      dbie = 0.625_r8 + chepolsum (nbif, z, bifcs) + x*(0.4375_r8 +&
            chepolsum(nbig,z, bigcs) )
      x2 = 0.0_r8
      if (abs(x)>x2sml) x2 = x*x
      daide = (x2*(0.125_r8 + chepolsum(naif,z, daifcs)) -&
              chepolsum(naig,z,daigcs)) - 0.25_r8
      dbide = x2*(chepolsum(nbif, z, dbifcs) + 0.25_r8) +&                          
              chepolsum(nbig, z, dbigcs) + 0.5_r8                      
      IF (x>x32sml) THEN
        factor=2.0_r8*x*sqrt(x)/3.0_r8
        daie = daie * exp(factor)
        dbie = dbie * exp(-factor)
        daide = daide * exp(factor)
        dbide = dbide * exp (-factor)
      ENDIF
    ELSEIF (x<=2) THEN
      sqrtx = sqrt(x)
      sqsqrtx=sqrt(sqrtx)
      z = (16.0_r8/(x*sqrtx)- 9.0_r8)/7.0_r8
      daie = (0.28125_r8 + chepolsum(naip1, z, aip1cs))/sqsqrtx
      daide = (-0.28125_r8 - chepolsum(naip1, z, daip1cs))*sqsqrtx
      z = (2.0_r8*x**3 - 9.0_r8)/7.0_r8
      dbie=exp(-2.0_r8*x*sqrtx/3.0_r8)* (1.125_r8 +&
            chepolsum(nbif2,z, bif2cs) + x*(0.625_r8 + chepolsum(nbig2,z, big2cs)))
      dbide=exp(-2.0_r8*x*sqrtx/3.0_r8) *(x*x*(0.25_r8 +&
            chepolsum(nbif2, z, dbif2cs)) + 0.5_r8 + chepolsum (nbig2, z, dbig2cs))
    ELSEIF (x<=4) THEN 
      sqrtx = sqrt(x)
      sqsqrtx=sqrt(sqrtx)
      z = (16.0_r8/(x*sqrtx)- 9.0_r8)/7.0_r8
      daie = (0.28125_r8 + chepolsum(naip1, z, aip1cs))/sqsqrtx
      daide = (-0.28125_r8 - chepolsum(naip1, z, daip1cs))*sqsqrtx
      z = atr/(x*sqrtx) + btr
      dbie = (0.625_r8 + chepolsum(nbip1,z,bip1cs))/sqsqrtx
      dbide = (0.625_r8 + chepolsum(nbip1,z, dbip1cs))*sqsqrtx
    ELSE  
      sqrtx = sqrt(x)
      sqsqrtx=sqrt(sqrtx)
      z = -1.0_r8
      IF (x<xbig) z = 16.0_r8/(x*sqrtx) - 1.0_r8
      daie = (0.28125_r8 + chepolsum(naip2, z, aip2cs))/sqsqrtx
      daide = (-0.28125_r8 - chepolsum(naip2, z, daip2cs))*sqsqrtx
      dbie = (0.625_r8 + chepolsum (nbip2,z, bip2cs))/sqsqrtx
      dbide = (0.625_r8 + chepolsum(nbip2, z, dbip2cs)) * sqsqrtx
    ENDIF
    END SUBROUTINE airsca
  END MODULE AiryFunction




