
!  This is a test program for FM 1.3, a multiple-precision arithmetic package.

!  All of the FM (floating-point real) and ZM (floating-point complex) routines are tested.
!  Precision is set to 50 significant digits and the results are checked to that accuracy.
!  A few constants are computed with 20,000 significant digits to test the routines that
!  use special algorithms for very high precision.
!  All of the IM (integer) routines are tested, with exact results required to pass the tests.
!  All of the USE FMZM derived type interface routines are tested in the same manner as those
!  described above.

!  If all tests are completed successfully, this line is printed:

!  3195 cases tested.  No errors were found.

      MODULE TEST_VARS

      USE FMVALS
      USE FMZM

!             Declare the derived type variables of type (FM), (IM), and (ZM).
!             These are in the form that would be found in a user program.

      TYPE (FM), SAVE ::  M_A, M_B, M_C, M_D, MFM1, MFM2, MFM3, MFM4, MFM5, MFM6, MSMALL,  &
                          MFMV1(3),  MFMV2(3),  MFMV4(3),  MFMV3(2),                       &
                          MFMA(3,3), MFMB(3,3), MFMC(3,3), MFMD(2,2), MFME(3,2), MFMF(2,3)

!             These are the integer multiple precision variables.

      TYPE (IM), SAVE :: M_J, M_K, M_L,  MIM1,  MIM2,  MIM3, MIM4, MIM5
      TYPE (IM), SAVE, DIMENSION(3)   :: MIMV1, MIMV2, MIMV4
      TYPE (IM), SAVE, DIMENSION(2)   :: MIMV3
      TYPE (IM), SAVE, DIMENSION(2,2) :: MIMA,  MIMB,  MIMC
      TYPE (IM), SAVE, DIMENSION(3,2) :: MIMD
      TYPE (IM), SAVE, DIMENSION(2,3) :: MIME
      TYPE (IM), SAVE, DIMENSION(3,3) :: MIMA2, MIMB2, MIMC2

!             These are the complex multiple precision variables.

      TYPE (ZM), SAVE :: M_X, M_Y, M_Z, MZM1, MZM2, MZM3, MZM4, MZM5,              &
                         MZMV1(3),   MZMV2(3),   MZMV4(3),   MZMV3(2),  MZMV5(4),  &
                         MZMA(2,3),  MZMB(3,4),  MZMC(2,4),  MZMD(3,2),            &
                         MZMA2(3,3), MZMB2(3,3), MZMC2(3,3), MZMA3(3,3)

!             Declare and initialize some other multiple precision variables.
!             These are in the internal form used in the basic arithmetic routines.

      INTEGER :: MA, MB, MC, MD, ME, MP1, MP2, MP3, MP4, MP5, MLNSV2, MLNSV3, MLNSV5, MLNSV7
      DATA MA, MB, MC, MD, ME, MP1, MP2, MP3, MP4, MP5, MLNSV2, MLNSV3, MLNSV5, MLNSV7 / 14 * -2 /
      INTEGER :: ZA(2), ZB(2), ZC(2), ZD(2), ZE(2), ZP1(2), ZP2(2), ZP3(2), ZP4(2), ZP5(2)
      DATA ZA, ZB, ZC, ZD, ZE, ZP1, ZP2, ZP3, ZP4, ZP5 / 20 * -2 /

!             These are the variables that are not multiple precision.

      INTEGER, SAVE :: J1, J2, J3, J4, J5, JV(3), JV2(3,3)
      REAL, SAVE :: R1, R2, R3, R4, R5, RSMALL, RV(3), RV2(3,3)
      DOUBLE PRECISION, SAVE :: D1, D2, D3, D4, D5, DSMALL, DV(3), DV2(3,3)
      COMPLEX, SAVE :: C1, C2, C3, C4, C5, CV(3), CV2(3,3)
      COMPLEX (KIND(0.0D0)), SAVE :: CD1, CD2, CD3, CD4, CDV(3), CDV2(3,3)

      CHARACTER(80), SAVE :: ST1, ST2, STRING, STV(3), STV2(3,3)
      CHARACTER(160), SAVE :: STZ1, STZ2
      CHARACTER, SAVE :: LINE(10), LINE2(80), LINE3(160)
      INTEGER, SAVE :: I, IREM, J, JERR, JEXP, K, KLOG, L1, L2, KST, KWSAVE,  &
                       NCASE, NDGSAV, NERROR, NSTACK(49), SEED(7)
      REAL, SAVE :: TIME1, TIME2
      REAL (KIND(1.0D0)) :: MBSAVE
      LOGICAL, EXTERNAL :: FMCOMP, FMCOMPARE, FPCOMP, FPCOMPARE,  &
                           IMCOMP, IMCOMPARE, IPCOMP, IPCOMPARE

      END MODULE TEST_VARS

      MODULE TEST_A
      USE TEST_VARS

      INTERFACE POWER
         MODULE PROCEDURE POWER_FM
         MODULE PROCEDURE POWER_IM
         MODULE PROCEDURE POWER_ZM
      END INTERFACE

      INTERFACE MATRIX_PRODUCT
         MODULE PROCEDURE MATRIX_PRODUCT_FM
         MODULE PROCEDURE MATRIX_PRODUCT_IM
         MODULE PROCEDURE MATRIX_PRODUCT_ZM
      END INTERFACE

      INTERFACE MATRIX_SQUARE
         MODULE PROCEDURE MATRIX_SQUARE_FM
         MODULE PROCEDURE MATRIX_SQUARE_IM
         MODULE PROCEDURE MATRIX_SQUARE_ZM
      END INTERFACE

      CONTAINS

      SUBROUTINE TEST1

!  Input and output testing.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing input and output routines.')")

!             NCASE is the number of the case being tested.

      NCASE = 1
      CALL FMST2M('123',MA)
      CALL FMI2M(123,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)

!             Use the .NOT. because FMCOMPARE returns FALSE for special cases like MD = UNKNOWN,
!             and these should be treated as errors for these tests.

      IF (.NOT.FMCOMPARE(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMST2M',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 2
      ST1 = '1.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMI2M(131,MB)
      CALL FMI2M(97,MC)
      CALL FMDIV(MB,MC,ME)
      CALL FMEQ(ME,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMPARE(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMST2M',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 3
      ST1 = '1.3505154639175257731958762886597938144329896907216495E-2'
      CALL FMST2M(ST1,MA)
      CALL FMI2M(131,MB)
      CALL FMI2M(9700,MC)
      CALL FMDIV(MB,MC,ME)
      CALL FMEQ(ME,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-52',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMST2M',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 4
      ST1 = '1.3505154639175257731958762886597938144329896907216495E-2'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('F40.30',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '         .013505154639175257731958762887'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF ((.NOT.FMCOMP(MD,'LE',MB)) .OR. ST1 /= ST2) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 5
      ST1 = '1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('F53.33',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '13505154639175257.731958762886597938144329896907216'
      CALL FMST2M(ST1,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 6
      ST1 = '1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('I24',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '13505154639175258'
      CALL FMST2M(ST1,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 7
      ST1 ='-1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('E55.49',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '-1.350515463917525773195876288659793814432989690722D16'
      CALL FMST2M(ST1,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 8
      ST1 ='-1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('ES54.45',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '-1.350515463917525773195876288659793814432989691M+16'
      CALL FMST2M(ST1,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 9
      ST1 ='-1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FMST2M(ST1,MA)
      CALL FMFORM('1PE54.45',MA,ST2)
      CALL FMST2M(ST2,MA)
      ST1 = '-1.350515463917525773195876288659793814432989691M+16'
      CALL FMST2M(ST1,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMFORM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      CALL FM_SETVAR(' MBASE = 10000 ')
      CALL FM_SETVAR(' NDIG = 7 ')
      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 10
      STZ1 = '0.123456789012345678901234567849999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 11
      STZ1 = '0.12345678901234567890123456785'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 12
      STZ1 = '0.12345678901234567890123456785'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 13
      STZ1 = '0.12345678901234567890123456775'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 14
      STZ1 = '0.123456789012345678901234567850000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345679'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 15
      STZ1 = '0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 16
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 17
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 18
      STZ1 = '0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 19
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 20
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 21
      STZ1 = '0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 22
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 23
      STZ1 = '0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF



      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 24
      STZ1 = '-0.123456789012345678901234567849999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 25
      STZ1 = '-0.12345678901234567890123456785'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 26
      STZ1 = '-0.12345678901234567890123456785'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 27
      STZ1 = '-0.12345678901234567890123456775'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 28
      STZ1 = '-0.123456789012345678901234567850000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345679'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 29
      STZ1 = '-0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 30
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 31
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 32
      STZ1 = '-0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 33
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 34
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345678'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 35
      STZ1 = '-0.123456789012345678901234567799999999999999999999999999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 36
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000000'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 37
      STZ1 = '-0.12345678901234567890123456770000000000000000000000000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.1234567890123456789012345677'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 1 ')
      CALL FM_SETVAR(' MBASE = 2 ')
      CALL FM_SETVAR(' NDIG = 53 ')

      NCASE = 38
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 39
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.90000000000000002220446049250313080847263336181640625'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 40
      STZ1 = '0.900000000000000077715611723760957829654216766357421875'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(9)/10 , TO_FM(1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 41
      STZ1 = '0.900000000000000077715611723760957829654216766357421875000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(9)/10 , TO_FM(1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 42
      STZ1 = '0.900000000000000077715611723760957829654216766357421874999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 43
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 44
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.90000000000000002220446049250313080847263336181640625'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 45
      STZ1 = '0.900000000000000022204460492503130808472633361816406250000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(9)/10 , TO_FM(1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 46
      STZ1 = '0.900000000000000022204460492503130808472633361816406249999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 47
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 48
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.899999999999999911182158029987476766109466552734375'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 49
      STZ1 = '0.8999999999999999111821580299874767661094665527343750000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 50
      STZ1 = '0.8999999999999999111821580299874767661094665527343749999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(9)/10 , TO_FM(-1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 51
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 52
      STZ1 = '0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '0.899999999999999911182158029987476766109466552734375'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 53
      STZ1 = '0.8999999999999999111821580299874767661094665527343750000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 54
      STZ1 = '0.8999999999999999111821580299874767661094665527343749999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(9)/10 , TO_FM(-1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 55
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 56
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.90000000000000002220446049250313080847263336181640625'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 57
      STZ1 = '-0.900000000000000077715611723760957829654216766357421875'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(-9)/10 , TO_FM(-1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 58
      STZ1 = '-0.900000000000000077715611723760957829654216766357421875000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(-9)/10 , TO_FM(-1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 59
      STZ1 = '-0.900000000000000077715611723760957829654216766357421874999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 60
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 61
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.899999999999999911182158029987476766109466552734375'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 62
      STZ1 = '-0.899999999999999911182158029987476766109466552734375000000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 63
      STZ1 = '-0.899999999999999911182158029987476766109466552734374999999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(-9)/10 , TO_FM(1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 64
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 65
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.90000000000000002220446049250313080847263336181640625'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 66
      STZ1 = '-0.90000000000000002220446049250313080847263336181640625000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(-9)/10 , TO_FM(-1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 67
      STZ1 = '-0.90000000000000002220446049250313080847263336181640624999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 68
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 69
      STZ1 = '-0.9'
      M_C =  TO_FM(STZ1)
      STZ1 = '-0.899999999999999911182158029987476766109466552734375'
      M_D = TO_FM(STZ1)
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 70
      STZ1 = '-0.8999999999999999111821580299874767661094665527343749999999999999999999999999999'
      M_C =  TO_FM(STZ1)
      M_D = NEAREST( TO_FM(-9)/10 , TO_FM(1) )
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 71
      STZ1 = '-0.8999999999999999111821580299874767661094665527343750000000000000000000000000001'
      M_C =  TO_FM(STZ1)
      M_D = TO_FM(-9)/10
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Input',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FM_SETVAR(' MBASE = 10000 ')
      CALL FM_SETVAR(' NDIG = 25 ')
      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 72
      STZ1 = '0.1234567890123456'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F20.14',M_A,ST1)
      WRITE (ST2,"(F20.14)") TO_DP(M_A)
      K = INDEX(ST2,'0.')
      IF (K > 0) ST2(K:K) = ' '
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 73
      STZ1 = '3.1234567890123456'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F20.14',M_A,ST1)
      WRITE (ST2,"(F20.14)") TO_DP(M_A)
      K = INDEX(ST2,'0.')
      IF (K > 0) ST2(K:K) = ' '
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 74
      STZ1 = '-3.1234567890123456'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F20.13',M_A,ST1)
      WRITE (ST2,"(F20.13)") TO_DP(M_A)
      K = INDEX(ST2,'0.')
      IF (K > 0) ST2(K:K) = ' '
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 75
      STZ1 = '3.1234567890123456e4'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('E25.14',M_A,ST1)
      WRITE (ST2,"(E25.14)") TO_DP(M_A)
      K = INDEX(ST2,'E+05')
      IF (K > 0) ST2(K:K+3) = 'M+5 '
      K = INDEX(ST2,'0.')
      IF (K > 0) THEN
          STZ2 = ST2(K+1:30)
          ST2(2:31) = STZ2(1:30)
      ENDIF
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 76
      STZ1 = '-3.1234567890123456e4'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('E25.13',M_A,ST1)
      WRITE (ST2,"(E25.13)") TO_DP(M_A)
      K = INDEX(ST2,'E+05')
      IF (K > 0) ST2(K:K+3) = 'M+5 '
      K = INDEX(ST2,'-0.')
      IF (K > 0) THEN
          ST2(K:K+1) = ' -'
          STZ2 = ST2(K+1:31)
          ST2(1:30) = STZ2(1:30)
      ENDIF
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 77
      STZ1 = '3.1234567890123456e4'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('ES25.14',M_A,ST1)
      WRITE (ST2,"(ES25.14)") TO_DP(M_A)
      K = INDEX(ST2,'E+04')
      IF (K > 0) ST2(K:K+3) = 'M+4 '
      K = INDEX(ST2,'3.')
      IF (K > 0) THEN
          STZ2 = ST2(K:30)
          ST2(2:31) = STZ2(1:30)
      ENDIF
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 78
      STZ1 = '-3.1234567890123456e4'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('ES25.13',M_A,ST1)
      WRITE (ST2,"(ES25.13)") TO_DP(M_A)
      K = INDEX(ST2,'E+04')
      IF (K > 0) ST2(K:K+3) = 'M+4 '
      K = INDEX(ST2,'-3.')
      IF (K > 0) THEN
          STZ2 = ST2(K:31)
          ST2(1:30) = STZ2(1:30)
      ENDIF
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 79
      STZ1 = '0.123456789012345678901234567849999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 80
      STZ1 = '0.123456789012345678901234567850000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345679'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 81
      STZ1 = '0.123456789012345678901234567850000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 82
      STZ1 = '0.123456789012345678901234567750000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 83
      STZ1 = '0.12345678901234567890123456749999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 84
      STZ1 = '0.12345678901234567890123456750000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234568'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 85
      STZ1 = '0.12345678901234567890123456750000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234568'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 86
      STZ1 = '0.12345678901234567890123456650000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234566'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 87
      STZ1 = '-0.123456789012345678901234567849999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 88
      STZ1 = '-0.123456789012345678901234567850000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345679'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 89
      STZ1 = '-0.123456789012345678901234567850000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 90
      STZ1 = '-0.123456789012345678901234567750000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 91
      STZ1 = '-0.12345678901234567890123456749999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 92
      STZ1 = '-0.12345678901234567890123456750000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234568'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 93
      STZ1 = '-0.12345678901234567890123456750000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234568'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 94
      STZ1 = '-0.12345678901234567890123456650000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234566'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SETVAR(' MBASE = 10000 ')
      CALL FM_SETVAR(' NDIG = 25 ')
      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 95
      STZ1 = '0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345679'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 96
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345679'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 97
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 98
      STZ1 = '0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234568'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 99
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234568'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 100
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 101
      STZ1 = '-0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 102
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 103
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 104
      STZ1 = '-0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 105
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 106
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SETVAR(' MBASE = 10000 ')
      CALL FM_SETVAR(' NDIG = 25 ')
      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 107
      STZ1 = '0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 108
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 109
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 110
      STZ1 = '0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 111
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 112
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 113
      STZ1 = '-0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345679'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 114
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345679'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 115
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 116
      STZ1 = '-0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234568'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 117
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234568'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 118
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SETVAR(' MBASE = 10000 ')
      CALL FM_SETVAR(' NDIG = 25 ')
      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 119
      STZ1 = '0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 120
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 121
      STZ1 = '0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  .1234567890123456789012345678'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 122
      STZ1 = '0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 123
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 124
      STZ1 = '0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  .123456789012345678901234567'
      ST2 = '    '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 125
      STZ1 = '-0.123456789012345678901234567899999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 126
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 127
      STZ1 = '-0.123456789012345678901234567800000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F35.28',M_A,ST1)
      ST2 = '  -.1234567890123456789012345678'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 128
      STZ1 = '-0.12345678901234567890123456799999999999999999999999999999999999999999999999999999'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 129
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000001'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 130
      STZ1 = '-0.12345678901234567890123456700000000000000000000000000000000000000000000000000000'
      M_A =  TO_FM(STZ1)
      CALL FM_FORM('F34.27',M_A,ST1)
      ST2 = '  -.123456789012345678901234567'
      ST2 = '   '//ST2
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SETVAR(' MBASE = 2 ')
      CALL FM_SETVAR(' NDIG = 53 ')
      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 131
      M_A =  TO_FM('6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.13',M_A,ST1)
      ST2 = ' .7700366561890M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 132
      M_A =  TO_FM('-6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.13',M_A,ST1)
      ST2 = '-.7700366561890M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 133
      M_A =  TO_FM('6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = ' .77003665618896M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 134
      M_A =  TO_FM('-6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = '-.77003665618895M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 135
      M_A =  TO_FM('6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = ' .77003665618895M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 136
      M_A =  TO_FM('-6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = '-.77003665618896M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 137
      M_A =  TO_FM('6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = ' .77003665618895M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 138
      M_A =  TO_FM('-6965949469487146') * TO_FM(2)**(-249)
      CALL FM_FORM('E25.14',M_A,ST1)
      ST2 = '-.77003665618895M-59'
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 139
      CALL FMSETVAR(' KROUND = 1 ')
      M_A = TO_FM('1.2e+44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' +OVERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 140
      M_A = TO_FM('-1.2e+44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' -OVERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 141
      M_A = TO_FM('1.2e-44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' +UNDERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 142
      M_A = TO_FM('-1.2e-44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' -UNDERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SET(50)

      NCASE = 143
      M_A = TO_FM('1.2e+44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' +OVERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 144
      M_A = TO_FM('-1.2e+44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' -OVERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 145
      M_A = TO_FM('1.2e-44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' +UNDERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      NCASE = 146
      M_A = TO_FM('-1.2e-44444444444444444444444444444444444444444444444444444444444')
      CALL FM_FORM('E25.14',M_A,ST1)
      M_B = TO_FM(' -UNDERFLOW ')
      CALL FM_FORM('E25.14',M_B,ST2)
      IF (.NOT.(ST1 == ST2)) CALL ERRPRT_STR(ST1,ST2)

      CALL FM_SET(50)
      RETURN
      END SUBROUTINE TEST1

      SUBROUTINE TEST2

!  Test add and subtract.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing add and subtract routines.')")

      NCASE = 147
      CALL FMST2M('123',MA)
      CALL FMST2M('789',MB)
      CALL FMADD(MA,MB,ME)
      CALL FMEQ(ME,MA)
      CALL FMI2M(912,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMADD ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 148
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMADD(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.0824742268041237113402061855670103092783505154639175'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMADD ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 149
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMSUB(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-.3814432989690721649484536082474226804123711340206185'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSUB ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 150
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.3505154639175257731443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMSUB(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '5.15463917525773195876288659793815M-20'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSUB ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 151
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMADDI(MA,1)
      ST2 = '1.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMADDI',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 152
      ST1 = '4.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMADDI(MA,5)
      ST2 = '9.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMADDI',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST2

      SUBROUTINE TEST3

!  Test multiply, divide and square root.

      IMPLICIT NONE

      CHARACTER(2000), SAVE :: STB
      TYPE (FM), SAVE :: M_H1, M_H2

      WRITE (KW,"(/' Testing multiply, divide and square root routines.')")

      NCASE = 153
      CALL FMST2M('123',MA)
      CALL FMST2M('789',MB)
      CALL FMMPY(MA,MB,ME)
      CALL FMEQ(ME,MA)
      CALL FMI2M(97047,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMMPY ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 154
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMMPY(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.2565628653416941226485280051014985652035285365075991'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMMPY ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 155
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMDIV(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.4788732394366197183098591549295774647887323943661972'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMDIV ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 156
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MA)
      CALL FMMPYI(MA,14,ME)
      CALL FMEQ(ME,MA)
      ST2 = '10.2474226804123711340206185567010309278350515463917526'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMMPYI',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 157
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MA)
      CALL FMDIVI(MA,24,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.0304982817869415807560137457044673539518900343642612'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMDIVI',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 158
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSQR(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.1228610904453183122542246784993091720692953555106813'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSQR ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 159
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSQRT(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.5920434645509785316136003710368759268547372945659987'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSQRT',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 160

!             Test allocate statements by a sequence of operations at increasing precision.
!             Also test FM_ENTER_USER_FUNCTION and FM_EXIT_USER_FUNCTION.

      CALL FMSET(500)
      M_H1 = HARMONIC_SUM(150)
      M_H2 = 1
      DO J = 2, 150
         M_H2 = M_H2 + 1/TO_FM(J)
      ENDDO
      MFM3 = ABS(M_H2 - M_H1)
      CALL FM_ST2M(' 1.0E-495 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 161
      MFM3 = M_H1*10**6
      CALL FM_FORM("I750",MFM3,STB(1:800))
      MFM3 = NINT(M_H1*10**6)
      MFM3 = ABS(MFM3 - TO_FM(STB(1:800)))
      IF (.NOT.(MFM3 == 0)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 162
      MFM3 = M_H1*10**6
      CALL FM_FORM("F902.900",MFM3,STB(1:910))
      MFM3 = M_H1*10**6
      MFM3 = ABS(MFM3 - TO_FM(STB(1:910)))
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 163
      MZM3 = M_H1*10**6
      CALL ZM_FORM("F902.900","F902.900",MZM3,STB(1:1820))
      MZM3 = M_H1*10**6
      MFM3 = ABS(MZM3 - TO_ZM(STB(1:1820)))
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      CALL FMSET(50)

      NCASE = 164
      MFM3 = 200
      MFM3 = FACTORIAL(MFM3)
      MFM4 = FACTORIAL2(200)
      MFM5 = ABS((MFM3-MFM4)/MFM3)
      IF (.NOT.(MFM5 < 1.0D-50)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 165
      MFM3 = 200
      MFM3 = FACTORIAL(MFM3)
      MIM4 = I_FACTORIAL(200)
      MFM5 = ABS((MFM3-MIM4)/MFM3)
      IF (.NOT.(MFM5 < 1.0D-50)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF
      NCASE = 166
      MFM3 = 200
      MFM4 = 99
      MFM3 = BINOMIAL(MFM3,MFM4)
      MZM4 = Z_FACTORIAL(200) / ( Z_FACTORIAL(99) * Z_FACTORIAL(101) )
      MFM5 = ABS((MFM3-MZM4)/MFM3)
      IF (.NOT.(MFM5 < 1.0D-50)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 167
      CALL H_SUM(TO_FM(0),1,150,MFM3)
      MFM4 = HARMONIC_SUM(150)
      MFM5 = ABS((MFM3-MFM4)/MFM3)
      IF (.NOT.(MFM5 < 1.0D-50)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 168
      MFMA(1,1:3) = (/ 3 , 1 , 4 /)
      MFMA(2,1:3) = (/ 1 , 5 , 9 /)
      MFMA(3,1:3) = (/ 2 , 6 , 5 /)
      MFMV1(1:3) = (/ 3.15D0 , 7.23D0 , 6.14D0 /)
      DO K = 1, 5
         MFMV1 = POWER(MFMA,MFMV1)
      ENDDO
      MFMV2 = (/  TO_FM(' 3.1542643547290503520828034216804200150468262227735M-1 ') ,  &
                  TO_FM(' 7.2306108656733102850197507313845978717562385025770M-1 ') ,  &
                  TO_FM(' 6.1456393393765623787137563007322207735298613009209M-1 ')    /)
      MFM5 = SQRT(DOT_PRODUCT(MFMV2-MFMV1,MFMV2-MFMV1))
      IF (.NOT.(MFM5 < 1.0D-25)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 169
      MIMA2(1,1:3) = (/ 3 , 1 , 4 /)
      MIMA2(2,1:3) = (/ 1 , 5 , 9 /)
      MIMA2(3,1:3) = (/ 2 , 6 , 5 /)
      MIMV1(1:3) = (/ 3.15D0 , 7.23D0 , 6.14D0 /) * 1.0D+20
      DO K = 1, 5
         MIMV1 = POWER(MIMA2,MIMV1)
      ENDDO
      MIMV2 = (/  TO_IM(' 31542643547290503520 ') ,  &
                  TO_IM(' 72306108656733102850 ') ,  &
                  TO_IM(' 61456393393765623787 ')    /)
      MFM5 = SQRT(TO_FM(DOT_PRODUCT(MIMV2-MIMV1,MIMV2-MIMV1)))
      IF (.NOT.(MFM5 < 1.0D+10)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 170
      MZMA2(1,1:3) = (/ 3 , 1 , 4 /)
      MZMA2(2,1:3) = (/ 1 , 5 , 9 /)
      MZMA2(3,1:3) = (/ 2 , 6 , 5 /)
      MZMV1(1:3) = (/ 3.15D0 , 7.23D0 , 6.14D0 /)
      MZMV1 = MZMV1 + TO_ZM(' 1E-3 i ')
      DO K = 1, 5
         MZMV1 = POWER(MZMA2,MZMV1)
      ENDDO
      MZMV2 = (/  TO_ZM(' 3.1542643130468500872641541678834676897138030382982M-1 +' //   &
                        ' 5.1278981926487839881349589767671081443509643262661M-5 i ') ,  &
                  TO_ZM(' 7.2306107701240042517092650862644370372071840430102M-1 +' //   &
                        ' 1.1754827305696904820108498770289645838406851701631M-4 i ') ,  &
                  TO_ZM(' 6.1456392581646724129324988735501670763785588781979M-1 +' //   &
                        ' 9.9909857541381365264205184957852886329504658229615M-5 i ')    /)
      MFM5 = SQRT(ABS(DOT_PRODUCT(MZMV2-MZMV1,MZMV2-MZMV1)))
      IF (.NOT.(MFM5 < 1.0D-25)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      RETURN
      END SUBROUTINE TEST3

      FUNCTION HARMONIC_SUM(N)
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: HARMONIC_SUM
      TYPE (FM), SAVE :: T(500)
      INTEGER :: J,N

      CALL FM_ENTER_USER_FUNCTION(HARMONIC_SUM)

      DO J = 1, N
          T(J) = 1/TO_FM(J)
      ENDDO
      HARMONIC_SUM = 0
      DO J = 1, N
          HARMONIC_SUM = HARMONIC_SUM + T(J)
      ENDDO
      CALL FM_EXIT_USER_FUNCTION(HARMONIC_SUM)

      END FUNCTION HARMONIC_SUM

      FUNCTION FACTORIAL2(N)
      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: FACTORIAL2
      TYPE (FM), SAVE :: LOW_PREC, ERR
      INTEGER :: J,N,ND1,ND2

      CALL FM_ENTER_USER_FUNCTION(FACTORIAL2)

      FACTORIAL2 = 1
      DO J = 2, N
         FACTORIAL2 = J*FACTORIAL2
      ENDDO

!             Raise precision and compute the error in the first factorial.

      ND1 = NDIG
      CALL FM_SET(100)
      ND2 = NDIG
      CALL FM_EQU(FACTORIAL2,LOW_PREC,ND1,ND2)

      FACTORIAL2 = 1
      DO J = 2, N
         FACTORIAL2 = J*FACTORIAL2
      ENDDO

      ERR = ABS( (FACTORIAL2-LOW_PREC) / FACTORIAL2 )
      IF (ERR > 1.0D-50) WRITE (*,*) ' Error is too high in FACTORIAL2.'

      CALL FM_SET(50)
      FACTORIAL2 = LOW_PREC

      CALL FM_EXIT_USER_FUNCTION(FACTORIAL2)
      END FUNCTION FACTORIAL2

      FUNCTION I_FACTORIAL(N)
      USE FMZM
      IMPLICIT NONE

      TYPE (IM) :: I_FACTORIAL
      INTEGER :: J,N

      CALL FM_ENTER_USER_FUNCTION(I_FACTORIAL)

      I_FACTORIAL = 1
      DO J = 2, N
         I_FACTORIAL = J*I_FACTORIAL
      ENDDO

      CALL FM_EXIT_USER_FUNCTION(I_FACTORIAL)
      END FUNCTION I_FACTORIAL

      FUNCTION Z_FACTORIAL(N)
      USE FMVALS
      USE FMZM
      IMPLICIT NONE

!  This complex "factorial" is equal to  N! * (1+i)^N.

!  For the complex "binomial", the result is always the same as the real binomial.

      TYPE (ZM) :: Z_FACTORIAL
      TYPE (ZM), SAVE :: TERM, LOW_PREC
      TYPE (FM), SAVE :: ERR
      INTEGER :: J,N,ND1,ND2

      CALL FM_ENTER_USER_FUNCTION(Z_FACTORIAL)

      Z_FACTORIAL = CMPLX( TO_FM('1.0D0') , TO_FM('0.0D0') )
      TERM = CMPLX( TO_FM('0.0D0') , TO_FM('0.0D0') )
      DO J = 1, N
         TERM = TERM + CMPLX( TO_FM('1.0D0') , TO_FM('1.0D0') )
         Z_FACTORIAL = TERM*Z_FACTORIAL
      ENDDO

!             Raise precision and compute the error in the first factorial.

      ND1 = NDIG
      CALL FM_SET(100)
      ND2 = NDIG
      CALL ZM_EQU(Z_FACTORIAL,LOW_PREC,ND1,ND2)

      Z_FACTORIAL = CMPLX( TO_FM('1.0D0') , TO_FM('0.0D0') )
      TERM = CMPLX( TO_FM('0.0D0') , TO_FM('0.0D0') )
      DO J = 1, N
         TERM = TERM + CMPLX( TO_FM('1.0D0') , TO_FM('1.0D0') )
         Z_FACTORIAL = TERM*Z_FACTORIAL
      ENDDO

      ERR = ABS( (Z_FACTORIAL-LOW_PREC) / Z_FACTORIAL )
      IF (ERR > 1.0D-50) WRITE (*,*) ' Error is too high in Z_FACTORIAL.'

      CALL FM_SET(50)
      Z_FACTORIAL = LOW_PREC

      CALL FM_EXIT_USER_FUNCTION(Z_FACTORIAL)
      END FUNCTION Z_FACTORIAL

      SUBROUTINE H_SUM(START,J1,J2,RESULT)
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: START, RESULT
      INTEGER :: J,J1,J2

      CALL FM_ENTER_USER_ROUTINE
      RESULT = START
      DO J = J1, J2
          RESULT = RESULT + TO_FM(1)/J
      ENDDO

      CALL FM_EXIT_USER_ROUTINE
      END SUBROUTINE H_SUM

      FUNCTION POWER_FM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: A(3,3),X(3),POWER_FM(3)

      CALL FM_ENTER_USER_FUNCTION(POWER_FM)

      POWER_FM = MATRIX_PRODUCT(MATRIX_SQUARE(A),X)

!             Normalize the eigenvector (L-2 norm).

      POWER_FM = POWER_FM / SQRT( DOT_PRODUCT(POWER_FM,POWER_FM) )

      CALL FM_EXIT_USER_FUNCTION(POWER_FM)

      END FUNCTION POWER_FM

      FUNCTION MATRIX_PRODUCT_FM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: A(3,3),X(3),MATRIX_PRODUCT_FM(3)
      TYPE (FM), SAVE :: X2(3),A2
      INTEGER :: J,K

      CALL FM_ENTER_USER_FUNCTION(MATRIX_PRODUCT_FM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by raising precision and doing
!             matmul by hand.

      NDIG = 2*NDIG
      DO J = 1, 3
         MATRIX_PRODUCT_FM(J) = 0
         DO K = 1, 3
            CALL FM_EQU(A(J,K),A2,NDIG/2,NDIG)
            CALL FM_EQU(X(K),X2(K),NDIG/2,NDIG)
            MATRIX_PRODUCT_FM(J) = MATRIX_PRODUCT_FM(J) + A2*X2(K)
         ENDDO
      ENDDO

      X2 = MATRIX_PRODUCT_FM
      DO J = 1, 3
         CALL FM_EQU(X2(J),MATRIX_PRODUCT_FM(J),NDIG,NDIG/2)
      ENDDO

      NDIG = NDIG/2

      CALL FM_EXIT_USER_FUNCTION(MATRIX_PRODUCT_FM)

      END FUNCTION MATRIX_PRODUCT_FM

      FUNCTION MATRIX_SQUARE_FM(A)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (FM) :: A(3,3),MATRIX_SQUARE_FM(3,3)
      TYPE (FM), SAVE :: A2(3,3),ROW,COL
      INTEGER :: J,K,L

      CALL FM_ENTER_USER_FUNCTION(MATRIX_SQUARE_FM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by raising precision and doing
!             matmul by hand.

      NDIG = 2*NDIG
      DO J = 1, 3
         DO K = 1, 3
            MATRIX_SQUARE_FM(J,K) = 0
            DO L = 1, 3
               CALL FM_EQU(A(J,L),ROW,NDIG/2,NDIG)
               CALL FM_EQU(A(L,K),COL,NDIG/2,NDIG)
               MATRIX_SQUARE_FM(J,K) = MATRIX_SQUARE_FM(J,K) + ROW*COL
            ENDDO
         ENDDO
      ENDDO

      A2 = MATRIX_SQUARE_FM
      DO J = 1, 3
         DO K = 1, 3
            CALL FM_EQU(A2(J,K),MATRIX_SQUARE_FM(J,K),NDIG,NDIG/2)
         ENDDO
      ENDDO

      NDIG = NDIG/2

      CALL FM_EXIT_USER_FUNCTION(MATRIX_SQUARE_FM)

      END FUNCTION MATRIX_SQUARE_FM

      FUNCTION POWER_IM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (IM) :: A(3,3),X(3),POWER_IM(3)

      CALL FM_ENTER_USER_FUNCTION(POWER_IM)

      POWER_IM = MATRIX_PRODUCT(MATRIX_SQUARE(A),X)

!             Normalize the eigenvector (L-2 norm).

      POWER_IM = POWER_IM / ( TO_FM('1e-20') * SQRT( TO_FM( DOT_PRODUCT(POWER_IM,POWER_IM) ) ) )

      CALL FM_EXIT_USER_FUNCTION(POWER_IM)

      END FUNCTION POWER_IM

      FUNCTION MATRIX_PRODUCT_IM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (IM) :: A(3,3),X(3),MATRIX_PRODUCT_IM(3)
      INTEGER :: J,K

      CALL FM_ENTER_USER_FUNCTION(MATRIX_PRODUCT_IM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by doing matmul by hand.

      DO J = 1, 3
         MATRIX_PRODUCT_IM(J) = 0
         DO K = 1, 3
            MATRIX_PRODUCT_IM(J) = MATRIX_PRODUCT_IM(J) + A(J,K)*X(K)
         ENDDO
      ENDDO

      CALL FM_EXIT_USER_FUNCTION(MATRIX_PRODUCT_IM)

      END FUNCTION MATRIX_PRODUCT_IM

      FUNCTION MATRIX_SQUARE_IM(A)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (IM) :: A(3,3),MATRIX_SQUARE_IM(3,3)
      INTEGER :: J,K,L

      CALL FM_ENTER_USER_FUNCTION(MATRIX_SQUARE_IM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by setting element 2,3 to a large value.

      MATRIX_SQUARE_IM(2,3) = TO_IM(10)**100
      DO J = 1, 3
         DO K = 1, 3
            MATRIX_SQUARE_IM(J,K) = 0
            DO L = 1, 3
               MATRIX_SQUARE_IM(J,K) = MATRIX_SQUARE_IM(J,K) + A(J,L)*A(L,K)
            ENDDO
         ENDDO
      ENDDO

      CALL FM_EXIT_USER_FUNCTION(MATRIX_SQUARE_IM)

      END FUNCTION MATRIX_SQUARE_IM

      FUNCTION POWER_ZM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (ZM) :: A(3,3),X(3),POWER_ZM(3)

      CALL FM_ENTER_USER_FUNCTION(POWER_ZM)

      POWER_ZM = MATRIX_PRODUCT(MATRIX_SQUARE(A),X)

!             Normalize the eigenvector (L-2 norm).

      POWER_ZM = POWER_ZM / SQRT( DOT_PRODUCT(POWER_ZM,POWER_ZM) )

      CALL FM_EXIT_USER_FUNCTION(POWER_ZM)

      END FUNCTION POWER_ZM

      FUNCTION MATRIX_PRODUCT_ZM(A,X)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (ZM) :: A(3,3),X(3),MATRIX_PRODUCT_ZM(3)
      TYPE (ZM), SAVE :: X2(3),A2
      INTEGER :: J,K

      CALL FM_ENTER_USER_FUNCTION(MATRIX_PRODUCT_ZM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by raising precision and doing
!             matmul by hand.

      NDIG = 2*NDIG
      DO J = 1, 3
         MATRIX_PRODUCT_ZM(J) = 0
         DO K = 1, 3
            CALL ZM_EQU(A(J,K),A2,NDIG/2,NDIG)
            CALL ZM_EQU(X(K),X2(K),NDIG/2,NDIG)
            MATRIX_PRODUCT_ZM(J) = MATRIX_PRODUCT_ZM(J) + A2*X2(K)
         ENDDO
      ENDDO

      X2 = MATRIX_PRODUCT_ZM
      DO J = 1, 3
         CALL ZM_EQU(X2(J),MATRIX_PRODUCT_ZM(J),NDIG,NDIG/2)
      ENDDO

      NDIG = NDIG/2

      CALL FM_EXIT_USER_FUNCTION(MATRIX_PRODUCT_ZM)

      END FUNCTION MATRIX_PRODUCT_ZM

      FUNCTION MATRIX_SQUARE_ZM(A)

      USE FMVALS
      USE FMZM
      IMPLICIT NONE

      TYPE (ZM) :: A(3,3),MATRIX_SQUARE_ZM(3,3)
      TYPE (ZM), SAVE :: A2(3,3),ROW,COL
      INTEGER :: J,K,L

      CALL FM_ENTER_USER_FUNCTION(MATRIX_SQUARE_ZM)

!             Test the move logic in FM_EXIT_USER_FUNCTION by raising precision and doing
!             matmul by hand.

      NDIG = 2*NDIG
      DO J = 1, 3
         DO K = 1, 3
            MATRIX_SQUARE_ZM(J,K) = 0
            DO L = 1, 3
               CALL ZM_EQU(A(J,L),ROW,NDIG/2,NDIG)
               CALL ZM_EQU(A(L,K),COL,NDIG/2,NDIG)
               MATRIX_SQUARE_ZM(J,K) = MATRIX_SQUARE_ZM(J,K) + ROW*COL
            ENDDO
         ENDDO
      ENDDO

      A2 = MATRIX_SQUARE_ZM
      DO J = 1, 3
         DO K = 1, 3
            CALL ZM_EQU(A2(J,K),MATRIX_SQUARE_ZM(J,K),NDIG,NDIG/2)
         ENDDO
      ENDDO

      NDIG = NDIG/2

      CALL FM_EXIT_USER_FUNCTION(MATRIX_SQUARE_ZM)

      END FUNCTION MATRIX_SQUARE_ZM

      SUBROUTINE TEST4

!  Test stored constants.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing stored constants.'//'     Check e.'/)")

!             Switch to base 10 and check the stored digits.

      MBSAVE = MBASE
      NDGSAV = NDIG
      NCASE = 171
      CALL FMSETVAR(' MBASE = 1000 ')
      CALL FMSETVAR(' NDIG = 55 ')
      CALL FMCONS
      CALL FMI2M(1,MB)
      CALL FMEXP(MB,MC)
      DO J = 49, 51
         NDIG = J
         NDIGE = 0
         CALL FMI2M(1,MB)
         CALL FMEXP(MB,MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J + 1
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' e    ',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

      NCASE = 172
      CALL FM_SETVAR(' MBASE = 1000 ')
      CALL FM_SETVAR(' NDIG = 55 ')
      CALL FMI2M(2,MB)
      CALL FMLN(MB,MC)
      CALL FMEQ(MLN2,MLNSV2)
      CALL FMEQ(MLN3,MLNSV3)
      CALL FMEQ(MLN5,MLNSV5)
      CALL FMEQ(MLN7,MLNSV7)
      WRITE (KW,"('     Check ln(2).'/)")
      DO J = 49, 51
         NDIG = J
         NDIGLI = 0
         CALL FMI2M(2,MB)
         CALL FMLN(MB,MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' ln(2)',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

      NCASE = 173
      CALL FMSETVAR(' MBASE = 1000 ')
      CALL FMSETVAR(' NDIG = 55 ')
      WRITE (KW,"('     Check ln(3).'/)")
      CALL FMEQ(MLNSV3,MC)
      DO J = 49, 51
         NDIG = J
         NDIGLI = 0
         CALL FMI2M(3,MB)
         CALL FMLN(MB,MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J + 1
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' ln(3)',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

      NCASE = 174
      CALL FMSETVAR(' MBASE = 1000 ')
      CALL FMSETVAR(' NDIG = 55 ')
      WRITE (KW,"('     Check ln(5).'/)")
      CALL FMEQ(MLNSV5,MC)
      DO J = 49, 51
         NDIG = J
         NDIGLI = 0
         CALL FMI2M(5,MB)
         CALL FMLN(MB,MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J + 1
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' ln(5)',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

      NCASE = 175
      CALL FMSETVAR(' MBASE = 1000 ')
      CALL FMSETVAR(' NDIG = 55 ')
      WRITE (KW,"('     Check ln(7).'/)")
      CALL FMEQ(MLNSV7,MC)
      DO J = 49, 51
         NDIG = J
         NDIGLI = 0
         CALL FMI2M(7,MB)
         CALL FMLN(MB,MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J + 1
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' ln(7)',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

      NCASE = 176
      CALL FMSETVAR(' MBASE = 1000 ')
      CALL FMSETVAR(' NDIG = 55 ')
      WRITE (KW,"('     Check pi.')")
      CALL FMPI(MC)
      DO J = 49, 51
         NDIG = J
         NDIGPI = 0
         CALL FMPI(MA)
         CALL FMSUB(MA,MC,MD)
         CALL FMABS(MD,ME)
         CALL FMEQ(ME,MD)
         CALL FMI2M(1000,MB)
         JEXP = -J + 1
         CALL FMIPOWER(MB,JEXP,ME)
         CALL FMEQ(ME,MB)
         IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
             CALL ERRPRTFM(' pi   ',MA,'MA',MC,'MC',MD,'MD')
             EXIT
         ENDIF
      ENDDO

!             Restore base and precision.

      MBASE = MBSAVE
      NDIG = NDGSAV
      CALL FMCONS
      RETURN
      END SUBROUTINE TEST4

      SUBROUTINE TEST5

!  Test exponentials.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing exponential routines.')")

      NCASE = 177
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMEXP(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.7043249420381570899426746185150096342459216636010743'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMEXP ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 178
      ST1 = '5.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMEXP(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '210.7168868293979289717186453717687341395104929999527672'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-48',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMEXP ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 179
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMIPOWER(MA,13,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.205572620050170403854527299272882946980306577287581E-6'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-56',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMIPWR',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 180
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MA)
      CALL FMIPOWER(MA,-1234,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.673084074011006302103793189789209370839697748745938E167'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E+120',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMIPWR',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 181
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMPOWER(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.4642420045002127676457665673753493595170650613692580'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMPWR ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 182
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '-34.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMPOWER(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '6.504461581246879800523526109766882955934341922848773E15'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-34',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMPWR ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 183
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMRATIONAL_POWER(MA,1,3,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.7050756680967220302067310420367584779561732592049823'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMRPWR',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 184
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MA)
      CALL FMRATIONAL_POWER(MA,-17,5,ME)
      CALL FMEQ(ME,MA)
      ST2 = '2.8889864895853344043562747681699203201333872009477318'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMRPWR',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST5

      SUBROUTINE TEST6

!  Test logarithms.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing logarithm routines.')")

      NCASE = 185
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMLN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-1.0483504538872214324499548823726586101452117557127813'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMLN  ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 186
      ST1 = '0.3505154639175257731958762886597938144329896907216495E123'
      CALL FMST2M(ST1,MA)
      CALL FMLN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '282.1696159843803977017629940438041389247902713456262947'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-47',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMLN  ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 187
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMLOG10(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.4552928172239897280304530226127473926500843247517120'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMLG10',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 188
      CALL FMLNI(210,MA)
      ST2 = '5.3471075307174686805185894350500696418856767760333836'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMLNI ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 189
      CALL FMLNI(211,MA)
      ST2 = '5.3518581334760664957419562654542801180411581735816684'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMLNI ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST6

      SUBROUTINE TEST7

!  Test trigonometric functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing trigonometric routines.')")

      NCASE = 190
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.9391958366109693586000906984500978377093121163061328'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCOS ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 191
      ST1 = '-43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.8069765551968063243992244125871029909816207609700968'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCOS ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 192
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSIN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.3433819746180939949443652360333010581867042625893927'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSIN ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 193
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSIN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.5905834736620182429243173169772978155668602154136946'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSIN ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 194
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMTAN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.3656127521360899712035823015565426347554405301360773'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMTAN ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 195
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMTAN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.7318471272291003544610122296764031536071117330470298'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMTAN ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 196
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS_SIN(MA,ME,MC)
      CALL FMEQ(ME,MA)
      ST2 = '0.9391958366109693586000906984500978377093121163061328'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCSSN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 197
      ST1 = '-43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS_SIN(MA,ME,MC)
      CALL FMEQ(ME,MA)
      ST2 = '0.8069765551968063243992244125871029909816207609700968'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCSSN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 198
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS_SIN(MA,MC,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.3433819746180939949443652360333010581867042625893927'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCSSN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 199
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOS_SIN(MA,MC,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.5905834736620182429243173169772978155668602154136946'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCSSN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST7

      SUBROUTINE TEST8

!  Test inverse trigonometric functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing inverse trigonometric routines.')")

      NCASE = 200
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMACOS(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.2126748979730954046873545995574544481988102502510807'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMACOS',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 201
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMACOS(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.9289177556166978337752887837220484359983591491240252'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMACOS',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 202
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMASIN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.3581214288218012145439670920822969938997744494364723'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMASIN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 203
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMASIN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.3581214288218012145439670920822969938997744494364723'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMASIN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 204
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMATAN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.3371339561772373443347761845672381725353758541616570'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMATAN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 205
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMATAN(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.5477326406586162039457549832092678908202994134569781'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMATAN',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST8

      SUBROUTINE TEST9

!  Test hyperbolic functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing hyperbolic routines.')")

      NCASE = 206
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '1.0620620786534654254819884264931372964608741056397718'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCOSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 207
      ST1 = '-43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '3.356291383454381441662669560464886179346554730604556E+18'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-31',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCOSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 208
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSINH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.3577371366153083355393138079781276622149524420386975'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSINH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 209
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMSINH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '3.356291383454381441662669560464886179197580776059111E+18'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-31',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMSINH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 210
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMTANH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.3368326049912874057089491946232983472275659538703038'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMTANH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 211
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMTANH(MA,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.9999999999999999999999999999999999999556135217341837'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMTANH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 212
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH_SINH(MA,ME,MC)
      CALL FMEQ(ME,MA)
      ST2 = '1.0620620786534654254819884264931372964608741056397718'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-49',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCHSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 213
      ST1 = '-43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH_SINH(MA,ME,MC)
      CALL FMEQ(ME,MA)
      ST2 = '3.356291383454381441662669560464886179346554730604556E+18'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-31',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCHSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 214
      ST1 = '-0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH_SINH(MA,MC,ME)
      CALL FMEQ(ME,MA)
      ST2 = '-0.3577371366153083355393138079781276622149524420386975'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCHSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 215
      ST1 = '43.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      CALL FMCOSH_SINH(MA,MC,ME)
      CALL FMEQ(ME,MA)
      ST2 = '3.356291383454381441662669560464886179197580776059111E+18'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-31',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMCHSH',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      RETURN
      END SUBROUTINE TEST9

      SUBROUTINE TEST10

!  Input and output testing for IM routines.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing integer input and output routines.')")

      NCASE = 216
      CALL IMST2M('123',MA)
      CALL IMI2M(123,MC)
      IF (.NOT.IMCOMPARE(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMST2M',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 217
      ST1 = '-350515'
      CALL IMST2M(ST1,MA)
      CALL IMI2M(-350515,MC)
      IF (.NOT.IMCOMPARE(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMST2M',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 218
      ST1 = '19895113660064588580108197261066338165074766609'
      CALL IMST2M(ST1,MA)
      CALL IMI2M(23,MB)
      CALL IMI2M(34,MC)
      CALL IMPOWER(MB,MC,ME)
      CALL IMEQ(ME,MC)
      IF (.NOT.IMCOMPARE(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPWR ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 219
      ST1 = '-20800708073664542533904165663516279809808659679033703'
      CALL IMST2M(ST1,MA)
      CALL IMI2M(-567,MB)
      CALL IMI2M(19,MC)
      CALL IMPOWER(MB,MC,ME)
      CALL IMEQ(ME,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPWR ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 220
      ST1 = '19895113660064588580108197261066338165074766609'
      CALL IMST2M(ST1,MA)
      CALL IMFORM('I53',MA,ST2)
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMFORM',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 221
      ST1 = '-20800708073664542533904165663516279809808659679033703'
      CALL IMST2M(ST1,MA)
      CALL IMFORM('I73',MA,ST2)
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMFORM',MA,'MA',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST10

      SUBROUTINE TEST11

!  Test add and subtract for IM routines.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing integer add and subtract routines.')")

      NCASE = 222
      CALL IMST2M('123',MA)
      CALL IMST2M('789',MB)
      CALL IMADD(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMI2M(912,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMADD ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 223
      ST1 = '3505154639175257731958762886597938144329896907216495'
      CALL IMST2M(ST1,MA)
      ST1 = '7319587628865979381443298969072164948453608247422680'
      CALL IMST2M(ST1,MB)
      CALL IMADD(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '10824742268041237113402061855670103092783505154639175'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMADD ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 224
      ST1 = '3505154639175257731958762886597938144329896907216495'
      CALL IMST2M(ST1,MA)
      ST1 = '7319587628865979381443298969072164948453608247422680'
      CALL IMST2M(ST1,MB)
      CALL IMSUB(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '-3814432989690721649484536082474226804123711340206185'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMSUB ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 225
      ST1 = '3505154639175257731958762886597938144329896907216495'
      CALL IMST2M(ST1,MA)
      ST1 = '3505154639175257731443298969072164948453608247422680'
      CALL IMST2M(ST1,MB)
      CALL IMSUB(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '515463917525773195876288659793815'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMSUB ',MA,'MA',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST11

      SUBROUTINE TEST12

!  Test integer multiply and divide.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing integer multiply, divide and square routines.')")

      NCASE = 226
      CALL IMST2M('123',MA)
      CALL IMST2M('789',MB)
      CALL IMMPY(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMI2M(97047,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPY ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 227
      ST1 = '10430738374625018354698'
      CALL IMST2M(ST1,MA)
      ST1 = '2879494424799214514791045985'
      CALL IMST2M(ST1,MB)
      CALL IMMPY(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '30035252996271960952238822892375588336807158787530'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPY ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 228
      CALL IMST2M('12347',MA)
      CALL IMST2M('47',MB)
      CALL IMDIV(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('262',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIV ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 229
      ST1 = '2701314697583086005158008013691015597308949443159762'
      CALL IMST2M(ST1,MA)
      ST1 = '-978132616472842669976589722394'
      CALL IMST2M(ST1,MB)
      CALL IMDIV(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('-2761705981469115610382',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIV ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 230
      CALL IMST2M('12368',MA)
      CALL IMST2M('67',MB)
      CALL IMMOD(MA,MB,ME)
      CALL IMEQ(ME,MB)
      CALL IMST2M('40',MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMOD ',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 231
      ST1 = '2701314697583086005158008013691015597308949443159762'
      CALL IMST2M(ST1,MA)
      ST1 = '-978132616472842669976589722394'
      CALL IMST2M(ST1,MB)
      CALL IMMOD(MA,MB,ME)
      CALL IMEQ(ME,MB)
      CALL IMST2M('450750319653685523300198865254',MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMOD ',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 232
      CALL IMST2M('1234',MA)
      CALL IMST2M('17',MB)
      CALL IMDIVR(MA,MB,MC,MD)
      CALL IMEQ(MC,MA)
      CALL IMEQ(MD,MB)
      CALL IMST2M('72',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVR',MA,'MA',MC,'MC')
      ENDIF
      CALL IMST2M('10',MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVR',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 233
      ST1 = '34274652243817531418235301715935108945364446765801943'
      CALL IMST2M(ST1,MA)
      ST1 = '-54708769795848731641842224621693'
      CALL IMST2M(ST1,MB)
      CALL IMDIVR(MA,MB,MC,MD)
      CALL IMEQ(MC,MA)
      CALL IMEQ(MD,MB)
      CALL IMST2M('-626492834178447772323',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVR',MA,'MA',MC,'MC')
      ENDIF
      CALL IMST2M('31059777254296217822749494999104',MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVR',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 234
      CALL IMST2M('4866',MA)
      CALL IMMPYI(MA,14,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('68124',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPYI',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 235
      CALL IMST2M('270131469758308600515800801369101559730894',MA)
      CALL IMMPYI(MA,-2895,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('-782030604950303398493243319963549015420938130',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPYI ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 236
      CALL IMST2M('-37179',MA)
      CALL IMDIVI(MA,129,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('-288',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVI',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 237
      ST1 = '8267538919383255454483790743961990401918726073065738'
      CALL IMST2M(ST1,MA)
      CALL IMDIVI(MA,1729,ME)
      CALL IMEQ(ME,MA)
      ST2 = '4781688212483085861471249707323302719444028960708'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDIVI',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 238
      CALL IMST2M('-71792',MA)
      CALL IMDVIR(MA,65,MC,IREM)
      CALL IMEQ(MC,MA)
      CALL IMST2M('-1104',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDVIR',MA,'MA',MC,'MC')
      ENDIF
      CALL IMI2M(IREM,MB)
      CALL IMI2M(-32,MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDVIR',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 239
      ST1 = '97813261647284266997658972239417958580120170263408655'
      CALL IMST2M(ST1,MA)
      CALL IMDVIR(MA,826,MC,IREM)
      CALL IMEQ(MC,MA)
      ST2 = '118417992309060855929369215786220288837917881674828'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDVIR',MA,'MA',MC,'MC')
      ENDIF
      CALL IMI2M(IREM,MB)
      CALL IMI2M(727,MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMDVIR',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 240
      CALL IMST2M('538',MA)
      CALL IMSQR(MA,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('289444',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMSQR ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 241
      CALL IMST2M('-47818191879814587168242632',MA)
      CALL IMSQR(MA,ME)
      CALL IMEQ(ME,MA)
      ST2 = '2286579474654765721668058416662636606051551222287424'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMSQR ',MA,'MA',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST12

      SUBROUTINE TEST13

!  Test conversions between FM and IM format.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing conversions between FM and IM format.')")

      NCASE = 242
      CALL IMST2M('123',MA)
      CALL IMI2FM(MA,MB)
      CALL FMI2M(123,MC)
      CALL FMSUB(MB,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'EQ',MB)) THEN
          CALL ERRPRTFM('IMI2FM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 243
      CALL IMST2M('979282999076598337488362000995916',MA)
      CALL IMI2FM(MA,MB)
      CALL FMST2M('979282999076598337488362000995916',MC)
      CALL FMSUB(MB,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('0',MB)
      IF (.NOT.FMCOMP(MD,'EQ',MB)) THEN
          CALL ERRPRTFM('IMI2FM',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 244
      CALL FMST2M('123.4',MA)
      CALL IMFM2I(MA,MB)
      CALL IMI2M(123,MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMFM2I',MB,'MB',MC,'MC')
      ENDIF

      NCASE = 245
      CALL FMST2M('979282999076598337488362000995916',MA)
      CALL IMFM2I(MA,MB)
      CALL IMST2M('979282999076598337488362000995916',MC)
      IF (.NOT.IMCOMP(MB,'EQ',MC)) THEN
          CALL ERRPRTIM('IMFM2I',MB,'MB',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST13

      SUBROUTINE TEST14

!  Test integer power and GCD functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing integer GCD and power routines.')")

      NCASE = 246
      CALL IMST2M('123',MA)
      CALL IMST2M('789',MB)
      CALL IMGCD(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMI2M(3,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMGCD ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 247
      ST1 = '431134020618556701030927835051546391752577319587628885'
      CALL IMST2M(ST1,MA)
      ST1 = '900309278350515463917525773195876288659793814432989640'
      CALL IMST2M(ST1,MB)
      CALL IMGCD(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('615',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMGCD ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 248
      ST1 = '5877631675869176172956662762822298812326084745145447940'
      CALL IMST2M(ST1,MA)
      ST1 = '10379997509886032090765062511740075746391432253007667'
      CALL IMST2M(ST1,MB)
      CALL IMGCD(MA,MB,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('1',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMGCD ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 249
      CALL IMST2M('47',MA)
      CALL IMST2M('34',MB)
      CALL IMPOWER(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '710112520079088427392020925014421733344154169313556279969'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPWR ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 250
      CALL IMST2M('2',MA)
      CALL IMST2M('187',MB)
      CALL IMPOWER(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '196159429230833773869868419475239575503198607639501078528'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPWR ',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 251
      CALL IMST2M('-3',MA)
      CALL IMST2M('101',MB)
      CALL IMPOWER(MA,MB,ME)
      CALL IMEQ(ME,MA)
      ST2 = '-1546132562196033993109383389296863818106322566003'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPWR ',MA,'MA',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST14

      SUBROUTINE TEST15

!  Test integer modular functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing integer modular routines.')")

      NCASE = 252
      CALL IMST2M('123',MA)
      CALL IMST2M('789',MB)
      CALL IMST2M('997',MC)
      CALL IMMPY_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      CALL IMI2M(338,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPYM',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 253
      ST1 = '431134020618556701030927835051546391752577319587628885'
      CALL IMST2M(ST1,MA)
      ST1 = '36346366019557973241042306587666640486264616086971724'
      CALL IMST2M(ST1,MB)
      ST1 = '900309278350515463917525773195876288659793814432989640'
      CALL IMST2M(ST1,MC)
      CALL IMMPY_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      ST2 = '458279704440780378752997531208983184411293504187816380'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPYM',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 254
      ST1 = '914726194238000125985765939883182'
      CALL IMST2M(ST1,MA)
      ST1 = '-75505764717193044779376979508186553225192'
      CALL IMST2M(ST1,MB)
      ST1 = '18678872625055834600521936'
      CALL IMST2M(ST1,MC)
      CALL IMMPY_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      ST2 = '-7769745969769966093344960'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMMPYM',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 255
      CALL IMST2M('123',MA)
      CALL IMST2M('789',MB)
      CALL IMST2M('997',MC)
      CALL IMPOWER_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      CALL IMI2M(240,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPMOD',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 256
      ST1 = '431134020618556701030927835051546391752577319587628885'
      CALL IMST2M(ST1,MA)
      ST1 = '36346366019557973241042306587666640486264616086971724'
      CALL IMST2M(ST1,MB)
      ST1 = '900309278350515463917525773195876288659793814432989640'
      CALL IMST2M(ST1,MC)
      CALL IMPOWER_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      ST2 = '755107893576299697276281907390144058060594744720442385'
      CALL IMST2M(ST2,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPMOD',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 257
      CALL IMST2M('314159',MA)
      CALL IMST2M('1411695892374393248272691827763664225585897550',MB)
      CALL IMST2M('1411695892374393248272691827763664225585897551',MC)
      CALL IMPOWER_MOD(MA,MB,MC,ME)
      CALL IMEQ(ME,MA)
      CALL IMST2M('1',MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMPMOD',MA,'MA',MC,'MC')
      ENDIF

      RETURN
      END SUBROUTINE TEST15

      SUBROUTINE TEST16

!  Complex input and output testing.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex input and output routines.')")

      NCASE = 258
      CALL ZMST2M('123 + 456 i',ZA)
      CALL ZM2I2M(123,456,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)

!             Use the .NOT. because FMCOMP returns FALSE for special cases like ZD = UNKNOWN,
!             and these should be treated as errors for these tests.

      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMST2M',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 259
      STZ1 = '0.3505154639175257731958762886597938144329896907216495 + '  &
         // '0.7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZM2I2M(34,71,ZC)
      CALL ZMDIVI(ZC,97,ZE)
      CALL ZMEQ(ZE,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMST2M',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 260
      STZ1 = '0.3505154639175257731958762886597938144329896907216495E-5 '  &
       //'+ 0.7319587628865979381443298969072164948453608247422680D-5 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZM2I2M(34,71,ZC)
      CALL ZMDIVI(ZC,9700000,ZE)
      CALL ZMEQ(ZE,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-55,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMST2M',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 261
      STZ1 = '7.699115044247787610619469026548672566371681415929204e 03 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M 03 I'
      CALL ZMST2M(STZ1,ZA)
      CALL ZM2I2M(87,-59,ZC)
      CALL ZMDIVI(ZC,113,ZE)
      CALL ZMEQ(ZE,ZC)
      CALL ZMMPYI(ZC,10000,ZE)
      CALL ZMEQU(ZE,ZC,NDIG,NDIG)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-47,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMST2M',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 262
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMFORM('F53.33','F50.30',ZA,STZ2)
      CALL ZMST2M(STZ2,ZA)
      STZ1 = '7699.115044247787610619469026548673 '  &
       // '-5221.238938053097345132743362831858 i'
      CALL ZMST2M(STZ1,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-30,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMFORM',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 263
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMFORM('I9','I7',ZA,STZ2)
      CALL ZMST2M(STZ2,ZA)
      STZ1 = '7699 -5221 i'
      CALL ZMST2M(STZ1,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(0,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMFORM',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 264
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMFORM('E59.50','E58.49',ZA,STZ2)
      CALL ZMST2M(STZ2,ZA)
      STZ1 = '7.6991150442477876106194690265486725663716814159292E3'  &
       //'- 5.221238938053097345132743362831858407079646017699E3 i'
      CALL ZMST2M(STZ1,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMFORM',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 265
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMFORM('ES59.50','ES58.49',ZA,STZ2)
      CALL ZMST2M(STZ2,ZA)
      CALL ZMST2M(STZ1,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-44,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMFORM',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 266
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMFORM('ES59.50','ES58.49',ZA,STZ2)
      CALL ZMST2M(STZ2,ZA)
      CALL ZMST2M(STZ1,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-44,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMFORM',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST16

      SUBROUTINE TEST17

!  Test complex add and subtract.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex add and subtract routines.')")

      NCASE = 267
      CALL ZMST2M('123 + 456 i',ZA)
      CALL ZMST2M('789 - 543 i',ZB)
      CALL ZMADD(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      CALL ZM2I2M(912,-87,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(0,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMADD ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 268
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMADD(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '1.1204269683423045342578231913146610710701578323145698 '  &
       //'+ 0.2098348690812882036310555606240306541373962229723565 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMADD ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 269
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMSUB(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.4193960405072529878660706139950734422041784508712709 '  &
       //'- 1.2540826566919076726576042331904023355533254265121795 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSUB ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 270
      STZ1 = '.7699115044247787610619469026548672566371681415929204E3 '  &
       //'- .5221238938053097345132743362831858407079646017699115E3 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMSUB(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '769.5609889608612352887510263662074628227351519021987045 '  &
       //'- 522.8558525681963324514186661800930572028099625946537725 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-47,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSUB ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST17

      SUBROUTINE TEST18

!  Test complex multiply, divide and square root.

      IMPLICIT NONE

      WRITE (KW, "(/' Testing complex multiply, divide and square root routines.')")

      NCASE = 271
      CALL ZMST2M('123 + 456 i',ZA)
      CALL ZMST2M('789 - 543 i',ZB)
      CALL ZMMPY(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      CALL ZM2I2M(344655,292995,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(0,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMMPY ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 272
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMMPY(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.6520390475321594745005017790347596022260742632971444 '  &
       //'+ 0.3805309734513274336283185840707964601769911504424779 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMMPY ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 273
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMDIV(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-.1705178497731560089737969128653459210208765017614861 '  &
       //'- 1.1335073636829696356072949942949842987114804337239972 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMDIV ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 274
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMMPYI(ZA,36,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '27.7168141592920353982300884955752212389380530973451327 '  &
       //'- 18.7964601769911504424778761061946902654867256637168142 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMMPYI',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 275
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMDIVI(ZA,37,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '2.080841903850753408275532169337479071992346328629514E-2 '  &
       //'- 1.411145658933269552738579287251853623535039464243004E-2 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-52,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMDIVI',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 276
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSQR(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.3201503641632077688150990680554467851828647505677813 '  &
       //'- 0.8039783851515388832328295089670295246299631921058814 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSQR ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 277
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSQRT(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.9219999909012323458336720551458583330580388434229845 '  &
       //'- 0.2831474506279259570386845864488094697732718981999941 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSQRT',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST18

      SUBROUTINE TEST19

!  Test complex exponentials.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex exponential routines.')")

      NCASE = 278
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMEXP(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '1.8718374504057787925867989348073888855260008469310002 '  &
       //'- 1.0770279996847678711699041910427261417963102075889234 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMEXP ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 279
      STZ1 = '5.7699115044247787610619469026548672566371681415929204 '  &
       //'- 4.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMEXP(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-60.6144766542152809520229386164396710991242264070603612 '  &
       //'+ 314.7254994809539691403004121118801578835669635535466592 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-47,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMEXP ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 280
      STZ1 = '1.7699115044247787610619469026548672566371681415929204 '  &
       //'- 1.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMIPOWER(ZA,45,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '31595668743300099.70429472191424818167262151605608585179 '  &
       //'- 19209634448276799.67717448173630165852744930837930753788 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-33,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMIPWR',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 281
      STZ1 = '1.7699115044247787610619469026548672566371681415929204 '  &
       //'- 1.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMIPOWER(ZA,-122,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '3.1000215641022021714480000129414241564868699479432E-46 '  &
       //'- 1.1687846789859477815450163510927243367234863123667E-45 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-93,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMIPWR',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 282
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMPOWER(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '1.4567089343012352449621841355636496276866203747888724 '  &
       //'- 0.3903177712261966292764255714390622205129978923650749 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMPWR ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 283
      STZ1 = '.3505154639175257731958762886597938144329896907216495 '  &
       //'+ .7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      STZ1 = '2.7699115044247787610619469026548672566371681415929204 '  &
       //'- 0.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZB)
      CALL ZMPOWER(ZA,ZB,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-1.0053105716678380336247948739245187868180079734997482 '  &
       // '- 0.0819537653234704467729051473979237153087038930127116 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMPWR ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 284
      STZ1 = '0.7699115044247787610619469026548672566371681415929204 '  &
       //'- 0.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMRATIONAL_POWER(ZA,2,7,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.9653921326136512316639621651337975772631340364271270 '  &
       //'- 0.1659768285667051396562270035411852432430188906482848 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMRPWR',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 285
      STZ1 = '0.7699115044247787610619469026548672566371681415929204 '  &
       //'- 0.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMRATIONAL_POWER(ZA,-19,7,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-0.0567985880053556315170006800325686036902111276420647 '  &
       // '+ 1.2154793972711356706410882510363594270389067962568571 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMRPWR',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST19

      SUBROUTINE TEST20

!  Test complex logarithms.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex logarithm routines.')")

      NCASE = 286
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMLN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-0.0722949652393911311212450699415231782692434885813725 '  &
       //'-  0.5959180055163009910007765127008371205749515965219804 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMLN  ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 287
      STZ1 = '.7699115044247787610619469026548672566371681415929204E28 '  &
       //'- .5221238938053097345132743362831858407079646017699115E28 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMLN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '64.4000876385938880213825156612206746345615981930242708 '  &
       //'-  0.5959180055163009910007765127008371205749515965219804 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMLN  ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 288
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMLOG10(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-0.0313973044728549715287589498363619677438302809470943 '  &
       //'-  0.2588039014625211035392823012785304771809982053965284 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMLG10',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 289
      STZ1 = '.7699115044247787610619469026548672566371681415929204E82 '  &
       //'- .5221238938053097345132743362831858407079646017699115E82 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMLOG10(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '81.9686026955271450284712410501636380322561697190529057 '  &
       //'-  0.2588039014625211035392823012785304771809982053965284 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMLG10',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST20

      SUBROUTINE TEST21

!  Test complex trigonometric functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex trigonometric routines.')")

      NCASE = 290
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOS(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.8180802525254482451348613286211514555816444253416895 '  &
       //'+  0.3801751200076938035500853542125525088505055292851393 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCOS ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 291
      STZ1 = '34.7699115044247787610619469026548672566371681415929204 '  &
       //'- 42.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOS(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-1432925478410268113.5816466154230974355002592549420099 '  &
       //'-  309002816679456015.00151246245263842483282458519462258 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-31,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCOS ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 292
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSIN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.7931260548991613428648822413402447097755865697557818 '  &
       //'-  0.3921366045897070762848927655743167937790944353110710 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSIN ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 293
      STZ1 = '34.7699115044247787610619469026548672566371681415929204 '  &
       //'- 42.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSIN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '-3.090028166794560150015124624526384249047272360765358E17 '  &
       //'+  1.432925478410268113581646615423097435166828182950161E18 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-31,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSIN ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 294
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMTAN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.6141156219447569167198437040270236055089243090199979 '  &
       //'-  0.7647270337230070156308196055474639461102792169274526 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMTAN ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 295
      STZ1 = '35.7699115044247787610619469026548672566371681415929204 '  &
       //'- 43.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMTAN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '2.068934241218867332441292427642153175237611151321340E-38 '  &
       //'-  1.000000000000000000000000000000000000023741659169354 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMTAN ',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 296
      STZ1 = '0.3505154639175257731958762886597938144329896907216495 '  &
       //'+  0.7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOS_SIN(ZA,ZE,ZC)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '1.2022247452809115256533054407001508718694617802593324 '  &
       //'-  0.2743936538120352873902095801531325075994392065668943 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCSSN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 297
      STZ1 = '0.3505154639175257731958762886597938144329896907216495 '  &
       //'+  0.7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOS_SIN(ZA,ZC,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.4395486978082638069281369170831952476351663772871008 '  &
       //'+  0.7505035100906417134864779281080728222900154610025883 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCSSN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST21

      SUBROUTINE TEST22

!  Test complex inverse trigonometric functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex inverse trigonometric routines.')")

      NCASE = 298
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMACOS(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.8797127900868121872960714368309657795959216549012347 '  &
       //'+  0.6342141347945396859119941874681961111936156338608130 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMACOS',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 299
      STZ1 = '.7699115044247787610619469026548672566371681415929204E12 '  &
       //'- .5221238938053097345132743362831858407079646017699115E12 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMACOS(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.5959180055163009910007767810953294528367807973983794 '  &
       //'+28.2518733312491023865118844008522768856672089946951468 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMACOS',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 300
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMASIN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.6910835367080844319352502548087856625026630447863182 '  &
       //'-  0.6342141347945396859119941874681961111936156338608130 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMASIN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 301
      STZ1 = '.7699115044247787610619469026548672566371681415929204E13 '  &
       //'- .5221238938053097345132743362831858407079646017699115E13 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMASIN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.9748783212785956282305451762549693982010148111568094 '  &
       //'-30.5544584242431480705298759613446206186670533428066404 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-48,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMASIN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 302
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMATAN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.7417952692265900376512911713942700568648670953521258 '  &
       //'- 0.3162747143126729004878357203292329539837025170484857 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMATAN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 303
      STZ1 = '.7699115044247787610619469026548672566371681415929204E13 '  &
       //'- .5221238938053097345132743362831858407079646017699115E13 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMATAN(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '   1.570796326794807650905529836436131532596233124329403 '  &
       //'-6.033484162895927601809954710695221401671437742867605E-14 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMATAN',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST22

      SUBROUTINE TEST23

!  Test complex hyperbolic functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing complex hyperbolic routines.')")

      NCASE = 304
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOSH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '1.1365975275870879962259716562608779977957563621412079 '  &
       //'-  0.4230463404769118342540441830446134405410543954181579 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-49,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCOSH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 305
      STZ1 = '34.7699115044247787610619469026548672566371681415929204 '  &
       //'- 42.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOSH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '69552104658681.7558589320148420094288419217262200765435 '  &
       //'+ 626163773308016.884007302915197616300902876551542156676 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-35,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCOSH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 306
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSINH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.7352399228186907963608272785465108877302444847897922 '  &
       //'-  0.6539816592078560369158600079981127012552558121707655 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSINH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 307
      STZ1 = '34.7699115044247787610619469026548672566371681415929204 '  &
       //'- 42.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMSINH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '6.955210465868175585893201484192181376093291191637290E 13 '  &
       //'+ 6.261637733080168840073029151984050820616907795167046E 14 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-35,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMSINH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 308
      STZ1 = '.7699115044247787610619469026548672566371681415929204 '  &
       //'- .5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMTANH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.7562684782933185240709480231996041186654551038993505 '  &
       //'-  0.2938991498221693198532255749292372853685311106820169 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMTANH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 309
      STZ1 = '35.7699115044247787610619469026548672566371681415929204 '  &
       //'- 43.5221238938053097345132743362831858407079646017699115 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMTANH(ZA,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '9.999999999999999999999999999998967653135180689424497E-01 '  &
       //'+ 1.356718776492102400812550018433337461876455254467192E-31 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMTANH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 310
      STZ1 = '0.3505154639175257731958762886597938144329896907216495 '  &
       //'+  0.7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOSH_SINH(ZA,ZE,ZC)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.7900326499280864816444807620997665088044412803737969 '  &
       //'+ 0.2390857359988804105051429301542214823277594407302781 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCHSH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      NCASE = 311
      STZ1 = '0.3505154639175257731958762886597938144329896907216495 '  &
       //'+  0.7319587628865979381443298969072164948453608247422680 i'
      CALL ZMST2M(STZ1,ZA)
      CALL ZMCOSH_SINH(ZA,ZC,ZE)
      CALL ZMEQ(ZE,ZA)
      STZ2 = '0.2661087555034471983220879532235334422670297141428191 '  &
       //'+  0.7098057980612199357870532628105009808447460332437714 i'
      CALL ZMST2M(STZ2,ZC)
      CALL ZMSUB(ZA,ZC,ZD)
      CALL ZMABS(ZD,MA)
      CALL FMI2M(10,MB)
      CALL FMIPOWER(MB,-50,ME)
      CALL FMEQ(ME,MB)
      IF (.NOT.FMCOMP(MA,'LE',MB)) THEN
          CALL ERRPRTZM('ZMCHSH',ZA,'ZA',ZC,'ZC',ZD,'ZD')
      ENDIF

      RETURN
      END SUBROUTINE TEST23

      SUBROUTINE TEST24

!             Test the = assignment interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type = interface.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0
      MSMALL = EPSILON(TO_FM(1))*10000.0
      NCASE = 312
      J4 = MFM1
      IF (J4 /= 581) CALL PRTERR(KW)

      NCASE = 313
      J4 = MIM1
      IF (J4 /= 661) CALL PRTERR(KW)

      NCASE = 314
      J4 = MZM1
      IF (J4 /= 731) CALL PRTERR(KW)

      NCASE = 315
      R4 = MFM1
      IF (ABS((R4-581.21)/581.21) > RSMALL) CALL PRTERR(KW)

      NCASE = 316
      R4 = MIM1
      IF (ABS((R4-661.0)/661.0) > RSMALL) CALL PRTERR(KW)

      NCASE = 317
      R4 = MZM1
      IF (ABS((R4-731.51)/731.51) > RSMALL) CALL PRTERR(KW)

      NCASE = 318
      D4 = MFM1
      IF (ABS((D4-581.21D0)/581.21D0) > DSMALL) CALL PRTERR(KW)

      NCASE = 319
      D4 = MIM1
      IF (ABS((D4-661.0D0)/661.0D0) > DSMALL) CALL PRTERR(KW)

      NCASE = 320
      D4 = MZM1
      IF (ABS((D4-731.51D0)/731.51D0) > DSMALL) CALL PRTERR(KW)

      NCASE = 321
      C4 = MFM1
      IF (ABS((C4-581.21)/581.21) > RSMALL) CALL PRTERR(KW)

      NCASE = 322
      C4 = MIM1
      IF (ABS((C4-661.0)/661.0) > RSMALL) CALL PRTERR(KW)

      NCASE = 323
      C4 = MZM1
      IF (ABS((C4-(731.51,711.41))/(731.51,711.41)) > RSMALL) CALL PRTERR(KW)

      NCASE = 324
      CD4 = MFM1
      IF (ABS((CD4-581.21D0)/581.21D0) > DSMALL) CALL PRTERR(KW)

      NCASE = 325
      CD4 = MIM1
      IF (ABS((CD4-661.0D0)/661.0D0) > DSMALL) CALL PRTERR(KW)

      NCASE = 326
      CD4 = MZM1
      IF (ABS((CD4-(731.51D0,711.41D0))/(731.51D0,711.41D0)) > DSMALL) CALL PRTERR(KW)

      NCASE = 327
      MFM3 = J2
      CALL FM_I2M(131,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMPARE(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 328
      MFM3 = J2
      CALL FM_I2M(131,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQU(MFM6,MFM4,NDIG,NDIG)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQU(MFM6,MFM4,NDIG,NDIG)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMPARE(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 329
      MFM3 = J2
      CALL FM_I2M(131,MFM4)
      CALL FM_SUB_R2(MFM3,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQU(MFM6,MFM4,NDIG,NDIG)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMPARE(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 330
      MFM3 = J2
      CALL FM_I2M(131,MFM4)
      CALL FM_EQU(MFM3,MFM6,NDIG,NDIG)
      CALL FM_SUB_R1(MFM6,MFM4)
      CALL FM_EQU(MFM6,MFM4,NDIG,NDIG)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQU_R1(MFM6,NDIG,NDIG)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMPARE(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 331
      MFM3 = R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMPARE(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 332
      MFM3 = D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 333
      MFM3 = C2
      CALL FM_ST2M('411.11',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 334
      MFM3 = CD2
      CALL FM_ST2M('431.11',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 335
      MFM3 = MFM1
      CALL FM_ST2M('581.21',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_EQ(MSMALL,MFM3)
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 336
      MFM3 = MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 337
      MFM3 = MZM1
      CALL FM_ST2M('731.51',MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 338
      MIM3 = J2
      CALL IM_I2M(131,MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMPARE(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 339
      MIM3 = R2
      CALL IM_ST2M('241',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMPARE(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 340
      MIM3 = D2
      CALL IM_ST2M('391',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMPARE(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 341
      MIM3 = C2
      CALL IM_ST2M('411',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMPARE(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 342
      MIM3 = CD2
      CALL IM_ST2M('431',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMPARE(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 343
      MIM3 = MFM1
      CALL IM_ST2M('581',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMP(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 344
      MIM3 = MIM1
      CALL IM_ST2M('661',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMP(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 345
      MIM3 = MZM1
      CALL IM_ST2M('731',MIM4)
      CALL IM_SUB(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      CALL IM_ST2M('0',MIM3)
      IF (IM_COMP(MIM4,'GT',MIM3)) CALL PRTERR(KW)

      NCASE = 346
      MZM3 = J2
      CALL ZM_I2M(131,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM4)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 347
      MZM3 = R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQU(MZM5,MZM4,NDIG,NDIG)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 348
      MZM3 = D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 349
      MZM3 = C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 350
      MZM3 = CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 351
      MZM3 = MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = MSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 352
      MZM3 = MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM4)
      CALL FM_ST2M('0',MFM3)
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 353
      MZM3 = MZM1
      CALL ZM_ST2M('731.51 + 711.41 i',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = MSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      END SUBROUTINE TEST24

      SUBROUTINE TEST25

!  Test the derived type == interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type == interface.')")

      NCASE = 354
      M_A = 123
      M_B = M_A
      IF (.NOT.FM_COMP(M_A,'==',M_B)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 355
      M_A = 123
      M_B = M_A
      IF (.NOT.FM_COMP(M_A,'EQ',M_B)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 356
      J1 = 123
      M_A = J1
      IF (.NOT.(M_A == J1)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 357
      J1 = 123
      M_A = J1
      IF (.NOT.(J1 == M_A)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 358
      J1 = 123
      M_J = J1
      IF (.NOT.(M_J == J1)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 359
      J1 = 123
      M_J = J1
      IF (.NOT.(J1 == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 360
      J1 = 123
      M_Z = J1
      IF (.NOT.(M_Z == J1)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 361
      J1 = 123
      M_Z = ( 123.0 , 34.5 )
      IF (M_Z == J1) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 362
      J1 = 123
      M_Z = J1
      IF (.NOT.(J1 == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 363
      J1 = 123
      M_Z = ( 123.0 , 34.5 )
      IF (J1 == M_Z) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 364
      R1 = 12.3
      M_A = R1
      IF (.NOT.(M_A == R1)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 365
      R1 = 12.3
      M_A = R1
      IF (.NOT.(R1 == M_A)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 366
      R1 = 123
      M_J = R1
      IF (.NOT.(M_J == R1)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 367
      R1 = 123
      M_J = R1
      IF (.NOT.(R1 == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 368
      R1 = 12.3
      M_Z = R1
      IF (.NOT.(M_Z == R1)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 369
      R1 = 12.3
      M_Z = R1
      IF (.NOT.(R1 == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 370
      D1 = 12.3
      M_A = D1
      IF (.NOT.(M_A == D1)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 371
      D1 = 12.3
      M_A = D1
      IF (.NOT.(D1 == M_A)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 372
      D1 = 123
      M_J = D1
      IF (.NOT.(M_J == D1)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 373
      D1 = 123
      M_J = D1
      IF (.NOT.(D1 == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 374
      D1 = 12.3
      M_Z = D1
      IF (.NOT.(M_Z == D1)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 375
      D1 = 12.3
      M_Z = D1
      IF (.NOT.(D1 == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 376
      C1 = 12.3
      M_A = C1
      IF (.NOT.(M_A == C1)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 377
      C1 = (12.3 , 45.6)
      M_A = C1
      IF (M_A == C1) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 378
      C1 = 12.3
      M_A = C1
      IF (.NOT.(C1 == M_A)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 379
      C1 = (12.3 , 45.6)
      M_A = C1
      IF (C1 == M_A) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 380
      C1 = 123
      M_J = C1
      IF (.NOT.(M_J == C1)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 381
      C1 = (12.3 , 45.6)
      M_J = C1
      IF (M_J == C1) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 382
      C1 = 123
      M_J = C1
      IF (.NOT.(C1 == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 383
      C1 = (12.3 , 45.6)
      M_J = C1
      IF (C1 == M_J) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 384
      C1 = (12.3 , 45.6)
      M_Z = C1
      IF (.NOT.(M_Z == C1)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 385
      C1 = (12.3 , 45.6)
      M_Z = C1
      IF (.NOT.(C1 == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 386
      CD1 = 12.3
      M_A = CD1
      IF (.NOT.(M_A == CD1)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 387
      CD1 = (12.3 , 45.6)
      M_A = CD1
      IF (M_A == CD1) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 388
      CD1 = 12.3
      M_A = CD1
      IF (.NOT.(CD1 == M_A)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 389
      CD1 = (12.3 , 45.6)
      M_A = CD1
      IF (CD1 == M_A) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 390
      CD1 = 123
      M_J = CD1
      IF (.NOT.(M_J == CD1)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 391
      CD1 = (123.0 , 45.6)
      M_J = CD1
      IF (M_J == CD1) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 392
      CD1 = 123
      M_J = CD1
      IF (.NOT.(CD1 == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 393
      CD1 = (123.0 , 45.6)
      M_J = CD1
      IF (CD1 == M_J) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 394
      CD1 = (12.3 , 45.6)
      M_Z = CD1
      IF (.NOT.(M_Z == CD1)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 395
      CD1 = (12.3 , 45.6)
      M_Z = CD1
      IF (.NOT.(CD1 == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 396
      M_B = 12.3
      M_A = M_B
      IF (.NOT.(M_A == M_B)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 397
      M_B = 123
      M_J = M_B
      IF (.NOT.(M_J == M_B)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 398
      M_B = 123.4
      M_J = M_B
      IF (M_J == M_B) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 399
      M_B = 123
      M_J = M_B
      IF (.NOT.(M_B == M_J)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 400
      M_B = 123.4
      M_J = M_B
      IF (M_B == M_J) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 401
      M_B = (12.3 , 45.6)
      M_Z = M_B
      IF (.NOT.(M_Z == M_B)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 402
      M_Z = (12.3 , 45.6)
      M_B = M_Z
      IF (M_Z == M_B) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 403
      M_B = (12.3 , 45.6)
      M_Z = M_B
      IF (.NOT.(M_B == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 404
      M_Z = (12.3 , 45.6)
      M_B = M_Z
      IF (M_B == M_Z) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 405
      M_K = 123
      M_J = M_K
      IF (.NOT.(M_J == M_K)) THEN
          CALL ERRPRT_IM('  ==  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 406
      M_K = (12.3 , 45.6)
      M_Z = M_K
      IF (.NOT.(M_Z == M_K)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 407
      M_Z = (12.3 , 45.6)
      M_K = M_Z
      IF (M_Z == M_K) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 408
      M_K = (12.3 , 45.6)
      M_Z = M_K
      IF (.NOT.(M_K == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 409
      M_Z = (12.3 , 45.6)
      M_K = M_Z
      IF (M_K == M_Z) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 410
      M_Y = (12.3 , 45.6)
      M_Z = M_Y
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM('  ==  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      RETURN
      END SUBROUTINE TEST25

      SUBROUTINE TEST26

!  Test the derived type /= interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type /= interface.')")

      NCASE = 411
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'/=',M_B)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 412
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'NE',M_B)) THEN
          CALL ERRPRT_FM('  ==  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 413
      J1 = 123
      M_A = 1 + J1
      IF (.NOT.(M_A /= J1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 414
      J1 = 123
      M_A = 1 + J1
      IF (.NOT.(J1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 415
      J1 = 123
      M_J = 1 + J1
      IF (.NOT.(M_J /= J1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 416
      J1 = 123
      M_J = 1 + J1
      IF (.NOT.(J1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 417
      J1 = 123
      M_Z = 1 + J1
      IF (.NOT.(M_Z /= J1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 418
      J1 = 123
      M_Z = ( 123.0 , 34.5 )
      IF (.NOT.(M_Z /= J1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 419
      J1 = 123
      M_Z = 1 + J1
      IF (.NOT.(J1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 420
      J1 = 123
      M_Z = ( 123.0 , 34.5 )
      IF (.NOT.(J1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 421
      R1 = 12.3
      M_A = 1 + R1
      IF (.NOT.(M_A /= R1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 422
      R1 = 12.3
      M_A = 1 + R1
      IF (.NOT.(R1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 423
      R1 = 123
      M_J = 1 + R1
      IF (.NOT.(M_J /= R1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 424
      R1 = 123
      M_J = 1 + R1
      IF (.NOT.(R1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 425
      R1 = 12.3
      M_Z = 1 + R1
      IF (.NOT.(M_Z /= R1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 426
      R1 = 12.3
      M_Z = ( 12.3 , 34.5 )
      IF (.NOT.(M_Z /= R1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 427
      R1 = 12.3
      M_Z = 1 + R1
      IF (.NOT.(R1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 428
      R1 = 12.3
      M_Z = ( 12.3 , 34.5 )
      IF (.NOT.(R1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 429
      D1 = 12.3
      M_A = 1 + D1
      IF (.NOT.(M_A /= D1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 430
      D1 = 12.3
      M_A = 1 + D1
      IF (.NOT.(D1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 431
      D1 = 123
      M_J = 1 + D1
      IF (.NOT.(M_J /= D1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 432
      D1 = 123
      M_J = 1 + D1
      IF (.NOT.(D1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 433
      D1 = 12.3
      M_Z = 1 + D1
      IF (.NOT.(M_Z /= D1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 434
      D1 = 12.3
      M_Z = ( 12.3 , 34.5 )
      IF (.NOT.(M_Z /= D1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 435
      D1 = 12.3
      M_Z = 1 + D1
      IF (.NOT.(D1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 436
      D1 = 12.3
      M_Z = ( 12.3 , 34.5 )
      IF (.NOT.(D1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 437
      C1 = 12.3
      M_A = 1 + C1
      IF (.NOT.(M_A /= C1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 438
      C1 = ( 12.3 , 34.5 )
      M_A = ( 12.3 , 34.5 )
      IF (.NOT.(M_A /= C1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 439
      C1 = 12.3
      M_A = 1 + C1
      IF (.NOT.(C1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 440
      C1 = ( 12.3 , 34.5 )
      M_A = ( 12.3 , 34.5 )
      IF (.NOT.(C1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 441
      C1 = 123
      M_J = 1 + C1
      IF (.NOT.(M_J /= C1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 442
      C1 = ( 123.0 , 34.5 )
      M_J = ( 123.0 , 34.5 )
      IF (.NOT.(M_J /= C1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 443
      C1 = 123
      M_J = 1 + C1
      IF (.NOT.(C1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 444
      C1 = ( 123.0 , 34.5 )
      M_J = ( 123.0 , 34.5 )
      IF (.NOT.(C1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 445
      C1 = (12.3 , 45.6)
      M_Z = 1 + C1
      IF (.NOT.(M_Z /= C1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 446
      C1 = (12.3 , 45.6)
      M_Z = 1 + C1
      IF (.NOT.(C1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 447
      CD1 = 12.3
      M_A = 1 + CD1
      IF (.NOT.(M_A /= CD1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 448
      CD1 = (12.3 , 45.6)
      M_A = (12.3 , 45.6)
      IF (.NOT.(M_A /= CD1)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 449
      CD1 = 12.3
      M_A = 1 + CD1
      IF (.NOT.(CD1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 450
      CD1 = (12.3 , 45.6)
      M_A = (12.3 , 45.6)
      IF (.NOT.(CD1 /= M_A)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 451
      CD1 = 123
      M_J = 1 + CD1
      IF (.NOT.(M_J /= CD1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 452
      CD1 = (123.0 , 45.6)
      M_J = (123.0 , 45.6)
      IF (.NOT.(M_J /= CD1)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 453
      CD1 = 123
      M_J = 1 + CD1
      IF (.NOT.(CD1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 454
      CD1 = (123.0 , 45.6)
      M_J = (123.0 , 45.6)
      IF (.NOT.(CD1 /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 455
      CD1 = (12.3 , 45.6)
      M_Z = 1 + CD1
      IF (.NOT.(M_Z /= CD1)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 456
      CD1 = (12.3 , 45.6)
      M_Z = 1 + CD1
      IF (.NOT.(CD1 /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 457
      M_B = 12.3
      M_A = 1 + M_B
      IF (.NOT.(M_A /= M_B)) THEN
          CALL ERRPRT_FM('  /=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 458
      M_B = 123
      M_J = 1 + M_B
      IF (.NOT.(M_J /= M_B)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 459
      M_B = 123.4
      M_J = M_B
      IF (.NOT.(M_J /= M_B)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 460
      M_B = 123
      M_J = 1 + M_B
      IF (.NOT.(M_B /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 461
      M_B = 123.4
      M_J = M_B
      IF (.NOT.(M_B /= M_J)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 462
      M_B = (12.3 , 45.6)
      M_Z = 1 + M_B
      IF (.NOT.(M_Z /= M_B)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 463
      M_B = (12.3 , 45.6)
      M_Z = (12.3 , 34.5)
      IF (.NOT.(M_Z /= M_B)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 464
      M_B = (12.3 , 45.6)
      M_Z = 1 + M_B
      IF (.NOT.(M_B /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 465
      M_B = (12.3 , 45.6)
      M_Z = (12.3 , 34.5)
      IF (.NOT.(M_B /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 466
      M_K = 123
      M_J = 1 + M_K
      IF (.NOT.(M_J /= M_K)) THEN
          CALL ERRPRT_IM('  /=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 467
      M_K = (12.3 , 45.6)
      M_Z = 1 + M_K
      IF (.NOT.(M_Z /= M_K)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 468
      M_K = (123.0 , 45.6)
      M_Z = (123.0 , 34.5)
      IF (.NOT.(M_Z /= M_K)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 469
      M_K = (12.3 , 45.6)
      M_Z = 1 + M_K
      IF (.NOT.(M_K /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 470
      M_K = (123.0 , 45.6)
      M_Z = (123.0 , 34.5)
      IF (.NOT.(M_K /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 471
      M_Y = (12.3 , 45.6)
      M_Z = 1 + M_Y
      IF (.NOT.(M_Y /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      NCASE = 472
      M_Y = (12.3 , 45.6)
      M_Z = (12.3 , 34.5)
      IF (.NOT.(M_Y /= M_Z)) THEN
          CALL ERRPRT_ZM('  /=  ',M_Z,'M_Z',M_Z,'M_Z',M_Z,'M_Z')
      ENDIF

      RETURN
      END SUBROUTINE TEST26

      SUBROUTINE TEST27

!  Test the derived type > interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type > interface.')")

      NCASE = 473
      M_A = 125
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'>',M_B)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 474
      M_A = 125
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'GT',M_B)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 475
      J1 = 123
      M_A = J1 + 1
      IF (.NOT.(M_A > J1)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 476
      J1 = 123
      M_A = J1 - 1
      IF (.NOT.(J1 > M_A)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 477
      J1 = 123
      M_J = J1 + 1
      IF (.NOT.(M_J > J1)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 478
      J1 = 123
      M_J = J1 - 1
      IF (.NOT.(J1 > M_J)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 479
      R1 = 12.3
      M_A = R1 + 1
      IF (.NOT.(M_A > R1)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 480
      R1 = 12.3
      M_A = R1 - 1
      IF (.NOT.(R1 > M_A)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 481
      R1 = 123
      M_J = R1 + 1
      IF (.NOT.(M_J > R1)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 482
      R1 = 123
      M_J = R1 - 1
      IF (.NOT.(R1 > M_J)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 483
      D1 = 12.3
      M_A = D1 + 1
      IF (.NOT.(M_A > D1)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 484
      D1 = 12.3
      M_A = D1 - 1
      IF (.NOT.(D1 > M_A)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 485
      D1 = 123
      M_J = D1 + 1
      IF (.NOT.(M_J > D1)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 486
      D1 = 123
      M_J = D1 - 1
      IF (.NOT.(D1 > M_J)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 487
      M_B = 12.3
      M_A = M_B + 1
      IF (.NOT.(M_A > M_B)) THEN
          CALL ERRPRT_FM('   >  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 488
      M_B = 123
      M_J = M_B + 1
      IF (.NOT.(M_J > M_B)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 489
      M_B = 123
      M_J = M_B - 1
      IF (.NOT.(M_B > M_J)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 490
      M_K = 123
      M_J = M_K + 1
      IF (.NOT.(M_J > M_K)) THEN
          CALL ERRPRT_IM('   >  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      RETURN
      END SUBROUTINE TEST27

      SUBROUTINE TEST28

!  Test the derived type >= interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type >= interface.')")

      NCASE = 491
      M_A = 125
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'>=',M_B)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 492
      M_A = 125
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'GE',M_B)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 493
      J1 = 123
      M_A = J1 + 1
      IF (.NOT.(M_A >= J1)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 494
      J1 = 123
      M_A = J1 - 1
      IF (.NOT.(J1 >= M_A)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 495
      J1 = 123
      M_J = J1 + 1
      IF (.NOT.(M_J >= J1)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 496
      J1 = 123
      M_J = J1 - 1
      IF (.NOT.(J1 >= M_J)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 497
      R1 = 12.3
      M_A = R1 + 1
      IF (.NOT.(M_A >= R1)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 498
      R1 = 12.3
      M_A = R1 - 1
      IF (.NOT.(R1 >= M_A)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 499
      R1 = 123
      M_J = R1 + 1
      IF (.NOT.(M_J >= R1)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 500
      R1 = 123
      M_J = R1 - 1
      IF (.NOT.(R1 >= M_J)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 501
      D1 = 12.3
      M_A = D1 + 1
      IF (.NOT.(M_A >= D1)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 502
      D1 = 12.3
      M_A = D1 - 1
      IF (.NOT.(D1 >= M_A)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 503
      D1 = 123
      M_J = D1 + 1
      IF (.NOT.(M_J >= D1)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 504
      D1 = 123
      M_J = D1 - 1
      IF (.NOT.(D1 >= M_J)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 505
      M_B = 12.3
      M_A = M_B + 1
      IF (.NOT.(M_A >= M_B)) THEN
          CALL ERRPRT_FM('  >=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 506
      M_B = 123
      M_J = M_B + 1
      IF (.NOT.(M_J >= M_B)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 507
      M_B = 123
      M_J = M_B - 1
      IF (.NOT.(M_B >= M_J)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 508
      M_K = 123
      M_J = M_K + 1
      IF (.NOT.(M_J >= M_K)) THEN
          CALL ERRPRT_IM('  >=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      RETURN
      END SUBROUTINE TEST28

      SUBROUTINE TEST29

!  Test the derived type < interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type < interface.')")

      NCASE = 509
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'<',M_B)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 510
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'LT',M_B)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 511
      J1 = 123
      M_A = J1 - 2
      IF (.NOT.(M_A < J1)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 512
      J1 = 123
      M_A = J1 + 2
      IF (.NOT.(J1 < M_A)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 513
      J1 = 123
      M_J = J1 - 2
      IF (.NOT.(M_J < J1)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 514
      J1 = 123
      M_J = J1 + 2
      IF (.NOT.(J1 < M_J)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 515
      R1 = 12.3
      M_A = R1 - 2
      IF (.NOT.(M_A < R1)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 516
      R1 = 12.3
      M_A = R1 + 2
      IF (.NOT.(R1 < M_A)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 517
      R1 = 123
      M_J = R1 - 2
      IF (.NOT.(M_J < R1)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 518
      R1 = 123
      M_J = R1 + 2
      IF (.NOT.(R1 < M_J)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 519
      D1 = 12.3
      M_A = D1 - 2
      IF (.NOT.(M_A < D1)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 520
      D1 = 12.3
      M_A = D1 + 2
      IF (.NOT.(D1 < M_A)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 521
      D1 = 123
      M_J = D1 - 2
      IF (.NOT.(M_J < D1)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 522
      D1 = 123
      M_J = D1 + 2
      IF (.NOT.(D1 < M_J)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 523
      M_B = 12.3
      M_A = M_B - 2
      IF (.NOT.(M_A < M_B)) THEN
          CALL ERRPRT_FM('   <  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 524
      M_B = 123
      M_J = M_B - 2
      IF (.NOT.(M_J < M_B)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 525
      M_B = 123
      M_J = M_B + 2
      IF (.NOT.(M_B < M_J)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 526
      M_K = 123
      M_J = M_K - 2
      IF (.NOT.(M_J < M_K)) THEN
          CALL ERRPRT_IM('   <  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      RETURN
      END SUBROUTINE TEST29

      SUBROUTINE TEST30

!  Test the derived type <= interface.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type <= interface.')")

      NCASE = 527
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'<=',M_B)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 528
      M_A = 123
      M_B = 124
      IF (.NOT.FM_COMP(M_A,'LE',M_B)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_B,'M_B',M_B,'M_B')
      ENDIF

      NCASE = 529
      J1 = 123
      M_A = J1 - 2
      IF (.NOT.(M_A <= J1)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 530
      J1 = 123
      M_A = J1 + 2
      IF (.NOT.(J1 <= M_A)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 531
      J1 = 123
      M_J = J1 - 2
      IF (.NOT.(M_J <= J1)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 532
      J1 = 123
      M_J = J1 + 2
      IF (.NOT.(J1 <= M_J)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 533
      R1 = 12.3
      M_A = R1 - 2
      IF (.NOT.(M_A <= R1)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 534
      R1 = 12.3
      M_A = R1 + 2
      IF (.NOT.(R1 <= M_A)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 535
      R1 = 123
      M_J = R1 - 2
      IF (.NOT.(M_J <= R1)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 536
      R1 = 123
      M_J = R1 + 2
      IF (.NOT.(R1 <= M_J)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 537
      D1 = 12.3
      M_A = D1 - 2
      IF (.NOT.(M_A <= D1)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 538
      D1 = 12.3
      M_A = D1 + 2
      IF (.NOT.(D1 <= M_A)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 539
      D1 = 123
      M_J = D1 - 2
      IF (.NOT.(M_J <= D1)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 540
      D1 = 123
      M_J = D1 + 2
      IF (.NOT.(D1 <= M_J)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 541
      M_B = 12.3
      M_A = M_B - 2
      IF (.NOT.(M_A <= M_B)) THEN
          CALL ERRPRT_FM('  <=  ',M_A,'M_A',M_A,'M_A',M_A,'M_A')
      ENDIF

      NCASE = 542
      M_B = 123
      M_J = M_B - 2
      IF (.NOT.(M_J <= M_B)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 543
      M_B = 123
      M_J = M_B + 2
      IF (.NOT.(M_B <= M_J)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      NCASE = 544
      M_K = 123
      M_J = M_K - 2
      IF (.NOT.(M_J <= M_K)) THEN
          CALL ERRPRT_IM('  <=  ',M_J,'M_J',M_J,'M_J')
      ENDIF

      RETURN
      END SUBROUTINE TEST30

      SUBROUTINE TEST31

!             Test the '+' arithmetic operator.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type + interface.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0

      NCASE = 545
      MFM3 = J2 + MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_ADD(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 546
      MFM3 = J2 + MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_ADD_R1(MFM4,MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 547
      MFM3 = J2 + MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_ADD_R2(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 548
      MIM3 = J2 + MIM1
      CALL IM_ST2M('131',MIM4)
      CALL IM_ADD(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 549
      MZM3 = J2 + MZM1
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 550
      MFM3 = R2 + MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ADD(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 551
      MFM3 = R2 + MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ADD(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV_R1(MFM4,MFM3)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 552
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_ADD(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = R2 + MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 553
      MZM3 = R2 + MZM1
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 554
      MFM3 = D2 + MFM1
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ADD(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 555
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_ADD(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = D2 + MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 556
      MZM3 = D2 + MZM1
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 557
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 + MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 558
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 + MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 559
      MZM3 = C2 + MZM1
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 560
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 + MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 561
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 + MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 562
      MZM3 = CD2 + MZM1
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 563
      MFM3 = MFM1 + J2
      CALL FM_ST2M('131',MFM4)
      CALL FM_ADD(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 564
      MFM3 = MFM1 + R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ADD(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 565
      MFM3 = MFM1 + D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ADD(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 566
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ADD(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 + C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 567
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 + CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 568
      MFM3 = MFM1 + MFM2
      CALL FM_ADD(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 569
      MFM3 = MFM1 + MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_ADD(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 570
      MZM3 = MFM1 + MZM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 571
      MIM3 = MIM1 + J2
      CALL IM_ST2M('131',MIM4)
      CALL IM_ADD(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 572
      CALL FM_ST2M('241.21',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_ADD(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 + R2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 573
      CALL FM_ST2M('391.61',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_ADD(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 + D2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 574
      CALL ZM_ST2M('411.11 + 421.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 + C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 575
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_ADD(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 + CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 576
      MFM3 = MIM1 + MFM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_ADD(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 577
      MIM3 = MIM1 + MIM2
      CALL IM_ADD(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM4 == MIM3)) CALL PRTERR(KW)

      NCASE = 578
      MZM3 = MIM1 + MZM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_ADD(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 579
      MZM3 = MZM1 + J2
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 580
      MZM3 = MZM1 + R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 581
      MZM3 = MZM1 + D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 582
      MZM3 = MZM1 + C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 583
      MZM3 = MZM1 + CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 584
      MZM3 = MZM1 + MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 585
      MZM3 = MZM1 + MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_ADD(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 586
      MZM3 = MZM1 + MZM2
      CALL ZM_ADD(MZM1,MZM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 587
      MFM3 = +MFM1
      CALL FM_EQ(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 588
      MIM3 = +MIM1
      CALL IM_EQ(MIM1,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 589
      MZM3 = +MZM1
      CALL ZM_EQ(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      END SUBROUTINE TEST31

      SUBROUTINE TEST32

!             Test the '-' arithmetic operator.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type - interface.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0

      NCASE = 590
      MFM3 = J2 - MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_SUB(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 591
      MIM3 = J2 - MIM1
      CALL IM_ST2M('131',MIM4)
      CALL IM_SUB(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 592
      MZM3 = J2 - MZM1
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 593
      MFM3 = R2 - MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_SUB(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 594
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_SUB(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = R2 - MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 595
      MZM3 = R2 - MZM1
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 596
      MFM3 = D2 - MFM1
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_SUB(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 597
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_SUB(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = D2 - MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 598
      MZM3 = D2 - MZM1
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 599
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 - MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 600
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 - MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 601
      MZM3 = C2 - MZM1
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 602
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 - MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 603
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 - MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 604
      MZM3 = CD2 - MZM1
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 605
      MFM3 = MFM1 - J2
      CALL FM_ST2M('131',MFM4)
      CALL FM_SUB(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 606
      MFM3 = MFM1 - R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_SUB(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 607
      MFM3 = MFM1 - D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_SUB(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 608
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 - C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 609
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 - CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 610
      MFM3 = MFM1 - MFM2
      CALL FM_SUB(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 611
      MFM3 = MFM1 - MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_SUB(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 612
      MZM3 = MFM1 - MZM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 613
      MIM3 = MIM1 - J2
      CALL IM_ST2M('131',MIM4)
      CALL IM_SUB(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 614
      CALL FM_ST2M('241.21',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_SUB(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 - R2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 615
      CALL FM_ST2M('391.61',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_SUB(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 - D2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 616
      CALL ZM_ST2M('411.11 + 421.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 - C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 617
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_SUB(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 - CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 618
      MFM3 = MIM1 - MFM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_SUB(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 619
      MIM3 = MIM1 - MIM2
      CALL IM_SUB(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM4 == MIM3)) CALL PRTERR(KW)

      NCASE = 620
      MZM3 = MIM1 - MZM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 621
      MZM3 = MZM1 - J2
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 622
      MZM3 = MZM1 - R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 623
      MZM3 = MZM1 - D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 624
      MZM3 = MZM1 - C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 625
      MZM3 = MZM1 - CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 626
      MZM3 = MZM1 - MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 627
      MZM3 = MZM1 - MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_SUB(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 628
      MZM3 = MZM1 - MZM2
      CALL ZM_SUB(MZM1,MZM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 629
      MFM3 = -MFM1
      CALL FM_I2M(0,MFM4)
      CALL FM_SUB(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 630
      MIM3 = -MIM1
      CALL IM_I2M(0,MIM4)
      CALL IM_SUB(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 631
      MZM3 = -MZM1
      CALL ZM_I2M(0,MZM4)
      CALL ZM_SUB(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      END SUBROUTINE TEST32

      END MODULE TEST_A


      MODULE TEST_B
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST33

!             Test the '*' arithmetic operator.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type * interface.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0

      NCASE = 632
      MFM3 = J2 * MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_MPY(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 633
      MFM3 = J2 * MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_MPY_R1(MFM4,MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 634
      MFM3 = J2 * MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_MPY_R2(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 635
      MFM3 = J2 * MFM1
      MFM4 = MFM1
      CALL FM_MPYI_R1(MFM4,131)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 636
      MIM3 = J2 * MIM1
      CALL IM_ST2M('131',MIM4)
      CALL IM_MPY(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 637
      MZM3 = J2 * MZM1
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 638
      MFM3 = R2 * MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_MPY(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 639
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_MPY(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = R2 * MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 640
      MZM3 = R2 * MZM1
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 641
      MFM3 = D2 * MFM1
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_MPY(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 642
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_MPY(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = D2 * MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 643
      MZM3 = D2 * MZM1
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 644
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 * MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 645
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 * MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 646
      MZM3 = C2 * MZM1
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 647
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 * MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 648
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 * MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 649
      MZM3 = CD2 * MZM1
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 650
      MFM3 = MFM1 * J2
      CALL FM_ST2M('131',MFM4)
      CALL FM_MPY(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 651
      MFM3 = MFM1 * R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_MPY(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 652
      MFM3 = MFM1 * D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_MPY(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 653
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_MPY(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 * C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 654
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 * CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 655
      MFM3 = MFM1 * MFM2
      CALL FM_MPY(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 656
      MFM3 = MFM1 * MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_MPY(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 657
      MZM3 = MFM1 * MZM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 658
      MIM3 = MIM1 * J2
      CALL IM_ST2M('131',MIM4)
      CALL IM_MPY(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 659
      CALL FM_ST2M('241.21',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_MPY(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 * R2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 660
      CALL FM_ST2M('391.61',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_MPY(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 * D2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 661
      CALL ZM_ST2M('411.11 + 421.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 * C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 662
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_MPY(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 * CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 663
      MFM3 = MIM1 * MFM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_MPY(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 664
      MIM3 = MIM1 * MIM2
      CALL IM_MPY(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM4 == MIM3)) CALL PRTERR(KW)

      NCASE = 665
      MZM3 = MIM1 * MZM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_MPY(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 666
      MZM3 = MZM1 * J2
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 667
      MZM3 = MZM1 * R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 668
      MZM3 = MZM1 * D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 669
      MZM3 = MZM1 * C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 670
      MZM3 = MZM1 * CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 671
      MZM3 = MZM1 * MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 672
      MZM3 = MZM1 * MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_MPY(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 673
      MZM3 = MZM1 * MZM2
      CALL ZM_MPY(MZM1,MZM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      END SUBROUTINE TEST33

      SUBROUTINE TEST34

!             Test the '/' arithmetic operator.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type / interface.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0

      NCASE = 674
      MFM3 = J2 / MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_DIV(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 675
      MFM3 = J2 / MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_EQ(MFM1,MFM6)
      CALL FM_DIV_R2(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 676
      MIM3 = J2 / MIM1
      CALL IM_ST2M('131',MIM4)
      CALL IM_DIV(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 677
      MZM3 = J2 / MZM1
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 678
      MFM3 = R2 / MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_DIV(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 679
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = R2 / MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 680
      MZM3 = R2 / MZM1
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 681
      MFM3 = D2 / MFM1
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_DIV(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 682
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = D2 / MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 683
      MZM3 = D2 / MZM1
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 684
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 / MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 685
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 / MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 686
      MZM3 = C2 / MZM1
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 687
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 / MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 688
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 / MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 689
      MZM3 = CD2 / MZM1
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 690
      MFM3 = MFM1 / J2
      CALL FM_ST2M('131',MFM4)
      CALL FM_DIV(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 691
      MFM3 = MFM1 / R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_DIV(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 692
      MFM3 = MFM1 / D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_DIV(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 693
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_DIV(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 / C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 694
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 / CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 695
      MFM3 = MFM1 / MFM2
      CALL FM_DIV(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 696
      MFM3 = MFM1 / MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_DIV(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 697
      MZM3 = MFM1 / MZM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 698
      MIM3 = MIM1 / J2
      CALL IM_ST2M('131',MIM4)
      CALL IM_DIV(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 699
      CALL FM_ST2M('241.21',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 / R2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 700
      CALL FM_ST2M('391.61',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 / D2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 701
      CALL ZM_ST2M('411.11 + 421.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 / C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 702
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_DIV(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 / CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 703
      MFM3 = MIM1 / MFM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_DIV(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 704
      MIM3 = MIM1 / MIM2
      CALL IM_DIV(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM4 == MIM3)) CALL PRTERR(KW)

      NCASE = 705
      MZM3 = MIM1 / MZM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_DIV(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 706
      MZM3 = MZM1 / J2
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 707
      MZM3 = MZM1 / R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 708
      MZM3 = MZM1 / D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 709
      MZM3 = MZM1 / C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 710
      MZM3 = MZM1 / CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 711
      MZM3 = MZM1 / MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 712
      MZM3 = MZM1 / MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_DIV(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 713
      MZM3 = MZM1 / MZM2
      CALL ZM_DIV(MZM1,MZM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      END SUBROUTINE TEST34

      SUBROUTINE TEST35

!             Test the '**' arithmetic operator.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type ** interface.')")

!             Use a larger error tolerance for large exponents.

      RSMALL = EPSILON(1.0)*10000.0
      DSMALL = EPSILON(1.0D0)*10000.0

      NCASE = 714
      MFM3 = J2 ** MFM1
      CALL FM_ST2M('131',MFM4)
      CALL FM_POWER(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 715
      J4 = 2
      MIM3 = J4 ** MIM1
      CALL IM_ST2M('2',MIM4)
      CALL IM_POWER(MIM4,MIM1,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 716
      MZM3 = J2 ** MZM1
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 717
      MFM3 = R2 ** MFM1
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_POWER(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 718
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_POWER(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = R2 ** MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 719
      MZM3 = R2 ** MZM1
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 720
      MFM3 = D2 ** MFM1
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_POWER(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 721
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_ST2M('661',MFM3)
      CALL FM_POWER(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = D2 ** MIM1
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 722
      MZM3 = D2 ** MZM1
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 723
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 ** MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 724
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = C2 ** MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 725
      MZM3 = C2 ** MZM1
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 726
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 ** MFM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 727
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_ST2M('661',MZM3)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = CD2 ** MIM1
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 728
      MZM3 = CD2 ** MZM1
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 729
      MFM3 = MFM1 ** J2
      CALL FM_ST2M('131',MFM4)
      CALL FM_POWER(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 730
      MFM3 = MFM1 ** R2
      CALL FM_ST2M('241.21',MFM4)
      CALL FM_POWER(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 731
      MFM3 = MFM1 ** D2
      CALL FM_ST2M('391.61',MFM4)
      CALL FM_POWER(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 732
      CALL ZM_ST2M('581.21',MZM3)
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_POWER(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 ** C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 733
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MFM1 ** CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 734
      MFM3 = MFM1 ** MFM2
      CALL FM_POWER(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 735
      MFM3 = MFM1 ** MIM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_POWER(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 736
      MZM3 = MFM1 ** MZM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 737
      J4 = 17
      MIM3 = MIM1 ** J4
      CALL IM_ST2M('17',MIM4)
      CALL IM_POWER(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 738
      CALL FM_ST2M('241.21',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_POWER(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 ** R2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 739
      CALL FM_ST2M('391.61',MFM3)
      CALL FM_ST2M('661',MFM4)
      CALL FM_POWER(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = MIM1 ** D2
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 740
      CALL ZM_ST2M('411.11 + 421.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 ** C2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 741
      CALL ZM_ST2M('431.11 + 441.21 i',MZM3)
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_POWER(MZM4,MZM3,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      MZM3 = MIM1 ** CD2
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 742
      MFM3 = MIM1 ** MFM1
      CALL FM_ST2M('661',MFM4)
      CALL FM_POWER(MFM4,MFM1,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM4 == MFM3)) CALL PRTERR(KW)

      NCASE = 743
      MIM4 = 19
      MIM3 = MIM1 ** MIM4
      CALL IM_POWER(MIM1,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM4 == MIM3)) CALL PRTERR(KW)

      NCASE = 744
      MZM3 = MIM1 ** MZM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_POWER(MZM4,MZM1,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 745
      MZM3 = MZM1 ** J2
      CALL ZM_ST2M('131',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 746
      MZM3 = MZM1 ** R2
      CALL ZM_ST2M('241.21',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 747
      MZM3 = MZM1 ** D2
      CALL ZM_ST2M('391.61',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 748
      MZM3 = MZM1 ** C2
      CALL ZM_ST2M('411.11 + 421.21 i',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > RSMALL) CALL PRTERR(KW)

      NCASE = 749
      MZM3 = MZM1 ** CD2
      CALL ZM_ST2M('431.11 + 441.21 i',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      IF (MFM4 > DSMALL) CALL PRTERR(KW)

      NCASE = 750
      MZM3 = MZM1 ** MFM1
      CALL ZM_ST2M('581.21',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 751
      MZM3 = MZM1 ** MIM1
      CALL ZM_ST2M('661',MZM4)
      CALL ZM_POWER(MZM1,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      NCASE = 752
      MZM3 = MZM1 ** MZM2
      CALL ZM_POWER(MZM1,MZM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM4 == MZM3)) CALL PRTERR(KW)

      END SUBROUTINE TEST35

      SUBROUTINE TEST36

!             Test functions ABS, ..., CEILING.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type ABS, ..., CEILING interfaces.')")

      NCASE = 753
      MFM3 = ABS(MFM1)
      CALL FM_ABS(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 754
      MIM3 = ABS(MIM1)
      CALL IM_ABS(MIM1,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 755
      MFM3 = ABS(MZM1)
      CALL ZM_ABS(MZM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 756
      MFMV1 = TO_FM( (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /) )
      MFMV2 = ABS(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ABS(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 757
      MIMV1 = TO_IM( (/ 12, -34, 56 /) )
      MIMV2 = ABS(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == ABS(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 758
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV2 = ABS(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ABS(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 759
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = ABS(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ABS(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 760
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = (-1)**(J+K) * TO_IM(25+3*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = ABS(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == ABS(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 761
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFMB = ABS(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ABS(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 762
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = ACOS(MFM4)
      CALL FM_ACOS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 763
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = ACOS(MZM4)
      CALL ZM_ACOS(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 764
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = ACOS(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ACOS(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 765
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = ACOS(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == ACOS(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 766
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = ACOS(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ACOS(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 767
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = ACOS(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == ACOS(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 768
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MFM3 = AIMAG(MZM4)
      CALL ZM_IMAG(MZM4,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 769
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV2 = AIMAG(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == AIMAG(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 770
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFMB = AIMAG(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == AIMAG(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 771
      MFM3 = AINT(MFM1)
      CALL FM_INT(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 772
      MZM3 = AINT(MZM1)
      CALL ZM_INT(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 773
      MFMV1 = TO_FM( (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /) )
      MFMV2 = AINT(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == AINT(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 774
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = AINT(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == AINT(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 775
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = AINT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == AINT(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 776
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = AINT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == AINT(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 777
      MFM3 = ANINT(MFM1)
      CALL FM_NINT(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 778
      MZM3 = ANINT(MZM1)
      CALL ZM_NINT(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 779
      MFMV1 = TO_FM( (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /) )
      MFMV2 = ANINT(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ANINT(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 780
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = ANINT(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == ANINT(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 781
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = ANINT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ANINT(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 782
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = ANINT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == ANINT(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 783
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = ASIN(MFM4)
      CALL FM_ASIN(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 784
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = ASIN(MZM4)
      CALL ZM_ASIN(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 785
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = ASIN(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ASIN(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 786
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = ASIN(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == ASIN(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 787
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = ASIN(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ASIN(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 788
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = ASIN(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == ASIN(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 789
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = ATAN(MFM4)
      CALL FM_ATAN(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 790
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = ATAN(MZM4)
      CALL ZM_ATAN(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 791
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = ATAN(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ATAN(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 792
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = ATAN(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == ATAN(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 793
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = ATAN(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ATAN(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 794
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = ATAN(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == ATAN(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 795
      MFM3 = ATAN2(MFM1,MFM2)
      CALL FM_ATAN2(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 796
      MFM3 = ATAN2(MFM1,MFM2)
      CALL FM_ATAN2(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 797
      JERR = -1
      DO J = 0, 10
         IF (BTEST(661,J)) THEN
             IF (.NOT.BTEST(MIM1,J)) JERR = J
         ELSE
             IF (BTEST(MIM1,J)) JERR = J
         ENDIF
      ENDDO
      IF (JERR >= 0) CALL PRTERR(KW)

      NCASE = 798
      CALL FM_ST2M('12.37654',MFM4)
      MFM3 = CEILING(MFM4)
      CALL FM_ST2M('13',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 799
      CALL FM_ST2M('12.0',MFM4)
      MFM3 = CEILING(MFM4)
      CALL FM_ST2M('12',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 800
      CALL FM_ST2M('-12.7654',MFM4)
      MFM3 = CEILING(MFM4)
      CALL FM_ST2M('-12',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 801
      CALL FM_ST2M('-12.7654',MFM4)
      CALL FM_CEILING(MFM4,MFM3)
      CALL FM_ST2M('-12',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 802
      CALL ZM_ST2M('12.37654 - 22.54 i',MZM4)
      MZM3 = CEILING(MZM4)
      CALL ZM_ST2M('13 - 22 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 803
      CALL ZM_ST2M('12.0 - 22.0 i',MZM4)
      MZM3 = CEILING(MZM4)
      CALL ZM_ST2M('12 - 22 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 804
      CALL ZM_ST2M('-12.7654 + 22.31 i',MZM4)
      MZM3 = CEILING(MZM4)
      CALL ZM_ST2M('-12 + 23 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 805
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = CEILING(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == CEILING(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 806
      MIMV1 = TO_IM( (/ 12, -34, 56 /) )
      MIMV2 = CEILING(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == CEILING(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 807
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CEILING(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == CEILING(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 808
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = CEILING(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == CEILING(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 809
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = (-1)**(J+K) * TO_IM(25+3*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = CEILING(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == CEILING(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 810
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CEILING(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == CEILING(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      END SUBROUTINE TEST36

      SUBROUTINE TEST37

!             Test functions CMPLX, ..., EXPONENT.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type CMPLX, ..., EXPONENT interfaces.')")

      NCASE = 811
      MZM3 = CMPLX(MFM1,MFM2)
      CALL ZM_COMPLEX(MFM1,MFM2,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 812
      MZM3 = CMPLX(MFM1,MFM2)
      CALL ZMCOMPLEX(MFM1%MFM,MFM2%MFM,MZM5%MZM)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 813
      MZM3 = CMPLX(MIM1,MIM2)
      CALL IM_I2FM(MIM1,MFM3)
      CALL IM_I2FM(MIM2,MFM4)
      CALL ZM_COMPLEX(MFM3,MFM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 814
      MZM3 = CMPLX(MFM1)
      CALL FM_I2M(0,MFM4)
      CALL ZM_COMPLEX(MFM1,MFM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 815
      MZM3 = CMPLX(MIM1)
      CALL IM_I2FM(MIM1,MFM3)
      CALL FM_I2M(0,MFM4)
      CALL ZM_COMPLEX(MFM3,MFM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 816
      MZM3 = CONJG(MZM1)
      CALL ZM_CONJUGATE(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 817
      MZM3 = CONJG(MZM1)
      CALL ZMCONJUGATE(MZM1%MZM,MZM4%MZM)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 818
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CONJG(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == CONJG(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 819
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CONJG(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == CONJG(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 820
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = COS(MFM4)
      CALL FM_COS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 821
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = COS(MZM4)
      CALL ZM_COS(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 822
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = COS(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == COS(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 823
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = COS(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == COS(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 824
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = COS(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == COS(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 825
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = COS(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == COS(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 826
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = COSH(MFM4)
      CALL FM_COSH(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 827
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = COSH(MZM4)
      CALL ZM_COSH(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 828
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = COSH(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == COSH(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 829
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = COSH(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == COSH(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 830
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = COSH(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == COSH(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 831
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = COSH(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == COSH(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 832
      MFM3 = DBLE(MFM1)
      CALL FM_EQ(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 833
      MFM3 = DBLE(MIM1)
      CALL IM_I2FM(MIM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 834
      MFM3 = DBLE(MZM1)
      CALL ZM_REAL(MZM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 835
      J = DIGITS(MFM1)
      IF (J /= NDIG) CALL PRTERR(KW)

      NCASE = 836
      J = DIGITS(MIM1)
      IF (J /= SIZE_OF_MWK/10) CALL PRTERR(KW)

      NCASE = 837
      J = DIGITS(MZM1)
      IF (J /= NDIG) CALL PRTERR(KW)

      NCASE = 838
      MFM3 = DIM(MFM1,MFM2)
      CALL FM_DIM(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 839
      MIM3 = DIM(MIM1,MIM2)
      CALL IM_DIM(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 840
      MFM3 = DINT(MFM1)
      CALL FM_INT(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 841
      MZM3 = DINT(MZM1)
      CALL ZM_INT(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 842
      MFM3 = TO_FM(' 12.34 ')
      IF (IS_OVERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 843
      MFM3 = TO_FM(' OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 844
      MFM3 = TO_FM(' -OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 845
      MIM3 = TO_IM(' 123456e+345 ')
      IF (IS_OVERFLOW(MIM3)) CALL PRTERR(KW)

      NCASE = 846
      MIM3 = TO_IM(' OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MIM3)) CALL PRTERR(KW)

      NCASE = 847
      MIM3 = TO_IM(' -OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MIM3)) CALL PRTERR(KW)

      NCASE = 848
      MZM3 = TO_ZM(' 45.67 - 0.4321 i ')
      IF (IS_OVERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 849
      MZM3 = TO_ZM(' OVERFLOW + OVERFLOW i ')
      IF (.NOT. IS_OVERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 850
      MZM3 = TO_ZM(' -OVERFLOW - OVERFLOW i ')
      IF (.NOT. IS_OVERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 851
      MFM3 = TO_FM(' 12.34 ')
      IF (IS_UNDERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 852
      MFM3 = TO_FM(' UNDERFLOW ')
      IF (.NOT. IS_UNDERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 853
      MFM3 = TO_FM(' -UNDERFLOW ')
      IF (.NOT. IS_UNDERFLOW(MFM3)) CALL PRTERR(KW)

      NCASE = 854
      MIM3 = TO_IM(' 123456e+345 ')
      IF (IS_UNDERFLOW(MIM3)) CALL PRTERR(KW)

!             Note TO_IM(' UNDERFLOW ') gives zero.

      NCASE = 855
      MIM3 = TO_IM(' UNDERFLOW ')
      IF (IS_UNDERFLOW(MIM3)) CALL PRTERR(KW)

      NCASE = 856
      MIM3 = TO_IM(' -UNDERFLOW ')
      IF (IS_UNDERFLOW(MIM3)) CALL PRTERR(KW)

      NCASE = 857
      MZM3 = TO_ZM(' 45.67 - 0.4321 i ')
      IF (IS_UNDERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 858
      MZM3 = TO_ZM(' UNDERFLOW + UNDERFLOW i ')
      IF (.NOT. IS_UNDERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 859
      MZM3 = TO_ZM(' -UNDERFLOW - UNDERFLOW i ')
      IF (.NOT. IS_UNDERFLOW(MZM3)) CALL PRTERR(KW)

      NCASE = 860
      MFM3 = TO_FM(' 12.34 ')
      IF (IS_UNKNOWN(MFM3)) CALL PRTERR(KW)

      NCASE = 861
      MFM3 = TO_FM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MFM3)) CALL PRTERR(KW)

      NCASE = 862
      MFM3 = TO_FM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MFM3)) CALL PRTERR(KW)

      NCASE = 863
      MIM3 = TO_IM(' 123456e+345 ')
      IF (IS_UNKNOWN(MIM3)) CALL PRTERR(KW)

      NCASE = 864
      MIM3 = TO_IM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MIM3)) CALL PRTERR(KW)

      NCASE = 865
      MIM3 = TO_IM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MIM3)) CALL PRTERR(KW)

      NCASE = 866
      MZM3 = TO_ZM(' 45.67 - 0.4321 i ')
      IF (IS_UNKNOWN(MZM3)) CALL PRTERR(KW)

      NCASE = 867
      MZM3 = TO_ZM(' UNKNOWN + 2.6 i ')
      IF (.NOT. IS_UNKNOWN(MZM3)) CALL PRTERR(KW)

      NCASE = 868
      MZM3 = TO_ZM(' -3.7 - UNKNOWN i ')
      IF (.NOT. IS_UNKNOWN(MZM3)) CALL PRTERR(KW)

      NCASE = 869
      CALL FM_ST2M('1.23',MFMV1(1))
      CALL FM_ST2M('2.23',MFMV1(2))
      CALL FM_ST2M('3.23',MFMV1(3))
      CALL FM_ST2M('4.23',MFMV2(1))
      CALL FM_ST2M('5.23',MFMV2(2))
      CALL FM_ST2M('6.23',MFMV2(3))
      MFM3 = DOT_PRODUCT(MFMV1,MFMV2)
      MFM4 = 0
      DO J = 1, 3
         MFM4 = MFM4 + MFMV1(J)*MFMV2(J)
      ENDDO
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 870
      IF (IS_OVERFLOW(MFMV1)) CALL PRTERR(KW)

      NCASE = 871
      MFMV1(3) = TO_FM(' OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MFMV1)) CALL PRTERR(KW)

      NCASE = 872
      IF (IS_UNDERFLOW(MFMV1)) CALL PRTERR(KW)

      NCASE = 873
      MFMV1(3) = TO_FM(' -UNDERFLOW ')
      IF (.NOT. IS_UNDERFLOW(MFMV1)) CALL PRTERR(KW)

      NCASE = 874
      IF (IS_UNKNOWN(MFMV1)) CALL PRTERR(KW)

      NCASE = 875
      MFMV1(3) = TO_FM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MFMV1)) CALL PRTERR(KW)

      NCASE = 876
      CALL IM_ST2M('12',MIMV1(1))
      CALL IM_ST2M('23',MIMV1(2))
      CALL IM_ST2M('34',MIMV1(3))
      CALL IM_ST2M('-14',MIMV2(1))
      CALL IM_ST2M('-5',MIMV2(2))
      CALL IM_ST2M('16',MIMV2(3))
      MIM3 = DOT_PRODUCT(MIMV1,MIMV2)
      MIM4 = 0
      DO J = 1, 3
         MIM4 = MIM4 + MIMV1(J)*MIMV2(J)
      ENDDO
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 877
      IF (IS_OVERFLOW(MIMV1)) CALL PRTERR(KW)

      NCASE = 878
      MIMV1(2) = TO_IM(' -OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MIMV1)) CALL PRTERR(KW)

      NCASE = 879
      IF (IS_UNDERFLOW(MIMV1)) CALL PRTERR(KW)

      NCASE = 880
      MIMV1(2) = TO_IM(' -UNDERFLOW ')
      IF (IS_UNDERFLOW(MIMV1)) CALL PRTERR(KW)

      NCASE = 881
      IF (IS_UNKNOWN(MIMV1)) CALL PRTERR(KW)

      NCASE = 882
      MIMV1(2) = TO_IM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MIMV1)) CALL PRTERR(KW)

      NCASE = 883
      CALL ZM_ST2M('1.23 + 1.67 i',MZMV1(1))
      CALL ZM_ST2M('2.23 - 2.56 i',MZMV1(2))
      CALL ZM_ST2M('3.23 + 3.45 i',MZMV1(3))
      CALL ZM_ST2M('4.23 - 4.34 i',MZMV2(1))
      CALL ZM_ST2M('5.23 + 5.23 i',MZMV2(2))
      CALL ZM_ST2M('6.23 - 6.12 i',MZMV2(3))
      MZM3 = DOT_PRODUCT(MZMV1,MZMV2)
      MZM4 = 0
      DO J = 1, 3
         MZM4 = MZM4 + CONJG(MZMV1(J))*MZMV2(J)
      ENDDO
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 884
      IF (IS_OVERFLOW(MZMV1)) CALL PRTERR(KW)

      NCASE = 885
      MZMV1(2) = TO_ZM(' -OVERFLOW - OVERFLOW i ')
      IF (.NOT. IS_OVERFLOW(MZMV1)) CALL PRTERR(KW)

      NCASE = 886
      IF (IS_UNDERFLOW(MZMV1)) CALL PRTERR(KW)

      NCASE = 887
      MZMV1(2) = TO_ZM(' -UNDERFLOW - UNDERFLOW i ')
      IF (.NOT. IS_UNDERFLOW(MZMV1)) CALL PRTERR(KW)

      NCASE = 888
      IF (IS_UNKNOWN(MZMV1)) CALL PRTERR(KW)

      NCASE = 889
      MZMV1(2) = TO_ZM(' -3.7 - UNKNOWN i ')
      IF (.NOT. IS_UNKNOWN(MZMV1)) CALL PRTERR(KW)

      NCASE = 890
      MFM3 = EPSILON(MFM1)
      CALL FM_I2M(1,MFM4)
      CALL FM_ULP(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 891
      CALL FM_EPSILON(MFM1,MFM3)
      CALL FM_I2M(1,MFM4)
      CALL FM_ULP(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 892
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = EXP(MFM4)
      CALL FM_EXP(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 893
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = EXP(MZM4)
      CALL ZM_EXP(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 894
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = EXP(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == EXP(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 895
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = EXP(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == EXP(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 896
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = EXP(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == EXP(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 897
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = EXP(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == EXP(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 898
      J = EXPONENT(MFM1)
      IF (J /= INT(MWK(START(MFM1%MFM)+2))) CALL PRTERR(KW)

      END SUBROUTINE TEST37

      SUBROUTINE TEST38

!             Test functions FLOOR, ..., MIN.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type FLOOR, ..., MIN interfaces.')")

      NCASE = 899
      CALL FM_ST2M('12.37654',MFM4)
      MFM3 = FLOOR(MFM4)
      CALL FM_ST2M('12',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 900
      CALL FM_ST2M('12.0',MFM4)
      MFM3 = FLOOR(MFM4)
      CALL FM_ST2M('12',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 901
      CALL FM_ST2M('-12.7654',MFM4)
      MFM3 = FLOOR(MFM4)
      CALL FM_ST2M('-13',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 902
      CALL FM_ST2M('-12.7654',MFM4)
      CALL FM_FLOOR(MFM4,MFM3)
      CALL FM_ST2M('-13',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 903
      CALL IM_ST2M('12',MIM4)
      MIM3 = FLOOR(MIM4)
      CALL IM_ST2M('12',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 904
      CALL IM_ST2M('-123',MIM4)
      MIM3 = FLOOR(MIM4)
      CALL IM_ST2M('-123',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 905
      CALL ZM_ST2M('12.37654 - 22.54 i',MZM4)
      MZM3 = FLOOR(MZM4)
      CALL ZM_ST2M('12 - 23 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 906
      CALL ZM_ST2M('12.0 - 22.0 i',MZM4)
      MZM3 = FLOOR(MZM4)
      CALL ZM_ST2M('12 - 22 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 907
      CALL ZM_ST2M('-12.7654 + 22.31 i',MZM4)
      MZM3 = FLOOR(MZM4)
      CALL ZM_ST2M('-13 + 22 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 908
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = FLOOR(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == FLOOR(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 909
      MIMV1 = TO_IM( (/ 12, -34, 56 /) )
      MIMV2 = FLOOR(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == FLOOR(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 910
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = FLOOR(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == FLOOR(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 911
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = FLOOR(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == FLOOR(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 912
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = (-1)**(J+K) * TO_IM(25+3*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = FLOOR(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == FLOOR(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 913
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = FLOOR(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == FLOOR(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 914
      CALL FM_ST2M('12.37654',MFM4)
      MFM3 = FRACTION(MFM4)
      MWK(START(MFM4%MFM)+2) = 0
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 915
      CALL FM_ST2M('12.37654',MFM4)
      CALL FM_FRACTION(MFM4,MFM3)
      MWK(START(MFM4%MFM)+2) = 0
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 916
      CALL ZM_ST2M('12.37654 - 22.54',MZM4)
      MZM3 = FRACTION(MZM4)
      MWK(START(MZM4%MZM(1))+2) = 0
      MWK(START(MZM4%MZM(2))+2) = 0
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 917
      MFMV1 = TO_FM( (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /) )
      MFMV2 = FRACTION(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == FRACTION(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 918
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = FRACTION(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == FRACTION(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 919
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = FRACTION(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == FRACTION(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 920
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = FRACTION(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == FRACTION(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 921
      MFM3 = HUGE(MFM1)
      CALL FM_BIG(MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 922
      MIM3 = HUGE(MIM1)
      CALL IM_BIG(MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 923
      MZM3 = HUGE(MZM1)
      CALL FM_BIG(MFM4)
      CALL ZM_COMPLEX(MFM4,MFM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 924
      MFM3 = TINY(MFM1)
      CALL FM_TINY(MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 925
      MIM3 = INT(MFM1)
      CALL FM_INT(MFM1,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 926
      MIM3 = INT(MIM1)
      CALL IM_EQ(MIM1,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 927
      MIM3 = INT(MZM1)
      CALL ZM_INT(MZM1,MZM4)
      CALL ZM_REAL(MZM4,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 928
      MFMV1 = TO_FM( (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /) )
      MFMV2 = INT(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == INT(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 929
      MIMV1 = TO_IM( (/ 12, -34, 56 /) )
      MIMV2 = INT(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == INT(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 930
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = INT(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == INT(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 931
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = INT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == INT(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 932
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = (-1)**(J+K) * TO_IM(25+3*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = INT(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == INT(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 933
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = INT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == INT(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 934
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = LOG(MFM4)
      CALL FM_LN(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 935
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = LOG(MZM4)
      CALL ZM_LN(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 936
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = LOG(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == LOG(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 937
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = LOG(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == LOG(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 938
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = LOG(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == LOG(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 939
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = LOG(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == LOG(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 940
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = LOG10(MFM4)
      CALL FM_LOG10(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 941
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = LOG10(MZM4)
      CALL ZM_LOG10(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 942
      MFMV1 = TO_FM( (/ .121123456789D0, 34.2123456789D0, .563123456789D0 /) )
      MFMV2 = LOG10(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == LOG10(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 943
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = LOG10(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == LOG10(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 944
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = LOG10(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == LOG10(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 945
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = LOG10(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == LOG10(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 946
      DO I = 1, 3
         DO J = 1, 3
            MFMA(I,J) = 3*(J-1) + I
            MFMB(I,J) = 3*(I-1) + J + 10
         ENDDO
      ENDDO
      MFMC = MATMUL(MFMA,MFMB)
      MFM3 = ABS(MFMC(1,1)-186)+ABS(MFMC(1,2)-198)+ABS(MFMC(1,3)-210)+ &
             ABS(MFMC(2,1)-228)+ABS(MFMC(2,2)-243)+ABS(MFMC(2,3)-258)+ &
             ABS(MFMC(3,1)-270)+ABS(MFMC(3,2)-288)+ABS(MFMC(3,3)-306)
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 947
      DO I = 1, 3
         DO J = 1, 3
            MFMA(I,J) = 3*(J-1) + I
            MFMB(I,J) = 3*(I-1) + J + 10
         ENDDO
         MFMV1(I) = MFMA(1,I)
      ENDDO
      MFMV2 = MATMUL(MFMV1,MFMB)
      MFM3 = ABS(MFMV2(1)-186)+ABS(MFMV2(2)-198)+ABS(MFMV2(3)-210)
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 948
      IF (IS_OVERFLOW(MFMA)) CALL PRTERR(KW)

      NCASE = 949
      MFMA(3,2) = TO_FM(' OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MFMA)) CALL PRTERR(KW)

      NCASE = 950
      IF (IS_UNDERFLOW(MFMA)) CALL PRTERR(KW)

      NCASE = 951
      MFMA(3,2) = TO_FM(' UNDERFLOW ')
      IF (.NOT. IS_UNDERFLOW(MFMA)) CALL PRTERR(KW)

      NCASE = 952
      IF (IS_UNKNOWN(MFMA)) CALL PRTERR(KW)

      NCASE = 953
      MFMA(3,2) = TO_FM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MFMA)) CALL PRTERR(KW)

      NCASE = 954
      DO I = 1, 3
         DO J = 1, 3
            MFMA(I,J) = 3*(J-1) + I
            MFMB(I,J) = 3*(I-1) + J + 10
         ENDDO
         MFMV1(I) = MFMB(I,1)
      ENDDO
      MFMV2 = MATMUL(MFMA,MFMV1)
      MFM3 = ABS(MFMV2(1)-186)+ABS(MFMV2(2)-228)+ABS(MFMV2(3)-270)
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 955
      DO I = 1, 2
         DO J = 1, 2
            MIMA(I,J) = 2*(J-1) + I + 20
            MIMB(I,J) = 2*(I-1) + J + 30
         ENDDO
      ENDDO
      MIMC = MATMUL(MIMA,MIMB)
      MIM3 = ABS(MIMC(1,1)-1410) + ABS(MIMC(1,2)-1454) + &
             ABS(MIMC(2,1)-1474) + ABS(MIMC(2,2)-1520)
      IF (.NOT.(MIM3 == 0)) CALL PRTERR(KW)

      NCASE = 956
      IF (IS_OVERFLOW(MIMA)) CALL PRTERR(KW)

      NCASE = 957
      MIMA(1,2) = TO_IM(' OVERFLOW ')
      IF (.NOT. IS_OVERFLOW(MIMA)) CALL PRTERR(KW)

      NCASE = 958
      IF (IS_UNDERFLOW(MIMA)) CALL PRTERR(KW)

      NCASE = 959
      MIMA(1,2) = TO_IM(' UNDERFLOW ')
      IF (IS_UNDERFLOW(MIMA)) CALL PRTERR(KW)

      NCASE = 960
      IF (IS_UNKNOWN(MIMA)) CALL PRTERR(KW)

      NCASE = 961
      MIMA(1,2) = TO_IM(' UNKNOWN ')
      IF (.NOT. IS_UNKNOWN(MIMA)) CALL PRTERR(KW)

      NCASE = 962
      DO I = 1, 2
         DO J = 1, 2
            MIMA(I,J) = 2*(J-1) + I + 20
            MIMB(I,J) = 2*(I-1) + J + 30
         ENDDO
         MIMV1(I) = MIMA(I,1)
      ENDDO
      MIMV2(1:2) = MATMUL(MIMV1(1:2),MIMB)
      MIM3 = ABS(MIMV2(1)-1377) + ABS(MIMV2(2)-1420)
      IF (.NOT.(MIM3 == 0)) CALL PRTERR(KW)

      NCASE = 963
      DO I = 1, 2
         DO J = 1, 2
            MIMA(I,J) = 2*(J-1) + I + 20
            MIMB(I,J) = 2*(I-1) + J + 30
         ENDDO
         MIMV1(I) = MIMB(1,I)
      ENDDO
      MIMV2(1:2) = MATMUL(MIMA,MIMV1(1:2))
      MIM3 = ABS(MIMV2(1)-1387) + ABS(MIMV2(2)-1450)
      IF (.NOT.(MIM3 == 0)) CALL PRTERR(KW)

      NCASE = 964
      DO I = 1, 2
         DO J = 1, 3
            MZMA(I,J) = CMPLX(TO_FM(2*(J-1)+I+10),TO_FM(2*(J-1)+I+20))
         ENDDO
      ENDDO
      DO I = 1, 3
         DO J = 1, 4
            MZMB(I,J) = CMPLX(TO_FM(4*(I-1)+J+50),TO_FM(4*(I-1)+J+30))
         ENDDO
      ENDDO
      MZMC = MATMUL(MZMA,MZMB)
      MFM3 = ABS(MZMC(1,1)-TO_ZM('-270 + 5192 i')) + &
             ABS(MZMC(1,2)-TO_ZM('-300 + 5300 i')) + &
             ABS(MZMC(1,3)-TO_ZM('-330 + 5408 i')) + &
             ABS(MZMC(1,4)-TO_ZM('-360 + 5516 i')) + &
             ABS(MZMC(2,1)-TO_ZM('-210 + 5462 i')) + &
             ABS(MZMC(2,2)-TO_ZM('-240 + 5576 i')) + &
             ABS(MZMC(2,3)-TO_ZM('-270 + 5690 i')) + &
             ABS(MZMC(2,4)-TO_ZM('-300 + 5804 i'))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 965
      IF (IS_OVERFLOW(MZMA)) CALL PRTERR(KW)

      NCASE = 966
      MZMA(2,2) = TO_ZM(' OVERFLOW - 23.45 i ')
      IF (.NOT. IS_OVERFLOW(MZMA)) CALL PRTERR(KW)

      NCASE = 967
      IF (IS_UNDERFLOW(MZMA)) CALL PRTERR(KW)

      NCASE = 968
      MZMA(2,2) = TO_ZM(' UNDERFLOW - 23.45 i ')
      IF (.NOT. IS_UNDERFLOW(MZMA)) CALL PRTERR(KW)

      NCASE = 969
      IF (IS_UNKNOWN(MZMA)) CALL PRTERR(KW)

      NCASE = 970
      MZMA(2,2) = TO_ZM(' UNKNOWN - 23.45 i ')
      IF (.NOT. IS_UNKNOWN(MZMA)) CALL PRTERR(KW)

      NCASE = 971
      DO I = 1, 2
         DO J = 1, 3
            MZMA(I,J) = CMPLX(TO_FM(2*(J-1)+I+10),TO_FM(2*(J-1)+I+20))
         ENDDO
      ENDDO
      DO I = 1, 3
         DO J = 1, 4
            MZMB(I,J) = CMPLX(TO_FM(4*(I-1)+J+50),TO_FM(4*(I-1)+J+30))
         ENDDO
         MZMV1(I) = MZMA(1,I)
      ENDDO
      MZMV5 = MATMUL(MZMV1,MZMB)
      MFM3 = ABS(MZMV5(1)-TO_ZM('-270 + 5192 i')) + &
             ABS(MZMV5(2)-TO_ZM('-300 + 5300 i')) + &
             ABS(MZMV5(3)-TO_ZM('-330 + 5408 i')) + &
             ABS(MZMV5(4)-TO_ZM('-360 + 5516 i'))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 972
      DO I = 1, 2
         DO J = 1, 3
            MZMA(I,J) = CMPLX(TO_FM(2*(J-1)+I+10),TO_FM(2*(J-1)+I+20))
         ENDDO
      ENDDO
      DO I = 1, 3
         DO J = 1, 4
            MZMB(I,J) = CMPLX(TO_FM(4*(I-1)+J+50),TO_FM(4*(I-1)+J+30))
         ENDDO
         MZMV1(I) = MZMB(I,1)
      ENDDO
      MZMV2(1:2) = MATMUL(MZMA,MZMV1)
      MFM3 = ABS(MZMV2(1)-TO_ZM('-270 + 5192 i')) + &
             ABS(MZMV2(2)-TO_ZM('-210 + 5462 i'))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 973
      DO I = 1, 3
         DO J = 1, 3
            MFMA(I,J) = 3*(J-1) + I
         ENDDO
      ENDDO
      MFMC = TRANSPOSE(MFMA)
      MFM3 = ABS(MFMC(1,1)-MFMA(1,1))+ABS(MFMC(1,2)-MFMA(2,1))+ABS(MFMC(1,3)-MFMA(3,1))+ &
             ABS(MFMC(2,1)-MFMA(1,2))+ABS(MFMC(2,2)-MFMA(2,2))+ABS(MFMC(2,3)-MFMA(3,2))+ &
             ABS(MFMC(3,1)-MFMA(1,3))+ABS(MFMC(3,2)-MFMA(2,3))+ABS(MFMC(3,3)-MFMA(3,3))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 974
      DO I = 1, 3
         DO J = 1, 2
            MFME(I,J) = 7*(J-1) + I
         ENDDO
      ENDDO
      MFMF = TRANSPOSE(MFME)
      MFM3 = ABS(MFME(1,1)-MFMF(1,1))+ABS(MFME(1,2)-MFMF(2,1))+ &
             ABS(MFME(2,1)-MFMF(1,2))+ABS(MFME(2,2)-MFMF(2,2))+ &
             ABS(MFME(3,1)-MFMF(1,3))+ABS(MFME(3,2)-MFMF(2,3))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 975
      DO I = 1, 3
         DO J = 1, 3
            MIMA2(I,J) = 3*(J-1) + I
         ENDDO
      ENDDO
      MIMB2 = TRANSPOSE(MIMA2)
      MIM3 = ABS(MIMB2(1,1)-MIMA2(1,1))+ABS(MIMB2(1,2)-MIMA2(2,1))+ABS(MIMB2(1,3)-MIMA2(3,1))+ &
             ABS(MIMB2(2,1)-MIMA2(1,2))+ABS(MIMB2(2,2)-MIMA2(2,2))+ABS(MIMB2(2,3)-MIMA2(3,2))+ &
             ABS(MIMB2(3,1)-MIMA2(1,3))+ABS(MIMB2(3,2)-MIMA2(2,3))+ABS(MIMB2(3,3)-MIMA2(3,3))
      IF (.NOT.(MIM3 == 0)) CALL PRTERR(KW)

      NCASE = 976
      DO I = 1, 3
         DO J = 1, 2
            MIMD(I,J) = 7*(J-1) + I
         ENDDO
      ENDDO
      MIME = TRANSPOSE(MIMD)
      MIM3 = ABS(MIMD(1,1)-MIME(1,1))+ABS(MIMD(1,2)-MIME(2,1))+ &
             ABS(MIMD(2,1)-MIME(1,2))+ABS(MIMD(2,2)-MIME(2,2))+ &
             ABS(MIMD(3,1)-MIME(1,3))+ABS(MIMD(3,2)-MIME(2,3))
      IF (.NOT.(MIM3 == 0)) CALL PRTERR(KW)

      NCASE = 977
      DO I = 1, 3
         DO J = 1, 3
            MZMA2(I,J) = CMPLX(TO_FM('62.3')+3*(I+3*(J-1)), TO_FM('-72.4')+7*(I+3*(J-1)))
         ENDDO
      ENDDO
      MZMB2 = TRANSPOSE(MZMA2)
      MFM3 = ABS(MZMB2(1,1)-MZMA2(1,1))+ABS(MZMB2(1,2)-MZMA2(2,1))+ABS(MZMB2(1,3)-MZMA2(3,1))+ &
             ABS(MZMB2(2,1)-MZMA2(1,2))+ABS(MZMB2(2,2)-MZMA2(2,2))+ABS(MZMB2(2,3)-MZMA2(3,2))+ &
             ABS(MZMB2(3,1)-MZMA2(1,3))+ABS(MZMB2(3,2)-MZMA2(2,3))+ABS(MZMB2(3,3)-MZMA2(3,3))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 978
      DO I = 1, 3
         DO J = 1, 2
            MZMD(I,J) = CMPLX(TO_FM('62.3')+3*(I+3*(J-1)), TO_FM('-72.4')+7*(I+3*(J-1)))
         ENDDO
      ENDDO
      MZMA = TRANSPOSE(MZMD)
      MFM3 = ABS(MZMD(1,1)-MZMA(1,1))+ABS(MZMD(1,2)-MZMA(2,1))+ &
             ABS(MZMD(2,1)-MZMA(1,2))+ABS(MZMD(2,2)-MZMA(2,2))+ &
             ABS(MZMD(3,1)-MZMA(1,3))+ABS(MZMD(3,2)-MZMA(2,3))
      IF (.NOT.(MFM3 == 0)) CALL PRTERR(KW)

      NCASE = 979
      MFM3 = MAX(MFM1,MFM2)
      CALL FM_MAX(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 980
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = MAX(MFM2,MFM1,MFM4)
      CALL FM_MAX(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_MAX(MFM2,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 981
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = MAX(MFM2,MFM1,MFM4,MFM2,MFM1,MFM4,MFM2,MFM1,MFM4,MFM2)
      CALL FM_MAX(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_MAX(MFM2,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 982
      MIM3 = MAX(MIM1,MIM2)
      CALL IM_MAX(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 983
      CALL IM_ST2M('7654',MIM4)
      CALL IM_ST2M('-1654',MIM3)
      MIM3 = MAX(MIM2,MIM1,MIM3,MIM4)
      CALL IM_ST2M('7654',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 984
      CALL IM_ST2M('7654',MIM4)
      CALL IM_ST2M('-1654',MIM3)
      MIM3 = MAX(MIM2,MIM1,MIM3,MIM4,MIM2,MIM1,MIM3,MIM4,MIM2,MIM1)
      CALL IM_ST2M('7654',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 985
      J = MAXEXPONENT(MFM1)
      IF (J /= INT(MXEXP)+1) CALL PRTERR(KW)

      NCASE = 986
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      MFM3 = MAXVAL(MFMV1)
      MFM3 = ABS(MFM3 - MFMV1(3))
      CALL FM_ST2M(' 0 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 987
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM3 = MAXVAL(MFMA)
      MFM3 = ABS(MFM3 - MFMA(3,3))
      CALL FM_ST2M(' 0 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 988
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MIM3 = MAXVAL(MIMV1)
      MIM3 = ABS(MIM3 - MIMV1(3))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 989
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM3 = MAXVAL(MIMA2)
      MIM3 = ABS(MIM3 - MIMA2(3,3))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 990
      MFM3 = MIN(MFM1,MFM2)
      CALL FM_MIN(MFM1,MFM2,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 991
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = MIN(MFM2,MFM1,MFM4)
      CALL FM_MIN(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_MIN(MFM2,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 992
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = MIN(MFM2,MFM1,MFM4,MFM2,MFM1,MFM4,MFM2,MFM1,MFM4,MFM2)
      CALL FM_MIN(MFM1,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_MIN(MFM2,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 993
      MIM3 = MIN(MIM1,MIM2)
      CALL IM_MIN(MIM1,MIM2,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 994
      CALL IM_ST2M('7654',MIM4)
      CALL IM_ST2M('-1654',MIM3)
      MIM3 = MIN(MIM2,MIM1,MIM3,MIM4)
      CALL IM_ST2M('-1654',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 995
      CALL IM_ST2M('7654',MIM4)
      CALL IM_ST2M('-1654',MIM3)
      MIM3 = MIN(MIM2,MIM1,MIM3,MIM4,MIM2,MIM1,MIM3,MIM4,MIM2,MIM1)
      CALL IM_ST2M('-1654',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      END SUBROUTINE TEST38

      SUBROUTINE TEST39

!             Test functions MINEXPONENT, ..., RRSPACING.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type MINEXPONENT, ..., RRSPACING interfaces.')")

      NCASE = 996
      J = MINEXPONENT(MFM1)
      IF (J /= -INT(MXEXP)) CALL PRTERR(KW)

      NCASE = 997
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM3 = MINVAL(MFMV1)
      MFM3 = ABS(MFM3 - MFMV1(2))
      CALL FM_ST2M(' 0 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 998
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM3 = MINVAL(MFMA)
      MFM3 = ABS(MFM3 - MFMA(1,1))
      CALL FM_ST2M(' 0 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 999
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MIM3 = MINVAL(MIMV1)
      MIM3 = ABS(MIM3 - MIMV1(2))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1000
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM3 = MINVAL(MIMA2)
      MIM3 = ABS(MIM3 - MIMA2(1,1))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1001
      CALL FM_ST2M('8',MFM3)
      CALL FM_ST2M('5',MFM4)
      MFM3 = MOD(MFM3,MFM4)
      CALL FM_ST2M('3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1002
      CALL FM_ST2M('-8',MFM3)
      CALL FM_ST2M('5',MFM4)
      MFM3 = MOD(MFM3,MFM4)
      CALL FM_ST2M('-3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1003
      CALL FM_ST2M('8',MFM3)
      CALL FM_ST2M('-5',MFM4)
      MFM3 = MOD(MFM3,MFM4)
      CALL FM_ST2M('3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1004
      CALL FM_ST2M('-8',MFM3)
      CALL FM_ST2M('-5',MFM4)
      MFM3 = MOD(MFM3,MFM4)
      CALL FM_ST2M('-3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1005
      CALL IM_ST2M('8',MIM3)
      CALL IM_ST2M('5',MIM4)
      MIM3 = MOD(MIM3,MIM4)
      CALL IM_ST2M('3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1006
      CALL IM_ST2M('-8',MIM3)
      CALL IM_ST2M('5',MIM4)
      MIM3 = MOD(MIM3,MIM4)
      CALL IM_ST2M('-3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1007
      CALL IM_ST2M('8',MIM3)
      CALL IM_ST2M('-5',MIM4)
      MIM3 = MOD(MIM3,MIM4)
      CALL IM_ST2M('3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1008
      CALL IM_ST2M('-8',MIM3)
      CALL IM_ST2M('-5',MIM4)
      MIM3 = MOD(MIM3,MIM4)
      CALL IM_ST2M('-3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1009
      CALL FM_ST2M('8',MFM3)
      CALL FM_ST2M('5',MFM4)
      MFM3 = MODULO(MFM3,MFM4)
      CALL FM_ST2M('3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1010
      CALL FM_ST2M('8',MFM3)
      CALL FM_ST2M('5',MFM4)
      CALL FM_MODULO(MFM3,MFM4,MFM5)
      CALL FM_EQ(MFM5,MFM3)
      CALL FM_ST2M('3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1011
      CALL FM_ST2M('-8',MFM3)
      CALL FM_ST2M('5',MFM4)
      MFM3 = MODULO(MFM3,MFM4)
      CALL FM_ST2M('2',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1012
      CALL FM_ST2M('8',MFM3)
      CALL FM_ST2M('-5',MFM4)
      MFM3 = MODULO(MFM3,MFM4)
      CALL FM_ST2M('-2',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1013
      CALL FM_ST2M('-8',MFM3)
      CALL FM_ST2M('-5',MFM4)
      MFM3 = MODULO(MFM3,MFM4)
      CALL FM_ST2M('-3',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1014
      CALL IM_ST2M('8',MIM3)
      CALL IM_ST2M('5',MIM4)
      MIM3 = MODULO(MIM3,MIM4)
      CALL IM_ST2M('3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1015
      CALL IM_ST2M('-8',MIM3)
      CALL IM_ST2M('5',MIM4)
      MIM3 = MODULO(MIM3,MIM4)
      CALL IM_ST2M('2',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1016
      CALL IM_ST2M('8',MIM3)
      CALL IM_ST2M('-5',MIM4)
      MIM3 = MODULO(MIM3,MIM4)
      CALL IM_ST2M('-2',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1017
      CALL IM_ST2M('-8',MIM3)
      CALL IM_ST2M('-5',MIM4)
      MIM3 = MODULO(MIM3,MIM4)
      CALL IM_ST2M('-3',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1018
      CALL FM_ST2M('0',MFM4)
      CALL FM_ST2M('1',MFM3)
      CALL FM_TINY(MFM5)
      MFM3 = NEAREST(MFM4,MFM3)
      IF (.NOT.(MFM3 == MFM5)) CALL PRTERR(KW)

      NCASE = 1019
      CALL FM_ST2M('0',MFM4)
      CALL FM_ST2M('-1',MFM3)
      CALL FM_TINY(MFM5)
      CALL FM_MPYI_R1(MFM5,-1)
      MFM3 = NEAREST(MFM4,MFM3)
      IF (.NOT.(MFM3 == MFM5)) CALL PRTERR(KW)

      NCASE = 1020
      CALL FM_ST2M('2.345',MFM4)
      CALL FM_ST2M('1',MFM3)
      MFM3 = NEAREST(MFM4,MFM3)
      CALL FM_ULP(MFM4,MFM5)
      CALL FM_ADD(MFM4,MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1021
      CALL FM_ST2M('2.345',MFM4)
      CALL FM_ST2M('1',MFM3)
      CALL FM_NEAREST(MFM4,MFM3,MFM5)
      CALL FM_EQ(MFM5,MFM3)
      CALL FM_ULP(MFM4,MFM5)
      CALL FM_ADD(MFM4,MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1022
      CALL FM_ST2M('2.345',MFM4)
      CALL FM_ST2M('-1',MFM3)
      MFM3 = NEAREST(MFM4,MFM3)
      CALL FM_ULP(MFM4,MFM5)
      CALL FM_SUB(MFM4,MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1023
      CALL FM_ST2M('1',MFM4)
      CALL FM_ST2M('-1',MFM3)
      MFM3 = NEAREST(MFM4,MFM3)
      CALL FM_ST2M('0.99',MFM5)
      CALL FM_ULP(MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM5)
      CALL FM_SUB(MFM4,MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1024
      CALL FM_ST2M('-1',MFM4)
      CALL FM_ST2M('12',MFM3)
      MFM3 = NEAREST(MFM4,MFM3)
      CALL FM_ST2M('-0.99',MFM5)
      CALL FM_ULP(MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM5)
      CALL FM_SUB(MFM4,MFM5,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1025
      MIM3 = NINT(MFM1)
      CALL FM_NINT(MFM1,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1026
      MIM3 = NINT(MIM1)
      CALL IM_EQ(MIM1,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1027
      MIM3 = NINT(MZM1)
      CALL ZM_NINT(MZM1,MZM4)
      CALL ZM_REAL(MZM4,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1028
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = NINT(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == NINT(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1029
      MIMV1 = TO_IM( (/ 12, -34, 56 /) )
      MIMV2 = NINT(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == NINT(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1030
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = NINT(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == NINT(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1031
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = NINT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == NINT(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1032
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = (-1)**(J+K) * TO_IM(25+3*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = NINT(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == NINT(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1033
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = NINT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == NINT(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1034
      J = PRECISION(MFM1)
      IF (J /= INT(LOG10(REAL(MBASE))*(NDIG-1) + 1)) CALL PRTERR(KW)

      NCASE = 1035
      J = PRECISION(MZM1)
      IF (J /= INT(LOG10(REAL(MBASE))*(NDIG-1) + 1)) CALL PRTERR(KW)

      NCASE = 1036
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM3 = PRODUCT(MFMV1)
      MFM4 = TO_FM('-23335.371886315713067263700860897069')
      MFM3 = ABS(MFM3 - MFM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1037
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM3 = PRODUCT(MFMA)
      MFM4 = TO_FM('1.11839386498724787888025199410658944266626022455926434E10')
      MFM3 = ABS(MFM3 - MFM4)
      CALL FM_ST2M(' 1.0E-35 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1038
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MIM3 = PRODUCT(MIMV1)
      MIM3 = ABS(MIM3 - (-22848))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1039
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM3 = PRODUCT(MIMA2)
      MIM3 = ABS(MIM3 - TO_IM('8821612800'))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1040
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') ,  &
                 TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM3 = PRODUCT(MZMV1)
      MZM4 = TO_ZM('-20423.717467422304481791683360897069 - '//  &
                   ' 22129.6037029617409201804816458 i')
      MFM3 = ABS(MZM3 - MZM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1041
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM3 = PRODUCT(MZMA2)
      MZM4 = TO_ZM('-1.99055822653094068848240107E17 + '//  &
                   ' 2.47926597678191251226278026E17 i')
      MFM3 = ABS(MZM3 - MZM4)
      CALL FM_ST2M(' 1.0E-28 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1042
      J = RADIX(MFM1)
      IF (J /= INT(MBASE)) CALL PRTERR(KW)

      NCASE = 1043
      J = RADIX(MIM1)
      IF (J /= INT(MBASE)) CALL PRTERR(KW)

      NCASE = 1044
      J = RADIX(MZM1)
      IF (J /= INT(MBASE)) CALL PRTERR(KW)

      NCASE = 1045
      J = RANGE(MFM1)
      IF (J /= NINT((MXEXP+1)*LOG10(DBLE(MBASE)))-1) CALL PRTERR(KW)

      NCASE = 1046
      J = RANGE(MIM1)
      IF (J /= INT(SIZE_OF_MWK/10*LOG10(REAL(MBASE)))) CALL PRTERR(KW)

      NCASE = 1047
      J = RANGE(MZM1)
      IF (J /= NINT((MXEXP+1)*LOG10(DBLE(MBASE)))-1) CALL PRTERR(KW)

      NCASE = 1048
      MFM3 = REAL(MFM1)
      CALL FM_EQ(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1049
      MFM3 = REAL(MIM1)
      CALL IM_I2FM(MIM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1050
      MFM3 = REAL(MZM1)
      CALL ZM_REAL(MZM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1051
      MFM3 = RRSPACING(MFM1)
      CALL FM_ABS(MFM1,MFM4)
      MWK(START(MFM4%MFM)+2) = NDIG
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1052
      CALL FM_RRSPACING(MFM1,MFM3)
      CALL FM_ABS(MFM1,MFM4)
      MWK(START(MFM4%MFM)+2) = NDIG
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      END SUBROUTINE TEST39

      SUBROUTINE TEST40

!             Test functions SCALE, ..., TINY.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type SCALE, ..., TINY interfaces.')")

      NCASE = 1053
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SCALE(MFM4,1)
      CALL FM_MPYI(MFM4,INT(MBASE),MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1054
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = SCALE(MZM4,-2)
      CALL ZM_DIVI(MZM4,INT(MBASE),MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_DIVI(MZM4,INT(MBASE),MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1055
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SETEXPONENT(MFM4,1)
      CALL FM_MPYI(MFM4,INT(MBASE),MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1056
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SIGN(MFM4,MFM2)
      CALL FM_SIGN(MFM4,MFM2,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1057
      CALL IM_ST2M('231',MIM4)
      MIM3 = SIGN(MIM4,MIM2)
      CALL IM_SIGN(MIM4,MIM2,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1058
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SIN(MFM4)
      CALL FM_SIN(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1059
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = SIN(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == SIN(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1060
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = SIN(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == SIN(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1061
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = SIN(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == SIN(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1062
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = SIN(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == SIN(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1063
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = SIN(MZM4)
      CALL ZM_SIN(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1064
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SINH(MFM4)
      CALL FM_SINH(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1065
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = SINH(MZM4)
      CALL ZM_SINH(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1066
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = SINH(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == SINH(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1067
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = SINH(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == SINH(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1068
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = SINH(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == SINH(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1069
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = SINH(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == SINH(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1070
      CALL FM_ST2M('-0.7654',MFM4)
      MFM3 = SPACING(MFM4)
      CALL FM_ULP(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1071
      CALL FM_ST2M('-0.7654',MFM4)
      CALL FM_SPACING(MFM4,MFM3)
      CALL FM_ULP(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1072
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SQRT(MFM4)
      CALL FM_SQRT(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1073
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = SQRT(MFM4)
      CALL FM_SQRT_R1(MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1074
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = SQRT(MZM4)
      CALL ZM_SQRT(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1075
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = SQRT(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == SQRT(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1076
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = SQRT(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == SQRT(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1077
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = SQRT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == SQRT(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1078
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = SQRT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == SQRT(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1079
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM3 = SUM(MFMV1)
      MFM4 = TO_FM('34.2123456789')
      MFM3 = ABS(MFM3 - MFM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1080
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM3 = SUM(MFMA)
      MFM4 = TO_FM('120')
      MFM3 = ABS(MFM3 - MFM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1081
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MIM3 = SUM(MIMV1)
      MIM3 = ABS(MIM3 - 34)
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1082
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM3 = SUM(MIMA2)
      MIM3 = ABS(MIM3 - TO_IM('117'))
      CALL IM_ST2M(' 0 ',MIM4)
      IF (.NOT.(MIM3 <= MIM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1083
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') ,  &
                 TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM3 = SUM(MZMV1)
      MZM4 = TO_ZM('34.2123456789 + 4.17498 i')
      MFM3 = ABS(MZM3 - MZM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1084
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM3 = SUM(MZMA2)
      MZM4 = TO_ZM('695.7 - 336.6 i')
      MFM3 = ABS(MZM3 - MZM4)
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1085
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = TAN(MFM4)
      CALL FM_TAN(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1086
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = TAN(MZM4)
      CALL ZM_TAN(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1087
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = TAN(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == TAN(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1088
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = TAN(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == TAN(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1089
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = TAN(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == TAN(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1090
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = TAN(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == TAN(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1091
      CALL FM_ST2M('0.7654',MFM4)
      MFM3 = TANH(MFM4)
      CALL FM_TANH(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1092
      CALL ZM_ST2M('0.7654 - 0.3456 i',MZM4)
      MZM3 = TANH(MZM4)
      CALL ZM_TANH(MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1093
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = TANH(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == TANH(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1094
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = TANH(MZMV1)
      DO J = 1, 3
         IF (.NOT.(MZMV2(J) == TANH(MZMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1095
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = TANH(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == TANH(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1096
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = TANH(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMB2(J,K) == TANH(MZMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1097
      CALL FM_BIG(MFM4)
      CALL FM_I2M(1,MFM3)
      CALL FM_DIV(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = TINY(MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1098
      MIM3 = TINY(MIM1)
      CALL IM_I2M(1,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1099
      CALL FM_BIG(MFM4)
      CALL FM_I2M(1,MFM3)
      CALL FM_DIV(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL ZM_COMPLEX(MFM4,MFM4,MZM4)
      MZM3 = TINY(MZM1)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      END SUBROUTINE TEST40

      SUBROUTINE TEST41

!             Test functions TO_FM, TO_IM, TO_ZM, ..., TO_DPZ.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type TO_FM,  ..., TO_DPZ interfaces.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0

      NCASE = 1100
      MFM3 = TO_FM(123)
      CALL FM_I2M(123,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1101
      MFM3 = TO_FM(123.4)
      CALL FM_SP2M(123.4,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1102
      MFM3 = TO_FM(123.45D0)
      CALL FM_DP2M(123.45D0,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1103
      MFM3 = TO_FM(CMPLX(123.4,567.8))
      CALL FM_SP2M(123.4,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1104
      MFM3 = TO_FM(CMPLX(123.4D0,567.8D0,KIND(1.0D0)))
      CALL FM_DP2M(123.4D0,MFM4)
      CALL FM_SUB(MFM3,MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_DIV(MFM4,MFM3,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      CALL FM_ABS(MFM4,MFM6)
      CALL FM_EQ(MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1105
      MFM3 = TO_FM(MFM1)
      CALL FM_EQ(MFM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1106
      MFM3 = TO_FM(MIM1)
      CALL IM_I2FM(MIM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1107
      MFM3 = TO_FM(MZM1)
      CALL ZM_REAL(MZM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1108
      MFM3 = TO_FM('-123.654')
      CALL FM_ST2M('-123.654',MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1109
      JV = (/  123,  -432,  567  /)
      MFMV1 = TO_FM(JV)
      MFMV2 = JV
      DO J = 1, 3
         IF (.NOT.(MFMV1(J) == MFMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1110
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = TO_FM(RV)
      MFMV2 = RV
      DO J = 1, 3
         IF (ABS((MFMV1(J)-MFMV2(J))/MFMV2(J)) >= RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1111
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = TO_FM(DV)
      MFMV2 = DV
      DO J = 1, 3
         IF (ABS((MFMV1(J)-MFMV2(J))/MFMV2(J)) >= DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1112
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = TO_FM(CV)
      MFMV2 = CV
      DO J = 1, 3
         IF (ABS((MFMV1(J)-MFMV2(J))/MFMV2(J)) >= RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1113
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = TO_FM(CDV)
      MFMV2 = CDV
      DO J = 1, 3
         IF (ABS((MFMV1(J)-MFMV2(J))/MFMV2(J)) >= DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1114
      MFMV4 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      MFMV1 = TO_FM(MFMV4)
      MFMV2 = MFMV4
      DO J = 1, 3
         IF (ABS(MFMV1(J)-MFMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1115
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MFMV1 = TO_FM(MIMV1)
      MFMV2 = MIMV1
      DO J = 1, 3
         IF (ABS(MFMV1(J)-MFMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1116
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = TO_FM(MZMV1)
      MFMV2 = MZMV1
      DO J = 1, 3
         IF (ABS(MFMV1(J)-MFMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1117
      STV = (/ " 12.1123456789", "-34.2123456789", " 56.3123456789" /)
      MFMV1 = TO_FM(STV)
      MFMV2 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DO J = 1, 3
         IF (ABS(MFMV1(J)-MFMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1118
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(JV2)
      MFMB = JV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMA(J,K) == MFMB(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1119
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(RV2)
      MFMB = RV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MFMA(J,K)-MFMB(J,K))/MFMB(J,K)) >= RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1120
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(DV2)
      MFMB = DV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MFMA(J,K)-MFMB(J,K))/MFMB(J,K)) >= DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1121
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(CV2)
      MFMB = CV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MFMA(J,K)-MFMB(J,K))/MFMB(J,K)) >= RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1122
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(CDV2)
      MFMB = CDV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MFMA(J,K)-MFMB(J,K))/MFMB(J,K)) >= DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1123
      DO J = 1, 3
         DO K = 1, 3
            MFMC(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMA = TO_FM(MFMC)
      MFMB = MFMC
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MFMA(J,K)-MFMB(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1124
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMA = TO_FM(MIMA2)
      MFMB = MIMA2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MFMA(J,K)-MFMB(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1125
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFMA = TO_FM(MZMA2)
      MFMB = MZMA2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MFMA(J,K)-MFMB(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1126
      STV2 = RESHAPE( (/ " 12.1123456789", "-34.2123456789", " 56.3123456789",  &
                         " 23.1123456789", "-36.2123456789", " 66.3123456789",  &
                         " 45.1123456789", "-38.2123456789", " 76.3123456789"   &
                      /) , SHAPE = (/ 3,3 /) )
      MFMA = TO_FM(STV2)
      MFMB = RESHAPE( (/ TO_FM(" 12.1123456789"), TO_FM("-34.2123456789"),  &
                         TO_FM(" 56.3123456789"), TO_FM(" 23.1123456789"),  &
                         TO_FM("-36.2123456789"), TO_FM(" 66.3123456789"),  &
                         TO_FM(" 45.1123456789"), TO_FM("-38.2123456789"),  &
                         TO_FM(" 76.3123456789")   &
                      /) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MFMA(J,K)-MFMB(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1127
      MIM3 = TO_IM(123)
      CALL IM_I2M(123,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1128
      MIM3 = TO_IM(123.4)
      CALL FM_SP2M(123.4,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1129
      MIM3 = TO_IM(1.234E+23)
      CALL FM_SP2M(1.234E+23,MFM4)
      MFM5 = ABS(MIM3-MFM4)/MFM4
      IF (MFM5 >= RSMALL) CALL PRTERR(KW)

      NCASE = 1130
      MIM3 = TO_IM(123.45D0)
      CALL FM_DP2M(123.45D0,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1131
      MIM3 = TO_IM(1.234D+23)
      CALL FM_DP2M(1.234D+23,MFM4)
      MFM5 = ABS(MIM3-MFM4)/MFM4
      IF (MFM5 >= DSMALL) CALL PRTERR(KW)

      NCASE = 1132
      MIM3 = TO_IM(CMPLX(123.4,567.8))
      CALL FM_SP2M(123.4,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1133
      MIM3 = TO_IM(CMPLX(1.234E+23,1.234E+23))
      CALL FM_SP2M(1.234E+23,MFM4)
      MFM5 = ABS(MIM3-MFM4)/MFM4
      IF (MFM5 >= RSMALL) CALL PRTERR(KW)

      NCASE = 1134
      MIM3 = TO_IM(CMPLX(123.4D0,567.8D0,KIND(1.0D0)))
      CALL FM_DP2M(123.4D0,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1135
      MIM3 = TO_IM(CMPLX(1.234D+23,1.234D+23,KIND(1.0D0)))
      CALL FM_DP2M(1.234D+23,MFM4)
      MFM5 = ABS(MIM3-MFM4)/MFM4
      IF (MFM5 >= DSMALL) CALL PRTERR(KW)

      NCASE = 1136
      MIM3 = TO_IM(MFM1)
      CALL FM_EQ(MFM1,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1137
      MIM3 = TO_IM(MIM1)
      CALL IM_I2FM(MIM1,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1138
      MIM3 = TO_IM(MZM1)
      CALL ZM_REAL(MZM1,MFM4)
      CALL IM_FM2I(MFM4,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1139
      MIM3 = TO_IM('-123654')
      CALL IM_ST2M('-123654',MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1140
      JV = (/  123,  -432,  567  /)
      MIMV1 = TO_IM(JV)
      MIMV2 = JV
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1141
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = TO_IM(RV)
      MIMV2 = RV
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1142
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = TO_IM(DV)
      MIMV2 = DV
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1143
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = TO_IM(CV)
      MIMV2 = CV
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1144
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = TO_IM(CDV)
      MIMV2 = CDV
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1145
      MFMV4 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      MIMV1 = TO_IM(MFMV4)
      MIMV2 = MFMV4
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1146
      MIMV4 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MIMV1 = TO_IM(MIMV4)
      MIMV2 = MIMV4
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1147
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = TO_IM(MZMV1)
      MIMV2 = MZMV1
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1148
      STV = (/ " 12.1123456789", "-34.2123456789", " 56.3123456789" /)
      MIMV1 = TO_IM(STV)
      MIMV2 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DO J = 1, 3
         IF (.NOT.(MIMV1(J) == MIMV2(J))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1149
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(JV2)
      MIMB2 = JV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1150
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(RV2)
      MIMB2 = RV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1151
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(DV2)
      MIMB2 = DV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1152
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(CV2)
      MIMB2 = CV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1153
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(CDV2)
      MIMB2 = CDV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1154
      DO J = 1, 3
         DO K = 1, 3
            MFMC(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMA2 = TO_IM(MFMC)
      MIMB2 = MFMC
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1155
      DO J = 1, 3
         DO K = 1, 3
            MIMC2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMA2 = TO_IM(MIMC2)
      MIMB2 = MIMC2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1156
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMA2 = TO_IM(MZMA2)
      MIMB2 = MZMA2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1157
      STV2 = RESHAPE( (/ " 12.1123456789", "-34.2123456789", " 56.3123456789",  &
                         " 23.1123456789", "-36.2123456789", " 66.3123456789",  &
                         " 45.1123456789", "-38.2123456789", " 76.3123456789"   &
                      /) , SHAPE = (/ 3,3 /) )
      MIMA2 = TO_IM(STV2)
      MIMB2 = RESHAPE( (/ TO_FM(" 12.1123456789"), TO_FM("-34.2123456789"),  &
                          TO_FM(" 56.3123456789"), TO_FM(" 23.1123456789"),  &
                          TO_FM("-36.2123456789"), TO_FM(" 66.3123456789"),  &
                          TO_FM(" 45.1123456789"), TO_FM("-38.2123456789"),  &
                          TO_FM(" 76.3123456789")   &
                       /) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMA2(J,K) == MIMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1158
      MZM3 = TO_ZM(123)
      CALL ZM_I2M(123,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1159
      MZM3 = TO_ZM(123,456)
      MZM4 = TO_ZM(" 123 + 456 i ")
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1160
      MZM3 = TO_ZM(123.4)
      CALL FM_SP2M(123.4,MFM4)
      CALL FM_I2M(0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1161
      MZM3 = TO_ZM(123.4,-456.7)
      CALL FM_SP2M(123.4,MFM4)
      CALL FM_SP2M(-456.7,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1162
      MZM3 = TO_ZM(123.45D0)
      CALL FM_DP2M(123.45D0,MFM4)
      CALL FM_I2M(0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1163
      MZM3 = TO_ZM(123.45D0,-456.78D0)
      CALL FM_DP2M(123.45D0,MFM4)
      CALL FM_DP2M(-456.78D0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1164
      MZM3 = TO_ZM(CMPLX(123.4,567.8))
      CALL FM_SP2M(123.4,MFM4)
      CALL FM_SP2M(567.8,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = RSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1165
      MZM3 = TO_ZM(CMPLX(123.4D0,567.8D0,KIND(1.0D0)))
      CALL FM_DP2M(123.4D0,MFM4)
      CALL FM_DP2M(567.8D0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      CALL ZM_SUB(MZM3,MZM4,MZM5)
      CALL ZM_EQ(MZM5,MZM4)
      CALL ZM_ABS(MZM4,MFM5)
      CALL ZM_ABS(MZM3,MFM6)
      CALL FM_DIV(MFM5,MFM6,MFM4)
      MFM3 = DSMALL
      IF (FM_COMP(MFM4,'GT',MFM3)) CALL PRTERR(KW)

      NCASE = 1166
      MZM3 = TO_ZM(MFM1)
      CALL FM_EQ(MFM1,MFM4)
      CALL FM_I2M(0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1167
      MZM3 = TO_ZM(MIM1)
      CALL IM_I2FM(MIM1,MFM4)
      CALL FM_I2M(0,MFM5)
      CALL ZM_COMPLEX(MFM4,MFM5,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1168
      MZM3 = TO_ZM(MZM1)
      CALL ZM_EQ(MZM1,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1169
      MZM3 = TO_ZM('-123.654 + 98.7 i')
      CALL ZM_ST2M('-123.654 + 98.7 i',MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1170
      JV = (/  123,  -432,  567  /)
      MZMV1 = TO_ZM(JV)
      MZMV2 = JV
      DO J = 1, 3
         IF (ABS(MZMV1(J)-MZMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1171
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = TO_ZM(RV)
      MZMV2 = RV
      DO J = 1, 3
         IF (ABS((MZMV1(J)-MZMV2(J))/MZMV2(J)) >= RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1172
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = TO_ZM(DV)
      MZMV2 = DV
      DO J = 1, 3
         IF (ABS((MZMV1(J)-MZMV2(J))/MZMV2(J)) >= DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1173
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = TO_ZM(CV)
      MZMV2 = CV
      DO J = 1, 3
         IF (ABS((MZMV1(J)-MZMV2(J))/MZMV2(J)) >= RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1174
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = TO_ZM(CDV)
      MZMV2 = CDV
      DO J = 1, 3
         IF (ABS((MZMV1(J)-MZMV2(J))/MZMV2(J)) >= DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1175
      MFMV4 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      MZMV1 = TO_ZM(MFMV4)
      MZMV2 = MFMV4
      DO J = 1, 3
         IF (ABS(MZMV1(J)-MZMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1176
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      MZMV1 = TO_ZM(MIMV1)
      MZMV2 = MIMV1
      DO J = 1, 3
         IF (ABS(MZMV1(J)-MZMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1177
      MZMV4 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV1 = TO_ZM(MZMV4)
      MZMV2 = MZMV4
      DO J = 1, 3
         IF (ABS(MZMV1(J)-MZMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1178
      STV = (/ " 12.1123456789", "-34.2123456789", " 56.3123456789" /)
      MZMV1 = TO_ZM(STV)
      MZMV2 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DO J = 1, 3
         IF (ABS(MZMV1(J)-MZMV2(J)) /= 0) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1179
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(JV2)
      MZMB2 = JV2
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MZMA2(J,K) == MZMB2(J,K))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1180
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(RV2)
      MZMB2 = RV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MZMA2(J,K)-MZMB2(J,K))/MZMB2(J,K)) >= RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1181
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(DV2)
      MZMB2 = DV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MZMA2(J,K)-MZMB2(J,K))/MZMB2(J,K)) >= DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1182
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(CV2)
      MZMB2 = CV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MZMA2(J,K)-MZMB2(J,K))/MZMB2(J,K)) >= RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1183
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(CDV2)
      MZMB2 = CDV2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((MZMA2(J,K)-MZMB2(J,K))/MZMB2(J,K)) >= DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1184
      DO J = 1, 3
         DO K = 1, 3
            MFMC(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMA2 = TO_ZM(MFMC)
      MZMB2 = MFMC
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MZMA2(J,K)-MZMB2(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1185
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMA2 = TO_ZM(MIMA2)
      MZMB2 = MIMA2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MZMA2(J,K)-MZMB2(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1186
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMA2 = TO_ZM(MZMA2)
      MZMB2 = MZMA2
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MZMA2(J,K)-MZMB2(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1187
      STV2 = RESHAPE( (/ " 12.34 + 87.65 i", "-34.21 + 44.55 i", " 56.74 - 88.23 i",  &
                         " 23.11 - 97.53 i", "-36.46 - 83.37 i", " 66.38 + 72.15 i",  &
                         " 45.28 - 28.45 i", "-38.04 -  4.85 i", " 76.31 - 13.67 i"   &
                      /) , SHAPE = (/ 3,3 /) )
      MZMA2 = TO_ZM(STV2)
      MZMB2 = RESHAPE( (/ TO_ZM(" 12.34 + 87.65 i"), TO_ZM("-34.21 + 44.55 i"),  &
                          TO_ZM(" 56.74 - 88.23 i"), TO_ZM(" 23.11 - 97.53 i"),  &
                          TO_ZM("-36.46 - 83.37 i"), TO_ZM(" 66.38 + 72.15 i"),  &
                          TO_ZM(" 45.28 - 28.45 i"), TO_ZM("-38.04 -  4.85 i"),  &
                          TO_ZM(" 76.31 - 13.67 i")   &
                       /) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS(MZMA2(J,K)-MZMB2(J,K)) /= 0) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1188
      CALL FM_M2I(MFM1,J3)
      IF (TO_INT(MFM1) /= J3) CALL PRTERR(KW)

      NCASE = 1189
      CALL IM_M2I(MIM1,J3)
      IF (TO_INT(MIM1) /= J3) CALL PRTERR(KW)

      NCASE = 1190
      CALL ZM_M2I(MZM1,J3)
      IF (TO_INT(MZM1) /= J3) CALL PRTERR(KW)

      NCASE = 1191
      CALL FM_M2SP(MFM1,R3)
      IF (ABS((TO_SP(MFM1)-R3)/R3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1192
      CALL IM_M2DP(MIM1,D3)
      R3 = D3
      IF (ABS((TO_SP(MIM1)-R3)/R3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1193
      CALL ZM_REAL(MZM1,MFM4)
      CALL FM_M2SP(MFM4,R3)
      IF (ABS((TO_SP(MZM1)-R3)/R3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1194
      CALL FM_M2DP(MFM1,D3)
      IF (ABS((TO_DP(MFM1)-D3)/D3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1195
      CALL IM_M2DP(MIM1,D3)
      IF (ABS((TO_DP(MIM1)-D3)/D3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1196
      CALL ZM_REAL(MZM1,MFM4)
      CALL FM_M2DP(MFM4,D3)
      IF (ABS((TO_DP(MZM1)-D3)/D3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1197
      CALL FM_M2SP(MFM1,R3)
      C3 = R3
      IF (ABS((TO_SPZ(MFM1)-C3)/C3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1198
      CALL IM_M2DP(MIM1,D3)
      C3 = D3
      IF (ABS((TO_SPZ(MIM1)-C3)/C3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1199
      CALL ZM_M2Z(MZM1,C3)
      IF (ABS((TO_SPZ(MZM1)-C3)/C3) > RSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1200
      CALL FM_M2DP(MFM1,D3)
      CD3 = D3
      IF (ABS((TO_DPZ(MFM1)-CD3)/CD3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1201
      CALL IM_M2DP(MIM1,D3)
      CD3 = D3
      IF (ABS((TO_DPZ(MIM1)-CD3)/CD3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1202
      CALL ZM_REAL(MZM1,MFM4)
      CALL FM_M2DP(MFM4,D3)
      CALL ZM_IMAG(MZM1,MFM4)
      CALL FM_M2DP(MFM4,D4)
      CD3 = CMPLX( D3 , D4 , KIND(0.0D0) )
      IF (ABS((TO_DPZ(MZM1)-CD3)/CD3) > DSMALL) THEN
          CALL PRTERR(KW)
      ENDIF

      NCASE = 1203
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DV = TO_INT(MFMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-INT(MFMV1(J)))/INT(MFMV1(J))) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1204
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      DV = TO_INT(MIMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-INT(MIMV1(J)))/INT(MIMV1(J))) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1205
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      DV = TO_INT(MZMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-INT(REAL(MZMV1(J))))/INT(REAL(MZMV1(J)))) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1206
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_INT(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-INT(MFMA(J,K)))/INT(MFMA(J,K))) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1207
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_INT(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-INT(MIMA2(J,K)))/INT(MIMA2(J,K))) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1208
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DV2 = TO_INT(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-INT(REAL(MZMA2(J,K))))/INT(REAL(MZMA2(J,K)))) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1209
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DV = TO_SP(MFMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-MFMV1(J))/MFMV1(J)) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1210
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      DV = TO_SP(MIMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-MIMV1(J))/MIMV1(J)) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1211
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      DV = TO_SP(MZMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-REAL(MZMV1(J)))/REAL(MZMV1(J))) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1212
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_SP(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-MFMA(J,K))/MFMA(J,K)) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1213
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_SP(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-MIMA2(J,K))/MIMA2(J,K)) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1214
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DV2 = TO_SP(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-REAL(MZMA2(J,K)))/REAL(MZMA2(J,K))) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1215
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      DV = TO_DP(MFMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-MFMV1(J))/MFMV1(J)) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1216
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      DV = TO_DP(MIMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-MIMV1(J))/MIMV1(J)) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1217
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      DV = TO_DP(MZMV1)
      DO J = 1, 3
         IF (ABS((DV(J)-REAL(MZMV1(J)))/REAL(MZMV1(J))) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1218
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_DP(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-MFMA(J,K))/MFMA(J,K)) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1219
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = TO_DP(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-MIMA2(J,K))/MIMA2(J,K)) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1220
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DV2 = TO_DP(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((DV2(J,K)-REAL(MZMA2(J,K)))/REAL(MZMA2(J,K))) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1221
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      CV = TO_SPZ(MFMV1)
      DO J = 1, 3
         IF (ABS((CV(J)-MFMV1(J))/MFMV1(J)) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1222
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      CV = TO_SPZ(MIMV1)
      DO J = 1, 3
         IF (ABS((CV(J)-MIMV1(J))/MIMV1(J)) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1223
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      CV = TO_SPZ(MZMV1)
      DO J = 1, 3
         IF (ABS((CV(J)-MZMV1(J))/MZMV1(J)) > RSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1224
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CV2 = TO_SPZ(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CV2(J,K)-MFMA(J,K))/MFMA(J,K)) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1225
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CV2 = TO_SPZ(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CV2(J,K)-MIMA2(J,K))/MIMA2(J,K)) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1226
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      CV2 = TO_SPZ(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CV2(J,K)-MZMA2(J,K))/MZMA2(J,K)) > RSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1227
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') ,  &
                 TO_FM('56.3123456789') /)
      CDV = TO_DPZ(MFMV1)
      DO J = 1, 3
         IF (ABS((CDV(J)-MFMV1(J))/MFMV1(J)) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1228
      MIMV1 = (/ TO_IM('12') , TO_IM('-34') , TO_IM('56') /)
      CDV = TO_DPZ(MIMV1)
      DO J = 1, 3
         IF (ABS((CDV(J)-MIMV1(J))/MIMV1(J)) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1229
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      CDV = TO_DPZ(MZMV1)
      DO J = 1, 3
         IF (ABS((CDV(J)-MZMV1(J))/MZMV1(J)) > DSMALL) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1230
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CDV2 = TO_DPZ(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CDV2(J,K)-MFMA(J,K))/MFMA(J,K)) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1231
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CDV2 = TO_DPZ(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CDV2(J,K)-MIMA2(J,K))/MIMA2(J,K)) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1232
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)),  &
                               TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      CDV2 = TO_DPZ(MZMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (ABS((CDV2(J,K)-MZMA2(J,K))/MZMA2(J,K)) > DSMALL) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      END SUBROUTINE TEST41

      SUBROUTINE TEST42

!             Test the derived-type interface routines that are not used elsewhere in this program.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the derived type ADDI, ..., Z2M interfaces.')")

      RSMALL = EPSILON(1.0)*100.0
      DSMALL = EPSILON(1.0D0)*100.0
      MSMALL = EPSILON(TO_FM(1))*10000.0

      NCASE = 1233
      MFM3 = MFM1 + 123
      MFM4 = MFM1
      CALL FM_ADDI(MFM4,123)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1234
      CALL FM_COSH_SINH(MFM1,MFM4,MFM3)
      MFM3 = COSH(MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1235
      CALL FM_COSH_SINH(MFM1,MFM3,MFM4)
      MFM3 = SINH(MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1236
      CALL FM_COS_SIN(MFM1,MFM4,MFM3)
      MFM3 = COS(MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1237
      CALL FM_COS_SIN(MFM1,MFM3,MFM4)
      MFM3 = SIN(MFM1)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1238
      MFM3 = MFM1 / 123
      CALL FM_DIVI(MFM1,123,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1239
      MFM3 = MFM1 / 123
      MFM4 = MFM1
      CALL FM_DIVI_R1(MFM4,123)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1240
      MFM3 = 123.45D0
      CALL FM_DPM(123.45D0,MFM4)
      IF (ABS((MFM3-MFM4)/MFM4) > DSMALL) CALL PRTERR(KW)

      NCASE = 1241
      CALL FM_FORM('F70.56',MFM1,STRING)
      CALL FM_ST2M(STRING(1:70),MFM4)
      IF (ABS((MFM1-MFM4)/MFM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1242
      STRING = FM_FORMAT('F70.56',MFM1)
      CALL FM_ST2M(STRING(1:70),MFM4)
      IF (ABS((MFM1-MFM4)/MFM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1243
      MFM3 = MFM1 ** 123
      CALL FM_IPOWER(MFM1,123,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1244
      MFM3 = LOG(TO_FM(123))
      CALL FM_LNI(123,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1245
      D4 = MFM1
      CALL FM_M2DP(MFM1,D5)
      IF (ABS((D4-D5)/D4) > DSMALL) CALL PRTERR(KW)

      NCASE = 1246
      J4 = MFM1
      CALL FM_M2I(MFM1,J5)
      IF (J4 /= J5) CALL PRTERR(KW)

      NCASE = 1247
      R4 = MFM1
      CALL FM_M2SP(MFM1,R5)
      IF (ABS((R4-R5)/R4) > RSMALL) CALL PRTERR(KW)

      NCASE = 1248
      MFM3 = 2.67
      CALL FM_MOD(MFM1,MFM3,MFM4)
      MFM3 = MOD(MFM1,MFM3)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1249
      CALL FM_PI(MFM4)
      MFM3 = 4*ATAN(TO_FM(1))
      IF (ABS((MFM3-MFM4)/MFM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1250
      MFM3 = MFM1 ** (TO_FM(1)/TO_FM(3))
      CALL FM_RATIONAL_POWER(MFM1,1,3,MFM4)
      IF (ABS((MFM3-MFM4)/MFM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1251
      CALL FM_SQR(MFM1,MFM4)
      MFM3 = MFM1*MFM1
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1252
      CALL FM_EQ(MFM1,MFM4)
      CALL FM_SQR_R1(MFM4)
      MFM3 = MFM1*MFM1
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1253
      MIM3 = MIM1 / 13
      CALL IM_DIVI(MIM1,13,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1254
      MIM3 = 13
      CALL IM_DIVR(MIM1,MIM3,MIM5,MIM4)
      MIM3 = MOD(MIM1,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1255
      MIM3 = 13
      CALL IM_DIVR(MIM1,MIM3,MIM5,MIM4)
      CALL IM_EQ(MIM5,MIM3)
      MIM4 = MIM1 / 13
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1256
      MIM3 = MIM1 / 13
      CALL IM_DVIR(MIM1,13,MIM4,J5)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1257
      J4 = MOD(MIM1,TO_IM(13))
      CALL IM_DVIR(MIM1,13,MIM4,J5)
      IF (J4 /= J5) CALL PRTERR(KW)

      NCASE = 1258
      CALL IM_FORM('I70',MIM1,STRING)
      CALL IM_ST2M(STRING(1:70),MIM4)
      IF (.NOT.(MIM1 == MIM4)) CALL PRTERR(KW)

      NCASE = 1259
      STRING = IM_FORMAT('I70',MIM1)
      CALL IM_ST2M(STRING(1:70),MIM4)
      IF (.NOT.(MIM1 == MIM4)) CALL PRTERR(KW)

      NCASE = 1260
      MIM3 = 40833
      MIM4 = 16042
      CALL IM_GCD(MIM3,MIM4,MIM5)
      CALL IM_EQ(MIM5,MIM4)
      IF (.NOT.(MIM4 == 13)) CALL PRTERR(KW)

      NCASE = 1261
      MIM3 = 40833
      MIM4 = 16042
      MIM4 = GCD(MIM3,MIM4)
      IF (.NOT.(MIM4 == 13)) CALL PRTERR(KW)

      NCASE = 1262
      D4 = MIM1
      CALL IM_M2DP(MIM1,D5)
      IF (ABS((D4-D5)/D4) > DSMALL) CALL PRTERR(KW)

      NCASE = 1263
      J4 = MIM1
      CALL IM_M2I(MIM1,J5)
      IF (J4 /= J5) CALL PRTERR(KW)

      NCASE = 1264
      MIM3 = 6
      CALL IM_MOD(MIM1,MIM3,MIM4)
      MIM3 = MOD(MIM1,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1265
      MIM3 = MIM1 * 123
      CALL IM_MPYI(MIM1,123,MIM4)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1266
      MIM2 = 3141
      MIM3 = 133
      CALL IM_MPY_MOD(MIM1,MIM2,MIM3,MIM4)
      MIM3 = MOD(MIM1*MIM2,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1267
      MIM2 = 3141
      MIM3 = 133
      MIM4 = MULTIPLY_MOD(MIM1,MIM2,MIM3)
      MIM3 = MOD(MIM1*MIM2,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1268
      MIM2 = 31
      MIM3 = 147
      CALL IM_POWER_MOD(MIM1,MIM2,MIM3,MIM4)
      MIM3 = MOD(MIM1**MIM2,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1269
      MIM2 = 31
      MIM3 = 147
      MIM4 = POWER_MOD(MIM1,MIM2,MIM3)
      MIM3 = MOD(MIM1**MIM2,MIM3)
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)
      CALL IM_ST2M('-602',MIM2)

      NCASE = 1270
      CALL IM_SQR(MIM1,MIM4)
      MIM3 = MIM1*MIM1
      IF (.NOT.(MIM3 == MIM4)) CALL PRTERR(KW)

      NCASE = 1271
      MZM3 = MZM1 + 123
      MZM4 = MZM1
      CALL ZM_ADDI(MZM4,123)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1272
      MFM3 = ATAN2(AIMAG(MZM1),REAL(MZM1))
      CALL ZM_ARG(MZM1,MFM4)
      IF (.NOT.(MFM3 == MFM4)) CALL PRTERR(KW)

      NCASE = 1273
      CALL ZM_COSH_SINH(MZM1,MZM4,MZM3)
      MZM3 = COSH(MZM1)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1274
      CALL ZM_COSH_SINH(MZM1,MZM3,MZM4)
      MZM3 = SINH(MZM1)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1275
      CALL ZM_COS_SIN(MZM1,MZM4,MZM3)
      MZM3 = COS(MZM1)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1276
      CALL ZM_COS_SIN(MZM1,MZM3,MZM4)
      MZM3 = SIN(MZM1)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1277
      CALL ZM_FORM('F35.26','F35.26',MZM1,STRING)
      CALL ZM_ST2M(STRING(1:75),MZM4)
      IF (ABS((MZM1-MZM4)/MZM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1278
      STRING = ZM_FORMAT('F35.26','F35.26',MZM1)
      CALL ZM_ST2M(STRING(1:75),MZM4)
      IF (ABS((MZM1-MZM4)/MZM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1279
      MZM3 = TO_ZM('123-456i')
      CALL ZM_2I2M(123,-456,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1280
      MZM3 = MZM1 ** 123
      CALL ZM_IPOWER(MZM1,123,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1281
      J4 = MZM1
      CALL ZM_M2I(MZM1,J5)
      IF (J4 /= J5) CALL PRTERR(KW)

      NCASE = 1282
      C4 = MZM1
      CALL ZM_M2Z(MZM1,C5)
      IF (ABS((C4-C5)/C4) > RSMALL) CALL PRTERR(KW)

      NCASE = 1283
      MZM3 = MZM1 * 123
      CALL ZM_MPYI(MZM1,123,MZM4)
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1284
      MZM3 = MZM1 ** (TO_ZM(1)/TO_ZM(3))
      CALL ZM_RATIONAL_POWER(MZM1,1,3,MZM4)
      IF (ABS((MZM3-MZM4)/MZM4) > MSMALL) CALL PRTERR(KW)

      NCASE = 1285
      CALL ZM_SQR(MZM1,MZM4)
      MZM3 = MZM1*MZM1
      IF (.NOT.(MZM3 == MZM4)) CALL PRTERR(KW)

      NCASE = 1286
      MZM3 = C2
      CALL ZM_Z2M(C2,MZM4)
      IF (ABS((MZM3-MZM4)/MZM3) > RSMALL) CALL PRTERR(KW)

      END SUBROUTINE TEST42

      SUBROUTINE TEST43

!  Test Bernoulli numbers, Pochhammer's function, Euler's constant.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing Bernoulli, Pochhammer, Euler.')")

      NCASE = 1287
      M_A = 1
      CALL FM_BERN(10,M_A,M_C)
      M_D = TO_FM('7.5757575757575757575757575757575757575757575757575758M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1288
      M_A = 1
      CALL FM_BERN(0,M_A,M_C)
      M_D = TO_FM('1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1289
      M_A = 1
      CALL FM_BERN(1,M_A,M_C)
      M_D = TO_FM('-0.5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1290
      M_A = 1
      CALL FM_BERN(41,M_A,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1291
      M_A = 0
      CALL FM_BERN(52,M_A,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1292
      M_A = TO_FM('.7699115044247787610619469026548672566371681415929204')
      CALL FM_BERN(102,M_A,M_C)
      M_D = TO_FM('5.7022917356035929245914353639470138260075545712953255M+80')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1293
      M_A = TO_FM('.7699115044247787610619469026548672566371681415929204')
      CALL FM_BERN(76,M_A,M_C)
      M_D = TO_FM('-6.3274121765674850311763600458139008604123253720098077M+50')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1294
      CALL FM_BERNOULLI(76,M_C)
      M_D = TO_FM('-8.2183629419784575692290653468617333014550892762886003M+50')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1295
      M_C = BERNOULLI(278)
      M_D = TO_FM('5.4809571213188766395120969944139922843271762639028329M+338')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1296
      M_C = BERNOULLI(10**5)
      M_D = TO_FM('-5.8222943146133508236497045360612887555320691004307968525M+376755')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1297
      M_A = TO_FM('.7699115044247787610619469026548672566371681415929204')
      M_C = BERNOULLI(76)*M_A
      M_D = TO_FM('-6.3274121765674850311763600458139008604123253720098077M+50')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1298
      M_A = 76
      M_C = BERNOULLI_FM1(76)
      M_D = TO_FM('-8.218362941978457569229065346861733301455089276288600333M+50')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1299
      M_A = 78
      M_C = BERNOULLI_FM2(78)
      M_D = TO_FM('1.250290432716699301673233982970289552417719636444847750M+53')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1300
      M_A = 80
      M_C = BERNOULLI_IM1(80)
      M_D = TO_FM('-2.001558323324837027492532919881329876872422013282591592M+55')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1301
      M_A = 82
      M_C = BERNOULLI_IM2(82)
      M_D = TO_FM('3.367498291536437423339667690333875301621959894719384367M+57')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1302
      M_A = 84
      M_C = BERNOULLI_ZM1(84)
      M_D = TO_FM('-5.947097050313544771866049684405154084057907156510690499M+59')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1303
      M_A = 86
      M_C = BERNOULLI_ZM2(86)
      M_D = TO_FM('1.101191032362797755956413079043769160463051144422314886M+62')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BERN ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1304
      M_A = TO_FM('769.9115044247787610619469026548672566371681415929204')
      CALL FM_POCH(M_A,10,M_C)
      M_D = TO_FM('7.7568981408767238023000514593534249181767332686451635M+28')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1305
      M_A = TO_FM('7699.115044247787610619469026548672566371681415929204')
      CALL FM_POCH(M_A,2222,M_C)
      M_D = TO_FM('1.330632198579290013040965245531889745992136035131794M+8763')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1306
      M_A = TO_FM('-7')
      CALL FM_POCH(M_A,12,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1307
      M_A = TO_FM('7.7568981408767238023000514593534249181767332686451635M+281')
      CALL FM_POCH(M_A,6,M_C)
      M_D = TO_FM('2.178354371001981973863113631260449017724481835653894M+1691')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1308
      M_A = TO_FM('7.7568981408767238023000514593534249181767332686451635M-281')
      CALL FM_POCH(M_A,8,M_C)
      M_D = TO_FM('3.9094766630018687963592259355141261587610735673971624M-277')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1309
      M_A = TO_FM('7.7568981408767238023000514593534249181767332686451635M-281')
      CALL FM_POCH(M_A,1,M_C)
      M_D = TO_FM('7.7568981408767238023000514593534249181767332686451635M-281')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1310
      M_A = TO_FM('7.7568981408767238023000514593534249181767332686451635M-281')
      CALL FM_POCH(M_A,0,M_C)
      M_D = TO_FM('1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1311
      M_A = TO_FM('0')
      CALL FM_POCH(M_A,8,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1312
      M_A = TO_FM('769.9115044247787610619469026548672566371681415929204')
      M_C = POCHHAMMER(M_A,10)
      M_D = TO_FM('7.7568981408767238023000514593534249181767332686451635M+28')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' POCH ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1313
      CALL FM_EULER(M_C)
      M_D = TO_FM('.5772156649015328606065120900824024310421593359399236')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' EULER',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1314
      CALL FMEULER(M_C%MFM)
      M_D = TO_FM('.5772156649015328606065120900824024310421593359399236')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' EULER',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1315
      NDGSAV = NDIG
      NDIG = INT(1785*DLOGTN/DLOGMB)+2
      CALL FM_EULER(M_C)
      M_D = TO_FM(  &
      '.5772156649015328606065120900824024310421593359399235988057672348848'// &
      '67726777664670936947063291746749514631447249807082480960504014486542'// &
      '83622417399764492353625350033374293733773767394279259525824709491600'// &
      '87352039481656708532331517766115286211995015079847937450857057400299'// &
      '21354786146694029604325421519058775535267331399254012967420513754139'// &
      '54911168510280798423487758720503843109399736137255306088933126760017'// &
      '24795378367592713515772261027349291394079843010341777177808815495706'// &
      '61075010161916633401522789358679654972520362128792265559536696281763'// &
      '88792726801324310104765059637039473949576389065729679296010090151251'// &
      '95950922243501409349871228247949747195646976318506676129063811051824'// &
      '19744486783638086174945516989279230187739107294578155431600500218284'// &
      '40960537724342032854783670151773943987003023703395183286900015581939'// &
      '88042707411542227819716523011073565833967348717650491941812300040654'// &
      '69314299929777956930310050308630341856980323108369164002589297089098'// &
      '54868257773642882539549258736295961332985747393023734388470703702844'// &
      '12920166417850248733379080562754998434590761643167103146710722370021'// &
      '81074504441866475913480366902553245862544222534518138791243457350136'// &
      '12977822782881489459098638460062931694718871495875254923664935204732'// &
      '43641097268276160877595088095126208404544477992299157248292516251278'// &
      '42765965708321461029821461795195795909592270420898962797125536321794'// &
      '88737642106606070659825619901028807561251991375116782176436190570584'// &
      '40783573501580056077457934213144988500786415171615194565706170432450'// &
      '75008168705230789093704614306684817916496842549150496724312183783875'// &
      '35648949508684541023406016225085155838672349441878804409407701068837'// &
      '95111307872023426395226920971608856908382511378712836820491178925944'// &
      '78486199118529391029309905925526691727446892044386971114717457157457'// &
      '3203935209122316085086828')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= MAX(TO_FM('1.0E-1785'),10*EPSILON(M_C)))) THEN
          CALL ERRPRT_FM(' EULER',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      NDIG = NDGSAV

      RETURN
      END SUBROUTINE TEST43

      FUNCTION BERNOULLI_FM1(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_FM1
      TYPE (FM), ALLOCATABLE :: T(:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_FM1)
      ALLOCATE(T( -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_FM1.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(-1:0) = 2
      T(1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 2 , J/2
            T(K) = T(K-1) + T(K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 - 1 , -J/2 , -1
            T(K) = T(K+1) + T(K)
         ENDDO
      ENDDO
      T(0) = TO_FM(2)**N
      BERNOULLI_FM1 = (-1)**(N/2) * ( N / ( T(0) - T(0)**2 ) ) * T(-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_FM1)
      END FUNCTION BERNOULLI_FM1

      FUNCTION BERNOULLI_FM2(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_FM2
      TYPE (FM), ALLOCATABLE :: T(:,:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_FM2)
      ALLOCATE(T( 2 , -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_FM2.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(1,-1:0) = 2
      T(1,1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 1 , J/2
            T(2,K) = T(2,K-1) + T(1,K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 , -J/2 , -1
            T(1,K) = T(1,K+1) + T(2,K)
         ENDDO
      ENDDO
      T(1,0) = TO_FM(2)**N
      BERNOULLI_FM2 = (-1)**(N/2) * ( N / ( T(1,0) - T(1,0)**2 ) ) * T(1,-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_FM2)
      END FUNCTION BERNOULLI_FM2

      FUNCTION BERNOULLI_IM1(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_IM1
      TYPE (IM), ALLOCATABLE :: T(:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_IM1)
      ALLOCATE(T( -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_IM1.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(-1:0) = 2
      T(1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 2 , J/2
            T(K) = T(K-1) + T(K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 - 1 , -J/2 , -1
            T(K) = T(K+1) + T(K)
         ENDDO
      ENDDO
      T(0) = TO_FM(2)**N
      BERNOULLI_IM1 = (-1)**(N/2) * ( TO_FM(N) / ( T(0) - T(0)**2 ) ) * T(-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_IM1)
      END FUNCTION BERNOULLI_IM1

      FUNCTION BERNOULLI_IM2(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_IM2
      TYPE (IM), ALLOCATABLE :: T(:,:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_IM2)
      ALLOCATE(T( 2 , -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_IM2.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(1,-1:0) = 2
      T(1,1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 1 , J/2
            T(2,K) = T(2,K-1) + T(1,K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 , -J/2 , -1
            T(1,K) = T(1,K+1) + T(2,K)
         ENDDO
      ENDDO
      T(1,0) = TO_FM(2)**N
      BERNOULLI_IM2 = (-1)**(N/2) * ( TO_FM(N) / ( T(1,0) - T(1,0)**2 ) ) * T(1,-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_IM2)
      END FUNCTION BERNOULLI_IM2

      FUNCTION BERNOULLI_ZM1(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_ZM1
      TYPE (ZM), ALLOCATABLE :: T(:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_ZM1)
      ALLOCATE(T( -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_ZM1.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(-1:0) = 2
      T(1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 2 , J/2
            T(K) = T(K-1) + T(K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 - 1 , -J/2 , -1
            T(K) = T(K+1) + T(K)
         ENDDO
      ENDDO
      T(0) = TO_FM(2)**N
      BERNOULLI_ZM1 = (-1)**(N/2) * ( TO_FM(N) / ( T(0) - T(0)**2 ) ) * T(-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_ZM1)
      END FUNCTION BERNOULLI_ZM1

      FUNCTION BERNOULLI_ZM2(N)

!  Seidel's recurrence for T(n).
!  This uses only addition of integers.
!  B(n) = (-1)^(n/2) ( n / ( 2^n - 4^n ) ) T(n)

      USE FMZM
      IMPLICIT NONE
      INTEGER :: J,K,N
      TYPE (FM) :: BERNOULLI_ZM2
      TYPE (ZM), ALLOCATABLE :: T(:,:)
      CALL FM_ENTER_USER_FUNCTION(BERNOULLI_ZM2)
      ALLOCATE(T( 2 , -N/2 : N/2 ),STAT=J)
      IF (J /= 0) THEN
          WRITE (*,"(/' Error in BERNOULLI_ZM2.  Unable to allocate T with size ',I8/)") N
          STOP
      ENDIF

!             Initialize.

      T = 0
      T(1,-1:0) = 2
      T(1,1) = 1

!             Recurrence.

      DO J = 5, N, 2

!             Row J of the table is filled left to right.

         DO K = -J/2 + 1 , J/2
            T(2,K) = T(2,K-1) + T(1,K)
         ENDDO

!             Row J+1 of the table is filled right to left.

         DO K = J/2 , -J/2 , -1
            T(1,K) = T(1,K+1) + T(2,K)
         ENDDO
      ENDDO
      T(1,0) = TO_FM(2)**N
      BERNOULLI_ZM2 = (-1)**(N/2) * ( TO_FM(N) / ( T(1,0) - T(1,0)**2 ) ) * T(1,-N/2+1)
      CALL FM_DEALLOCATE(T)
      DEALLOCATE(T)
      CALL FM_EXIT_USER_FUNCTION(BERNOULLI_ZM2)
      END FUNCTION BERNOULLI_ZM2

      SUBROUTINE TEST44

!  Test Gamma, Factorial, Log(Gamma), Beta, Binomial.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing Gamma, Factorial, Log(Gamma), Beta, Binomial.')")

      NCASE = 1316
      M_A = 19
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('6.402373705728M+15')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1317
      M_A = TO_FM('.7699115044247787610619469026548672566371681415929204')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('1.1998023858495967876496039855917100290498970370440326')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1318
      M_A = TO_FM('-.7699115044247787610619469026548672566371681415929204')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('-5.14110071322331700055471385717142758748739973201063050214')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1319
      M_A = TO_FM('5.7699115044247787610619469026548672566371681415929204')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('8.1434691207877806133071511233406796488474685081500979M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1320
      M_A = TO_FM('7.7568981408767238023000514593534249181767332686451635M-281')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('1.2891751081921193691625844770542239587773115818085396M+280')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1321
      M_A = TO_FM('2')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1322
      M_A = TO_FM('5.7699115044247787610619469026548672566371681415929204')
      M_C = GAMMA(M_A)
      M_D = TO_FM('8.1434691207877806133071511233406796488474685081500979M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1323
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = GAMMA(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == GAMMA(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1324
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = GAMMA(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == GAMMA(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1325
      M_A = 33
      CALL FM_FACT(M_A,M_C)
      M_D = TO_FM('8.68331761881188649551819440128M+36')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' FACT ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1326
      M_A = TO_FM('769.9115044247787610619469026548672566371681415929204')
      CALL FM_FACT(M_A,M_C)
      M_D = TO_FM('5.998259003357134762219307127916529472560301341339449M+1889')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' FACT ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1327
      M_A = TO_FM('769.9115044247787610619469026548672566371681415929204')
      M_C = FACTORIAL(M_A)
      M_D = TO_FM('5.998259003357134762219307127916529472560301341339449M+1889')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' FACT ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1328
      CALL IMFACT(0,MA)
      CALL IMI2M(1,MC)
      IF (.NOT.IMCOMP(MA,'EQ',MC)) THEN
          CALL ERRPRTIM('IMFACT',MA,'MA',MC,'MC')
      ENDIF

      NCASE = 1329
      CALL IM_FACT(7,M_J)
      CALL IM_I2M(5040,M_K)
      IF (.NOT.(M_J == M_K)) THEN
          CALL ERRPRT_IM('IM_FACT',M_J,'M_J',M_K,'M_K')
      ENDIF

      NCASE = 1330
      CALL IM_FACT(12,M_J)
      CALL IM_I2M(479001600,M_K)
      IF (.NOT.(M_J == M_K)) THEN
          CALL ERRPRT_IM('IM_FACT',M_J,'M_J',M_K,'M_K')
      ENDIF

      NCASE = 1331
      M_J = FACTORIAL(50)
      M_K = TO_IM('30414093201713378043612608166064768844377641568960512000000000000')
      IF (.NOT.(M_J == M_K)) THEN
          CALL ERRPRT_IM(' FACT ',M_J,'M_J',M_K,'M_K')
      ENDIF

      NCASE = 1332
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = FACTORIAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == FACTORIAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1333
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = FACTORIAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == FACTORIAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1334
      M_J = 56
      M_J = FACTORIAL(M_J)
      M_K = TO_IM('710998587804863451854045647463724949736497978881168458687447040000000000000')
      IF (.NOT.(M_J == M_K)) THEN
          CALL ERRPRT_IM(' FACT ',M_J,'M_J',M_K,'M_K')
      ENDIF

      NCASE = 1335
      MIMV1 = TO_IM( (/ 12 , 123 , 456 /) )
      MIMV2 = FACTORIAL(MIMV1)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == FACTORIAL(MIMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1336
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_IM(25+31*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMB2 = FACTORIAL(MIMA2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == FACTORIAL(MIMA2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1337
      JV = (/ 12 , 123 , 456 /)
      MIMV2 = FACTORIAL(JV)
      DO J = 1, 3
         IF (.NOT.(MIMV2(J) == FACTORIAL(JV(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1338
      DO J = 1, 3
         DO K = 1, 3
            JV2(J,K) = 25+31*(J+3*(K-1))
         ENDDO
      ENDDO
      MIMB2 = FACTORIAL(JV2)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MIMB2(J,K) == FACTORIAL(JV2(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1339
      M_A = TO_FM('1.0M-222')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('5.1117389064467814185199410293992885408744453047558760M+2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' LNGM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1340
      M_A = TO_FM('2')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' LNGM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1341
      M_A = TO_FM('33')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('8.1557959456115037178502968666011206687099284403417368M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' LNGM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1342
      M_A = TO_FM('2.00000000000000000001')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('4.2278433509846713939671258025183870114019600466320121M-21')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' LNGM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1343
      M_C = LOG_GAMMA(TO_FM('33'))
      M_D = TO_FM('8.1557959456115037178502968666011206687099284403417368M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' LNGM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1344
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = LOG_GAMMA(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == LOG_GAMMA(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1345
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = LOG_GAMMA(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == LOG_GAMMA(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 1346
      M_A = TO_FM('2.0706137739520290320140007735608464643737932737070189M-223')
      M_B = TO_FM('.78')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('4.8294858876137637017880452468052846823385248996130407M+222')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1347
      M_A = TO_FM('.78')
      M_B = TO_FM('2.0706137739520290320140007735608464643737932737070189M-223')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('4.8294858876137637017880452468052846823385248996130407M+222')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1348
      M_A = TO_FM('-4.5')
      M_B = TO_FM('4.5')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1349
      M_A = TO_FM('-5.5')
      M_B = TO_FM('4.5')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1350
      M_A = TO_FM('10')
      M_B = TO_FM('4')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('3.4965034965034965034965034965034965034965034965034965M-4')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1351
      M_A = TO_FM('1.0M+1234')
      M_B = TO_FM('2.2')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('1.746239267231954787655429292265211001580693244013921M-2715')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1352
      M_A = TO_FM('10')
      M_B = TO_FM('5.3')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('7.0836036771097107530120640698518155187687458162734679M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1353
      M_A = TO_FM('10.3')
      M_B = TO_FM('5')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('8.8146035423244390793072072569173028531206477712519934M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1354
      M_A = TO_FM('10.3')
      M_B = TO_FM('5')
      M_C = BETA(M_A,M_B)
      M_D = TO_FM('8.8146035423244390793072072569173028531206477712519934M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1355
      M_A = TO_FM('12.5')
      M_B = TO_FM('0')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1356
      M_A = TO_FM('5')
      M_B = TO_FM('-2')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1357
      M_A = TO_FM('12.5')
      M_B = TO_FM('12.5')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1358
      M_A = TO_FM('-4.5')
      M_B = TO_FM('4.5')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1359
      M_A = TO_FM('-4.5')
      M_B = TO_FM('4.5')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1360
      M_A = TO_FM('-10')
      M_B = TO_FM('3')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('-220')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1361
      M_A = TO_FM('52')
      M_B = TO_FM('5')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('2.59896M+6')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1362
      M_A = TO_FM('1.0M+1234')
      M_B = TO_FM('7')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('1.984126984126984126984126984126984126984126984126984M+8634')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1363
      M_A = TO_FM('1.0M+123')
      M_B = TO_FM('2.2')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('1.6423797032130683531106846289429264567307029528308099M+270')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1364
      M_A = TO_FM('1.0M-100')
      M_B = TO_FM('4')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('-2.5M-101')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1365
      M_A = TO_FM('1.0M+123')
      M_B = TO_FM('2.2')
      M_C = BINOMIAL(M_A,M_B)
      M_D = TO_FM('1.6423797032130683531106846289429264567307029528308099M+270')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' COMB ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST44

      END MODULE TEST_B


      MODULE TEST_C
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST45

!  Test Incomplete Gamma, Incomplete Beta.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing Incomplete Gamma, Incomplete Beta.')")

      NCASE = 1366
      M_A = TO_FM('2.0706137739520290320140007735608464643737932737070189M-145')
      M_B = TO_FM('.34')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('4.8294858876137637017880452468052846823385248996130407M+144')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1367
      M_A = TO_FM('1.0E-50')
      M_B = TO_FM('1.0E+555')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('9.9999999999999999999999999999999999999999999999999423M+49')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1368
      M_A = TO_FM('1.2')
      M_B = TO_FM('2.3')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('7.9163089830797686672658085698101181778608009481363580M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1369
      M_A = TO_FM('23.4')
      M_B = TO_FM('456.7')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('3.9191215305400046110416169991395759293572844563673750M+21')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1370
      M_A = TO_FM('1.2')
      M_B = TO_FM('0')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1371
      M_A = TO_FM('-1234.5')
      M_B = TO_FM('3.4')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('-2.089243913181003055673082477964338279776719826973623M-661')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1372
      M_A = TO_FM('10.3')
      M_B = TO_FM('230.7')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('7.1643068906237524454762965471616445342244699109269471M+5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1373
      M_A = TO_FM('1.2')
      M_B = TO_FM('2.3')
      M_C = INCOMPLETE_GAMMA1(M_A,M_B)
      M_D = TO_FM('7.9163089830797686672658085698101181778608009481363580M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM1 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1374
      M_A = TO_FM('0')
      M_B = TO_FM('4.5')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('2.0734007547146144328855938695797884889319725701443004M-3')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1375
      M_A = TO_FM('4.5')
      M_B = TO_FM('0')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('1.1631728396567448929144224109426265262108918305803166M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1376
      M_A = TO_FM('1.2')
      M_B = TO_FM('2.3')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('1.2653784409178374391437079820481858290074190484504480M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1377
      M_A = TO_FM('3.4')
      M_B = TO_FM('456.7')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('1.1043526800164195407100289367720949121507981651704628M-192')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1378
      M_A = TO_FM('1.0E-30')
      M_B = TO_FM('40.7')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('5.0619447546123889551107110735110897294460083487536391M-20')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1379
      M_A = TO_FM('-8000.3')
      M_B = TO_FM('1.0e-10')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('1.24995312663273564605221746530224928996650914518900M+79999')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1380
      M_A = TO_FM('1')
      M_B = TO_FM('-10.7')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('4.4355855130297866938628363428602120081387560278336788M+4')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1381
      M_A = TO_FM('1.2')
      M_B = TO_FM('2.3')
      M_C = INCOMPLETE_GAMMA2(M_A,M_B)
      M_D = TO_FM('1.2653784409178374391437079820481858290074190484504480M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IGM2 ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1382
      M_A = TO_FM('0.1')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('5.8731980918960730463350151650813268739874201571164800M-27')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1383
      M_A = TO_FM('8.115640517330775M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.0112520048150164306467955877563719782378767062440103M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1384
      M_A = TO_FM('9.01737835258975M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.2512248738228585976753517954889151150428002974819213M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1385
      M_A = TO_FM('9.6097615596216720E-01')
      M_B = TO_FM('1.970425178583792')
      M_C = TO_FM('5.5680052333367')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.8619456987740165364092968281459448023932520843535423M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1386
      M_A = TO_FM('4.764360371097952E-01')
      M_B = TO_FM('1.161514683661584E+01')
      M_C = TO_FM('2.937801562768354E-01')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.3604503996731113868791517339909092506365724801689105M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1387
      M_A = TO_FM('0.9')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('7.3148127865937299821246829407023943740949130742928268M-18')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1388
      M_A = TO_FM('9.99496253868099M-1')
      M_B = TO_FM('2.47067979368109M+6')
      M_C = TO_FM('6.09475681774953M-100')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('1.7681753021411259894614747665450637683755190050365931M-544')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1389
      M_A = TO_FM('6.213433771653724M-1')
      M_B = TO_FM('8.854622686031200M-1')
      M_C = TO_FM('5.00000854049816M-121')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('1.1281271573737080091147788530326864610276172049831497M+0')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1390
      M_A = TO_FM('5.304391676698501M-15')
      M_B = TO_FM('4.870186358377400M+2')
      M_C = TO_FM('4.999955247889730M-98')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('8.789231448295684789660412810680366252747943306875046M-6956')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1391
      M_A = TO_FM('1.882803169800314M-7')
      M_B = TO_FM('1.591547060066600M-169')
      M_C = TO_FM('3.521822614438970M+6')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('6.2831946669434576663925763649227277100409122269443137M+168')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1392
      M_A = TO_FM('.9999999999999')
      M_B = TO_FM('8.591098092677430M+2')
      M_C = TO_FM('1.863210949748253M+1')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('3.9062929191651064065641350979581425238442928803700306M-40')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1393
      M_A = TO_FM('2.531772074701081M-99')
      M_B = TO_FM('3.547571261801072M+2')
      M_C = TO_FM('1.974896958876250M+6')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('4.09572371031661966931910120566898398359503771147050M-34981')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1394
      M_A = TO_FM('.99999999999999')
      M_B = TO_FM('1.0E-123')
      M_C = TO_FM('1.0E-134')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('1.0M+123')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1395
      M_A = TO_FM('1')
      M_B = TO_FM('2.65')
      M_C = TO_FM('4.88')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('1.5020204575152306127604878970920601604169827852591720M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1396
      M_A = TO_FM('0')
      M_B = TO_FM('2.65')
      M_C = TO_FM('4.88')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('0')
      M_D = ABS(M_C - M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1397
      M_A = TO_FM('.998')
      M_B = TO_FM('759.6')
      M_C = TO_FM('4.95e-57')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('9.7133692099062434492386763673434080317019087637060970M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1398
      M_A = TO_FM('4.764360371097952E-01')
      M_B = TO_FM('1.161514683661584E+01')
      M_C = TO_FM('2.937801562768354E-01')
      M_C = INCOMPLETE_BETA(M_A,M_B,M_C)
      M_D = TO_FM('2.3604503996731113868791517339909092506365724801689105M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST45

      SUBROUTINE TEST46

!  Test the Polygamma, Psi functions.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing Polygamma, Psi.')")

      NCASE = 1399
      M_A = TO_FM('4.5')
      CALL FM_PGAM(0,M_A,M_C)
      M_D = TO_FM('1.3888709263595289015114046193821968137592213477205183M+0')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1400
      M_A = TO_FM('1.0E-123')
      CALL FM_PGAM(1,M_A,M_C)
      M_D = TO_FM('1.0M+246')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1401
      M_A = TO_FM('1.0E-123')
      CALL FM_PGAM(2,M_A,M_C)
      M_D = TO_FM('-2.0M+369')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1402
      M_A = TO_FM('2.0706137739520290320140007735608464643737932737070189M-1')
      CALL FM_PGAM(1,M_A,M_C)
      M_D = TO_FM('2.4580954480899934124966756607870377560864828849100481M+1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1403
      M_A = TO_FM('2.0706137739520290320140007735608464643737932737070189M-1')
      CALL FM_PGAM(6,M_A,M_C)
      M_D = TO_FM('-4.4120531379423056741117517146346730469682094212273241M+7')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1404
      M_A = TO_FM('2.0706137739520290320140007735608464643737932737070189M-1')
      CALL FM_PGAM(23,M_A,M_C)
      M_D = TO_FM('6.7006365293376930742991440911935017694098601683947073M+38')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1405
      M_A = TO_FM('1.0E+123')
      CALL FM_PGAM(4,M_A,M_C)
      M_D = TO_FM('-6.0M-492')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1406
      M_A = TO_FM('-6.499999840238790109')
      CALL FM_PGAM(4,M_A,M_C)
      M_D = TO_FM('1.0135142464863270830609416082237513111216512170936928M-16')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1407
      M_C = POLYGAMMA(2,TO_FM('1.0E-123'))
      M_D = TO_FM('-2.0M+369')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PGAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1408
      M_A = TO_FM('1.0E-135')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('-1.0M+135')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1409
      M_A = TO_FM('1.2')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('-2.8903989659218829554720796244995210482558827420664281M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1410
      M_A = TO_FM('-3.4')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('2.3844508141180140670320531380285019520468887144980679M+0')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1411
      M_A = TO_FM('57')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('4.0342536898816977739559850955847848905386809772893269M+0')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1412
      M_A = TO_FM('1.0E+56')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('1.2894476520766655830500752146232439562566168336321129M+2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1413
      M_A = TO_FM('1.0')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('-5.7721566490153286060651209008240243104215933593992360M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1414
      M_A = TO_FM('1.0E+23456')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('5.4009435941268335564326007561076446853491436517276499M+4')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1415
      M_A = TO_FM('1.46163214496836234126266')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('4.4287869692570149446165609601581442013784186419176534M-25')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1416
      M_C = PSI(TO_FM('1.2'))
      M_D = TO_FM('-2.8903989659218829554720796244995210482558827420664281M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' PSI  ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1417
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = PSI(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == PSI(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 1418
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = PSI(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == PSI(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      RETURN
      END SUBROUTINE TEST46

      SUBROUTINE TEST47

!  Test the different rounding modes.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing the different rounding modes.')")

      CALL FMSETVAR(' MBASE = 10 ')
      CALL FMSETVAR(' NDIG = 20 ')
      M_A = 0

      NCASE = 1419
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('2')/TO_FM('3')
      M_D = TO_FM('.66666666666666666667')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1420
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('2')/TO_FM('3')
      M_D = TO_FM('.66666666666666666666')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1421
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('2')/TO_FM('3')
      M_D = TO_FM('.66666666666666666666')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1422
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('2')/TO_FM('3')
      M_D = TO_FM('.66666666666666666667')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1423
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('1')/TO_FM('3')
      M_D = TO_FM('.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1424
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('1')/TO_FM('3')
      M_D = TO_FM('.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1425
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('1')/TO_FM('3')
      M_D = TO_FM('.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1426
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('1')/TO_FM('3')
      M_D = TO_FM('.33333333333333333334')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1427
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('-1')/TO_FM('3')
      M_D = TO_FM('-.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1428
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('-1')/TO_FM('3')
      M_D = TO_FM('-.33333333333333333334')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1429
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('-1')/TO_FM('3')
      M_D = TO_FM('-.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1430
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('-1')/TO_FM('3')
      M_D = TO_FM('-.33333333333333333333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1431
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('-2')/TO_FM('3')
      M_D = TO_FM('-.66666666666666666667')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1432
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('-2')/TO_FM('3')
      M_D = TO_FM('-.66666666666666666667')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1433
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('-2')/TO_FM('3')
      M_D = TO_FM('-.66666666666666666666')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1434
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('-2')/TO_FM('3')
      M_D = TO_FM('-.66666666666666666666')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1435
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('1') + TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1436
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('1') + TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1437
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('1') + TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1438
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('1') + TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1439
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('1') - TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1440
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('1') - TO_FM('3E-555')
      M_D = TO_FM('.99999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1441
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('1') - TO_FM('3E-555')
      M_D = TO_FM('.99999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1442
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('1') - TO_FM('3E-555')
      M_D = TO_FM('1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1443
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('-1') + TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1444
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('-1') + TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1445
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('-1') + TO_FM('3E-555')
      M_D = TO_FM('-.99999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1446
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('-1') + TO_FM('3E-555')
      M_D = TO_FM('-.99999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1447
      CALL FMSETVAR(' KROUND = 1 ')
      M_C = TO_FM('-1') - TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1448
      CALL FMSETVAR(' KROUND = -1 ')
      M_C = TO_FM('-1') - TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1449
      CALL FMSETVAR(' KROUND = 0 ')
      M_C = TO_FM('-1') - TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1450
      CALL FMSETVAR(' KROUND = 2 ')
      M_C = TO_FM('-1') - TO_FM('3E-555')
      M_D = TO_FM('-1.0000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' MBASE = 2 ')
      CALL FMSETVAR(' NDIG = 53 ')
      CALL FMSETVAR(' KROUND = 1 ')
      NCASE = 1451
      M_A = TO_FM('0.125')
      M_B = TO_FM('23.25')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('6.1345805065305141873M-25')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1452
      M_A = TO_FM('0.52')
      M_B = TO_FM('2.01')
      M_C = TO_FM('1.6')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('1.0304844627978347604M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1453
      M_A = TO_FM('9.01737835258975M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.2512248738228585986M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1454
      M_A = TO_FM('9.6097615596216720E-01')
      M_B = TO_FM('1.970425178583792')
      M_C = TO_FM('5.5680052333367')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.8619456987740165927M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1455
      M_A = TO_FM('4.764360371097952E-01')
      M_B = TO_FM('1.161514683661584E+01')
      M_C = TO_FM('2.937801562768354E-01')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.3604503996731113869M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1456
      M_A = TO_FM('0.9')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('7.3148127865937395334M-18')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-15'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL FMSETVAR(' MBASE = 3 ')
      CALL FMSETVAR(' NDIG = 55 ')
      NCASE = 1457
      M_A = TO_FM('0.1')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('5.87319809189607304633501593392681M-27')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1458
      M_A = TO_FM('0.52')
      M_B = TO_FM('2.1')
      M_C = TO_FM('1.6')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('9.25745341552810210762563659429375M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1459
      M_A = TO_FM('9.01737835258975M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.25122487382285859767535178829535M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1460
      M_A = TO_FM('9.6097615596216720E-01')
      M_B = TO_FM('1.970425178583792')
      M_C = TO_FM('5.5680052333367')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.861945698774016536409296855493M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1461
      M_A = TO_FM('4.764360371097952E-01')
      M_B = TO_FM('1.161514683661584E+01')
      M_C = TO_FM('2.937801562768354E-01')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.36045039967311138687915158221269M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1462
      M_A = TO_FM('0.9')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('7.31481278659372998212468429642039M-18')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1463
      CALL FPST2M('1.67',MP1)
      CALL FPST2M('2.64',MP2)
      CALL FPADD(MP1,MP2,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPST2M('-3.91',MP2)
      CALL FPSUB(MP1,MP2,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPST2M('4.58',MP2)
      CALL FPMPY(MP1,MP2,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPST2M('0.27',MP2)
      CALL FPDIV(MP1,MP2,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPADDI(MP1,2)
      CALL FPMPYI(MP1,13,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPDIVI(MP1,11,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPLN(MP1,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPSIN(MP1,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPCOS(MP1,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPEXP(MP1,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FPGAM(MP1,MP3)
      CALL FPEQ(MP3,MP1)
      CALL FMUNPK(MP1,M3FM)
      CALL FMEQ(M3FM,M_C%MFM)
      M_D = TO_FM('0.941122001974472326543759839200398')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-24'))) THEN
          CALL ERRPRT_FM(' Pack ',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1464
      CALL FM_RANDOM_SEED_SIZE(J)
      SEED = (/ 2718281,8284590,4523536,0287471,3526624,9775724,7093699 /)
      CALL FM_RANDOM_SEED_PUT(SEED)
      DO J1 = 1, 10
         CALL FM_RANDOM_NUMBER(D1)
      ENDDO
      CALL FM_RANDOM_SEED_GET(SEED)
      M_C = D1
      M_D = TO_FM('0.931628836663817')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-10')) .OR. .NOT.(J == 7)) THEN
          CALL ERRPRT_FM(' Rand ',M_C,'M_C',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST47

      SUBROUTINE TEST48

!  Test cases close to 1/2 ulp rounding error, so a retry is required for perfect rounding.
!  Some cases are also included for results close to a representable number, to check perfect
!  rounding in the other three rounding modes:  toward -infinity, toward zero, toward +infinity.

      IMPLICIT NONE

      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 10 ')
      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 1465
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000000001e-41')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768402')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1466
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999999e-41')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768401')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1467
      M_A = TO_FM('5.000000000000000000000000000000000000001e-37')
      M_C = M_A
      CALL FM_ADDI(M_C,2)
      M_D = TO_FM('2.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1468
      M_C = TO_FM('4.999999999999999999999999999999999999999e-37')
      CALL FM_ADDI(M_C,2)
      M_D = TO_FM('2.000000000000000000000000000000000000000')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1469
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000000001e-41')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768400')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1470
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999999e-41')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768401')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1471
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('0.5257635728213180166595247703159528791601')
      M_C = M_A * M_B
      M_D = TO_FM('0.3303469955801149926388139215009285936894')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1472
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('0.4742364271786819833404752296840471208399')
      M_C = M_A * M_B
      M_D = TO_FM('0.2979715351378436550537147551549719831507')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1473
      M_A = TO_FM('0.6318370867781348553996520736856019490561')
      CALL FM_MPYI(M_A,46101123,M_C)
      M_D = TO_FM('29128399.25352046867936657440618499878248')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1474
      M_A = TO_FM('0.8135122987796887463349472568784450350361')
      CALL FM_MPYI(M_A,20316759,M_C)
      M_D = TO_FM('16527933.31784293035429925669571046007157')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1475
      M_A = TO_FM('0.6318370867781348553996520736856019490561')
      CALL FM_MPYI_R1(M_A,46101123)
      M_C = M_A
      M_D = TO_FM('29128399.25352046867936657440618499878248')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1476
      M_A = TO_FM('0.8135122987796887463349472568784450350361')
      CALL FM_MPYI_R1(M_A,20316759)
      M_C = M_A
      M_D = TO_FM('16527933.31784293035429925669571046007157')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1477
      M_A = TO_FM('0.3976743471825143687216599350592794108215')
      M_B = TO_FM('0.9424777960769379715387930149838508652591')
      M_C = M_A / M_B
      M_D = TO_FM('0.4219455872995980174105705502942218606745')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1478
      M_A = TO_FM('0.6919325506063328369126062247898634980537')
      M_B = TO_FM('0.9424777960769379715387930149838508652591')
      M_C = M_A / M_B
      M_D = TO_FM('0.7341632381012059477682883491173344179766')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1479
      M_A = TO_FM('36461617.89732034137767779122871087621687')
      CALL FM_DIVI(M_A,63388493,M_C)
      M_D = TO_FM('.5752087827252864550302180433396780109108')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1480
      M_A = TO_FM('37124279.59189018208711544238998994234663')
      CALL FM_DIVI(M_A,75134789,M_C)
      M_D = TO_FM('.4941024003127257346409190340574449786054')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1481
      M_A = TO_FM('36461617.89732034137767779122871087621687')
      CALL FM_DIVI_R1(M_A,63388493)
      M_C = M_A
      M_D = TO_FM('.5752087827252864550302180433396780109108')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1482
      M_A = TO_FM('37124279.59189018208711544238998994234663')
      CALL FM_DIVI_R1(M_A,75134789)
      M_C = M_A
      M_D = TO_FM('.4941024003127257346409190340574449786054')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1483
      M_A = TO_FM('0.9999999999999999999999999999999999999999')
      M_C = SQRT(M_A)
      M_D = TO_FM('0.9999999999999999999999999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1484
      M_A = TO_FM('0.0812551668996974871345739579795687707841')
      M_C = SQRT(M_A)
      M_D = TO_FM('0.2850529194723279573072539887330984043228')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1485
      M_A = TO_FM('0.5985846996875529104874722961539082031432e-36')
      M_C = ACOS(M_A)
      M_D = TO_FM('1.570796326794896619231321691639751441')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1486
      M_A = TO_FM('0.5985846996875529104874722961539082031430e-36')
      M_C = ACOS(M_A)
      M_D = TO_FM('1.570796326794896619231321691639751442')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1487
      M_A = TO_FM('3.1072325059538588668776624275223863628e-19')
      M_C = ASIN(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1488
      M_A = TO_FM('3.1072325059538588668776624275223863629e-19')
      M_C = ASIN(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863630e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1489
      M_A = TO_FM('2.4662120743304701014916113231545890428e-19')
      M_C = ATAN(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1490
      M_A = TO_FM('2.4662120743304701014916113231545890427e-19')
      M_C = ATAN(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1491
      M_A = TO_FM('24.662120743304701014916113231545890428')
      M_B = TO_FM('1M+20')
      CALL FM_ATAN2(M_A,M_B,M_C)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1492
      M_A = TO_FM('24.662120743304701014916113231545890427')
      M_B = TO_FM('1M+20')
      CALL FM_ATAN2(M_A,M_B,M_C)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1493
      M_A = TO_FM('3.1072325059538588668776624275223863629e-19')
      M_C = SIN(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1494
      M_A = TO_FM('3.1072325059538588668776624275223863628e-19')
      M_C = SIN(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1495
      M_A = TO_FM('1.0e-20')
      M_C = COS(M_A)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1496
      M_A = TO_FM('1.000000000000000000000000000000000001e-20')
      M_C = COS(M_A)
      M_D = TO_FM('0.9999999999999999999999999999999999999999')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1497
      M_A = TO_FM('3.1072325059538588668776624275223863629e-19')
      CALL FM_CSSN(M_A,M_B,M_C)
      M_D = TO_FM('.9999999999999999999999999999999999999517')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1498
      M_A = TO_FM('3.1072325059538588668776624275223863628e-19')
      CALL FM_CSSN(M_A,M_B,M_C)
      M_D = TO_FM('.9999999999999999999999999999999999999517')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1499
      M_A = TO_FM('1.0e-20')
      CALL FM_CSSN(M_A,M_B,M_C)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('1.0e-20')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1500
      M_A = TO_FM('1.000000000000000000000000000000000001e-20')
      CALL FM_CSSN(M_A,M_B,M_C)
      M_D = TO_FM('0.9999999999999999999999999999999999999999')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('1.000000000000000000000000000000000001e-20')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1501
      M_A = TO_FM('3.1072325059538588668776624275223863629e-19')
      M_C = SINH(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863630e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1502
      M_A = TO_FM('3.1072325059538588668776624275223863628e-19')
      M_C = SINH(M_A)
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1503
      M_A = TO_FM('1.0e-18')
      M_C = COSH(M_A)
      M_D = TO_FM('1.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1504
      M_A = TO_FM('9.9999999999999999999999999999999999988e-19')
      M_C = COSH(M_A)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1505
      M_A = TO_FM('3.1072325059538588668776624275223863629e-19')
      CALL FM_CHSH(M_A,M_B,M_C)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('3.1072325059538588668776624275223863630e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1506
      M_A = TO_FM('3.1072325059538588668776624275223863628e-19')
      CALL FM_CHSH(M_A,M_B,M_C)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('3.1072325059538588668776624275223863628e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1507
      M_A = TO_FM('1.0e-18')
      CALL FM_CHSH(M_A,M_B,M_C)
      M_D = TO_FM('1.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('1.00000000000000000000000000000000000017e-18')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1508
      M_A = TO_FM('9.9999999999999999999999999999999999988e-19')
      CALL FM_CHSH(M_A,M_B,M_C)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_B)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_B,'M_B',M_D,'M_D')
      ENDIF
      M_D = TO_FM('1.00000000000000000000000000000000000005e-18')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1509
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000000001e-41')
      M_C = DIM(M_A,M_B)
      M_D = TO_FM('0.6283185307179586476925286766559005768400')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1510
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999999e-41')
      M_C = DIM(M_A,M_B)
      M_D = TO_FM('0.6283185307179586476925286766559005768401')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1511
      M_A = TO_FM('0.5e-36')
      M_C = EXP(M_A)
      M_D = TO_FM('1.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1512
      M_A = TO_FM('0.4999999999999999999999999999999999989999e-36')
      M_C = EXP(M_A)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1513
      M_A = TO_FM('1.0000000000000000000000000000000000005000000000000000000000000000000000001')
      M_C = M_A
      M_D = TO_FM('1.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1514
      M_A = TO_FM('1.000000000000000000000000000000000000499999999999999999999999999999999999999')
      M_C = M_A
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1515
      M_A = TO_FM('1.000000000000000000707106781186547524')
      M_C = M_A ** 2
      M_D = TO_FM('1.000000000000000001414213562373095048')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1516
      M_A = TO_FM('1.000000000000000000707106781186547525')
      M_C = M_A ** 2
      M_D = TO_FM('1.000000000000000001414213562373095051')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1517
      M_A = TO_FM('1.000000000000000000707106781186547524')
      CALL FM_SQR(M_A,M_C)
      M_D = TO_FM('1.000000000000000001414213562373095048')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1518
      M_A = TO_FM('1.000000000000000000707106781186547525')
      CALL FM_SQR(M_A,M_C)
      M_D = TO_FM('1.000000000000000001414213562373095051')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1519
      M_A = TO_FM('0.9999999999999999994067407863053487817742')
      M_C = LOG(M_A)
      M_D = TO_FM('-5.9325921369465121840177824731679791984e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1520
      M_A = TO_FM('0.9999999999999999993793990486547925547640')
      M_C = LOG(M_A)
      M_D = TO_FM('-6.2060095134520744542857277040528826945e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1521
      M_A = TO_FM('1.000000000000000000958662527832292178')
      M_C = LOG10(M_A)
      M_D = TO_FM('4.1634184584498706665047310953955053593e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1522
      M_A = TO_FM('0.9999999999999999994778241676797874940004')
      M_C = LOG10(M_A)
      M_D = TO_FM('-2.2677808255990599106049606546937597102e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1523
      CALL FM_LNI(2895833,M_C)
      M_D = TO_FM('14.878783365079154638251408713480965444')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1524
      CALL FM_LNI(2531896,M_C)
      M_D = TO_FM('14.744478987153028713006171333463425116')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1525
      M_A = TO_FM('.8830071479276119336989609534710013727931')
      M_B = TO_FM('.2983029918655860363206006071417293306070')
      M_C = M_A ** M_B
      M_D = TO_FM('.9635648854663441602276295143804091214980')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1526
      M_A = TO_FM('.2046822834634936204259667947178397091054')
      M_B = TO_FM('.0113741193573152263874178352602582175058')
      M_C = M_A ** M_B
      M_D = TO_FM('.9821190715107246840300334336752116983076')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1527
      M_A = TO_FM('.7668605659739208337937419810211254654597')
      CALL FM_RATIONAL_POWER(M_A,3,7,M_C)
      M_D = TO_FM('.8924681893919363302730585208912593273843')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1528
      M_A = TO_FM('.9062372571831410794348152141805768025855')
      CALL FM_RATIONAL_POWER(M_A,3,7,M_C)
      M_D = TO_FM('.9586831750229133225694901565227212287703')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1529
      M_A = TO_FM('2.4662120743304701014916113231545890428e-19')
      M_C = TAN(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890429e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1530
      M_A = TO_FM('2.4662120743304701014916113231545890427e-19')
      M_C = TAN(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1531
      M_A = TO_FM('2.4662120743304701014916113231545890428e-19')
      M_C = TANH(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1532
      M_A = TO_FM('2.4662120743304701014916113231545890427e-19')
      M_C = TANH(M_A)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1533
      M_X = TO_ZM('0.6283185307179586476925286766559005768401     + 2 i')
      M_Y = TO_ZM('5.000000000000000000000000000000000000001e-41  + 3 i')
      M_Y = M_X + M_Y
      M_Z = TO_ZM('0.6283185307179586476925286766559005768402     + 5 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1534
      M_X = TO_ZM(' 2 + 0.6283185307179586476925286766559005768401 i ')
      M_Y = TO_ZM(' 3 + 4.999999999999999999999999999999999999999e-41 i ')
      M_Y = M_X + M_Y
      M_Z = TO_ZM(' 5 + 0.6283185307179586476925286766559005768401 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1535
      M_X = TO_ZM(' 0.6283185307179586476925286766559005768401    + '//  &
                  ' 5.000000000000000000000000000000000000001e-41 i ')
      M_Y = TO_ZM(' 4.999999999999999999999999999999999999999e-41 + '//  &
                  ' 0.6283185307179586476925286766559005768401 i ')
      M_Y = M_X + M_Y
      M_Z = TO_ZM(' 0.6283185307179586476925286766559005768401 + '//  &
                  ' 0.6283185307179586476925286766559005768402 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      NCASE = 1536
      M_X = TO_ZM('0.6283185307179586476925286766559005768401     + 2 i')
      M_Y = TO_ZM('5.000000000000000000000000000000000000001e-41  - 3 i')
      M_Y = M_X - M_Y
      M_Z = TO_ZM('0.6283185307179586476925286766559005768400     + 5 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1537
      M_X = TO_ZM(' 2 + 0.6283185307179586476925286766559005768401 i ')
      M_Y = TO_ZM('-3 + 4.999999999999999999999999999999999999999e-41 i ')
      M_Y = M_X - M_Y
      M_Z = TO_ZM(' 5 + 0.6283185307179586476925286766559005768401 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1538
      M_X = TO_ZM(' 0.6283185307179586476925286766559005768401    + '//  &
                  ' 5.000000000000000000000000000000000000001e-41 i ')
      M_Y = TO_ZM(' 4.999999999999999999999999999999999999999e-41 + '//  &
                  ' 0.6283185307179586476925286766559005768401 i ')
      M_Y = M_X - M_Y
      M_Z = TO_ZM(' 0.6283185307179586476925286766559005768401 - '//  &
                  ' 0.6283185307179586476925286766559005768400 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1539
      M_X = TO_ZM(' 0.6283185307179586476925286766559005768401 + 2e-71 i ')
      M_Y = TO_ZM(' 0.5257635728213180166595247703159528791601 + 3e-72 i ')
      M_Y = M_X * M_Y
      M_Z = TO_ZM(' 0.3303469955801149926388139215009285936894 + '//  &
                  ' 1.2400227048580236276268081436286759314e-71 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1540
      M_X = TO_ZM(' 0.6283185307179586476925286766559005768401 + 2e-71 i ')
      M_Y = TO_ZM(' 3e-72 + 0.4742364271786819833404752296840471208399 i ')
      M_Y = M_X * M_Y
      M_Z = TO_ZM(' -7.599772951419763723731918563713240686e-72 + '//  &
                  ' 0.2979715351378436550537147551549719831507 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1541
      M_X = TO_ZM(' 0.6283185307179586476925286766559005768401 ')
      M_Y = TO_ZM(' 3e-72 + 0.4742364271786819833404752296840471208399 i ')
      M_Y = M_X * M_Y
      M_Z = TO_ZM(' 1.884955592153875943077586029967701731e-72 + '//  &
                  ' 0.2979715351378436550537147551549719831507 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1542
      M_X = TO_ZM(' 0.3976743471825143687216599350592794108215 + 2e-71 i ')
      M_Y = TO_ZM(' 0.9424777960769379715387930149838508652591 + 3e-72 i ')
      M_Y = M_X / M_Y
      M_Z = TO_ZM(' 0.4219455872995980174105705502942218606745 + '//  &
                  ' 1.9877564560228500546418079520211719271e-71 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1543
      M_X = TO_ZM(' 0.6919325506063328369126062247898634980537 + 2e-71 i ')
      M_Y = TO_ZM(' 3e-72 + 0.9424777960769379715387930149838508652591 i ')
      M_Y = M_X / M_Y
      M_Z = TO_ZM(' 2.3557573246522558864973918862865235752e-71 - '//  &
                  ' 0.7341632381012059477682883491173344179766 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1544
      M_X = TO_ZM(' 0.6919325506063328369126062247898634980537 + 2e-71 i ')
      M_Y = TO_ZM(' 0 + 0.9424777960769379715387930149838508652591 i ')
      M_Y = M_X / M_Y
      M_Z = TO_ZM(' 2.1220659078919378102517835116335248271e-71 - '//  &
                  ' 0.7341632381012059477682883491173344179766 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1545
      M_Y = TO_ZM('5.000000000000000000000000000000000000001e-37 + 4 i')
      CALL ZM_ADDI(M_Y,2)
      M_Z = TO_ZM('2.000000000000000000000000000000000001 + 4 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1546
      M_Y = TO_ZM('4.999999999999999999999999999999999999999e-37 + 6 i')
      CALL ZM_ADDI(M_Y,3)
      M_Z = TO_ZM('3 + 6 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1547
      M_X = TO_ZM('1 + e-18 i')
      M_C = ABS(M_X)
      M_D = TO_FM('1.0')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',TO_ZM(M_C),'M_C',TO_ZM(M_D),'M_D')
      ENDIF

      NCASE = 1548
      M_X = TO_ZM('1 + e-18 i') + TO_ZM(' e-52 i ')
      M_C = ABS(M_X)
      M_D = TO_FM('1.000000000000000000000000000000000001')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',TO_ZM(M_C),'M_C',TO_ZM(M_D),'M_D')
      ENDIF

      NCASE = 1549
      M_X = TO_ZM('0.5985846996875529104874722961539082031432e-36 + e-50 i')
      M_Y = ACOS(M_X)
      M_Z = TO_ZM('1.570796326794896619231321691639751441 - e-50')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1550
      M_X = TO_ZM('0.5985846996875529104874722961539082031430e-36 + e-50 i')
      M_Y = ACOS(M_X)
      M_Z = TO_ZM('1.570796326794896619231321691639751442 - e-50')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1551
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863628e-19 i')
      M_Y = ACOS(M_X)
      M_Z = TO_ZM('1.570796326794896619231321691639751442') -  &
            TO_ZM('3.1072325059538588668776624275223863628e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1552
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863630e-19 i')
      M_Y = ACOS(M_X)
      M_Z = TO_ZM('1.570796326794896619231321691639751442') -  &
            TO_ZM('3.1072325059538588668776624275223863629e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1553
      M_X = TO_ZM(' 1e+20 + 24.662120743304701014916113231545890428 i ')
      CALL ZM_ARG(M_X,M_C)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1554
      M_X = TO_ZM(' 1e+20 + 24.662120743304701014916113231545890427 i ')
      CALL ZM_ARG(M_X,M_C)
      M_D = TO_FM('2.4662120743304701014916113231545890427e-19')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1555
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863628e-19 i')
      M_Y = ASIN(M_X)
      M_Z = TO_ZM('9.9999999999999999999999999999999999995e-51') +  &
            TO_ZM('3.1072325059538588668776624275223863628e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1556
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863630e-19 i')
      M_Y = ASIN(M_X)
      M_Z = TO_ZM('9.9999999999999999999999999999999999995e-51') +  &
            TO_ZM('3.1072325059538588668776624275223863629e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1557
      M_X = TO_ZM('2.4662120743304701014916113231545890428e-19 + e-50 i')
      M_Y = ATAN(M_X)
      M_Z = TO_ZM('2.4662120743304701014916113231545890427e-19') +  &
            TO_ZM('.99999999999999999999999999999999999994e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1558
      M_X = TO_ZM('2.4662120743304701014916113231545890427e-19 + e-50 i')
      M_Y = ATAN(M_X)
      M_Z = TO_ZM('2.4662120743304701014916113231545890427e-19') +  &
            TO_ZM('.99999999999999999999999999999999999994e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1559
      M_X = TO_ZM('3.1072325059538588668776624275223863629e-19 + e-50 i')
      M_Y = SINH(M_X)
      M_Z = TO_ZM('3.1072325059538588668776624275223863630e-19') +  &
            TO_ZM('1.00000000000000000000000000000000000005e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1560
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863629e-19 i')
      M_Y = SINH(M_X)
      M_Z = TO_ZM('9.9999999999999999999999999999999999995e-51') +  &
            TO_ZM('3.1072325059538588668776624275223863628e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1561
      M_X = TO_ZM('1.0e-18 + e-50 i')
      M_Y = COSH(M_X)
      M_Z = TO_ZM('1.000000000000000000000000000000000001') +  &
            TO_ZM('1.0E-68 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1562
      M_X = TO_ZM('9.9999999999999999999999999999999999988e-19 + e-50 i')
      M_Y = COSH(M_X)
      M_Z = TO_ZM('1.0 + e-68 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1563
      M_Z = TO_ZM('9.9999999999999999999999999999999999988e-19 + e-50 i')
      CALL ZM_COSH_SINH(M_Z,M_X,M_Y)
      M_Z = TO_ZM('1.0 + e-68 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('1.00000000000000000000000000000000000005e-18') +  &
            TO_ZM('1.0000000000000000000000000000000000005e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1564
      M_Z = TO_ZM('e-50 + 3.1072325059538588668776624275223863629e-19 i')
      CALL ZM_COSH_SINH(M_Z,M_X,M_Y)
      M_Z = TO_ZM('0.9999999999999999999999999999999999999517') +  &
            TO_ZM('3.10723250595385886687766242752238636285e-69 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('9.9999999999999999999999999999999999995e-51') +  &
            TO_ZM('3.1072325059538588668776624275223863628e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1565
      M_Z = TO_ZM('3.1072325059538588668776624275223863629e-19 + e-50 i')
      CALL ZM_COSH_SINH(M_Z,M_X,M_Y)
      M_Z = TO_ZM('1.0 + 3.10723250595385886687766242752238636295e-69 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('3.1072325059538588668776624275223863630e-19') +  &
            TO_ZM('1.00000000000000000000000000000000000005e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1566
      M_X = TO_ZM('3.1072325059538588668776624275223863629e-19 + e-50 i')
      M_Y = SIN(M_X)
      M_Z = TO_ZM('3.1072325059538588668776624275223863628e-19') +  &
            TO_ZM('9.9999999999999999999999999999999999995e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1567
      M_X = TO_ZM('e-50 + 3.1072325059538588668776624275223863629e-19 i')
      M_Y = SIN(M_X)
      M_Z = TO_ZM('1.00000000000000000000000000000000000005e-50') +  &
            TO_ZM('3.1072325059538588668776624275223863630e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1568
      M_X = TO_ZM('1.0e-20 + e-50 i')
      M_Y = COS(M_X)
      M_Z = TO_ZM('1.0 - 1.0e-70 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1569
      M_X = TO_ZM('1.000000000000000000000000000000000001e-20 + e-50 i')
      M_Y = COS(M_X)
      M_Z = TO_ZM('0.9999999999999999999999999999999999999999') -  &
            TO_ZM('1.00000000000000000000000000000000000100e-70 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1570
      M_Z = TO_ZM('3.1072325059538588668776624275223863629e-19 + e-50 i')
      CALL ZM_COS_SIN(M_Z,M_X,M_Y)
      M_Z = TO_ZM('.9999999999999999999999999999999999999517') -  &
            TO_ZM('3.107232505953858866877662427522386362850e-69 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('3.1072325059538588668776624275223863628e-19') +  &
            TO_ZM('9.9999999999999999999999999999999999995e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1571
      M_Z = TO_ZM('e-50 + 3.1072325059538588668776624275223863629e-19 i')
      CALL ZM_COS_SIN(M_Z,M_X,M_Y)
      M_Z = TO_ZM('1.0 - 3.107232505953858866877662427522386362950e-69 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('1.00000000000000000000000000000000000005e-50') +  &
            TO_ZM('3.1072325059538588668776624275223863630e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1572
      M_Z = TO_ZM('3.1072325059538588668776624275223863629e-19 + e-50 i')
      CALL ZM_COS_SIN(M_Z,M_X,M_Y)
      M_Z = TO_ZM('9.999999999999999999999999999999999999517e-1') -  &
            TO_ZM('3.107232505953858866877662427522386362850e-69 i')
      IF (.NOT.(M_X == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF
      M_Z = TO_ZM('3.1072325059538588668776624275223863628e-19') +  &
            TO_ZM('9.9999999999999999999999999999999999995e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1573
      M_X = TO_ZM('0.5e-36 + e-80 i')
      M_Y = EXP(M_X)
      M_Z = TO_ZM('1.000000000000000000000000000000000001') +  &
            TO_ZM('1.000000000000000000000000000000000001e-80 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1574
      M_X = TO_ZM('4.999999999999999999999999999999999989999e-37 + e-80 i')
      M_Y = EXP(M_X)
      M_Z = TO_ZM('1.0 + e-80 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1575
      M_X = TO_ZM('1.000000000000000000707106781186547524 + e-50 i')
      M_Y = M_X ** 2
      M_Z = TO_ZM('1.000000000000000001414213562373095048') +  &
            TO_ZM('2.000000000000000001414213562373095048e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1576
      M_X = TO_ZM('e-50 + 1.000000000000000000707106781186547525 i')
      M_Y = M_X ** 2
      M_Z = TO_ZM('-1.000000000000000001414213562373095051') +  &
            TO_ZM(' 2.000000000000000001414213562373095050e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1577
      M_X = TO_ZM('0.9999999999999999994778241676797874940004 + e-50 i')
      M_Y = LOG10(M_X)
      M_Z = TO_ZM('-2.2677808255990599106049606546937597102E-19') +  &
            TO_ZM(' 4.3429448190325182787790700147651107341e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1578
      M_X = TO_ZM('.8455190010494953391255848876096865326839') +  &
            TO_ZM(' .7861461988847145319251164691167782914963 i')
      M_Y = LOG10(M_X)
      M_Z = TO_ZM('.0624033825129988962409024321757246973134') +  &
            TO_ZM('.3252980116488363982766948434519904605853 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1579
      M_X = TO_ZM('0.9999999999999999993793990486547925547640 + e-50 i')
      M_Y = LOG(M_X)
      M_Z = TO_ZM('-6.2060095134520744542857277040528826945e-19') +  &
            TO_ZM(' 1.00000000000000000062060095134520744562e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1580
      M_X = TO_ZM('1e+20 + 24.662120743304701014916113231545890428 i')
      M_Y = LOG(M_X)
      M_Z = TO_ZM('46.051701859880913680359829093687284152') +  &
            TO_ZM('2.4662120743304701014916113231545890427e-19 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1581
      M_X = TO_ZM('.8830071479276119336989609534710013727931 + e-50 i')
      M_Y = TO_ZM('.2983029918655860363206006071417293306070 - e-51 i')
      M_Y = M_X ** M_Y
      M_Z = TO_ZM('0.9635648854663441602276295143804091214980') +  &
            TO_ZM('3.3750637551181513929342847538584028563e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1582
      M_X = TO_ZM('.2046822834634936204259667947178397091054 + e-50 i')
      M_Y = TO_ZM('.0113741193573152263874178352602582175058 - e-51 i')
      M_Y = M_X ** M_Y
      M_Z = TO_ZM('.9821190715107246840300334336752116983076') +  &
            TO_ZM('2.1036918503256548440548740118221763962e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1583
      M_X = TO_ZM('.7668605659739208337937419810211254654597 + e-50 i')
      CALL ZM_RATIONAL_POWER(M_X,3,7,M_Y)
      M_Z = TO_ZM('0.8924681893919363302730585208912593273843') +  &
            TO_ZM('4.9876911638623221362078386375958597571e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1584
      M_X = TO_ZM('.9062372571831410794348152141805768025855 + e-50 i')
      CALL ZM_RATIONAL_POWER(M_X,3,7,M_Y)
      M_Z = TO_ZM('.9586831750229133225694901565227212287703') +  &
            TO_ZM('4.533737877253610724793982869327765542e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1585
      M_X = TO_ZM('1.000000000000000000707106781186547524 + e-50 i')
      CALL ZM_SQR(M_X,M_Y)
      M_Z = TO_ZM('1.000000000000000001414213562373095048') +  &
            TO_ZM('2.000000000000000001414213562373095048e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1586
      M_X = TO_ZM('1.000000000000000000707106781186547525 + e-50 i')
      CALL ZM_SQR(M_X,M_Y)
      M_Z = TO_ZM('1.000000000000000001414213562373095051') +  &
            TO_ZM('2.000000000000000001414213562373095050e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1587
      M_X = TO_ZM('0.9999999999999999999999999999999999999999 + e-50 i')
      CALL ZM_SQRT(M_X,M_Y)
      M_Z = TO_ZM('0.9999999999999999999999999999999999999999') +  &
            TO_ZM('5e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1588
      M_X = TO_ZM('0.0812551668996974871345739579795687707841 + e-50 i')
      CALL ZM_SQRT(M_X,M_Y)
      M_Z = TO_ZM('0.2850529194723279573072539887330984043228') +  &
            TO_ZM('1.75406026686402147370502782695083137048e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1589
      M_X = TO_ZM('2.4662120743304701014916113231545890428e-19 + e-50 i')
      CALL ZM_TAN(M_X,M_Y)
      M_Z = TO_ZM('2.4662120743304701014916113231545890429e-19') +  &
            TO_ZM('1.00000000000000000000000000000000000006e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1590
      M_X = TO_ZM('2.4662120743304701014916113231545890427e-19 + e-50 i')
      CALL ZM_TAN(M_X,M_Y)
      M_Z = TO_ZM('2.4662120743304701014916113231545890427e-19') +  &
            TO_ZM('1.00000000000000000000000000000000000006e-50 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1591
      M_X = TO_ZM('2.4662120743304701014916113231545890428e-19 + e-50 i')
      CALL ZM_TANH(M_X,M_Y)
      M_Z = TO_ZM('2.4662120743304701014916113231545890427e-19') +  &
            TO_ZM('9.9999999999999999999999999999999999994e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      NCASE = 1592
      M_X = TO_ZM('2.4662120743304701014916113231545890429e-19 + e-50 i')
      CALL ZM_TANH(M_X,M_Y)
      M_Z = TO_ZM('2.4662120743304701014916113231545890428e-19') +  &
            TO_ZM('9.9999999999999999999999999999999999994e-51 i')
      IF (.NOT.(M_Y == M_Z)) THEN
          CALL ERRPRT_ZM(' Round',M_X,'M_X',M_Y,'M_Y',M_Z,'M_Z')
      ENDIF

      RETURN
      END SUBROUTINE TEST48

      SUBROUTINE TEST49

!  Round toward +infinity.

      IMPLICIT NONE

      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 10 ')
      CALL FMSETVAR(' KROUND = 2 ')

      NCASE = 1593
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768407')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1594
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1595
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1596
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768405')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1597
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1598
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768395')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1599
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768397')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1600
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1601
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1602
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1603
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1604
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('-0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1605
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1606
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = -M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1607
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541580')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1608
      M_A = TO_FM('-0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('-0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541580')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1609
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.3997431577248499881970027038678588808455')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1610
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = -M_A + TO_FM('0.5649365180369')
      MFMV1(3) = -M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1611
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('0.2844558260571')
      MFMV1(3) = M_A + 2*TO_FM('0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541580')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.8815842236052348640130150036752442950679')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1612
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('-0.2844558260571')
      MFMV1(3) = -M_A + 2*TO_FM('-0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541580')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.8815842236052348640130150036752442950678')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1613
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = M_A + 2*TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.3997431577248499881970027038678588808455')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1614
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = -M_A + 2*TO_FM('-0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('-0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1615
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('0.5142899005070373097659012225902504129228')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1616
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('-0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1617
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('1.878706647477504308190417437970331887')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1618
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('-0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('-1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1619
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') - M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.5142899005070373097659012225902504129228')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870773')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1620
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') + M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870773')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1621
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('2.788483144777492522933050948973640361')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('1.878706647477504308190417437970331887')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1622
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('-0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-2.788483144777492522933050948973640360')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST49

      SUBROUTINE TEST50

!  Round toward -infinity.

      IMPLICIT NONE

      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 10 ')
      CALL FMSETVAR(' KROUND = -1 ')

      NCASE = 1623
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1624
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768407')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1625
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768405')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1626
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1627
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768395')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1628
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1629
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1630
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768397')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1631
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1632
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1633
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1634
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('-0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1635
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1636
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = -M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1637
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1638
      M_A = TO_FM('-0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('-0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1639
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1640
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = -M_A + TO_FM('0.5649365180369')
      MFMV1(3) = -M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605757')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.3997431577248499881970027038678588808455')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1641
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('0.2844558260571')
      MFMV1(3) = M_A + 2*TO_FM('0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.8815842236052348640130150036752442950678')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1642
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('-0.2844558260571')
      MFMV1(3) = -M_A + 2*TO_FM('-0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409099')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.8815842236052348640130150036752442950679')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1643
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = M_A + 2*TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1644
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = -M_A + 2*TO_FM('-0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('-0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.3997431577248499881970027038678588808455')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.1598437505049341638922976633191829202699')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1645
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1646
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('-0.5142899005070373097659012225902504129228')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1647
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1648
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('-0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('-1.878706647477504308190417437970331887')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1649
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') - M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870772')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1650
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') + M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-.5142899005070373097659012225902504129228')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870772')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1651
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('2.788483144777492522933050948973640360')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1652
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('-0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-2.788483144777492522933050948973640361')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-1.878706647477504308190417437970331887')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST50

      SUBROUTINE TEST51

!  Round toward zero.

      IMPLICIT NONE

      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 10 ')
      CALL FMSETVAR(' KROUND = 0 ')

      NCASE = 1653
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1654
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768406')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1655
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768405')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1656
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A + M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768405')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1657
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768395')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1658
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-5.000000000000000000000000000000000001e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768395')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1659
      M_A = TO_FM('0.6283185307179586476925286766559005768401')
      M_B = TO_FM('4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1660
      M_A = TO_FM('-0.6283185307179586476925286766559005768401')
      M_B = TO_FM('-4.999999999999999999999999999999999999e-40')
      M_C = M_A - M_B
      M_D = TO_FM('-0.6283185307179586476925286766559005768396')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1661
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1662
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1663
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1664
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('-0.2844558260571')
      M_C = M_A * M_B
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1665
      M_A = TO_FM('0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1666
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      M_B = TO_FM('0.5649365180369')
      MFMV1(1) = -M_A + M_B
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1667
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1668
      M_A = TO_FM('-0.696614681390281171833211321255418669')
      M_B = M_A + TO_FM('-0.2844558260571')
      MFMV1(1) = TO_FM('0.2844558260571')
      CALL FMMPYD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1669
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1670
      M_A = TO_FM('-0.282941083469653908817180471388519729')
      MFMV1(1) = TO_FM('0.5649365180369')
      MFMV1(2) = -M_A + TO_FM('0.5649365180369')
      MFMV1(3) = -M_A + 2*TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1671
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('0.2844558260571')
      MFMV1(3) = M_A + 2*TO_FM('0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.8815842236052348640130150036752442950678')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1672
      M_A = TO_FM('0.696614681390281171833211321255418669')
      MFMV1(1) = M_A + TO_FM('0.2844558260571')
      MFMV1(2) = TO_FM('-0.2844558260571')
      MFMV1(3) = -M_A + 2*TO_FM('-0.2844558260571')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.6834281189668589065995658881433064541579')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-0.1981561046383759574134491155319378409098')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.8815842236052348640130150036752442950678')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1673
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = M_A + 2*TO_FM('0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1674
      M_A = TO_FM('0.282941083469653908817180471388519729')
      MFMV1(1) = -M_A + 2*TO_FM('-0.5649365180369')
      MFMV1(2) = M_A + TO_FM('0.5649365180369')
      MFMV1(3) = TO_FM('-0.5649365180369')
      CALL FMMPYE(M_A%MFM,MFMV1(1)%MFM,MFMV1(2)%MFM,MFMV1(3)%MFM,  &
                  MFMV2(1)%MFM,MFMV2(2)%MFM,MFMV2(3)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-0.3997431577248499881970027038678588808454')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.2398994072199158243047050405486759605756')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(3)
      M_D = TO_FM('-0.1598437505049341638922976633191829202698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1675
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1676
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921')
      M_C = M_A / M_B
      M_D = TO_FM('-0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1677
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1678
      M_A = TO_FM('0.4693356799052036759819703352946208572489')
      M_B = TO_FM('-0.2498185017524528219383570234374166958944')
      M_C = M_A / M_B
      M_D = TO_FM('-1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1679
      M_A = TO_FM('0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') - M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('0.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870772')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1680
      M_A = TO_FM('-0.4248927758509876073065623506584042361272')
      M_B = TO_FM('0.8261736725377782666616486764041757591921') + M_A
      MFMV1(1) = TO_FM('0.8261736725377782666616486764041757591921')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-.5142899005070373097659012225902504129227')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('0.4857100994929626902340987774097495870772')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1681
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('2.788483144777492522933050948973640360')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1682
      M_A = TO_FM('0.696614681390281171833211321255418669')
      M_B = TO_FM('0.4693356799052036759819703352946208572489')
      MFMV1(1) = TO_FM('-0.2498185017524528219383570234374166958944')
      CALL FMDIVD(M_A%MFM,M_B%MFM,MFMV1(1)%MFM,MFMV2(1)%MFM,MFMV2(2)%MFM)
      M_C = MFMV2(1)
      M_D = TO_FM('-2.788483144777492522933050948973640360')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF
      M_C = MFMV2(2)
      M_D = TO_FM('-1.878706647477504308190417437970331886')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST51

      SUBROUTINE TEST52

!  Test cases close to 1/2 ulp rounding error for special functions.

      IMPLICIT NONE

      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 10 ')
      CALL FMSETVAR(' KROUND = 1 ')

      NCASE = 1683
      M_A = TO_FM('.2328386190529659228832053957071072125573')
      CALL FM_BERN(24,M_A,M_C)
      M_D = TO_FM('-20159.22657221596015247800092403139140')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1684
      M_A = TO_FM('.9451765100122574216552754520712319556089')
      CALL FM_BERN(24,M_A,M_C)
      M_D = TO_FM('-81833.62147384601623719886358367428881')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1685
      M_A = TO_FM('.5821684750579093589504314571127397718728')
      M_B = TO_FM('.5276586479483013778818324226131214725295')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('2.718685192837677534284224946262289328')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1686
      M_A = TO_FM('.0045177228684763844273939828899034713744')
      M_B = TO_FM('.7071703810032528448210532389136837995613')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('221.971401823711307460442393160140748062')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1687
      M_A = TO_FM('.2910233266900902429391868324973905211679')
      M_B = TO_FM('.2686978655316086409504709070690468302996')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('1.008221342235108731639228823278327453')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1688
      M_A = TO_FM('.1496244761646217127068665425798759041706')
      M_B = TO_FM('.5208004094353136060294490790695580983140')
      CALL FM_COMB(M_A,M_B,M_C)
      M_D = TO_FM('.7373815284360172522038196138611166769208')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1689
      M_A = TO_FM('.8818763003667274658259474897327495825393')
      CALL FM_FACT(M_A,M_C)
      M_D = TO_FM('.9556856818324261868773320949535856718209')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1690
      M_A = TO_FM('.4949226557823776089070415346269135914019')
      CALL FM_FACT(M_A,M_C)
      M_D = TO_FM('.8860734400698097304792845052056675778507')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1691
      M_A = TO_FM('.3761598409707025773715937538446685849102')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('2.362889562494552736407145620878970868')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1692
      M_A = TO_FM('.1672675981473020062920707493172560265625')
      CALL FM_GAM(M_A,M_C)
      M_D = TO_FM('5.545212721835892382245850289336741506')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1693
      M_A = TO_FM('.4614584565062692160383906583541987167546')
      M_B = TO_FM('.5951149438121376420146106335369913012772')
      M_C = TO_FM('.5135832693383946635459024061261877609871')
      CALL FM_IBTA(M_A,M_B,M_C,M_D)
      M_C = M_D
      M_D = TO_FM('1.175720760325729892558264431672632920')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1694
      M_A = TO_FM('.4081940034223790033948418644820959999190')
      M_B = TO_FM('.1180588713006268461672671906643209312650')
      M_C = TO_FM('.3149184009440604069173388778384328835109')
      CALL FM_IBTA(M_A,M_B,M_C,M_D)
      M_C = M_D
      M_D = TO_FM('7.900309247533697782193990826692658854')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1695
      M_A = TO_FM('.0427267171132272876071206331149137449302')
      M_B = TO_FM('.5105188999386855843675421276828724346974')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('22.321595915082369762690531066589279138')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1696
      M_A = TO_FM('.4794594023597792560960161318337194611725')
      M_B = TO_FM('.4519909618067343602717438997268702891724')
      CALL FM_IGM1(M_A,M_B,M_C)
      M_D = TO_FM('1.241872690864524980937587750040289597')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1697
      M_A = TO_FM('.2261686600832506249009095185947406573375')
      M_B = TO_FM('.5015127240787333498711528283826321561631')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('.5549442049131076957568567379492812192955')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1698
      M_A = TO_FM('.5094842013600974599082648516536815144934')
      M_B = TO_FM('.3482871781307067261980605367667982396401')
      CALL FM_IGM2(M_A,M_B,M_C)
      M_D = TO_FM('.7151073736823869119517083475220619366219')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1699
      M_A = TO_FM('.2068069932686212583647656539146963022688')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('1.488657022360415732776205520278718644')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1700
      M_A = TO_FM('.1193692518130361861966262640397336872045')
      CALL FM_LNGM(M_A,M_C)
      M_D = TO_FM('2.067720011879939917820025488153571130')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1701
      M_A = TO_FM('.2576495214584462521245806915946723616023')
      CALL FM_PGAM(4,M_A,M_C)
      M_D = TO_FM('-21146.16261340494528903688834773180156')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1702
      M_A = TO_FM('.7962098719476029756078555617481483300242')
      CALL FM_PGAM(4,M_A,M_C)
      M_D = TO_FM('-76.473397969955670235128480927719957319')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1703
      M_A = TO_FM('.2903751291177076383370995341599159483511')
      CALL FM_POCH(M_A,10,M_C)
      M_D = TO_FM('226382.58826609244992525125582538977845')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1704
      M_A = TO_FM('.6535382063050879489012218891599782182586')
      CALL FM_POCH(M_A,10,M_C)
      M_D = TO_FM('1172527.33029198368051435459325948991873')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1705
      M_A = TO_FM('.6974141103846349693484255734679991971531')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('-1.227373681669287236661348744017575764')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1706
      M_A = TO_FM('.1489240375392748170922697013324334780161')
      CALL FM_PSI(M_A,M_C)
      M_D = TO_FM('-7.070608127091923241761976851770484074')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1707
      M_A = TO_FM('.1418132137659642168028407618412830046398')
      CALL FM_BESJ(2,M_A,M_C)
      M_D = TO_FM('.0025096630568893136653901659219379348639')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1708
      M_A = TO_FM('.1788169540762649644737416406458567693875')
      CALL FM_BESJ(2,M_A,M_C)
      M_D = TO_FM('.0039862981780302297384350008335271212665')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1709
      M_A = TO_FM('.5805890744092277015557299624869968071680')
      CALL FM_BESY(3,M_A,M_C)
      M_D = TO_FM('-27.170050571120923815100314544070890349')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1710
      M_A = TO_FM('.1727566160014456348350360062835911734820')
      CALL FM_BESY(3,M_A,M_C)
      M_D = TO_FM('-991.492233932025018825422382282585945571')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1711
      M_A = TO_FM('.4016568782932617682033356419955298473240')
      CALL FM_C(M_A,M_C)
      M_D = TO_FM('.3990851528696198643615325503826128715808')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1712
      M_A = TO_FM('.5530524251328989351390869029628343285806')
      CALL FM_C(M_A,M_C)
      M_D = TO_FM('.5404216519412922344321401126915592210606')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1713
      M_A = TO_FM('.3132698047591739833827682199637207397498')
      CALL FM_CHI(M_A,M_C)
      M_D = TO_FM('-0.5588397635338133878184786033023681883232')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1714
      M_A = TO_FM('.9021393609362524403130756737458658526952')
      CALL FM_CHI(M_A,M_C)
      M_D = TO_FM('.6847189967592175982961668075227015086895')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1715
      M_A = TO_FM('.4629298516778537800282633125284364103977')
      CALL FM_CI(M_A,M_C)
      M_D = TO_FM('-0.2460639652015249005042894314555107778450')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1716
      M_A = TO_FM('.0549423062812426822427336674003262253111')
      CALL FM_CI(M_A,M_C)
      M_D = TO_FM('-2.325010525455479068147552564259710333')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1717
      M_A = TO_FM('.6072730938561594792843888804993271348637')
      CALL FM_EI(M_A,M_C)
      M_D = TO_FM('.7919157659390910345415002387390308359006')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1718
      M_A = TO_FM('.9503051536465725719993585687558366320625')
      CALL FM_EI(M_A,M_C)
      M_D = TO_FM('1.759976172298062963545208718828109308')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1719
      M_A = TO_FM('.2340205975024858648191209097882767518758')
      CALL FM_EN(3,M_A,M_C)
      M_D = TO_FM('.3330926301696971928355749328109205940940')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1720
      M_A = TO_FM('.0400995594332772093627899515751956369449')
      CALL FM_EN(3,M_A,M_C)
      M_D = TO_FM('.4632389771805115242616797414710747077664')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1721
      M_A = TO_FM('.7886473371721963111084785258161883958469')
      CALL FM_ERF(M_A,M_C)
      M_D = TO_FM('.7352848658941150054408574269874333390461')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1722
      M_A = TO_FM('.7609436172163287325768460098497054081684')
      CALL FM_ERF(M_A,M_C)
      M_D = TO_FM('.7181339130361657639451467578071178631777')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1723
      M_A = TO_FM('.6100881772504833944803283072200079400836')
      CALL FM_ERFC(M_A,M_C)
      M_D = TO_FM('.3882502027357936095789040007851801672816')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1724
      M_A = TO_FM('.6243617029740179628590302641485755306347')
      CALL FM_ERFC(M_A,M_C)
      M_D = TO_FM('.3772466516971787018401366908961968549338')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1725
      M_A = TO_FM('.9707757617868134478807410067239461677428')
      CALL FM_LERC(M_A,M_C)
      M_D = TO_FM('-1.773202710864594278785176372612043038')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1726
      M_A = TO_FM('.5982919135705171840846535893551708254495')
      CALL FM_LERC(M_A,M_C)
      M_D = TO_FM('-.9225855862015127266997763635874449606237')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1727
      M_A = TO_FM('.3075187515156989643790009724751097014093')
      CALL FM_LI(M_A,M_C)
      M_D = TO_FM('-.1637252161858283068213216668816736669698')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1728
      M_A = TO_FM('.1187059517092358051891453031444894386999')
      CALL FM_LI(M_A,M_C)
      M_D = TO_FM('-.0408414304985139641159873359583412863556')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1729
      M_A = TO_FM('.5437226766721640071140744727072520535257')
      CALL FM_S(M_A,M_C)
      M_D = TO_FM('.0828773122511780478009671826497228619741')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1730
      M_A = TO_FM('.9617114410081342679366219277397124076033')
      CALL FM_S(M_A,M_C)
      M_D = TO_FM('.4000602273249795258822738271587288566974')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1731
      M_A = TO_FM('.8655870024154057721077141187964875276485')
      CALL FM_SHI(M_A,M_C)
      M_D = TO_FM('.9024368708930004866080405665890701363253')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1732
      M_A = TO_FM('.7550498406342259261861893754142408822008')
      CALL FM_SHI(M_A,M_C)
      M_D = TO_FM('.7793769513468371612732453792935391553448')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1733
      M_A = TO_FM('.7336740214990864267606810631343342550790')
      CALL FM_SI(M_A,M_C)
      M_D = TO_FM('.7120850765110427480344276510598853655741')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1734
      M_A = TO_FM('.8448202102736804118406485838696405421819')
      CALL FM_SI(M_A,M_C)
      M_D = TO_FM('.8120307046646463143924793647173595754174')
      IF (.NOT.(M_D == M_C)) THEN
          CALL ERRPRT_FM(' Round',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      RETURN
      END SUBROUTINE TEST52

      SUBROUTINE TEST53

!  Test special cases and error cases.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing special cases and error cases.')")

      MBASE = MXBASE
      CALL FMCONS
      NDIG = 2 + 52*DLOGTN/DLOGMB

!             Turn error message printing off while testing the error case code.

      CALL FMSETVAR(' KWARN = 0 ')
      M_A = 0

      NCASE = 1735
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMMPY(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.2565628653416941226485280051014985652035285365075991'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMMPY ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 1736
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FMST2M(ST1,MA)
      ST1 = '0.7319587628865979381443298969072164948453608247422680'
      CALL FMST2M(ST1,MB)
      CALL FMDIV(MA,MB,ME)
      CALL FMEQ(ME,MA)
      ST2 = '0.4788732394366197183098591549295774647887323943661972'
      CALL FMST2M(ST2,MC)
      CALL FMSUB(MA,MC,MD)
      CALL FMABS(MD,ME)
      CALL FMEQ(ME,MD)
      CALL FMST2M('1.0E-50',MB)
      IF (.NOT.FMCOMP(MD,'LE',MB)) THEN
          CALL ERRPRTFM('FMDIV ',MA,'MA',MC,'MC',MD,'MD')
      ENDIF

      NCASE = 1737
      M_A = TO_FM('10')
      M_B = TO_FM('5.3')
      CALL FM_BETA(M_A,M_B,M_C)
      M_D = TO_FM('7.0836036771097107530120640698518155187687458162734679M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' BETA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1738
      M_A = TO_FM('0.1')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('5.8731980918960730463350151650813268739874201571164800M-27')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1739
      M_A = TO_FM('8.115640517330775M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.0112520048150164306467955877563719782378767062440103M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1740
      M_A = TO_FM('9.01737835258975M-1')
      M_B = TO_FM('2.00853601446773')
      M_C = TO_FM('1.59735792202923')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.2512248738228585976753517954889151150428002974819213M-1')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1741
      M_A = TO_FM('9.6097615596216720E-01')
      M_B = TO_FM('1.970425178583792')
      M_C = TO_FM('5.5680052333367')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.8619456987740165364092968281459448023932520843535423M-2')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1742
      M_A = TO_FM('4.764360371097952E-01')
      M_B = TO_FM('1.161514683661584E+01')
      M_C = TO_FM('2.937801562768354E-01')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('2.3604503996731113868791517339909092506365724801689105M-5')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 1743
      M_A = TO_FM('0.9')
      M_B = TO_FM('23.4')
      M_C = TO_FM('34.5')
      CALL FM_IBTA(M_A,M_B,M_C,MFM6)
      CALL FM_EQ(MFM6,M_C)
      M_D = TO_FM('7.3148127865937299821246829407023943740949130742928268M-18')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM(' IBTA ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      CALL ZMSET(50)
      CALL ZM_SET(50)
      CALL FMSET(50)

      NCASE = 1744
      MIM3 = 1
      MIM4 = 0
      MIM5 = MIM3/MIM4
      IF (MWK(START(MIM5%MIM)+2) /= MUNKNO .OR. MWK(START(MIM5%MIM)) /= 1) CALL PRTERR(KW)

      NCASE = 1745
      MIM5 = MIM3*MIM5
      IF (MWK(START(MIM5%MIM)+2) /= MUNKNO .OR. MWK(START(MIM5%MIM)) /= 1) CALL PRTERR(KW)

      NCASE = 1746
      MIM4 = 1.23E+23
      MFM4 = MIM4
      MFM5 = TO_FM('1.23E+23')
      IF (.NOT. ABS((MFM5-MFM4)/MFM5) < RSMALL) CALL PRTERR(KW)

      NCASE = 1747
      MIM4 = 1.23D+45
      MFM4 = MIM4
      MFM5 = TO_FM('1.23D+45')
      IF (.NOT. ABS((MFM5-MFM4)/MFM5) < DSMALL) CALL PRTERR(KW)

      NCASE = 1748
      MIM4 = CMPLX(1.23E+23,9.87E+24)
      MFM4 = MIM4
      MFM5 = TO_FM('1.23E+23')
      IF (.NOT. ABS((MFM5-MFM4)/MFM5) < RSMALL) CALL PRTERR(KW)

      NCASE = 1749
      MIM4 = CMPLX(1.23D+23,9.87D+24, KIND(0.0D0))
      MFM4 = MIM4
      MFM5 = TO_FM('1.23D+23')
      IF (.NOT. ABS((MFM5-MFM4)/MFM5) < DSMALL) CALL PRTERR(KW)

      NCASE = 1750
      CALL FM_ST2M('1.23',MFMV1(1))
      CALL FM_ST2M('2.23',MFMV1(2))
      CALL FM_ST2M('3.23',MFMV1(3))
      CALL FM_ST2M('4.23',MFMV3(1))
      CALL FM_ST2M('5.23',MFMV3(2))
      MFM3 = DOT_PRODUCT(MFMV1,MFMV3)
      IF (MWK(START(MFM3%MFM)+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1751
      CALL IM_ST2M('12',MIMV1(1))
      CALL IM_ST2M('23',MIMV1(2))
      CALL IM_ST2M('34',MIMV1(3))
      CALL IM_ST2M('-14',MIMV3(1))
      CALL IM_ST2M('-5',MIMV3(2))
      MIM3 = DOT_PRODUCT(MIMV1,MIMV3)
      IF (MWK(START(MIM3%MIM)+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1752
      CALL ZM_ST2M('1.23 + 1.67 i',MZMV1(1))
      CALL ZM_ST2M('2.23 - 2.56 i',MZMV1(2))
      CALL ZM_ST2M('3.23 + 3.45 i',MZMV1(3))
      CALL ZM_ST2M('4.23 - 4.34 i',MZMV3(1))
      CALL ZM_ST2M('5.23 + 5.23 i',MZMV3(2))
      MZM3 = DOT_PRODUCT(MZMV1,MZMV3)
      IF (MWK(START(MZM3%MZM(1))+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1753
      DO I = 1, 3
         DO J = 1, 3
            MFMA(I,J) = 3*(J-1) + I
         ENDDO
      ENDDO
      DO I = 1, 2
         DO J = 1, 2
            MFMD(I,J) = 3*(J-1) + I
         ENDDO
      ENDDO
      MFME = MATMUL(MFMA,MFMD)
      IF (MWK(START(MFME(1,1)%MFM)+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1754
      DO I = 1, 2
         DO J = 1, 2
            MIMA(I,J) = 2*(J-1) + I + 20
         ENDDO
      ENDDO
      DO I = 1, 3
         DO J = 1, 2
            MIMD(I,J) = 2*(J-1) + I + 20
         ENDDO
      ENDDO
      MIMC = MATMUL(MIMA,MIMD)
      IF (MWK(START(MIMC(1,1)%MIM)+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1755
      DO I = 1, 2
         DO J = 1, 3
            MZMA(I,J) = CMPLX(TO_FM(2*(J-1)+I+10),TO_FM(2*(J-1)+I+20))
         ENDDO
      ENDDO
      DO I = 1, 2
         DO J = 1, 4
            MZMC(I,J) = CMPLX(TO_FM(4*(I-1)+J+50),TO_FM(4*(I-1)+J+30))
         ENDDO
      ENDDO
      MZMC = MATMUL(MZMA,MZMC)
      IF (MWK(START(MZMC(1,1)%MZM(1))+2) /= MUNKNO) CALL PRTERR(KW)

      NCASE = 1756
      MFM4 = HUGE(MFM1)
      MFM3 = SCALE(MFM4,12)
      IF (MWK(START(MFM3%MFM)+2) /= MEXPOV) CALL PRTERR(KW)

      NCASE = 1757
      MZM4 = HUGE(MFM1)
      MZM3 = SCALE(MZM4,12)
      IF (MWK(START(MZM3%MZM(1))+2) /= MEXPOV) CALL PRTERR(KW)

      RETURN
      END SUBROUTINE TEST53

      SUBROUTINE TEST54

!  Test packed array routines and error messages.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing packed array routines and error messages.')")

!             Turn error message printing on while testing the error case code, and write the
!             error messages on unit 22.

      CALL FMSETVAR(' KWARN = 1 ')

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')
      CALL FMSETVAR(' NTRACE = -2 ')
      CALL FMSETVAR(' LVLTRC = 1 ')
      CALL FMSETVAR(' MBASE = 10000 ')
      CALL FMSETVAR(' NDIG = 14 ')

      NCASE = 1758
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('-1.67',MP1)
      CALL FPABS(MP1,MP3)
      CALL FPST2M('1.67',MP4)
      IF (.NOT.FPCOMPARE(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1759
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('8374251785837425178583792',MP3)
      CALL IPEQ(MP3,MP2)
      CALL IPDIVR(MP1,MP2,MP5,MP4)
      CALL IPST2M('3666412140861684892372583',MP3)
      IF (.NOT.(IPCOMPARE(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1760
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPM2DP(MP1,D1)
      CALL FPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL FPM2DP(MP1,D3)
      IF (.NOT. (ABS(D3-D1) < DSMALL)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1761
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('0',MP1)
      MBLOGS = 0
      CALL FPACOS(MP1,MP3)
      CALL FPPI(MP2)
      CALL FPDIVI(MP2,2,MP4)
      CALL FPSUB(MP3,MP4,MP2)
      CALL FPST2M('1.0E-49',MP1)
      IF (.NOT.FPCOMPARE(MP2,'<',MP1)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1762
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('-UNDERFLOW',MP1)
      CALL FPACOS(MP1,MP3)
      CALL FPPI(MP2)
      CALL FPDIVI(MP2,2,MP4)
      CALL FPSUB(MP3,MP4,MP2)
      CALL FPST2M('1.0E-49',MP1)
      IF (.NOT.FPCOMPARE(MP2,'<',MP1)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1763
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 0
      CALL FPST2M('-0.5',MP1)
      CALL FPACOS(MP1,MP3)
      CALL FPST2M('120',MP4)
      KRAD = 1
      IF (.NOT.FPCOMPARE(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1764
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMSETVAR(' NTRACE = -1 ')
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('13.0',MP2)
      MBLOGS = 0
      CALL FPADD(MP1,MP2,MP3)
      CALL FPST2M('25.0',MP4)
      IF (.NOT.FPCOMPARE(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1765
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('13.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FPADD(MP1,MP2,MP3)
      KDEBUG = J
      CALL FPST2M('25.0',MP4)
      IF (.NOT.FPCOMPARE(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1766
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('13.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FPSUB(MP1,MP2,MP3)
      KDEBUG = J
      CALL FPST2M('-1.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1767
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('0.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FPADD(MP1,MP2,MP3)
      KDEBUG = J
      CALL FPST2M('12.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1768
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('0.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FPSUB(MP1,MP2,MP3)
      KDEBUG = J
      CALL FPST2M('12.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1769
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPBIG(MP1)
      CALL FPBIG(MP2)
      CALL FPADD(MP1,MP2,MP3)
      IF (.NOT.(MWK(START(MP3)+2) == MEXPOV)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1770
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPBIG(MP1)
      CALL FPI2M(0,MP3)
      CALL FPSUB(MP3,MP1,MP2)
      CALL FPSUB(MP1,MP2,MP3)
      IF (.NOT.(MWK(START(MP3)+2) == MEXPOV)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1771
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPTINY(MP1)
      CALL FPDIVI(MP1,2,MP3)
      IF (.NOT.(MWK(START(MP3)+2) == MEXPUN)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1772
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMSETVAR(' NTRACE = -2 ')
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('13.0',MP2)
      MBLOGS = 0
      CALL FMUNPK(MP1,MA)
      CALL FMUNPK(MP2,MB)
      CALL FMADD_R1(MA,MB)
      CALL FMPACK(MA,MP1)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('25.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1773
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPACOS(ZP1,ZP4)
      CALL ZPST2M('0.70600062465538060328041859335986022136042273675348823497' &
       // ' - 0.71156604883917677179467491357721581085120933977853167363 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1774
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMSETVAR(' NTRACE = 2 ')
      CALL FM_SET(50)
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('13.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FMUNPK(MP1,MA)
      CALL FMUNPK(MP2,MB)
      CALL FMADD_R1(MA,MB)
      CALL FMPACK(MA,MP1)
      CALL FPEQ(MP1,MP3)
      KDEBUG = J
      CALL FPST2M('25.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1775
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.0',MP1)
      CALL FPST2M('0.0',MP2)
      J = KDEBUG
      KDEBUG = 1
      CALL FMUNPK(MP1,MA)
      CALL FMUNPK(MP2,MB)
      CALL FMADD_R1(MA,MB)
      CALL FMPACK(MA,MP1)
      CALL FPEQ(MP1,MP3)
      KDEBUG = J
      CALL FPST2M('12.0',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1776
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPBIG(MP1)
      CALL FPBIG(MP2)
      CALL FMUNPK(MP1,MA)
      CALL FMUNPK(MP2,MB)
      CALL FMADD_R1(MA,MB)
      CALL FMPACK(MA,MP1)
      CALL FPEQ(MP1,MP3)
      IF (.NOT.(MWK(START(MP3)+2) == MEXPOV)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1777
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' 1.732050808 ',MA)
      CALL FMPRINT(MA)

      NCASE = 1778
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FM_ST2M(' 1.732050808 ',M_A)
      CALL FM_PRINT(M_A)

      NCASE = 1779
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IM_ST2M(' 11732050808 ',M_J)
      CALL IM_PRINT(M_J)

      NCASE = 1780
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IM_ST2M(' 11732050808 ',M_J)
      CALL IMPRINT(M_J%MIM)

      NCASE = 1781
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMFPRINT(' F12.7 ',MA)

      NCASE = 1782
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMFPRINT(' ES25.15 ',MA)

      NCASE = 1783
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMFPRINT(' 1PE25.15 ',MA)

      NCASE = 1784
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMFPRINT(' E25.15 ',MA)

      NCASE = 1785
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FM_FPRINT(' F12.7 ',M_A)

      NCASE = 1786
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      M_J = 12343
      CALL IMFPRINT(' I10 ',M_J%MIM)

      NCASE = 1787
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      M_J = 12343
      CALL IM_FPRINT(' I10 ',M_J)

      NCASE = 1788
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZM_ST2M(' 1.23 - 4.56 i ',M_Z)
      CALL ZM_FPRINT(' F12.7 ',' F12.7 ',M_Z)

      NCASE = 1789
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZMST2M(' 1.23 - 4.56 i ',ZA)
      CALL ZMFPRINT(' F12.7 ',' F12.7 ',ZA)

      NCASE = 1790
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FM_FPRINT(' F12.7 ',M_A)

      NCASE = 1791
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','0','5','0','8','1' /)
      CALL FMINP(LINE,MA,1,10)
      CALL FMFPRINT(' F14.9 ',MA)

      NCASE = 1792
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','0','5','0','8','1' /)
      CALL FM_INP(LINE,M_A,1,10)
      CALL FM_FPRINT(' F14.9 ',M_A)

      NCASE = 1793
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','2','7','3','2','0','5','0','8','1' /)
      CALL IM_INP(LINE,M_J,1,10)
      CALL IM_FPRINT(' F14.9 ',M_J)

      NCASE = 1794
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','-','5','.','8','i' /)
      CALL ZM_INP(LINE,M_Z,1,10)
      CALL ZM_FPRINT(' F14.9 ',' F14.9 ',M_Z)

      NCASE = 1795
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','-','5','.','8','i' /)
      CALL ZMINP(LINE,ZA,1,10)
      CALL ZMFPRINT(' F14.9 ',' F14.9 ',ZA)

      NCASE = 1796
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FM_OUT(M_A,LINE2,80)
      WRITE (22,*) LINE2

      NCASE = 1797
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IM_OUT(M_J,LINE2,80)
      WRITE (22,*) LINE2

      NCASE = 1798
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZM_OUT(M_Z,LINE3,160,L1,L2)
      WRITE (22,*) LINE3(1:L1)
      WRITE (22,*) LINE3(L1+1:L2)

      NCASE = 1799
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZM_PRINT(M_Z)

      NCASE = 1800
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZMPRINT(M_Z%MZM)

      NCASE = 1801
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      OPEN (23,FILE='TEMPFM')
      CALL FMWRITE(23,MA)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL FMREAD(23,MB)
      CLOSE(23)
      IF (.NOT.FMCOMP(MA,'==',MB)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1802
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      OPEN (23,FILE='TEMPFM')
      CALL FM_WRITE(23,M_A)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL FM_READ(23,M_B)
      CLOSE(23)
      IF (.NOT.FMCOMP(MA,'==',MB)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1803
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IMST2M(' 8765432 ',MA)
      OPEN (23,FILE='TEMPFM')
      CALL IM_WRITE(23,M_J)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL IM_READ(23,M_K)
      CLOSE(23)
      IF (.NOT.IM_COMP(M_J,'==',M_K)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1804
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      OPEN (23,FILE='TEMPFM')
      CALL IM_WRIT(23,M_J)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL IM_READ(23,M_K)
      CLOSE(23)
      IF (.NOT.IM_COMP(M_J,'==',M_K)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1805
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      OPEN (23,FILE='TEMPFM')
      CALL ZMWRITE(23,ZA)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL ZMREAD(23,ZB)
      CLOSE(23)
      CALL ZMSUB(ZA,ZB,ZC)
      CALL ZMABS(ZC,MA)
      IF (.NOT.(MWK(START(MA)+3)==0)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1806
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      M_X = TO_ZM(' 123456789.0123 + .00000000000987654321098765 i ')
      OPEN (23,FILE='TEMPFM')
      CALL ZM_WRITE(23,M_X)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL ZM_READ(23,M_Y)
      CLOSE(23)
      CALL ZM_SUB(M_X,M_Y,M_Z)
      CALL ZM_ABS(M_Z,M_A)
      IF (.NOT.(M_A==0)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST54

      END MODULE TEST_C


      MODULE TEST_D
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST55

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 1807
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MAXINT = 31
      CALL FMSET(50)

      NCASE = 1808
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MAXINT = HUGE(MAXINT)
      CALL FMSET(50)

      NCASE = 1809
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      INTMAX = 31
      CALL FMSET(50)

      NCASE = 1810
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      INTMAX = HUGE(INTMAX)
      CALL FMSET(50)

      NCASE = 1811
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      DPMAX = 31
      CALL FMSET(50)

      NCASE = 1812
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      DPMAX = HUGE(DPMAX)
      CALL FMSET(50)

      NCASE = 1813
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      SPMAX = 31
      CALL FMSET(50)

      NCASE = 1814
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      SPMAX = HUGE(SPMAX)
      CALL FMSET(50)

      NCASE = 1815
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MXBASE = 31
      CALL FMSET(50)

      NCASE = 1816
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MXBASE = HUGE(MXBASE)
      CALL FMSET(50)

      NCASE = 1817
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMSET(123456789)
      CALL FMSET(50)

      NCASE = 1818
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MXEXP2 = 31
      CALL FMSET(50)

      NCASE = 1819
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MXEXP2 = HUGE(MXEXP2)
      CALL FMSET(50)

      NCASE = 1820
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MEXPUN = 31
      CALL FMSET(50)

      NCASE = 1821
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MEXPUN = -(HUGE(MEXPUN)/2)
      CALL FMSET(50)

      NCASE = 1822
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MEXPOV = 31
      CALL FMSET(50)

      NCASE = 1823
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MEXPOV = HUGE(MEXPOV)
      CALL FMSET(50)

      NCASE = 1824
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MUNKNO = 31
      CALL FMSET(50)

      NCASE = 1825
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      MUNKNO = HUGE(MUNKNO)
      CALL FMSET(50)

      NCASE = 1826
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      DPEPS = 31
      CALL FMSET(50)

      NCASE = 1827
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      DPEPS = TINY(DPEPS)
      CALL FMSET(50)

      NCASE = 1828
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMACOS(MA,MB)

      NCASE = 1829
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMI2M(2,MB)
      CALL FMSUB_R1(MA,MB)

      NCASE = 1830
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMI2M(2,MB)
      MBLOGS = 0
      CALL FMADD_R2(MA,MB)

      NCASE = 1831
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMI2M(2,MB)
      MBLOGS = 0
      CALL FMSUB_R2(MA,MB)

      NCASE = 1832
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMI2M(2,MB)
      MBLOGS = 0
      CALL FMSUB_R2(MB,MA)

      NCASE = 1833
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' UNDERFLOW ',MA)
      CALL FMI2M(2,MB)
      CALL FMSUB_R1(MB,MA)

      NCASE = 1834
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMBIG(MA)
      CALL FMBIG(MB)
      CALL FMADD_R1(MB,MA)

      NCASE = 1835
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMBIG(MA)
      CALL FMBIG(MB)
      CALL FMADD_R2(MB,MA)

      NCASE = 1836
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMBIG(MA)
      CALL FMBIG(MB)
      MWK(START(MB)) = -1
      CALL FMSUB_R1(MB,MA)

      NCASE = 1837
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMBIG(MA)
      CALL FMBIG(MB)
      MWK(START(MB)) = -1
      CALL FMSUB_R2(MB,MA)

      NCASE = 1838
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 1
      CALL FMBIG(MA)
      CALL FMRATIONAL_POWER(MA,2,3,MB)
      CALL FMI2M(1,MC)
      CALL FMDIV(MC,MB,MA)
      CALL FMATAN2(MA,MB,MC)

      NCASE = 1839
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 1
      CALL FMST2M(' OVERFLOW ',MA)
      CALL FMST2M(' -OVERFLOW ',MB)
      CALL FMATAN2(MA,MB,MC)

      NCASE = 1840
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 1
      CALL FMST2M(' OVERFLOW ',MA)
      CALL FMST2M(' OVERFLOW ',MB)
      CALL FMSUB_R2(MA,MB)

      NCASE = 1841
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 1
      CALL FMBIG(MA)
      CALL FMRATIONAL_POWER(MA,2,3,MB)
      CALL FMCOS(MB,MC)

      NCASE = 1842
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      KRAD = 1
      CALL FMBIG(MA)
      CALL FMRATIONAL_POWER(MA,2,3,MB)
      CALL FMI2M(1,MC)
      CALL FMDIV(MC,MB,MA)
      CALL FMEXP(MA,MC)

      NCASE = 1843
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMST2M(' 9.87654321 ',MA)
      CALL FMADDI(MA,1)
      CALL FMST2M(' 10.87654321 ',MB)
      IF (.NOT.FMCOMP(MA,'==',MB)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1844
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMI2M(0,MA)
      CALL FMI2M(10,MB)
      CALL FMSUB_R2(MA,MB)

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST55

      SUBROUTINE TEST56

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 1845
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.3',MP1)
      CALL FPST2M('13.4',MP2)
      MBLOGS = 0
      CALL FPADD_R1(MP1,MP2)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('25.7',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1846
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('12.3',MP1)
      CALL FPST2M('13.4',MP2)
      MBLOGS = 0
      CALL FPADD_R2(MP1,MP2)
      CALL FPEQ(MP2,MP3)
      CALL FPST2M('25.7',MP4)
      IF (.NOT.FPCOMP(MP3,'==',MP4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1847
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPASIN(MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '-0.1549366595480165482162668772711462026055032526229215'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1848
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPACOS(MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '1.72573298634291316744758856891089764470408795231047443'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1849
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPATAN(MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '-0.1531097611932166866656026454043044303832710577681088'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1850
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '0.94560848060096528389929229868402683067804981169173247'
      CALL FPST2M(ST1,MP1)
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP2)
      CALL FPATAN2(MP1,MP2,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '1.73256418659578182618854912685922800721811839353964281'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1851
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPCOSH_SINH(MP1,MP5,MP3)
      CALL FPEQ(MP5,MP1)
      ST2 = '1.01193059616357146189046397247688618707733939978160410'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-49',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1852
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPCOSH_SINH(MP1,MP3,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '-0.1549307311412463123459415264870282740222134044307085'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-49',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1853
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.94560848060096528389929229868402683067804981169173247'
      CALL FPST2M(ST1,MP1)
      CALL FPCOSH(MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '1.481411250434183525381236609413838568985012681608897254'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-49',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1854
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.94560848060096528389929229868402683067804981169173247'
      CALL FPST2M(ST1,MP1)
      CALL FPSINH(MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '-1.09296811157186613424915073409970877381016076745694536'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-49',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1855
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.28774393113505190047124972239269330732580050085069004'
      CALL FPST2M(ST1,MP1)
      CALL FPCOS_SIN(MP1,MP5,MP3)
      CALL FPEQ(MP5,MP1)
      ST2 = '0.958886564221161298875708475997367442261190043299635289'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
      ENDIF

      NCASE = 1856
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.28774393113505190047124972239269330732580050085069004'
      CALL FPST2M(ST1,MP1)
      CALL FPCOS_SIN(MP1,MP3,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '-0.28378963504000055007660394052727537030693318515060125'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1857
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPDIG(NSTACK,KST)

      NCASE = 1858
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FPST2M(ST1,MP1)
      ST1 = '0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP2)
      CALL FPDIM(MP1,MP2,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '0.1961979460329520811830831348163129844349414342734330'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1859
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '0.3505154639175257731958762886597938144329896907216495'
      CALL FPST2M(ST1,MP1)
      ST1 = '0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP2)
      CALL FPDIM(MP2,MP1,MP5)
      CALL FPEQ(MP5,MP1)
      ST2 = '0.0'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1860
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      ST1 = '0.94560848060096528389929229868402683067804981169173247'
      CALL FPST2M(ST1,MP2)
      CALL FPDIV_R1(MP1,MP2)
      ST2 = '-0.1631938810304448993189068089843600996344185378132402'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1861
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      ST1 = '0.94560848060096528389929229868402683067804981169173247'
      CALL FPST2M(ST1,MP2)
      CALL FPDIV_R2(MP1,MP2)
      CALL FPEQ(MP2,MP1)
      ST2 = '-0.1631938810304448993189068089843600996344185378132402'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1862
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMFLAG(J)
      IF (.NOT.J==0) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1863
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FM_FLAG(J)
      IF (.NOT.J==0) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1864
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPFLAG(J)
      IF (.NOT.J==0) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1865
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '-0.1543175178845736920127931538434808299980482564482165'
      CALL FPST2M(ST1,MP1)
      CALL FPDIVI_R1(MP1,314)
      ST2 = '-4.9145706332666780895793998039325105094919826894336465M-4'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('1.0E-50',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1866
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPDP2M(3.1415926536D0,MP1)
      ST2 = '3.1415926536D0'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPDPM(DSMALL,MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1867
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPDP2M(3.1415926536D0,MP1)
      ST2 = '3.1415926536D0'
      CALL FPST2M(ST2,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQU(MP5,MP4,NDIG,NDIG)
      CALL FPDPM(DSMALL,MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      CALL FMSETVAR(' MBASE = 2 ')
      CALL FMSETVAR(' NDIG = 100 ')

      NCASE = 1868
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '3.1415926536D0'
      CALL FPST2M(ST1,MP1)
      CALL FPEQU_R1(MP1,100,53)
      CALL FPDP2M(3.1415926536D0,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPDPM(DSMALL,MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1869
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPI2M(1,MP1)
      CALL FPDIVI(MP1,3,MP2)
      CALL FPI2M(3,MP3)
      CALL FPDIVI(MP3,7,MP1)
      CALL ZPCOMPLEX(MP2,MP1,ZP1)
      CALL FPI2M(2,MP1)
      CALL FPDIVI(MP1,11,MP2)
      CALL FPI2M(5,MP3)
      CALL FPDIVI(MP3,-13,MP1)
      CALL ZPCOMPLEX(MP2,MP1,ZP2)
      CALL ZPMPY(ZP2,ZP1,ZP3)
      CALL ZP2I2M(677,-151,ZP2)
      CALL ZPDIVI(ZP2,3003,ZP4)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-28 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1870
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('0.1',MP1)
      CALL FPST2M('23.4',MP2)
      CALL FPST2M('34.5',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('5.8731980918960730463350151650813268739874201571164800M-27',&
                  MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1871
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('8.115640517330775M-1',MP1)
      CALL FPST2M('2.00853601446773',MP2)
      CALL FPST2M('1.59735792202923',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('2.0112520048150164306467955877563719782378767062440103M-1',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1872
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.01737835258975M-1',MP1)
      CALL FPST2M('2.00853601446773',MP2)
      CALL FPST2M('1.59735792202923',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('2.2512248738228585976753517954889151150428002974819213M-1',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1873
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPST2M('5.5680052333367',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('2.8619456987740165364092968281459448023932520843535423M-2',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1874
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('4.764360371097952E-01',MP1)
      CALL FPST2M('1.161514683661584E+01',MP2)
      CALL FPST2M('2.937801562768354E-01',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('2.3604503996731113868791517339909092506365724801689105M-5',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1875
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('0.9',MP1)
      CALL FPST2M('23.4',MP2)
      CALL FPST2M('34.5',MP3)
      CALL FPIBTA(MP1,MP2,MP3,MP5)
      CALL FPEQ(MP5,MP3)
      CALL FPST2M('7.3148127865937299821246829407023943740949130742928268M-18',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-28',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      CALL FMSET(50)

      NCASE = 1876
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      ST1 = '1.3505154639175257731958762886597938144329896907216495E+16'
      CALL FPST2M(ST1,MP1)
      CALL FPFORM('F53.33',MP1,ST2)
      CALL FPST2M(ST2,MP1)
      ST1 = '13505154639175257.731958762886597938144329896907216'
      CALL FPST2M(ST1,MP3)
      CALL FPSUB(MP1,MP3,MP4)
      CALL FPABS(MP4,MP5)
      CALL FPEQ(MP5,MP4)
      CALL FPST2M('0',MP2)
      IF (.NOT.FPCOMP(MP4,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1877
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPFPRINT(' F12.7 ',MP1)

      NCASE = 1878
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','0','5','0','8','1' /)
      CALL FPINP(LINE,MP1,1,10)
      CALL FPFPRINT(' F14.9 ',MP1)

      NCASE = 1879
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPDP2M(3.1415926536D0,MP1)
      CALL FPINT(MP1,MP4)
      CALL FPI2M(3,MP2)
      IF (.NOT.FPCOMP(MP4,'EQ',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1880
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('23.4',MP1)
      CALL FPIPOWER(MP1,3141,MP3)
      CALL FPST2M('5.09340400268261822666046780299885179315709583071835M+4300',&
                  MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST56

      SUBROUTINE TEST57

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 1881
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('23.4',MP1)
      CALL FPLOG10(MP1,MP3)
      CALL FPST2M('1.36921585741014283901029985917705207599817679823056854M+0',&
                  MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1882
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPLNI(314159,MP3)
      CALL FPST2M('1.26576545061554068013063698538579804967961002514885554M+1',&
                  MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1883
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.26576545061554068013063698538579804967961002514885554M+1',&
                  MP4)
      CALL FPM2DP(MP4,D4)
      D3 = 12.6576545061554068013063698538D0
      IF (.NOT.(ABS((D3-D4)/D3) <= DSMALL)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1884
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.26576545061554068013063698538579804967961002514885554M+1',&
                  MP4)
      CALL FPM2I(MP4,J4)
      J3 = 12
      IF (.NOT.(J3 == J4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1885
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.26576545061554068013063698538579804967961002514885554M+1',&
                  MP4)
      CALL FPM2SP(MP4,R4)
      R3 = 12.6576545061554068013063698538D0
      IF (.NOT.(ABS((R3-R4)/R3) <= RSMALL)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1886
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMAX(MP1,MP2,MP3)
      CALL FPEQ(MP2,MP4)
      IF (.NOT.(FPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1887
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMIN(MP1,MP2,MP3)
      CALL FPEQ(MP1,MP4)
      IF (.NOT.(FPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1888
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMOD(MP2,MP1,MP3)
      CALL FPST2M('4.84728666594576M-2',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1889
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMPY_R1(MP2,MP1)
      CALL FPEQ(MP2,MP3)
      CALL FPST2M('1.8935316137265192583672271140224',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1890
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMPY_R2(MP2,MP1)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('1.8935316137265192583672271140224',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1891
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPMPYI_R1(MP1,3141)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('3.0184261058771671752M+3',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1892
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPNINT(MP2,MP3)
      CALL FPST2M('2',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1893
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPOUT(MP2,LINE2,80)
      WRITE (22,*) LINE2

      NCASE = 1894
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPPRINT(MP2)

      NCASE = 1895
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPPOWER(MP1,MP2,MP3)
      CALL FPST2M('9.2456296989927890349870950485447101281994309260378M-1',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1896
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.2456296989927890349870950485447101281994309260378M-1',MP1)
      OPEN (23,FILE='TEMPFM')
      CALL FPWRITE(23,MP1)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL FPREAD(23,MP2)
      CLOSE(23)
      IF (.NOT.FPCOMP(MP1,'==',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1897
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M(' 8765432 ',MP1)
      OPEN (23,FILE='TEMPFM')
      CALL IPWRITE(23,MP1)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL IPREAD(23,MP2)
      CLOSE(23)
      IF (.NOT.IPCOMPARE(MP1,'==',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1898
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M(' 8765432 - 3.1415926535 i ',ZP1)
      OPEN (23,FILE='TEMPFM')
      CALL ZPWRITE(23,ZP1)
      CLOSE(23)
      OPEN (23,FILE='TEMPFM')
      CALL ZPREAD(23,ZP2)
      CLOSE(23)
      CALL ZPSUB(ZP1,ZP2,ZP3)
      CALL ZPABS(ZP3,MP1)
      IF (.NOT.(MWK(START(MP1)+3)==0)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF
      CALL FPSET(50)
      CALL ZPSET(50)
      CALL FPSETVAR(' KROUND = 1 ')

      NCASE = 1899
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPRATIONAL_POWER(MP1,-17,3,MP3)
      CALL FPST2M('1.2530311443238039320917124735975084865516365445493',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1900
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('1.970425178583792',MP2)
      CALL FPSIGN(MP1,MP2,MP3)
      CALL FPST2M('9.6097615596216720E-01',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1901
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('-1.970425178583792',MP2)
      CALL FPSIGN(MP1,MP2,MP3)
      CALL FPST2M('-9.6097615596216720E-01',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1902
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPSP2M(9.6097615596216720E-01,MP1)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('9.6097615596216720E-01',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPDP2M(DBLE(RSMALL),MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1903
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('-1.970425178583792',MP1)
      CALL FPSQR(MP1,MP3)
      CALL FPST2M('3.882575384396968595370765099264',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1904
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('-1.970425178583792',MP1)
      CALL FPSQR_R1(MP1)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('3.882575384396968595370765099264',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1905
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP1)
      CALL FPSQRT(MP1,MP3)
      CALL FPST2M('1.4037183401892959523361955370723206435382400513186',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1906
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP1)
      CALL FPSQRT_R1(MP1)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('1.4037183401892959523361955370723206435382400513186',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1907
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('-1.970425178583792',MP2)
      CALL FPSUB_R1(MP1,MP2)
      CALL FPEQ(MP1,MP3)
      CALL FPST2M('2.9314013345459592',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1908
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('9.6097615596216720E-01',MP1)
      CALL FPST2M('-1.970425178583792',MP2)
      CALL FPSUB_R2(MP1,MP2)
      CALL FPEQ(MP2,MP3)
      CALL FPST2M('2.9314013345459592',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1909
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP1)
      CALL FPTAN(MP1,MP3)
      CALL FPST2M('-2.367672024680099040477317736673741484868333249781053',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1910
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('1.970425178583792',MP1)
      CALL FPTANH(MP1,MP3)
      CALL FPST2M('0.96187741826338453069125363260768470953417284943678332',MP4)
      CALL FPSUB(MP3,MP4,MP1)
      CALL FPDIV(MP1,MP4,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1911
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('0.970425178583792',MP1)
      CALL FPULP(MP1,MP4)
      CALL FPST2M('1.0E-49',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST57

      SUBROUTINE TEST58

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')
      CALL FMSETVAR(' KDEBUG = 1 ')
      CALL FMSETVAR(' NTRACE = 0 ')

      NCASE = 1912
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPBIG(MP1)

      NCASE = 1913
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('1',MP2)
      CALL IPADD(MP1,MP2,MP3)
      CALL FMSETVAR(' NTRACE = -2 ')

      NCASE = 1914
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('-97042517858374251785837425178583792',MP1)
      CALL IPABS(MP1,MP4)
      CALL IPST2M('97042517858374251785837425178583792',MP3)
      IF (.NOT.(IPCOMPARE(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1915
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('-97042517858374251785837425178583792',MP1)
      CALL IPST2M('9618774182633845306912536326076847095',MP2)
      CALL IPADD(MP1,MP2,MP4)
      CALL IPST2M('9521731664775471055126698900898263303',MP3)
      IF (.NOT.(IPCOMPARE(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1916
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('9618774182633845306912536326076847095',MP1)
      CALL IPST2M('97042517858374251785837425178583792',MP2)
      CALL IPDIM(MP1,MP2,MP4)
      CALL IPST2M('9521731664775471055126698900898263303',MP3)
      IF (.NOT.(IPCOMPARE(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1917
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('97042517858374251785837425178583792',MP2)
      CALL IPDIV(MP1,MP2,MP4)
      CALL IPST2M('9911917368706',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1918
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPDIVI(MP1,141421356,MP4)
      CALL IPST2M('6801500462655615681490949353260002232803',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1919
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('8374251785837425178583792',MP2)
      CALL IPDIVR(MP1,MP2,MP4,MP5)
      CALL IPST2M('114861296610416734545911',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1920
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('8374251785837425178583792',MP2)
      CALL IPDIVR(MP1,MP2,MP5,MP4)
      CALL IPST2M('3666412140861684892372583',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1921
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPDVIR(MP1,314159,MP4,K)
      CALL IPST2M('3061753501454309858037853950596202993790013',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1922
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPDVIR(MP1,314159,MP4,K)
      CALL IPI2M(K,MP4)
      CALL IPST2M('153028',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1923
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPFACT(42,MP1)
      CALL IPST2M('1405006117752879898543142606244511569936384000000000',MP3)
      IF (.NOT.(IPCOMP(MP1,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1924
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPFORM('I60',MP1,ST1)
      WRITE (22,*) TRIM(ST1)
      CALL IPFORM('I65',MP1,ST1)
      WRITE (22,*) TRIM(ST1)
      CALL IPFORM('I70',MP1,ST1)
      WRITE (22,*) TRIM(ST1)
      CALL IPFPRINT('I55',MP1)

      NCASE = 1925
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPFM2I(MP1,MP4)
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1926
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('501617681971661768197016151614655',MP2)
      CALL IPGCD(MP1,MP2,MP4)
      CALL IPST2M('2995',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1927
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPI2FM(MP1,MP4)
      CALL FPST2M('961877418263384530691314159265352536326076847095',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1928
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','2','7','3','2','0','5','0','8','1' /)
      CALL IPINP(LINE,MP1,1,10)
      CALL IPFPRINT(' I19 ',MP1)

      NCASE = 1929
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('9618774',MP1)
      CALL IPM2I(MP1,J)
      IF (.NOT.(J==9618774)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1930
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352',MP1)
      CALL IPST2M('501617681971661768197016151614655',MP2)
      CALL IPMAX(MP1,MP2,MP4)
      CALL IPEQ(MP1,MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1931
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352',MP1)
      CALL IPST2M('501617681971661768197016151614655',MP2)
      CALL IPMIN(MP1,MP2,MP4)
      CALL IPEQ(MP2,MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1932
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159265352536326076847095',MP1)
      CALL IPST2M('501617681971661768197016151614655',MP2)
      CALL IPMOD(MP1,MP2,MP4)
      CALL IPST2M('145259323199683353738381582948755',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1933
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPST2M('501617681971661768197016151',MP2)
      CALL IPMPY(MP1,MP2,MP4)
      CALL IPST2M('482494720890165508515231424715486981447117196737982009',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1934
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('9618774182633845306913141592653525363260768479',MP1)
      CALL IPMPYI(MP1,27182818,MP4)
      CALL IPST2M('261465387989634577617974069721330917007901356104793822',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1935
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPST2M('501617681971661768197016151',MP2)
      CALL IPST2M('890165508515231424715486981',MP3)
      CALL IPMPY_MOD(MP1,MP2,MP3,MP4)
      CALL IPST2M('858797890729021380597497877',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1936
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPPRINT(MP1)
      CALL IPOUT(MP1,LINE2,80)
      WRITE (22,*) LINE2

      NCASE = 1937
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPST2M('501617681971661768197016151',MP2)
      CALL IPST2M('890165508515231424715486981',MP3)
      CALL IPPOWER_MOD(MP1,MP2,MP3,MP4)
      CALL IPST2M('633132741667454490327909790',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1938
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('3',MP1)
      CALL IPST2M('99',MP2)
      CALL IPPOWER(MP1,MP2,MP4)
      CALL IPST2M('171792506910670443678820376588540424234035840667',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1939
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPST2M('-501617681971661768197016151',MP2)
      CALL IPSIGN(MP1,MP2,MP4)
      CALL IPST2M('-961877418263384530691314159',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1940
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPSQR(MP1,MP4)
      CALL IPST2M('925208167765033988714377447579006734179035806433877281',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1941
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL IPST2M('961877418263384530691314159',MP1)
      CALL IPST2M('-501617681971661768197016151',MP2)
      CALL IPSUB(MP1,MP2,MP4)
      CALL IPST2M('1463495100235046298888330310',MP3)
      IF (.NOT.(IPCOMP(MP4,'==',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST58

      SUBROUTINE TEST59

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 1942
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPACOS(ZP1,ZP4)
      CALL ZPST2M('0.70600062465538060328041859335986022136042273675348823497' &
       // ' - 0.71156604883917677179467491357721581085120933977853167363 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1943
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      C2 = ( 411.11D0 , 421.21D0 )
      CALL ZPZ2M(C2,ZP1)
      CALL ZPM2Z(ZP1,C3)
      IF (.NOT.(ABS(C2-C3)<=10*RSMALL)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1944
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M(' UNKNOWN + UNKNOWN i',ZP1)
      CALL ZPABS(ZP1,MP1)

      NCASE = 1945
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPST2M('.806032804185933598602213 - .677179467491357721581085 i',ZP2)
      CALL ZPADD(ZP1,ZP2,ZP4)
      CALL ZPST2M('1.767910222449318129295372 - .175561785519695959610924 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1946
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPADDI(ZP1,23)
      CALL ZPEQ(ZP1,ZP4)
      CALL ZPST2M('23.961877418263384530693159 + .501617681971661761970161 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1947
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPARG(ZP1,MP2)
      CALL FPST2M('.480698159960890424820899647062999936490174031143315855',MP3)
      CALL FPSUB(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1948
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPASIN(ZP1,ZP4)
      CALL ZPST2M('0.86479570213951601595090309827989122073816196293406467551' &
       // ' + 0.71156604883917677179467491357721581085120933977853167363 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1949
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPATAN(ZP1,ZP4)
      CALL ZPST2M('0.83122857933580380367837122090555657350450640595902544783' &
       // ' + 0.24920779958101410179847467515196375836302942974441567571 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1950
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOSH_SINH(ZP1,ZP4,ZP5)
      CALL ZPST2M('1.31467350963913258828454157251213529780144052082464935752' &
       // ' + 0.53720666283416318345036206080606650334019117579553972797 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1951
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOSH_SINH(ZP1,ZP4,ZP5)
      CALL ZPEQ(ZP5,ZP4)
      CALL ZPST2M('.979580485714651735857744392650346362731955914349750961769' &
       // ' + 0.72097329329143451318183379449877600176209183488881542857 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1952
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOSH_SINH(ZP1,ZP4,ZP5)
      CALL ZPEQ(ZP5,ZP4)
      CALL FPST2M('.979580485714651735857744392650346362731955914349750962',MP1)
      CALL FPST2M('.720973293291434513181833794498776001762091834888815429',MP2)
      CALL ZPCOMPLEX(MP1,MP2,ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1953
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOSH_SINH(ZP1,ZP4,ZP5)
      CALL ZPEQ(ZP5,ZP4)
      CALL FPST2M('.979580485714651735857744392650346362731955914349750962',MP1)
      CALL FPST2M('-.72097329329143451318183379449877600176209183488881543',MP2)
      CALL ZPCOMPLEX(MP1,MP2,ZP5)
      CALL ZPCONJUGATE(ZP5,ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1954
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOSH(ZP1,ZP4)
      CALL ZPST2M('1.31467350963913258828454157251213529780144052082464935752' &
       // ' + 0.53720666283416318345036206080606650334019117579553972797 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1955
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPSINH(ZP1,ZP4)
      CALL ZPST2M('.979580485714651735857744392650346362731955914349750961769' &
       // ' + 0.72097329329143451318183379449877600176209183488881542857 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1956
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOS_SIN(ZP1,ZP4,ZP5)
      CALL ZPST2M('.645463644587284986570788327890260087314797257046253121008' &
       // ' - 0.42893405213103227551382784541030693750489674471244174226 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1957
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOS_SIN(ZP1,ZP4,ZP5)
      CALL ZPEQ(ZP5,ZP4)
      CALL ZPST2M('.925646878732852518234454333124909696895019818561899130649' &
       // ' + 0.29910038367448814287423577861472924609286011958848280525 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1958
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPCOS(ZP1,ZP4)
      CALL ZPST2M('.645463644587284986570788327890260087314797257046253121008' &
       // ' - 0.42893405213103227551382784541030693750489674471244174226 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1959
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPSIN(ZP1,ZP4)
      CALL ZPST2M('.925646878732852518234454333124909696895019818561899130649' &
       // ' + 0.29910038367448814287423577861472924609286011958848280525 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1960
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPST2M('.806032804185933598602213 - .677179467491357721581085 i',ZP2)
      CALL ZPDIV(ZP1,ZP2,ZP4)
      CALL ZPST2M('.393065886385899116192752703080718648267156986016216110380' &
       // ' + .952559034342193734113670482385007317974710202767761766583 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1961
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPDIVI(ZP1,17,ZP3)
      CALL ZPEQU(ZP3,ZP4,NDIG,NDIG)
      CALL ZPST2M('.056581024603728501805479941176470588235294117647058823529' &
       // ' + .029506922468921280115891823529411764705882352941176470588 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1962
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPEXP(ZP1,ZP4)
      CALL ZPST2M('2.29425399535378432414228596516248166053339643517440031928' &
       // ' + 1.25817995612559769663219585530484250510228301068435515654 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1963
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      STZ1 = '7.699115044247787610619469026548672566371681415929204e+3 '  &
       //'- 5.221238938053097345132743362831858407079646017699115M+3 i'
      CALL ZPST2M(STZ1,ZP1)
      CALL ZPFORM('F53.33','F50.30',ZP1,STZ2)
      CALL ZPFPRINT('F53.33','F50.30',ZP1)
      CALL ZPST2M(STZ2,ZP1)
      STZ1 = '7699.115044247787610619469026548673 - 5221.238938053097345132743362831858 i'
      CALL ZPST2M(STZ1,ZP3)
      CALL ZPSUB(ZP1,ZP3,ZP4)
      CALL ZPABS(ZP4,MP1)
      CALL FPI2M(10,MP2)
      CALL FPIPOWER(MP2,-30,MP5)
      CALL FPEQ(MP5,MP2)
      IF (.NOT.FPCOMP(MP1,'LE',MP2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1964
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPIMAG(ZP1,MP2)
      CALL FPST2M('.501617681971661761970161',MP3)
      CALL FPSUB(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1965
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('961.877418263384530693159 - 50161.7681971661761970161 i',ZP1)
      CALL ZPINT(ZP1,ZP4)
      CALL ZPST2M('961 - 50161 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1966
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPIPOWER(ZP1,-17,ZP3)
      CALL ZPEQU(ZP3,ZP4,NDIG,NDIG)
      CALL ZPST2M('-0.0783198382158008596797674342388290245832366478080809199' &
       // ' - 0.23802087499028856650937161618337776943798676633749916344 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPEQU_R1(ZP2,NDIG,NDIG)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1967
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPLOG10(ZP1,ZP4)
      CALL ZPST2M('0.03535658255837767759890583679877500609113178092547835860' &
       // ' + 0.20876455833206137887867112816112836681425288379320453778 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1968
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPLN(ZP1,ZP4)
      CALL ZPST2M('0.08141153993813371843860406013667319698707451321662014634' &
       // ' + 0.48069815996089042482089964706299993649017403114331585543 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1969
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZP2I2M(311,242,ZP1)
      CALL ZPLN(ZP1,ZP4)
      CALL ZPST2M('5.97650870861072332214638522053994842350413381557547832020' &
       // ' + 0.66126573728680700894734815861149103459820486160667323526 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1970
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZP2I2M(0,1,ZP2)
      CALL ZPI2M(242,ZP1)
      CALL ZPMPY(ZP2,ZP1,ZP3)
      CALL ZPI2M(311,ZP2)
      CALL ZPADD(ZP2,ZP3,ZP1)
      CALL ZPLN(ZP1,ZP4)
      CALL ZPST2M('5.97650870861072332214638522053994842350413381557547832020' &
       // ' + 0.66126573728680700894734815861149103459820486160667323526 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1971
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      LINE = (/ '1','.','7','3','2','-','5','.','8','i' /)
      CALL ZPINP(LINE,ZP3,1,10)
      CALL ZPFPRINT(' F14.9 ',' F14.9 ',ZP3)

      NCASE = 1972
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZP2I2M(0,1,ZP2)
      CALL ZPI2M(242,ZP1)
      CALL ZPMPY(ZP2,ZP1,ZP3)
      CALL ZPI2M(311,ZP2)
      CALL ZPADD(ZP2,ZP3,ZP1)
      CALL ZPM2I(ZP1,K)
      CALL ZPI2M(K,ZP4)
      CALL ZPI2M(311,ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1973
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPST2M('.806032804185933598602213 - .677179467491357721581085 i',ZP2)
      CALL ZPMPY(ZP1,ZP2,ZP4)
      CALL ZPST2M('1.114989947487781115990363612078996929155913365552' &
       // ' - 0.247043331062694339517150562789101008517858731222 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1974
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPMPYI(ZP1,63387,ZP4)
      CALL ZPST2M('60970.523911461155247047269533 + 31796.040007137724106002595307 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1975
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('7.46187741826338453069315 - 11.5016176819716617619701 i',ZP1)
      CALL ZPNINT(ZP1,ZP4)
      CALL ZPST2M('7 - 12 I',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1976
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('7.4618774182633845306931 - 11.5016176819716617619701 i',ZP1)
      CALL ZPOUT(ZP1,LINE3,160,L1,L2)
      WRITE (22,*) LINE3(1:L1)
      WRITE (22,*) LINE3(L1+1:L2)
      CALL ZPPRINT(ZP1)

      NCASE = 1977
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPST2M('.806032804185933598602213 - .677179467491357721581085 i',ZP2)
      CALL ZPPOWER(ZP1,ZP2,ZP4)
      CALL ZPST2M('1.39775982163051551688131453335764913350785862824257646215' &
       // ' + 0.48240656957195221898158057319722954101453374897327805790 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1978
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPREAL(ZP1,MP4)
      CALL FPST2M('0.961877418263384530693159',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1979
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPRATIONAL_POWER(ZP1,2,3,ZP4)
      CALL ZPST2M('1.00202360107782552892042821152548849581875484236296485859' &
       // ' + 0.33257768446397834834871578362882211629744208653087094696 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1980
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPSQR(ZP1,ZP4)
      CALL ZPST2M('0.67358786889841078726210758566713980197275503336' &
       // ' + 0.964989441780331005053370946075151648549609657198 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1981
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPSQRT(ZP1,ZP4)
      CALL ZPST2M('1.01160631388938404645144168377130820925509481210302287649' &
       // ' + 0.24793127281059658860683266919655766045064329364530970818 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1982
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPTAN(ZP1,ZP4)
      CALL ZPST2M('0.78117053617929045357436659926266970251614000121758973149' &
       // ' + 0.98250464217661207723158350609409132905007077433947956202 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1983
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL ZPST2M('.961877418263384530693159 + .501617681971661761970161 i',ZP1)
      CALL ZPTANH(ZP1,ZP4)
      CALL ZPST2M('0.83052827119349045667199695567558847711641456190882938853' &
       // ' + 0.20903134528783898803996574942036149916960793736034264482 i',ZP3)
      CALL ZPSUB(ZP4,ZP3,ZP2)
      CALL ZPABS(ZP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST59

      SUBROUTINE TEST60

!  Test packed array routines and error messages.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 1984
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPBERN(6,MP1,MP4)
      CALL FPST2M('.018139938530080584064122845276611475515756237384957075',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1985
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.76187741826338453069315950161768197166176197016819E-30',MP1)
      CALL FPBERN(56,MP1,MP4)
      CALL FPST2M('-2.1712568779835074200430675247025298102245771733788731',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1986
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPBERNOULLI(754,MP4)
      CALL FPST2M('2.46143453963085054575745389497735050525111549008129322M+1242',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP4)
      CALL FPABS(MP4,MP2)
      CALL FPEQ(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1987
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('UNKNOWN',MP1)
      CALL FPST2M('.384530693159501617681971661761970168197166161761877418',MP2)
      CALL FPBETA(MP1,MP2,MP4)

      NCASE = 1988
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPST2M('.384530693159501617681971661761970168197166161761877418',MP2)
      CALL FPBETA(MP1,MP2,MP4)
      CALL FPST2M('2.99150917174738777323834998550737132112608848764083126',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1989
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPCMBI(52,7,MP4)
      CALL FPST2M('133784560',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1990
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FMSETVAR(' NTRACE = 0 ')
      CALL FPCMBI(152,47,MP4)
      CALL FPST2M('4688795937593084907665736021700474766400',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1991
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPCMBI(524,257,MP4)
      CALL FPST2M('1.7394867054111349048750219854973569921796001236423E156',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF
      CALL FMSETVAR(' NTRACE = 2 ')

      NCASE = 1992
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPST2M('.384530693159501617681971661761970168197166161761877418',MP2)
      CALL FPCOMB(MP1,MP2,MP4)
      CALL FPST2M('1.16776225886340871791424789455418366405513640340362234',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1993
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPEULER(MP4)
      CALL FPST2M('0.57721566490153286060651209008240243104215933593992360',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1994
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPFACT(MP1,MP4)
      CALL FPST2M('0.92181747044639815204253427093098440709300519155172509',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1995
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPST2M('.384530693159501617681971661761970168197166161761877418',MP2)
      CALL FPIGM1(MP1,MP2,MP4)
      CALL FPST2M('0.54012222681292420650853318537501826484216332470115287',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1996
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPST2M('.384530693159501617681971661761970168197166161761877418',MP2)
      CALL FPIGM2(MP1,MP2,MP4)
      CALL FPST2M('0.66980662571505767554186612265050822469259270495177049',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1997
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPLNGM(MP1,MP4)
      CALL FPST2M('0.19056155831623627284176293227248235560520674439064473',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1998
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPPGAM(12,MP1,MP4)
      CALL FPST2M('-1.6437610934504989650413401960008051459064634656830e10',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 1999
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPPSI(MP1,MP4)
      CALL FPST2M('-1.0560385061434708930901856824702932941189426061196201',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPABS(MP2,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2000
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPPOCH(MP1,19,MP4)
      CALL FPST2M('4.96330494211633715298220189277411152814525032466164E16',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST60

      SUBROUTINE TEST61

!  Test special functions BESJ, ..., SI.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing special functions Bessel J, ..., Sine integral.')")

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2001
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPBESJ(1,MP1,MP4)
      CALL FPST2M('0.35395934550649481043706011910726694906877434623666577',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2002
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_BESJ(1,M_A,M_C)
      M_D = TO_FM('0.025076313747902851151016887592625714022097197246242295753')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2003
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = BESSEL_J(1,M_A)
      M_D = TO_FM('0.580613481388098517450802341770789762709610311496482470588')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2004
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPBESJ(2,MP1,MP4)
      CALL FPST2M('-.01952848241900729944980296190098199680508467281412306',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2005
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPBESY(1,MP1,MP4)
      CALL FPST2M('-1.0229628883608938340543466176704780443299917729340212',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2006
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPBESY(3,MP1,MP4)
      CALL FPST2M('.019458484184348814542380224640044909138243842997041552',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2007
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_BESY(1,M_A,M_C)
      M_D = TO_FM('0.415283138512818266781669706694859586834446116171226914427')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2008
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = BESSEL_Y(1,M_A)
      M_D = TO_FM('-0.24596633539686028736976213837495696096219154732970115661')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2009
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPC(MP1,MP4)
      CALL FPST2M('0.70093080766765024647108053129311787400047652090339761',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2010
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPC(MP1,MP4)
      CALL FPST2M('0.50039725503716926991543653820001681893864568953849831',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2011
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_C(M_A,M_C)
      M_D = TO_FM('0.474185047305100802036571447978041504166048152999958048195')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2012
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = FRESNEL_C(M_A)
      M_D = TO_FM('0.323694749294869464549126969706085301507654288830977216874')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2013
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = FRESNEL_C(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == FRESNEL_C(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2014
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = FRESNEL_C(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == FRESNEL_C(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2015
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPCI(MP1,MP4)
      CALL FPST2M('0.16359653190526440803969970201664214390677012794223332',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2016
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPCI(MP1,MP4)
      CALL FPST2M('0.00131149972931578659459371814940608018872333303675684',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2017
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_CI(M_A,M_C)
      M_D = TO_FM('-0.09741800567259753506641387590335440898467110400622055004')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2018
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = COS_INTEGRAL(M_A)
      M_D = TO_FM('0.461138635729125521212988221957593798317545122640768597596')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2019
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = COS_INTEGRAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == COS_INTEGRAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2020
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = COS_INTEGRAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == COS_INTEGRAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2021
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPCHI(MP1,MP4)
      CALL FPST2M('0.45391567917918361783871059919514892434083540938287730',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2022
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPCHI(MP1,MP4)
      CALL FPST2M('4.97524761172698478085053978815976047476478376994146601603E+327',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2023
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_CHI(M_A,M_C)
      M_D = TO_FM('8.369873724415932287335807611146084488445255497226133667162')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2024
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = COSH_INTEGRAL(M_A)
      M_D = TO_FM('2.029389481780475855055661101690384319730636141596070218552')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2025
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = COSH_INTEGRAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == COSH_INTEGRAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2026
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = COSH_INTEGRAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == COSH_INTEGRAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2027
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPEI(MP1,MP4)
      CALL FPST2M('1.24079391564823418645696678687520762323754599014641389',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2028
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPEI(MP1,MP4)
      CALL FPST2M('9.95049522345396956170107957631952094952956753988293203207e327',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2029
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('-76.187741826338453069315950161768197166176197016819716',MP1)
      CALL FPEI(MP1,MP4)
      CALL FPST2M('-1.0582953867286369384402649747001954422153942812201779081e-35',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2030
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_EI(M_A,M_C)
      M_D = TO_FM('16.74474823903927976564480561675304621451626105015241561691')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2031
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = EXP_INTEGRAL_EI(M_A)
      M_D = TO_FM('4.126976466117941107497767353354627810661198867641799416837')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2032
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = EXP_INTEGRAL_EI(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == EXP_INTEGRAL_EI(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2033
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = EXP_INTEGRAL_EI(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == EXP_INTEGRAL_EI(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2034
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPEN(2,MP1,MP4)
      CALL FPST2M('0.21311259166852101417208662675364586968103289659979351',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2035
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_EN(1,M_A,M_C)
      M_D = TO_FM('0.005000790207415190973190394460877237625750055700148282582')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2036
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = EXP_INTEGRAL_EN(2,M_A)
      M_D = TO_FM('0.051264349837010471403529969401060258628812446447171003753')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2037
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPERF(MP1,MP4)
      CALL FPST2M('0.71872401755779946235619478212012889850923788333405962',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2038
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_ERF(M_A,M_C)
      M_D = TO_FM('0.999999902573705653018913609266972468861889295927486074244')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2039
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = ERF(M_A)
      M_D = TO_FM('0.987349264543733922694659969705283287445319385344849039875')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2040
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = ERF(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ERF(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2041
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = ERF(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ERF(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2042
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPERFC(MP1,MP4)
      CALL FPST2M('0.28127598244220053764380521787987110149076211666594038',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2043
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_ERFC(M_A,M_C)
      M_D = TO_FM('9.742629434698108639073302753113811070407251392575621797281293e-8')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2044
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = ERFC(M_A)
      M_D = TO_FM('0.012650735456266077305340030294716712554680614655150960125')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2045
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = ERFC(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == ERFC(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2046
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = ERFC(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == ERFC(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2047
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPLERC(MP1,MP4)
      CALL FPST2M('-1.2684189477137498562516625540971134601277248866639213',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2048
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.76187741826338453069315950161768197166176197016819e166',MP1)
      CALL FPLERC(MP1,MP4)
      CALL FPST2M('-5.80457200459680176440663633717748607007309664599M+331',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-47 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2049
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('7618.77418263384530693159501617681971661761970168197166',MP1)
      CALL FPLERC(MP1,MP4)
      CALL FPST2M('-5.80457295567037365018902816623993644716703242747682e7',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2050
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_LERC(M_A,M_C)
      M_D = TO_FM('-16.1441697002365667213529634391734146510026147989134315461')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2051
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = LOG_ERFC(M_A)
      M_D = TO_FM('-4.37003992666334136276330328324363949591706428743873191723')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2052
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = LOG_ERFC(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == LOG_ERFC(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2053
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = LOG_ERFC(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == LOG_ERFC(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2054
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPLI(MP1,MP4)
      CALL FPST2M('-0.9793900433217607572331466402453083681659945255591914',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2055
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_LI(M_A,M_C)
      M_D = TO_FM('2.797997089943573501800184831901782240262866606296541185584')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2056
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = LOG_INTEGRAL(M_A)
      M_D = TO_FM('0.668796391754850708354080921181694708542231838607797144120')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2057
      MFMV1 = TO_FM( (/ .121123456789D0, .342123456789D0, .563123456789D0 /) )
      MFMV2 = LOG_INTEGRAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == LOG_INTEGRAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2058
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = LOG_INTEGRAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == LOG_INTEGRAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2059
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPS(MP1,MP4)
      CALL FPST2M('0.21816325134409825621860357629665121608937929116536471',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2060
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPS(MP1,MP4)
      CALL FPST2M('0.50012939294593301301098168046160096978366608125882900',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2061
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_S(M_A,M_C)
      M_D = TO_FM('0.580281902413501913366950218788087272320285927001746179124')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2062
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = FRESNEL_S(M_A)
      M_D = TO_FM('0.486368483997269340556953893768418549490362828623678106725')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2063
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = FRESNEL_S(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == FRESNEL_S(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2064
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = FRESNEL_S(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == FRESNEL_S(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2065
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPSI(MP1,MP4)
      CALL FPST2M('0.73773231897820644930684330520081942495672326643513847',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2066
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPSI(MP1,MP4)
      CALL FPST2M('1.57084866664732825971020846026968465003368780298508651',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2067
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_SI(M_A,M_C)
      M_D = TO_FM('1.798158893955183419022680508529636904015624233443431352508')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2068
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = SIN_INTEGRAL(M_A)
      M_D = TO_FM('1.485583783707077764617204020897763202398558637245905748694')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2069
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = SIN_INTEGRAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == SIN_INTEGRAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2070
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = SIN_INTEGRAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == SIN_INTEGRAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2071
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('.761877418263384530693159501617681971661761970168197166',MP1)
      CALL FPSHI(MP1,MP4)
      CALL FPST2M('0.78687823646905056861825618768005869889671058076353659',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2072
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('761.877418263384530693159501617681971661761970168197166',MP1)
      CALL FPSHI(MP1,MP4)
      CALL FPST2M('4.97524761172698478085053978815976047476478376994146601603E+327',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-49 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2073
      M_A = TO_FM('3.7699115044247787610619469026548672566371681415929204')
      CALL FM_SHI(M_A,M_C)
      M_D = TO_FM('8.374874514623347478308998005606961726071005552926281949744')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2074
      M_A = TO_FM('1.76313747902851151016887592625714022097197246242295753')
      M_C = SINH_INTEGRAL(M_A)
      M_D = TO_FM('2.097586984337465252442106251664243490930562726045729198285')
      M_D = ABS((M_C - M_D)/M_D)
      IF (.NOT.(M_D <= TO_FM('1.0E-49'))) THEN
          CALL ERRPRT_FM('  GAM ',M_A,'M_A',M_C,'M_C',M_D,'M_D')
      ENDIF

      NCASE = 2075
      MFMV1 = TO_FM( (/ .121123456789D0, -.342123456789D0, .563123456789D0 /) )
      MFMV2 = SINH_INTEGRAL(MFMV1)
      DO J = 1, 3
         IF (.NOT.(MFMV2(J) == SINH_INTEGRAL(MFMV1(J)))) THEN
             CALL PRTERR(KW)
             EXIT
         ENDIF
      ENDDO

      NCASE = 2076
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = (-1)**(J+K) * TO_FM(25+3*(J+3*(K-1)))/60
         ENDDO
      ENDDO
      MFMB = SINH_INTEGRAL(MFMA)
      DO J = 1, 3
         DO K = 1, 3
            IF (.NOT.(MFMB(J,K) == SINH_INTEGRAL(MFMA(J,K)))) THEN
                CALL PRTERR(KW)
                EXIT
            ENDIF
         ENDDO
      ENDDO

      NCASE = 2077
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('7.418263384530693159501617681971661761970168197166e+99',MP1)
      CALL FPST2M('6.8259710208460269684650033687802985086166176197016819',MP2)
      CALL FPBETA(MP1,MP2,MP4)
      CALL FPST2M('1.01162064582829378146463715877011489612774362551e-679',MP3)
      CALL FPSUB(MP4,MP3,MP2)
      CALL FPDIV(MP2,MP3,MP5)
      CALL FPABS(MP5,MP4)
      CALL FPST2M(' 1.0E-45 ',MP3)
      IF (.NOT.(FPCOMP(MP4,'<=',MP3))) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2078
      WRITE (22,*) ' '
      WRITE (22,*) ' NCASE = ',NCASE
      WRITE (22,*) ' '
      CALL FPST2M('7.418263384530693159501617681971661761970168197166e+99',MP1)
      CALL FPGAM(MP1,MP4)
      IF (.NOT.(MWK(START(MP4)+2) == MEXPOV)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST61

      SUBROUTINE TEST62

!  Test type (FM) array equal assignments.

      IMPLICIT NONE

      WRITE (KW,"(/' Testing derived-type array operations.')")

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')
      CALL FMSETVAR(' NTRACE = 0 ')

      NCASE = 2079
      MFMV1 = 123
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - 123)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2080
      MFMV1 = 123.45
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - 123.45)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2081
      MFMV1 = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - 123.456789D0)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2082
      MFMV1 = (123.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - 123.67)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2083
      MFMV1 = (123.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - 123.987654D0)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2084
      MFM3 = TO_FM('234.56')
      JV = MFM3
      J5 = 0
      DO J = 1, 3
         J5 = J5 + ABS(JV(J) - 234)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2085
      MFM3 = TO_FM('234.56')
      RV = MFM3
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(RV(J) - 234.56)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2086
      MFM3 = TO_FM('234.56789')
      DV = MFM3
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(DV(J) - 234.56789D0)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2087
      MFM3 = TO_FM('234.56')
      CV = MFM3
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(CV(J) - 234.56)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2088
      MFM3 = TO_FM('234.56789')
      CDV = MFM3
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(CDV(J) - 234.56789D0)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2089
      MFM3 = TO_FM('1234.56789')
      MFMV1 = MFM3
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - TO_FM('1234.56789'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2090
      MIM1 = TO_IM('123456789012345')
      MFMV1 = MIM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - TO_FM('123456789012345'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2091
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MFMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - TO_FM('1234567.89012345'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2092
      MFM3 = TO_FM('1234.56789')
      MIMV1 = MFM3
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - TO_FM('1234'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2093
      MFM3 = TO_FM('1234.56789')
      MZMV1 = MFM3
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - TO_FM('1234.56789'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2094
      JV = (/ 12, -34, 56 /)
      MFMV1 = JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - JV(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2095
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - RV(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2096
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - DV(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2097
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - REAL(CV(J)))
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2098
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - REAL(CDV(J),KIND(0.0D0)))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2099
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      JV = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(JV(J) - INT(MFMV1(J)))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2100
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      RV = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(RV(J) - MFMV1(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2101
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      DV = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(DV(J) - MFMV1(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2102
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      CV = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CV(J) - MFMV1(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2103
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      CDV = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CDV(J) - MFMV1(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2104
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV1 = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - MFMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2105
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(REAL(MZMV1(J)) - MFMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST62

      SUBROUTINE TEST63

!  Test type (IM) array equal assignments.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2106
      MIMV1 = 123
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV1(J) - 123)
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2107
      MIMV1 = 123.45
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - 123)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2108
      MIMV1 = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - 123)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2109
      MIMV1 = (124.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - 124)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2110
      MIMV1 = (125.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - 125)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2111
      MIM1 = TO_FM('234.56')
      JV = MIM1
      J5 = 0
      DO J = 1, 3
         J5 = J5 + ABS(JV(J) - 234)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2112
      MIM1 = TO_FM('234.56')
      RV = MIM1
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(RV(J) - 234)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2113
      MIM1 = TO_FM('234.56789')
      DV = MIM1
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(DV(J) - 234)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2114
      MIM1 = TO_FM('234.56')
      CV = MIM1
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(CV(J) - 234)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2115
      MIM1 = TO_FM('234.56789')
      CDV = MIM1
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(CDV(J) - 234)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2116
      MIM1 = TO_FM('1234.56789')
      MIMV1 = MIM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - 1234)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2117
      MIM1 = TO_IM('123456789012345')
      MIMV1 = MIM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - TO_FM('123456789012345'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2118
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MIMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - TO_FM('1234567'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2119
      MIM1 = TO_FM('1234.56789')
      MZMV1 = MIM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - TO_FM('1234'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2120
      JV = (/ 12, -34, 56 /)
      MIMV1 = JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - JV(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2121
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = RV
      MFM3 = 0
      JV = RV
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - JV(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2122
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = DV
      MFM3 = 0
      JV = DV
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - JV(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2123
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = CV
      MFM3 = 0
      JV = CV
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - JV(J))
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2124
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = CDV
      MFM3 = 0
      JV = CDV
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - JV(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2125
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      JV = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(JV(J) - INT(MIMV1(J)))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2126
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      RV = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(RV(J) - MIMV1(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2127
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      DV = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(DV(J) - MIMV1(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2128
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      CV = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CV(J) - MIMV1(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2129
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      CDV = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CDV(J) - MIMV1(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2130
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = MZMV1
      MFM3 = 0
      JV = (/ 12, -34, 56 /)
      DO J = 1, 3
         MFM3 = MFM3 + ABS(JV(J) - MIMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST63

      SUBROUTINE TEST64

!  Test type (ZM) array equal assignments.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2131
      MZMV1 = 123
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - 123)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2132
      MZMV1 = 123.45
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - 123.45)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2133
      MZMV1 = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - 123.456789D0)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2134
      MZMV1 = (123.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - (123.67 , 987.65 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2135
      MZMV1 = (123.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - (123.987654D0 , 987.123456D0))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2136
      MZM1 = TO_ZM('234.56 - 65.32 i')
      JV = MZM1
      J5 = 0
      DO J = 1, 3
         J5 = J5 + ABS(JV(J) - 234)
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2137
      MZM1 = TO_ZM('234.56 - 65.32 i')
      RV = MZM1
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(RV(J) - 234.56)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2138
      MZM1 = TO_ZM('234.56789 - 765.765432 i')
      DV = MZM1
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(DV(J) - 234.56789D0)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2139
      MZM1 = TO_ZM('234.56 - 65.32 i')
      CV = MZM1
      R5 = 0
      DO J = 1, 3
         R5 = R5 + ABS(CV(J) - MZM1)
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2140
      MZM1 = TO_ZM('234.56789 - 765.765432 i')
      CDV = MZM1
      D5 = 0
      DO J = 1, 3
         D5 = D5 + ABS(CDV(J) - MZM1)
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2141
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MFMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - TO_FM('1234.56789'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2142
      MIM1 = TO_IM('123456789012345')
      MZMV1 = MIM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - TO_FM('123456789012345'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2143
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MZMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - TO_ZM('1234567.89012345 - 31.654 i'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2144
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MIMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - TO_FM('1234'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2145
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MZMV1 = MZM1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - TO_ZM('1234.56789 - 4.374659586'))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2146
      JV = (/ 12, -34, 56 /)
      MZMV1 = JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - JV(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2147
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - RV(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2148
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - DV(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2149
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - CV(J))
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2150
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV1(J) - CDV(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2151
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      JV = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(JV(J) - REAL(INT(MZMV1(J))))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2152
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      RV = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(RV(J) - REAL(MZMV1(J)))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2153
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      DV = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(DV(J) - REAL(MZMV1(J)))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2154
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      CV = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CV(J) - MZMV1(J))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2155
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      CDV = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(CDV(J) - MZMV1(J))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2156
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV1 = MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV1(J) - MZMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2157
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV1 = MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV1(J) - MZMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2158
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - MZMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST64

      SUBROUTINE TEST65

!  Test type (FM) array equal assignments.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')
      CALL FMSETVAR(' NTRACE = 0 ')

      NCASE = 2159
      MFMA = 123
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - 123)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2160
      MFMA = 123.45
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - 123.45)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2161
      MFMA = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - 123.456789D0)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2162
      MFMA = (123.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - 123.67)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2163
      MFMA = (123.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - 123.987654D0)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2164
      MFM3 = TO_FM('234.56')
      JV2 = MFM3
      J5 = 0
      DO J = 1, 3
         DO K = 1, 3
            J5 = J5 + ABS(JV2(J,K) - 234)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2165
      MFM3 = TO_FM('234.56')
      RV2 = MFM3
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(RV2(J,K) - 234.56)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2166
      MFM3 = TO_FM('234.56789')
      DV2 = MFM3
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(DV2(J,K) - 234.56789D0)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2167
      MFM3 = TO_FM('234.56')
      CV2 = MFM3
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(CV2(J,K) - 234.56)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2168
      MFM3 = TO_FM('234.56789')
      CDV2 = MFM3
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(CDV2(J,K) - 234.56789D0)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2169
      MFM3 = TO_FM('1234.56789')
      MFMA = MFM3
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - TO_FM('1234.56789'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2170
      MIM1 = TO_IM('123456789012345')
      MFMA = MIM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - TO_FM('123456789012345'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2171
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MFMA = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - TO_FM('1234567.89012345'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2172
      MFM3 = TO_FM('1234.56789')
      MIMA2 = MFM3
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - TO_FM('1234'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2173
      MFM3 = TO_FM('1234.56789')
      MZMA2 = MFM3
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - TO_FM('1234.56789'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2174
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2175
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - RV2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2176
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - DV2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2177
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - REAL(CV2(J,K)))
         ENDDO
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2178
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFMA = CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - REAL(CDV2(J,K),KIND(0.0D0)))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2179
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      JV2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(JV2(J,K) - INT(MFMA(J,K)))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2180
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      RV2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(RV2(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2181
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(DV2(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2182
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CV2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CV2(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2183
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CDV2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CDV2(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2184
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMA = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2185
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFMA = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(REAL(MZMA2(J,K)) - MFMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST65

      SUBROUTINE TEST66

!  Test type (IM) array equal assignments.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2186
      MIMA2 = 123
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMA2(J,K) - 123)
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2187
      MIMA2 = 123.45
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - 123)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2188
      MIMA2 = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - 123)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2189
      MIMA2 = (124.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - 124)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2190
      MIMA2 = (125.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - 125)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2191
      MIM1 = TO_FM('234.56')
      JV2 = MIM1
      J5 = 0
      DO J = 1, 3
         DO K = 1, 3
            J5 = J5 + ABS(JV2(J,K) - 234)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2192
      MIM1 = TO_FM('234.56')
      RV2 = MIM1
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(RV2(J,K) - 234)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2193
      MIM1 = TO_FM('234.56789')
      DV2 = MIM1
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(DV2(J,K) - 234)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2194
      MIM1 = TO_FM('234.56')
      CV2 = MIM1
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(CV2(J,K) - 234)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2195
      MIM1 = TO_FM('234.56789')
      CDV2 = MIM1
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(CDV2(J,K) - 234)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2196
      MIM1 = TO_FM('1234.56789')
      MIMA2 = MIM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - 1234)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2197
      MIM1 = TO_IM('123456789012345')
      MIMA2 = MIM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - TO_FM('123456789012345'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2198
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MIMA2 = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - TO_FM('1234567'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2199
      MIM1 = TO_FM('1234.56789')
      MZMA2 = MIM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - TO_FM('1234'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2200
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2201
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = RV2
      MFM3 = 0
      JV2 = RV2
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2202
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = DV2
      MFM3 = 0
      JV2 = DV2
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2203
      DO J = 1, 3
         DO K = 1, 3
            CV2(J,K) = CMPLX(12.3+3*(J+3*(K-1)),-32.4+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMA2 = CV2
      MFM3 = 0
      JV2 = CV2
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2204
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIMA2 = CDV2
      MFM3 = 0
      JV2 = CDV2
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2205
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      JV2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(JV2(J,K) - INT(MIMA2(J,K)))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2206
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      RV2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(RV2(J,K) - MIMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2207
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DV2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(DV2(J,K) - MIMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2208
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CV2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CV2(J,K) - MIMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2209
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      CDV2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CDV2(J,K) - MIMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2210
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIMA2 = MZMA2
      MFM3 = 0
      JV2 = RESHAPE( (/(62.3+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(JV2(J,K) - MIMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST66

      END MODULE TEST_D


      MODULE TEST_E
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST67

!  Test type (ZM) array equal assignments.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2211
      MZMA2 = 123
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - 123)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2212
      MZMA2 = 123.45
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - 123.45)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2213
      MZMA2 = 123.456789D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - 123.456789D0)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2214
      MZMA2 = (123.67 , 987.65 )
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - (123.67 , 987.65 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2215
      MZMA2 = (123.987654D0 , 987.123456D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - (123.987654D0 , 987.123456D0))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2216
      MZM1 = TO_ZM('234.56 - 65.32 i')
      JV2 = MZM1
      J5 = 0
      DO J = 1, 3
         DO K = 1, 3
            J5 = J5 + ABS(JV2(J,K) - 234)
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(TO_FM(J5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2217
      MZM1 = TO_ZM('234.56 - 65.32 i')
      RV2 = MZM1
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(RV2(J,K) - 234.56)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2218
      MZM1 = TO_ZM('234.56789 - 765.765432 i')
      DV2 = MZM1
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(DV2(J,K) - 234.56789D0)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2219
      MZM1 = TO_ZM('234.56 - 65.32 i')
      CV2 = MZM1
      R5 = 0
      DO J = 1, 3
         DO K = 1, 3
            R5 = R5 + ABS(CV2(J,K) - MZM1)
         ENDDO
      ENDDO
      MFM4 = RSMALL*234
      IF (.NOT.(TO_FM(R5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2220
      MZM1 = TO_ZM('234.56789 - 765.765432 i')
      CDV2 = MZM1
      D5 = 0
      DO J = 1, 3
         DO K = 1, 3
            D5 = D5 + ABS(CDV2(J,K) - MZM1)
         ENDDO
      ENDDO
      MFM4 = DSMALL*234
      IF (.NOT.(TO_FM(D5) <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2221
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MFMA = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - TO_FM('1234.56789'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2222
      MIM1 = TO_IM('123456789012345')
      MZMA2 = MIM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - TO_FM('123456789012345'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2223
      MZM1 = TO_ZM('1234567.89012345 - 31.654 i')
      MZMA2 = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - TO_ZM('1234567.89012345 - 31.654 i'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2224
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MIMA2 = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - TO_FM('1234'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2225
      MZM1 = TO_ZM('1234.56789 - 4.374659586')
      MZMA2 = MZM1
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - TO_ZM('1234.56789 - 4.374659586'))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2226
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - JV2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2227
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - RV2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2228
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - DV2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2229
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - CV2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*84*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2230
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZMA2 = CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA2(J,K) - CDV2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2231
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      JV2 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(JV2(J,K) - REAL(INT(MZMA2(J,K))))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2232
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      RV2 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(RV2(J,K) - REAL(MZMA2(J,K)))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2233
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DV2 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(DV2(J,K) - REAL(MZMA2(J,K)))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2234
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      CV2 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CV2(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2235
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      CDV2 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(CDV2(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2236
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMA2 = MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMA(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2237
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMA2 = MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMA2(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2238
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMA3 = MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMA3(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST67

      SUBROUTINE TEST68

!  Test type (FM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2239
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4 + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2240
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.8 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.8 + MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2241
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.87D0 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.87D0 + MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2242
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) + MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2243
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) + MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2244
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2245
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2246
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2247
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2248
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2249
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 + JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 + JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2250
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 + RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2251
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 + DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2252
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 + CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2253
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 + CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2254
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = JV + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) + MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2255
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = RV + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) + MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2256
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = DV + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) + MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2257
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CV + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) + MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2258
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CDV + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2259
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2260
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFMV1 + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2261
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MIM2 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIM2 + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2262
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MFMV1 + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2263
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2264
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MFMV1 + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2265
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2266
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MIMV1 + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) + MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2267
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2268
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 + MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST68

      SUBROUTINE TEST69

!  Test type (FM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2269
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = JV + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2270
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2271
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = RV + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2272
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2273
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = DV + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2274
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2275
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2276
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2277
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2278
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2279
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MFMV2 = MFMV1 + MFMV4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + MFMV4(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2280
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MFMV1 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2281
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MIMV1 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2282
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 + MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2283
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2284
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = +MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - MFMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2285
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MIMV2 = +MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - MIMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2286
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = +MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - MZMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2287
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = -MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) + MFMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2288
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MIMV2 = -MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) + MIMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2289
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = -MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) + MZMV1(J))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2290
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = +MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - MFMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2291
      DO J = 1, 2
         DO K = 1, 2
            MIMA(J,K) = TO_IM(257+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB = +MIMA
      MFM3 = 0
      DO J = 1, 2
         DO K = 1, 2
            MFM3 = MFM3 + ABS(MIMB(J,K) - MIMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2292
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = +MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - MZMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2293
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = -MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) + MFMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2294
      DO J = 1, 2
         DO K = 1, 2
            MIMA(J,K) = TO_IM(257+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB = -MIMA
      MFM3 = 0
      DO J = 1, 2
         DO K = 1, 2
            MFM3 = MFM3 + ABS(MIMB(J,K) + MIMA(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2295
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = -MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) + MZMA2(J,K))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST69

      SUBROUTINE TEST70

!  Test type (IM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2296
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MIMV2 = 4 + MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( 4 + MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2297
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.8 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.8 + MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2298
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.87D0 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.87D0 + MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2299
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) + MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2300
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) + MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2301
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + 4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) + 4 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2302
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) + 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2303
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) + 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2304
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2305
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2306
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 + JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( MIM2 + JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2307
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 + RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2308
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 + DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2309
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 + CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2310
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 + CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2311
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = JV + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( JV(J) + MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2312
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = RV + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) + MIM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2313
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = DV + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) + MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2314
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CV + MIM2
      MFM3 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MZMV2(J) - ( CV(J) + MIM2 ))
      ENDDO
      MIM2 = RSMALL*56*3
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2315
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CDV + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2316
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 + MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIM2 + MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2317
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIMV1 + MIM2
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) + MIM2 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2318
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2319
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MIMV1 + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2320
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2321
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 + MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST70

      SUBROUTINE TEST71

!  Test type (IM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2322
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = JV + MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( JV(J) + MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2323
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + JV
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) + JV(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2324
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = RV + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2325
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) + RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2326
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = DV + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2327
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) + DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2328
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2329
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2330
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2331
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2332
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MIMV2 = MIMV1 + MIMV4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) + MIMV4(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2333
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 + MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2334
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST71

      SUBROUTINE TEST72

!  Test type (ZM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2335
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4 + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2336
      MFMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.8 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.8 + MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2337
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.87D0 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.87D0 + MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2338
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.8,5.9) + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) + MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2339
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.87D0,5.98D0) + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) + MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2340
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2341
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2342
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2343
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2344
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2345
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 + JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2346
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2347
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2348
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2349
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2350
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = JV + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) + MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2351
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = RV + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) + MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2352
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = DV + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) + MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2353
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CV + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) + MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2354
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CDV + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2355
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2356
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZMV1 + MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST72

      SUBROUTINE TEST73

!  Test type (ZM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2357
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = JV + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2358
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2359
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = RV + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2360
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2361
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = DV + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2362
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2363
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CV + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2364
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2365
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CDV + MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) + MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2366
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 + CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) + CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2367
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (/ TO_ZM('1.21123456789 + 0.9574635 i') , TO_ZM('-3.42123456789 - 0.54 i') ,  &
                 TO_ZM('5.63123456789 + 0.00345 i') /)
      MZMV4 = MZMV1 + MZMV2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV4(J) - ( MZMV1(J) + MZMV2(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST73

      SUBROUTINE TEST74

!  Test type (FM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2368
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4 + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2369
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4.8 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4.8 + MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2370
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4.87D0 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4.87D0 + MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2371
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) + MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2372
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) + MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2373
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + 4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + 4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2374
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2375
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2376
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2377
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2378
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 + JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2379
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 + RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2380
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 + DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2381
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 + CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2382
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 + CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2383
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = JV2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( JV2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2384
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = RV2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( RV2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2385
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = DV2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( DV2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2386
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = CV2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2387
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = CDV2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2388
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2389
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFMA + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2390
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_IM('121123456789')
      MFMB = MIM2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIM2 + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2391
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_IM('121123456789')
      MFMB = MFMA + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2392
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2393
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MFMA + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2394
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2395
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MIMA2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIMA2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2396
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2397
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MZMA2 + MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST74

      SUBROUTINE TEST75

!  Test type (FM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2398
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = JV2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( JV2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2399
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2400
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = RV2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( RV2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2401
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2402
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = DV2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( DV2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2403
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2404
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CV2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2405
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2406
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CDV2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2407
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2408
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMC(J,K) = TO_FM(55+5*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + MFMC
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + MFMC(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2409
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2410
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MIMA2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIMA2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2411
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2412
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST75

      SUBROUTINE TEST76

!  Test type (IM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2413
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4 + MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( 4 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2414
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4.8 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( 4.8 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2415
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4.87D0 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( 4.87D0 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2416
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2417
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2418
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + 4
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) + 4 ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2419
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) + 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2420
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) + 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2421
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2422
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2423
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 + JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - ( MIM2 + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2424
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIM2 + RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2425
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIM2 + DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2426
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 + CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2427
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 + CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2428
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = JV2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - ( JV2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2429
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = RV2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( RV2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2430
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = DV2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( DV2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2431
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = CV2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MZMB2(J,K) - ( CV2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      MIM2 = RSMALL*56*3
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2432
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = CDV2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2433
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 + MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIM2 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2434
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIMA2 + MIM2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2435
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2436
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MIMA2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2437
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2438
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MZMA2 + MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST76

      SUBROUTINE TEST77

!  Test type (IM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2439
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = JV2 + MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( JV2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2440
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + JV2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2441
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = RV2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( RV2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2442
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) + RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2443
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = DV2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( DV2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2444
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) + DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2445
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CV2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2446
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2447
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CDV2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2448
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2449
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMC2(J,K) = TO_FM(37+11*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 + MIMC2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) + MIMC2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2450
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2451
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST77

      SUBROUTINE TEST78

!  Test type (ZM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2452
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2453
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4.8 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4.8 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2454
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4.87D0 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4.87D0 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2455
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2456
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2457
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + 4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + 4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2458
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2459
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2460
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2461
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2462
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 + JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2463
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2464
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2465
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2466
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2467
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = JV2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( JV2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2468
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = RV2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( RV2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2469
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = DV2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( DV2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2470
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = CV2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2471
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = CDV2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2472
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2473
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZMA2 + MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST78

      END MODULE TEST_E


      MODULE TEST_F
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST79

!  Test type (ZM) array addition operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2474
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = JV2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( JV2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2475
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2476
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = RV2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( RV2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2477
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2478
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = DV2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( DV2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2479
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2480
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CV2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2481
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2482
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CDV2 + MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) + MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2483
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 + CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) + CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2484
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MZMB2(J,K) = CMPLX(TO_FM(48.3+5*(J+3*(K-1))), TO_FM(-31.4+8*(J+3*(K-1))))
         ENDDO
      ENDDO
      MZMC2 = MZMA2 + MZMB2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMC2(J,K) - ( MZMA2(J,K) + MZMB2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST79

      SUBROUTINE TEST80

!  Test type (FM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2485
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4 - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2486
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.8 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.8 - MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2487
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.87D0 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.87D0 - MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2488
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) - MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2489
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) - MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2490
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2491
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2492
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2493
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2494
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2495
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 - JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 - JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2496
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 - RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2497
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 - DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2498
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 - CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2499
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 - CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2500
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = JV - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) - MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2501
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = RV - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) - MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2502
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = DV - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) - MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2503
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CV - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) - MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2504
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CDV - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2505
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2506
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFMV1 - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2507
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MIM2 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIM2 - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2508
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MFMV1 - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2509
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2510
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MFMV1 - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2511
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2512
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MIMV1 - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) - MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2513
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2514
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 - MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST80

      SUBROUTINE TEST81

!  Test type (FM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2515
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = JV - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2516
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2517
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = RV - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2518
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2519
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = DV - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2520
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2521
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2522
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2523
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2524
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2525
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MFMV2 = MFMV1 - MFMV4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - MFMV4(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2526
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MFMV1 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2527
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MIMV1 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2528
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 - MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2529
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST81

      SUBROUTINE TEST82

!  Test type (IM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2530
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MIMV2 = 4 - MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( 4 - MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2531
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.8 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.8 - MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2532
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.87D0 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.87D0 - MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2533
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) - MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2534
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) - MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2535
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - 4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) - 4 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2536
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) - 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2537
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) - 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2538
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2539
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2540
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 - JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( MIM2 - JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2541
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 - RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2542
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 - DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2543
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 - CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2544
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 - CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2545
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = JV - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( JV(J) - MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2546
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = RV - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) - MIM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2547
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = DV - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) - MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2548
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CV - MIM2
      MFM3 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MZMV2(J) - ( CV(J) - MIM2 ))
      ENDDO
      MIM2 = RSMALL*56*3
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2549
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CDV - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2550
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 - MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIM2 - MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2551
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIMV1 - MIM2
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) - MIM2 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2552
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2553
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MIMV1 - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2554
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2555
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 - MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST82

      SUBROUTINE TEST83

!  Test type (IM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2556
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = JV - MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( JV(J) - MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2557
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - JV
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) - JV(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2558
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = RV - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2559
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) - RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2560
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = DV - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2561
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) - DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2562
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2563
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2564
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2565
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2566
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MIMV2 = MIMV1 - MIMV4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) - MIMV4(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2567
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 - MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2568
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST83

      SUBROUTINE TEST84

!  Test type (ZM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2569
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4 - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2570
      MFMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.8 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.8 - MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2571
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.87D0 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.87D0 - MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2572
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.8,5.9) - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) - MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2573
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.87D0,5.98D0) - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) - MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2574
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2575
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2576
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2577
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2578
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2579
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 - JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2580
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2581
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2582
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2583
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2584
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = JV - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) - MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2585
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = RV - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) - MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2586
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = DV - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) - MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2587
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CV - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) - MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2588
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CDV - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2589
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2590
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZMV1 - MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST84

      SUBROUTINE TEST85

!  Test type (ZM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2591
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = JV - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2592
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2593
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = RV - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2594
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2595
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = DV - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2596
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2597
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CV - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2598
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2599
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CDV - MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) - MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2600
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 - CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) - CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2601
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (/ TO_ZM('1.21123456789 + 0.9574635 i') , TO_ZM('-3.42123456789 - 0.54 i') ,  &
                 TO_ZM('5.63123456789 + 0.00345 i') /)
      MZMV4 = MZMV1 - MZMV2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV4(J) - ( MZMV1(J) - MZMV2(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST85

      SUBROUTINE TEST86

!  Test type (FM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2602
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4 - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2603
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4.8 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4.8 - MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2604
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4.87D0 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( 4.87D0 - MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2605
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) - MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2606
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) - MFMA(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2607
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - 4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - 4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2608
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2609
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2610
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2611
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2612
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 - JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2613
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 - RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2614
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 - DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2615
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 - CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2616
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 - CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2617
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = JV2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( JV2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2618
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = RV2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( RV2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2619
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MFMB = DV2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( DV2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2620
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = CV2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2621
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = CDV2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2622
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2623
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFMA - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2624
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_IM('121123456789')
      MFMB = MIM2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIM2 - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2625
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_IM('121123456789')
      MFMB = MFMA - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2626
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2627
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MFMA - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2628
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MFM4 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFM4 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2629
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MFMB = MIMA2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIMA2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2630
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MFM4 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFM4 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2631
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MFM4 = TO_FM('12.1123456789')
      MZMB2 = MZMA2 - MFM4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - MFM4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST86

      SUBROUTINE TEST87

!  Test type (FM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2632
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = JV2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( JV2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2633
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2634
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = RV2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( RV2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2635
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2636
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = DV2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( DV2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2637
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2638
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CV2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2639
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2640
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CDV2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2641
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2642
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMC(J,K) = TO_FM(55+5*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - MFMC
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - MFMC(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2643
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MFMA - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MFMA(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2644
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = MIMA2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MFMB(J,K) - ( MIMA2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2645
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - MFMA(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2646
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MFMA - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MFMA(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST87

      SUBROUTINE TEST88

!  Test type (IM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2647
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4 - MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( 4 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2648
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4.8 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( 4.8 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2649
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = 4.87D0 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( 4.87D0 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2650
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2651
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2652
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - 4
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) - 4 ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2653
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) - 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2654
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) - 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2655
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2656
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2657
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 - JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - ( MIM2 - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2658
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIM2 - RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2659
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIM2 - DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2660
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 - CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2661
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 - CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2662
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = JV2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - ( JV2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2663
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = RV2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( RV2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2664
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = DV2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( DV2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2665
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = CV2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MZMB2(J,K) - ( CV2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      MIM2 = RSMALL*56*3
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2666
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = CDV2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2667
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIM2 - MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIM2 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2668
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MIMB2 = MIMA2 - MIM2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2669
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2670
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MIMA2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2671
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MIM2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIM2 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2672
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MIM2 = TO_FM('12.1123456789')
      MZMB2 = MZMA2 - MIM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - MIM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST88

      SUBROUTINE TEST89

!  Test type (IM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2673
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = JV2 - MIMA2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( JV2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2674
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - JV2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2675
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = RV2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( RV2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2676
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) - RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2677
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = DV2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( DV2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2678
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MIMB2(J,K) - INT( MIMA2(J,K) - DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2679
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CV2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2680
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2681
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = CDV2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2682
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2683
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMC2(J,K) = TO_FM(37+11*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MIMB2 = MIMA2 - MIMC2
      MIM1 = 0
      DO J = 1, 3
         DO K = 1, 3
            MIM1 = MIM1 + ABS(MIMB2(J,K) - ( MIMA2(J,K) - MIMC2(J,K) ))
         ENDDO
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2684
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - MIMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - MIMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2685
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MIMA2(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MZMB2 = MIMA2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MIMA2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST89

      SUBROUTINE TEST90

!  Test type (ZM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2686
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2687
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4.8 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4.8 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2688
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = 4.87D0 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( 4.87D0 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2689
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = (4.8,5.9) - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.8,5.9) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2690
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = (4.87D0,5.98D0) - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( (4.87D0,5.98D0) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2691
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - 4
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - 4 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2692
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - 4.8
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - 4.8 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2693
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - 4.87D0
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - 4.87D0 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2694
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - (4.8,5.9) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2695
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - (4.87D0,5.98D0) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2696
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 - JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2697
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - RV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2698
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - DV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2699
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - CV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2700
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = MZM2 - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - CDV2(J,K) ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2701
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = JV2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( JV2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2702
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = RV2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( RV2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2703
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = DV2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( DV2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2704
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = CV2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2705
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMB2 = CDV2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2706
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZM2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZM2 - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2707
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMB2 = MZMA2 - MZM2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - MZM2 ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST90

      END MODULE TEST_F


      MODULE TEST_G
      USE TEST_VARS

      CONTAINS

      SUBROUTINE TEST91

!  Test type (ZM) array subtraction operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2708
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = JV2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( JV2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2709
      JV2 = RESHAPE( (/(11+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - JV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - JV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2710
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = RV2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( RV2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2711
      RV2 = RESHAPE( (/(11.345+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - RV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - RV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2712
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = DV2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( DV2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2713
      DV2 = RESHAPE( (/(12.3456789D0+3*J,J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - DV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - DV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2714
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CV2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CV2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2715
      CV2 = RESHAPE( (/(CMPLX(12.3+3*J,-32.4+7*J),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - CV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - CV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2716
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = CDV2 - MZMA2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( CDV2(J,K) - MZMA2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2717
      CDV2 = RESHAPE( (/(CMPLX(13.3D0+3*J,-22.4D0+7*J,KIND(1.0D0)),J=1,9)/) , SHAPE = (/ 3,3 /) )
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      MZMB2 = MZMA2 - CDV2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMB2(J,K) - ( MZMA2(J,K) - CDV2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2718
      DO J = 1, 3
         DO K = 1, 3
            MZMA2(J,K) = CMPLX(TO_FM('62.3')+3*(J+3*(K-1)), TO_FM('-72.4')+7*(J+3*(K-1)))
         ENDDO
      ENDDO
      DO J = 1, 3
         DO K = 1, 3
            MZMB2(J,K) = CMPLX(TO_FM(48.3+5*(J+3*(K-1))), TO_FM(-31.4+8*(J+3*(K-1))))
         ENDDO
      ENDDO
      MZMC2 = MZMA2 - MZMB2
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
            MFM3 = MFM3 + ABS(MZMC2(J,K) - ( MZMA2(J,K) - MZMB2(J,K) ))
         ENDDO
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST91

      SUBROUTINE TEST92

!  Test type (FM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2719
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4 * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2720
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.8 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.8 * MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2721
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = 4.87D0 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( 4.87D0 * MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2722
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) * MFMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2723
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) * MFMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2724
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2725
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2726
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2727
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 * (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2728
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 * (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2729
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 * JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 * JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2730
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 * RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2731
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 * DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2732
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 * CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2733
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 * CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2734
      JV = (/ 12, -34, 56 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = JV * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) * MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2735
      RV = (/ 12.1, -34.2, 56.3 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = RV * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) * MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2736
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = DV * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) * MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2737
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CV * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) * MFM4 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2738
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = CDV * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MFM4 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2739
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2740
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFMV1 * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2741
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MIM2 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIM2 * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2742
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_IM('121123456789')
      MFMV2 = MFMV1 * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2743
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2744
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MFMV1 * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2745
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MFM4 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFM4 * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2746
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFM4 = TO_FM('12.1123456789')
      MFMV2 = MIMV1 * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) * MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2747
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MFM4 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFM4 * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2748
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFM4 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 * MFM4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * MFM4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST92

      SUBROUTINE TEST93

!  Test type (FM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2749
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = JV * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( JV(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2750
      JV = (/ 12, -34, 56 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2751
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = RV * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( RV(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2752
      RV = (/ 12.1, -34.2, 56.3 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2753
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = DV * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( DV(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2754
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV2 = MFMV1 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2755
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2756
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2757
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2758
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2759
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MFMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MFMV2 = MFMV1 * MFMV4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * MFMV4(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2760
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MFMV1 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MFMV1(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2761
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MFMV2 = MIMV1 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MFMV2(J) - ( MIMV1(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2762
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 * MFMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * MFMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2763
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MFMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MFMV1 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MFMV1(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST93

      SUBROUTINE TEST94

!  Test type (IM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2764
      MIMV1 = (/ TO_IM('121123456789') , TO_IM('-342123456789') , TO_IM('563123456789') /)
      MIMV2 = 4 * MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( 4 * MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2765
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.8 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.8 * MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2766
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = 4.87D0 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( 4.87D0 * MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2767
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.8,5.9) * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) * MIMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2768
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = (4.87D0,5.98D0) * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) * MIMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2769
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * 4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) * 4 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2770
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) * 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2771
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) * 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2772
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 * (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2773
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 * (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2774
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 * JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( MIM2 * JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2775
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 * RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2776
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIM2 * DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2777
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 * CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2778
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 * CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2779
      JV = (/ 12, -34, 56 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = JV * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - ( JV(J) * MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2780
      RV = (/ 12.1, -34.2, 56.3 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = RV * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) * MIM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2781
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = DV * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) * MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2782
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CV * MIM2
      MFM3 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MZMV2(J) - ( CV(J) * MIM2 ))
      ENDDO
      MIM2 = RSMALL*56*3
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2783
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = CDV * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MIM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2784
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIM2 * MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIM2 * MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2785
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIM2 = TO_FM('12.1123456789')
      MIMV2 = MIMV1 * MIM2
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) * MIM2 ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2786
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2787
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MIMV1 * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2788
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MIM2 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIM2 * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2789
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIM2 = TO_FM('12.1123456789')
      MZMV2 = MZMV1 * MIM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * MIM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST94

      SUBROUTINE TEST95

!  Test type (IM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2790
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = JV * MIMV1
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( JV(J) * MIMV1(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2791
      JV = (/ 12, -34, 56 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * JV
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) * JV(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2792
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = RV * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( RV(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2793
      RV = (/ 12.1, -34.2, 56.3 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) * RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2794
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = DV * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( DV(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2795
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV2 = MIMV1 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MIMV2(J) - INT( MIMV1(J) * DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2796
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CV * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2797
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2798
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = CDV * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2799
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2800
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MIMV4 = (/ TO_FM('1.21123456789') , TO_FM('-3.42123456789') , TO_FM('5.63123456789') /)
      MIMV2 = MIMV1 * MIMV4
      MIM1 = 0
      DO J = 1, 3
         MIM1 = MIM1 + ABS(MIMV2(J) - ( MIMV1(J) * MIMV4(J) ))
      ENDDO
      CALL IM_ST2M(' 0 ',MIM2)
      IF (.NOT.(MIM1 <= MIM2)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2801
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MZMV1 * MIMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * MIMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2802
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MIMV1 = (/ TO_FM('12.1123456789') , TO_FM('-34.2123456789') , TO_FM('56.3123456789') /)
      MZMV2 = MIMV1 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MIMV1(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST95

      SUBROUTINE TEST96

!  Test type (ZM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2803
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4 * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2804
      MFMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.8 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.8 * MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2805
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = 4.87D0 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( 4.87D0 * MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2806
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.8,5.9) * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.8,5.9) * MZMV1(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2807
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (4.87D0,5.98D0) * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( (4.87D0,5.98D0) * MZMV1(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2808
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * 4
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * 4 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2809
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * 4.8
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * 4.8 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2810
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * 4.87D0
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * 4.87D0 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2811
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * (4.8,5.9)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * (4.8,5.9) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2812
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * (4.87D0,5.98D0)
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * (4.87D0,5.98D0) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2813
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 * JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2814
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * RV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2815
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * DV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2816
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * CV(J) ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2817
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = MZM2 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * CDV(J) ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2818
      JV = (/ 12, -34, 56 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = JV * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) * MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2819
      RV = (/ 12.1, -34.2, 56.3 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = RV * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) * MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2820
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = DV * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) * MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2821
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CV * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) * MZM2 ))
      ENDDO
      MFM4 = RSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2822
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZM2 = TO_ZM('12.1123456789 - 53.837465 i')
      MZMV2 = CDV * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MZM2 ))
      ENDDO
      MFM4 = DSMALL*56*3
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2823
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZM2 * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZM2 * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2824
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZM2 = TO_ZM('-123.654 + 98.7 i')
      MZMV2 = MZMV1 * MZM2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * MZM2 ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST96

      SUBROUTINE TEST97

!  Test type (ZM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2825
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = JV * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( JV(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2826
      JV = (/ 12, -34, 56 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * JV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * JV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2827
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = RV * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( RV(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2828
      RV = (/ 12.1, -34.2, 56.3 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * RV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * RV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2829
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = DV * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( DV(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2830
      DV = (/ 12.1123456789D0, -34.2123456789D0, 56.3123456789D0 /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * DV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * DV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2831
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CV * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CV(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2832
      CV = (/ (12.1,65.4) , (-34.2,54.3) , (56.3,-84.5) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * CV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * CV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2833
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = CDV * MZMV1
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( CDV(J) * MZMV1(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2834
      CDV = (/ (12.1123456789D0,34.57D0) , (-34.2123456789D0,987.43D0) ,  &
               (56.3123456789D0,-465.84D0) /)
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = MZMV1 * CDV
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV2(J) - ( MZMV1(J) * CDV(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      NCASE = 2835
      MZMV1 = (/ TO_ZM('12.1123456789 + 9.574635 i') , TO_ZM('-34.2123456789 - 5.4 i') ,  &
                 TO_ZM('56.3123456789 + 0.000345 i') /)
      MZMV2 = (/ TO_ZM('1.21123456789 + 0.9574635 i') , TO_ZM('-3.42123456789 - 0.54 i') ,  &
                 TO_ZM('5.63123456789 + 0.00345 i') /)
      MZMV4 = MZMV1 * MZMV2
      MFM3 = 0
      DO J = 1, 3
         MFM3 = MFM3 + ABS(MZMV4(J) - ( MZMV1(J) * MZMV2(J) ))
      ENDDO
      CALL FM_ST2M(' 1.0E-45 ',MFM4)
      IF (.NOT.(MFM3 <= MFM4)) THEN
          CALL PRTERR(KWSAVE)
      ENDIF

      KW = KWSAVE
      RETURN
      END SUBROUTINE TEST97

      SUBROUTINE TEST98

!  Test type (FM) array multiplication operations.

      IMPLICIT NONE

      KWSAVE = KW
      CALL FMSETVAR(' KW = 22 ')

      NCASE = 2836
      DO J = 1, 3
         DO K = 1, 3
            MFMA(J,K) = TO_FM(25+3*(J+3*(K-1)))/3
         ENDDO
      ENDDO
      MFMB = 4 * MFMA
      MFM3 = 0
      DO J = 1, 3
         DO K = 1, 3
        