
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00484_bessel_yv_at_v_1_3 : public TestCaseReal
    {
    public:
      TestCase_case_00484_bessel_yv_at_v_1_3() { }
      virtual ~TestCase_case_00484_bessel_yv_at_v_1_3() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00484_bessel_yv_at_v_1_3");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::cyl_bessel_y(ef::third(), ef::euler_gamma() + (10 * k));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.73207636458826762069849728518425560246571288334226943211877806039498122997405045177597549733244700546477614597095902808433026367881408893428241541536979285095140541890233278464456115626074980947808794807139060367830622620851820948277307638026259751781683150698053104583386290216115580135591502757063512912691407841528662670194318623302068311766267890589154623640822618284745513016333733627252343690825"),
           e_float("0.039823206452162032898937267750661733273870126141892109767441187282615095127802618536924966853735078308420745146222530403465854039834358064231131515393233683688044444563501029243461445123490512305848425141328855416035932509869340304908798072331199454869485922474899500774342465493749037501402121881966781715350556958804278835203928126745320145366171764773048033358110472697877725541431311653051480254382"),
           e_float("0.070959197420307002230764044554916036334734411844669555838564771680640496528885129161752143444961133782578948156560841841106346195763448876007950406091888892215384564858299834517161312940871589635131527484779060679011188797322995623533938084396261028260617425944680716975593574586121437715178942169573937110578357976551753350369676299837360313935506310400687948902788049058375920195178336503247931246872"),
           e_float("-0.12075476280108744405425483022173604860738840636877222237495456088299801944374669875852131577098943278613205546586245151008538075604687869122588604827925797784967474998268115137783922072734041914378138501654148217874893482157673248250571336784966258703366291069857775567929659073785694172631564363444743535231660025103544661879656493038036815102485420795128488246519351830439414705177502799648371569957"),
           e_float("0.12525275272883877212463964371238262892193721132537655371371607733694504500654306450194990833172865639560775897489992516218655139651316721371471558200663559437927757377618785700589870869140282335273992842783219860049051075727889783161767193021788944781261025303999440077463446683081320959018934835013359893229452771872331093092873117487746834902366489023763177784840411837787545990795790464012581828856"),
           e_float("-0.094322447904058852698286682552079154204498304056697773424805272359206484205751234055776373856013486613200176829106087394099657843867630522509284452358184921883086686848168611005236627061411442097726852715197630596532376477290197757444638455510211437982079165804896858614782693860177781628329176535201448280573649352615303821659503815853397330460142374343211802870730591457410030943802778691041411262837"),
           e_float("0.04209916251438243250598279468664444343816430773814109640191646364540376808762162771124756419982359458849767401664570520710004971984990998603705369840240602959051582555794154312307321526344054353154205339280977673450309066417296785534019919341620899747695414578011261550239555140968595992806143665765528844927236273720505973739258845165218541111866920280053973768059858578546155290837637923372293020532"),
           e_float("0.014398972020368273782923780572458337677361580902085343478551268529177982246803871335613127085771108121851725965896452842788411219860106234570084456482686632668981700457455446562129159026019683287444673139834542128022670129486642796349362966278662228629590524683841529917571543611861854088552319631877155371933916288846176498320756219498832177223514944592498597700761889749687177785463989346951834121712"),
           e_float("-0.0591120582345438075905140051814981467270729001461782069873504181629330408984055528208357695683175081349426184714681056153825464024276189427949511406983087077094417941748489064807561762615271560474008766707471747112830952639194768254000297015655631403157561642915170635591556290356007910098621739571252559072227047911331105849494230108545274208960946506697258344952614374825501962624719972120613653153"),
           e_float("0.08084428623389362501029402394475165893487793457204460346073919335270647945618819339125724230171287852812704515100063340334543659268515182592782348142970035360790339919845343942593449481369584704099343833512753554600857028180942060775521259161886280654402632188091224048747727220077777714519974251024068657179295858648401171521483167710860179394169952579175940768398744712726733458555475875789433105483"),
           e_float("-0.075830426630671014845212251066854503134456730538808321930102537817931238247744058256216554544196978863319397051204507795816146161786011834158130599258008348911704006470700019516517889169125227553760622870417902737822266891779306981751873591184530145258741476510652137148256896824041535351672908367282534947557905794875181682056408889246446402113292381008217685038450347201008440983980482124362015778498"),
           e_float("0.048189852680844803425869026566868376199682563413131753323088325650971206669812496030020380217444413875349885075689095128778461956184877384508185345076033863767200173404213744695026575003426344955707435672055498351875775100933226319695523393472583698464697170276966613413099705987801705289037461009540815779996759056276835748215446257782629396220326121118265798193942290417141440705724145414531526717584"),
           e_float("-0.0081845187299326792220206907374235612652494948097712730808501640122031288512266872815316791515925970961549298954376622856102378193181569213529560775248398336843884006671268113785293211915475153284539936452981687611051575220229266809373342367184223367399648041364156304312880137941896172241063901436023596492885417078586016796144367748687715669743406792973362615812513233176848558076336064156819122665148"),
           e_float("-0.031147612844131948534101510995862176510004915315583560036500665650220857685459684958966112477067581307474167131556215685356921488477825888196369938132570368923823498144732064122274156218364796138165134680244559115591674227799849938338912288199282241049980349138820424784383363849956564788368528501048197737190161701135130853477251335464624514394425691911452588320926633364590122337979121699632480620415"),
           e_float("0.057955078962669358714586634279161181714430301289804258248653644513439826664571418198877494103382324514350538946003767923308718070601765678217556865941079593553132727177553567456553441465474176290266019020026396977669769235395405951278837684304486547905317021843597165672434474978935659538280932170001127183966497452292446697751501442780914246695341585655106051812074447765625761514947708094212102780866"),
           e_float("-0.064964284356019169462342279000699206893838878838082935333125098910298442031645128431948375880637584370569772910862458363132508751498296685788876244073675718040614598678294636641315028087023080925365302931901052893764476740893710494459192924486612170079085396189709180036722467569937888532964812205630612773623280600968113526854832186185744304017835295312638323090986455193762046202584885541826627019789"),
           e_float("0.051342162162638362395010028372096352185081752555963506323669212179271267005857367987486996676131056493888904024300917576475057450399284203353979146749225888851466997467027615645216547056577958940869725098562919348103804802281026552229849103740123344997764647168477564286019415722929337469400476389705307012818294900873194049765133635227171002173650941786265464003142030338621274029874890896553606579364"),
           e_float("-0.022557367035510640120167060554686453433595889177175363333961783487490163675514285526956169084934785931766061569335599058085496518020396762220331659957532745778568382213105941573818791430940039636106582306029289696324927613431388238359401283617753779219778395160563288556591748267521106575469063763582428203121598730778126314023480660989646060515551239469853823204197898714355235863969986998747761961924"),
           e_float("-0.011624565432326334077017950677688214411137365223106802175375880738772135340645059079618881740517774895598489017305026824699341558091814146644334329798707575501999443288073831319448009017417702010164202127437458886353567095150147042354838218753989506418747108602101764990630498348104606108135870378081553075067056888538846137574722603575476790866780043427925681511861428584382811454050619387046738308271"),
           e_float("0.04032954839086112115496020287201646802972054289079405276724394116465998456903545333156174114148495800881907225272721431629594271335340378766397791170052231933944096355281050691271584324442573163223712543303484880209753562442747499664607049553977124668897302319113488680751791505564879554183523019823141726632731311855576476103626636954989748384369902274175284838731153813915006597462556424378123807114"),
           e_float("-0.054939404478672603201521987817469569831516134557375646026238139276833909813858187237947857027791505953666855839817739849761304725182676536870739050375692224436147433049961785450250833289445969415784625559492110046222137655359870355856862480345195234166685644257778149425073764084231646982499010344793273871212546615294873921540433879668188466653609100339062365551343734153695556184660245605635869304626"),
           e_float("0.051612811779974810276898422980829928960145221975225928900150420178185296191356385771661297630742400129790340073171663732256106665184896227588728041666164628216561657818520051784029152701306067915610998721637648637891510065374597509152118291506778475826477451892810188373544259921146564503414829955557847125758048579409436011328236308721490823506790677387603626668230413960477513844967311301504779726196"),
           e_float("-0.032237208513136621417843285313625415776310177301621311280765090691527856316965868971565112072874340624296194785317523200002106363043884998854911233233245245538387510004004370339043828132255752496418646986592163300874828867596189334299889288131458081333229966451633176999713111929996103446692405390034699808339889704636381238611817507115186901257570866018994939054396037447000645345990764120899330730142"),
           e_float("0.0035884552513704812449293968248646447882615079991053446243595215039794901896141012030495487098332986460829778802790448375118806710708083488478567331219358266270221821549083069751413997328139860137048813201088797001533135232806658942888314011550193626428847103442557840152395929637728760463867850110964396273884884147539493009715916484760134956879130826096110488827090838669781712237570904094996786563142"),
           e_float("0.024972690709875874151436079383471369051655049456489851526818796483469867147141168215918273152178429810288250504663531438555715947634140896722870204361013621282828241389205082529811053949720238027676953452466027133070093289323890295317694554963884532774050337147121008044654818993160708838441860774164334056969278083608749807029315938503864264659478257280915680888456012585419800111763760904213555439096"),
           e_float("-0.044504925011614936238111990696224367268031311562296414310010183221195552549687453288694446562788419069653216999526770320048837117879927452394062654348865891087591778587090170939464702659781295663484402219330156137234642594291401227973142942244198838633736956332724680446017929180375308491057068190028906269975765896803245224956359299305792762983044814110243356493411526808997153253167254209110707799274"),
           e_float("0.049242789084308071484604251472215078548559874967206252392673499986028610382359515722378084931065371292804717390185964921516841980939998236991084538390468342445456122444538065363245677969292706619489280194085055458491990985020263585463237599441165852266174161303264496677447865897356993474716206669015122859234266092994251431946829081788619408804216475832679315446255676999323178834863129575125985789423"),
           e_float("-0.03826595437417020931603806668297368459368108520319267390341645845603261090087635238440193926341065773904417389913856854303012593973040041129890468190565161022200065207868410258183462654590883385913301211127165766068001328831261000560803291897381713972524667452936301537153248897358986163342746378806836699317109006039237029806459316583967528952740780890737372463469025481621508430941256048068785679268"),
           e_float("0.015605347084784775973029615920222130831375492680623806755808165571437127596970453153277458963950724406269473547234540259876487879104797513215212639005956648668605897137243511388691230699739100818133540987362314890695994824156246902542329060382593043292318376995680393981737387025918207316900636468790780065277450359971514787154841309799882181069225587683276096599199994336651158743996452106515711511325"),
           e_float("0.011192271016366281351641090652485466139060016424217003324727192430589492550696394686867091010932053725772442000461038123449599229998685998927897658872585886528493313980922700110640320599751033369678194168847306921141057673221709521148162527829698760973131727526942950887667689971266611998272896249178036767182810924736589991152796306753525829608879577032193828287098309541873670900567105022585248120056"),
           e_float("-0.033544266129123889354673425300382232733840590495163064392302272946449185647724376713085986120147972554949213029357012030759698976387264501466482183269785603233145145561521820169389327173559740281197426917566219895792276016226540950578258610254092735974719905401867124551601760234976431797907856355068509607408275036335882553428943821271300280255093954502544469713834445588646916003227961484078414239852"),
           e_float("0.044552219763758159495845247596934838786535799182329420485331953415631653669000864775979882808583941234769382701298976347390316602731188509618941579491149908595060584282053045760040227967639776496230202230630365980462677559730695984920547453922706173648291537511637077172426597406665887671097726880956490181083450869675047967867955953638100729540101458656414264833481376437883080349996488625864487956395"),
           e_float("-0.041108268090603135645708385582932372931503130385201433442741687925962674754562573867862862677075946739449339489136992551444568940083944954915424860371319413857656899046147902260947059557670584093937865271667060718218444655150527094489695623547886594944208349253406484440231349584844654700132310012036145541376252816638055495211139131291978740967750667113213293241574988604650545720356670912555730901641"),
           e_float("0.024750354605535340223041934229701659355235345835804661840785849022741010665111003550416893539822064600277080315001366867033797200474035431427235107840739787632989645071992995477327934636447718319599001988764500151250072264646992742577350715336280559940064173323812429610996731780268832796471996452567028077702554555341913889099368562045135199276715743105155921841380475427507141853776181465661726008571"),
           e_float("-0.0010371764234703046980718423507914298071987267892203901912416596968001621023624105358008159161342617296613672378189643534022852862434022164241622207284616148260085855948591240247764625834840056508789016152262518955872230625945718798120133951141815063490480602615339113426613106528477536820550637879583162317458918931577952274283336478727730397015629005335483816955431925801808502976518080131518717196936"),
           e_float("-0.022318466961206193164753071483252248678310940578660504078648249436172677823713136341479094323387886379387124529846885771672996525699528641959527823190678561082960205770874026409960739390885255864468578470789458661430855582670757771925960646240171979568128290673887532174271035675004072747902606124326939900878749907058189547744105449186803309139745006213419108683144733039634625270729176452352487305354"),
           e_float("0.037938430101231239106001508756037969802348257964919597432212567131472487283918266647064792906584409661099913465173542145549128547583074763628249943687033134994691091216131001336180796656484365978552226811430523569048666966057427743517523763484742793080164819884513820935610857389154635124794803144433565207362717415179057293425637101047481674496583403446046366571888523871014506392209797450665896614219"),
           e_float("-0.041093152125100394544147266948666701448781106750523801931917418192654614993983120337307997032280779801825674131793786036055695300115086252965854007003960543779616003603319262889560563751417620183046920280194462038584257435626768902725274648210134135410737722702940605303349904613455151940730114762544998254271497522681953819880848556119592254285282720914112987043341321721923113537249784483518675153246"),
           e_float("0.031119828199768081029812877354643120532092197052296032185714671305424063419419950213575443127014056302869280701850244440942790037320527150013501747922070320523867172254445424517271132977763716772085383430943771498159479556007120603502064506462116777459004287489373991461372655962858394613575513943287257247792486324781607854569168749396944657753189427996452165220443057064909096430889458905032247965348"),
           e_float("-0.011523276964421162035470396706846218189011955892088877013446002093105128115559456118632323433468602227764757633551965354067098879396366886344890390300728064644474451230695715060981694135402773595794072816439676414228114893315849814062330207580566862413679218861575153224505311281932604744222953716841141109874847254373705607726524639205457057562305524509601175212697617661597494469866332350958136124957"),
           e_float("-0.011238247417608476648806559151667304011616507468392838043431543966466384257375936154253367710511748062951264230302166159414443610070472896343954910136625736631420305708286509628846626660562714259057200246034965594645866124531667949435885833907917795804483409703819150070569599422621086680154814610918903301642943061251010763592136515880336974888746685469627909573789541590960854671294009978842902309184"),
           e_float("0.02986735604709281828937790906499754027166023416707524919720520582263559419284842882714838541581406872847061692822902102411385592804090203500946985268950645957484409923704750301253528609130319915605068684910713311424432735350686100342808955485021769377712449592552694560889622603124402617151818421502499824699970365771942473948020925571882905638376297077358841496462840440711181780270314080477845912915"),
           e_float("-0.038554324429817206132680085005181896181738029763990413948778855202286902443798602826125060302021204529649553072143280440027517986539943388733034808539294486440179409059601685266788618419899903493059416270548041656207588318875402975583600446617746726052299237775243506977630614732969245018776955065279719968601126557158064813963124631194309592292445770270191458980333133976098752534169422180119997909477"),
           e_float("0.034778331549729242615709184210143431167943408437794843200430377256490631319866773628281636366732637909464217459301013570440741677013390646480965341468780586848055833820547576603792490105895269590254048462390212565770990326468030962121077511330050740665141700019348142807270152571886185111678592947953521169794467065566696749712842895171957202588358595721083914669781070920051492662812538584415910556745"),
           e_float("-0.020027654193588998827683422539867274311288661459795280353198406389928071261333417968138090963809712533313763006909049316674942294133035409107833618169249937867716271178741400050649595452847120705545479297960757157947267827941455005438126863716322950915115935386628229129892584840367643091144687382448139365176690913346512129570932641533007848866780579654228511174795621987001400075745197778339827625948"),
           e_float("-0.00076356376908663049564921688878913420594776657968723475541465574402077492255208330975674913397034192757328258215229762648572466626658277488365339965446351653029190773197078929990258179879480539793252499330301180371476428006788801275423482441648842497259471463714879067735394369401208481559860258185371226903204712905984281615353687496336004589231537124763948103204728436057367131362549898750691583856277"),
           e_float("0.020855365296838287146795958969603630656028324237756637103460562244225164584322835682106174193036543696106307801531246759692952328613048153798592229467815704888676067981473052612307214847525781009046223794936833324608994946817906229057181032639337194677289184315370059300585839324086082653609430423320833861667390039128321433240009626141021902172604766299124167152318852395514252853165868794966062539415"),
           e_float("-0.033877185721079055189330854808890595376844156312750478952805439255008617652783480324394102606948797962551038997370901194504695820793155821720255153259463062629235727033945152435053752215199588564638130231786300747629501613636391431724928453700610895129309323773435741549776020912509809912648638878018091373059565247049317219239204869743338077819307982955852942626074002848543397294421538127084690031685"),
           e_float("0.035839265685313550865889388226175094636408240147597232212787746871752414775393372558544514425452131964704146901930129154842168785463558854364599591173326863135252933812931546453832106176842252026879117155619372474894012115122627478927641719455557676593564322326642805362462790920346659203102365101093845885362695260841916675061033109553123252374888391378989283473845665549162537617906054475590648467436"),
           e_float("-0.026347714543584316928943258720500629646676050251099873932024592612845484014751080168367615094114158275072807313746588806975062952191894175276076273057071777058970633101410565806865300684634777737110120840184864010432448262646206860040414011767619910074679481471346357597116424892597073650896851388764800640127249559868700852891825030201897349084099909359557574745625969751315498618803091851299200674396"),
           e_float("0.0086552750680936657522443726889341682020061725680139762609465160573182153867562945440994783796308505099390393577097253619094774665513323337767263978680487249340160788812005807284520991745586493636213949072604524626269357817436191750040649069815408427307904050113013990337117563072065239737072729230352541334479704720815096408440225913421445489845896821045334036911939171985191403164791030818077006117753"),
           e_float("0.01144469718314673442266692311791575899854973008730920666709873988098656552584596514844906704556716503088518942140096287288007049858173470308628285405343793939737439669828535845405282690288987116482800175322284865014943032079027328736595441842365507090478446302448136835093719619276791766223014599937361967988739627557810287811207798531932510547038410886191950663433616145067344951644619032614923516195"),
           e_float("-0.027507825983899638068190007198174848045580359662980672332105476005071742075707874013899105188728609065478809594651649997727489115136736729624091438053616915770525708090403059465708125239312253142792424742951397674166657193913510168459470510525841287698276463132891608841737686982887405452462383477245752908243460211016203575699344489630469750418950062392685906762840466504744119581275615127961734077461"),
           e_float("0.034497980388613543829201481582676547542287411154543516807462612526047381209987589635557274742697819971789392761895700318149420678065884656936340236825365653477081861874619391558978249832392792139081043247949111553817538184314747987093297265320905479351329607819392394049893436190249981856460974773825832207455350004480218355766640391673623286429796866228212383339944207444282641024224673917662942610546"),
           e_float("-0.030360315078916116396250951576322888260519786152074266043799311903408610433699415520664191361905456418098686624071927128507872119554697635045739851557559477733786868944647294106655704960662356748024497546853837844943064017009689718726447513553379575984350381587393322091612349154877143466989237749630168315886703681566856792251793297646896439029792818805374049147910908708787217964779165965805104098378"),
           e_float("0.016618462333786184486831266388677919642246091442834184161378865818914864893216587450505524030128792023889756544132750335511674522351326694619681943798395933239935511886259941754291018136610622436712404049385374623907355714750252146226329956379239883105034351660618792860301650718457661195041984989827385858238591951189813088829631829477447271047922870615682328080285680789828788529633216491839596035267"),
           e_float("0.0021755523319440505477666590636660924843050812413982691363383144549886639373842323192962949617908275462361232984739756862271195516142222358256906942646628378084166140355531541887934214824754726948160056078254738385824914156774113011583545387393834615630119770338854556010942516149626874921814666271360969033869694729954130685768845319230242163052808137437433280593999334154434545547414615329751603751694"),
           e_float("-0.019943353706985054332312826038032935894787758584324398775746950701396531828991008209299327463869008267592448607505141633689490662998442082099165400943651636176708986379400017639898615112615101271428217860530334589365445190263726335218147088293110418233326195715259843611583879553002688432343440507449948083340015575220282891386115578047821766481496445841852701605169547954199802225390511794984317768087"),
           e_float("0.031040520800446358710825914435898102768811905192313707787274328042395497125064980011122441182906719029147995008517380966088294450534687224210992779630790621983708799833923639103573299323847069146627659737100963074549571479639811575280332669657276463540918408382228666930769146185089980960571666814692833145783358240263372080759126980524874555334046511824899750516854964234586576267166538258260327149317"),
           e_float("-0.03204471642683137367104448690760657360176697447995335235944175333153030210327823427137986308449931415715185597908882726839358441313477488532751808340463242219611574465790566149634560423133107059016853924467702762713965921129869254439191587224819874241939096052775577568331302610875221928437556486450725761999191711216425991457910211909503678397593772747627412521785699261544705049878466336934480863153"),
           e_float("0.022806671246263095763586660016034700132711361485764639995408538110978930198763576288672151546252954281873063434038200064253878905971759025714957263620052836562170256118247965166121408534559226249655024172595257683976728161885284940581638114048338975712268029854711966384463474251080490514420593098021148843976193181566194925621168698307129230664052209434763604652427696900690914505680511250684219973321"),
           e_float("-0.0064425813556036866899055115590274489662278080058512930683434897253935783771836165446299435584795008838142408238671135393805090517401796715020489676336991426709930471680755298565379418766125032852090302038366010547195233557121415413537084036340527392100720804145149959843504115211009181798294004097534418224776571519101944274036050649921495338980853234138942662074511115923431518058522796918168781840237"),
           e_float("-0.011712055205656763493412847123360850677115464935336550509931099526247472087900315307014460745905632468782989519481507677641292700583553893265062995355393584265524225820148443481202248202062574694847468004300357161271881989689465113625141079878850269625627425108920352367795770738193755850017267584753099922738037752905354773341774491849048358878489257951059711533933793805346587536272785758201230422479"),
           e_float("0.02583760036540517273189524906513423561666509334572092466315827465008470320514353366582474325881584098564608578510292184739728211224993119173114198613799696359802747888912248822508358130043241732093555717562525413166050680804260284241212571115143311039590505575651223849031615983548443872373353255786913296120620679740858552442938664046632343501432858560104770906723849329542756805272618685757742767623"),
           e_float("-0.031491601089076709688220095585217762495902603321876594378726033444406969506707724308157692259280130199366742570717179702945258171033375734319517351810960247849501476827473602075570941421070889875718597963629568043666323788369310805866244556098375852458427983574729194963268427422357582248271122844480637846999488004736274951949015330447773968449283408195483120714823467013737467794066223585027729867786"),
           e_float("0.027002272014912989056721407785014585666410650960458558166554019557186718132880266555621725803212377353664912869969954275249651703151284025641134940753106638343037920628051357018114758227517768024273595509926096333248253513004070422607188868492891098706177498648706111633682794488025555637195305167832882271779631194691002363529209165608020367818777877808948768843487894331737320515806099284410204746541"),
           e_float("-0.013958126234186953569174377149924051247545417420922119562549707823190719247337065317248013299487502001465182628411957377186507267137390558750095953509782111716393511050739831966973183708090975509033418975757348516759046410581665964906888090406047280914037145605147738410349668802290025284375038839104493608769251773220574081435087696848201731647652172048127403298143637200672459152182101853102027840252"),
           e_float("-0.003348151732684838258915658672071612954787769181206581370854685349302609232262457607048329440620523094426440536896924510595601159447847156500769149479287730905523036432903019990706026123640890993897056968293649080731786674649656189622323248983130530048012302889687014041550574907455442628568993657973361506876616351440224736305638751427347862292173185385083099222689653425104032296723585029303600880375"),
           e_float("0.019328743836201270673656767528017457849118423731709845681955512025979902142227900339443498188197223348264734547795118960092158540511587744957240801938672765388960574720330668199618043432162961606789589208887233953477837156507071287537443565190567635668345726285780916584429675863668137605368813592594357092629059569196184059950558043132012713316420707154732529741481748577039520292896080429822411654472"),
           e_float("-0.028901346726493318816120512186288724902753553967375206318214558733485725378771608757276303200124167007219893326670184418665035816497244612644167615727498013976316879736585493162773798711406412024636263593156296671869119122613260474605929252743496858710515122284787049346981262151175776490299292191732415941274715983159981080669126584560320855378651960910620484716169072215674075574796548108640798155867"),
           e_float("0.029102308359643451084971749752626522781780959293930764880927011462629343827735200061994890164708212953427118905607351922234942409847449105133962548097498893217498922362862868529186312032923177370532371863494112428052063314282165210892430030626524090948618266851204091205358524349673740722457165558360148704890552373755545826609744963199830767895182143859533701400277754587094472730864088316824832951"),
           e_float("-0.020001212624173545757535639394025383896643809661900724199331755528585750996487811461050566825101949541003033855215176280912659676820805232623918353913189974710783597747800733028291481007220567881058549734765839775303327632255231245162249431407108595370730688422450212687981437187114976276040368261469629609887899939300173085561777171008304810972176818791858506461649564016134095282266848517888234664925"),
           e_float("0.0046355591284918626784491160622619729446788343566972964202606770370280060320818879033756942898158111846827915392085599336640792864787790587087921287948440192452774350812822737920982514257029104426084026986001769567035287368157330971422812169732403977930228051513013095829460700919934794262311903874755601190050910590601637777615433318311410012034991439848978743488681139904509801863224067783467548408035"),
           e_float("0.011999837661051786270718744846026346613274086104296629969864744108013717980038509203542408606131042260202920321186817344308024424328147284012672884938159644919231747569942662769542283803124286165656105353372741647751406542590047251350450266026567260718589067713341190099609037373809767674325232930892524974900330905626272538947246908945108765423534834076189586331478160790436946873710165168154392899955"),
           e_float("-0.024573543654031290588681593361726137393520665489115494691841950036603338045375294883679290617915871632138418253657378719269445264949759205501496465777091441010272876963206003664225040710896192549900164652810334320893575928729269588543824166782302031993348808640923106363936402408919784552741131388620846449522737499101662314861520295536824896143053283046005359579891072414482875264997860055468810472996"),
           e_float("0.029123375016747697478312529533391433580233504955195283055585490163868938781994123379839217688454958747250568206683657772167990939774635920858196412141894797468706491048416261410530379118009788974091863236917752410373748041799361961841924403868626019980181190788356394952249476520639008755004014049828126533154843582882673708168590873313874166263317983476498148353644111442152311978309127286860965018444"),
           e_float("-0.024302497042728224270389251113930493014177649148687354796352389349338301703466872758003229298502159632968725633406327532347114602462627025544220751597568030038386321902010014911001943862609364932558069143567949094186463701038860469798932411282722451359340370430795291790608457376600739167169136305160176925746174084106757606065917368448445483640068238889230780586158177234040559954040840379361654387026"),
           e_float("0.011774596663503049619888526138761766385081464414664202845896192166959782020520073935839419367256140449960682368163918762648738997587864870250204367212005403396779760521797199666963704880700121726444441907656328474796369732489207423262514857652740618421853458316609477875174278832637840667432645875406678198991787968393462502346734796112179102531597921825727387867987235198636909488524125463169626950197"),
           e_float("0.0043566708372125295816826952554168618475134306462233739577906752591906778160126335940882902878317806002673653637543801707515259303640325762975879290879650344944254757607294982070786134076103721545510462834933067107314209068621956986487436186653832080282391493070842577221799238695251613972910072633169909714175651380444739473224631377473799741368557862992997737642939734568448381572538253365633576487315"),
           e_float("-0.018889430552681560510282399554890673840700912309877656393384898603331672885109061630678064241798131438033142815211019093711177148891500778018105425066554037524848746527287060654581697995129409929167224576040097933936957709671145000351397249282942032885159482144525855765442228807902122579142161301886483591859126736092778767183678090350379641920252913548819765916892015847134697483973642896670140759298"),
           e_float("0.027198636992677432465077727757307105998769780609802558127892315873046857124765377554824956210192739816763793193468547456428479054749436197916984038355544579842371876727309536826904421279961270226884187224438818957609406528228628543647824146597486533386769417138779612109529043294005381595166477673552496508059519872496115118555168773844178297696919839843965158358794198483592034685262752209526748142246"),
           e_float("-0.026705812255577556187278407148513895370199809456522095063385875314312151759126198039574503786657309815940781384149058053006218377780186899019130667150823488987827132342968101709145433193320668949751086613042862555431725084041338403732033720595785338997748528033361170323770176114441416684956181773823976895194612890747832589545495813588086526070745954229878964376471010694592174257673091594037394246388"),
           e_float("0.017677093928460532262009421388926050444197946973156560904121077825142940165304389219537000271677584362015664483100582297498356082723750906572135742981829286144441429057248223324793816975171827450060745851178708931885675077175697475951363432908725325013542210224124800288435072831947620369405404610371959087181255251819445924746542388045706682065072997632485788422724807483344044086158709723236448297239"),
           e_float("-0.0031032337895281276696412094163200186494512134443045697265023049104323358644070878140079096382803792007297577006961164079697277050257586518668285953672113354086714246320592105468462968798299740027835162138728236078727581158431781708970441090635864191243838353923585615205587916417814255171060506236968520156431607187132716687921684760458175217751238929267720517502213664155323992855400199218812584606526"),
           e_float("-0.012288932876677836424559826548259210174171982311071800427742818471708388403073599337403248162843719022592702997153906488993653242447520767468968172919032303141617876674933154258507736787040310028159611120945381937666138765910855974593975996074542761822815794419213578869667540880817089787548698495687190315971566423362812600453686295098919122767908763220865878983595723142793019097826491384384827739975"),
           e_float("0.023567521358131398927542543253907644526441525113044470722378996214438963491200793503927387831463625799234962346197032297601066234723571582037252080857733371486647606277718748387512331442139460405166441884428518991711645642170766626998652433182770506433427984316615362209611950828796868524412041287428315029135537581814009073527596243645995892350231595851642274510331173878183981313258782381937113201273"),
           e_float("-0.027173895777378762129595587027915197312860977289122500332040279325664687068963935639796948967354838871270176227325267524384376137774480272437611683182259158066025119227799564459880048655837746705835006047516318180137651597625822073200792076858000422216560801676554156292577868982048391492906112204686156705351347675258105795555398736736634497897543500018847322108405186357105732480669779894192782871914"),
           e_float("0.022043758663923075747478022278324800516275861958891698456854885209020735521350085707074313359738688144417350698011659892901435972590617738876452488893080175826878232221897029817767734306234948655667185001161271686333461894369266371674269524318493693451638073843667313073500069110600325558790857279312400609963322573688424276672499872179392168090138188029373068083846524036482514465049511614276513607395"),
           e_float("-0.0099183803724390058498061277755377670257883674462528937751027251604960653331527109096477125053238616304213404662832675402309692631170573165996245356239366485879071722746406774795450924813897602983033387583767207734251630071529094431838360111355774239936847832788116007904844084076260113752517850192230993809771082738074212551983645119585510376671879292997208130934101593048090388899446081970967487574851"),
           e_float("-0.0052440904692779807566251530891686505948345211782898554905277607155774413318369508396877935310454709382513780017253909965814365360165299203152030476053189526613530458467096099782900601829253392380798465900279447358869814383154033749794140910768255502216819375544825064056618503829358171632417493034627411308459141865046553563071642285761314995859774103280491011167041912372502159842932847950150444714902"),
           e_float("0.01855896127963952145132823073353444502620600598855389542945330041683447355598148375984219200640715888549729270461388689808990481006715335991949362004967929405644913246097644299498261164570998851002031704040290306989204256005120991514468640777629101089003319219562213545379776151919448020273791257031423172892812024906524287931550422766968016733551900604170927337215808264242732943179541392768660800606"),
           e_float("-0.025786906902633130701573348284636376945174497411791852721363535572800885999051002806217034802662323952918090675058544647282902081636182381979479759428684733760566572024185161184436220163598995723395956041126216350612154349375848071229033428495148493343488684079511707617269348164333852001409351722997840332663812918825201950015409546640017392457995194562065808371278731971567147205327453240089070706016"),
           e_float("0.024682162712762291856148832240497925533806621655235188059196368591177924094830413497687926246304673259170261961953410980858443607034112459827497707382229915325191425612885644048081170901853890435382916290639654671443818139423428456176111206027793389167835738389630716211779728723401505914974640101665729517394105216445430581635833980423318522914565012061226400825992241527621623896272672502375980719887"),
           e_float("-0.01568873080551034682044097563245426026550097751842047501897074951587280468147659107384350125991709893944034875388913791633564100287368293148660520267805912177242014474892928340280362113441362356078282633881098364165148375973422577897372559029184006961377124605928831156502607030954242370242735820056196357641409160805149451169862328237589221619571571781878256094250666789294127667199087408276967988514"),
           e_float("0.001769253452655382170617332995138556357554315045178465558107122732034381136963141609170477137453232898083565969448470339607956760961673440308847901062829370323635715322504111398614716896501985205088326459608315168151024955427463814637380910060593198950414163838172142994741014293942600553999174114131143686345436722363319745569048053742377312155851432202072065321831089242765184660435535185067312941648"),
           e_float("0.012569408370312943343426730984258283805651186936730221890796562336675296277661826720528485461617147600116256661489532200306247969024870618557352071312768058463431226285524296944575113153229283426242572659192231384261655447728086806740170738876043249337823908241476968284756843475847207515710436196978735805905906195456382928763403852077883574605654263767639803994871083149855837068529230076441350265818"),
           e_float("-0.022733910588190647186402619865551167617729132530454912639380114437375299644641931213397064517751843591556114448287463588494189607967480437668805969630073204389410204776858932073733088799510967519318496784059706724511406539714813917854651134208069508063989119274087046883443188159712753462789372783897201390233591901911557444459659068024167044894415963500613978391043656767873252647238128551716343614006"),
           e_float("0.025514460497985355451020883247024529553793981622616894020314057679753757164032426522697567348216714181469483845483362805766631122158112121090921219422711767667035735930857479527416657153649132755217591042476262216116095770269566108342456832296190962145435030322161293894884050099948775851026999747870415874426263361009461739209532249896376121148860384797518234352392973440802142501579549512690723409688"),
           e_float("-0.02009713581684099928594606221211765168903619493752457443517111736815095118762386118790338323483132837788020289640772400842584518027689619481724003422271186491330740849846636054094067672805382096530188254333156053446026197276152245735521239042966488655815663800377209046414806649565314577983274168936240362937855984968010709437318706707322870003698854101901614954387091040622738345870054646237890650062"),
           e_float("0.0082996127441359472719430167717610440556235686834243470644088381376582204201396099348250513873338546047126316118238478285779389138070385962866738704295302822635171033083781150122436623642258959013799726311455645835132716329093526485745672540891854085388373489591180827327222253280407039001743540716077180588246478395167395918759927285352894325001185789856164195353460390049165981999111465309738544573805"),
           e_float("0.0060371094065476762315150280389460860651690225145975664490527212248633511353161794459168574921209595746083525009522356329192832096521522594297431174137463000098257117321185240813741945783519497793118560687338444438781591685566831097497345397835986630177107776702653391582391665264948398863949465145255836134368735295166774864894997372635079684758468949666211225189461578377428448072952670993595789210099"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00484_bessel_yv_at_v_1_3(const bool b_write_output)
    {
      return TestCase_case_00484_bessel_yv_at_v_1_3().execute(b_write_output);
    }
  }
}
