
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_03025_z_poly_hermite_h : public TestCaseImag
    {
    public:
      TestCase_case_03025_z_poly_hermite_h() { }
      virtual ~TestCase_case_03025_z_poly_hermite_h() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_03025_z_poly_hermite_h");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + (k - 10);
          const e_float y = ef::golden_ratio() + static_cast<INT32>(2 * k);
          data[static_cast<std::size_t>(k)] = efz::hermite(k + 1, ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 111u> a =
        {{
           ef_complex(e_float("-18.845568670196934278786975819835195137915681328120152802388465530230264546444670658126105873416506500970737105500385835038078991971026914327551652004710152927492999332514125324524652114414809483505810167982529592103668658293533696446776942757600996984030412509828588519940157290427706611940791349156961882448929465337201491974065158972491720901776629794384031530244825589923137812005277254893878221337"), e_float("3.236067977499789696409173668731276235440618359611525724270897245410520925637804899414414408378782274969508176150773783504253267724447073863586360121533452708866778173191879165811276645322639856580535761350417533785003423392414064442086432539097252592627228876299517402440681611775908909498492371390729728898482088641542689894099131693577019748678884425089754132956183176921499977424801530434115035958")),
           ef_complex(e_float("229.41250404732261176951289737217523951719601277720876261587911998619337759041312137704072043373327519446361229891976182070612171342048211177711520350567281967183140918092456517801374600770228495044808146619809311999353248891044046662833031743031051327142457457018212311997573501737521707796969499974576011978769346556206454738826910357706545234615605564265733257548590227346027284416845810409192955811"), e_float("-243.7913600343715041396432786251176495419535645231503234230263167731846994941010972393899821901077534546492003580781352500108686510949246776442564023382995360500480684899402444024665183251055476092067834799814437726668851976013947270479340151097146809286771553717316252737532189628394593827636624037607333500974461549289732405638259858170794119807364609611310911256660275809535362476699316152871154423")),
           ef_complex(e_float("2439.9695913891136840252358029179078631967874464847537763762073523773042657934154298497033971962382034693806179879366062640595750476031532668768369729770821457374290896517406759579587126969252930102478816102255028351570872534928751682601477343997317648324569868123645821735041832087945356350456846570638489806191060959315850786509987292415286421414930411303194490849784552645738459284482335370652755772"), e_float("5943.0204439267795414602236180280878400539415472403554354743431855889039507773837541201549697569040877655837956167071605478434764729943613714361197132407269263068400474328176889424260619130689696186182790491889582382780173357306709672107179992245838628979196920872385922095421941275754450571383210323264663378340768951937519027784939609780235496997423757334126260951637711086232378880823619012744881982")),
           ef_complex(e_float("-147895.07394501683021718593194342282132964925152839620364445835086799337224488387216403345964633664273110574113508568476083998614318551371761924427253914406265277994608495432928649885875156999581337483081488458084710051616287246975069284889929221447394023452408753236671489042057749539276144979308204316360414822995854552442316990759594163594432449728322390439003209635519893912297747376196487346171259"), e_float("57250.15310000536479752087375218450603356960013206933469381918430286638906899375648523556072626755324895454247442630133255036130701477275765941418364644615272361345963442168173400458988858140938083526774242254301932140065315676833423232562425800376493563495990131288594772510518940142027478235221874021965271933720826562617429769190114643476404658241027176092340086334339800330728033431021234007885921")),
           ef_complex(e_float("-3.0703141903858999786538801851402098664187870191114187589588649422529910884505804739696038487847518724221630609499151412762631536879334142928344411811557140607071797290549499928386390980677643599075788723656337485158308427142204879330698557038875840787348839034165827596353776923304724495141718924381667235621874506527838237323428911331364418090097572434090234305262365928180607560983132944362810072752e6"), e_float("-4.4001786437820467525256781465423318666517905109714501696222593106218893257139466069720499984389168869077186807677559742410155369859869356746878928196738859733405367156513019478919685442480001758839426783365462726442865115161995154279144492526889130729067709099277970108469190281252318253978153404800905548308148040319735112257168663179711529732470346671856894238897941399358245158553868644429396318441e6")),
           ef_complex(e_float("1.342317150085794380676032711739980440315418957777400551823895781747962248791635518467441502621878914404636529291146569261078317023878719736711121808477480475540997749887311026140947056065243533987865956162012307545309636809593232257214599412541786492361418080270323614576413718732224790082537005586981327085445270527409467361503385269692610209567241865267142910733999674817645767035837460535634136486e8"), e_float("-2.04845374290405889663037402408438181531260913605970108847414029950588716197682528582967466664333508538006010057002332607264551408987747801940216869019912575994668365148311807171124901024969845344910646526793295169074476552925403115364457962067845167510267443471178900257568450787841116051583039657410246689140138799181905549632155571038393664821944853949039611443220092741883408529445606965212440037e8")),
           ef_complex(e_float("1.4313345847463312342749718655891815970787747163524802703752963957975581256781070016533197834098171419470362108405950751928010879344933704771917243212079422887187417078015157797839398261461572014130045494896869144159800445773363279892628952655533597107355694841214213026726596763131515236097554532484113381820956407056174189616926724773902889449033188764728049164622831542028944140161555213537890498563e10"), e_float("1.846790753688713035437385158202643442962632880731221496910241452673498049232564952323497062701093947791265597137661719196144861923948924785116429728903587608551460605486258508329006857326476722449446444161702584080256641848715929334894739857685814064405134726012670160932220726768989761693188822708130024665101020022922075579539958496261460028256419554929985799044058708909699570002688922288363142323e9")),
           ef_complex(e_float("3.6637697080351430591256494449340930230121096430517993209092009748945525720563619195497496481679164860528360155957871893541542018905057713912311230584653085439908005545797604600543869423933672828455488847046634469259768699144676589182560659326434867686318142941173348579057735348477281257275528700626099579359724115531174978591838872567448392402643253483475344177103380501580060056335108455574913302645e11"), e_float("9.8481329770081811513461934675098962354977869851721613000185138480039447551321683021330894450076343307157302402956566024383308079396933958173322346238183283914018344202584276397909277391271280565635069010738865672612148241413515266525394978757419092125149471115953053950623754906201048050606757704924718414788399501283027536359968873088185241826154917214639419054783377519176921933182105216835024971526e11")),
           ef_complex(e_float("-5.9877470671825534574151763214113398783644956873070650445271878499835916716139330773341840495006251095925523597939170672799497768785734065786145160807339573563233686298597701632164326525723238899067254237531208797923502804938223836244900574720853576225570177159796297200998943396999704326842097295488375567765053182023261466496896266776450746926322370158792675972154445403508832076348603085548179104839e13"), e_float("6.8794354340383664044392416638294370300284422768527331165054220875921295240979433298234980812882218928765237368824262632021075003964488251327658711947954068202211270235368155771857098274124497857031768219687660133218611623414334345989942885259472720135601529427989856291038974123446810247620762412808584966160851060834039343701699052681288286578276680915473472029646061667407322054107744409688385109296e13")),
           ef_complex(e_float("-8.9745937472034168426815566755437786250241851144260480562594715119950504658729748608789592612831169007662849674733485369059573902096679496690487500770429352970416963362984757682387013317447892681192223353148678283304912419798410013534805418921853427080080424416858516631662017478379317719564972819853932046680177232113856463357359458403120564443124233073765855023733411825725612647529612817391285935495e15"), e_float("-1.9411379906994557431850563696263129495884428846720100623092797164798897849441077113661781002339700843817342085484550673012230835177219741310024252694602498718904012093634684589921456074136960129522017655246755212746655028056704158968756617698987691227746403475605981572554555796481625479885161040592226236520208745525826259998029461324914381294247727824498331852028350700249399259625347955416324864655e15")),
           ef_complex(e_float("-3.0086221434179679920526198240794356231967102767218916658157467774513795808376234363785807338589316256060693258664345019555453282681240227755761784778763908668971440499077162782328446097111612615344486929752924448807500537045869427801167215461134009393358611535930664524653847903713443577050897643608927695672606035090425638978640483251251025892317949302941154569188839208347253986981403080421774261893e17"), e_float("-1.00614525466445804136200103807183880310875795573898438450019435073052657731254575425771722679859836167273254129503873532812154877172028047149831591507181425520330976676671398139312255637501057647271726991525589874286205844990188484076414435998434825341468849518472946901967541149702498951179484830983023973713716552621668562227674454565685763585848137692032742003834202496335883455882030321050654018123e18")),
           ef_complex(e_float("9.4273324048026319892524237449141880906326634096238549364302811890039991554110426241535335047844667310187139161483753707348179874879117993334109230422789456140775541284606483922728934884163460443244842510147195640049203884781395655752524380439468610262957418251358016338300446793607118013136817011438992764868342182807889287850938772042902121651696894124757115486954783575156374608750868795024280711434e19"), e_float("-9.5618995772208862831866084572226584062341023761960570172147651611905169967961975109664024161628914157617602530632233357528881640637088106130282478513310144208735797704302741522906708072713413867219879722442679541523491056051315487463220656355347014164622543011065262114030247807101315512904417641106777418319850878023443375684358238324272555563977851156044197167427037209239899365002570931956544802855e19")),
           ef_complex(e_float("1.8223643187811320595087732717273133842750788035733747114947357111638635312426102269776367764876898342047238854099623606623930252205579080889407599211094134787772373061475990695933934961496398219947195817857027218675420432583005239792116960442106691653123388960799363393974767778760309698791891434340756788204088527359035350954535792560731399540122853185942657667178131627176465553047323150413563056178e22"), e_float("5.218268675189603628191162018629807099084187261173504970894455654837293087841784913441762246440625745947211966603074023624248862337405178768641487272245420979654973135521458976176312509959289325727783742299149440367998538229046502064265833636491423139287902717059538098493544468841640103778359385725145206948618795046497455847373849887448260934988827319367179907635662339202104584380572321216617238765e21")),
           ef_complex(e_float("6.320610595083380631035255210631105128445127148445441234962321032710403288577169389527750363827704361379894775291950406066904283885940667305210260632284239944544825371119855317028293410481412634866315261072235622316776811980704018777971450148123656188764058788993868717432582313080903660353471936637834027478016013627643924554609586541102346172377758974478850248665349391293797597874107835021595906435e23"), e_float("2.856121448529925422475796895653947948808670304104200329638572488028475259250583359114123745974652137289369659483909916274470555051126550354453218103291905317837385480907552705709673120778995802255514806722819473321631717901048971468123294173930473860876887070223319725871152167772368038375870099633109470732170444177407786089549876015125434882111029555148818886600235006464574138328755006227725077449e24")),
           ef_complex(e_float("-3.7063375746831329783802411023684764021771666604776083289939003453958150476218786451949741388598523546745754661304967817977932564704744483639366818853915597591145128790039532542733680466176308693238590140802532578518182449365117856472277409925072940171737344006329659056855207680630082252871757741033743536060557938179509181785504560456250633260130649861266951812257401989062121371063710097105936724142e26"), e_float("3.1969037921332599967029855377996878307437171698457249732777937926103200698647408165717111093948677065905161504228979874643549189468349173554529796007371997560862592921481720115505392686637145097005119986650223872594697826552327209676272262713971868495526408087252304300883166281009241751923853856696007470956927419346403600222706065918216486191374375651150159663624814096748692555971716397782065162809e26")),
           ef_complex(e_float("-8.2312899023537122577226971729935935808903420500112652893744084726087112943954554926574341252082887802772854373963762283057004833415320902278606596573865105595668272443288576877439048908975329586072429266829359302676320638307075504066046125430530253115973896382471616243862598880821514899498971763538181358282040544514039395333485005169379232632921915167629602978434955630002875862482526053827087817776e28"), e_float("-3.1707532237397726234366122780808612431259230643399352114986646620099231015000667932615910181464471789348919483478173798810368306262763993040442131374161848027829931592611107440297672013871616008394697128158378703821416496780048408053046041797305141935889548835074183340180974345157011990653277248773996137104453530274141195636293532836059348362448122105020729801167687279963728819130672965052639449444e28")),
           ef_complex(e_float("-2.060397017933708701486994428616537999569610674396168673507769697884693903584936591689282510003046204377165139333203255205868653552123614126328120195444520646158112825873531478708036954798803353632337221425223898913428702853393443858988166643725671674885693713921710168846459274362635834739478847436988384871848689227445198795229756072277350930579616709679864697323386316795423488836210352337860640274e30"), e_float("-1.6900195841034314411972200229469244631545532812129102083410948692674712096411247705397612425630918009071000109875432006944258652455200913811912042511579248045018400199049624596174116746671142398660420389332350749411342921269958808545985196073500665773512867111408396984237736180893790439940865932843529073390126949201301034348632263937253045288521209029484746594540663505972724873386908729304172558653e31")),
           ef_complex(e_float("2.8745137968298113367248346176678663865096800677616303914045216462553995103448529946038331501578091328157223402931887875877995455609150303953447319589297519221828059306684477576778354237577756338822929190208285421873333491812597967922488226477703798428580596535892140342892090366512929294708335971088737977360781401647046191949980205468306039351784092055738070205252085262957762065932575888676299389501e33"), e_float("-2.001269305350098139616989480296192072780254408026461107493061467159287458064170498272404870620257695320627087926770692323008014070643657092343961247203506600233555509965315529847804860073651227746858236183067003196313792364780239410140010365519907769730617808024387090726422879858167242398731628562622179979682551348162301408228161983236517498106989787661426706152887588022079780486835684146194256955e33")),
           ef_complex(e_float("6.7924475694478193202377405328330248443245375058139669499540018005117891312884349167237702815554425305091086397327621352068113012745642087697390488663291491681917826434175845234017661231058626583140854034826449820041435038625155606236536642928235444710249081616975384433832661399955398555567588116877758261527757330326133565920252376778892029643771705011641775643034527591799677580552842728100260741902e35"), e_float("3.5162662318698979685977783635272587837961941752236729815077858480347111015373072882589964510124720740801547501086077571020057941031425373594627491072173090282806748192395229877989691464933628794996584357470653750714823465906227328683193891454833306455238716956452893895522450526552067421951999522554373167699481219081724427310328612161903759701961900004766928458516432927202811686121732269700513946829e35")),
           ef_complex(e_float("9.7420096780115015237796189581153571327278924145050708286552966093978756069409523761397469266296521572073448730253302121582423898393931588652971877697151191947826162242930711834836926208441989761087999406510908210558064081648659854613237782105690102670928268444749075890986235921375829978821899716319909639059445588175846937902694166683071879936273576255761099414996099453646138638844449385604808277e35"), e_float("1.7665111598913043062511019923929922201046290409426514863720008974609950119159989187282096998322000237884449811649322567589958175842243902654519674616794959550343122214461635130977595165781507711992833288484821262009062783190825449225117524978730871204982540706082376883239012480055991539056163222210992591869240973557490740883064581808120672207280626299807105319583847047316287127739945142966712631706e38")),
           ef_complex(e_float("-3.8011246729391293712799416213795442354687561420031844764138384499062105282853331418096094041825787453698027076924872097061681298044746461463014379939053119086046271634273556492120283019199505683791538581795696664758029230078680111217062687133574117351320972422079137078336482317202482491733678676027540841438417475149436032875544881694238170459802379797344388485859161840251139560162373633849726849127e40"), e_float("2.0136504067451285301582675372465855392692797762670845233096022220633891044423161373303523777119694254856678707842194147146604163136066054376611304069522574287301469380488236557496075930673810954946694686636012772400536166937317539313583959114207842732748950346428026140839703953032141487812848165279084461203733667997245580401772002484177234389584243239402941622505367958118698359906221294463207091034e40")),
           ef_complex(e_float("-9.067566533176978344853748394139874554601801049479937120130842166715750618119385403524203261299209934624947500583732382321539002208101873912250856568723766012518732195479859984146688146526152279733487810187960051936820060328786189156308975715706218586624204612640129400608838362847385037986856675807535494866372857915547074303368954239582684007016902466608294068664662717624320422936946881292163451693e42"), e_float("-6.2484508681189727513967639668121146005535373267817383493899674665892532859151919714225954351644896470210754914551553646906599166519516889952843470682721002169976944698504907953810275817302901875341574679428960734657536021258215556239621994837543056695050473069500946949069677192448293769663165814281978464092208454332828012414788503857543040561118501754981313749437151986502118355965350928968734832362e42")),
           ef_complex(e_float("3.666995415323320759242485589588502700346835754530447922381471232785760891861786668941051973280693679194962005614384789134579122101407968331177524625012190758444679149551220553400193447485738908827605557322384725607845079889185026295354424899799782880226229625856113272660990944531658984010324145313763631484299925039994912194534148094825975393230065897524028930132235866542456154090796796910554854688e44"), e_float("-2.9334880219388343916198781314225015398453386394834556282129889622988184793477779584777250277740340935545643445998161410534292625344959935674416550467895000848241610490304056657094591600799021918958109122213678054133345340347106070958908393377051402858621023019441239826268767881922399359468468756711965141872782376929329555294588246027477311689526602643236605477298236403335300296964083677604910119336e45")),
           ef_complex(e_float("7.7906194020961277303879603436689895087564991628872674261441983409303799797359150063482592292785882061383005923892221487738546968522626167847166628888540346251949004355410515787355114730235079034608373763602760293372241919297661751491043669486808682950247641977779910050047339141310217117148693411318213572969266956700668660099025163859272861584534623138382307982457576082239902496068975310686776585624e47"), e_float("-2.8750277112250221516326260418604541741833077701173255449477223540883200236136984832444392883111221222067032145021538179856960402787858907612081076979470401870660562504547742656826653903297020155965132535579064874755721327367738996203616625276266855141591432240840594958232740690895200113372951475328760306421822063024807137199373836518909363381191154692333749559235052402408717836265320326724476839432e47")),
           ef_complex(e_float("1.798016796323287977248325635109031023546890186106479436032444119185330915683039071709808376198041335641675788475817115174588074749596039314809755278687064076159597576209842296035207122180354208301584071194740857116890957728495536878378381765713263745019873342838393543828773599487026217475000302687560504795503412514665066938389913777854283439633729215084645606386646662454671410910928461783280345118e50"), e_float("1.6430048443703304297276833426395809727776900897965433128553786418973475550218349365285996491213737588399868060021380198809087195833476133849698186763779138332517790736233384009044921995502746518025936136426297385007378617674014311864414103400809640744722874096525550513795821177759191224545894013213413414241368439647693426645699260382856517116207890294494949163384240007805956664220112347148302577044e50")),
           ef_complex(e_float("-1.9457594022627774537955291571087420240801835692890603778268456382526419149047310772501122722274599059996015762587376886805196375684491464870010950882205212694114678430600008697337374110674213687389029011457616539481273030117333581501995550813626165233922186819640368888859934024641823381316247867438409811484000844535664663058851128078994120008580346487151624897487169903111416021721728020970883086359e52"), e_float("7.1866392678816949194304312675490192010495902134517839495327964665188411965988258345838919261958548176430915441806919390826061448149486092142570871478552940496987011750622982291453824023276983435635925051557904988392848546054253331246577979456995091142356127031124948734932905642050925185133867778243775487431777152910331509003433643904857294892173162349365642643096738481988835789728864704844950853687e52")),
           ef_complex(e_float("-2.3156018924217544465233213457383467764058260768280228508335378581440980140350022003807555102353821507701844589566435007332780885792845769761036746215175221654909994507013570822815091833202926470248646306496765499542237311820650812663589787801361705247567336359803640982559861120478683602615773090643498837696576807815665990987306019689312005161640786011957783996999543487727715933205976764313282387608e55"), e_float("4.953474634872653721387795298930380239806402096210015123188047023126311838142856671564810072668753862892895083452144640913869385756368177077886059393715711537925158306802817129450578626463552135775999566731638442376891592138741341835202121105597049827124385206289561943283439919962133015736319120039912122717376179527653556173212205854287990640945442321985182587352176807252949932203470813008526834683e54")),
           ef_complex(e_float("-4.9506994599205310510267020898588054575896039657756645743491914348644463630716676254964055057669178534491844974505838955152006100485084047907565965032116860209384665987746587433847167606237565345147901340439337324884976589496674825750721011781731363090366534461913808968060642054641123853733249590936688731971322897705861139850053915812718289447400907300815060149096143202869350258732650659332677017532e57"), e_float("-6.0581007477242419116840756424019390055511613080580231481020949437136473331197216316011841352398509402687312872160954378689084523220481334065885851639542337337799549328832543412373265925435947248839339466887820144300061294243720851046597789560552097346616120591569758267942165264732741615697840479258791961288457397802536774119795322819227442526799591746721822869494242340814918629204659082638725385685e57")),
           ef_complex(e_float("1.0735576487461335172447498394683948926847409106213654785560860578752415400505061272811412420903105194899405137178912836039244793892981483671800751613714913197424306483418812189126963257235049611085784220068096209517936762505627495277678729065966513502270869167749734352259046113123490387377391779068714076773495566561205832521640127553735215653514238791075374683836676779850842879668113509732953719405e60"), e_float("-2.4570579402865402391245838065578874394915858974275211062381041504441597225663498468856747304339915496509116071297933331529635838468558438928336696987586787317168885772701089521544264608820368066424575910254304745066754455373191579519942757252580909924661802938504256752941879038382727671883001666997803910853433579567772644970278599319592839966424136830088075447292749374598278545342145414963117925459e60")),
           ef_complex(e_float("9.5020295738601785120348461532266126245681934413314728261602561639081056581505275100485011516485300090254117652535256964740332727964604958670346545864221793939254739406369355649968827389370194993469458225600202941739353233109700286505105589610453550794732140792940667133144402794260010168393729231318541977510341022071743410276798539331619973252638011504452624948111389949188088354465298534782570526399e62"), e_float("-5.820040702170029897787004027948025981833457571576071049475013389905242525995204555123426062928168053560373254957922026914553894274552164408213749576712823986175429430971784845661304444332897280820026502399960250569411360709189318801862966655173209869264109790729042565102741742168598277928703627188403062288196615294160623313403263396040667707881342346760999148323437431410287383047705375456889940175e61")),
           ef_complex(e_float("1.7790597159851597426081833913288733910006885395192534185996955498484652735088131071686336602620564913235209888374393007245632301685100609357224887591970227850474290520169809845465094666761193176298839684591700030767259793375315257207659832437766042814784520271166813571742216591027593600561844521765182511600441344030859587548319458366505326431901746138332441780887924851484214446494313808177629746333e65"), e_float("3.0106793350108051152432490262513947766145892696294566429208901773589303184995781802159667278818372784098065539970227668459705200590214577195697926377539583747964933952811265583491007100585586142813574330587220195311539285251590648828113793567958543612681826790386357276175981472564749668630009573397136114423405890889703975012844612090496420306953375982863763430857980208044602293495607994688368797526e65")),
           ef_complex(e_float("-7.1088191334771285936282446584156651148346210744965784242371740175438551335569059777415354694964409153531878822181232694802686916747930631257752993891360756688281671163419875868419353657806240764286819969223426874527876556568763453664763775637175851189860110679580904675291828129084231559056752974332171389364429126244119776721813111992824615842088385867615861460507691996029731934346072679503357754137e67"), e_float("1.12122723511792816478361113814488034602442758927259692368408263191397917725879537211877603185916779872842501814332499655038232955716437447125916834816687021786186430762971691259128538724589122483437662126831683558396094863842467789783314173795335287045143057457726204392437210801019680208290651874990509602387356454854172513809031781568019401551314576007527674737360405631062601451481394267476424393492e68")),
           ef_complex(e_float("-5.1803254847153645009830958336815168840913717569394986538208486530465209626793480816745835750083442565756699435535548838601226290632880542011277341678706808251847095194933401321733109124266090282959767050982791609766899183091090150613819956440463498767822590727777054794281079845844423798051573730443113347115050162010949150653773257735634253333628938706352866928909362504883422521393377557244848755274e70"), e_float("-4.858393583658514917902492427035266687507964424818663256563970735072622278473975667682725812769481269156256260133623513240306228130152067367414901766485372485006238478571037552986869591575214351262155644430628407758026113829136015323585520279276980780388791884222974375268731114848515794595926890986427708014121584658414014019478737661857526800847459360925864395341410484238340072699657520864703960219e69")),
           ef_complex(e_float("-7.753664491307391666824703723279427842710331471428041984722202238199929465805078373034420015930478025993760478877825193458810628388752109927825491930222033388153419037852542479372047878563765973351530900533136499944610753188023921438204485230539785771795079039234487182207010595590051508783848413307280694896358580167806480492080007581275539165437399988995721054057386581830759571014850942935814897161e72"), e_float("-1.9548714028812034183545489309421317400082452820207310490907230816671473858959848799264243793125514962176101395225148486439387050872964436658051145169986845716854497062444916904525195462977019315165318432132016587818444934502585919340531790938519914825613596030772997414641953262130380954323783969916386074022387680745899281276987744681543735270883123797468303779356422268490488125874431137317251723959e73")),
           ef_complex(e_float("5.7913501985774346043849914151862476189613308201705155972121851466416351673255927320601336467851718002781094338013284491332774907748810092310857993174764142438909187033561434875892155201923358969233372511573831136223339161401752410258424017094541207500855321502897178961975235139702180490677247311242594672363655984398671988776341637929100545211063584898176920172079043758868252365530352047098182960637e75"), e_float("-6.5700731606061374955683496474576887945583544824694910669017413453089479988628625039074674515303012211830039135092891750068451594792154248628391084430438218541966268793931386690891022838702214223030674487413336931967066928776282923719657580214991758821895912711812329190361287952909594608676386450422775337169111501593040313100199694261941431611930743613068750620901098638107398535425226492601126617957e75")),
           ef_complex(e_float("3.6360277538899361902276059719404904238449892791017505076893539922261213540779876406447084214917428945893639406886626808001996781307603688383555783265896030850794885773515024699881729838798409444012028785818725154811826023955620824857530654243554343448655969359376643522237431339354388319516581692013211451213268414894711849131398813950777209954967973211860863584141239574619454594051904438605241646922e78"), e_float("9.367418029917710637096024524672032100408942904092793920392302686856088284780492926207946103219207186998141247979141566464104304029410019729546942872590896314149967340447319226799496218008715356064999988102736689181849862094552148477840228253004760372150534290469141367018246670802778991091862590399116985664260987388199780659811618992903305848507681627590256945396472352506845424076826376884976425205e77")),
           ef_complex(e_float("3.578570529061092305958969159457640178837219402757340474695173059966757984513687701942461524349372389637773058819060563938030954453955152843376293136594438135298365197263032031608452045275064433089865220887706303316646133660092243347029411125785680426763485212656611427699079071643773365583933399676875075073638881189233284644756604223280101729129450266717650359409881650333972440264369784886756312859e80"), e_float("1.6165852065555359914309835578966369565015490152103366185690926617666923344818829769890273127567854974642429691444338667311382676404243257201120293446174128551343369739649258818229427440263460921671057042494573722701425618120195172030098306956053911569907963852886541300185240459783668361230815714445904160948743012512503115987762453879168824722402689774938712608077323013779009175855836891146581130788e81")),
           ef_complex(e_float("-5.799138484956369806137905088034109113350906842086549511872652510147820119292323757135805448701932865998405361480973701088133948257917559114837798351923706190509289920841931880991688667895639168255542141081536473015684354352300144383248171567833032950446700352884380719891601920662793623749231633708923448102283800124867727395712246475056120076692023708322022621853061976597112764266347932412226759856e83"), e_float("4.7622373309195739358055320096138397113857713719342586686351422780262961294125100485081904303865541703781549010393932990893534900448166585787158119688320237431741244241249112452129565483495363685119492757467467241535739072580969165095508063163327211997222133075886300621455216216722805546220172699922903450510246831711662995075756779157104570603733041662265963367487264594627853950237868506576368310672e83")),
           ef_complex(e_float("-3.1978269078178995158667725441322593955314710899115388564389771354327210683679296979380159281610158510772139577786216539845806032964398311484630065055539976948706702185419142114808254656802318699263165710207119663812868234052969767531295308004842199172155410718268364937315868083809466928942225526193564221123107803585457862605611555414464066067091681414387293046130611818189122508858171473908398173816e86"), e_float("-1.4046416579187770415318857839401762160662334575722307327215154277531490251711819985498730097823193022452967730804660470345192801289459854694901738373212744048961706787941824948636673302195602583117196169711318223258415360829634564948084105914611072945642879743123974158962245266675675765382230630829456681633240322329889254084517052965090900507297185471881373177279064730144516596529611530482924387527e86")),
           ef_complex(e_float("-9.2108505264773483154919029888832246910879295663481510553714978320937001984149317936033611729987189970983734877329454408258813996677718949454384387413252336682726699605893627840646230014527786443227302806438404729857853356869526959714329676533119252810048961212780857593186989364991472849723934874897082419197246776150019431784843024110545918779826484411708849481679224176821434979233260032826078601e87"), e_float("-1.6658885735336094233959693906709003216530635377806762335490879574950933200198762722501609890238465531862983968353878191712427499447437776753361003697020784413397509209156115470001975448189595569025477553275682129959886521302697989308232708354239142332494369012419716906702138060755383692230285213177353972984589207116525349547564029527624909556316472772169088842593776638882794210404703891907971020448e89")),
           ef_complex(e_float("7.0768545484743632278020176560717845480028912081143661839969969770900146997988379497491592588802020710294787932710838997206387042249507648994888146932209617981838827821395122075641236899912390074474328007787476497512141176046310568668325904251410789487833386574526862077736067686241841930568599303575958888032782388512617283706884484945060245924300810992132435718782725014833312070238601405671859429324e91"), e_float("-4.0904775841924666508976285281549178444405212020812362904292415907891347609691091931100825033857624018423219588485836752557872763647246076627098593530144031524820630929311690915783065584424302571651730916480735000494643629868551185843197356490075925143026985403675410201785505514609344962594320640725566288156400638358144484540309981685035176470570304777837168118842732192138423187966492845480900336985e91")),
           ef_complex(e_float("3.4375876256589406178742745191193662277184368207295519748275696045038402917890895147121970519241143140236312032874711539453088779459920177189515505447710333178858932061836863324927220085165242893952167743170197362900911010607749561761857172100449575550060423653739663568469923339859037031708951485060944700398925931721836467375385240328352332118363888051703596996362351212330877157691419203582528462638e94"), e_float("2.2428020353040873153687561091076396474423195328738853193631307716331893897859062078587062891592075208380603135171985749151804037510418155428779580098140352660232531696671145764676306443346259550054283111155756867390356404554027274973416296657922378768011538038102618678769273449593149964849411551785281662771424624008184737898223997215468704437106307678741725499430328307073907581138625644660353427847e94")),
           ef_complex(e_float("-2.311128591579080939159176697642964866443755663114171425067716075260270543310366876914329005040433507269985977809660393767770870059201883408785442286769111533562910343405340192266086124811173297584490200486880229103175146178361800782862379370665459267439475552984395872686632326418514997449105855613469520293018878078664818367457402807063677300530298982443527642957026719260657385744736985511934872173e96"), e_float("2.0985559536211343918043135446602861997666254885313842211132868769841027048943823278346857342221874536875286248933418271275137876210911338513547947531368108315125055985277082965852540412403155691521496819708141421447689488931764225933341502066496722941274815754527891730690942396643461505396269422510429934730933430843998890293212601905366650910130478467184756267215426620667593837403274722529505533242e97")),
           ef_complex(e_float("-1.04107503192647041485539870699531406186431315090487352191921310450900175835830365041241624878965015113247723063041666772751891241426574473684233139288473123934280509089399150035204484323954609357717206032162440757431085401737514558993416930177199261827431189644098203255891576070343036321488366391084004429953551834436563883716073546732436824625608031429467332755343380648133475770826102985918600115923e100"), e_float("3.9008476633915212155800053408581278478055505052579830952316746517299806729973374654351396629746158836906236326720062180903915789434924382660015564051844057271610030370761370679275276148254021710696488661615223539637771235067329872449230211187849705054610246460976610933265276648744778093845692201795997125548336455197626812754237095793976527113121500111875991258535051530003761721378854082950165754934e99")),
           ef_complex(e_float("-4.4061718707764461910541371201611716771233061343579713329977136254068966932808681948442294568647214796516424731892687765762126993513202061215854612904097482236346369643107023335162821598277851238153826652678999167474057184453693685467089943639970525047639843892301355568015222803957727284743274472404783400772681839110679520747406307747217831416715214565203205380476376916821754647101453705917672447277e102"), e_float("-4.058094751523529616051700088839141191218634009617471075753919508088997166877553996190686747427229712069989302260909864834736666573447206994917981041363235779727434404697103086136144457256189722853756470825707957624778824366704360532531767444422590795385029336694080840092031418326482787835923690907411767212061530442931381385886806774588185681111554145609659255646609621934093407911188474241822220138e102")),
           ef_complex(e_float("9.010128622400253293344728422162392884529590340016583082378390719554900981831138345092372743828668461218141678421174738236078627987377618621589375441472505278446445080459103966157014217255133668303849583678974574767646263964459111768645574804964560742222521987103038527191249377036526605562369809873716290489720799704719943657626554730840558881583182755557354794506795090708077273679660161130152094782e104"), e_float("-3.1753490497106869025806265728822938234373258540637821017072886080664077958499736736730420083595644421301987332990991836004824042874166019069151373401189307179393639903297118342715982026467263966103665235007140466426362967492943139362860685554713312211180269558714834420855004030597081706860903718178505769559496202504845905002963017895413416766125882469003426374006564725387533330024432036461847921303e105")),
           ef_complex(e_float("1.8251887043455191645014855805657898075157057829404676697841330598351224865697886268914939316344113969237395499606236243658445043187180465433919794789364610995387807772015794456942447486521454988391979112875842822180142835186321319277107841672739838650349359984776923756617775839187246230890185049180097131414765879338024341653493803229672849912363768506797825220073072555443100197991502476842372803946e108"), e_float("-3.532108147952886970838150876235178159179959990844016721691682014380824675775653700715032172689364890110197745829745028842902263025708881861134954723963694945437496659762678234552546731530295995609296302162936844556927641472839129210913236087497216309277072057085419639377001867127656611503687632218875146603333707185929255800866979728548412319092086804896061035309679543203720001614751348276957832719e107")),
           ef_complex(e_float("6.5473967519776557465694744811593686325285091848593099966429170641876868618436381229040212944320993533038916349234239328651431971440191469027546747283894683731108933434303598269333389246253785429214005074287586219244074986881810911377041324149700171944240557657373839690106619264098069021571180678028962070617479904610688648679147097135858555660998118168480492356039649107918413819178200713700749080391e110"), e_float("8.4599822358120374678374062079333121550696506847980793078542391981679662390933518478610327406484936326469450532447802197482065424603929082338179521117536654150792689053308503237546177663334735867395573831570825381102978774045645812781696028704791367047498795543695558480281077326064377841323117258805712698056894543270485903228759693010696849726389797530832402678787040720468147565939830936522355972437e110")),
           ef_complex(e_float("-2.7050463570670573007823835798169125357387792970680314788990479680834051889368642893702799241136269133293592953332939733769265147102018952774404454862235153155999684115564548140065473456898082550769080597002855487695771931134353610948437814883231951021046558467130074330010139971408871895162265627223690025208651025971685362370533249650049755895096537153989984058534958527860077755426068636172638164056e113"), e_float("5.6746187189174055592437622424957153702989005682812098701138631331812510003414360906610399092149467000419770002816410338888878117376927232239280642725085017940501782456817535282315024741707600596772770659041890947995723925467374679863294984547643879705879342720798304456785960689218780551186972925737833044213600172072633153194751763070294838671500940639164900857317906744531078426150558623922482223324e113")),
           ef_complex(e_float("-3.7699064705148854856721551149358544267807581372663701929966964845799938020882868542314396505417653910653164635391016872150448429374039335975778937975502183366514158848143084388223936177222994684050209196543355459071064641489546325222881464757214439254047546423236655811748301448146596511215711753376553240058963465495791148546531752794748107113527610111583932547621211127237411392040307191559060929849e116"), e_float("8.43051063709615014539340335786610582127298699284851575871029132857027162799822539149517555129095657564439099708534062022038109102675139872445933246340889577824556734242488762529381977081405993834661285344339213827139127283130994685951360302407107855982527767123118870600967837909504421947205761401687460706072734045359073788788482363671817269532648250496271838910080334519372366928169308497078437836e114")),
           ef_complex(e_float("-1.0849725748528691005863010701540991498047791461742326868764254756450172782237649982143387866265598488548744318933595727231056447925609977404921686453453236947018738816930530969989946004885279889890394560894294393270829843686452267473522122322392050357364795414308997816326785456394722686559764526415093386939476595057092032878162527392888798341012835764471526092756114146692683004997831838275028093521e119"), e_float("-2.0370015148569670475315514464541309838591800058462724520424250323189315427661916066641903574784187347137275789675393674188178917826095430496900108314781857202059935365403894898831805735898294315726719430946264970532246705286011035176239906628999539838919338276585115938328089020158955367602708489388256124362218694146419975756564455402437872128300378756331017981474790020070743575883545832809786616582e119")),
           ef_complex(e_float("8.30595136452850727244410289985090939201379224837457442245948803674204828927367813529616624337237386435205956143554099135947580613126648526185076226958215396411332321622619222866903367491588139634831320818612436221872600761454308265117318411996810086167138703060026859799338366508084192724423896965091044496835187239951769844996569487644888123699994897621335470250050922700860045616776037399734277822e121"), e_float("-1.1771838910397532633689872033112085438658621900303564497548555881290469863314325987335554288488084846828831157903031145267090295574042353417196353165820886289364508655141272207028082461106908787777545927298225487792216847305009199975934142788234753946550884686675998541146465871283551105019540054548537386853560711657631637957548196505341673230795242123811217406227866778317910785695477130690610345951e122")),
           ef_complex(e_float("9.0695102504337519401764417403293931347951344013323782992075288032115259331051039480287798822779746099815743809344206228153535435740202222232239682444802548393888378343879219493941456149358027380518365920230414320367477484225257245607527115587740964889995823654920966618859208163252954774181555810158367820026976383255087134510105873609054108358016993970436191743189329195922452384291619839660963524087e124"), e_float("1.3489749087567970114533139961192828539766138347072844168194715289437018815609006954624032868949700663215957024040008753989939853563073897881230110449012077801162561185949884920125688232248705349666832319241303866767910134309702759053281121730109102899873520253014376344927368117445776841951876211191309584877437680522416829869459213252913869580036453553397880806016648529797384667701365047039106821652e124")),
           ef_complex(e_float("1.865453537563237635747772149819422769707591471899065072889728106490943471054720410291932158460374672818838587351066380323339203020648857245452864750522271365906840365916393056326507023347808704838063740423263447657895487342960016422762593466365424473578220353353331415054513353830853641010375766981097073559598719283393791640699687642239776341582533920593553001797748064286702875851536682515248708452e127"), e_float("5.6474084603466401314573951606183500382024945021728087577737512985693647769827373036978482272785682495865750906808893822014418715731767471893375367421647550130348095507018314720394120910887042831815030487450119260862910549453246336803366133301691497239525861069539213894207141781932593676849984160443143548393991493612167563134696186402425555349937685392745417865660855280376713054540227966083706074607e127")),
           ef_complex(e_float("-2.7785324440624410733533005414886005163185690766297904171803280936394943522651380897133267377237770712271874809955006395548950390086482424545008621926517569980722745093049511795283460058559729393798160331661766151672648887697179418366950567759638819001829229584352425210445668767795423843479738712874478116276378035535024077788171228139417090903889109692142473356366739590530446110154440649303572752364e130"), e_float("2.7797643870543586932425621250339487799124695520526880802756320898657237943899682067574246927180893738509708837352938702134655744581253925050007522260269770709129283200157917051308729096751580030059152518422108591903087687739390635429118028575344999640384328196640606855875079541818980284655576725842960028958343585544756344540478780308032874684853716735921598413489875132136076452159621303755595328026e130")),
           ef_complex(e_float("-2.5119884532494273255720614985865681183582551183169335620569144297108190254151117576688623451173079848322365884214954054210778668066738880806954605123590373083171798472861087429209451083721724900912518107595643757834278758934932304120898818640284220418848834813015610728627162244502850647111069101203050583503544260064289691092197365197266200205628257252111270478091131837123683037464271229946887910923e133"), e_float("-8.288104900205885189350132124638555850810351294647700706811377472289188181039330574440343875057956165034377347837040871663383728926833683388295279150376339517815185041041106608116623210989856647678384954433802847077889982998611728604733336247937623611167356035100619737343961946379255055576807079913814949381560858643910615478978065609866075294031717594161102384831512595906369696771531942459108656595e132")),
           ef_complex(e_float("-2.667168447471110603872410238947942356433470758855442038215891736441140735064705346039959611176460202643237253409263453954783767973870899892670283749188123114844709864631982923379782627439456534886157790091975094305287225293888488000384247281427641013565637681159829080207464624542361955940614546933467796212919970857795574344563309065062409321817326265378065763993466668061309017629005399283175564591e135"), e_float("-1.7927855966433321556370298039259259344320939810502034923946714871485160357256637463924874107964152114895025127077716321091404517447855148974132048403021455519215172878340243338606949022914592949823883152527084495389345650757601886850054654007914518430853852706683778730365621997533097453948508491066034459200639603683855464001765624559622960414188842964567231331418036838608234356619099427449443263538e136")),
           ef_complex(e_float("1.03318839847882187996135508183366114909471811951591083486137233146694893248497185483256188986546320369017448371607423374052964370368144189350807339891434653119530682338149137016841490082422628475660690574611710700372913229048997781687976455557248717446622943700609746996622979730122212964813767860639963046287152831731868878686233749025575862391782105548154976992324639093741548799803611357667455762942e139"), e_float("-7.2825470945230433521083909331829991863802063919918386246093310529113021420068537817320551733915581970519947789099930762083543795823400120799139567791159885704780361749990802018928027194808725317814307651465294382444170927840281995270436465386428791106437201920829453305005639226691606300788984873702734074130272150378174375914839055890141806826829472733176587622396114143630756760584982657923550286188e138")),
           ef_complex(e_float("7.9116061980037565432342854371725591869929997535455268531913934718686216643370933995128572618505146671767449240470272390174675780576339228242058969309967698678583534905834233684694639892047228079937014595816356639974060448255601618217758270686651856053071512413544536706125422111654102284140895673654402885586959151646269712251029131552210084258342266301772355485310628003172321814091509419973641227353e141"), e_float("4.2261622483898236025707620414619496109178206243490050599264851857548675051381345471320693565380272881148337375989507969839939895645947502172516945178779274662036717490898781442337968055120355310792104280988028802188356915569174330212881151561003301497944637615785886353551604794151058546761678489239563100593058292996436075510456588588541070273373107271857803917352284632815909668564537309594545452795e141")),
           ef_complex(e_float("-1.585278740706631743188107532707081123371360447319586900599314342014609148695363041149653973410213727866555632416954720747228554011146629859211129786388599030679317129178686718273879749342036342697408734517347002868557449985895491743552274666873636505358139052768313876245124429067180010349057962432796500869310710039443512224261701251768601168558394495297619993883746999028465511241053757948544781989e143"), e_float("6.4721261349070585359105700418076824818044066614321127264643752945458079621102691446206589744232253553160606502208626810378974821596939689263629562173884934093839768764372957839053080300404051503144603109443470135866409693197818086583864863509429187270106896175667101323212312525276196968336271130863307545066471521988099497610179719738957161646670359872424229854231190000365117869949123086746543662709e144")),
           ef_complex(e_float("-4.2959867996431308459078946691705609827917958002948675791295186051090907671593962555355241229759019917012004655366183281336862912959252032461235149138827685497358958387259052478126506739339417992502084256179591701389635321663360165278766151876584837619277701241513168047776248583547052326131811237791626214595217868202390538183066542102686366350348122861765616378376077586096051009911605517881332347575e147"), e_float("2.0306232915835911821962503907822320615640780490770599301558608354725692457546192342362975264640716157426005470356822545387889088034068073107396900641312516840371766842686506035194819130265950752462571170072099695653140638385026672909960122812022898897354197021300470860885857624582374448607485752778602295118538399785382775765831267969173753511881088280368660547174299532178227820714657801359913494672e147")),
           ef_complex(e_float("-2.7937751689473640868120662954466039072094184441875079682141629875334983437487397300374275119421481114492738460317998126107799428556047684317675727262958917409682390332667827237164825398274445769654933708294278043396069024384919953675097665946160089321958244832837884238629588635010779086098598821403900314699101376698947033544266853043149038443578179693187827433564366103083374783336189437097289897406e150"), e_float("-2.1829690882270105100947017000548956096831953653768266048044544995278967118393022944881663290102994142213564031236048762423130405393410636216347114200356897273189882299374661173941342117220429063932968691809976481093626674495451193940923671070619421261163712248665864256182646996847704436626508027642195899139884650801723066058470705029978312551770316698938701644346855945847957439864895556939433959198e150")),
           ef_complex(e_float("5.272553987608450528499455039464256077988303969132864094990120366894447486623186871275674418020284571614857332377313452489905004614761624962895161316461632694063364969218659060992213690021869912865162101634986038527888349740931392369300233370712120766827965032539473576695901696794067922444681466788683046350600937977728976213503453231011737878179792934677274446100496378133531757306534634444879437897e152"), e_float("-2.6364570966823376997969597292519310430567152094218241408605511870361151834910179057835777609402273515233072283600778952632476270033793585061466674500248203912654245399875581224363362716046753655919676335728699308333551289641889266393082376713258857498956445445572954469365087342586825129723161263381626856012745882628421614071187454079917567424489866277082261205882884668825140810160581208252517389381e153")),
           ef_complex(e_float("1.997457472463376832811364087812207649166267226983798080732633092608157361043814959686106057543760920095909767708268386966665192804496937584916511083936796068640789577408513758387778208208078307086430067519840706720642899522178214841232262070994737066479599530621884481228270909404822677150925638921025138296326608737541516305156796466504050255561339802660085354718473723254145249033068485751809385258e156"), e_float("-5.494662567345583913779586412426324724448556859261639435389139412709756901731761060084606015437301466856138868976666080956971884074843923798267147933926149447978969873630920528626922779669171225971960689336925566443201735594129635441714480550656288491918855484857904647912547755125947347806459590352707600983724696438654242306595965027224875866240511392699298940965091737532273513394938210153582511435e155")),
           ef_complex(e_float("1.0863823750032575592050079474562748189208031978218817680708897136728383094507301038723221244608787008833424120000594136508531030432940845498290440611699782438524641113975493372928082488777699784640398619917219356539662269374644067639527981674898052491180706993133443240419276130630244026326877018288971194690656175036956238970280472097844219149187997443114269253619080062225096082226811286107023546073e159"), e_float("1.2037270236593776367143072288350430978728270967702748509373659885071480688514830893083586219820546344549584204589879183587938028254309657909815506093778092711703159698131923601059250023975634790435539803631407799674179219475070022861019813558397718133051083204079351757608374290409512937503985368873364352166300894810732384489707360161815380093959149096328428207065255056505261811459228637616172049645e159")),
           ef_complex(e_float("-4.6715353937667614715289648295205459488149680998280196896764628150969144640390004411502013543690921279807548626249954344148476493011988580065764055462431752514789319427069543291972892801904974464100795247586505611529273113304786052607524533920871803354832647564522693992514300400636064510314054479538135267980406757508410542175337048871772596552200881175552508939670605209310901580057487526453635774491e161"), e_float("1.20123539529296312226895984224492535465744793756318889673741170912161791879467716527946254047653014779326052809099725408806976796569776392319491669043742868370480842835014731708337829750767412750325869996394139295833320119630610100809948303250816279581064839045120033244059955018044585028524811246190483092332628461348765309982183147836623680874738678803164946475812482006476414772759358464818674715517e162")),
           ef_complex(e_float("-1.03553160430802134065694655910943585917997935480277057613198501554595047195415154105283618118261903270334519270082393418080665715148880996072009217826639531593291268870423936214499790613996887370507161189563121947591167834345271457099453755732055296897910758185842140703023673353183680457429621226350321662388669352853868749296260235152343179297411666872764663943154517606818387494704401515016317568091e165"), e_float("9.840213768635091316707648806832747819843091118067629673368006752105865102740089427721808833604137045165603138805735361908068869506111164885513349304748910191309023860293837850948590422301376404246005701461162932460270812093328297719049471325440813381463473555871348769763416080107047351798385330271795126743413113535102213021167159364107345817681102298879656448915700867658804640259928232882906943648e163")),
           ef_complex(e_float("-4.5289130633225812402496996168300252195059577996455173988302209614153930806762436815254757556500524648187150300062866605742206543969568215328148806049088336100568884125986904124124530939068064445934628263686542927677022011572820743697962483245151902744690940793243899676091957873374766857766680060175150364257096870147623173690031073374497830599515416848456102609326898374652682569583626733427604134818e167"), e_float("-7.2185786514853136501106628831653023858334224870991946429396543042403696825220175864788679955084731206924092086088690344434421100613861406358919664576213566898607199347090674660043589362685005852243697517216674397749077016870180576146640785484491273886193771718344534802022048824440903246553979361745687619561571252992425374822275377729079508544781425100310543147910354252438890868407324377221522298274e167")),
           ef_complex(e_float("3.6727200308146561162914379619227052884212269215225110064396379406413805926617440289272946181518567178543619609170808234224116642386956573296257104871988218749129270047338428896461823321631861785455958194064312950990613775220689322254804512165551291768474440344894906451017050262265601009392711993843118855172132063124848349414101168511368929130187104798013073110034380539845498724612503497593185509134e170"), e_float("-6.0588035603186176133664964139891766281030425472571229423139051769443747759229056959466185232581275332646237610779576465251195935340903639557039252019137374171626495505650969836932344855568656744991267202928573775223741832372922482409872235995091075912987821073714201727313193753136407531941318486833008993801758092815764565941735634503740967990956061120256882284195245364112654825889663280113956775929e170")),
           ef_complex(e_float("5.9580367229737687469764238017135017386328657661241029759934993296477276900320468845287161301761496947275066175953108964781804132224702766967195316874558582284791237104636488602570212529398155760594385616536380851690670403119133175952265813825646218357295114283574894657323020934887918785664878648031545165643467706418958684635816952626380938919849760689953557228318756914706544593188752358133253650956e173"), e_float("4.745352975359602133134973266033467768262060785951184696241668463329588744871042017614211597989309950618024397332453181735965743391392900449149835621153567498204961039878871893593151541074021967717912464268094827439217009044682263984879057896719240314202559529396690443833194300945841490639813048538569767668136386844576363828121485563569336073959262871318007200577241067947658145495489764029522521301e172")),
           ef_complex(e_float("1.9254021325395279550427583732641556096941798601335295413715427809656652853858582604089827182759109454417279969099138670560426991308157767318684318450635058828611028713520671413522127726775012398081892796782902926919300793089135279753163559635779407132758506024581333664757875711284195951049484552233650248177676666994849585325228166240190943752669464197748953375054729913341958135922123054374895203604e176"), e_float("4.7386300474200515417668349245997231595182490890615960693424190951317234531544288000858567044258136720670965293935095503225182307168742053249887062647408924190524574525709752865971080764601298535393716150409405400922082818087546284172544236275904046309132371371684552797990934119538119342185181568998872439785130606910420632263086573836432251875696923851612893795423450287897039573401361672814717817962e176")),
           ef_complex(e_float("-2.9255552646161535543861914237867287515586146044463370140888224832012474427762387086419081911549988712550665238444439637089219293161286105242300960148834007191603237659522503299234837773757389961011067754567823983323965029797033607076946406117057853796602374492089481574687111503112800708857239288461686304432651601760288301835503503807632834139927788429475527246709137832602695175259926680821804333221e179"), e_float("3.3391091574568571786257907410348905745005886326401986794324320541439347560992268864808200904082389216746640380249237983760801909911094172084134084716831779659365520277867336215962159093844352606319354807670053908571024399295294454128537806211017498064429842939462152220478844293816941017944194848189288067648946515773387989341490413330818494591955439752752928927413651341295901476352952946762846467745e179")),
           ef_complex(e_float("-3.7817294856709692625945522605815395895501993568056872204745872797783033200821377266358595319505840340069924879014238229815879369743397304391927327869749091473784343507811036267165657044276457965443691828144368313801200526638641471718203968030073147627287287219196910768228379644513919768363664684488411866683723835984137881595753780470892486587145006046702396602925039791464753513123194765754333524426e182"), e_float("-9.823831098776480903689699599252555349695465089360087196559018021415560453259270686581970236628368681205181830122308089890663564372660120745804502296611450233360516976773252720248239992443365762859388536545609647996332507048001103273053531034129085079214026744201934126379064487037748529883786988052642766223796760981470607861223831105688272772032743643751778524788064358588981998045631819690567460552e181")),
           ef_complex(e_float("-7.306283343459625882197992616285233046918212068473433133066111548157472241530712135916190557940070083221252048212514994360280362967709297929643671933918532781589075594287837034029679318143373377447707172052185173626829981216097563200013593393556215953815003641172357438388077694695488836241166571291049564015346943397066260894805830333138052999553482968095471934674016738234664609112157902986170632203e184"), e_float("-3.4090120093005984386067354984351294767137336233805009894748458974130725662197556897107699479418733356249047009271114110241633019296213037076554204633680125407716173241624372342625253791944027627394543085048962099875773885379375023539694613092025329013691732274304550945613139333691253811907976857342747521180458384916285396931094034321991237222527506421240986015492500455983712269962867801940211786223e185")),
           ef_complex(e_float("2.4591692263571030902578020446722095584221183747973920383146068941710861087049440930936411071900580845790145173704618615864453135982346184202829994830264085335416589091360590379719484218213309647938111471623044956751665315805737644686866889196225919797181042630157061603316985989218961400164899104460873992907986261650721369594990023984372019130907220178224857757694622717788731246586828969994946040779e188"), e_float("-1.9739048395578353402100782595996478113247205162356438760147119008661449141140797049666552043877267705558830881164115282483561866212390830213999343535917501064789666624340046189705165863707429558464153801104674282266406384030952572269766390920097081418478710597459257508952059045936896540472106441743171340785343315392046654082590086346598942941792657488750673279404816677028130776613408994282632210257e188")),
           ef_complex(e_float("2.6283275736236836552202785911022667347914902782331895031406846740638067185545251490340481496509554742404623952172510563769835545754791129469642780453844785593323540904194059771774312152468914636290242577413947962220431576666210647602646579977448029668358588775762840209601077088899178729902605142556623269922348049883054198905508887922324734579315742161537777686919009454937811449461647306386687066995e191"), e_float("1.2029598697711900709514817389960730229874753236229832893689975008901682659433527433374624740307588218133797354814328836444006023559248633669269655751884541784523726409289205608084539642490434449567487236593719499807231162269773055492873793980904466562125370410927766075863736730033814456015994300013158475061782679634683277186318288968378887489123569549446885813544183662246821371449889739222718855475e191")),
           ef_complex(e_float("9.64373568940086752407524772976268208055880411208559987131606021350346449991664302276567147732954756366534416843643345522015812643235397278691491404273220287030512790423450074621110555299307469268806850466749408028770713989014898179300995929121639094470331443898286553567898567035162327138796435059229263341178538976250132751286138907849845146579646552352896400043733949097657977095509305265185194629e192"), e_float("2.683062206269996257677164959526732188073067967487254513246004742147230039363491252227867765325978774831769227371458331131195961206523310530650604088636239029675692869482252315087672217824635479454237387568210859049772740408867060909140193869984684386593416623251067816416910130301692199093559559160608038911079822315319068362875052373994775025320718845254039854333851674620300297943044677233466461146e194")),
           ef_complex(e_float("-2.215834613470017244644793108635347703954663392925553501951789046141352133184016686056376116271756247164802087407784548458081026967615404165977573913917956962972239518089136926095428813152197364176739088861521722655796554632214503607218345301093966000504508903235934920494469394239310656946963485265824928501059060342727014086834260438625140178383029041187539406506667659472559370632640898882497516462e197"), e_float("1.2135319276127509032347187853884848989416246152494292632458241514574369927665253813934778973694098020877662972665249738494905943695262332088015408059310723294180907572379661072681760749315565310483933256103744645560140355553985793355594967507611540547097181226468132264955475770486049125619479415678319171201331624723362118730732834377325208281921237117048422354272056032263671525076616012115935420173e197")),
           ef_complex(e_float("-1.9810931251767892169310797735128700956753801660303239449471580206152560161558884286649503493637804611082549791861034276326464978341866406163733153246565001447290306447970124048331527284857970225741079180627093103692641064227047346957558492096368085356262516057825308075920613094729754034195328155802998121047734447539911372329840165358434904404451156255792036931932325353583225773792025874410122347826e200"), e_float("-1.3689505412817640506663832521741773221102203461951828590293557599517042119302096724582096527188609594879558768907354654041503353622760754629797222897809397757434884893546867899071479456251591167480051165346645131553273624069868592433281976446968191542015333572027434435580053585615313433995885735486005268866648102480817527641868639156494008888049669935552717217610622435244421995681596697668398976888e200")),
           ef_complex(e_float("3.235005397712936757287408238859382694917507783083592124464506883997101916878899210137141715839179037825646471607198071380935042743351747376704276004278102030066076180705327498633589762102282848190682693767704152726728595077276392049711065812724653829436496536877693484740560369612370474588478899589780194593575685792517288378343361463450472420633979782644901788905318076692300431230227565420096033829e202"), e_float("-2.3019765599589893883886783892348081016167030965866532965265698640252007438410716211441893652329135974702607171500658944308315998502435445866596614112693528143644466824868799914780766809803634305209290445307566631245956670604865616382268313084532846102019213323871400292157991874528857150854286416722226332411537037549420930766409432263382801503072306020093491675782743863783037200274038398269499558615e203")),
           ef_complex(e_float("2.1530777765555450209404610995592025818929115699925756451770083582807393742867810907333888854759113686117068849403449951820517306431640703988131137053802350085460194351353388910785272444170601797030398874461158499883753335872755985752662855372516802354054811151221068642396733470374007928807658382273040128297477315285184334797797376765547863354532047728772782430287343779507026069327269403911140706734e206"), e_float("-7.264256609229147828838822064707663086117159056252252258954447796519190025167679377260483674239788094380378612471283883021435641776927541372383595798304563475653694914605971976583824188257620549077985921186796533135992571078053315469701097956943576734356634176195971890295794909085476874818348284372495029494390797649921836331867027709444902277667999538599791366574203385850702325277417976495416713764e205")),
           ef_complex(e_float("1.5980944761549555262772697577772869664364881542728180397698816434451688082649598261511044698299799653620127682898988922846579108198606867687767385106563325934089693280250456505167292382566216618703105004551848127930607285632348832608929249059011168202341119862273929360896293954001114792394985785380736967901646286939595717766202952629790163998099846819596920555939538263874271559049086910781017504443e209"), e_float("1.5822579185704755907497343594647690957969790429119562955964008403191809824117126486802618600628214790311652615440074458491547317586616624966120229750449501730041505595210329415856217519145739768009098245416872908191677890270382714237712673252818303492174632019654048977064470078759844647627725534362383438655834561495197552527768459140383965618240725971870142041102803499652438587272897743660208560076e209")),
           ef_complex(e_float("-6.990362499089358674516068784558786182358995306884812445068699351588387498134430318818597044607458672844570885791893862484785487957596925378425621723460612726998855798753422461781680781469928122150282435153707651959168509355653638630112229281168606888737310871302173344263995718907604289002048615956915874574040387759787496525847057564216243442377077255864672428910398611864855951875616664860389989678e211"), e_float("2.1418604577408467890523529089672008413158273016012772995472285575632495479824456643048096513085121140781488157300205794630532643159921785837238122268679015946111506346897532603010070777884337846856982359786527815463299716159974057494302632813685886980651564787938894415694294345424884318817759260993488143013620824638796660621704768778004605475973371014983081966173975609404699244991282075932563919706e212")),
           ef_complex(e_float("-2.2591784837494370576546148521961448668796029585111776463949134312320345114928082945731558536158305961909608704618718507769761603752307874343905690772262861399785135439800933838455621817251676335914309021176120171343267653248908596396662762644167449142322446370197481916947045434773656923765955376595145541089715776629326664195716410426540865760231357698275744713946311202727567281705076285973628972551e215"), e_float("3.401692481003713868608855552120037137243005158420029810257711075912476698888120849506761639719552122801036676715580878016478630397850997936959725533517992982054689803120202591340689647064291922288962395339840506211634561709300781756019654370870602918322469751306368011815088153250290366005474627322068553224710782670460120565042892971725389653335870082566591853625641850782397269027360950005584018639e214")),
           ef_complex(e_float("-1.3514076854446579925882329968395942535823784843656165766207880958466273497369004163462505056980057277815991840098989741283556960263374641825587303354108235516625022184061504661284020374165472805856892325185414103958953345617735583008360483427668986366196505272532184374235826240498474588509043244759296903345079850812842060741819250164567624690195496493083569050616925086610454613786714461870327462266e218"), e_float("-1.9158126009624544351979038570517455056823783638902468769186923901940353408580189166084808178584955372186799065073543556808627948703144425412980761463148345798036718396604433318383400846908848086898197954636724498720057798220516833765162473682053413835185179380398163269778008620351529621161366691136739063908064229277991992759604606941282790551205470271362242523611014851916166628321677050674543734656e218")),
           ef_complex(e_float("1.1491383287150840840194429084145797275186694844353989348901181740517243162674583848326469099153936911963200803000811501977892610687551509303157587386408706271026112511391274832158009163860402595746785779436538356885334203075433993113338754582111428860565696517775645667253433218026140194590331805727087836192477954291294593526483214152663289165146678380484798669146409439141181690463482935609633993355e221"), e_float("-2.1461525065058259489535863352992414405675271975107628994659707496730677297118077997291619970131397098725795495568011026440174673398720773826462918773900998262335255197453232258990143162972433277665798122537261347050941315076869418389620443891571814888897829270063561034161026020819363802589640821899409983016673568799130240378498360797128944611595483670950208352485653386465285737610469160861147245853e221")),
           ef_complex(e_float("2.5565460050648296986108164286922077358293101795794033490427983411407907038800557034900287781101379716076861070366595262908234239175198240279003475070599654914972576256804335071841320518717328620359792782076574196736837358893424573711841906550744556014573569546396532279578550510961406733955351249681720270980994584527919306239088382239527895953974984601062954238150241588713495295435375365979272935564e224"), e_float("6.84389520883862466683127838474448684487714017616776314338648177725552301044605634724408419672272319914670049962172992674102727882844262198737345868083807025021465959459647417720273813517741270260940753746912151390731186878220823812493241150962590538651792579157031661489908913793348621594430098266372559688668275317024682310956563775026890764611727310941703314448315140338612442290504284475293567105e222")),
           ef_complex(e_float("1.1528143443932735639599211020496394631878793745385184137824166871346161152463524766621223683239855525992357030253707570752260988545194561786401942575104717154439105568884950866550063601329344478626264133522562531754647629523482867121224463660718517243832487480151154139757887798816098971406555024138752361450417490110356157847852178741489087884968365824216954355892377765125055080375702044972811125293e227"), e_float("2.4612175880571096575884998967248610637943518438276415119586131753614776427178252573341720078022389349313828894025121018003204387428658491727972932858386895743201833088223549592871717667767906178225085031926196607153775207603042665905732116754286033158072700151007767805212848638426070511848303059673052315914797432651372703905467514427452589770843506020052699928057354122674463106811130603331533799473e227")),
           ef_complex(e_float("-1.8094505352050507275995060178192375696175079264881138133060246744271904285361992687309518553275957577915197194284079867645377775873459239232714098141297323249433382846601038754991929291282380327662391672242873504894283068659127012519294447215190476879007800191321766444006743030157915795310274763059336065708332093827492058627773918311195868998794292070394672246077086496962987433030027935082831114142e230"), e_float("2.2934646672828078243307972532258414443310320646381325221677901349026706422643858888416349147035436488780860136609629023330382708977819161941065078078384923048771742121249504005993708876413599424351448503042771578600611624685907159042278506811414230527261001457451848994329037707438383247482731211369135437378899242992761106532702753939262141092123283068023348923153715129442634353995606674039604095861e230")),
           ef_complex(e_float("-3.1102471684511147290796264298175404194614782959594823098447601412676186206992388785216188151688712732868330283905204200805276168434330429990134441342336386261984321619602696044837977043987786093236726644417814360244181258895413884666296046066575721294537118164880481261443098214542912712010846394130368556206957645655482180057034290499294004475189595229121218531874142533168084404545907555225010718017e233"), e_float("-6.409004119851634252934005985230677094376474788552988496053147370201184778487752532184507363541121336843943318648118684641985220155863282629039770951934990684771196089819017997866696091522929677776181611073225896079004730371580621607406352169619108907861462369427914491887129234587483999367356656334385938977491221179353990225711699825022856449971033652813079889943296766322525053182174940582205609764e232")),
           ef_complex(e_float("-9.024875352569782449141891881685407051291646032603386642552120524529915869662498420383129917937400844152220575508331210403020905367307960883823683630336438999875373474233937551340951125930661279787441825596783397864140649010137303461502420691941042910694191939451787591489954850810753480378050269222864332267795054416693171137563807474969490405994265091893607269062884302410636445795583436480478261842e235"), e_float("-3.3719592883403024475151798671636989082743545368370215975780152435482932456687673220960467915081106684624858934036857341059270947101749052550404647517254350247612816693086229202051493495880871255946809315690250280374526657272830872671147451379048064065825303252467361392083029183390077309080174047925814620703829203115044024469609048591081897392061076772877841188033149379687003687417095393321085525162e236")),
           ef_complex(e_float("2.9005962324502704229619467645278139117096569960590742979566233905444919917996745064467648120289891536428630174738779329763271100764359286409196437698895570229096426780888663923919058302396504765694175833261558364050607874857843896817816503126015014216296375487534007244921150042322590656786693290247984869663434554334650460001772307988219939918869278028402961034889386768087509344122011554415301879441e239"), e_float("-2.5761366076066850823545121425466066723252857012159930285630017071326097185499133701444814313082574497738936904112381454505056120699595457998407914561578776545723340345387838727795140808518793000931032926016766501385369040227186880900429911657487677194907783119881539883148251066006694466355659038143941957489503956336907271503955615581950780138466730367552710485479699073717894652267913219500370248162e239")),
           ef_complex(e_float("4.0479658314801002728236370228287183410450094471839711380135835065905791100088663125051321837893849234950659307703354177901050652501359986148356895216773764037437213988824154703827536394769089393468867023841249418698304698622713084360761974908794249054026330198544619092608380559035048400108955576591941318938595560751263093589130447082519662591844664842253626612024392472373158047470724667771656843102e242"), e_float("1.6162749226569299765279584511483908033170533069537128839783810490946321097508971489298823275926880877445683085822270247330455994208708275705300858121300809616041598652022244917120902416242792287582505428586078429279866419353763219537202408430695044875401782396725583768011612528113582360994095663184121825627079577051178911424866032287802932965906899372856492687679453171911703307189233554276219799545e242")),
           ef_complex(e_float("4.191697872962438549212503879643418954729132217431922504157841304744932361293559009820758750813777651706042304341152113686917329764731119089341158855731322416806642565406240892939149352015754060691896981484075017501806911039025986614407565573807230302804684137296069028601707902086014680303753275909520680473183883249052880646647694849378956438955857143548074469123951133330690994362362710773759148687e244"), e_float("4.9324693822324935679837687481947336045178782979427390540030163101002850655722612605051939690282812962065172409616816438366658253418603514821783407366094673917892564831212422427083602666016172986015090925727896796765225432503197527315307641445377916163017611610669592518261986178200235942330200369697870974411707945179359804267410126612559789949565953916398050001962792539806713986962439881753770958463e245")),
           ef_complex(e_float("-4.8460141993692969132128880194113934063461937138226971044268377414461963753759072622732426839300565011612413197403147412233605232186776640527115356982921485437400580297950933899016318510740986596657400893173809908808230246824619712811992670390702739097475051882937359794184838326677561715048464503548893939440902709166114083849283691647583518647303962915335311068755864665568617791866812797265771026468e248"), e_float("2.967258111054196090136463244640011295693616872016043184177364789819880134860042028328121286276527534409256826680397084401982504190124273255561896976139456674170111880277034679994186534009182181819029779632644321687469032791291218410809828222060694947880372168695537765652494902140916571506922812181009998979597752682843800841304599424917421695446866530554583957028749844130406690533321785952088377277e248")),
           ef_complex(e_float("-5.5962210329201745245513940061506410603571586163765544013457414734990732776404065650340905005604407865982109937797819851618282980067551042637484617440619280390271783565669352204469988269011921378147406153527639893288937182632119783590353667221351244486639275960865423723230067309035682313883079172875532646075125222855150762691466705962785602522638048596970864537043327796475733232279641841792056028504e251"), e_float("-3.4832835500120492843783660234842254474399932406356301469722458310922763356778254435437584669012342457819394592125378742362132784117828808423307570267741767667981867525626189298341685922095156697229886752000209883121700105075381914509589826252780918276238026211140717771847057882857819129010642573039138364082790909925315611729888261179446376158223268201805549375346595434389626121471816094288089390256e251")),
           ef_complex(e_float("7.110288657218805878443201709442129609217272565444763496286735225711389126661742986023000377481133353141424909364811279724912776240355859209139381101967196986002978126450990369255686282578837381552896359264617105421782189593563471784084373996149823527679278337791019783683432590273775981508878094989464072357056869063199112707597986905684380578166295444469617902513295095722555807527144067252112902741e253"), e_float("-7.6941429939323305707383549433658796077663712898272149050575395384966566391058312933773880177635009386047889949043466476640895345331251291884245075655584928870854057271818831055242077284808860889538157034318711175434232092908318781870501428288438825844737285985120376189401294629038838503223624698538224961472154126567225694296828959213830347875512383850386508432698644218292143909491595491907943381626e254")),
           ef_complex(e_float("8.5242338493600585236403880102479747302978278921742700702734801185630913643513818189305798494520368561872984111451396331980672660460574504399371613488098898682434046487562179660248982496843108858796563614432839792055410896382210775823548440152856671275017046948530050798270541734608758139937941193345984904585058268786351668590514103821895371424551329799182733080183855137086680472003734733632922537196e257"), e_float("-3.3301223809914233313889524112308077975176529304763461565690766580539724146704443130979487252804740975314065425259833125285132075933664115378576583858140175157130884521858839321762268919882875068389999649026396133629715650744542246370600475157697935395761652352989437164098581896690507126558146231020063706138125520081164447125246389709790919983197337252886176882803288046095843519414852216136894238073e257")),
           ef_complex(e_float("8.1321306719288848029636802214256239551503021478233164789541924568490688614841211849566663279764420932894477419540595829400812166125150926768910288759296497243511307596430743797844754791574812994363353407863256151257929002613482198262296159024508307794947461038041037486809899820809026100085038727456834388846648470047637320163406295055001841894596396046693291932974403236798778729126566219154381428072e260"), e_float("7.3334012249340202279879851091876509205726497166603453048219819776728474606787453111369152234043395428872257654804848393745142211829655946566174539715558424716805789517380009334140955173391964114886386619820796488815292264746676740720202702575181001048657668155974513717333311012144209984357920111940540661406256306842870381842222711947469329123158666262072270141914589503622841018636777696416140516918e260")),
           ef_complex(e_float("-3.520869867204763633640801638852608339970834748574565317861759903266877562083218185123471318409247987752495460189652702744399558352826704356499621744000286983903509245356598967932724845741799981343810268667491773017162696547832780656359691160956517033126124359794769933962557196142148264433597263019445409459979671228382271024019933457446394078977558614231787818636468907693717943195183356554296667618e263"), e_float("1.27589623798780037402696992034348052190028842468175518597490174848915756519207521095316838512431008441513731200758553168717736319783447739523636161818881016110662765876386949290756390000566376252140470982325099957167651930222483529539397626306074726343530343631605470208700280293655149060761105095297044740662055388527332451485423012528740528433643886431581789298026468084610718461493127728922027275549e264")),
           ef_complex(e_float("-1.5852249827347702015979010167013186303990127099156388439170974211435903388837182677803372778545490326497685503950827757092878178911637985228078759297742253385874149007482784516939610553511675744887447463283743085617261450358732392891505619280338915036412622008879613663935192090603371977878207945326350746835435420285709299479454597824126397258839430094353136481948321562164894570447775668259311440279e267"), e_float("3.1355410499811875666403765363339868094726168929533572480060068247479899253411914605993016849131543231418131118704220227186760363514514185380598730142434731105809690188450232518176047219815810050507077225013798334550934126958231934687558422451839927171734106885301882267594792438723253953221055595200029782902425308374163741514710577937796776935321278899818128503125922888257752770497245681785098246e266")),
           ef_complex(e_float("-1.2213181989189741239870845651159814396886060471855219525420906132970065311849535622822209100148185315184681909782974466516987464602774865775669927088049782880168729533610145068319642757212814505816007171948180958759351859431110980983895571869170048506060201042850278739197893684168058024086938368352018557627829963879371301227255654654169379804133036453682240887089183175260920511271280640902695173111e270"), e_float("-1.5743365231169786610063110059648011138448989783303534021746507550884308268622991398995720085534304648060945459383452307272531224887601616666503474819058652083817659125715091061729544539606455324813767116725126445858851635910618903737701619226381509844094383514850647950788517084523932996352793694507417091779620814947746215202378964339860255959526084792538454225772393835299090861603609802498690329837e270")),
           ef_complex(e_float("1.0713998249045733234347416497315983043125644875045972035025835393860208476307008508670057430731520941991457541502214356540749582538812203167309744951229824195905167283917329773201215280734691745342086288623079935285637894159499112289089196612416186212010364473183387103672993064531723822104300741615379108984957095181868696149671350264858186079577270491567653637073155961627961959149197526782602456867e273"), e_float("-2.2378617183465578898415186665452790874475003678170147860582442131866177108763897846234235126627424579944391064594915129712007077302303331564380981831751046705057819032067249680873500962215179520077555319448256810156929364351004900877537754790252801530452273442656519018497220355763945253912601168966463252186530639805727897909381706549242624684132997411577481763613205233482117213881551409598053448916e273")),
           ef_complex(e_float("3.1191893173292949062501274022383902391824833868716955248839289679634835037079948497715257465274174550652984983389263749762040420116498605942922311792316590536051505649397593490090012205251405999986902063912308114176669353178181487718452477988257839693055707991125487425999744525413684610244697512621560472142350523797847550061900165121152251254638693492435385078479103215144569950622353877966791409436e276"), e_float("-5.60483521714320970472962771263420316532348507588661735007524273380998002181182008622426246842655443395323070400601697709238854073431304198146060287918365230098195902542838352041244792503299025737030573658183452687605135356171329657480173934322410434596298617369177547629403907303579600346065890256304233442176303149350574517103840229977812795713335437550210163402697936879032326918646702989571604651e274")),
           ef_complex(e_float("1.8374453867274903834459524224021908922087179508145214893585828960708222843766694980400968097945410514791266571860404871622099423546635687997544346635575494182067736372644938141602776942882792292682099963085368481468348324169502152579232667835565372289888991471994293755108390425646103519321816780736655017470446599965236030318480361386564965721972887348837825706996799449860108521268573272488407635036e279"), e_float("3.5085585242278078663199477423172341334615327572827775128845857949106479523986964432389280267220133515059403698163974949175854226895880178884266726504836871277376888248066218135870717952355526632707775457572485349299110931627738560066760654282592183124680490792870903198243429491226012321456672254223003150956207410176506585841385586848988635667249861115536788145416237392153331513201811818750145543093e279")),
           ef_complex(e_float("-2.9656727514238409779692791426274030116349197595235666528526350318635488098423493397186267781468399884191162945755364593469721561285592670055905396398985387035065213909877759116518880442575504118324435407464607326946194352836968770810641608568298236753932024676075337892236740627754107823609790691426406738411066738166115569245875577617454049835620809880892636836064565339745936965634619467472170476457e282"), e_float("4.1199036269895162434531745894429390968378372224007177539457033676009980167110374753064566993183911889065710442042633542373753965714805219808518125721033780472366353662300815622402105718164674205442909851108477782943810007318672850992419348088019690946762737087932946911289719860103458924772669618028546304479469596068523638158194422419160446142126792737882775181058496735267552710333791000598840391211e282")),
           ef_complex(e_float("-6.4847246715221053489680938992900772490780232629934783009808066645698210411568450980740830813693052439108678526289797551432924378827258582873133812884832369323246785723633262688829376970597891341879536775449036535869389576999720226744857403561940584214845435337040778127482912480828815551092370677110066952377015838412408732092977615773840945463795579918224760455239933812742860269076432311637159108829e285"), e_float("-1.0430722610084633245749985934651349262738139806556308310216393310186020478437050590816877624525768596837282083258293924330068205316404667295764595660738994776803356672291737579917900905970617604208523166563266872937994507860935266011416625820066122437338002414487781210264092105789044344062733740372973819992888781302022326857442719140001156693661824261239408093214597452247332789063687805733187253166e285")),
           ef_complex(e_float("-2.5754211617448715853851039482572042186407230174089628097674554672329165182388315263067932005476413202447155520483103965167179679205892768670675738510406095709319155137498439174976702465784042616154343165782644251697646369325992295515150966180928487755047416364810742325557135301468495697099549401433419956532498742298296965273374811587542078223623702121081298078803581866564822480591986778475986226397e288"), e_float("-8.1824076319209832416033452598724832593842187109756530942066062241485072059447806870491087379475669400031119775053049317697368299663583701305516508617582211910035880829942650268398170184245078886603540811997563956867886602447470600837435415614116325553710862066696914592388168534833618698044286768813710454007570452698636234908282989884808153435475823911085050623359442363698495054658044953999762689186e288")),
           ef_complex(e_float("8.1231294218079253860523186747099861953884749654826036305088153411071038596952375737796565313532902715790480929964806870147299177248717269510598179521039873184529287551363764430782283084753851652837466694861473245557196300820745604350379015205695383962923797618165750562387918276841962505606309141517191782651576081477560897030908693097658444311058857168759118143706326380618876077701412515063926807169e291"), e_float("-7.8663326563968980249886424296059322957984284901309332298374129435849081452207812405308310094868170289617771811190458409000549618007777114511930605279028553620891869304307591319528167152147931046058394988158833173189830795281332812768952446440785881767482041554075240267654796987197463461498118745706097972305585533856559394153701670620765942428717641288113994031287538149625340373773804024519483340398e291")),
           ef_complex(e_float("1.4196879676039877880670944502198340965099166199850208174876380680850094944278672237838612621146023343843655557078549437008944971852917710464197089718818809222973742576525241412795338699392343325595839123180018255434668180025645250032797299152291804982112033669449899302618568020362638017558408416896269870685342542516132123453973722102162354767096875940500667314338873179477996119503648073136653141751e295"), e_float("4.975141618987512480681572558098304338644275877152416261159801879722539713390557204244322190968701722458872752125286740514619836950792067444486058017847029450985258563888913293690470959888638047910141260064640006139451117697764387939599691127527562849233441231384910618757015871658995967162197929925868110904822520774357290504975079355355589147268076823708197755173610287403812485425436954616702458291e294")),
           ef_complex(e_float("2.564275632885904397892209438513464904006424401890041830911530026367028157188855773715286774188977684005379384230849961730454580165512538730128380397023628042852314619823973215500062487434215098340040118592722429581939894616792983253001146951134232626658975279761100726782014043628473122421309893830974322310897532975383259949333908889615642693562635891780429575378084501187116877879318517693996523011e297"), e_float("2.0032725810651337769110279053737299443150901533722000524919250906487303134469878477812114671339047513619219362489373958175272161458015061320078514885496024853660897962315955926260703531599226862607920132554140884527297796891232561042172871648607872814009043006621919592232330942904582538928664465649846571736681531790698288369465067784834029481121812671813214608142746571904434161521596926480612928938e298")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_03025_z_poly_hermite_h(const bool b_write_output)
    {
      return TestCase_case_03025_z_poly_hermite_h().execute(b_write_output);
    }
  }
}
