
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02901_z_zeta_small_x : public TestCaseImag
    {
    public:
      TestCase_case_02901_z_zeta_small_x() { }
      virtual ~TestCase_case_02901_z_zeta_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02901_z_zeta_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = (ef::pi() * (k + 1)) / 100;
          const e_float y = (ef::euler_gamma() * (k + 1)) / 100;
          data[static_cast<std::size_t>(k)] = efz::riemann_zeta(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("-0.52985466577457302195328648942739781277718734803254006077450189335164662346912812308038561685205210558715964377417145004413260038356938326391090347526735985174015075534312364961306505151839858513052407368006197454458064230264259888014543860113442222743882031089638734392889829371442071447745734204037326344944802970583868022920929579701568814904716234476780614297874579577153021948064975196535677931306"), e_float("-0.00568571558999989315472868447592594696035334039481811337669934739438502576792122514092504798803933965773077111464624107320423413747832930103058079039160379863604690714762356504002447481456585571971657089390107010263122196696529059601501679772214129285160275897350982422082224999485478801178858525481016690462885917093208119927645934170289301592886914872536822369938842238100295133664500823833766037619")),
           ef_complex(e_float("-0.5618015412073744555247717688267607658871280658874210302112873099115049335976385298665325220080927422334276037926434960543698162860641335876770386940422247347032124166594879745954086339709275684097808333889739877124734229583467324846112216113882142152790048935243623194810615631905991372368463860796503145049237676436364014644786208368784066945352387167768673569726663647739157801555842521481517964072"), e_float("-0.01221108924405952678819907020946460447474429467543888864631543387862212665719080404203843739683661294292643552019862500310351446502838837482363492908170497152311367889776240529316453627518420567753865559731606749314414257024021545238685253491401837820293294245727342954950963112200801344840616617937829433237186779173118888162626869139024868619134555964822228650718165710017053559633397055998066725007")),
           ef_complex(e_float("-0.5960393062287881786543717978283890773148177764034421093628072258652404377638250579268109380138629065302492317348966132154158045809714413775124368714909924135670364174455825756886606893506270797548338660790653161095501329681564922743640560192398464142383140263028191863259494248921172357208653977508410095131886254717866596265370653477959011745011181690359867469335697658081748187300388570376279658098"), e_float("-0.01970699706659198152499316607501653831698077553354584875387744962268401304624676040159186163535489127574095232927926289405988993818452599117650633011487453503942426278303607769322078103603208890017028382304234725274553815231211420710560835984731326918821097824502890289702418218408271230586121950032334642083414100666843487788148871324542714396678934586550964652778399843632296523776851632450669981647")),
           ef_complex(e_float("-0.63279106940443320227895586548326880854981837873079139021396682845910741246054283754998737941407986557925361197082523284502869981898897486054126543216611872924666040031087030197735024619249154641549406388350087813259580299595245802816687610059304678118968025691228937907668946210789720991227301034292984041384552139007235377412423941542253298994536382936964017443713410177409089765760052417117683682952"), e_float("-0.02832900060418441013334546073144250678148050752741286761674594197470105162997501250731567142529588587678399252608337007215504520996546853722340183853470549864285410219846380661444291360328133580424623284079598891436016812669073453632244689820368366771728972662550844472587649681780308810724346019314339226683053795992011185624521648912780945816074161482633615807616054088300943748888569933793217159001")),
           ef_complex(e_float("-0.6723078851204109241114380214092921954868831737996531697440570817040000879666119976588891652717402915486905908029089649760857309811814194560601905888225277076877095422275939722570485179305109996619723350972475556336608689478553456737848967867918489686356374476238404972925172245167183767333934210012293360465666709087964586729360996456741843176074129359081138501501560146274473385024982659199663414991"), e_float("-0.0382629043130358787978044091515728451312152407289737445918734723098682544786814387144597849420409732563698556681970508546839372666323547668737222488757821566099271386299467951181417802376442697731106377732695494512069779512652094181580277550199953289227226436067155694060646953404944755025291158494467893154154936019075122323239088062823050742517789286807769564191746540627823495983345279203372496758")),
           ef_complex(e_float("-0.71487278811832850934241443869219240643914441208494905344951869783935836488436364951649789925404344945456702145223872186525859273457500936287560603243592198758705312233562531698764571522490642777840268613634117192720191042016602347384503066495851407358796402520183575759904795684263099295031381503842512684570785570220060712084350753945451121177074201690230064295136401002366143394926882816296538586561"), e_float("-0.04973177609247732319744515977521961764691052202725548293316693055626455380573574340928594476775424132963458430815218650568154436010951146022563128570987034958457623480493523312236224082556940649815583894362294815452257158886683999053115468111093423515069580648604165117751490789234617118705183293460651126351846662040001208649112600590133528406510736780780260774354116577357276086628213958419298445673")),
           ef_complex(e_float("-0.76080539256622478921264114003320738912525993169544443231919683506789125674386219754061010805985286321788853895935057986345933802279519518545344501929935651905744202541924932154551206168997974584722010437672736324825369419779031409686713751903151878830050282842274857913538697718428104225824417568333045000598243147788263380135815646448531158587694490842085963812096977501422833692103351166702912718923"), e_float("-0.06300487257156569715149370070714528680837699399556265945269569681524770549617597750441813660078626012056533131982687863280104247938912112662681129258398610781898908020388574651311681815045647903550809858896571815042708120257983642884807862191335606035483684208693049283123994617834061854533680103057360922455075333113239460261292556653587608968103827949288545087969104075828459964000542829451364118693")),
           ef_complex(e_float("-0.81046708220277335624761356174402552025759505010937309983351667855832535287422518130295019393371896217569772515866659487502589856681721063537001065495962803209801093794018656053796934437232147013534340360356620585979405747816942446032917750837900128012436687366256528417241908588919570346630287601023900931791341014419822528174268023114782705926152446283936069907149646296238793508112248682843240970539"), e_float("-0.07840906074570631985934903843430698514072465833998137697571029083920982475320600747024592646351394263790012290050846599583844240210401588741700908461900765126764534784640408623733401481288516214742720943468508980905913435177228901808865623002459197555871031631802967071798500583124988036756802900190597284905594860344812880333420464489066258181451591872179458986543791174743595750712002778945942424499")),
           ef_complex(e_float("-0.86426677439508112320279428555218123064146435916241758868772407533358714967301628464988817542973968437735488037684284353441040332445684729492284282176688716693465469949704345819714123572227436896043510524437481154710858318072258142988072040490437935228756066358036047176023700225678326136199467477884464067983917059503444318542770594531917186059107683275242633384926624607172553441746466682303545081885"), e_float("-0.09634353339999869456002607301166836069006710834502482124260726292886980786431273539415647714714586002482046167349541342396160507615197307706705492672538255099370840669828080103915244864109985528064869660802494249842864402664478726270484186516609100709152634105293794414097323165520581576449146689730746937602107864612951819190022464666691531929729101202243578700295523660055211479472334572967671053842")),
           ef_complex(e_float("-0.92266715706873941534683459645102316167351136292283042035727549693177916702796539271251679082663213817601324088916378028946001611104650081093963363603459110693901240806288097374823587730760369781745857179762653643322467908531523387402585360385314103564331191659340339814207542752152410410091872616305463298150962834430798398400067604804168698221191222892465852021758293061902829155418165115550602080011"), e_float("-0.11729889976295855996451521574493001424043062844332196176368363067158916658550642018348042509822865489834827610579023860363023108768523356452572419829555722488661514566465582070206035665122777358901826090313657316490379525406513434326201097429618889302397620488576927026163956872070136333025683580327412801510301455564599467716354203802533083048025711750600853652468872398910465431264674487646742865429")),
           ef_complex(e_float("-0.98619114419534383088857414992933757666206211815959945062336381765008964481562658785961749027254030839541812880145789395183056722195436341671094546330106300134157396248701378855957522291938261937271025942751567262703823506846187102991465202258514338096340005445800917574846618513738725102232668667885572574352022368064223963875013499107716499999100606717807130780087419203549476242222691376930146539406"), e_float("-0.14188212615482395255949714690784035206785583031349334696749031331065738435618330466578637306035663637975389948690211940144740527533086216147037481567123983892963239991458198440848919383227989936242311458297903729163456897087524577317126205147742251392773308642027747411649220273745944135652627998745279019992832505267179350605953627286226155001322744990669583363109975702357938410738686250337234906528")),
           ef_complex(e_float("-1.05542802294130742493296680793562169398798680838972656945935086776282693665174875436919053084789665558637747965272011518999636670969989969149779042220022644722930181502759450140855101060899183650331531893240360655654299395492074876284515451059944503661579482873811022297413101638732964687462678300894891433567104089780902293556100396662850362690418678587470518931376964607493140772259699304623735385603"), e_float("-0.17084934717263637163006909245846359286412339223038219793279645324918029569794472322404135751311436873990266677868282788077722404819196435834917529127000711171929585401911600390001285707102958509443871593634056769366636794517725448506672558957725473911126323564860496197626669305513804850166275116879729179085752207314613978319989447499664640665412890834973117670928000256669718459907522071862150819455")),
           ef_complex(e_float("-1.13103828804531043579675822913371879775919339269853687757918397122728609115799372772166017600694993249705918869898378458298062291898959110975917262947061089568035324723537660996750899165822996477590918527810504629333984563732742394411242188947174572358693327189789452698358401147293764724730513146346374617872234673194122973246068188277928278599018805696481392646332242205409816167540473811599543208168"), e_float("-0.20514932464624226757544246094898975873355203861699893558407869036429617638782700016518434555404879671436311500240929323205043487224563013136016355718178578438166655910532275664086990158818793141537181201179417370502638693323727809503848398507194931203769684021876418894675883098690102585658126330679194530029119072302316994023408779836187021407794985459114456602611372620325733450354886514278906948207")),
           ef_complex(e_float("-1.21375532887907138608985444519218270076007499939136489544461017241918348912692728241799847299409857942617954763973660658471041991627111007523490560859459897251269524117061312097695080316771026645467766736769931771876311971423962506918371718738200657940361857638391878719758733425413474940701254210898864846051708017926489589823394072579514088326662548954443288668192209147722984743240402705979336612178"), e_float("-0.24598137507587333123287362617903328619620210710396774855689832082288051333262194680053206604749578212224126425874268296477481949955855948781550931771793893231617328349251670911816901162999153186858309447190242990601434853239228096153104639532807852498952713175865444132482242584424398982023662896451387414476853500812551871616002474634219937231992483565605601089606122563914267081801388184570688022106")),
           ef_complex(e_float("-1.30438069642353948676561951197262140545806848013174844540581947239863842932330878764216292840277403484623169888804752420793774080256868429717519622518799603243414845737958623063792852060771440095132455204706291685571233112642012724762914735867984396839960361626608262924577551972732059477360493852693080366573449213865535280281337946828166617475081248031391183733016963109820500273387992684214643681589"), e_float("-0.29487300658273357935556144221593684522513810506644727905989351420762504119100435430867287925176241434864648823816656392191973679727454449258805568402493502343182524347156869647771022894239686912106487116691497657994766686748738089791497805880952893240350160916471011036475729229750939293865309085067171346127198413175352995461899230526463525736767886810894674223618630868128294571581750308536578230563")),
           ef_complex(e_float("-1.4037671873986268373542407568059802673783239405603295207539144572389219207876094725240905196434440775891704634925899592788732470509745849772349287528675315288607899941072146088625636285511039447725357432020058836667952742003912836240446508804212078228337509299474295359578115605788760989745263076574968969058232499628864962537149031810354594085704720477679187700524086254991138970653107186888645408249"), e_float("-0.3537843886486319101916160292837986273472706603633842374576666628179799028363623410206702255988397370747554730915850603265392013195626213890511104051542786122679162930715440237331412170934109241222105873204568056848691146687898757196966640953328523322779435531009073194524543043423638333013740849530913495826863962674724737668458364890743493667073458428143710556510399690550493352746318436537840706163")),
           ef_complex(e_float("-1.51277967063888142987685410551755854827213756196623871468134865251309552874127715216163263498581730120796935254110664048594708652600365837048542981229998374670691548895168846453217239226569786814695337601949706185089892491587744418460515431102671774615480048410111792030718580269511041045430457952958948754678284192125389147573037589346562209181852586736594627417342817119091710081821145334801439284"), e_float("-0.4252491410038464458300395450379666406816554525835844889437079405722323334252082695674409593956220529814020254040428376891237245867369870222479858704327837328594777759714885191959278318603361022518020350904388991461208192326820010236153247826080457686422955062422270960093568360576620335762676406623337087659018292655587472451767789077036030770340549056433260098438293955266881495750293924908915830106")),
           ef_complex(e_float("-1.6322161160162755551051181509671204966520409142909733441559793067246263101390762974002029122844920235303796334612594054461310018342756048924989441215325152100204171136245038063513280406013269061758029287495072469979929496663283908073354193504675386064172728596154659288249985467319419162147566280026472830231433477785970511204462160663944273257249473302351188650342699806618148408158029827067448576811"), e_float("-0.5125635593975506493062086276792782332781980072292792552248656624644982324005821453624404802482228151026655474646498092126066375675896489877494486125799517635499126988248299114808283838047473697997943573821355042814967778100206607517218296448723651391201678710677706734343699730638440547423314302720083177375486869041381741213809977710659508521247838328681405577200770956074305361114167891429060886158")),
           ef_complex(e_float("-1.7626584066816552244702231062436511679859508788138453844629931752692584597586238403052048221666244593796293081619732451760244747796782465349802278079238381388407301496841487925037762974270417868871778740684521312569716895985871999310819086742531161837819609105730003675097673090046443679562446080463699025926118657553800918889583769648234510732377341481545965182928354171478439041351341782531811515499"), e_float("-0.6200384378567088957423421615114507172482115211710642834304969024488914260997896325432982007029571454966091661539707732854156016607512364054081263302564917872078026610396179580891374772028999653099943155199536391817683808342624450438462477831684534323978382307290975402980783712481695469352516812105855602151464955425715227642969362813646282832614515293558933355606865766708203094676781886728262891794")),
           ef_complex(e_float("-1.90420050990158872454924728830734420139814896024389023378748348952159101284109030026327345668995111494464855304953670070752019060745735962570648150676075888390269938492518693890470269889827622896627424311708851123436869404958483544187228852921279129333298954548429013132961780982781085823698288605062365667271110838490800984556665423586445730773898302924668764462789633736201277318521695474465826051"), e_float("-0.7533266075402308135416577792553167326678418368642809085274375951754383337660868134383099479136550675493366783300558693720483593935949766517578498348531536512395991447031652795111349142866636595796957730288751815572513386664676221157447696273562077603642133538058001465598472033229384038796577240748685206901974099568286932169334923281533393732501516868442561082087243783051996081222929820625354848123")),
           ef_complex(e_float("-2.0559648259591015001586547746330328884379025976944001325146412245107925512628499482857983669897183746576129631247006201873879572406482649017706738366207661993959533157692237121965793672974033883089949511765720621646160250664865276156167048756784395141275019290049186197276233441615940115820082544239814140813426972707108138948097958674180568979668731300051693918379325017819976905443082801758019171303"), e_float("-0.919828794764838359701405092758742874680160232308768371147161546046109255992983504253751454526207048213963031807492429476317211427531390716465935099974630431906449891332006684164153773875105833821310197371913396014995310048870486451076919692543361239685469747329534082228606719789411861651794294294283976149196212273126192578885827368265863260728905282236785653777432863230068982080685855174657471705")),
           ef_complex(e_float("-2.2152590698022952734705233684072375115261906222081162493280833751911819115059971284311733917679498511709025142861029833106068888238025931283603813012368474844282336358283159765992811022691475755579925074155865022501248125214939553171654046833211122873443983097450657894130058435812058223385805480664058411243486828587249086113495413243551183883741688816941043786917048204462882601854107387484373959033"), e_float("-1.1291451463825257807720945264082964118322467086925641254043024868252105188502131515006255342294709109708914262099190304253774294202008787930644309406899820192573745214756513777292976261093539187479197247149127447585332226440370659662842617728148784125230861844876093721544238349150731430488237523324457889568641947257408236628679718088876138149114182883164293741005776441445084604692836837517772582164")),
           ef_complex(e_float("-2.3761427170256665942587655398747353200119387296484898220045495330463243004906117644384609097885579721226495330757204386627606574768312089503009434001208468240074882946768422926633342643236479611735017741488594330116773361736472923648275991087172954270699699787865005512264264212489821985310136865110515660198677842434620538017920379709585890699304198000696180668709525489695071318579709565094784839216"), e_float("-1.3934457442784112287824928573612096535131213064384046207784634955068837118284036924420790204234959805935463444667155260118291233173910232657057243913192950590288345842418225071935255636987121062670694367556407347066244880682196839148071868996542214183570642287217438968985466634010800549823431814053586930366127167976706880029801021860167770639233776576080683980302946408937595510623095767079927264787")),
           ef_complex(e_float("-2.5270848127552446475829365625165360610218575296066550160737632733530863861260375768624031286647205711396705298193562662877673354189762184664609842165281799627893670658805751249734518526177580490430563382019637011145503585154711353150516330997711888722539809631031031538634815155359582041662908552893422653233968895993109054398693078645088382822803747629773130656821416128181147026125815563627330299069"), e_float("-1.7274115453898016313357886035346127452804005146883423950587523019114305509454303707136721192870037248231344012428346128204064464637216306899544008761405255271320574394063450135504189495580107423251322559772860918055355359116255861797571526438394706765540852262381480984336263450275829816093637954447841708806783724044841182605218967725989553189684139861449949994395977155945928833949340711951977924589")),
           ef_complex(e_float("-2.6474106986543696434589138382351842190661903603687490795953131411147254440800454232232407272770343853006696237138927785034575768787716173476719137230236766609361784207109577004843743228812142351149684767248780432816890732786890423238233576542036073866483732015101273167564960165257037447982459907926842132083302343871737496880896689671255953068217299905276224283446844142062295555159563359269607614846"), e_float("-2.1469310948605277725568439757902112247079583839771987915964797778342249676134705865614475102943394506764940075212124044658507459973593194364935101696456266313835872050874978719882802739729603505465659173631768386332868017387065128545549160822371805073238444317279046703524680911087193713320316408491495904802799392708447688151900452656345003070068550081517215640090509842223997195549301246766826024665")),
           ef_complex(e_float("-2.7026950915964024368425068485802302407478986433235750786397898645601569555343597945748843848457204949574622097269257649209135952970321226993982355539532311701634511360299003106161824692689233669088818629756901494533097633826440769293568605795007103769139310355396875065438460164075634132305377152003737870060737094360335394201213276433535142410020033157745956050643947929602537203486472808147071630956"), e_float("-2.6649211911369438223707798017206110107998684692147291220699477917340968851711131060003439995795861093144202456052096969251515479389099725348286150795475243575086948297890350956528650825309878874991795427345521594424517800087568743500566891915255785558181505234040024500585097859302187953266763725672500349621426664625379253567845960303981233524072218177856805160965812095671342234367080410687783472298")),
           ef_complex(e_float("-2.6409542227306307769632207677250451621970335448200505837340443217114404061187385271666831326512645834340737711091190024951185505495121775824162912075662330454116524828680942775327423039142077609143658440957798771215665147714363280305177193072018361863464539640623971960551033840200531710621027424157250388299543247823516363871652213806883772298405976906742236259222663607584344032193779404972842607543"), e_float("-3.2817261552332023802215698012794189227477323729631780615310859349256195194850964938547511859170237230699337363512138278263425475072011207984292559978175451863476593707752243826585356247671995325591705439636980909947644496658551158325238240461250296710220746514753977851671398659308403021225399474503653996095336215977263946072391474932086626062872056216850505423074846876106056578030260756927709047521")),
           ef_complex(e_float("-2.3954239012998439742254844918406381774510748574559010240072265687138251661927551615915329071554241128390667390787001759086788302234540464108430072122807503584514254055684732581293755875834049957701471632944863829625266224120923541743154320829528807874095407736774323588174125159175962134084758909736472359878813746464886592307545594139202719897398317630380661817780580677830646512716003129701872450926"), e_float("-3.9682289964453007555911731316242170618009254861179014292993975685408898895926999150278094415470953805403315615693547403292507464240949793469493360569055882561749236137457484924054796603326801622692864401211410092863143540497095378882423385625044844305717318810909382305794385575022435320737472075210092551627497813004637907981539657203150125241098163062113892321616633362019171189554446471259550161308")),
           ef_complex(e_float("-1.9044645770399311489691377970372277806285271965169069685698111388010556886967723712804689891599568008543641066503859887242797885184329931938070102086736353489572732232536607148084780143976350990994368275364532220748500373388915420629101312689639519462063551518377007625308451989337582647006677445256696544343567223610189801636436711891669307332428560473826492202774099475810559145991234599513459493458"), e_float("-4.6464852839541849385014300286184865127471086372175737519996771653604770786278305813438561748037582142961972107304845699339736942291721623984675929784424308289785768114434451326082303383754816493150475842120181406416046822054011592866600516879452883210277785613490101239004884712889660447851372436644598892557994267182411262488521125033660734097931939917977843029654941706129119228293126875105584243325")),
           ef_complex(e_float("-1.154507691220871624992764232445333007566414005824139131976976713479123074683688386688481101773152943290021835649371725793247733972831381026862417005668341393894184724507818313963067332934162464923676015196079905308534100479258895360602141678828846512159359068859285524979923511329436927852447752883892470778979321110817033396555190553284409235012901634814790671625077309184639232992918154668039163359"), e_float("-5.1882436669934811751674203965712026786672495522188972394928615494705882166872216029546444496532882689847465838906032323127593679725245002743618961111276508682265019391471857700256791468461281094712769422529338578249946530261779833875989692786331599838698954082438351970935134938674914797808782429915550535072147594016718942274341590816248301776473835484408918409267627630154510093179568942062167018031")),
           ef_complex(e_float("-0.2228928820937877560866370817731719414038887972977633596952268058139751888893324852933489012689765193399097459551506931052108402908996353918050885166894250887490848122342644533254753305485715961873362119326578303508336953357046469362154036489734737185542736470374101376310622815639209599729016980400977481998032606789151639950956762298603188867041917318307067922702230019292792940831381964449472748508"), e_float("-5.459009190122714763579426352737487136175682053720144620256786375096448585241556725326795152758612640366710705134616256949410147166570015919231860672062410028316664890808769403753070006078566926265423614278488528506336234277703807246988928126186688115250378287594770844257574964197573307412649184876867521679075639218579927929057088552191932350437081958676967764834038381806142013313533764416492171828")),
           ef_complex(e_float("0.7332679488892902462685158698197561245759119465251640470642552114246036045390639711446735933235284164610907046317959741074354871199818835726152828477989238754106390384317689963217996630782407336218206817754018783073104620406923631179941764120849246917570076293012587403826541285282585072042692416700655310338342537795924055748885308128693737071831870282277796683328464752143313199195531283801810763412"), e_float("-5.3960085947544795214916047084014149218031630855195288936489986715578510328462247413304836133517380039588806055547287523612348779308506144346129910613276133934922504234686132925815983966237801934535272069283934077867426807570629714650852609411070967715270107891415155667399551319972871017227702487510782376321052218059839237198557942922977735731364115217874287882119297378962431696676127042751438924386")),
           ef_complex(e_float("1.5559781010085447708606979039419411343333022342452179218160436687059574418980926429640259650906651427442919447293002520442629255249513661551324784698607557861923491982748665736334765716624118268122967413961514482662798804200952166216581919994143190475365233730070976805416925683813009892068511446172135075954371506736747098367789720511401606540279007736442292049145776965254748562566990575525041179242"), e_float("-5.0478974787372947786355446966228523242799292373515555390605017481557275574699293291401127037894136016947501557592167203794688873465000310130550949900304116341982244169747035837150776367646454642413122677718594830886997724735536659122169363097463296106728476827450232013180684198904453581933259106513514113425576618324626747056678237561433860119185982416653330690883968794513343910846889237976011978703")),
           ef_complex(e_float("2.1612056715332827171479148646287182787429700009758504893284748395179923536878178457074382502417457072719129475034719517853075011711178923878690645357326701419410162526497672974225981096098986607709455465047036418708271700985618490758005357601589011414023887866709907995523039319027941447355639067356582056421040105027146087410009857737394822309875328299467757049260053999670157057679551261607317203935"), e_float("-4.533093212141391113795459011487021768629859789702353319238512407398115435590591494196142652653244951652022561550352968684603849556835830979519318056169996768225780024740663585734758845273608943802187795183651640075417793648227014738503657427152329989864167719352136899814062896280572257870882926043137456992248837152923645973998517881433561604942389185179843410517463639139678689362990954322295413047")),
           ef_complex(e_float("2.5472702828889396175480170385948924243636970982562612471456291396424244887485469315407756434172257588607629733443465521461698657944358366024244525267678967674403338399885679879178715828836324747402432984192822184626427688269175657562526456734689620907867887356820552919112578911657468779503939121897178703358128218972646328308490704733707492119931367793623753208653750699752124640228657117939820753336"), e_float("-3.9681666271372616034564513121424780305375219973481495226503316057458182580388440891279010507097846286334204139844274195859260739282446158140463719713131878048639911683996866652920924735642121934999741986526211146667482378526681467638591476952480026271416187494084085839250989365469798627483948355714058716103230747344906374430225736169889194368628515699189363088047991669358272035560279934018866891034")),
           ef_complex(e_float("2.7576929855841410268598721980420102799371676281237983772903533177703196114874603796204021334104935534118817358745539025095736008069678507760424033792449441450611113599796781555841857925375241548316270731268652952110742757098462293011960569698496445343346973839676713133388144404648211678309559250046484443062373969010406657800380195270659654735953287305853811684905008324143817991010662059407281060284"), e_float("-3.429262264656376128418051946515480440639320339486969320026961299945708350725859632494174132163263971504616986192918384631772069523878066297122755440833969830559221144921291252313576053712387342303810390572601216047369731362730522371724512586323125862131311979522828200816273682529413529817018775134100752527975332364203818767302868773967478327940500894027679397367411158904400008322549431403282123308")),
           ef_complex(e_float("2.8450992535350025155216177936610453501985102851732892910414149185560792594498070577835970108928505145417946957708819291589259293607802080710741636113111672359102770843154146968093980685145517292443265911176212409499709207169967154033591766414024932684918971730761232355911900497965963607005769658267335441365710556253760597227956998636273826348927064438752163777715573943800460048961731143318507689771"), e_float("-2.951762548018143179819925223899877934402351966978431190581300767766481849318276267111361835497660782164237344295537868807615160776486041427086853939083625991764360167009787604314309779377021137477640293259725044201789530978438461076298159334805440702068069257479080237700408025081692036533213321808614243849522630016998326054137761913499260227411291716863420504691606407717692805424592167379790866371")),
           ef_complex(e_float("2.8535791828384632631087853982975803333236806073427739893049735078271644539794208976898332238221471412053707391947386413020135638315343906104983491885108882245363878491979462783308938760044790530572845562778664767178759673473489101468230944575086767781715207335487901832025307189062062406694953757250135502221760945944308553755939777458267997476361799727921717073756432121486339498821708248525066368293"), e_float("-2.5447172740675236535952066288657858053819425669232478683645795361423989040165543335461119619534094828494846901185339940749810153967921017581284767419652730448891691324760270438737140814978490201647846847053316641517914106026516399402008993772971216530580967473946612441110626030652517379262431363840956558931269909471081165727715834827066876540050333897001243770962436879920493600518021237177971946078")),
           ef_complex(e_float("2.8147174649120745387825777190155852158448005005776039078482379304475322758172854413113275493324016269016737047480651115233140827401309265982777308427193076890132114243400075256897727563641587163942271707261860881948031773966351436102927682768784229964146948562030395434709267714181446614308520139751463101181542887745821052175012612455587915233223172354717758371080285775929412755014771255575589184227"), e_float("-2.2041473037030553871289707187285412723693482244304198470871191399778675263809881714218653157915004794750382153358450739239360762713849624600444711294929304288403437225378120146304522713226958679766230964626289586077967439209205174379565446028130196929945799253701295658493199765756434807632951535356802514347273119581818410246089548757846010372126221734010931279880139864368135711991091423730098020255")),
           ef_complex(e_float("2.7493675497016971349120784040027580179418918399096171367829188550127315324475907480243361876266796589985726925560498665489926898474693284703637047170222547959613591605962300429187178455492669908989933546344246819527853106164628277257142019929995072331975820582124752204045095608059106861373642861634045739325298819303233005305118341225151831434632237562788803322021795241205344334688750009479830527306"), e_float("-1.9212089881094683613733765256878774670823158816901480738966689306256159563921862426739273406941999479397031435251677327629622863715422934482995910851339427347101147274703392688256771656998447840091822647918828194446609511367786356377578650293974935276099098707936900514422450290924580298364919109787183222264817375257381163808116100749235613058519882191871473783136200673829408394196543080484804127675")),
           ef_complex(e_float("2.6706625577666477096725747546968292104204010398017554807122221382054812626306938335117358901373568429666150442994360570836905185718569596253158982949306480612740288978607892110879863893437799680974931438844257366354986246009699706922284357643774561590226640709792911286846234460094114485617655960303401840077671409127951152099878828837828657500434558622424364356655266605806741253042097012756459453725"), e_float("-1.6862453706644465601051378877243230705154443056851572517260481246652154971923602246262257239595647844694004059784017954938582471179459143230296604632707540816354612212698174978655389718300302855205432547328332388790153242549481181721223943140753566665454478746473564154218199865357645231417045642205670691169175658229097349959175688157658569457330694962724963539413510863439557572208827525600775378961")),
           ef_complex(e_float("2.5866140420295230028608997886235353660191169014667956357146457394932626618591534263354423836894458021212642036618202102091176875611579759369752322850230469855888077838796024962549558353928293529779365317565279572299874452654346109838548458758629619301175580851317996894916651330616612561192841495985643094773037066690833564356512149987801340435205357836657647958072255667817378596218038356044021032089"), e_float("-1.4904607110630421859118445863510484583345076633030222554817338737955118066868293161050968576133985770340794172773490226044547976575756994809407460104483182325182868755423254607054904777391853524049704640670223468333028108506122131353677223788356270329927004019799066685445770940706951102919875875387321480132463275064145936097624559166927858578190690529703771885143477707326215938232485174828036052448")),
           ef_complex(e_float("2.5019732850749118454295720950492340762579289560814424769454576305555006935025409421206171350779537551737097911447593885421500904102306266440280851506092985094677655688960764789356110510861223152765334967115504392270226223237570156613795541214579259117872011383214141840791242060523899327548106449756766910473639057381513769488148016263299036863377082047719919305627301825185430691294962257575500352391"), e_float("-1.3264303016991421820664857524326030190152324229788263858961437827563501274841193308239015213369152956768450559176803145134835003913015937579759321030075945427092587564831332555951160246221406423092787042735894961836580875687841357078391911459856540207129184131469222239732077581119176423807208469074904594610401913695138687790727117269816581314382535327561581445808825975317914606536726642967815564994")),
           ef_complex(e_float("2.419461978597599791483743705381670175642106975719165521208532920426406125450686609592424918847400798097881905498040307425147433130013153659090841311662954301395818020982821243129105343901316786706084264015704120478313841062976029291535589362798660009209766668951014201157423124389039275151606296601080946963411235850571179863388761957966776774823327533438671651484562602758029967472969254687334758038"), e_float("-1.1881085926076085256132814583651154573070441630393339191699149008815078460234999450495481026520790791317147869999494532416928077634827863515915991655885337945826972979388322382562220225906260865367143159070704120546340861559786882369040570815487474668928094537437289665834434079048580456620674656947309150407621528865921758828228757582219074994046861093421166949929038461840084817764684254920973622732")),
           ef_complex(e_float("2.3405555049612474722749238544633774454857349208787446138241576413704325764192993748818285870571587551718363796206251785109977433569516582687948116178247548896443819802385173352504607207233110841428712378472785191047919942818136415099087120726820416911384166233089812169961882417811394837424892333255386568669523274153257737788622396349145683732491225779680477340501022587523868314102217044436006348158"), e_float("-1.0706557434945539607609328344871407532704857899094459007281976614642243640964499430578192861794905006558607852101167416594835727329583792558368874509356634883499495489726485351029895583340217435661639723127262164565035879479511218052869635554645228838529293071974269936652889305435352028111135955316454707380538699381531173829789349883347409100082002799134473628797233123275972519987241998695902216319")),
           ef_complex(e_float("2.2659724037390864468582966546167969386191688654934453317307670775605784615403372260097961406479720324159659262517956130954183467583057445845484128197152401755462764265541790566082148272498280029031437813477092780584083392112622435531924727178956947019342368630815810942735788358633237749871868932227600720364272666793452765540837498977998444288240487495157447949636204442079317399746913269492196838148"), e_float("-0.9702233070258896013999108762003487753319272230379161374619133681089000127790848198159446859844026257885957946634395649040583067450934534700167330173765357809765650837270982851282862375937949607487292344876907846690518173032160386370161229719749839294906855605648752436791604817858927779927786955911302074500796171091929223110755865250556699097665329206962419884836925957239346032905193161299574882823")),
           ef_complex(e_float("2.195977642136781459281882860319293989163141489970110996657602508659031658895554324209894005006441150499997633698401596738401465751298789837729179320498777290505883302223220846213959015960794550444986404488383049115498611578282486805263358614970491035916366655734855488615257860478433862511688395974078393948921525715841473995261038835967461771079872502591345333242436307163794632588233895796173721264"), e_float("-0.8837542569714888806952041484730307757384473476502875946976035822045786010633492931437151518480101106902547655241394875261147554421223212522569003104912718221804913995625785821968462265806412546492296741240333692586710590288447420031292792779410586649287460874695481413785430957908735319957600039401946728399755178613304212780813048560565949047480779095078890860007184062688134570083305735336290744885")),
           ef_complex(e_float("2.1305697730317849729299592055765250366748380511008036341200682636958765397945905230570851557569382528903498322250463688109106912443835329678026989508153378354517179087792024324048596840812958801673454820739124980102408306538472156461157130435278567674181600408781937087265759909408967097020478897971899328058336596430179430364427857980684768236801474187958781568866925532552352396006987185817212744845"), e_float("-0.8088145666905643145189654727061643588210825700367338755735898873673009637987271207216584235967737578083498116669647407026088747220777649214819134717714977405621898666169274209587772901085927002224193827161731300761656614841847547269261455156101244357312447727956264229529016900585729141510611975862898390863561852209224407349485942099404585862633402248291683082123475367460076483858227019759165760173")),
           ef_complex(e_float("2.069596125425676339850576009892113600306058012447107274186573854734157872598896660758457710201664415994885138955254974619115468377814215528403236899499989286103025454084039511187660875145185790102994048761372207168744986085914218780376106948448413482957107600296783968131735363364897515625085760419720311157245941112134088354858457822344720572331881441116279407582232565872173435299047157954553934136"), e_float("-0.7434579247954224603496511332248553835262762590624187613079395614859556875198755610547399689424577512831503471890321794120890437856040233893559135118680561720965039380098585824795402553273355268119462292570903110257317047936697800085203247453676202146758047393368936206051635775054462823413607529818623241777924041904893162316243624186678572005736677660559906082269792821928918647808261103560423293185")),
           ef_complex(e_float("2.0128234332457510707769012326987806463611161964922086405753845797282623696580962957545571955306708096681507809362524892012666563232227312828984562861601225272821112628061785875121456176862936180204209220660704984076502244727535407883390491261306398884755159878271359029834227311612549653203815414026053552508702262120125839307525486773067542194198901391556915694623171949696685298893824514348110782316"), e_float("-0.6861195838760651694101306870787422262899638386429586799403553594615870989260734788457126844817025400083173674463830400808403938137864790753697594762161052626297491795111059817375859709164807959166624554117564995791708117328714609727080501838905851980632999538106760624402866201363264278130435599902895198300267236735076467520548228769091641331895532287303251051995855679317349701773921646931038556287")),
           ef_complex(e_float("1.959980836140084140657851643621378246870188484451437480525011498013722426672907378428499484039129757056581499009543020002352428474289234265083278028549879586352849173332551965742860765936093763328866680461580391677052277494203190590718019320262861806352811604797099688504971708707935431086083439555471147159180854768263191945110022824252296903247368622849907829223787223419485424909198177668453693221"), e_float("-0.6355339915368141540760248422819286384848470006080223817025481323576936911550969751404208908177230898463235377565462824425203354607802777442664771361975990811307742644864912460077275425684459157559705339704737292903870809620233011305654095786637441340269575204101605077974251985344245850907808881243360789782804089401486519923009133719627561837533404276027018283526595041511636768955063137090303481433")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02901_z_zeta_small_x(const bool b_write_output)
    {
      return TestCase_case_02901_z_zeta_small_x().execute(b_write_output);
    }
  }
}
