
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02123_z_tanh : public TestCaseImag
    {
    public:
      TestCase_case_02123_z_tanh() { }
      virtual ~TestCase_case_02123_z_tanh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02123_z_tanh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = (ef::euler_gamma() + k) / static_cast<INT32>(10);
          const e_float y = (ef::catalan() + static_cast<INT32>(2 * k)) / static_cast<INT32>(10);
          data[static_cast<std::size_t>(k)] = efz::tanh(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.058142377244072242428117985812375778101355939679496968378840280171349668377979923625574072781899292802213532776974182940914534403981479875175816895217329551548825839529098659044653110684289076348266503382410484276537479618586416545076669913079942908425880629407192178862864601399724040711505045317768860934691538979286744700739832667970785834741197769939999896240605178129947561244317426208769132895137"), e_float("0.091545659846557717921580418302848367032685442387743414664382583765711774868104995042123158017042986738982215752236762022375120925484478858536881452902890268257289045940494174183342167098757822539272083529378953817239828130634831000797175695097706376623744457814180334026539158436431383208873850613427147677646044080077295308343962842237603423136202112052981531319664608332710663513572492803473225073178")),
           ef_complex(e_float("0.17014423801223794105219470068712357164199185474227129306516123944199594140505338086403088097158182765577966599953375913273270470683800656265203765147832607802769502749823091562659572724552368826929730657944665894388733380919105902070079634814505930635706507438008863303548999831364845628182544420658252170772045772968561005525950082367115148790081718853416690942000282714476384804525302688080977687223"), e_float("0.29216376903400911254933905721001365533525924871517668559226327356185468763393682080908092839566257330399395340803942328487351675497464199009656743905391390010618630457221945621378716582259850907978592428766165299697844339533437447136601602342467926315894976994486893844547104785325416590620949833827129153039470551533715949230639872455088455024205498923387684328924565635933493577076026219304599087329")),
           ef_complex(e_float("0.31864861225875469090645054530886348428709371777320985943229726457563092832910172858780457663340640237190136400618097153370983546959487511306334116616580918364250341039813140953935461945425302617381029554160546204020336990109647324862034809934986735451455440452932594062256610005946430508517884788026192365025027841088490908454063100825540883803818861729119558315088331359357083556075815733937383194815"), e_float("0.4924172435069304713190957747703173871598509350352821192585065122886428145776924353515653957574078208182384528731167833852603894234273866755965348750598170184656246482314285580108953932973530442270841663929385252841659280679321028838884337935720008272069298266028909549331558955021276042819565572319325260330239343752771516550388501116970119095797950199860096763283553726781236555156472753335031194902")),
           ef_complex(e_float("0.53528581397373305608446111520851424673047855821786245213663130899207029103193561847136587147416645649724368557338338129060636270635403000230941036912690716919346006492807903158391395838964745014737246750662097899409231183001752041852436389692065308620123827450356467356089602303660951672905958770183164768077114453382912996911311433260985770108752817541565324678130728175505746982918201537021213083289"), e_float("0.67590497256130587439199597046313502719734160282320896697066008257709862072972997708892249938397165892076636364440032751982964834395362086856455222474958915573784211803028545577140374808599386705295906693547939448562214278815636992562134398114062799459199997162759200298092445351704840149838449071062462116211412820865794360654768592644169558705393399499011572564125238832544377778490513877458700163729")),
           ef_complex(e_float("0.84693962688545644279745801873920129999202515439321905677409372193483592892191352365394520960004425800556105937638420086114521746500713975932265722466588421871730599383817280262201437875893919148858130833325443065783769909248443357009186315873747561798605072151973950416547560324327946641780386203627370975771231845199080839518455806731393029637440788533231520166597223587921697839694343079152163055543"), e_float("0.78940713975650310043694258135485426556463813172324532160403730248256191230969248142985899087379555876632019528958219288171107933012428652013083835761230551706346574994132843098687443305462453299629452941048682822064045964229329023824809185759207868578604795486912176129617692724012549782227804965993158955110336788032885359902499510150852986770070754802579021986855281703905774665687411033379291321759")),
           ef_complex(e_float("1.2216752847326960327756800086779976620675551566842307637989227145661857685280186746216411603937397103185742633699440466484013471744722247259801351336384524690076974011211543717019371211363480558167993732972393625807886526504602239646997809316035985532883262398179517219362365703549814053249493070338919373714917571887397077125102185103628400482251533334299845382865930880378449014578875439325910275255"), e_float("0.7341964232227217355633529666214029865585772241370430188315376173598662142824837792684244765912579183018933623973620798771988117883402589264461341075774886560098047190781093672880935919376898764664677631988230425936280629694271750245793027959713613331666520401714407101922398435592590512861225982255211078086803659901610783315226379725907166774233095558550952625705548558293235215410593191322301936021")),
           ef_complex(e_float("1.5044476350257182698998484132553608906316819738946567556506092863755187280365463971382825135644191549598217255961041729451637906159279960432719184587891120616334402378364927240670092889106067375698656769949968733738790684799792538594626335105753124905012150105131242387659577743048185150633159520907856345383373288837409530759162676208155291476645987109052522917085360355954079664838453602489049947516"), e_float("0.4610121667530139735477661284192303836045834220411199454223471068096622904406361417079045751672116202351636257147387626586200816125897350795763260534083212292669414666999133291284831346921038491793989320034173025494052792093757368348735823469460940679848970623932993771489390947747365461179597974261550720327418752820006483691791999036900218073584195438457802522374766544704886278197776088000730439229")),
           ef_complex(e_float("1.5491552410037133170164693788639083632479538258573742711467801539829116986794807352069613632751000299381200259567488363340897840052026012260364455902112351053340906165038102177574250197320780776551980561953888850908911866776924894304366739377637466174552605976164346884510432308804065616349943161610047568544336068504046158035211640503572519608142845951286462575932678300377110629254332083437294695844"), e_float("0.1128236529415363406887308982725678920019889928454583070303086274455870754911324825310297559743690386517492260878885242592785625548424369662105230206913761829537286571702373031513535459185080846537341643996609372209134036538063484269898338274925680087618018166083327553679667985585398561765257331050900431890070109088955792008776783337415449320438317806152138538397023386194720603949694694820746463189")),
           ef_complex(e_float("1.4166707558356149509669654626374378968291318709857244179997519667417242194936670325316897785844233322404507402255154817465594379515510585962269132178402714975622105947811894434212052415812457878380763392214169397298672061329666533345016015335550078977581512290449259487121636919189061459113213380923956317054041211280178949609813061833496886414605700519167438444800700515792599620456077232403664561666"), e_float("-0.1260205400697666853624530354597477093371240796328101197156145120731131093281700941905287408757824012490530432427099798084383059407698239249246531466494414357482649713797667942847099570911770577991372090460448590460325658995328931339549608208321361284115013989627230316055974266602639982267937665883169473455060774575848042414326803335221452173412323242734819775684239423557490061203065009056714403934")),
           ef_complex(e_float("1.24512429098564898238022649603531211226549618786849953552248493965703561494857357486240194289847743668647266975363753860419717497979288108661530244850702787414460956978041827220655846282087547072445114925459701453892823501364716474298273910113191790763572250519388680520908023059028505227574240863478137056404538370196612679528463035609639618319299830716629488944446333019517990204916421848650356910895"), e_float("-0.22436157410446805416488087300048112316654250600003679880929951439238873812612917237029504086287705113654483587461677622693614289931771067914562236563629017576380283755213458285846553070266930270847092038645713978434609806583041177052023245280773935936434391713908237735403735292946626552430692847981896117302886275409197209813896073381166785692376358493317987308706779430588002987071845126377953638931")),
           ef_complex(e_float("1.10379555819235596771828012456552803251591578005600684892907985596185439488459068676820493682394833555589185806757581530529059854621397117955523636008492702960845015428694080644647318332178478047599545046474087980415893896855476626954976622415999339117538119263662050891921286690715788260540320708505608562382310559257466849488334476332162113584901220607004533862395632293060945354968801069962875757773"), e_float("-0.23316978107830565189312990747426607293255032367942560134007029297059642215025708342089046966409300154790948185133507573103420004862354387734524893539054390243238938700788795255195790183477979232363868246053682471023499563002159346464007171179404212855066349620513196315499265230004468321501723972146093373915634043345616881221842543322060583278251495931470011527437063790823950255955652832104127683087")),
           ef_complex(e_float("1.00604070865672042371736143764921310289161616093830914335783594717287517518048275125919845345577019173508993430483477656431177132438414293761910562241799418394127847086345717907083476137035518222557582096819264260950944587139034080290331956930600874749030982005616075802377434910286558920408402761345652413611973552719587455822352812947641550728073802199359038853492603002055589060183851304071473923068"), e_float("-0.19892078469151835307877893633795955446358298800065666125233273433399326629549515169552935515132700988540173313367249765745937309303547292851392377850824349509051210548027702980439164281730516027039011200508279608004771524474207231163697590034891842524853586581892889309866341296429362198882989517506368508020278338750174316405780438707668203861878679658869581444577129193886553905620536445636949941685")),
           ef_complex(e_float("0.94636043666597229198100828747451792318696724969272693264425194502736395124078632734118291769023110173324956265902569578142384205309130684689007657696833087662890624063252634941155310243974460778465753283152073850704859513468839442823175371393214380931566415205712616158954712782798482384042864036835220122148662873921063049250397826097959634465003133262721774156566391920964859737531567887086168841391"), e_float("-0.14837716362056166590568079325958689086434998472678233119079104819116279274550352271961410649765580736548527395022648342301909693040123750920926881493088976919097035119428063302903904184432334456272500866004927929123299561296923750821471409187859036573662887242871732302974620552339203407293856070115779406866527556073343151844670466913658570049988909936336474440918107484589528297041605449300042635896")),
           ef_complex(e_float("0.91622876281955608472586811155849682747930469946740153323318747636006613133290509952051226295189618718765348357340112172481547939677774921876352308781140082552611074385402642091263945349074787433288895820415794334611068409359317235786248530767016707180271213950130128323542916589608426764381285308683952554003437320938140032985051071198884032162443798739661067511637233928198016855777347648530155199527"), e_float("-0.09540658410972088381815425403714825751081345341544171041537058469803901709294546689802865779583456794781878982341748030549724798664002357128857923326441314709690534092809286962543551756681798300726106166614092699857080775181933849346239832014630869047767175197721294545366716454717049886914067927697288202077258490164289674273286903764680421280375782768128596703895749128709603626003617941768819042964")),
           ef_complex(e_float("0.90804790345410960831786306587520857973287307253100634492357348604799553619986810956825649241547784668663750578455651116435844032346868744977796775380875669627541653208309552905879624589651019495185036936594448189344231454456231991486182486023488016507843917550455803350740209287451515339230799903968894343556751413040999923936219817043696796299809773177923555960807006500856171721648826251327819975618"), e_float("-0.04731181190205179325023340304897523603732789971007259092001760040038702659504813592765672364271105664005641296389409210520471660773568985082668442875438844783965605140338030813692820396034818299445746058104936138139351295635773805326721719291911134785526270139163587582036381554769136337847105811521140315187665622147820678362225986867639430661960271879332356772832521765630071579260839873782437658169")),
           ef_complex(e_float("0.91542250670568665777346104401061077491293128713826321959338817622129520204821167190028953514032538149627837874759442533071101520589365475521926015315936371969004566946868289779493097911384669999117434286374430641201249504829785066452538578782177138587417190247268214039463075413949714794808374364926830215598842412870148332625392608497281226184309310904770999679239137915547827750055443653571287832788"), e_float("-0.0081232411692459207075483091123492640641417463645246964870479799893970530442036472922045998117371735361594976505383829060283009388048554948017411651890206230511126050375289308257142763677717434063306736414724254143652264953856118221627487673768920633342365720897000767520860869255963090187889873705997593337929901951426973197741552609741249758901234639405672099659919488195217930058324083776831080471")),
           ef_complex(e_float("0.93272733938533834153581915246288127002055652991387711886232933356448023925063952700571642477379278875665672674119341483945107023498424047365971427999403680231776325414928313319160482308788062284315505874855474853265335098669774364924075219989368095942531627409580076747797878249559611705314942622808378263294475782079975129700818147219884403274393970497581274732673939192839753302251531134848271496039"), e_float("0.0200482931126770406531768041573127243651540759947470262316154271789421061680756892224766408617444319532942266725878604169561281366177285859632775677600734004585548792031781979147318825741880949054710089032711017660263196220722801555279578211873080259643906792695886041832865911904646800206869494744360499450494935630565419985519983682505613580875871097296877844485476361121319642566284486456717771325")),
           ef_complex(e_float("0.95484135044994593702890072006616431884638373455781383175792304287522188824936591601276707030472000042695566334788980997381943363725035880672964365672789466844107615422380602230185313169271535877600626098668505150705732205711404382817733658873358714106281912432060349775338644453222664893306526923878532683307592531363038681777885918495309429440616069706495727216574238312389543743517007085391475667817"), e_float("0.03661377281074277632455254998939087305502272304688691480105654764053179643954245288380462398455831558454327216386335857398853411886834965380172892742454364032893007596365049682434453646297590877946860164788938901389754005731575901405359686537029011719136220666486154059561975928019482812799289846134332277297674847986786319759086985168277037243142909342109767035116918772259121057464161956048226721246")),
           ef_complex(e_float("0.9772457484019186255345173466736304528006803812625155459417460728370655776238812394386642140660392995275353013120998249715609294700834647470658616192917380423408826373389232981848850757757676986735889763993593205402005427962453324564810966248309101379794945206463881329104636286760059861401205203598298826223989513020075562658666681627426370485009560965899625054880149462504657398344588782255793693174"), e_float("0.04243022083899317131254374315325445417971581748964870075809906376634521504279844868536887021054245118128606016740111368464413234953873360716356634814351798074993569756526975283319475885964686892947982597359530111790818493300097774985226325454377124870240313633388714014262628699667346479032405155356802526259526002759994573396806404309704829308739418834627036917221302877275628641508926762416036049176")),
           ef_complex(e_float("0.99639752516906725170745935816663043639581500414453076776786056857445122987395800550411667214416478297513371471708334677273790702163679210799380963528132605510749940865188947132701576300114646686766917963704878167136191766464308248061545667340493988324423166427840116874788849202735557885355553267436396421959960187602956013351813888164624144179010504779160969680289629858949123435790926897939806840485"), e_float("0.03963609119873208246151920530479598149975754677842090317567830427178956670989968625788806515713631949404834296713119101736124493844427294807834023377982351729049352956732734506980421548100888317593792741044444332349153478226937008466183534754858608889935381383168066713060382471337381813026373572816680172053300027787966742988373454978307083524813231630549636196168449822103471895778631980198511222545")),
           ef_complex(e_float("1.01012309539962068212229096845344983411788735178574314522980059628400504732715689421431821747624587519355698506802707745362615135655939449133814715619737245253076710928623595636743887324494694083118692389638621499259033960198612196022031965154120071072593033798640502960037155211035457913791484254463380098361912194206064135829399210266873829303504240367586177126000737742771707525689510873040641685545"), e_float("0.03120566505854685570754106019520578666715090618271626315670504723700421769201277273422454643090036529175527936916182246561944931881223536254943052873716323544858310991206662171369961562150533721216328857320141699446131358101730041891314280907500616680463139138145675614698579231478319218886024028288127180470062763516382411013303635491797762114571253713654657473789307071441274108820159540319568827184")),
           ef_complex(e_float("1.01775989955995787147828810061789164516637679775109793711258915709736140462902119420945702019332223550464148131914066976619935473918582354214946302737761415821215855374597158495339106874168799555049793715713877386114177375158024267079658427513739874874684326568342677593819925962744820099613010148675692107549971893283979912054530600943849062078902774957398663131403234710098673793746516278688572461741"), e_float("0.02028354547580809947022065033905512022730323837722843066839708867789397383890611060919671414110768586821481419393343540567164940783524190248564088492257370939124309061437380838588460357835312585006179899137214647957788582682385928733017606379900038920461169934168864643603987373126886176680955424961129032230152710632568321917470871697847708539564275831341590960996777938113690868616773182534095842164")),
           ef_complex(e_float("1.01993144836141580791131564392114944850019958483601674162856503678755851915783878908796872426885778060558081635034310003434951053813089496562424456733220999460984206789033029259654691868611465115021830256082964611751456876068295742800740848014654389605756732519710436003685228070247122644778109714829515860423810399121828119266454923388492697093054295316135625238134111573796897998480129122136484429156"), e_float("0.0095373519243060499806569803845820618731856273990032737952885383066178427558712680738109133024504140785683044782664539904972183479077172020934852400914951056131885918574320623753336259381114454718186831145683911800058665894710771953725806857935206198987067028603768917113067692340454932994350874986956804472236531264080589204929035423623728511664196295235386979991175328630156539949101373308434489094")),
           ef_complex(e_float("1.01805760785483946453624723625114060246893142108097966740669884737802867130945496648395113113245835617643107610071751592250918415918891549566971707444185922379740376941257052965752193344762027802640615036761047702701331013535294113087383270286253667325695082266278125851854410224096680530359931987166301376992554351484512270729360193367789623903893736081429592000746811412221407603307572870575691289022"), e_float("0.00075815172823458468838859091652096405686826970617908528752091895806711346532993228831597577349093872211578157029419308736638894156642074545344433288512931506797995392179511873757853403039776417492806762432477520118317591419260445251782734427569836225730847686697749627526512238242729405955608061442113079882142598579468852429117496996859463672410395546115186863169641247907601223565150358582803569892")),
           ef_complex(e_float("1.01381447888171935635253193071518861082075277468638847618901541904230041104152670279550277073267924938329898930044738793629694972423942837495101402014870908255003124501167849720934936621066754218898051335828451848435781820086027449190461200583123049387613405683785923745275701959702128282388927662990816623617506192440344518575636940558804472079691928255417541815114145801568945286038986294301737607697"), e_float("-0.00521566733341257545441137406865667947989370152835146566223544918398993283875646525842548064665940665196384735701043233124822815364588213085382601617776386032458450361258540746092516205337939422953178287493158059964658067073483287836809512540794421684412951931805798074376753122449804037487886799339831641410014950484699742659849660882929746887947614772976271118229506603227446558855282011022216186931")),
           ef_complex(e_float("1.00871954407874837944993664126695847888790099209337246903922770534580769591271458272176656584086010486106813620231541039429883278962449300471375804071691850170448960266426830623985488638797682597338637625571699935515707130813695989358850618258391114159562754959564112033126905096978246211206935823318219038055064260149140357733458326087433084404777608026785292201259432515071538055437673294269146468255"), e_float("-0.0083301292876266162325659619997320648429317338929010921999563551619488251709424323948378312468924409691921883813868067576706839770347145667062555808459940215466565893279200619755153799597791969019278351681345773169336481723202939141113490890190159464699932133934002553733527845777258710322232367930695888062024819204202758660844690679142940667520339126078079574997846161207371828222379281415709202753")),
           ef_complex(e_float("1.0039068475049571404179177479152656977356846628497007899918217186172820445566419506302901255581205326242767528680027082937495431829356445969793178674937848326733941879655955044420964627644029934603980248390760242704187390199084208176923654921274350490560985165354482175599204183083998652127431635058074349742405331292454258967399470039342524851759615057388559601893077110321017461827743602997910316928"), e_float("-0.00904152957589874903825979544649786727095975588652811272732804217198404758419315898416166506696372339175763667566498526211868077901564894770372022791354817091050285915251432745607147646679148503349669988489277631176890625715233483580928617978916952682051351421634421226935711802772832129827369567172900950707837141607516670159565889596142066634798127246448263259174758943286093209679365127794210287772")),
           ef_complex(e_float("1.00006726280663693165746677103736725934222982137960949564010584794165865159036175840535344512864038891863818034588509384456295076105277456993033652909825562521919616461629388130753588715724647405701053613336112584454866258978786743038374342998136619817077854947878000362892457450636849494980587303438309241468272944361361706484073759494328329960324456565315409017566901918720868354987232526145113589212"), e_float("-0.00804834220006513092293199696166530118395386838836430597448270144743910240015584073976212579948478206949473290242499673647464350062957892192582848986435569401962654056133102527736079479461362037058601703189819315680337560661005175678930304023120649850799155430575207565596981195987360806256644675409117757966105921191272987168772169193327235318435525235941689207387793776376281968344643843818006395928")),
           ef_complex(e_float("0.99749387242165060497625153851001744495065004679742215497135897947877395466594070072936912088911097873909948359835464950217567800693668644052830374376877031105710570704342780764438356533126096923801492287430933148998403458114525231170531350646910628433334951648877541771429594701617429997321836556132672786726985691684474303810047960481892003650971427708841302291745035468372443390137316146244313516057"), e_float("-0.00608530304840063370177943285944947211401220366176403969292790769940295512412714227225465885376589750415669789919380013756510705513640019303308975629407588250781352299429097991836406491851499066396807355681727439206963353838700076326676556694645388837764385856348585959216343812826638691866870084248683294302992479427428246736890387016739221864532362240583580933049505435151708828018548958903691950495")),
           ef_complex(e_float("0.99617683967599536124243361988729491960583831265784795475487596168635945554788254625490459334528653229082046885127350790444718153184526103099228133272693335255893381521995677827003039641321710905267747145677680112070302621259080181382218405946920206010211797997925181029613728459217869338806807129781576788682744194593091747727550322509384391396530459319231336406937229219504071915946685445859057926358"), e_float("-0.0037917851300950244418548684299441149444592983847660448675083732244045541670662978857183779908645639398500840269373570652885140727366054214510453106992470038112836755691057713520796386825494086785094679632689464651219092106418177122779417455029514691946922559422564120676605440701404368481443621021627446086205479184384427663674809305592472687741731730584997301357778101893279072844086039452737422728")),
           ef_complex(e_float("0.995910339688510660219417474366131632605124494394474871524885183712928591203328469849653499603834221048344836244109693737376257665381376085172988844225165156510472162764658321020574879735521569825486007345242115930273884491501643596178680991010871318139042049690822066559351561951966329623075066477140982025122901720850241038012483411365112694628828643637918214783042278017452486997302197869120283823"), e_float("-0.00164463334764873192700735918372336251235181853734586665814256617515191079931936666606548051330201838407300166364254419474120043628361469334872105784004589122350546376566545347658868166608928242125219643927326787837597226095557165020621825091437289427850773287603044631589676467227654753639551676388857060136157042091421138746114057897508357066038649860579026457273878425945682211704379296815798502424")),
           ef_complex(e_float("0.99639070646953275089977970550990839348153475699582584450820993269897012074432419828658380000845700065470803896854264098745917170350733971596520679291839924760199232171272624927324851135813351331545426534956341732644181613829410227807580874786581552736979880715338773835579237552663340387966153510136026435403369434469812467147835055940532588360333179379412684393074749664745436041784913339963457252754"), e_float("0.00006061347019946855891065961529712752881379444825663773645280396863163980830571597625989940298852941538950266969130304170940949038622771708324299322992922300458822525900606518033694512698191576768889870203471238130302594329201113001348143727751902546505501071273827401934101389857384055947243426718383438666795733951633562556869399100196209431052135738448363673982125831597829650007158557017773304008")),
           ef_complex(e_float("0.99729564845324464973697810977901735416143122326850018679321818222925164065605605993788735013186547445554643769132809407458463346450020177968542172754340672455547500202297136667259633435248447229353813083915820031600855382482849688512616106167432246247489233694061375554843251980331128876816113615570970785904215095533611812198401290216475130171103166318328611500202760821395391670486913235463413874282"), e_float("0.00119546149523698579923031081559449134014998982008984959277228557993752867202604943264206764554423144036676894769565575351602004857510416272800442415475606306861087317841647741607624642661354776336048517808302374331064277212509858885972916437747755455548100182619791816727352109024939717592213845103088097671971717839533338735258865499190108879328252940903530031875488217885391307960937335713558747146")),
           ef_complex(e_float("0.99834042408479629611913726655208548674552257092539196789145760809833107496393462034130044537708609185817556615401115340609153580373354629708510284195454339653752930983189203749731169278335475281971111511800245552846718311180859641461227792676223244481697817031168920337758482434325863801490470394452276688909570890475962289161765324218538605366179772459517413739925054419229216577232979355385292417149"), e_float("0.00176417500141759425041680580659680059523715548574238785369132933219248836765619427381994792733496447689153900699520061778695564901449697279643429132812648492807991502698344584908463672710764657552249013854183229762459259809841260327435963855638225788989572515216716502464410903694556215083403560274482238437657803338638189619962174484586696713981675302588324708616706777450637617794993279153974171097")),
           ef_complex(e_float("0.99931055872941668326937583351044817623279993610718190552490322611906162149144321618370018500791907482196706473248353281002442684397447041458575061243487821113900410635104046519303114935879685337246983542642370084142922100628442409608365518517898739620990276731888579476476506961086208991479450554789466179983399407284059136590821676522041051309391084422984735833119450246835116237187465207906510305166"), e_float("0.00186035655253380884360711978386370325287160070308503594376162624935248773420198849691062561008575530192640885630062666338528334875743140530530318950259222655366372751499896519061066746372783913466698863149988585703844133046249313421261345487217018397849287173987617583962643139331576051928743346272681500743593058399730198268345396839375469180993018880032293362506995990673848873540177943784797611571")),
           ef_complex(e_float("1.00007344776759328954740582531641355019505179487619786317399594168680303414955326172172688148179534990235747010350407243967296343329839540396162052370290792267356132375256317303400370143491131639113361504948039918060005207991503744103468530582051491460559734976711671818733769450461409317511512302737182680774549398157695066855707887000680199875717467896874418744201954683800493602049136491841191603466"), e_float("0.00162332067884917592309261793467487781105186152388802619124805807689470133678476633330277736274084681016095761446123302776275402395572313959414852289284910461641857745993976918220900704403712391930761202630952783137134844710918980109383139940503934197590370776708572881064816113089696370276964700143996952000396443688295671523373534079295649998073967360681573331878123985496045259022439379904839655489")),
           ef_complex(e_float("1.00057334531124507523007631024662197035876690844287373727943778843976822088221888511218327664502474859457101822112258314580312495529536022366866093131335650081138706391375521401646060118744148494692718314814438041499215176143381006688949467507048725372876032440930396435204597388991673591891047791402626257114222182793379918649693622639016393746083945073638543411589438016220793220696650530395314710848"), e_float("0.00120090920510774762487551440680948276557698431336011845653245561229858469410513167079479052620895866358437187495347583777462467491955904764110714206505537161102163962425825604722192544179358352904093833351832721571121440135372863697462688660303702724839346325354197749523952326507778595027541721981202724014421430761378736241140080127323503164144345703022324320827249234808268393131779439886567105776")),
           ef_complex(e_float("1.00081551605668536236319097301144047781037329909587919945738427737927207046997896216187486479555357571446869280411248189966667296440999194539945346425228733414755330909575557125421744161542690433189172546635344633912286394140790441861914152450004131213767937873298801751095225400336833393473106119666274927534448936482141396296086006051015253077902588810340470936724597382402725249979348017791760067601"), e_float("0.00072270026472798008065064961958205374849248451563109229519624306952948655740918850450367603531916777751673968291693930672902831897873540996713255237506047615981206097625404281095771944112640235470271011157891581411181290654478220236656612391891298475859872291412253667238220960176532828385413874866213206548125764355727308966953122627098295422245498227342498465928807875168079297087669258785986800332")),
           ef_complex(e_float("1.00084547404444305088782396368527296453814778311879125123669621013791523748299394013467950263068598011670303945839926483302748610754061872676477520817948224792144492323308566900759332795146224253621267045072139890565656726929733415569965384056365398808830355288111092408947109455788018939237303944882540032665004847001523149842066449211125185049291198702628170483363337383372048701960713564945643729694"), e_float("0.0002847981952129662482141638079741813393933147043139383323345306667365068042855757464936636051184631619234649469379980801012674918702011244102059720831892227122035744982751334117933178771782607031440816110557662403621713265162330951488587241310847796806640647949412870794157972488710021655968171914611277315975963951833340870670396723758777778737606269195603759442979873351145862441045560251204269388")),
           ef_complex(e_float("1.00072832268116083320872473501981797407326069964308894510458578962459550653997525863948891545741475363478750493093920268241846062532916511516457018669561514368021833344504491969990052980781758280383810106047337381685902557659553417501828421922381769836353105175840875702244240572979712502249849764325245991496377298193951919903920714321930370978424008961403210007129432859325265968336588737896795298411"), e_float("-0.00005491531052079984804553004357176204984927016584242776940025792887391041985740076256754549418517017726514206109956777720512206147024189128781466507278315098866274965988734919972636772374133842864851450547382855556196926355297607007935693297051641157221114023776818792140273051575286600916860303170045695261050005320583667153960627607196715763900751251681102029597079686933354114825530124452212804283")),
           ef_complex(e_float("1.00053163806736725024935902617066991098432528394382179433892254505468087097291976464176810681993709523685956536168188020523809100602147458478563845861240940533118917292744422033067292160343027987650344999300489201864450338583839205373927374708957483520620790160695168212718692517798930591488014669499195831992883347095073509102542111554689716132371937206122313499595451003510002951419977404570916488235"), e_float("-0.00027365315092788024605967171544105689670538962419622962963520171100709140829559415339515353545495835324303736445963679232756000061932350002795083172129975906611308106730323342905877035112060795204998933868396600323894533885463153597081654488308213128293129488187668796708354678378413639199868295861877388569798029967162542175889314439152376623660199010130872982804275722478130277632418541961294989025")),
           ef_complex(e_float("1.00031360689240236037597928897970328211191453156269752962129378960688311519957320309613322729150585144375483882918204774243748100872585289573329621857192589099303650578901814136588066976613273987296952844032050853341076229357805538893579546738717631754801038701392905366099005618136080001252119980437573063135502939362194904569694614031595035684266441561596194575656187256949844928165068547896439934244"), e_float("-0.00037583868139350168823908364118386179302323240227444099993752129577098850602595606463311135762811289636559342051908420691254218926968513626779168673688120016350092069467661005045135216762555740777362296808387835310273587405577042496561670023516807065045749646237373126801894303727459666608626462198426703620826635506880536880634765827393225920024757586115319730016051701730642880591191320935933114627")),
           ef_complex(e_float("1.0001166501359734034366122727173743642060540431350444544470639683594966508744925101126709732488609477808602085459426534577954292756253817554272163839484803426306490670610597799150090359341195065146998269111309846434663784707420323092768018585494260670555254137818644441268077793940348645639932431934826939386516527750620705071517446915809889172683679624636804419467720093834413785831374134675359442228"), e_float("-0.0003833699017854231793162995512199528397720543551561205130949617126381131988290065624693787070553115836007527866873676062315167252756875487301021507674219625714008750170367192208883289558268902316504937660327036100016765102310250887001954713254001652876429132292089417212571103366740248759686422333531821251689306920875557154768920853214567621494085525037821119341165174636673750276192893591345208951")),
           ef_complex(e_float("0.99996574852039885256022352563879509153387745633485373653193784477187930647609199142895895060447771710278439023424593819737316122329837321406033160279150551339325143616410914962926345400544380734948827280771678417802549164652233653569079182681540148149123164766267169915228659499970693532026383008727020304187925323492667443360147158980677792208692056698322048657873783746008921803854803572278344646283"), e_float("-0.00032626738957324856737645513241975931394081053588824075889617724639255782724554781270913280577701167828256243327123346328483575861321968568351122595931959435760021762205052475350569577734475820950093612693751007136298270417065583000990952030932495440531569282943123551779568464171657066765607271080594106385813080966207353946214452712867249077782575671251285555654826899525693029300817651449119464486")),
           ef_complex(e_float("0.99987016441631366592245077939564631386056633268285665134607048354874427091355076569713426126156968172607788782996765960710107103497743327147708725599081294921925781996622168245404704318211035046754958656061176207366528222044720934664362927769810191321433899549969745148339139766679428301751088360802552510084396663740679366351585250311459799500141481853203808441813206446060880047338196208247977202023"), e_float("-0.00023511287358744586745557725826542744631729617155319832394545153149495357953490003014981540058194663228856319397738063340036856833681304456672572644384426799825392908221680892917960631112804659425817763029807688865838214182574029987044507076372508992746084965628099371040021016037423190720362768743121512167995474240764120583015215840504118782368616893691086678120286843267605071495821253744547072161")),
           ef_complex(e_float("0.99982714057378786936174168425988847283006021160132206580866725716120523500577304354543597925091603432794096960287229444670750421517405705940728980456663715669029778311724175933477553188443048376056106445838185470112580056360343846822558700661064699557931912512637060665960690543209124091550025987649440162559936978854692538645205490222720325706930947095740001509610573179353434977012808761550985588914"), e_float("-0.00013590917443757367483800863766246783937595401405154823196162541708458068189662993794614311256545035330939838082788782157198381249150612615451224868040090287213542420306567086795923620611837629026730757692932386865644012144823551629161885765757287294087245711494405506740693447184034295341906948279680379997879799071708054634348308079081662947581518951908044027675510300578194284204225190180207490167")),
           ef_complex(e_float("0.99982631695449295238744865119453920803929173412042445071671742157094228463827993790420476185253372029958257471249685872481898710825385203141806459094555247841986217703446080017827752112571933317591160570074919945684017426809459587086236149182745107725953264790980061646369424981186154659991941322057035673289611572007033920082824660611512582043303166654990572237678339980427964611953563275009220185512"), e_float("-0.00004738434911598551511055259075302860406873466841639550110459219488979619409385797110822653515899134261542464150980894972846423097783694495032298076453937418416782673169033175017980904973491534564128315941132560695071849429800143508249730705072943815755158563803046193178762813759618874649007852451292763687707492737543439442273447125795780273775237250422791291929842745308908678187136944740588906597")),
           ef_complex(e_float("0.99985391528038058450855992518145382580115338883015029688005205908359730582531382954519900556102808818100958763656651652472601631032438135044896401290712414742621220809508205130881426393096145734283911195850974355098514863147205165642958307429533596510457467488724260207670584225079439440853283067682848275640572155019735323617515982739252069029208662085069001580614933915745169488882463803254571771356"), e_float("0.00001963794422356528577887207149423749957142233604056726711454577351752455408360286630332441767572999893244109847304992872212810395703034486814888723583640481336633044258404451372423021333367535900900584002309809527690106832132888215938807447838087224280311931310226771820236436596179623819441544877551905902057450820078297436357883060797937765395492276997062590918802873028944180746834192786409341142")),
           ef_complex(e_float("0.99989609504133825932986118330570343809381001190777118940064946557187648979589769517132270988769844824561975430014646386562303891106149956799781473382450236937169553298682056799938562778349843034760835893728187209754482094349985597649151513015860252730444588236477304133287969243989964825157336047734345214201388954390209277296024570283029155252105305341099840401364524647848319353475733553398788313857"), e_float("0.0000613841303040003240704357497821891708123082136384009556129331342807791459218953668780671847668840835396102356262377335029480082449069096174206296826145140707112648388033867538195074702848794718750031241097932947253698554955583097748427297434893826049472301752156743422338824480219400696532521249323419332737179853672375586843159196479781950237186194732397290031492483791786031835304126906725394793")),
           ef_complex(e_float("0.99994121415537272277442697874499149433789764457473310087903376011757907593650418970093334385985444735815175024354673324251470948847214093900472775460176787190232824317458628124634198945027005095406349004583183011043929483842722616195732486566503744664010328633123807563010288361098164138965078742579097886504099968630213992092199499082281939390402351741170732988654173474085415690700502047849932052197"), e_float("0.00007941898378950549842306016061689764116516093698887530582930891700345289123743781343164091849240608698407515608159534965756607655212854982764142097246401061395323852087533430660515210068424428571074307990576503014973213303363762894372354264320607501528147273794450364646743103206795554565095048092570743129133463429004319828741040517567714685724951615078710284476718640764722362880850323379259887758")),
           ef_complex(e_float("0.999980990248036315075763851471495581662631217062423325809125579802668851401305215776549712051459578719668176220249303196664206894539396752450170049894938712953755452116127390895887990821257078226649371738005712589734532912328943456666073661549803341283519742587763040356283963517630402000668174356604738588446392127110101465663829533062111892827434430983116324359727015931730124156114333003543360197"), e_float("0.00007863412207722350326121192656406898286074146062710812386793425011994370875180484548902551668481536707660280850791617280646194151354391992668144855812765733891307763960013155163345883400028709890688307309911562999724293380396927849416032568354435410963360070939634187522390396554920195655617001892610629246850176213060264976988795362815429940313504828806045416927049068129221447485055156189352079279")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02123_z_tanh(const bool b_write_output)
    {
      return TestCase_case_02123_z_tanh().execute(b_write_output);
    }
  }
}
