
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02104_z_log : public TestCaseImag
    {
    public:
      TestCase_case_02104_z_log() { }
      virtual ~TestCase_case_02104_z_log() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02104_z_log");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::tenth() + ((ef::pi() * (100 * k)) * (100 * k));
          const e_float y = (ef::one() + (31 * k)) / static_cast<INT32>(3);
          data[static_cast<std::size_t>(k)] = efz::log(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 101u> a =
        {{
           ef_complex(e_float("-1.0555234405475835252245784655022890867184176046999068512305854572646152607983799562376098239226040008809413824028781345270987642313155075533279551607615346816561609834714287286365882180494480521653371515685137599526313331311674544232357381854861116987588418011542394552541624363212639457675425486763609095290672343223156397659018406628377738300549836973209741554114132767094938217280259346949485107658"), e_float("1.2793395323170295272357170702068602485954171006754874912152662130666091882325955012425037639622960099428396875156139059153210539296808137296830178045701619480586542202527179728586331974900380765032228525500207592833266355097298622879781985469725132871337506805557800217761079831387785882273136357577325669894198872855353576274888815468731649065421421833211294657699427531993290728822426448750005349161")),
           ef_complex(e_float("10.3550734985595040114631829561540313058483900391264720996236934500812126072732793992835762310100490751790792660291225360635392877206943698825813528187638750687584483230181723083126503629349917011907848835894873895473817298231911511984410217124072193095030657459303450724750484825057359681660394956147408688704912890152700289521928070594833201802261735794405782730676028755825686153873191449331821583237"), e_float("0.0003395294514598442470233031689420762555763628378922441928721024104837974596826893651378664805446748821075555685458185877677666075405286382630779016418638991459115795921404624926512879757543210126424620583750314901695011827453401926437640591388578819238392811364021135752398507091945948232080964173578735827505601214348803592277669060416292283032283468147288085079458016884058898036881272922191828877")),
           ef_complex(e_float("11.7413654286831755624350483154156762883639119489350883451221913659275580791268809114329588050987226622340251586670477094370203300485778219127818063270700785383210328789766712766335450516302650369348419345668682884193796426314140542405775298672780950560286673058690826646289196804768522109184457126266801344626722514538643206862807310999268206697823613993756565062145906499038901179646269562471554716593"), e_float("0.0001671125557069135309352264363968241984759092627521174192686217525492954087736870638385841726781398984008305736776960639187390031002047731706767019246476475859366236923975110859432680846114040458636241557747623341364040377557821612585964438182178387502798874923160556494040356950001502543933383527954205485556637415891924105873670363748579389149468915573934978843273458168541278000439910882269832677")),
           ef_complex(e_float("12.5522951949798117769537059716369184574960305674056227524932118688511557676106354138475541732158168923935476075455953938786835652151781906609716220011543311878478845126380504126740694476785406714752079311835800547333369213633656112099351189198395352904502756067565961260270681661833117644445954217544389397429450095410649439917953379357378490271627187853234484706655637144836181550318745464335095717586"), e_float("0.0001108189577642956493242772924526654575226458108216548897964769017990410285153828497684631963236173285066369432684259852898993444080892499878192525869174244887636277090626394760014144540850233072875472387224841308059614287761114658953096017824204467861832863385948051801296083590600813352512655248803114278838183417992664717178069061732136284307850852133917625485433504935833046352034906789494748523")),
           ef_complex(e_float("13.1276591824446631085749032923080526387515330695501485852223844149410569099440179341399224056817846643374219757519294053378370367635694574717764346684638718354163730220253525333979667594514682696039223437228215949273190555482076103547783222631961708429606411349528026748059610754025661355623320889541215855253388961404182674829440498853090443788424095437695503520841758259447009693109974238703554470037"), e_float("0.0000828931828460932842902573973444749745248508075610911413942368616228448110782441495401037478926111283000575303217946289294817685028795131606620399394899629279955334704046562188414408525644764169043915737914925694998623949034455037074662406968994817496556654083921112322767923759008617874868274268885641362226509597820011526494026141765650260620676588564000026787592437151839407622359389551343445123")),
           ef_complex(e_float("13.573946212209509308854283651028767311852447668284045439750485774917424471802206990621561589778709716998522390668259304488113131556446895698378239775398112505297211568797120229861139845113345807502348602789016215975369222534998679042945220771930959279231228341792137321355157682697290231471708855488034558092187059022707416431641177369061128600374407069469026737512711430980646680556574793671869962059"), e_float("0.0000662084477995641844326774160085203074621187606864834318892086335451734118359017769859432368177545359741524572441739266084498480834770830472379361911833725295735418574084447831590569411492672667794228172899319078330299297989761929714820227083260773482661516446183532655054788115482100218599475342685446472685560964718977423256240138349685166999852965899208230459816590149703328609427880263813168974")),
           ef_complex(e_float("13.9385892862199203497005611103160541940184851289122878573023143470193903283036805923299061609055878737500863368883496115213844294587113167549126757662305195182650756119492897984353364836234704714297277010736244217674679165310701028515017630816277625870632352461761911357733654779285791847530858259444239131572418396974441547111762929930050976943050463613169180354360335244378966594247097447977801462835"), e_float("0.0000551147624009500134046323288080441253657922235236188038981743669846420471052203187262615190641668967136861356588326766457401828143237859620046281767931010356501808197826850701478494635785962991141954053370606145326110014708854569654113318316992106539695844771210214672929999237594525090030434247539805405609517726460069284084891842776779796391906697268265300398523016912175585209119831067114465109")),
           ef_complex(e_float("14.246890622011571128008604799628107885069909572786671938987024488164818684461802269111564787776500813538023033594813778893137397688456116176420740401744077783453791809052621229783680535453574243486855793767030072920904738416816284130737463909086720233903487127650756876832573961319862194274656414338012749538117503731241120655492812483529829230760705606364649483328582664378408982444469123032333417502"), e_float("0.000047205136482153448830086061511408936567647212728318919863877804986386533782565752903534139821772750608184895925040004446175398928779638034795059207016869676289217776994356255253017387250423218580658037709138599335489484468474411328402011103466176053455739958232786512916746149488648204623176189413831306861753494065728295489502863742947040517235866965219716954327378931372615121470768927668699047")),
           ef_complex(e_float("14.513953391773225936639724171731708674593822329340770346427880112535121671547432856870549037820731609827155061798607499322223173217506664938209360708466128223534783822184018816628353825219234328703662085004566221454613833228098233499979804804712479471272741562427924421499514103722032297071078332217372123122737927277523197005354236571194674124852513944486645479054423458531365857037515724551242914869"), e_float("0.000041280811287872284622024767198034269772694323718326087056798520539696597719503060440282433273870357463666702835563578866134528962563756813977093776772778488218949919290383107454775817529473182931789129700361034155336024890738708215468018842902635016640772453551778571210185779873966874930107600019390797130784643645443595679924730978286626724704734301071378045631941442100522620790801172880136905")),
           ef_complex(e_float("14.749519452468163854745278309882293735577978190373363832130852031460137914577705815369540170906480957488041700878167862486454758448942739760197440257213991647923951183676404753500383330530939298653182886919037832147659595863192473301180246013365308485083444778392462472964812222688355396782072238851954837665202755719397430675971298045700979121458881261301076527790412559226335453169465887283198606909"), e_float("0.000036677680900837391858470768778497500025461954617181525897766186187080584063241257971379566475621648722519608175090557522863739644612511390491558080570531374621938452914831544394172399392178881270530833409559172342772270145396807315485488374448065183337609138685726752934663871584083357147421944556622043153597662675360272058319236861725051934281743794717734888808412662573298519728383896879813883")),
           ef_complex(e_float("14.960240476189100477460925662966421431754765368271645400846044341970380175624745209330852886456199966068079693960018252394957843786911819809667539120220788121477021559864941157502636471898107815658075643400749179926154223296366402185372674307207414975261096894705138444221917160082152484004949486487869292952940724372732061797467455223126627347447646282840588834139436133846353374467610748239663866942"), e_float("0.00003299812380537977234583352162461212624205405023085760397374035915423123332736452674957988801994415023390614266701343072354555074526092800183336248613337780658468743843263782284612823006661708548044183639266892856375875622182530678335085049887164028958746785141587740413759058588169838829221173640719549121347102610234315456904634017291246091731597218880459159813004533535345721470151688868941872")),
           ef_complex(e_float("15.150860830178611641263165644365046739188320939221722558039962757965995431456590355524917544126446662889185089662486463297288449249700464214530078121970698882767691838642896592051169700506506751504430008903262102005132828824616493753615933847800705156608372654781189487221361800493892225057725197267104850498001866292173981781813239821194508306072391883305736644220938977408632735742013800527311956908"), e_float("0.000029989525668989494702003307852960120185051980682247491374113219002479396440869319674030906041126801644312257425736733202732362226004062815293274254844182766686572298644163511161420510760713123754827221422304855013394172430592294744206439478073284615473679266445707769666317072355376769537631069706581672506487738081688470424681657052232062200323301290723873172500695922156767788701902432351307585")),
           ef_complex(e_float("15.324883579884113382138670655773229711384119125503117120816364214494475881111769084153413111745459420957460304808442635844189387313776376925336940191659025625954258634450152200700896520679613835685766830514957619742256815418436500079966902188183592924921355511149476628925687476184525684039959209254517362763898795920201137715805641933139630423776018098285035736163558505351325334411491798978312189388"), e_float("0.000027483700206518424603755393239140102550033213668855501851801803043243933134182581553439371039459215206333395113277008199956550359829296954036733534326395381253876357591330171819563257234695477940256373698505724256387576860831356020764559420311320264671687436456866092464015118689413031050447741262908823922055413414566358407770296001051786850377073694820953787740949799093909581137317585850513147")),
           ef_complex(e_float("15.484968991905235523522652964845722156839638411096974855941621103012695809835823769996582565437444478153967760390095983082826649438685269743945573934399108272874931940589184214999061523754308705644656313164459157450580727733574378746699895466023825539126859955529479276879028001545789584157548114748932342286475020335454626189616600303048535720798617493494396474737393067447152745028061045558630483504"), e_float("0.000025364337587486776350714728220434437445341155826427061198538886344385473130893332549995830982261928087705872583741954960565200201862808640949372096440503135979853398483052937781075305465316512134817691894978256080221266139303551022394678472440252614613373593700500089433539406046224340558785833515570373192645788550709478034080676806676026337269279194617720842024661569108261555195601963426449006")),
           ef_complex(e_float("15.633184933573664720051238096953448791401888845963091763650025344302401023847721074114950927033979555749322364017462307445883094561155424718741125225915305638936593093169683351296302676396164590347282771301931582486996020204734471992235586258371659163350137286129565729750722194108735670283859308722270692375743772557767967180687341529076879404380606905390927211241124137667067841272092811574830911284"), e_float("0.000023548435070687890535539378753506393084514951892827273976450339481586122605273602216091907335306476852959066548287170594697434262437242786695488587398902606408136118698547970165128118551278251533487933834980621468121568786274952836104712842128258292030569672050390381179439402769228179985846175968562659703316614664614527133647195273923086501464835687205896737431990620256995944341638060281187231")),
           ef_complex(e_float("15.771170674418563066927569256743151307844329414806667987316067810350616976582859209699231193288511885169069143939191772200026960260801494442206508006123055070494730740006415712454129216429123765732156011919966496144387584806491848529072369267878333720746651388729609384167268929876964971780551427560997682379050623639604996072177330794321986308682406111932500567264791197983567831249519363948578209403"), e_float("0.000021975171087302994791003155371801963731424066225790052163621909164071774474779535796327713120268190162184726120300744264164342830763070733335116147716143072763820930772458127110334150597038961381067736950125878616422403066202905961471278436934662919631951399976310935453847274476858868919831463825182088402873905046859670809346038544694609620223056500524644198408719969336073464483255200252824492")),
           ef_complex(e_float("15.900247714951283810224210756719595573093457656600531042739157142979349279343584370222294652671419515635839468344224756686420763422356686400846931898185578437491239670212218512048109147022838253409075090987383337891333018877313967031111733258607865285225229740077671544368804660031594430399446035455702890397654376643538665976907752005984620485332094134842401221205871345676010044949315250341151311501"), e_float("0.000020598959823426111626949189258562902613195755650303454511437250698663073940397701426881603026312855176577840152149707446733431589706628083394394837469729795738364707208597352032121830060773712564462832099148426777124899641637592778398677785328444480716051236844193597250331463494734122162092944215390930061312974444081339241342199424753788466208890832150308577026929336912475676634139920754898286")),
           ef_complex(e_float("16.021496957140086293269147231930416936110330600851819731168781349740348299702031681552293302843336650030090194194900624415597240793413700516428792712808139901583339170135582961315832976423052740742032656306730793596782647783433588613612277486194800072912182205240673467695729902674067754120316630197498210359625293495500005684704566382321766867281282679358359761699194761870795447476161489067933358415"), e_float("0.000019384961710826069244617077488534335230820113374212927895553826651490710064681632164753794749239579126146665562108876377048014427193055796588393602284315159262921801228882130395550406442706287728142585438762837550598357720725399461918534337903797307828196797780428571337206787358989916690989314681496498001201012501102145779071256948250475672238707956881655181124661579313395312651596546680611009")),
           ef_complex(e_float("16.13581378360984797126856102512692723075362811945799745407009709898188903384348650453972488012698332509620692739842344453221166643212083619715712794432803875798765429530678908600786926486243402319632758564863135475760652391769557954686563196543856310598064895877941601394888917075107125197690813870647591603905743958699845456037977452287325538776846317378318568425049836443499133568961228826540807594"), e_float("0.000018306093066744827861559683207205089292520809250780119326719271934535612224585462917169530575654110454919979532941785541507372654518192295667858770985576825249380752580465796857931144562866658832935268311747470034100196979067748278515394109651162973319039746939238218299885517091292008675907923958839488416898929676177338354785181815337889536493477747522256602728189908560200612982667333667774537")),
           ef_complex(e_float("16.243948225126266984248785292037200949780365059738748872210056804820890795511130953636372631974999761599910260746931006551234039168002472884978982853881055054923663515137502671299419901722712626932481971819472552956320562781431491262947998065468347204840315377786549280686900656170385294055681945287952808312189523676559823524683476354591342500838211901757338882723471877944977759949139638754823734157"), e_float("0.000017340981641151433127153483003386512256682330435761035239258652627229393862074871648240379526969338016985229856574508742892168429808364232279481711746188534709220489436430168128608727346127416341414666828265200133016064032424121330212764770565465498814808162889999358992905707507873629654735848888500956068136328973624827091286491871945862744500259940010795390860449092146475413753649149772621438")),
           ef_complex(e_float("16.346534813026984249024118938308835103746791012529945347971040149777541824035392175826472925697715644775886620036506448096742790380586150028557905517813833067125435205072744984765778051852660212199117053605365609422760353658212107185681766071709282809563289135703585063811741298228267530016236035633411000106799343079169974764967277939178816403247596345958034709649044439452882713233425328949984728649"), e_float("0.000016472536477436976463657669082146534379436101158711029846398582653695165643092218563081264736808876463425596778838547285344075979948275883387591509554159361817001373416741684681784537512478208377309847036882262269511987552329607375719131506340292092231560681433014546563315322756309138116356125341267015687831324152750858546118719611565755979522295438908513212745229401037319108433821573051734288")),
           ef_complex(e_float("16.444115140613379967936525559389527736929846096768147905732794643131702431841949451526877087850462047503027087219600540541078941967428256134491006327598046076194801175015968977909086806907595825834452542578823238451406662882313589842809975164206649779679179194884408657155783632244988986763028730809792228246932142928954852958237048472271607236312187599484968214510506406046956132555700342681253301394"), e_float("0.000015686927005050393128522541789010192097775422540205565361925602232285791523486877874785341488837419135596442412582520856788101777914216845565548923944035330646955723392339915931816409079604648395967317870407799078316532107120928014734445816082163559564555814996703026736304093407576861540558360345029561642147670473302246788025295554259017576246406847831759808325232222912371513502899715070912193")),
           ef_complex(e_float("16.537155171230958119826627208134275571739847095069854139969685974457143777964923885533045584947365329820747139367075600172239413079011504339371722044806439471116153391905207082884213024685469267151421358655247853768073809975912294023894622041090747050384290306148103805176290518765969969723951809402754308217928390168634450076220181118486739364801945239554443964121069122298369452876365398929146959227"), e_float("0.000014972840965391295144652892243209169413765616139807244791288892780310626422544646592032909136423355502362909166932104128306050570268153231632703246368873334845992837848205196399618644475294161881015326869519050329647947696642473310598668023424443736554734860555539709958948412509817296162016635173494992009497076044363370237079869581171979915439879813081312259234307210088226213027583783042207422")),
           ef_complex(e_float("16.626058695803626997319132127913502737207944367033050257033650305957564055102655547610975236287595864418497123968120857105622032946009043292786415939309000580012773959881194617209721478008205449606086659465663265568134120877397097389952874935526182849492825785293525108268318221463111865314897939883984047033148949379436657868264844459073653538107996592819261409255393515642975965731558456568449010069"), e_float("0.000014320936191061170183894468695116470536410525584558260871212556182221951067945320831916107300609411945893771121437000919817905836276355244719316594702562627586931570766408095675803662643830948886175715000183042797166530809862342539605264396050544915325436811270850485527068094588128753774357171122174147069596333536896710841306551956350679996646991223028990475242611953360106169320106570715146421")),
           ef_complex(e_float("16.711177924141853696350261220777809264159864939946413194775302851633008009815153520454920208706617022108436838721904405768240620956650551673192633807936041122196146902819803128352884995217176482695706813066279896512754274997169649174414209640935531759296904566558851103290222175187025786009147364437488260041936624755849496066856330924787285798701602985205557176696539457257612831543565350403802317141"), e_float("0.000013723429622774649399170588156353408453836673156713751879731168932934722200668121016432326341076742288107388031197515196706705852460106031460107314248788698187543480494154653525846657641676880409426620337619629605041721074283034948389640100371659930056053777541953443825584056996156504993359056580981939705650601120647041272039599246941188081305271401728372638972049057007574566552259157453144193")),
           ef_complex(e_float("16.792821912741716881369331659698358134339711911254532889812387432188718970178103985351372283422525655965096720153817283788047528026763436983988749640225244470275683530529731043278903888346108549621471809287229073371159938383449101625862716885774951273483665483509111408194584141054968347779767027642167995991211397703566105098741476351061077883187893073041040597518186297183900273211740031806562400497"), e_float("0.00001317378508833751602974209064247375510425862148394409553414917983840095083049621920067850879875318742049019709977772236339598046097057655147576055764916131510576703678969746632326268278140596116159699729381369765101314046635300036250593621942896239582837627822679312207787270018709582248432756832539775123950870716666579521600129499317312791430935763755622657878910738294589498243882435066916044")),
           ef_complex(e_float("16.871263338657492888984445300443458429033822168191985877084116035285633068824601173279023095196323844949789033534830219268226145616962444991272523951888744689298739539541014531224523816197648057532482017080216633099877817419012087546178201042930045576722792891309384634755615107352749959642795408281999709177770743451263941563508831371832852811830080810372388840973403882810476195879135336552543167862"), e_float("0.000012666473221253564275439949160719821688244720433469946279259663558559783357647336376315823059547652287093621063452785694132483770705874602220675023388889644837932535043973963061987870549087227536677567588284760658351448227295313207117862024455724893052320730687543376948629625780120994201061555269598603665111781765954489024084590402343305591146989284181577223217378429936944410217060218906088619")),
           ef_complex(e_float("16.946743994275012585690506311783526124343987568387435633545292198663556329474372761348133367884136178784036071289982766685390185728770764314850415226683291381097261025006278598112309409905435691585549013025129895964158253312289622420428426582318210188388699983984029693972720055105316072433721381445926743324758796380253494745604428693601110681723717818007545125246847990809211307793714520821302887218"), e_float("0.000012196784793968100596958261090642328756569059526722562902542046336948255753497780280715357737191203787734395998454881248788838471014473207192122546084278867983804802925435104319550700540567466760963213937183237257060107013705974397618045800819517563688706215088667539859678331744907419019720399618847179859552170026754978913291400727368915228724915066218600352671985610643587745396901761947161178")),
           ef_complex(e_float("17.019479282305222673942341052278498153331515400817296712696384512914203768551535279341712803845413813424472182169886017415291123097556170499446507286174360884423527507237734610676172080671550119111246807251596118901936981645668346706789036472922224944491282196617041159530892845040769845204638207883459514524841016300903172754101186689970911044086576695424731323383375307818776188437951563123991776234"), e_float("0.00001176068409684942371787804623918144308247883254920188466377171829271292924642208430159417353016350729098950606574901350170085468671153233313007247181705985219636515714835674878846414123826921105341906419121172520779925153326226668046389487010726968581163301862849561187900077050002393226265602258999653768079904958023391555112671645413718608962935037244857029368392482828002114688542540981090782")),
           ef_complex(e_float("17.089661921647893056919483239100926483130942117532700662702926872067817721041373671801639995407165535372220095638438223192400717601572869009296173123876976554953736610520632280853581731159591058071175113268401573441461767998667781975655905711399681780272546912110357126116068193761464568023870519970731230262859284730708201656085820365021755543451753563393944957061116624620708313786601610852935627754"), e_float("0.000011354692686040685946624831184627574826044075084549535501097530417410720430036241925854860360021412718479796150807024151188949424226419311309992794084142129503457809421166256745829273417744874557250149705592125053260399998802420281014898524155829207797271467789575989040767009696323078500364294925321040861997359392562045163449189720293294289158764770184450195788913030664461270790961000293609565")),
           ef_complex(e_float("17.15746502474690422132103020435513847262679548894665215805530781138458168557166651520567074739389252949682291578033560436467088215652594308875013470561258080255553371302738525061725853225981260671540697715226041454153784503438253854493814039283602159222711001388676881673238046701006539119725000821978298201779207214550339997956547077629003763179784734808636685042324324214095863331132207153526551448"), e_float("0.00001097579640655917270204255706851483690275137785078298932676214598037403633518054047712292751199904986529664072981660000895065900595809619245264987405320993374714893410459439194972019175830803722413496730145848608823025242140565425434703680387238687608782852786059519977742564425224745156672421948238330307710856467687278227457410650611516864303995081908916294243862065984035269361542306761578428")),
           ef_complex(e_float("17.223044670164559843308559796805165415083672566530768683396291422657694873540600443486332340136101362260373363881198611589937289314458267199029653142868705285220306074413443047364068568759408626194685581452851137636363242647598641721377729610298078552777394358455236704228097858640303248092060259087580514212723912846663445724891346710606555327032482737464369926724931586473086869884253044735625771833"), e_float("0.000010621370429518745499112476155228211067789864890916437119157273154579491155697485253382795919942077159419001471788344989315240094149674247581217174183696224348352028574086803533801162091660252296535701053701847420933116060240623897638007202092405346146253862396484445470014736693156605277371610515040203676659440551782039118742097864129607522930048651427461821925163083599519041859875473798443948")),
           ef_complex(e_float("17.286542066586463960123055239926875317446435783897791691206291859000038080673515887411789890361655421592741091341441887305144337834621450768993045916514672730181480588538877628210597062440779944432369455851229009611865979423153264524273059489196304365184646651663165310538955447714138061860169603948082279106064026116972219033962132731373083560060618913098692240896768111716260690378579013399038371215"), e_float("0.000010289118358945690459924855976672949295744670194302376887306324322815609903089968347654146519327627502954702903925925821250628884768102836197599786448299212299181095988499076499245796189379478719696884523153068084204877761312695191640954756378223520280529938821835380620261432630804189308083998964991236488060248681553384686955351672849902500059023332627253318549393198270221668363738530022799411")),
           ef_complex(e_float("17.348085383731269661046079391906651392664569185229469398624038369810095025332152455454285543231101956978621439122889045434971193164071626184156618437663519394589057210178727323892415678854008880070562196498184875754521443703697779406816529246503144619297802002220569910508077322201481126030912912761853491766917992575668445455333192513055994869845383809360765629086019174016067676891930162013031468216"), e_float("9.977022420834131669718585259739487784931241397698908658880530660169384038727551635879464122424019801658252960630483672644831085197368233643715278393690579531027202784095716930239213548518069663655345824372570577482207886474601014926918047264689787117443085384795280008665379868182044786336847693535235211796072423336294852998891530927860179550467601620682239229062332632566816483365138062877436e-6")),
           ef_complex(e_float("17.407791309858334587167566282357415548118406138402513010939972266665039434859687330945752094272645953531794417555943445735822651112571432196736277990746522574219167275075668078462917863516610255024570251613329587433324395251497357795296592174996709561341635005123679786109369997291087960350431935320780407225058861483671817927956521708264268930209478347424923598557527290050564633539331188735018465703"), e_float("9.683302450655010938091254229065950264428673667335665391247932713258657563355710042607599108588061702498724139813769887245719885423991619749189279659448768675753401429277470459010683098640676135102073670650399122604075473076536860326417412545059443341103141126528742431372629705074201065674906792388020616985613496171948768993703069383346542433734266948733745071230168280076945128065559351298012e-6")),
           ef_complex(e_float("17.465766383447098327126034526676823610297063640305059874845015323811044621305438145110690339449892990958399778185293431582292546498271369853934481333046050023114540619496839768550746635369076987205446342734838392600140154574524602897973278976257543394478533790385364262810472410936999972880498207960519895231806445880821951543389434476185449503317066427135084639322163095483451015821468550302316675796"), e_float("9.406381918017903954200779838955403051584093026209093798741285475565134217276987369065287011162922458558480315304346845316355749890326679960730699506016785386353193387233346310445863963587922622388907271105922608094009111380901997109427327658563835519344019228297098410138735391410996036583531664776501719940771552157549479690421004865671872870352787906311199670519445906800897969267178288015068e-6")),
           ef_complex(e_float("17.522108137235711939975533754359526214106489041030042478496531881987595484031639431849115742315931555974494659355216469703917197535161087984911964314184717928001003075808373013202511844331078603965340944497708388788811310002995241928089805760008298743799281021397546675953434387331875354637875269392224012916515701918504590574183779194648629229050605582098897162658537190100125647330666820043562336552"), e_float("9.144859618932947196926457403547964033752799599819603284299357870629386565074854231201645608645527547631614222528498224905300704948610747953254675592256045297867144938529545545170044515500145617636591985027166898240162611870453026788491507353748014109064252131800712894175678925847574647392311190239477036531831786215542963425736708074632301495406198302221355601650330593920107107157450273232246e-6")),
           ef_complex(e_float("17.576906085478741423626540807638523612718721585883565590870956103920379088996268130253372538163472151950218967805103475467056153495377822247715508443419484347384042556714848975419821343927538500586707796870658418479203836251854070991004862602502402235176916029373465874058573604853099580685764961010579985888377436945823829629901831042111663607697090702189527148676002682809740355589603877849995650324"), e_float("8.897485962495775951359962761400171292976012231834865373968677186480612187670119361787895405478383938610730174501220214055519077862679591960914379900174332278400893193044071858376377376589329876585858485247990699541057487342806820764524373536875316114466880283976297972127835138282512742272214527089312288816189692315606893504638314509710406289263822656065566515325268831841696242629805039412246e-6")),
           ef_complex(e_float("17.630242579520241562686333078072422795387299654294517362052774032384561099806063911570529073377696419065724790491052378643811660201549018048701948939000138774672749580132691593976960859906645310000162156627864991164257358256740000630483613207070535590208962612371962119378934060158217014660510250522889873249528701331308694687839923361128519623885914693264023542919404783736200393375898685328318626906"), e_float("8.663143004940709557813809084867928575926528447940415979917618026354853910270326750187055082579404354245019759404583750079697106067539417899015699064371460661779500794242486908283069803575387642863712892220372851009639093400494273315251218850651819182494071643030777947904385450100629184951634961330380479786124220739657585302750467054731846205208391572434279878193458189778380916667842781504153e-6")),
           ef_complex(e_float("17.6821935522132667154008773716940486562545302741174243704422479006229687365159846014029446982298634452658281353238839825395995100246192019881143889448007328555424405689935055292051848813634224538411202574773973348993064652883672687350392321383046064840292646864481514842740485093928215262543310011676951335406630995196992081955413801734447490571393705623396528298899689299763998882242756709707327747"), e_float("8.440827557904885742352311627146866967353066524030058885627975829673080675491118818264817142147295430438067677405373073827908663473177487475194982866088876495704537557412427681518907090887939117732329872315788423583701746065636238170374222027741208292272723869253828652430566188823268706689638491352803993856684740965490119190143994335218460218585594795979775938954598322960911934755787756093122e-6")),
           ef_complex(e_float("17.732829168076755763787748397973786485784208486728164934818923003807596716111463068626214866756736561542473184732380858966828349499374205192199151450230654533175594818596474558808393676630667631851960670099194461179850376040938583865697673374612788655917114176240438978494690445157062785132696189321146399085205248195733158829586463777044702454253431609417667329523350991246804165304069574259580787721"), e_float("8.229636832485289723213702464058254589550903064814241094707779161446744252949553621686465465669363300644901610626430759125176416344980801042166417393710359434454562794472419190989002453058239870380192958999439632813922509687394188897582040743794496001807325950053251690910858557961816685627717220142371492305311847383689234247799687584220716678544143402377450172755711468327370339279922193611488e-6")),
           ef_complex(e_float("17.782214393160003554853327031622622098405575312905545933061403755114897272695460915693137864486069769180142141381277052434669148185898829363522164410750078445183472460377012801445742417505188372257205734504195011121109275600148032307151733760513626457332332715860353796347837267194656921009831791336995749368281671114525929387671069855084195791101122047156826521274070161272582158866370142533810692238"), e_float("8.028756185809877626256988956117943659290609478885256102858133197262148583857966009539908905776629980770261570755366485312881855008655620607117202905157911136067642070882719756471517061334883277670109692968220908773742841240871098731350319214147331538967743964513441472574120142224395904652630101032409840114351851385507088595359589899799883193071714813338075676168278928106103086342539451391326e-6")),
           ef_complex(e_float("17.83040949622751013368772967001889034933544975006005262311115912773720904423850215894308799196636369670926594512464315332208617539069023648261471605832175566145383798301639617131481681100935425543552627969855645354770728819674375842453490150194739231358485064525627903245287051771175526201747760185963882145491338210268968008456193439232128977312367680767889495947197554233147487709908002892916722975"), e_float("7.837448619436239284872098623166952556992039766132370331360669811250163649723636372417798379351450409227037306824478042575844086830562605396351568645275950035805483168348248362055729819556720949322370912935457090818011792814472750914482877388858322377635738696967372362518673947016914705578861875303010609857631413826932267304662535174437969010208352763692046517684109962038799098256343722235488e-6")),
           ef_complex(e_float("17.877470490963532151525871715287068310890082910664406045934618487762078908939855109424332730235150110719558626208737709222774391922657288315975650166239278953506012389739951360474396693994910655767459051984484372331485435837227333371602684931622471278719300585995166778812520450777627632887916746237697884666379262140790592864780209094262655697055557310293423214482272225863378172499613543766207490553"), e_float("7.655045744183872788690561810088635045472413762736424631002088037678910083468074150958217939551055969707695449063177845397514861005738856231926174811439426232427517466244512495612753279365629906953178759072742625727988670623669913198470029948346556236688616230411706775862127819818044158564406234115219579394882805448252146599643378904114384399106864182375903073547947311138941892404897011413928e-6")),
           ef_complex(e_float("17.92344952733425010138041071941848214120883497387798461127610141725528020801826314687019705294002787256154095917810117642418917913852956727399158728342312394355719557475950987341488391314517742033982433080435526113068297017806462070041493883703696678687208273191742005053172746694039551849424267437109694598998337829852119499650001599251311830040477874262539527747981563675077084290738801210068807458"), e_float("7.480939977933741937634772225426483515511203256267387624336633531245622512549973319651350438641418613357122782252044528189322798023345298764016786089989475412430796293952939952992841641564230563957753671481299658958862263673547277724971818261094572675071658199581652239615731236778663621880164919761287123386682717120126646110562151341120932399909957055859473025130516039966683451097898611003061e-6")),
           ef_complex(e_float("17.968395238964874620357725304309015014612755809910624479838767754930443660421708789209059282089125924551677435227530418805836013557701723346515232621377383278931605064773644150567913251937633243987514103831284213874621815999933852649706350281634661510340246246642480556468855350915015985072274836037273763091763396988102640422745065625054824786617776647990504215924476599523066793627120611291822543791"), e_float("7.314577784463476026922351970792996348914382733965270971456888183574441949719865500673775964813114853119726776442473982213417909652082405356555364504274209982732733824198952744136916471794130744960954587620840399126922081736895252295161675764514508234618224522527838330928182076186865436499353535424274002275246799912154643060997570425291732319582359686831547491901333338360790410657552836923655e-6")),
           ef_complex(e_float("18.012353052333673198260767656510153488828347213251484673530362775719118094958262002442531707913896822387743594140918624557425997115734178674095337067670537138353024582841152457855832680423827660018882316314210306880911569541705957530719838309854955977258299673901950138205477011795394828337495224868379771914867684116434175632234870157164722722169585648221000439507797121908271734816308454284359612991"), e_float("7.155453794789249265724798646746892780954541627789921706397148035978851852043343816777641452407945865453405545833140846989276573956496189169317404898052849697200425160962544192780826950153582462626219396598015743212126294087256302727903947349748238810355143003373566922216948347067269178239271174839281710498770372094139954121535631621491219146680830812541972667974121804607364818365876887905055e-6")),
           ef_complex(e_float("18.055365462711190076306395791381330968657814113618785589347864518214061131243515530930873770465165181011089333867691901630217394310538908947151694673352998935937085114841533075654888356418423120202630613351555376783532311302168982347689896583599124525364880323697841958772011095938455828535577168314382077550574016088382386608260560792158492675400907502436567591271714763171132393191939291384385388417"), e_float("7.00310567948743787881659718162994912463905309598542326417003268192741446284257509498998441388040510926956164055099610969905074380374841224385675000193721108295791937433667374528323280522372707757723921637517800563473351630262591156868537302573280278790231136043700026586316918728923517940889785447889654237051228593877456471095904982947048292085847538705602958610582921520607933659800202291243e-6")),
           ef_complex(e_float("18.097472281046428069301184054411562152689846070308928965139390447651576455783008877770499185688567871132483093023812215328772598553459825339791664595238115637202024144346878267765301671635316330175872667685808365665354258326704505747190824318480035334341386182359926244479813957663104973599362029917192718364642341899216556523630261472048945323517745350766260129829873061067768230807715675684802421417"), e_float("6.85710966240494779836110349799783741318026713836041015360751466697093274599662405566572590629622570834516849486140662427698788684593899763487896172109571849124434786098157090171019900005397412493156351971153763342491387773807294813587202643826024655938805835599896508606486778849621278459696581770833157275645417047503931742313429824815223057096256751409548191962671423576027621063342055405089e-6")),
           ef_complex(e_float("18.138710855395134489941588468857458789595154182095261096098747619955783676511223897287132861886421619235766154486022813555058106523203886153988516377150814050005915627408603914562057567972544867484932212916008409066100136483091980844294841842212058754530687240438038326297800111393611649716805648451099399129582986161844194810480839891842020195200439805825816293418360450218852928950840186371366267862"), e_float("6.717076584071242252880523210958711387996725295369677889212557922856997970980688148443790632741805690726756509116122988634357433989529238017998695736090582885352582755122829986655117359549545336699097298225269016006601764674848320278911466967102868656411487497938328857875037133783914514581184132948264310219410041505264027227872157463981633853551045675339728532775632684082682568166856506617201e-6")),
           ef_complex(e_float("18.179116269976780201605508946179836325054419887551575244714821517743540070192001298873073217436454682509142480715278027891183886430908191941674512909447368851443051612166323129729619541977023285456092404591652350399106489123756400454231965919298833504027551373493762585828608246172693804470828672638026418868173871071751271540369705474377075251971981451420096257947888602706718170239020763300215502172"), e_float("6.582648437804424635860924638346929909131635240967916151466178244654568644180352964732789709537337207250102511542322579872765298276655213528689680487810419206778747682392812727258531981700379370806601253277519771737050948410242622525563850482770097246151510718417718981490392217062617900092616456475759714598352864336200845542311835055879724534724735080281839592712821415621811210745871199114994e-6")),
           ef_complex(e_float("18.218721524518856355074630469868260242279423720386407087166808785605025871011043261623783878415973990101496137117492563708834480035574619102491911596907160224381608076621431314804988026942727741397171652588707113869138576306132021714273403416035051148053613104439965132021894577647933453550785997533374724968263114328770720067471009759189050431013742427021898381435580457024835705282410046572638130278"), e_float("6.453495313590960647677824552702422426053829930240986605290226156636552828364550817017583468316181474125462029065641278477946077603781949400882171196583754294283073330884526994546605851515729244481157697903348871671241953588247983943234907867923647646387380605401253240750258760689440643693866779441552053376743261870091421057814866753136539832851791374085578497367971661680331750843225958450368e-6")),
           ef_complex(e_float("18.257557696185649250637697684271939529458570240858142486570986596776659846595403393314377860942465769707295002062182191645509540626540052967370104953875140376500360037331511877083341395086911150169654071047839460484321348147553823683218298006963937915051853330761908674720958827300591196078169508954480143712275105082329807729766044904575057240455935466311311140301175303645314351371663909109765971013"), e_float("6.32931269481254221834709614246731204104642412472254424905903811336795976711683778510790661998790576592916546935169036459266781983038086945423170564416979740001620759831415717116946526450014078723841090865388692129136226445876461211369459209110406866891099764423555498139372799840963110978116188668886487008110121692883914458265394400243469340965352485800103384559485360148026515656415443366562e-6")),
           ef_complex(e_float("18.295654086082286166348410463097800811482011655361310604390029110847476956095265750859275361905604102591391403400133929904434657769267620779282284505481475491818227973487731824642588830938629338342793040507445310974688685613835194884909900950919255302223232795190564481748363671708891193453967857081349049366801186436141601613673112350522320094824592071713725298575835431314314930527684336395293104531"), e_float("6.209819061189407063454986992579262428058837472819703040538189317727741259212336784046824293259912364113807280041397773927452854951072685306588844489710149011527236983322732963470820236479561962418199377190670906212528359219850786976771902952580742316798658748257270070936694158302853608913919840364616939510601185104066060957686479424154920199591492859969037504868331182535634021872015599028237e-6")),
           ef_complex(e_float("18.33303835206430237775715431224928197330551168562268696725224553468074794293275531882982126409234912818235642665404048618634264079013347713046746120743080857766562574922905303339003920823329913710536295089833727466799272079400871526490246212209301248096517935050901524051984779613255723471773438291986474731706050655386101763410339803146922161600143471183407955613750944307166822583998006038215698831"), e_float("6.094753758221782794346703996182388189288070009517510336260833212138690050056117132764182582980875107046466428367430763680852819748255062793901827667253590002152026527422043948587076645681701942493383426117502963337132336853405323609158514939806709677318963298653310353164774013801859485647061741778555245725383779861707267766360837114043573012641893778430212494277477377850503225564976729583836e-6")),
           ef_complex(e_float("18.36973662936069221414662495649494160828180946535900945828341013715943636453072773705642427825384207138483607034413419373965146512212859018894501441715275221950670964289289563501341386201614463524199345656702047246556899591575468426292412507824124314627023797670089597255808108075523398525110531533436812970807554637417523190844064472746106415138634024214327679600900618123205840934747381546750039194"), e_float("5.983875099191707368694237049291092000593593791787397283349865263653764725716209703135741954603977427006934736158476738290154236771753462579323610851456237361091672263458580012470512317305198062209983327893190458140763737091145877769390638374672858753737949862059002256027228645180266177553107322792197997117180647133325530507934796032081137135682559394515999603133244224632413927541722308994005e-6")),
           ef_complex(e_float("18.405773640328169467741376056980982972385044526244566740410658947564103371839487986673968966505625577772701754095710394972636431332252131354359331453396939479534091144228149832912595764854537422207221492123026876426228156013927765353818251247908706143176833230194660324327588175660862635453246164170543352877087566632348755255002168118596491210721772972450063395278911415631379774000801687222683488442"), e_float("5.876958670638506182636849117038951863422508576193979102348039971783567059390671486272274749338227855738816809805658482736528884955924369082569756129024166198014123059246615199922927720149570490675904638138630201138362418740823671273270466280275470202274266377449481439284884875767753441624362240281058703328095944237254091487616675865609489877786200825179599523335693394525008528149288465429514e-6")),
           ef_complex(e_float("18.441172794491068057246318164284363318320295920896894653410116897775537170685128378257223200555619778173686154186912898022364210223106944422387960600416143295979699311040143023332233478768221572862038040298014008951220641172502446062196364303238417732208676471158997834034504472735779731393329894047128879053035487848199210215266829418299444132962244798202634236711014544018349124032674359054554729159"), e_float("5.773795816305851694948710825147903904811465943655278965131978354263593802673356764666660801213695809253194041025568271323493898283331373391651214415217049829640403962852956292850311765881500767796152554832604298674692095911367267116304745113886420682190104089435529187423723292132346287337884163752376972176819412982199561018480655398792078527420038945380420495313646704035199401180906221415319e-6")),
           ef_complex(e_float("18.475956279880744206098143087597794080938076860094533215725894060360649635269621571543177221839308617761028876537554418223307672873404809456638870596552411073344770475129604947777795241930215159551436678245169382611630169136175391147392443292300075797897318257219716932298178152071029352526792963210542708576907810889775414292574627769623824507850576030783949166540564323149954685420287038556979943485"), e_float("5.674192278008802162672951972093701507515865644893820776132689598559489046417982637216629100238827981549660699389847031011759935262091884296698712722046049018871595929773604150650205136800200563785039311213047222439675856483097737878301433234311891583977239976735294565814985686046274395575526692480290715453271167679350335545273930965278785833038265646003712591024439191489969215330289847961221e-6")),
           ef_complex(e_float("18.510145146566999485200927485790597186166966129271731816379052703049469776313175650629029763796805126362763367857932275564950376934718998606311945549088635868296801478229813784449983615028769415109914899320283057434327483022901090303483428804154234741625211624307451793876165745421866196488935038388439925819742502493066555962398062339399433970939926565833701244372027086642016634492435487000033400083"), e_float("5.577966974793057541501645909923835941504115615591095195776485304338327737316683479856099233586621918320199736218203485495099703549423629520224075491523043411827598000257832771793469910750882813177200943356630752563480946604224465929881670510750875150792703985856022173219827146067224256241697804901787198792447758091288827309951356374762173422959719067511279326562195988324874900354950395562329e-6")),
           ef_complex(e_float("18.543759383169020750984795911488924154417006723071562365319989841887327449358912798980010523160144998538210392825055853566672838157354380784355470123015530414527230610238588781253481348637409388856728404524393094568843069826581234177849288919144506090046580329405226628707816872771287930571431110249171624762796727420840720582089932026354413597610822133556891487644048199655260406990320868552076447339"), e_float("5.484950904243701308357669246541466878631267140474320256887897755959902109716800504111428907202788174667680809195425261568704161283348956995968085970700033285702383335379049074600012722388584090627726003389634653824614126067748101751628582469206803044204248564002271256706232677558851741897688580609867781338756152933590849660832827141482117794755849133883775475195892940788845343239167607949136e-6")),
           ef_complex(e_float("18.576817987042200124727620155471181036348628236178675187874257124039245700473498516359369046330011870946269358389381701942587377648613982209651555029724289228013660984064985990917334453081708646791193350585102204601116521629585660872214103415581525588385031492646822461226513615417077844969678110920269223617595848777596797775606713322935193932045577398609048964071247872056762552987225074868322063648"), e_float("5.394986151918890910083529431059478952823405500424761021556724382730836111847715503257566186635018963399788682770839763353782849420956770863841048373254756683389967931158595021477486222655494674801373419855649979071898779243105723558540475772613886705088674046783154678631158176935714107179829938361610270710777199643730769631732098842886991603084699739096245962493260308560544616663744135084079e-6")),
           ef_complex(e_float("18.609339028757922477405380340844287716355861198745776284993715812773174617685179964995991502642177591835794276129321848093596987664961859728356776908122748609897590803758929628487224623351478141213910949704342500364624338085397260790538126262522845970107187097709681099157133180145208920962045427376481454559037718660455011478449456436142039339953098598344414397769649581074243893008295638647796627535"), e_float("5.307924996694514558241357914669853243424162865484117947886605783597900911516182411632372739023373680820843131669438728033973668937868101701075636002233089533892378980728961042082359823201140945100021255847318064810015919141013999478689520857093779542772474977539226878451094601221154262223271634715925996546890540297324736394928613365712422214094386506781243614823238328454759824470173569709279e-6")),
           ef_complex(e_float("18.641339711424281575216836120173144532872423783947630917929633064137618870013622352609139831355616825809920600791671979844161746156142643177974104709071124013246662080031168787713889673741408143679406049867343607205379117866856302338094227708080681865185458888857149717115523094908309540903110258428260250778296411876488229636081607192395238018389691336492101333892065116623480941133295720604434871893"), e_float("5.223629101357604615081895726010208811973970086390158572975345684335248265829154794752697982010751604804908294446473795354694517657511017080126416510053740880192300735720965240467999083688030231891992563901805510390019210627764989143264012576096341582223286387668008953484279057639969594113185185338463334076228998667560537921203935550871365396486174126246155969024381837924683596212914082160081e-6")),
           ef_complex(e_float("18.672836425335270289948892508990246284258689960968208542635865561885904748685945695884892021033732121899061197400674194846971918281152084857611097208043665159435926915234064923438952347816987468181288298872154560940607346870968009290958199928652739436868427344636608844071921725112367901572222565869727625197674523909145754936627734714219900756638356007737411851962936986237588893253845501043009806016"), e_float("5.141968779119742881986875819657535397025657434128429741348790770025192763270954866102491882946616342144956924178805434558922188133271022018057311039948072484006004294004909292435281245711426544261770235241082355052571534544431162739896736417006292191816398663828436506628154390800690078601181798849590964168184183204249300858422327722548915479440189387099781912982985836166362057691087709622215e-6")),
           ef_complex(e_float("18.703844798383069396518594489239331497741810998157494135410706181397140249858088122760952265544291656274060846261735048717723606482559992928754388879394967671178586997070085627865173841868885593689459386200779830201645008606420557410189217806186702866001912388533179428444722663915652566724342243889235670010103228636991861647404402330755143677633377597866775626966659690323350290906010787094542712638"), e_float("5.062822327870416127944844718822782671167149129141939095171461689754238852528205483211546090876743680433885261379289186978568758099231882266167457430349228404408226391141925612682761147983011209957937223829696069798988986947706543086387007115969910884074279314014582728365523594716722212669046585041948734330937014575044249466251019059274331542304204377137399848592608165550031162121149401849329e-6")),
           ef_complex(e_float("18.734379742621603422767704143907335902633844243756315845655601797837383163215625863986683511196756925966043004658797097650071413968420676889304278095796796636185938383505564288839139038843950142036911275713557660661554456024021520678760446329530387126420997535851576714449480316482217773485654391343322247441879947691112870354296067175682381165190650856056850462886515283960800473193148508841796141289"), e_float("4.986075424982282976268953692600096049435626935434312980332750072582316513227385780945478845447541506673464923354729562612724559365592683864089983097279568828554165397052438406331146708822637410275469527377252429445141427488928238847215054041259981313021860435057676056099928927347139841040953137172266273079936028020728356891693996283609811165699175382291145039022868763899350981825119992501422e-6")),
           ef_complex(e_float("18.764455497328665668040971489898577555768165160588941923591710593020491904507913010248702438369659682262701048241528507933860762789217803466199529115580274170401185436750229093574806196320293710847796112332874140650320690975151231704967792486010282143400658078782792766411652054750944293761865776963404810876424644963429642604795383888549257069197531958375891273237307561955167575686432493022332226052"), e_float("4.911620576338998087105797775530958921269497015658599895686636421410596971621214830952133972460423102944395944635422430624544704875785187654529617423023375124526284041403860660699839096034701813421542496005208877882449576829348472124943375146620365225738765143077197785615783969956809434959362561303863051589075649299791053987519191896392292316190137200462552949793901312304405343272362631026343e-6")),
           ef_complex(e_float("18.794085668877892426423608169532806081915821114098753347284130708390905504099965805612625418158871719907986405152056007497397527764201841738612340165774172285877121652221549565911064578328913389693517727042073618350250208461556356813444613839028498098760175648585421884132836399219516874918839394647228195117805492843874523476671823941666182210354092146329848457625876496990467671991401323647363611787"), e_float("4.839356614001221266404403567562978852600417890303448536139461537341674125102008242051860928891699978456536241272914359210139253656019936368523219490456186693873965794793628951265550942918953177184672190468186654935144448585389955365410032041096784085543279379029047846053359964732816848160698724262259188571616812827430088508804883961807915160020761013499024396813936784503982949726324579354419e-6")),
           ef_complex(e_float("18.823283267700052043384848349132498548474594598492490769734505386370012030104278546302723899471036082257812353436417788140009998904895091376812817922976048909791232794970302905520044543241663446358771385470110442843494218946653583072621034531965708294091250841853493331659106736741889483351094197680738171185661043040361878443873248152412079354632412607938070210050581506550753884769286513691520133534"), e_float("4.769188237574204077642884676977041189612103279960530988619988669356574649042420645537274772299774661963002794639041472862932474792544673795327560395842854258085551308616267796501380092413828612816869324385409936859376066909611034819416037247817302887257519095893860734688086986425330483501951154484086378293550333426885765209091919698415440815860343559930321962821793059649244171275845761684146e-6")),
           ef_complex(e_float("18.852060742584962721693080308433190331026027860208013950592685660274816814697871761546270525106918980916660778465555153924713157857996272882158245441461534416566212461846276096370751289296681146124935378343350826275155030159303261338326723292605551289993059041802566268273160987122659217897406182945569534302609981398041128827065006805111549946710771628144804196268653482689984056118223043428839336004"), e_float("4.701025594904789205560932492601683095897536899143258971240938453626988260793027436700624340096575334012265770120606900735606381336952771627672268524988531185171746360094797192007665462472303212060536658578926641602538750220985393214002418774095169793255229398676502371103377419668201020576146046533811715406491755190771898780938838271963398892426716070084682453419450779417127597253477060655043e-6")),
           ef_complex(e_float("18.880430012550396311957397367241138040233528838852141304416477322231238948538094148469034932421938056740429131700637600005937236356762214903838276577246213317450141140772898714460020480908011376967774029925932601932447158572300130674458162310883028326805046359287023170461955414411164843223034579766550093724754771056279388652323598345536186811827406755067935714159164051202378770147073553634748894948"), e_float("4.634783898228519058422025760341405914518726258137548840360603109449302879156394701653076658860561197319917513871514340932121709547731289580535997039933625879835464020304748664159759033275029543497165263504407195378644797761534926925346447375748921533028043208654483669100342183768574275440457045416612167685494391022231796945698265538143612157956366494542793056170439168924555484275606567418512e-6")),
           ef_complex(e_float("18.908402496482161433025373149528860689585990884760900867069532534243087000248120516795855024300129946434562834357524916390909141860495022960133257348691372937008576049337398685162680122479303735739795323552753726181633780481762502717898984126489455219150871378057549643690196716963094519734177678462579457288645595468415815917711519429525384852400951584729559395382386003098963583700179674618194856971"), e_float("4.570383072318776195621686708535585991378833008744039146147393856758060816769204568503412956641886580461382005967787645272456916202276372118148413885855895096129644088191815702329248180422179452027527035681591592029218075957257812427806104299935774595771157449885406851082547844192809201907363200115510259191973575242725136034669301623381936493085951243739845549904631439688433411342151720630307e-6")),
           ef_complex(e_float("18.935989140729841417808621806826763600440283340046879959153627214585829054984702536720127721871139623039461014304970625293971117729368204806614826875806051647263380409029203219961285845492418360347173941971801096368081006793589882190870555295938276205769008736851780162776535742232951945761413576816959734863251568835182652485964890671601057521878991853567382288007598441379631564863606348744365717875"), e_float("4.507747431567916013342576808044171354546244396097259918200585664053996298575154751504039194492767397158235087439085551064000024289214403771471769318129329604369338331491785165893736498537388175054533392758241692108364883942382652627773636795475445420398853547671522775284600734102776460678821339765483944954592146575917392175179507577572118476652974665629570291972471111762604570334747389842338e-6")),
           ef_complex(e_float("18.963200444825091206463227079410779519244977469637452333062801277120783095596494117953939344367700952369360855000352605405941834645484811085318459112499682002372524752482819448915062171561111427706247036646449855200548430963816574104873568034316268870782771549110515661621730988351027530780503535232116224896234242185746420482222489501968248172890917052453149986799435968585480150031226129569845757537"), e_float("4.44680538326239243283733808662442212468105141058052919831690869749754408597876622585702591390909030019480024365298496462808253314480543037529960725441035350319017000523430100293307209779417028613210570933408679919635400231942741863120023028541602006134295740601372224232557538569242282342967029531342450505485890073880406220035245285176554623286675156373277212574278246111278922774744081776496e-6")),
           ef_complex(e_float("18.99004648547371306389424899983580509312529299103147341815116809923152174049485399861964107138773561715295730653574114201103673271444746618388712094730192681559422185193388963666930975618806858776264040492457835174401749877301838954325412499306809079666102165594432562037266106390323999834559523623941443184876480530812938926607084790176489231814701335881774649988061128585353275135323360110486781668"), e_float("4.387489154606055743932224825241932747889486515357097679172490048947011904954241701703511600923117982643976390142371608638381241491226592298074184386691282869468057238507802894886078808607981060803393487902107235318151367474707180931899756238856062043812176417771412788167990813072920811922005066611731554115631578517502145239790779959181526284874629384564351418782844010975944129817436647700739e-6")),
           ef_complex(e_float("19.016536938958708891521015897494806815313750436500404656736622716054340926651500821149981545527825880709928948191489291685246497782452597826267624341422954252343442214731317599774508888957800113501824589373108142723932063039807287063770947863328295639688892297620594429368819380523243689500115590471858549736460508413556376429598649173860399050585343361836097986744795737247016005874099102837329618805"), e_float("4.329734541303365463874216226049492216805620334292943955753537164139404319828737745223850553570484778409013884416309998943961224911166871890976974485609827388952774663722207357390204777907483433530188042523389801234967291639499380113768924023241252764198050926977187643394653154346962487641557847488992951507783078891100019810737476659103437150919687306280973324583649257924704375867803417236503e-6")),
           ef_complex(e_float("19.042681102078951358866207751358410438860301779270758202542817008047915230388722614355328933102328761986739403536845810778744346213973413624145279838384295183971493685650480562378485857023764667660306181163933399224621165597757170027563935011119250187740756564707379217351177971309809810890402930630286115315026929434674264063142364233557644277401325680503093511560611333621540178817154445801762939935"), e_float("4.273480675741707369128734908443318486712908605338041936551693982112935170862570158046495617799518524826365945393153043402985421961904143912161716516393182729491671188624712189711732510334739132291950901195705748410612106051810304135895243044354421327052548972324272612655467945702244847311932041042941315854956630056383031634242827646947498121999663745002981568913185624686862538248298093868155e-6")),
           ef_complex(e_float("19.068487911736856763192671172976111696143073721484454518201056597133851236751675602017724712331968461560485902899492092598558795404954737934561643712728050651376497906189353773850971079523595954694942319530018949011614051139982467438537943061495547847924589725576462898629306523645640009715302024731675460685515430572204518665748905121884084719285331313705083387548831952234892143794722514585310592667"), e_float("4.218669813013195541341309882930695915176926156006615343105551944328356517356028141561368796180714840751301078229868296446912781149240545716637528154698105502410256748056171354657063567451078837257354494799278621919656410523969815600770897194644238047964243041663540578905439760050887063866658677180592693348819756433367240979799844252243164308612667648941442419840575183680201877105882665185652e-6")),
           ef_complex(e_float("19.093965963278330801742119541504692123737006762402827705815036281991397395846108877675071981397259139023207525484814482358506346705256533223694913693373049544422544216400060967886055823240555753333258121870583145903096416729066237341649347271202196287095392346776540741672131676038652442386839828908564305412353781119713891457906739841960474103633445317170332854422447208874975019720294932631377552815"), e_float("4.165247133194602058321917526302992885542745833427368567972667472596762265032218743897549847253399073155189118819418817114904891769887154019059917763551020273154704148106245567240298412732723993349854577689680365946560197680563051127798048680194023652616521383693710121713350819755481677784266669567175921065506827623900182145019240150067355717034042378892003795993821197299864432781518649096389e-6")),
           ef_complex(e_float("19.11912352767916437668312726867257881200786565756896799997383013012104034461810646062975829892512891994282142342113793006475838960093272001519671138714512498409157721779574306792666561587023058296681120745519732058968063997817280776190170698333486746366375559564887235728934315051616003586425320615863498328820942636798704960173497738958327228994163119206873581770068446565582080632686296523419844756"), e_float("4.113160558462256244074046172896225923435042924334781995369516478685008857005311331940742331803511431159470984789593250821482184909903032444775702028525501176216981196682458990137787117065718885402430654819967755331069870176340208496274069311160930429990791570446751171107769269997780999919649628052609703166336593064222874443822954894007071234362154565137815555741003604772746761826168007559215e-6")),
           ef_complex(e_float("19.143968567663866356569186287715250940028933430864389519480596803669014145774876990275624645518019837108624961061645558030182285396254518975793588498875744840257643733636127718705201118758492611151022763604167146044659627255397551229458291642285977646418449582069022866678394002686716653573253836458933798383020190779951203930105726044238258491876359779777328116045576319109806789798296092785403407634"), e_float("4.062360583759370003407926042518674165970089064471897447142026686356170374136998605759903968136076918713915902929703114067401977512126499682292494157305914003013859519151016883485669322879714183735024927917438085237381776448180789737568659470526441102750840535800625258744040283783724863196013313966042866515596893311797515714900557420790597100932655147692401650016353389470554315360642572930885e-6")),
           ef_complex(e_float("19.168508752835534063010143623686273673897580243066508298455016991857489704355576575280068814835323774955050806103288486844469398826779849210589501237613163580730855013478100511674274391794153040724071015065200417848803753509757235462882546411404513918936531126345706291102844581977628017161858234416869258938296628503622943662582408170280142566348026217391124522343174777532278065176223269990183098341"), e_float("4.01280011985842101875753732564330067417840795965143816974481394035329339700387810727962503896463662898467040400672977450190717290609683639508038845559809644678697648641567980807481347443123662501384726528185258485450665393183161641593504932278937550320686718359829171060192349159108405799581486216248723699807943618014734020499656649689883178999048788168566073064597714778380105621822485164376e-6")),
           ef_complex(e_float("19.192751473888692412412634608609629428573619207880605280700205318520449699847474926861926282008327237918157810045064907432285782652038807761441421947115163989678512070934691998729443030471850009698819923021260683749100611673638549683097154138681950797492656472421353067562031857072899541504715724702801632873804154196654449486187888465013028817756704943201402667862608501259965392379198039391348672696"), e_float("3.964434347772822363195827094700188842102136532763846746264140684592957073786689164155513530163448012381080717661554303240363253637860685103168689956345278638532832241713099910250974461408788604603864777807018286766312503358911790216354977611490074957066643405671265249078807414195297460796221899097790099477001039899649744815470397024461730214486546044645212504043530696940245021730654669738614e-6")),
           ef_complex(e_float("19.216703855971001902542282041702623172813222231424034550393915517312378792740824854201596619918237619221732022655599180764328370116673417302774148114637058570162914732086411587400295819153008660675523932863071959536135246030093174243978466712412965787928413704798230081773719490018634131854831000423271762008411586749843250544732004537565779856232842208111154031278790684761581948161966739855098958141"), e_float("3.917220583571742487732596957807557682177261334939729801217439758597276590377301802831346662046942638536764123666463796502286713557828636654846791026576715718093548484215409611907009929479355369399745471625274856019808795224752309915834379233525927045371149644383093249409810340610741961590787551882036676812564125691697950433778240086836194140015787953272694018741439648428492993508093741758398e-6")),
           ef_complex(e_float("19.240372771254275914212547865535132890945812366459095685872027011361008717086390321056051655453787397302132451465743974078353385325860149857511367193434701156431447922991551600112616258129773468909129526672948264208916024593031646562666278614837976811857836074346813080740090958496098478582679439548702852561373273792607739238136767226438826890162542094071398182558464827788690372487844721281142258821"), e_float("3.871118152741021324934667466685652502755543934689136600484176752266328533822408674562165295222976736351913816379059160152210332028053513179289919195588796101899205652113043409671408110156473075384969531691291635536475230000208761418548663885113517242260625720159482872676653268070997445378000753852332540274391717468526918150925830093199181659327917228939565402081567226317967228381612887391914e-6")),
           ef_complex(e_float("19.263764850770298984933926747217737522857299086858291602822177112769579005909162033795275141867759046152899197615416082068890768445264883207760744387973340719131963681336508440260585661449596253227814079387852047548211722438319776039109449590021048356182444308286266709619033594398651835088361522554433473315328770957594937050641075623576020230870928863492208556102761763426297397597321608772324533676"), e_float("3.826088273312884038316419376965704561878759593849053755746080612091837904440552982084379009797481672268498873763975639687108142686003699023050251001338375103892432455217132472408914905119641839742129388150903739838256558780891346054327292979525968949240755632831601165784135271688805281810299011960973715834938686503329498026063319676026347638381087756843091849494927002495010332584160371929758e-6")),
           ef_complex(e_float("19.286886495562446639763057439092162842693290121038730773153769678169662812349593251207248425242407403561002250419199245957796012292793482629548055134518347181882824671324274053209325995643657715601128539898716691130734827466812430841407784499996578664223348891000671317541996244788323871960400680005626123375529907651224544655497656526939984600597299806946258314667796543875965661872481442583155092446"), e_float("3.782093947058656087323971981750453207289902778316757224425217024165744835010872500907533471650819996627752944591205636201749087644851475443941119632062990068329361397699490770021482199141806173183928989178760661535228580756242180324952255581372241804494438737757188423234394005544287277549634470448137284705940337614260897694757616741023987876143799827731590336712146639283466762798934654279855e-6")),
           ef_complex(e_float("19.309743887200026947444357743865863347441808739235147730122998776167283122918449425755302005353227070002617840044657664836045265780389613834738481372084516959074079046347146406255502945124417682821401667828466302728096949060855105560781051056981854442694894788480012899391750003361728119621169140226730985463894702381022942383098306535491989232004824718082287120737681051067278592156314097839665865177"), e_float("3.739099858102870027978724009509026439044122766946738011991624247442277561719068926683018773528921484703906152066507259731372460093869666879162005558958118014266133351676065721064493390193310486109512619547796829783565169977143010086833384653762214149046262631151885213744847126039216155075905513643715935990170536465965573548029970877349609635915631993227894537145997737021479174995381389815494e-6")),
           ef_complex(e_float("19.332342997698552441081427314773530483213501126221449629372921672511508309428617431839180207079956284024002863119873245420182430908828102265454321128980743182680427572385896253449959816403669333362808793754323779682735026364343108900093960239884188842690328918186680173029742503346771420720293623618997385759707088259893121086823373788683654838356686055697145309007744041505925295807775256630463916688"), e_float("3.697072278374848080068852132813071813640023857818896935161828238411115906684846567647065821188042832344919944521200348340414718124493823300193227877614766982806712311965123051824724199806053447029697930490727763558367355377004248804799081297849258103687077096835244091425969312239035824812017923731421929641010586683068155873170418371068490742569195585433070029910160522489462289231528240332111e-6")),
           ef_complex(e_float("19.354689598885771303032075981733932965506182428913844224721336825078015745891705122824716571373758085075798762339225472641171804134433676022811447293780464123885689388810433224653980065969878326719983354607567832714630063842205307720919941740105851710555637421602655420070818570614859115661514893496956162365571107099140125762306317271741362957497197951252900614560520018591403614280633378207151400407"), e_float("3.655978979365766680716059544461134061822261147242829329461105189611531597185553811886316478350719664232117441446476663782232288471883840921952054411842524064709638068951405704413683178950834894328312955159292528424760509546342739620786601422694869135342080857634323831127588577638871276151368571909406962408498872456138717390001168412181789521102647860885770758509417333326344072747982989144931e-6")),
           ef_complex(e_float("19.376789271250205764330789763002898918977538575933307584731382137543465106925319305594356265170584694244400838620402569592113586109834746960399399381404927225523268762377997909321868801952107739067032160435874592085779784175339666683984195253946684476448354398712604284016310664389815241479373118398854187721788344938852432807173717819478349055188180117999255285715052851534467507827080401270419767587"), e_float("3.615789149705994457357374540460883922301402289017099120327350574601787945743155941677165782065298855452528430469958007288233128606049196248193258127137406928396399431901507150955707624381919298729677726120272328529955782920629162923215682951075796578877218690181410477301951376399924638297034774738215581684060638094530813610605851932681748552569730030930563732355249090512546411612401720873864e-6")),
           ef_complex(e_float("19.398647412306134117430726692548605328952335989521668405845004622193503805350791850618471553406032865165997501050335983958234513409476838214299299825202427702932916022038487687995511781408590044365262695129978910349165835075138347633468260849998586123238679772576759831012594150527089860795584680202519077876602802517236224255040957744347237558250686039273077775409233705510739367948110177405974536731"), e_float("3.576473318119701852645036091673955666260581699388752443637950322628760246518025968233313361878688900003956565532592759062229429615909694857481152022937489895435432334561312884728205490047416143655505839405318519950102146987112265872195097783211005193966636792008685719208459573440599901010053030231426981398654991734583298026533187037846662847557079937170196212709338130507860037865374057067152e-6")),
           ef_complex(e_float("19.420269244506384373052468213255457999022467100979243007758329753919958684151887732717001295022068091013695286404991195054635290677099098286887839372116613016755161383721365340227874331741665939662468727217460642858444698085375544871671640064279379162884733893421006234006417402008108632531457061757786564611875982715984066665186990182388548151939648231960979470826896370655148211356808772776456544548"), e_float("3.538003281351861492165646094638010463520914469876819226974971501058398916121792000195099515433839176573377634288957723826446876227906726546551700201216933736494316718462072906377847606119660876458826328895311747773813759895484757606675791851419497853837824208537817725146798748822012659664999315677245062718810334664003897385503614433485611590438476275378407785190039092503443824566589756711766e-6")),
           ef_complex(e_float("19.44165982273195899704430455384325040195662928396266312440179519287725345195404689010386095835826487068332600597631834925479712969588415754977262515435434034742995960679352837331758210171472936903108992294948734041098585848483618543901934689739738983413525687864880813999071879380781103062021172158346666217429713781315115880757556128113343029427519672110666640396375549111653062345597067752759486999"), e_float("3.50035203669722812641773207322637993464296810145151579988622661944511948218646310608116354162625096796636474963980076165195262912090806260043932620651311833206026804198547989472003660902210160649305733381810258165571460895719898268242803879188811822101098617360637776702681726382874398088749902526964105662121608378543717003071981314874933948533336353059649411735530649152780174921518279370847e-6")),
           ef_complex(e_float("19.462824041385360408572521860615210140649786270926475530127548350504665980925660990288382013217650086568506865071439224650696578495333198657358636729620208165699295797607516592576314161471475889538480904252982228725586487362213196688490213907458335678356887143072390199923980140438282483290858526519590712983680218290588464545279326295185669016181480833506732255579761328579091554354607566665432167929"), e_float("3.46349371879209005939164867214677131203438018779816353210970847535776746987146464181063559731833563570532270265423910183617320877083428336752804615009715729052969249751670457854157870616641264352824458904826740426908972604502698922613516372359504620511648871116099745588399355161890374700003564710770137037835474129505728343289558440849090991162462986122278093067940757195736131272014255528123e-6")),
           ef_complex(e_float("19.483766641112517265995418693767339299909635186331362616538359093566734019151858540026786499677166186225977699268824288846238040309496862860892055665418328454163011786375299826489828665559430912733902576796394570859421726964830791735011016428259646221368950354690145519689570223480359617727145201329133456663173411393400106748666743737636553522681327291320831877988222344504485353037631314081624254083"), e_float("3.427403540357860788344983744339833125419424027880958834898256748811769606710640109208616910464545556761526512920415529075608572019264100736103281722822007502583582997574743419009383112619057935315278920086315911234717502116293183680179641573099108802616820486825287391650283558422629006917558984634093460769475638451693348527523919930307473348934047968893353589813580530482556902353931962221261e-6")),
           ef_complex(e_float("19.504492215176405212997688700738192844593659581726279206823695925080484865618887810800236792197886221928353315816561362954093818799185184517216377844768147741072716634436889584791498424776309043230862825535031663725957049394578511881322627700032466437623959783424071620315896064865278932702753495550571274681765412974072011757214238207287338553226633618379528456688606691031709661654955399177412854216"), e_float("3.392057736611231900112286474638902113551170394300764937864142717312084303963822278231404872656888892912212846939757743342877939183618723039397734926467177574580566362242123593011133418400691586137035079387740584395132672199570064067510956708069165653481321554016359722442918882498267422055847275080732992290317320954291687534964119228457287048248102860297740484320356717430943123340975065362183e-6")),
           ef_complex(e_float("19.525005215503797629630043988347640051423967466864699821024284424309984103513817335400810279198621390279862518200679858609654782878383551503477415437022348209167203250781129503092546578190764663101879176803537160645825469103421189871801684524677124339048995524415218949336312391203894614846910413785809961036765738050074926180008892194287111861217284626439441066540857191682337151378634608584470831499"), e_float("3.357433513078903991629615390725823820242001902227121529695841058203426349845666463876958621145180597225112912933535584410878270335989990370289466503795558423805056647606066015195981449372086897545450949417878376902421780334048887105011674434912067212265737363229660142807990189581255830769213863212417538206299635385548617739516981137193909975740095377151407781395762930780717863104253251687352e-6")),
           ef_complex(e_float("19.545309958425058486114294358697813610830671986768433225603619435358994651823164494901467041173089036851201429640325513092792956219454267578123723412393596812194390781832822783514096058081715992545501814789589500628706308050019542018566532653410289711078832834271071823306027030719380142004622324583564318515191075298178788487489810398349794701752041912787277655005702349635466320291390056252453394572"), e_float("3.323508996576089623829910256606541208298878195262707760395697561543912506621715496030424976696527176814240717945806352286204719555066125597970381595206823015246562716117382914982372058884815326421448064706173595789191934394360689263812459704954892606247691875213571639085238299898722986478766077674290132172891616315917007236791920588977762388179897553972740138091511621856330327385507468510557e-6")),
           ef_complex(e_float("19.565410630125488448347361755813470192010043606423822123274552299095837876075651358066587511487092916994918732814958312485072956301671033420189978507388609393684787689249089988518463675733232238873188931034644177981546094288880854872132743822459178794917318375574510333121878639422692570559395689851808826197873914521535290929001898928145931194475694984071166914956923418523931033347528403267930721294"), e_float("3.290263189127252994865749053528510917763777352660201702061431770089016261743314642120601702611947668607731143231443870959031702889281802729632369169325398837319091916243083359813427754124679031652065943308287343392182659846735221570081447161111192523458744683316106174552910820628688008301924252215937574098592617651950432146256501170520492672112745246475279377310378094889609058449729912445028e-6")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02104_z_log(const bool b_write_output)
    {
      return TestCase_case_02104_z_log().execute(b_write_output);
    }
  }
}
