
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02103_z_exp : public TestCaseImag
    {
    public:
      TestCase_case_02103_z_exp() { }
      virtual ~TestCase_case_02103_z_exp() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02103_z_exp");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const INT32 k_plus_one = static_cast<INT32>(k + static_cast<INT32>(1));
          const e_float x = ef::sqrt((ef::pi() * (100 * k_plus_one)) * (100 * k_plus_one));
          const e_float y = (ef::one() + (31 * k)) / static_cast<INT32>(3);
          data[static_cast<std::size_t>(k)] = efz::exp(ef_complex(x, y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("8.9558066625208223242553082882273557624500648173688979747971238504918080248626555878382441877921952972605248709861674003193039903526515011089322382612880077834102067884777815948072692337488720093343953183778991810152538846181493559322574259403548414794734691742640832882091284988283283978650624354573056722839013424766874130736886801360896078955461704436459313144662623132670006457444959761702727533753e76"), e_float("3.1009798456282954005346581545032769608951852145512377907832997601925844908809865447334251490912198944589392485997337669759668273969577683032715637768703767100500566113050782231298899526474633027122787800075288106938279966021904025578377599454299354385646689836390637042428905280034604663021835058971814901127544633745230064107264852901089424948028876333257381081679258342760330922783686609341132465423e76")),
           ef_complex(e_float("-2.901352750639364816774077914866866360551298681607820139718901249194821669859268787023824006745266058861383584018185141315397297889938516983437626102446456114613612584149818613678388492145138847900745585001776881087104097627870308699255263090732848015670317910537258228470673913385942483442767384035344186933640013222602765895848854884631785186249747003220845739947632290555197971712623362952587373438e153"), e_float("-8.5007679222530112434912357537141144471975954794731787862488096543288004845828393759268646245966304059955397945371136798466647810595418475402636541556659353165961551433859891718192603906713119899169271928951578403445354459662166304324129105246947694286946773527035023050028931970650179235161521901799861449808310585253470275871986028489653439815646854136735389008786125949624668788592095117608260003898e153")),
           ef_complex(e_float("-4.6627701216088646560147666843710868933640378585411141075920871706188364022506146374767572215146385663222814025946100396906597314752297454960882779264045491496292016813467049960556342833645489592467822109594356818195645448747615545481341258544728261548000029735969969997856502790345581099237643569653772303925650906999125133259631975033618761681338039904676118488246622627022614323474293681057643182957e230"), e_float("7.1223744954654871085822250131185832752468972858828949225047594984752238800271315244569813154391925302099971241902423823682305699705648725118981254303448210583689902044831874308359734932383986937874069744535144152007905339921715711811393174768779499382336035488379950632782656839720924621499041197380012575310769161160707417242619197573660755944876853476184523490308646023809478916119724957051455916209e230")),
           ef_complex(e_float("8.0405871530934573342824030986321483574352535634045105036637529909529812446345420636360018092009965527161392079096208518030088688600941751388383749346053252297074554459985120422794315155984846843616927139112187493440769914160422281534210527854430537129416771409207842390657019637421909420330893137978114301357894028597689058263919148763489184796311799607130892816101948955224452864165973689480524779942e307"), e_float("-6.656120535291630613011042932836646384402764537560259023782185642008813059920274196190670037284145895235445029391894324648734322073679467554966843317668223265392324423209771379489779599820604892821029159511258664266306098168658289156453665445401623738154739892610141167263613156998168707200642754741758534133805239689800319898860256989650912175727418048374319272194116662267812723387023374474339107939e306")),
           ef_complex(e_float("-5.1831880932240439244981159182129111342457545248589313879028196634947288089818548729897149884332795555569226008953232386706482142583997732909572156061848874018310853338219798015064317903806807477326792103275683543426016770261195706082130029018086893574541155492843067733383255629409876778580610562275938837949416656157598783286327327284703397005912271009360457016959972056787610690387551366925446868833e384"), e_float("-5.6217189661139135800397225299665214079217410105210135114600702223362107388066326050635946749055601604545389462281096137448025650477291894901526787213773283678959787699766517261220300192176095817756544643024117706589558799773370818383270760727141359654256523104564181375483216806011112606765063338791901423858408118465248002546086916743023619422336377929614773794332295262874699274227131514391547851905e384")),
           ef_complex(e_float("-1.1811883804231914260796621791706605892068701242177115069835865541502638410157759671801205073869739998854267250364982750796984391706780384144402671990158315021824063864050590237381574613914279889442337987852523901984706799648362750420753786484386582587379218334327185031110358878793458581587117380016063941042239097675614609389515633571354182354200039809693698565143407395835276971716729822956657525562e461"), e_float("7.1500550020915054516320523735781331787248343464991114253743584896406828325810411790271947944037390161576008437770207622866740964009087323979740747289900632503066108948078494077547010516724733462492100763121699673483251676629487001193920009248960805234306354966708031098440165033137597404852456768315526657619582898268737705286480213096304821570153890074194156003876657551241582123195563558802711190672e461")),
           ef_complex(e_float("6.0323618143342493731190719558333681067527705031342418185338095519070036362611996783048070998065779232725808375294459062079553676025669812280044436267263028714549625938103030052761251298092297218723076585516993745957998629059475951303504114331916301975070620080240616138009649681849339014675444741153253609241729596729122747405144287698673734234141285149430738231193971570327927707033012399891282497017e538"), e_float("-3.2839091964733838132804877813206164128026916205125390555740541135142963039725948284506030026020050119674321512592840465917330299349775892479451720672934841099426285501003382331821299931815677337230226222623727766071300137525876676469153783813258763712725922096547665884498116037977491800906482930746840856353793264321943785295690490414265391413505009547883230148705859749359180356613282931018488705687e538")),
           ef_complex(e_float("-5.969821264544711096483894717382997579150242058245949768600357547960709708357037443163397179558510595737556208463991870858558686334135083631541815248678437997822068493194444670627045471334907674473127517053373360703982823605318607012562764176925391273671557903427373935765241093728057306750688205017369144280812515741874661193893307946180014356976883864181290948286388718189406307758295837395882481177e615"), e_float("-2.5949235260490638129015392967787016787156846811868892169748776776494696144306379365745550259399749151041045158983875161588968437342910134883125096766530254579785202293801837570639404972022997505845847666680449555185683895525371039224232670000860739827979581534425456030085129782291920492789905535163422514926725733787237280061030857347781258158982772313745796775323039907607002471965260961460416269327e615")),
           ef_complex(e_float("1.5394818208696366352298356888019744585025251217150634596851377140610711450939154351878629777031832704201574947108483681418416239052404608031172430157234749718708417574895999790020568341610860138662940321881327015616919166119027985175907129351984764441791089444164627951604368660646686524286998175648688810937816228399825387285253962564803572774909041497206406011760160961268371170733162168591622955228e692"), e_float("5.9741074739703327008968430631192338792650891368837561327495808587010805341382553470178255662065975448406576865235673692427933445320957905823187964458769717696170108110141326624636421277694294037827932649830317979034189227956617056683040260561190794550106402661471545143693173888102065610712834357016270647769826949425616632291639418849848264489480390790998880107930767298647677202001014975019167396868e692")),
           ef_complex(e_float("3.5679598956179245880409121341041952162516384655952600547770243629754020616097426850620686633366721644734500126012986611545734669501860763403829890992786105248043868515045855871405804969043545094759332036387796530308810202779595775340527597387783721484228280110187837315633479469875768193539101322246353489247935756125397206558752601885905913845453449599124541112755162108859121715703734229200098832645e769"), e_float("-4.6320721428575218580825357134224886437744753330777740619560051220084289653895241141683078828998048484227980840274898666630662893341380265924859931789179982483888597767873590695086480818006511415046826991616600063659272161776306486405418396254892117496887486052444535527935351761815143041647966295552370441380217159197014833638178134803598315261402120117580683340169935695847074166379070816623487261907e769")),
           ef_complex(e_float("-5.5413046622932391766149302247453199101738465422488971633343220984898517415836684189736453944492692193271970135951463999230896835757183266511334331897707424537592692565928778030499487423338752614271296016039542574297996435891847505445215654089614989311844413598615165605177359828586672996952181718255445986130620755097618831462552158528354278640425925801422457738064740090291149490445680402263229147709e846"), e_float("3.26436591989521260788557215910377932508337568978561007344161095986371929527348122721717071343417875046247006650977825711892695252428606387457095260039628155004231353634974985954036749143932314312165055590394625526389489183371130278464994010269560488295093357427154641906921308688204415861425013020283671397467653441591262634670142314469838292608956210028566523535008892808350450683837911207530063819e844")),
           ef_complex(e_float("3.2536288658523176758754649399803117169676708693527623749746104226740467151457283324350750858674759067072430377432059526581549760914025716318608567506510054975247813278089486595578443037733677066951725894040636326207279476683991837915121906208768854389363046078130371084668041494683294219214543601652140255614405784225750890411693078048326438987618530521674743318068187139554204899987385811205884794719e923"), e_float("4.1225986673645748971970333455823032099380764823954651598366394539999920733249737762300387048411030268112386820566355582667830805305021904752189743774536859939505407100252622110492503263507686513587764109470451618521738968740861617607710055738551776943829520901864105436726398154523606625580331481560584176606810763479671414839388463893791199684047677026230506470281759445355332417830869695731979928432e923")),
           ef_complex(e_float("1.1851950763875110417440203679730396260366398337282493668378750182115370581229350772866179602202970662620143335472686228984953375515197131957757528936803206906571110481229543520701659339972833727030832604471874860383556122544977905374768575688741483119734362212432003043115496003533391496055713124832503594334416114173508400788508887752683550143911931925816376907328977740228711664717899775781522167898e1000"), e_float("-4.8342627921272542682919847971338438206663156112048610192721198240760807601310552433975841628829137278544888722374034449855098701447757244668671092828495663973436776004246807381755353209286368356208133427177874420684104800597909762097092316274848263422660698029640331756091412287823300405868000591210861934669431257077614128572073146438001788001562086099805771780881679883982865193441305908246559255247e1000")),
           ef_complex(e_float("-4.3038523875848271196897530297952020811965219872985793768124048282242303162672092570527969326414560853603873305797539288927648342046222547908325055467592232375937993153834196885281776571584311649982698874597404394496202268556143048353709698944462237054978809563477471927018750806125880505040894344975827013751578443676601179419989633751620753649081870611464195674403229502986235331432476481812845964734e1077"), e_float("1.9313718491859343457790018137308325079578879663554848096286571921577999969439221977878776732569569253141081244700426278222499430345230591418579730820066924622132059651617864701874703934411719594608315381929971973120171081123073540725696639327962271910139601169860700763320357670124188263479115632266606974502103103154658107655967708535035829993390084751937176999970993896965881670732149443867849051756e1077")),
           ef_complex(e_float("3.9516225243401065773411218836366754179233789381101348480895987682222181844409378698037833202994582503514969434193751874595355878401645466411555085108494282180661905580226560766570661837519541682705031106830677892226402318452625739544019383884714267774966657269705105150280722360122475722614639440871748663256288378535270412442837946564071106942621187103050792526587644504327137670876299085026056081004e1154"), e_float("2.0912194949694251134516450567901855046831050267342488970869085812613908486715130218164271559639197955381113038674461340111783702290210545787562574053198994277387681745916737506061534856805582707094148623077035720954266699732284649038503876279252557846907849635692414567089816231884974259485777698823367517401155640488920760210730374070868306038996270989180055182592280586944219542431969424770019340236e1154")),
           ef_complex(e_float("-7.39836627086034191549350547504215435809774501513991197247588896822540353314614846127404409283731415882662858555133519966034656538693372041606459759150186434268860910182133901197372010461546213442797750666612289469302136808386593233937943460639363040026752883716683813471516515081642994058832565004341458356134186815312635378052106269046795753014967469495999235642994976480353727994417718251356418966e1230"), e_float("-4.1721504681873506331591397193137820824524230428219771621945442694653696811119351568281169171662304564427097969657647351789962303213035504653398565077805678777821053101455267318751418948902800784609250458403670647292527251348966299547651760713158765410817068386338097365055973802216228135895585543584308700524053954119973478238013381260143257884429471037479033562368042848306225853923095508158623022505e1231")),
           ef_complex(e_float("-2.6871590349114018885434522282403988195263220199234916888547953782557241192587034361518357869302518869359446009871815964111457649057591393669263166754468482673775981919895276935884109278684013544839741600968080838274661142558245282060523929637711963631462024551488454310698218704064673960747304675319495032267710308176951000666225507530833096703815570239651986695254023793360843316201433772745982486015e1308"), e_float("2.9843080272495335725299752265084480510105663243286633137367250866826193037392016341332926904126299656113473278885762349983605898446517482516961897581405138206807867585160134936369570644059597737438800376139847763758612883188708278571663269417351866581730419700589138989743676434031058642158781298153157668694839450265153396829530753265804164515753626670349258300135880983090653814970502815986454715423e1308")),
           ef_complex(e_float("3.7964583084235867567999864904037247889779269648439627165484035173304223786248450657342289749454124590564344784523969205874323613414163137081262480678610345729450588746169775459204047365753346119806943942790169058475796181657759128037073176059420035745372455122968129454257248291559510771373673920397658567823357087359289794023364714297907850514133736579014530212731199720818570289996810929406009720019e1385"), e_float("2.692827585542346304843850886440218898350635991942493827363351788870053067315218940850011488015445405995433919630374507098142217776650548898606061461109585602010878211785024709683937924515519886359057382327517440092157559158402693666964168304913982585835541174658831272841799861889170438982813390743818138163817820751752759475329423614268585097806847142656745014822323397481735544923440347876950767724e1384")),
           ef_complex(e_float("-2.0111459293004276171791319557213343342011136035109365570529858201883529813272382519331540813045565525401102091942279759651983148227921277537090706499626288937716414004612832628877229086592106288461351548481219177323371778832633354108258293778696441333681484001487018119198309554045043453091811786636177867509257046392096492072147684595957034551771931272779602418540842352649692845730082274601893893173e1462"), e_float("-2.9944340354621712016403110445536971678195540841934708617365159921339302367241220203293446987538904689847930782471602251694407674925171158632750346744246683864251024921926277551241482043591923426041554226907337800337014674949341449430301842876759967730992917369191755138452336218347759207431912642873344525084610693580693963189721232906252693110642684860430383999072512503655747221871756411107795359754e1462")),
           ef_complex(e_float("-1.0660593445576578409473981502783236224663709828471586177918783020140641677611082564793710309058894613481171200500389274843053266772343222805802379791558848052013363217079210675645474837865039598854816570364349094262534017739340486114563074169067160740080357468816938269543296722310181553610136771936081638630820049873100754630259873131761842304860349459188588463373817862653804142399072816880289782745e1539"), e_float("3.2481744934958252033630731861811459512761367709047915313395948385778927013486916100433789919446143839118741756942413122037092122595439668933182738363030506275328694836833806355781498732472077228949600043623523750401518389587956182757128878931972241443478037058711256082126407241852261506444419526035336158130061628692519174626363295315157148898870457183432174455971922337624798525667294532174589837201e1539")),
           ef_complex(e_float("3.0489683255758916005715272100283073904806705521927742670226927451905909785795670213158079214349128554399156161684765290617473777291116909012611195884111060628759524771368127144760616826458582574866427303984239253743501604540247594954419440420744352838904734016751822611849427764619567520271871326931755734941987035452224778061307365365769013245528650085529928835677601324906171423356777429686006450026e1616"), e_float("-1.0961118991634995059530017204844646173991799103332359157854048103593060312358250436276968793270479210507234469468254112649227210053899635064002341598171938373756350173231938382541566951365450609413112023899220524100097798902077303439974522716778611186320740740214292265347757822496220206756094804574231023810353683254927727103930655822436828994083939339105096054881610336762579360542600604578101319947e1616")),
           ef_complex(e_float("-2.5960498662425236874386783628388719404663260619437917642725189852436664813430482570682232386514159012313951689324503297336410142303949144168540267242505271033036960512843696425637108803660102230432338074308592306510770810163538856610530459147526621320587361204682177108703144074126097592648695729264562674026931336176257214609446533824318933785433449976951580743847127546901257486786212653052923523414e1693"), e_float("-1.6400607007717669658216576104116900805165405624138914714394278893765623172653023933191346998536908495201985203757573426774348946611088400572066397894326821276669305168890843123556127345535924558812511340027765911405626413081640487337176222541647384485300704664011110648946992868986840511083120693169670349457806670537727566653035138269544227407344136673947189733355598314735380695582269816158521590469e1693")),
           ef_complex(e_float("2.870682238071902047450982276604445022990429814368960302320194910448413855430963181458288964798484430716467369419930954371059510197789935991229899747546457198623703922011119991564416029014730121313913148714915516417310108277735876334916156600528756863361656856471953479253796689030929218570577704803079230676092180116759026449532711690212777331393011266796339937293609557970860612794641980265801751599e1769"), e_float("2.8960673509310076252799294842019527799154961732505215224494366922174215955846511179467575323232480219826544483248368047412895143211783029747795453983966405196365950785683208750757136233844833454481988849248940692821406414747562536204400869829753070337703054348979111791445623577109899630324819812541697951025110858389164227949655988552242584980681393124698742098924689171351882014747597618890688380978e1770")),
           ef_complex(e_float("1.9972564796331817740961850381368598198412527705375015154726763463406649342544119056024687426707171237541338654537376009813077497114170994526531727077666287228788961211189209427400377392680038890635387008058351756658003605794648436347098204531527789626564296037587962611990097405264102772025638515074185476919622746486617075602945841271352298836113527891087982326698375566776480866265747635840321455272e1847"), e_float("-1.9022591771980713608803004406884459104458848238575033754810127142718960087210013312052655770989450620071530953535677230334524803083149989746161639009653170290588887982445448289552632972160142882672063313201999164458461594572561067930005336982735212365359997088773868256686485528624828324557427820431865599279741005865226408355233914122919300333698674684844838699314076467997464264294147242476440980559e1847")),
           ef_complex(e_float("-2.5856799438774933641761606490783760964260091801334343190803130469985787182566748899463967660922231814596978612013904034756958222666393193424189774006046026712051424994774428676409178914286840174186859169285283249308897414984674588874366054762974747810998098150882077839504567975361592296098977720026946679266168663970717044152911170107302168512583615505419739737437787992053180035261952325098085465163e1924"), e_float("-3.842141366869550764914621632940946114868102155940648316243808963080172538335410320784014899096197277618683632830686309887243930135880869602748461504072767415961645017797400688676744797565412185109786548640801644925332442551649714528447898841583351768816683769067347429851551153683414575162922521355037308188534786691669543508610902344397067621464673282146202018095039133565144871118271673435525095892e1923")),
           ef_complex(e_float("1.2196563347284594087288035951438288477084193318658780261953212593283420282772359369415059644491491115945418436595372339038000296779702808234501310424185635860416175012353530367124791669652128683451428923427761614712733703147500758901740802565856281338055781849226256721855670312877834364952402464684081516405153069351295532326326255712275431543465807925545428634642997111229907722572323250176412340594e2001"), e_float("2.1564641669493225006739066318729329242964624151736052731234440933290104048628914814233071774615802114404365560523586048960017830447111131192924028822487816155877294919046082249803097566632152866912671252041134748768362630863217274069161885990908521555803307864103570897412306351071448114313703017259642434334092282807622190045355166860307911674352047606536712760759009696729973498273195165105695199982e2001")),
           ef_complex(e_float("9.009985911536642476632099588267046901603642544646703764658966013163087013110083802712968790023023753118973907925746271918672916875407638723582374450581678976621733790602859214301211727332176894126641724063149311321746736580636396009758829655019444842634614683676132214125003599037549061234388328521468595552498216227660022262182863528145532695559792410463220098290292055475334841197059767018818161429e2077"), e_float("-2.1682756107541044425488459254044447593072621256210639250171227182107187446942839121979188610261638976303926547159153381279367300085006251628946966805352605903483187331832749636730293054489150039084917213789406105586088830073358166076501972785987916692664428162204932367710496888730097115770543816441606882405380203952852001553063134954207284430721481331767985827652751312657562215399287285662169802644e2078")),
           ef_complex(e_float("-2.145651779586595984490257322589806622381635900319578418874564237885551287823740790607209655794257423182036361714517551572854648531320726475102383389524545956990568800193125801638139215100275706471767059413127956401179107384642502000269394902178499610328055828531925927855298425870098259689407782593099747606016395757919995548135846521481136371874738724993926039234697656132469592505717163967613191625e2155"), e_float("5.901618479644882615843926634411152176239016105661547256527717598678261231957758675923535421898431175140217133669446435976891191654698560011083613797136435457537220698630791657152648235245847146742047289897349097095227049672482537562988762629696439006794834154225197651503262800259398133535324377378545303910126595712786473932943988448089495310792732355976432318901602198907509840119439173271112329239e2154")),
           ef_complex(e_float("1.69148466539070674829731349932831666873070250534169858238608408101245440865204246043465772706603744068108983206803217958616741012664843759475283214099534281112929365307707572683425785084597540367270406566250195486883191296045520753668553536069927410307678353340711349168976077159483695491680843111923449532864603571583140534653316029907696105245336006102225802348295893399613039188265353098202711463e2232"), e_float("1.2597592475917867796475994220894470552861755571113089062069956173861193733649412899340016416569241455106414842435726222990660376652794953650096481299420416722896903694981795427716008515326057390616391108675733066754348207527679203700466591670155277273717135628583712397023180204120031549300662814528611060214331722866403215233912597578478103433424571892457096691066422910601423887642229613879589880036e2232")),
           ef_complex(e_float("-4.41678706463248269713559488280378905568381544493501902118847097912323150985542801777978000835311649449204993757738175585935153914439234902724836250502411768487128431694048671581438875192084892644289181735968462895086921716639984291937929405677772073121866578819581919203672149466060639417234807915382503366876947913755823681818628203237414117350253833099145570115666943202204059333973636158260784968e2307"), e_float("-1.9983639152102803547172232407500708364438213458402023518957405720014249642603519936512256356769304287278562523254874941569853106319985995788983974850721475122424442203521311372635278714315625823079230061308687916583389143567698074472897289919813774344904073749785727972913939315451691674223817719718061449576132521390206943217116715406515684797119264379946357452759547369857304903662782036584697714641e2309")),
           ef_complex(e_float("-1.4678564244352937048745998861305908475714256183479304458722682003953414460866235797049169667080827131217138650868164507338083707263746498378202127235211911880574154107229563041124832222910957699548979263960064353002883627966090313968585919559912529973137636647392346310049001871212619587442068579567726065771692477417673358967616634229789597203428786874743844299250307090030860125686077304996333992135e2386"), e_float("1.1975708110685465901161335475817332967786235800387324990800516462718738644388389397400888411156557744458772954641801514892596397297434245768683435048379830490980002638236296079841552295105401158299967192196999312122267615394753617793540787811433610169985875256838521372267156182802570015091836482022764180909307664922982072532225867761930916424673629046071053634725276049100554679190792606835627524503e2386")),
           ef_complex(e_float("1.750478126184443612664014334542235565563821467261700670262878385785635793705297205725187376352985216916259126667826276452948410136099109237335119904008561259929570212048051318404961891405575965362057194399483299756875402779909762215374988255671080404515886684620797006068035893739982842673381813439033947559502930091723980291327647251263446588330684574195375619999114970204535013457878033051944127619e2463"), e_float("3.991973236742421887210330411999045929957544344754018748543881173333250597373886476151251441555531980777219565115034204074231680975666433078991131807962231818683211325071839059889380696325818291745734651270524084168365321840871213260732726938932500623439544197635339823202192127329764625995925574008724800782821120410652956860049995860896636232307163687682071051957512570238272766072703715801379444137e2462")),
           ef_complex(e_float("-7.217385678806985546398799551383676804307005227633298013208843072224870367421266759391694235464825714209216823861774448372743095412157288956925018584871236197521871955365918182365290249442515199771430251874546915785579695698699271553520079670232685091482265919527342986566926535387969131771360972655592561361003381736266559737142258993439314327735422727671360029874844484709865943152892674552500687366e2539"), e_float("-1.5409582100189348109346756424451457832994385454577246882133969706585463527036344683908778201044232115497581680442748719505656163716443167123449408596038490308781236834858815825100737829895776925845867637450812052168229116596723365485742753050983418482381205876746775302848736645882880429720587222608968886059942430123462483121731172207297804501562153751401913099198599777909299319507427666555950466714e2540")),
           ef_complex(e_float("-7.311285490304276935749089616712162205260657635268862627758323499475943657294519462699510071635358832814895565221558352747839922237511694363495461612800752427376380117876798102191706412629181553758291791948515103594367321087730192342343518839653175816396946253163703365547000138998924621896422286682306215418970457886411384032592162903923343510633755372036567653434017395926869531431477703922253134774e2616"), e_float("1.4374372725499535969048368439551248855384389489498026542756238981220462270886033612654885764108967194717521936881026130820914165039172061502364073108567765153135224504448441416870670888828151561681011305926985031745091139598097860010192861264472084549072478389581179009019564343782202841951897216188526564963136127006668194581898581869849377910435768961425339519487025849635578161013500826283670622856e2617")),
           ef_complex(e_float("1.5004236448893888731287935266175268110123054760191187376817649247784234460761210588779906996729784098293608152929376446097942854480671231679567024873587002936569698456886390103197379183071759774965603649949817890743388847969252228667174754976845048284438225724200489560375173747555985697158959263673739013729607243972526656313923458649876846702571901733054223851049746952844063097181848039411199804779e2694"), e_float("-2.9122356577482491959455682186519967872556787130534065181718954265809278167842715102347661122001595758783844526507178255749277599044570449710943771062452021881202546904346557824765140435152797597643033722476488263288841541097917707145023717113793214776431453602727346321535379816617097141386643528409191590835551910886441365194532343635401849200688210009243935658328647611953230173037984398857512897e2693")),
           ef_complex(e_float("-1.0920446314674038965892277784815996546183011788092259709451583704231153110088737161125847048767307163128820781466466957744581301514832469708565227545893328259410148749691963607710126593330369103419036593595910935081816976069072689910980904432624190956828486573633303734109066897007319360006637429871903097772385040717402627325470528942188118759063194025885739767305505919734879648323875221263933315782e2771"), e_float("-9.517180110214390307664461350582548742749256292007038463337896663571269068437206952669814415127101722055289936696692697888746944458654342303452921341369019114109458328874151080685269660179767816076401828780022670532556732736192058999222513100343021572177320223012709161642805915304646389573316248539163646232495138493418463179488615051247259636198591838818676074538861591987545176766461951506622975031e2770")),
           ef_complex(e_float("-7.492679121490271112058153255730961076488504980759138051315317883885767628957118519533169953457356285395225703597240192250488635259545125978346057815642953215582741937033069838119031058790341663842999800327450184660037917774498388452274406536448155081643659455610626931746650899778085429152394544496754920540492129993931772798946241101781983578509601682436852382234917095489217934819815402988178339033e2846"), e_float("1.3708239329003340511983748018424648237446931032355945832216951760012442686979423367244613504445556917199870590263906242483338177903472760218002569743489052727581315809320032884616981694019563919379383633455462125939210735662145911543861864103256610528625487821725638731411944869572780428033206574917525099614625912823471592072041489916520016952029405382903377589214802582665332203663089049264068600552e2848")),
           ef_complex(e_float("1.06823045655227141458793496130606721912518026299556738590606309716131175557987842423762928246012376047095854751107166658014973201070312382996445075103399082466587737988222528666669434470772857059729970495146584101698136259898782923485121309876119169544865287825402914362865511321076641677201106946983585236812412656035553534023848415626844845775988048016245190435727271227801462159737512596305769975309e2925"), e_float("-7.4285543357944287509874236370823968968544008101445840276870631180577733516464829830869488402200446745286508254483576091173117406792769771349185187304461526472998775386104647211529896744996981857176466961960208607271750665296823164047343087051730840175597072076564869125474489222157485586773471934958359930678420903499384121165254776585048502882911096839043490586909718559471716946793201045884307236996e2924")),
           ef_complex(e_float("-1.1777350932163415021120082291230566342265801583218808644892361084526388666102224646948840813517414940266752841211024294825180753389015192638501365652243249369892231276784373834621922306058653839709718603840065756150750409685580384575416115508953789788595947403395515405919595760570080035213666875365168479414878394510308807478857538925358085608455287152806160075224397276274069136746127591792189552486e3002"), e_float("-3.6550149851222025090005346506998801011916865252548325926148814506513140068698875277511242763782745247494944063419329268067105402142071989427890379541370173831826550357919251171640716434384481877216111753644414964419780200595455976718621730849996194964984896100189541685135041340225583704285262520363373051285421033817809805144542729906925302346334574693726609500840029695321799361456073096945512130707e3001")),
           ef_complex(e_float("4.1315347518562648143764486905928057780017715366481994756661732536541381444445885610491703917999180682878906353799070222952289029251142877488287501532012097857774311189420292067849936281575252439480811708496356284130612248067519901147486231036642265351663483559024143851147063748784526623071159353309504492913116206728875899923726396730263729098752825738097076874368920508727854612014526331570327664042e3078"), e_float("1.09324835256532583141516932201912470341923177103772912646950429225607115146793631520143172025498780161498047560171839828894037088803968117162065457879834127629988707135341739892456731755175244135233045165577553591055977050987145578642213840128171641424800278251643199137779917821043998268199519545298467643876902222510670089380501022604420114955438776209525430085772682757668745103789817598348606095206e3079")),
           ef_complex(e_float("5.7633602635087424137590312464706125545504081117545209417843380169737282026993373414298760567496136031360905419617285267524790542716392799426803282470221321799396776228617297900842228351525939351646987012024736611341857135965819505239861349576121895678728934853862673033366127954407076497583201080599165539499608165748653805452044232484137962966433302936631328579442407892726195139239060294750884949079e3155"), e_float("-9.458921619140697671895859622058124198180364538197134361364797593747250185054363139358186247193381710989570541664715408999040536490966215426757468641337182766202612709741078384047458800327705259852771076003132457848394073379358919903833464863067320768643201955258696970414533600390713713195829526146991995419550815500070499096645314200034728318116279877412329552040277700644172476380310057849348033157e3155")),
           ef_complex(e_float("-1.04283198573914026371906807241306922871019676631130846258087995295844392881820831129667353718902138545546946585424043454568822992465409873109922157501908197741250100646057712351711440222341521544691077196112016849792902127810504962604158668795722327080815341650506549069977029980385194980169960248075572173122555319815508311473177741838030774191258173648975641369685216523012633434701841055698157346309e3233"), e_float("1.2046586436528305697767477919022086179108301675695508828301955725632949974107185341882373738714144041748709690109955961606837972465947812758802781658381242867261038583157028053699775922148379963343727033656027388950460354845029175095512868835881248768186214959826061383184177793187926678010668757028955454065053320570082843632128320030283294710739227854215261617646075677847014310526173140272504078113e3232")),
           ef_complex(e_float("6.9775429512465883258966626549058074620459373908079988755039070892722411863373840328448477516484945808860167127989394891746502067292546677650544873742791605235602104387519121038091599218773734026999019543461949584349306148824906789038645866026597859198447334915485575397374312244960888962976213700436111601051204596521548726410778427704242218819829202205703985608620542406707520955165965576101085155211e3309"), e_float("7.092199461981650800936955726681200843163252219681077997633280313132585704777715316353444926813014869343537772720296975260962808877472726093432864043588440639127651619102979114025505107533280236243974353518023043363810310080938008698512555251740462620450138612775604554750422783612116151051681878686332750226795894675909611226861476730790904026517214913563286430450972572380381208260196730734374834243e3309")),
           ef_complex(e_float("1.2345672429584976757933828621008958251683185382190760015166366834204805795675731544503300269329627715305337717277265162936723435667814944057716402854484456491743405588946276944975840505943430431478469609005086981226377424329157872392700652553877130671621653050486533636960535668722378175299164695894108626478541682029480891058850388465417279550799142525298105583500166079325554616627086949518581484318e3386"), e_float("-9.3481041972522186199497244616902207618369400577650461633879230264542652610851217608947036008887174789269113834013879499569693629995692608656230110970011061990285843581970338653717728523757628194949458621561684417825348708304832506085864699325399743632076083001255526784206374123898249049310075188152229010210789119735850593203838250132361136554524940222905394576071005695983943781196581186784645467908e3386")),
           ef_complex(e_float("-7.7063108319062908675700120152741675341125838565085622553822895712066531461761707610851389646263422427889732266417214357052594321344200680105943306086378868201871761701497266725833415006760189290597309286892865449885850594085625300875554398533638586050853865437841339332887614293835344129234291760893570435024745444422390098430740743136138892149234898196372202241825255216479890600239747272579142945424e3463"), e_float("4.5249405564587119436556730240288759726859453893111846550984111681094998747253358980127475086922371661409195187410325324279652571932458737697059759364761272015170204012849099667891723554121329012647743788579916099704125131251198098667727330933264957603330356577912443884537150993109886399224144263610382677456640904688698820615520227660887074506571235652451699721670050793829799675236046370071849792698e3463")),
           ef_complex(e_float("7.8728839792900406832090794165313181768178619823745600432316471385554154568447481496468056811088703646686645867582078582945661104029031034711755430113423858769580036135358234322839603968999228231958328196174154143583413031554375362680623548293571171064639255158620122479810366479287128648833474808419047752126395848707892587304393138161147468438551098254115203857572242228285094043858988809766735008474e3540"), e_float("3.1228294330103821539854250395905290071854578732176107879269835383662576390822050890045917529847895730629366717404294344125694852346202164174868703517759521593154323657724566624653022549479213822757290450546200477920240487004754016668725539455965948110066515300397259074536703184018648301367427904155269663371124872319495443704060477309711686133627702053260216311122971279503552188683469576716714106448e3540")),
           ef_complex(e_float("-2.2539420560297461796973778197085584729763253203281926234722110955624609452287257470323155891428103218817297304873210744803700139263042136090282110965327237337594866232786633137515365609280657228354946798967868667854578308591693864454334067743919586058100278485248803976351514309125670793701029031186183896349288811908143139571352560533368058117598734914161928416772367278397467147101373504704564554509e3617"), e_float("-7.7041145552853761180307743670394051085690707838835518956058111929325511377513570446740294228344610354298889125448037134006606160785106552857627694271616588421702522290198384084636229117465605681010946619946619655807366841095618276142765295761859651747887350384759263016636589207735421930247142509463849771256165234107102009798180277135680039759961385680038505572774950215775597215992312395307821946077e3617")),
           ef_complex(e_float("-4.4446268012318776598663086190522612343434300120019846600137262320292027074326041773975230312015702847343629366738670341902699318129401825978633442955160249604583802308953790490862868898808084703086610926447788916301284055502853792098921997524568824755542039953341018419966950577027489194388039559492465398795753607426197631538966072577647338504546853666679082653840652362669722023509756492860917160963e3694"), e_float("6.1742389603046557366214553578379570873487749414299524642357228986587678124370610796954256900832538555054854460640315239272493569673969215663344113242136627777546253123270242788671990416184836579571636394945313794341224408626739973597834605252228289445849440340111377293790851125057081626336184175765634404499652230499974408915663629615942439906545978963207865410284849444102687677888475865202754630564e3694")),
           ef_complex(e_float("7.204817537496141112942261956682521836344280180245979565320277780679099691590173082780311040785826652058890836410907998802366969494208875526746522571758942465238632433093308325992438543341918187067884064773287299118220359643159624825560164623848179279020653870138769598486576709582257144482160761927381683621650961274959410468328535884665287609776569218132529478918868752515847706688957679184112634771e3771"), e_float("-2.761223327699051074097954312025609215545084192138537156244361770830798539380561800193307930955566073965987795691559339024176477117884170928367656526281750560475194808315906992554850994957934183028165167520223192957987747643514264482859293902452760565168390210095384111202161025273336581491905445959673436255548852513733319068153509847079715444830877360055586760517561898966200366873122825053501869055e3770")),
           ef_complex(e_float("-4.4050298175772164212746951786689288593079581049524718018870043191128328461784342266027581983461898080918590973242142675946881334107230006681794752696557736197532974691971327960710471610597531097308708903390281625276658659730281997833551062941516802387515517930281226805940780679408530752689945906599610836507276886156166791992238545899223216482703114643402280863460354190957890407497404819139463376387e3848"), e_float("-5.2240347070947943031126643603252844729425907589234862413701681137820904619384760639679883824346653818108888448058233762448526282777900696999803783023445690342329174896472476659114893829126686551112847476471136176626826053309394638339859994065460380939988173839858318779351909433321985205837363246407109675996110402684421904202893799049851642339945215993877435758672593696368744672602145185911067713856e3848")),
           ef_complex(e_float("-1.3374322216661528371375078012807759308005742525444612925297730306504855565298187080090095064629798221790318350320091824788994789391471348852668183729750559868461385425093030101468032893360875371282603294897900670620157885533464975145905224576672416893295316493277757204054232774149408462217418526952261348344779326205253608722076731282546007307678182706640875770694821167672734193216021958730314976193e3925"), e_float("6.3366993213987434167884723537202930842897347597781800002066328644667769394888890667289330771641618123546588729993610011131959443411911064612903109333277970507611560690501485798673612563137495652818777007127814720367491331194739161783908568848830894522623214687984505912158188331851121027198166079496716258497064317896282785307104425624439719835542087754213388515587979387064865870312055171248690151618e3925")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02103_z_exp(const bool b_write_output)
    {
      return TestCase_case_02103_z_exp().execute(b_write_output);
    }
  }
}
